/* GNOME DB Front End
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gda-fe.h>

static guint prepare_app (void);

GnomeUIInfo filemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Open Connection..."), N_("Open a connection to a data source"),
    fe_open_connection_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect"), N_("Close current connection"),
    fe_close_connection_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_STOP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Disconnect all"), N_("Close all connections"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PRINT_SETUP_ITEM(gda_ui_print_setup_dlg_cb, NULL),
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit application"),
    fe_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo databasemenu[] =
{
  { GNOME_APP_UI_ITEM, N_("SQL Window"), N_("SQL window"),
    fe_activate_connection_sql_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXEC, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Batch"), N_("Batch commands window"),
    fe_activate_connection_batch_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_TIMER, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Query Designer"), N_("Query designer"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_INDEX, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Browser"), N_("Browse database"),
    fe_activate_connection_browser_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PROP, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Export"), N_("Export database"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REDO, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Import"), N_("Import data into current database"),
    NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_UNDO, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Begin transaction"), N_("Begin transaction"),
    fe_begin_transaction_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Commit"), N_("Commit transaction"),
    fe_commit_transaction_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_SAVE, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Rollback"), N_("Discard all changes"),
    fe_rollback_transaction_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_REVERT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Connection Properties"), N_("View connection properties"),
    fe_view_connection_props_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Configure"), N_("Configure underlying database"),
    fe_open_connection_config_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo toolsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("View logs"), N_("View the different logs"),
    fe_open_log_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_MAIL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Database designer"), N_("Open the database designer"),
    fe_open_designer_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Service control"), N_("View service activity"),
    fe_open_service_manager_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Manager"), N_("The GNOME-DB configuration tool"),
    fe_run_app_cb, "gda-mgr", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("GNOME-DB Builder"), N_("The GNOME-DB Development Environment"),
    fe_run_app_cb, "gda-builder", NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo optionsmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("Preferences..."), N_("Configure user preferences"),
    fe_open_config_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Data sources..."), N_("Configure GDA data sources"),
    fe_open_dsnconfig_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Save options"), N_("Save current configuration"),
    fe_save_config_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo helpmenu[] =
{
  { GNOME_APP_UI_ITEM, N_("About gnome-db..."), N_("About this program"),
    fe_about_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_ABOUT, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Submit bug report"), N_("About this program"),
    gda_ui_submit_bug_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
    NULL, 0, 0, NULL },
  GNOMEUIINFO_END
};
GnomeUIInfo mainmenu[] =
{
  GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
  GNOMEUIINFO_SUBTREE(N_("Database"), databasemenu),
  GNOMEUIINFO_SUBTREE(N_("Tools"), toolsmenu),
  GNOMEUIINFO_SUBTREE(N_("Options"), optionsmenu),
  GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
  GNOMEUIINFO_END
};
static GnomeUIInfo toolbar[] =
{
  { GNOME_APP_UI_ITEM, N_("Connect"), N_("Open a connection to a data source"),
    fe_open_connection_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_CONVERT, 0, 0, NULL },
  { GNOME_APP_UI_ITEM, N_("Logs"), N_("View logs"),
    fe_open_log_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_MAIL, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Preferences"), N_("Configure user preferences"),
    fe_open_config_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_PREF, 0, 0, NULL },
  GNOMEUIINFO_SEPARATOR,
  { GNOME_APP_UI_ITEM, N_("Quit"), N_("Exit Application"),
    fe_quit_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
    GNOME_STOCK_MENU_EXIT, 0, 0, NULL },
  GNOMEUIINFO_END
};

/*
 * Global variables
 */
GtkWidget* glb_container = NULL;

gint
main (gint argc, gchar *argv[])
{
  CORBA_Environment ev;
  CORBA_ORB         orb;

  /* initialize the i18n stuff */
  bindtextdomain(PACKAGE, GNOMELOCALEDIR);
  textdomain(PACKAGE);

  /* initialize CORBA/bonobo */
  CORBA_exception_init(&ev);
  orb = gnome_CORBA_init("gda-fe", VERSION, &argc, argv, 0, &ev);
  CORBA_exception_free(&ev);

  if (bonobo_init(orb, NULL, NULL) == FALSE)
    g_error(_("Could not initialize Bonobo\n"));
  
  /*
   * We can't make any CORBA calls unless we're in the main
   * loop. So we delay creating the container here.
   */
  gtk_idle_add((GtkFunction) prepare_app, NULL);
  bonobo_main();

  return 0;
}

static guint
prepare_app (void)
{
  glb_container = gnome_db_container_new("gda-fe", mainmenu, toolbar, NULL);
  gtk_signal_connect(GTK_OBJECT(glb_container),
		     "close",
		     GTK_SIGNAL_FUNC(fe_quit_cb),
		     NULL);

  /* load configuration */
  fe_config_load();
  gda_ui_load_window_config("MainWindow", gnome_db_container_get_widget(glb_container));

  gnome_db_container_set_contents(glb_container, fe_workarea_create());
  gnome_db_container_show(glb_container);

  return FALSE;
}





