/* GNOME DB LDAP Config Component
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gda-ldap-config.h"

int
main (int argc, char *argv[])
{
  CORBA_Environment ev;
  GnomeDbControl*   control;

  /* initialize CORBA/bonobo */
#if USING_OAF
  gnome_init("gda-ldap-config", VERSION, argc, argv);
  oaf_init(argc, argv);

  if (!bonobo_init(oaf_orb_get(), NULL, NULL))
    g_error(_("Could not initialize Bonobo"));
#else
  CORBA_exception_init(&ev);
  gnome_CORBA_init("gda-ldap-config", VERSION,
                   &argc, argv,
                   GNORBA_INIT_SERVER_FUNC,
                   &ev);

  if (ev._major != CORBA_NO_EXCEPTION)
    g_error(_("Could not initialize CORBA"));

  if (!bonobo_init(gnome_CORBA_ORB(), NULL, NULL))
    g_error(_("Could not initialize Bonobo"));

  CORBA_exception_free(&ev);
#endif

  /* initialize widget factories */
  control = gnome_db_control_new("control-factory:gda-ldap-dsn", ldap_dsn_create_widget_cb);
  if (GNOME_DB_IS_CONTROL(control))
    {
      gtk_signal_connect(GTK_OBJECT(control),
			 "new_instance",
			 GTK_SIGNAL_FUNC(ldap_dsn_new_instance_cb),
			 NULL);
    }
  else g_error(_("Could not create DSN config component"));

  /* run main loop */
  bonobo_main();
  return 0;
}
