/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <ctpublic.h>
#include "gda-sybase-types.h"


Gda_SYBASE_Connection* 
gda_sybase_connection_open(gchar* dsn, gchar* user, gchar* passwd)
{
  CS_RETCODE     rc;
  CS_CONTEXT*    ctx;
  CS_CONNECTION* cnc;
  
  rc = cs_ctx_alloc(CS_VERSION_100, &ctx);
  if (rc != CS_SUCCEED)
    {
      g_error("Cannot allocate context\n");
    }
  rc = ct_init(ctx, CS_VERSION_100);
  if (rc != CS_SUCCEED)
    {
      g_error("Cannot init library\n");
    }
  rc = ct_con_alloc(ctx, &cnc);
  if (rc != CS_SUCCEED)
    {
      g_error("ct_con_calloc failed");
    }
  
  rc = ct_diag(cnc, CS_INIT, CS_UNUSED, CS_UNUSED, NULL);
  if (rc != CS_SUCCEED)
    {
      g_error("ct_diag: Cannot CS_init error handling\n");
    }
  rc = ct_con_props(cnc, CS_SET, CS_USERNAME, user,
		    CS_NULLTERM, NULL);
  if (rc != CS_SUCCEED)
    {
      g_error("ct_con_props: Cannot set username");
    }
  rc = ct_con_props(cnc, CS_SET, CS_PASSWORD,
		    passwd, CS_NULLTERM, NULL);
  if (rc != CS_SUCCEED)
    {
      g_error("ct_con_props: Cannot set username");
    }
  rc = ct_connect(cnc, dsn, CS_NULLTERM);
  if (rc != CS_SUCCEED)
    {
      gint num_of_errors;
      
      rc =ct_diag(cnc, CS_STATUS, CS_CLIENTMSG_TYPE, CS_UNUSED,
		  &num_of_errors);
      if (rc != CS_SUCCEED)
	{
	  g_error("Cannot get number of client error messages\n");
	}
      if (num_of_errors)
	{
	  gint idx;
	  CS_CLIENTMSG msg;
	  for (idx = 1; idx <= num_of_errors; idx++)
	    {
	      rc = ct_diag(cnc, CS_GET, CS_CLIENTMSG_TYPE, idx, &msg);
	      if (rc != CS_SUCCEED)
		{
		  g_error("Cannot get client message\n");
		}
	      g_print("severity: %d\n", msg.severity);
	      g_print("msgnum: %d\n", msg.msgnumber);
	      g_print("msgstring: '%s'\n", msg.msgstring);
	      g_print("osnumber: %d\n", msg.osnumber);
	      g_print("osstring: '%s'\n", msg.osstring);
	      g_print("status: %d\n", msg.status);
	      g_print("sqlstate: '%s'\n", msg.sqlstate);
	    }
	}
      rc = ct_diag(cnc, CS_STATUS, CS_SERVERMSG_TYPE, CS_UNUSED,
		   &num_of_errors);
      if (rc != CS_SUCCEED)
	{
	  g_error("Cannot get number of server error messages\n");
	}
      if (num_of_errors)
	{
	  gint idx;
	  CS_SERVERMSG msg;
	  for (idx = 1; idx <= num_of_errors; idx++)
	    {
	      rc = ct_diag(cnc, CS_GET, CS_SERVERMSG_TYPE, idx, &msg);
	      if (rc != CS_SUCCEED)
		{
		  g_error("Cannot get server messages\n");
		}
	      g_print("msgnum: %d\n", msg.msgnumber);
	      g_print("state: %d\n", msg.state);
	      g_print("severuty: %d\n", msg.severity);
	      g_print("text: '%s'\n", msg.text);
	      g_print("svrname: '%s'\n", msg.svrname);
	      g_print("proc: '%s'\n", msg.proc);
	      g_print("line: %d\n", msg.line);
	      g_print("status: %d\n", msg.status);
	      g_print("sqlstate: '%s'\n", msg.sqlstate);
	    }
	}
    }
  return 0;
}
