#include "login.h"

/* FUNCTION: close_dialog()
 *
 * Event handler invoked when the user clicks the cancel
 * button or after a successful connection is made.
 */
gint close_dialog(GtkObject* dialog) {

  /* Close the dialog */
  gnome_dialog_close(GNOME_DIALOG(dialog)); 

  dialog = NULL;    /* destroy the dialog */
  
  gtk_main_quit();  /* terminate the main loop */
}

/* FUNCTION: on_logindlg_delete_event()
 *
 * Event handler invoked when the user clicks the close 
 * button on the dialog window.
 */
gint on_logindlg_delete_event(GtkWidget*   w,
                              GdkEventAny* e,
                              gpointer data)
{
  gtk_main_quit(); /* Quit the main loop */
  return FALSE;    /* Delete event must return FALSE */
}

/* FUNCTION: login_db()
 *
 * Display a login dialog and return true if the
 * connection succeeded.
 */
gboolean login_db(Gda_Connection* cnc) {

  GtkWidget* login;    /* A login widget */
  GtkWidget* logindlg; /* A login dialog widget */

  /* Create a login widget */
  login    = gnome_db_login_new(cnc, NULL, NULL);

  /* Create a login dialog that uses that widget */
  logindlg = gnome_db_logindlg_new(GNOME_DB_LOGIN(login), 
                                   "Please Log In");

  /* Connect the dialog window's delete_event to the
   * on_logindlg_delete_event() handler.
   */
  gtk_signal_connect(GTK_OBJECT(logindlg),
                     "delete_event", 
                     GTK_SIGNAL_FUNC(on_logindlg_delete_event), 
                     NULL);

  /*
   * Connect the connection's open event to the close_dialog()
   * handler.
   */
  gtk_signal_connect_object_after(GTK_OBJECT(cnc),
                                  "open",
                                  GTK_SIGNAL_FUNC(close_dialog),
                                  GTK_OBJECT(logindlg));

  /* Connect the cancel button to the close_dialog() handler()
   */
  gtk_signal_connect(GTK_OBJECT(logindlg),
                     "cancel",
                     GTK_SIGNAL_FUNC(close_dialog),
                     NULL);

  /* Hide the dialog when it is closed */
  gnome_dialog_close_hides(GNOME_DIALOG(logindlg), TRUE);

  /* Display the dialog */ 
  gnome_db_logindlg_popup(GNOME_DB_LOGINDLG(logindlg));

  /* Start a GTK loop */
  gtk_main();

  /* Return true if the connection is open */
  return gda_connection_is_open(cnc);

}
