#include "error.h"

/* 
 * When an error occurs, display a dialog with 
 * the list of errors.
 */
void on_error(GtkObject* cnc) {

  GtkWidget *error_dialog;

  /* Create an error dialog */
  error_dialog = gnome_db_errordlg_new(GDA_CONNECTION(cnc), 
                                       "Database Error");

  /* Display the dialog */
  gtk_window_set_modal(GTK_WINDOW(error_dialog), TRUE);
  gnome_db_errordlg_show_errors(GNOME_DB_ERRORDLG(error_dialog)); 

}

/* 
 * Connect the on_error routine to the connection's error signal.
 */
void register_error_handler(Gda_Connection* cnc) {

  /* If we have a connection error, invoke the 
   * error handler.
   */
  gtk_signal_connect(GTK_OBJECT(cnc),
                     "error", 
                     GTK_SIGNAL_FUNC(on_error), 
                     NULL);
}
