/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

/*
 * Callbacks
 */
static void
edit_entry_cb (GtkButton *button, FE_ConnectionInfo *cnc_info)
{
  GList* selection;
  
  g_return_if_fail(cnc_info != NULL);
  g_return_if_fail(GTK_IS_CLIST(cnc_info->batch_cmd_list));
  
  selection = GTK_CLIST(cnc_info->batch_cmd_list)->selection;
  if (selection)
    {
      GtkWidget* dialog;
      GtkWidget* frame;
      GtkWidget* scroll;
      GtkWidget* text;
      gint       row = GPOINTER_TO_INT(selection->data);
      
      dialog = gnome_dialog_new(_("Edit command"),
                                GNOME_STOCK_BUTTON_OK,
                                GNOME_STOCK_BUTTON_CANCEL,
                                NULL);
      frame = gnome_db_new_frame_widget(NULL);
      gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), frame, 1, 1, 0);
      scroll = gnome_db_new_scrolled_window_widget();
      gtk_container_add(GTK_CONTAINER(frame), scroll);
      
      if (!gnome_dialog_run(GNOME_DIALOG(dialog)))
        {
        }
      gnome_dialog_close(GNOME_DIALOG(dialog));
    }
}

static void
file_entry_changed_cb (GtkEditable *editable, FE_ConnectionInfo *cnc_info)
{
  gchar* filename;
  
  g_return_if_fail(GTK_IS_EDITABLE(editable));
  g_return_if_fail(cnc_info != NULL);
  
  filename = gnome_file_entry_get_full_path(GNOME_FILE_ENTRY(cnc_info->batch_file_entry), TRUE);
  if (filename)
    {
      FILE* fp;
      
      gnome_db_clear_clist(GTK_CLIST(cnc_info->batch_cmd_list));
      gnome_db_container_set_status(GNOME_DB_CONTAINER(glb_mainwin),
                                    _("Loading file %s"), filename);

      /* load file */
      fp = fopen(filename, "r");
      if (fp)
        {
          gchar    buffer[4097];
          gchar**  arr;
          GString* str;
          gint     cnt = 0;
          
          str = g_string_new("");
          while (!feof(fp))
            {
              memset(buffer, 0, sizeof(buffer));
              fread(buffer, sizeof(buffer) - 1, 1, fp);
              if (ferror(fp))
                {
                  gnome_db_show_error(_("Error loading file %s"), filename);
                  break;
                }
              g_string_append(str, buffer);
            }

          /* close file and show list of commands */
          fclose(fp);
          
          gtk_clist_freeze(GTK_CLIST(cnc_info->batch_cmd_list));
          arr = g_strsplit(str->str, ";", 0);
          while (arr[cnt])
            {
              gchar* row[2] = { "", "" };
              row[1] = g_strstrip(arr[cnt]);
              gtk_clist_append(GTK_CLIST(cnc_info->batch_cmd_list), row);
              cnt++;
            }
          g_strfreev(arr);
          g_string_free(str, TRUE);
          gtk_clist_thaw(GTK_CLIST(cnc_info->batch_cmd_list));
        }
      else gnome_db_show_error(_("Could not open file %s"), filename);
      g_free((gpointer) filename);
    }
}

/*
 * Public functions
 */
void
fe_connection_activate_batch (FE_ConnectionInfo *cnc_info)
{
  g_return_if_fail(cnc_info != NULL);
  
  if (!cnc_info->batch_tab)
    {
      GtkWidget* label;
      GtkWidget* frame;
      GtkWidget* table;
      GtkWidget* scroll;
      GtkWidget* button;
      
      cnc_info->batch_tab = gnome_db_new_table_widget(4, 2, FALSE);
      
      /* create main pane */
      label = gnome_db_new_label_widget(_("File name"));
      gtk_table_attach(GTK_TABLE(cnc_info->batch_tab), label, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
      cnc_info->batch_file_entry = gnome_db_new_file_entry_widget("FE_Batch_FileName");
      gtk_signal_connect(GTK_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(cnc_info->batch_file_entry))),
                         "changed",
                         GTK_SIGNAL_FUNC(file_entry_changed_cb),
                         (gpointer) cnc_info);
      gtk_table_attach(GTK_TABLE(cnc_info->batch_tab), cnc_info->batch_file_entry, 1, 2, 0, 1,
                       GTK_FILL, GTK_FILL, 3, 3);
                       
      cnc_info->batch_transaction =
          gnome_db_new_check_button_widget(_("Transaction mode"),
                                           gda_connection_supports(cnc_info->cnc,
                                                                   GDA_Connection_FEATURE_TRANSACTIONS));
      gtk_table_attach(GTK_TABLE(cnc_info->batch_tab), cnc_info->batch_transaction,
                       2, 3, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
      
      /* add SQL batch stuff */
      frame = gnome_db_new_frame_widget(NULL);
      gtk_table_attach(GTK_TABLE(cnc_info->batch_tab), frame, 0, 4, 1, 2,
                       GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                       GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                       3, 3);
      table = gnome_db_new_table_widget(4, 8, FALSE);
      gtk_container_add(GTK_CONTAINER(frame), table);
      
      scroll = gnome_db_new_scrolled_window_widget();
      gtk_table_attach(GTK_TABLE(table), scroll, 0, 3, 0, 8,
                       GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                       GTK_FILL | GTK_EXPAND | GTK_SHRINK,
                       3, 3);
      cnc_info->batch_cmd_list = gnome_db_new_clist_widget(NULL, 2);
      gtk_container_add(GTK_CONTAINER(scroll), cnc_info->batch_cmd_list);

      /* add buttons */
      button = gnome_db_new_button_widget_with_pixmap(_("Up"), GNOME_STOCK_MENU_UP);
      gtk_table_attach(GTK_TABLE(table), button, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
      button = gnome_db_new_button_widget_with_pixmap(_("Down"), GNOME_STOCK_MENU_DOWN);
      gtk_table_attach(GTK_TABLE(table), button, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 3, 3);
      button = gnome_db_new_button_widget_with_pixmap(_("Delete"), GNOME_STOCK_MENU_TRASH);
      gtk_table_attach(GTK_TABLE(table), button, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 3, 3);
      button = gnome_db_new_button_widget_with_pixmap(_("Edit"), GNOME_STOCK_MENU_PROP);
      gtk_signal_connect(GTK_OBJECT(button),
                         "clicked",
                         GTK_SIGNAL_FUNC(edit_entry_cb),
                         (gpointer) cnc_info);
      gtk_table_attach(GTK_TABLE(table), button, 3, 4, 3, 4, GTK_FILL, GTK_FILL, 3, 3);
      
      gtk_notebook_append_page(GTK_NOTEBOOK(cnc_info->container),
                               cnc_info->batch_tab,
                               gtk_label_new(_("Batch")));
    }
  gtk_notebook_set_page(GTK_NOTEBOOK(cnc_info->container),
                        gtk_notebook_page_num(GTK_NOTEBOOK(cnc_info->container), cnc_info->batch_tab));
}
