/*  GNOME-DB Front End
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if !defined(__gnomedb_fe_h__)
#  define __gnomedb_fe_h__

#include <gnome.h>
#include <gnome-db.h>
#include <bonobo.h>
#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif

BEGIN_GNOME_DECLS

#define GNOMEDB_FE_CONFIG_SECTION_LAST_COMMANDS "/gnomedb-fe/LastCommands"
/*
 * Callbacks
 */
extern void fe_about_cb                       (GtkWidget *w, gpointer data);
extern void fe_activate_connection_batch_cb   (GtkWidget *w, gpointer data);
extern void fe_activate_connection_browser_cb (GtkWidget *w, gpointer data);
extern void fe_activate_connection_sql_cb     (GtkWidget *w, gpointer data);
extern void fe_begin_transaction_cb           (GtkWidget *w, gpointer data);
extern void fe_close_all_connections_cb       (GtkWidget *w, gpointer data);
extern void fe_close_connection_cb            (GtkWidget *w, gpointer data);
extern void fe_commit_transaction_cb          (GtkWidget *w, gpointer data);
extern void fe_open_config_cb                 (GtkWidget *w, gpointer data);
extern void fe_open_connection_cb             (GtkWidget *w, gpointer data);
extern void fe_open_connection_config_cb      (GtkWidget *w, gpointer data);
extern void fe_open_designer_cb               (GtkWidget *w, gpointer data);
extern void fe_open_dsnconfig_cb              (GtkWidget *w, gpointer data);
extern void fe_open_log_cb                    (GtkWidget *w, gpointer data);
extern void fe_open_service_manager_cb        (GtkWidget *w, gpointer data);
extern void fe_quit_cb                        (GtkWidget *w, gpointer data);
extern void fe_rollback_transaction_cb        (GtkWidget *w, gpointer data);
extern void fe_run_app_cb                     (GtkWidget *w, const gchar *cmd);
extern void fe_save_config_cb                 (GtkWidget *w, gpointer data);
extern void fe_view_connection_props_cb       (GtkWidget *w, gpointer data);

/*
 * Configuration
 */
extern void   fe_config_add_sql_command   (const gchar *sql);
extern GList* fe_config_get_last_commands (void);
extern void   fe_config_load              (void);
extern void   fe_config_open_dsn          (void);
extern void   fe_config_save              (void);

/*
 * Connection management
 */
typedef struct
{
  Gda_Connection* cnc;
  GtkWidget*      container;
  gchar*          dsn_name;
  
  /* SQL tab */
  GtkWidget*      sql_tab;
  GtkWidget*      sql_area;
  GtkWidget*      sql_grid;
  
  /* Batch tab */
  GtkWidget*      batch_tab;
  GtkWidget*      batch_file_entry;
  GtkWidget*      batch_cmd_list;
  GtkWidget*      batch_transaction;
  
  /* Browser tab */
  GtkWidget*      browser_tab;
} FE_ConnectionInfo;

extern void               fe_connection_activate_batch       (FE_ConnectionInfo *cnc_info);
extern void               fe_connection_activate_browser     (FE_ConnectionInfo *cnc_info);
extern void               fe_connection_activate_sql         (FE_ConnectionInfo *cnc_info);
extern void               fe_connection_begin_transaction    (FE_ConnectionInfo *cnc_info);
extern void               fe_connection_close                (FE_ConnectionInfo *cnc_info);
extern void               fe_connection_commit_transaction   (FE_ConnectionInfo *cnc_info);
extern FE_ConnectionInfo* fe_connection_get_current          (void);
extern GList*             fe_connection_get_list             (void);
extern FE_ConnectionInfo* fe_connection_open                 (const gchar *dsn_name, Gda_Connection *cnc);
extern void               fe_connection_rollback_transaction (FE_ConnectionInfo *cnc_info);
extern void               fe_connection_show_errors          (Gda_Connection *cnc);

/*
 * Designer
 */
typedef struct
{
  GtkWidget* container;
  GtkWidget* designer;
  gchar*     filename;
} FE_DesignerInfo;

extern FE_DesignerInfo* fe_designer_open (void);

/*
 * Log window
 */
typedef struct
{
  GtkWidget* container;
  GtkWidget* chooser;
  GtkWidget* notebook;
  GtkWidget* viewer;
} FE_LogViewerInfo;

extern FE_LogViewerInfo* fe_log_open (void);

/*
 * Service manager
 */
typedef struct
{
  GtkWidget* container;
  GtkWidget* service_list;
  GtkWidget* iid_list;
} FE_ServiceManagerInfo;

extern FE_ServiceManagerInfo* fe_service_manager_open (void);

/*
 * Work area management
 */
GtkWidget* fe_workarea_create          (void);
void       fe_workarea_add_tab         (const gchar *title,
                                        GtkWidget *w,
                                        GnomeUIInfo toolbox[]);
void       fe_workarea_remove_tab      (GtkWidget *widget);
void       fe_workarea_activate_tab    (GtkWidget *widget);
GtkWidget* fe_workarea_get_current_tab (void);

/*
 * Global variables
 */
extern GtkWidget*  glb_mainwin;
extern GnomeUIInfo glb_connection_toolbox[];
extern GnomeUIInfo glb_designer_toolbox[];
extern GnomeUIInfo glb_log_toolbox[];
extern GnomeUIInfo glb_servicemgr_toolbox[];

END_GNOME_DECLS

#endif