/* GNOME DB Front End
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gnomedb-fe.h"
#if defined(HAVE_GAL)
#  include <gal/e-paned/e-hpaned.h>
#endif

static GtkWidget* workarea = NULL;
static GtkWidget* workarea_shortcut = NULL;
static GtkWidget* workarea_notebook = NULL;

/*
 * Private functions
 */
static void
notebook_page_changed_cb (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer data)
{
  GtkWidget* w;

  g_return_if_fail(GTK_IS_NOTEBOOK(notebook));

  w = gtk_notebook_get_nth_page(notebook, page_num);
  if (GTK_IS_WIDGET(w)) gnome_db_control_widget_activate(GNOME_DB_CONTROL_WIDGET(w));
}

/*
 * Public functions
 */
GtkWidget *
fe_workarea_create (void)
{
  gchar* str;

  if (!GTK_IS_WIDGET(workarea))
    {
      GtkWidget* dock_item;
      GList*     components;
      
#if defined(HAVE_GAL)
      workarea = e_hpaned_new();
#else
      workarea = gnome_dock_new();
#endif
      
      /* add shortcut bar */
      workarea_shortcut = gnome_db_shortcut_new();
#if defined(HAVE_GAL)
      e_paned_add1(E_PANED(workarea), workarea_shortcut);
#else
      dock_item = gnome_dock_item_new("workarea_shortcut_bar",
                                      GNOME_DOCK_ITEM_BEH_NORMAL | GNOME_DOCK_ITEM_BEH_NEVER_HORIZONTAL);
      gtk_container_add(GTK_CONTAINER(dock_item), workarea_shortcut);
      gnome_dock_add_item(GNOME_DOCK(workarea), dock_item, GNOME_DOCK_LEFT, 0, 0, 0, FALSE);
#endif
      
      /* add buttons for all found components */
      components = gnome_db_config_get_shell_components();
      if (components)
        {
          GList*                  node;
          GnomeDbConfigComponent* com;
          
          for (node = g_list_first(components); node != NULL; node = g_list_next(node))
            {
              com = (GnomeDbConfigComponent *) node->data;
              str = g_strdup_printf("%s/%s",
                                    GNOMEDB_FE_CONFIG_SECTION_LOAD,
                                    gnome_db_config_component_get_name(com));
              if (gda_config_has_key(str))
                {
                  gnome_db_shortcut_append(GNOME_DB_SHORTCUT(workarea_shortcut),
                                           gnome_db_config_component_get_description(com),
                                           gnome_db_config_component_get_name(com),
                                           gnome_db_config_component_get_icon(com),
                                           GTK_SIGNAL_FUNC(fe_activate_component_cb),
                                           g_strdup(gnome_db_config_component_get_name(com)));
                }
              g_free((gpointer) str);
            }
          gnome_db_config_component_free_list(components);
        }

      /* add notebook */
      workarea_notebook = gnome_db_new_notebook_widget();
      gtk_notebook_set_show_border(GTK_NOTEBOOK(workarea_notebook), FALSE);
      gtk_notebook_set_show_tabs(GTK_NOTEBOOK(workarea_notebook), FALSE);
      gtk_notebook_popup_disable(GTK_NOTEBOOK(workarea_notebook));
#if defined(HAVE_GAL)
      e_paned_add2(E_PANED(workarea), workarea_notebook);
#else
      dock_item = gnome_dock_item_new("workarea_notebook", GNOME_DOCK_ITEM_BEH_NORMAL);
      gtk_container_add(GTK_CONTAINER(dock_item), workarea_notebook);
      gnome_dock_add_item(GNOME_DOCK(workarea), dock_item, GNOME_DOCK_LEFT, 0, 0, 0, FALSE);
#endif
    }

  /* create the tab for the manager */
  if (gda_config_has_key(GNOMEDB_FE_CONFIG_SECTION_LOAD "/" GNOME_DB_OAFIID_CONNECTION))
    fe_activate_component_cb(NULL, GNOME_DB_OAFIID_CONNECTION);
  gtk_widget_show_all(workarea);

  return workarea;
}

void
fe_workarea_add_tab (GtkWidget *tab, const gchar *label)
{
  g_return_if_fail(GTK_IS_WIDGET(tab));
  
  gtk_notebook_append_page(GTK_NOTEBOOK(workarea_notebook), tab, gtk_label_new(label));
  //fe_workarea_activate_tab(tab);
}

void
fe_workarea_activate_tab (GtkWidget *tab)
{
  GtkWidget* w;
  gint       current;
  
  g_return_if_fail(GTK_IS_WIDGET(tab));
  
  current = gtk_notebook_get_current_page(GTK_NOTEBOOK(workarea_notebook));
  /* first, deactivate current component */
  w = gtk_notebook_get_nth_page(GTK_NOTEBOOK(workarea_notebook), current);
  if (GTK_IS_WIDGET(w))
    {
      if (w == tab) return;
      bonobo_window_freeze(BONOBO_WINDOW(glb_mainwin));
      gnome_db_control_widget_deactivate(GNOME_DB_CONTROL_WIDGET(w));
      bonobo_window_thaw(BONOBO_WINDOW(glb_mainwin));
    }
  
  /* activate the new one */
  gtk_notebook_set_page(GTK_NOTEBOOK(workarea_notebook),
                        gtk_notebook_page_num(GTK_NOTEBOOK(workarea_notebook), tab));
  bonobo_window_freeze(BONOBO_WINDOW(glb_mainwin));
  gnome_db_control_widget_activate(GNOME_DB_CONTROL_WIDGET(tab));
  bonobo_window_thaw(BONOBO_WINDOW(glb_mainwin));
}

GtkWidget *
fe_workarea_get_current_tab (void)
{
  gint tab;
  
  g_return_val_if_fail(GTK_IS_NOTEBOOK(workarea_notebook), NULL);
  
  tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(workarea_notebook));
  return gtk_notebook_get_nth_page(GTK_NOTEBOOK(workarea_notebook), tab);
}

