/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if defined(HAVE_CONFIG_H)
#  include <config.h>
#endif
#include <gnome-db-control-corba.h>

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_GNOME_DB_Control_base_epv =
{
  NULL,			/* _private data */
  NULL,			/* finalize routine */
  NULL,			/* default_POA routine */
};
static POA_GNOME_DB_Control__epv impl_GNOME_DB_Control_epv =
{
  NULL,			/* _private */
  (gpointer) & impl_GNOME_DB_Control_getVersion,
  (gpointer) & impl_GNOME_DB_Control_getAuthors,
  (gpointer) & impl_GNOME_DB_Control_run,
  (gpointer) & impl_GNOME_DB_Control_doPrint,
};

/*** vepv structures ***/

static POA_GNOME_DB_Control__vepv impl_GNOME_DB_Control_vepv =
{
  &impl_GNOME_DB_Control_base_epv,
  NULL,
  &impl_GNOME_DB_Control_epv,
};

/*** Stub implementations ***/

GNOME_DB_Control
impl_GNOME_DB_Control__create(GnomeDbControlInstance *control_instance, CORBA_Environment * ev)
{
  GNOME_DB_Control retval;
  impl_POA_GNOME_DB_Control *newservant;
  PortableServer_ObjectId *objid;

  impl_GNOME_DB_Control_vepv.Bonobo_Unknown_epv = bonobo_object_get_epv();
  
  newservant = g_new0(impl_POA_GNOME_DB_Control, 1);
  newservant->servant.vepv = &impl_GNOME_DB_Control_vepv;
  newservant->poa = bonobo_poa();
  POA_GNOME_DB_Control__init((PortableServer_Servant) newservant, ev);
  
  newservant->control_instance = control_instance;
  
  retval = bonobo_object_activate_servant(BONOBO_OBJECT(control_instance),
                                          newservant);
  return retval;
}

void
impl_GNOME_DB_Control__destroy (impl_POA_GNOME_DB_Control *servant,
                                     CORBA_Environment * ev)
{
  PortableServer_ObjectId *objid;

  objid = PortableServer_POA_servant_to_id(servant->poa, servant, ev);
  PortableServer_POA_deactivate_object(servant->poa, objid, ev);
  CORBA_free(objid);

  POA_GNOME_DB_Control__fini((PortableServer_Servant) servant, ev);
  g_free(servant);
}

CORBA_char *
impl_GNOME_DB_Control_getVersion (impl_POA_GNOME_DB_Control * servant,
                                       CORBA_Environment * ev)
{
  return CORBA_string_dup(VERSION); 
}

CORBA_char *
impl_GNOME_DB_Control_getAuthors (impl_POA_GNOME_DB_Control *servant,
                                       CORBA_Environment *ev)
{
}

void
impl_GNOME_DB_Control_run (impl_POA_GNOME_DB_Control *servant,
                                CORBA_Environment *ev)
{
}

void
impl_GNOME_DB_Control_doPrint (impl_POA_GNOME_DB_Control *servant,
                                    CORBA_Environment *ev)
{
  g_return_if_fail(servant != NULL);
  gtk_signal_emit_by_name(GTK_OBJECT(servant->control_instance), "do_print");
}

void
impl_GNOME_DB_Control_doCutClipboard (impl_POA_GNOME_DB_Control *servant,
                                           CORBA_Environment *ev)
{
  g_return_if_fail(servant != NULL);
  gtk_signal_emit_by_name(GTK_OBJECT(servant->control_instance), "do_cut_clipboard");
}

void
impl_GNOME_DB_Control_copyClipboard (impl_POA_GNOME_DB_Control *servant,
                                          CORBA_Environment *ev)
{
  g_return_if_fail(servant != NULL);
  gtk_signal_emit_by_name(GTK_OBJECT(servant->control_instance), "do_copy_clipboard");
}

void
impl_GNOME_DB_Control_pasteClipboard (impl_POA_GNOME_DB_Control *servant,
                                           CORBA_Environment *ev)
{
  g_return_if_fail(servant != NULL);
  gtk_signal_emit_by_name(GTK_OBJECT(servant->control_instance), "do_paste_clipboard");
}
