/* GNOME-DB Front End
 * Copyrigth (C) 2000 Rodrigo Moya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gnomedb-fe.h>

static GList* activated_components = NULL;

void
fe_about_cb (GtkWidget *w, gpointer user_data)
{
  gnome_db_show_about_dialog("GNOME-DB Front End");
}

void
fe_activate_component_cb (GtkWidget *w, gpointer user_data)
{
  GnomeDbControlWidget* wid = NULL;
  GList*                node;
  
  /* see if the component is already loaded */
  for (node = g_list_first(activated_components); node != NULL; node = g_list_next(node))
    {
      wid = GNOME_DB_CONTROL_WIDGET(node->data);
      if (wid)
        {
          if (!g_strcasecmp(gnome_db_control_widget_get_repo_id(wid), (const gchar *) user_data))
            {
              fe_workarea_activate_tab(GTK_WIDGET(wid));
              return;
            }
        }
    }
    
  wid = gnome_db_control_widget_new((gchar *) user_data,
                                    gnome_db_window_get_ui_container(GNOME_DB_WINDOW(glb_mainwin)));
  if (GNOME_DB_IS_CONTROL_WIDGET(wid))
    {
      fe_workarea_add_tab(GTK_WIDGET(wid), wid->goad_id);
      activated_components = g_list_append(activated_components, (gpointer) wid);
    }
  gtk_widget_show(GTK_WIDGET(wid));
  fe_workarea_activate_tab(wid);
}

void
fe_do_print_cb (GtkWidget *w, gpointer user_data)
{
  GtkWidget* tab = fe_workarea_get_current_tab();
  if (GNOME_DB_IS_CONTROL_WIDGET(tab))
    {
      gnome_db_control_widget_do_print(GNOME_DB_CONTROL_WIDGET(tab));
    }
}

void
fe_preferences_cb (GtkWidget *w, gpointer user_data)
{
  fe_config_open_dialog();
}

void
fe_quit_cb (GtkWidget *w, gpointer user_data)
{
  fe_config_save();
  gnome_db_main_quit();
}


