/*  GNOME-DB Builder
 *  Copyrigth (C) 2000-2001 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gnomedb-builder.h>

static void new_perl_script_cb (GtkWidget *w, GnomeDbControl *control);

static GnomeUIInfo filenewmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Perl script..."), N_("Create a new Perl script"),
	  new_perl_script_cb, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Report..."), N_("Create new report"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo fileopenmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Perl script..."), N_("Open an existing Perl script"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Report..."), N_("Open an existing report"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo filemenu[] = {
	GNOMEUIINFO_SUBTREE_STOCK(N_("_New"), filenewmenu, GNOME_STOCK_MENU_NEW),
	GNOMEUIINFO_SUBTREE_STOCK(N_("_Open"), fileopenmenu, GNOME_STOCK_MENU_OPEN),
	GNOMEUIINFO_END
};
static GnomeUIInfo mainmenu[] = {
	GNOMEUIINFO_SUBTREE(N_("_File"), filemenu),
	GNOMEUIINFO_END
};
static GnomeUIInfo toolbar[] = {
	{ GNOME_APP_UI_ITEM, N_("New"), N_("Add new module to project"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Open"), N_("Open an existing module"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
	GNOMEUIINFO_END
};

/*
 * Callbacks
 */
static void
new_perl_script_cb (GtkWidget *w, GnomeDbControl *control)
{
	BUILDER_ControlData *control_data;

	g_return_if_fail(GNOME_DB_IS_CONTROL(control));

	control_data = gnome_db_control_get_user_data(control);
	if (control_data) {
	}
}

/*
 * Public functions
 */
BonoboObject *
builder_control_new (void)
{
	GtkWidget*           w;
	GtkWidget*           notebook;
	GnomeDbControl*      control;
	BUILDER_ControlData* control_data;
	
	/* create builder main widget */
        w = gnome_db_new_table_widget(4, 2, FALSE);
	notebook = gnome_db_new_notebook_widget();
	gtk_table_attach(GTK_TABLE(w), notebook, 1, 4, 1, 2,
			 GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			 GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			 3, 3);
	gtk_widget_show(w);
	
	/* create control instance */
	control = gnome_db_control_new(w);
	if (GNOME_DB_IS_CONTROL(control)) {
		/* create custom structure */
		control_data = g_new0(BUILDER_ControlData, 1);
		control_data->notebook = notebook;
		gnome_db_control_set_user_data(control, (gpointer) control_data);

		/* set menus/toolbar */
		gnome_db_control_set_menubar(control, mainmenu);
		gnome_db_control_set_toolbar(control, toolbar);
	}
	
	return BONOBO_OBJECT(control);
}
