/*  GNOME-DB Components
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gnomedb-com.h>

#define COMPONENTS_LOG_INFO "COMPONENTS_LogInfo"

typedef struct {
	GtkWidget* file_sel;
	GtkWidget* viewer;
} COMPONENTS_LogInfo;

static void select_provider_cb (GtkMenuItem *item, gpointer data);

static void save_log_file (GtkWidget *w, GnomeDbControl *control);
static void view_selected_entry_cb (GtkWidget *w, GnomeDbControl *control);

static GnomeUIInfo log_control_toolbar[] = {
	{ GNOME_APP_UI_ITEM, N_("Save"), N_("Save log to a disk file"),
	  save_log_file, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("View"), N_("View selected log entry"),
	  view_selected_entry_cb, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_BOOK_RED, 0, 0, NULL },
	GNOMEUIINFO_END
};

/*
 * Private functions
 */

static void
fill_provider_list (GtkOptionMenu *option_menu, GnomeDbLogViewer *log_viewer)
{
	GList*     servlist;
	GList*     node;
	GtkWidget* menu;
	
	g_return_if_fail(GTK_IS_OPTION_MENU(option_menu));
	g_return_if_fail(GNOME_DB_IS_LOG_VIEWER(log_viewer));
	
	menu = gtk_menu_new();
	servlist = node = gda_provider_list();
	while (node) {
		gchar*     str = g_strdup((GDA_PROVIDER_NAME((GdaProvider *) node->data)));
		GtkWidget* item = gtk_menu_item_new_with_label(str);
		gtk_object_set_data(GTK_OBJECT(item), "COMPONENTS_LogViewer_Widget", (gpointer) log_viewer);
		gtk_signal_connect(GTK_OBJECT(item),
		                   "activate",
		                   GTK_SIGNAL_FUNC(select_provider_cb),
		                   str);
		//mem_to_free = g_list_append(mem_to_free, (gpointer) str);
		gtk_widget_show(item);
		gtk_menu_append(GTK_MENU(menu), item);
		node = g_list_next(node);
	}
	gda_provider_free_list(servlist);
	gtk_widget_show(menu);
	gtk_option_menu_set_menu(option_menu, menu);
}

/*
 * Callbacks
 */

static void
select_provider_cb (GtkMenuItem *item, gpointer data)
{
	gchar*     str = (gchar *) data;
	GtkWidget* log_viewer;
	
	g_return_if_fail(GTK_IS_MENU_ITEM(item));
	
	log_viewer = gtk_object_get_data(GTK_OBJECT(item), "COMPONENTS_LogViewer_Widget");
	if (str && GNOME_DB_IS_LOG_VIEWER(log_viewer)) {
		if (!gnome_db_log_viewer_load_file(GNOME_DB_LOG_VIEWER(log_viewer), str))
			gnome_db_show_error(_("Error loading log for '%s'"), str);
	}
}

static void
save_log_file (GtkWidget *w, GnomeDbControl *control)
{
	COMPONENTS_LogInfo* log_info;
	
	g_return_if_fail(GNOME_DB_IS_CONTROL(control));
	
	log_info = (COMPONENTS_LogInfo *) gnome_db_control_get_user_data(control);
	if (log_info) {
		gchar* filename;
		
		filename = gnome_db_select_file(_("Save Log File"));
		if (filename) {
			gnome_db_log_viewer_save(GNOME_DB_LOG_VIEWER(log_info->viewer), filename);
			g_free((gpointer) filename);
		}
	}
}

static void
view_selected_entry_cb (GtkWidget *w, GnomeDbControl *control)
{
	COMPONENTS_LogInfo* log_info;
	
	g_return_if_fail(GNOME_DB_IS_CONTROL(control));
	
	log_info = (COMPONENTS_LogInfo *) gnome_db_control_get_user_data(control);
	if (log_info)
		gnome_db_log_viewer_show_current(GNOME_DB_LOG_VIEWER(log_info->viewer));
}

/*
 * Public functions
 */
BonoboObject *
components_log_new (void)
{
	GtkWidget*          logw;
	COMPONENTS_LogInfo* log_info;
	GnomeDbControl*     control;

	logw = gnome_db_new_table_widget(4, 6, FALSE);
	log_info = g_new0(COMPONENTS_LogInfo, 1);
	
	log_info->file_sel = gnome_db_new_option_menu_widget();
	gnome_db_set_widget_tooltip(log_info->file_sel,
				    _("Use this option menu to select the provider whose "
				      "log messages you want to see"));
	gtk_table_attach(GTK_TABLE(logw), log_info->file_sel, 0, 4, 0, 1, GTK_FILL, GTK_FILL, 3, 3);
	
	log_info->viewer = gnome_db_log_viewer_new();
	gnome_db_set_widget_tooltip(log_info->viewer,
				    _("This is a list of all log messages for the provider "
				      "you've selected. You can easily sort messages by "
				      "any of the columns (but just clicking on them) as "
				      "well as look at the messages individually, with more "
				      "detail"));
	gtk_widget_show(log_info->viewer);
	fill_provider_list(GTK_OPTION_MENU(log_info->file_sel),
	                   GNOME_DB_LOG_VIEWER(log_info->viewer));
	gtk_table_attach(GTK_TABLE(logw), log_info->viewer, 0, 4, 1, 6,
	                 GTK_FILL | GTK_SHRINK | GTK_EXPAND,
	                 GTK_FILL | GTK_SHRINK | GTK_EXPAND,
	                 3, 3);

	control = gnome_db_control_new(logw);
	if (GNOME_DB_IS_CONTROL(control)) {
		gnome_db_control_set_user_data(control, (gpointer) log_info);
		gnome_db_control_set_toolbar(control, log_control_toolbar);
	}

	return BONOBO_OBJECT(control);
}

