/*  GNOME-DB Rolodex
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gnomedb-rolodex.h>

static guint prepare_app (void);

GtkWidget*      glb_mainwin = NULL;
GdaConnection* glb_connection = NULL;

int
main (int argc, char *argv[])
{
  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
  
  gnome_db_init("gnomedb-rolodex", VERSION, argc, argv);
  
  /* run application */
  gnome_db_main((GtkFunction) prepare_app);
  return 0;
}

static guint
prepare_app (void)
{
  glb_mainwin = gnome_db_window_new("gnomedb-rolodex", NULL/*mainmenu*/, NULL/*toolbar*/, NULL);
  gtk_signal_connect(GTK_OBJECT(glb_mainwin),
                     "close",
                     GTK_SIGNAL_FUNC(rolodex_quit_cb),
                     NULL);

  /* load configuration */
  gnome_db_load_window_config("MainWindow", glb_mainwin);

  gnome_db_window_show(GNOME_DB_WINDOW(glb_mainwin));
  
  return FALSE;
}
