/*  GNOME-DB Builder
 *  Copyrigth (C) 2000 Rodrigo Moya
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <gnomedb-builder.h>

static GnomeUIInfo filenewmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Report..."), N_("Create new report"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo fileopenmenu[] = {
	{ GNOME_APP_UI_ITEM, N_("Report..."), N_("Open an existing report"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_NONE,
	  NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};
static GnomeUIInfo filemenu[] = {
	GNOMEUIINFO_SUBTREE_STOCK(N_("_New"), filenewmenu, GNOME_STOCK_MENU_NEW),
	GNOMEUIINFO_SUBTREE_STOCK(N_("_Open"), fileopenmenu, GNOME_STOCK_MENU_OPEN),
	GNOMEUIINFO_END
};
static GnomeUIInfo mainmenu[] = {
	GNOMEUIINFO_SUBTREE(N_("_File"), filemenu),
	GNOMEUIINFO_END
};
static GnomeUIInfo toolbar[] = {
	{ GNOME_APP_UI_ITEM, N_("New"), N_("Add new module to project"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Open"), N_("Open an existing module"),
	  NULL, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
	  GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL },
	GNOMEUIINFO_END
};

/*
 * Public functions
 */
BonoboObject *
builder_control_new (void)
{
	GtkWidget*      w;
	GnomeDbControl* control;
	
	/* create builder main widget */
	w = gnome_db_new_table_widget(8, 8, FALSE);
	gtk_widget_show_all(w);
	
	/* create control instance */
	control = gnome_db_control_new(w);
	if (GNOME_DB_IS_CONTROL(control)) {
		/* set menus/toolbar */
		gnome_db_control_set_menubar(control, mainmenu);
		gnome_db_control_set_toolbar(control, toolbar);
	}
	
	return BONOBO_OBJECT(control);
}
