/* GNOME DB components libary
 * Copyright (C) 2000 Rodrigo Moya
 * Copyright (C) 2000 Vivien Malerba
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_control_widget_h__)
#  define __gnome_db_control_widget_h__

#include <gtk/gtkvbox.h>
#include <bonobo/bonobo-widget.h>
#include <gnome-db-control-defprops.h>

BEGIN_GNOME_DECLS

#define GNOME_DB_TYPE_CONTROL_WIDGET            (gnome_db_control_widget_get_type())
#define GNOME_DB_CONTROL_WIDGET(obj)            GTK_CHECK_CAST(obj, GNOME_DB_TYPE_CONTROL_WIDGET, GnomeDbControlWidget)
#define GNOME_DB_CONTROL_WIDGET_CLASS(klass)    GTK_CHECK_CLASS_CAST(klass, GNOME_DB_TYPE_CONTROL_WIDGET, GnomeDbControlWidgetClass)
#define GNOME_DB_IS_CONTROL_WIDGET(obj)         GTK_CHECK_TYPE(obj, GNOME_DB_TYPE_CONTROL_WIDGET)
#define GNOME_DB_IS_CONTROL_WIDGET_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), GNOME_DB_TYPE_CONTROL_WIDGET))

typedef struct _GnomeDbControlWidget      GnomeDbControlWidget;
typedef struct _GnomeDbControlWidgetClass GnomeDbControlWidgetClass;

struct _GnomeDbControlWidget {
	GtkVBox            parent;
	BonoboWidget*      bonobo_widget;
	gchar*             goad_id;
	Bonobo_PropertyBag prop;
	CORBA_Object       gnomedb_control;
};

struct _GnomeDbControlWidgetClass {
	GtkVBoxClass parent_class;
};

GtkType    gnome_db_control_widget_get_type  (void);
GtkWidget* gnome_db_control_widget_new       (const gchar *id, Bonobo_UIContainer uic);

gboolean   gnome_db_control_widget_supported  (const gchar *goad_id);
gboolean   gnome_db_control_widget_is_alive   (GnomeDbControlWidget *wid);

void       gnome_db_control_widget_activate   (GnomeDbControlWidget *wid);
void       gnome_db_control_widget_deactivate (GnomeDbControlWidget *wid);

#define gnome_db_control_widget_get_repo_id(_wid_) ((_wid_) ? GNOME_DB_CONTROL_WIDGET((_wid_))->goad_id : NULL)

/* 
 * Functions to manipulate controls from the properties 
 */
gboolean gnome_db_control_widget_prop_supported  (GnomeDbControlWidget *wid, 
                                                  const gchar *prop_name);

void     gnome_db_control_widget_get_prop        (GnomeDbControlWidget *wid,
                                                  const gchar *prop_name, 
                                                  gpointer *value);
void     gnome_db_control_widget_set_prop_ptr    (GnomeDbControlWidget *wid,
                                                  const gchar *prop_name, 
                                                  gconstpointer value);

/* give the right type of arg as the last argument */
void     gnome_db_control_widget_set_prop        (GnomeDbControlWidget *wid,
                                                  const gchar *prop_name,
                                                  ...);
                                                  
/* GnomeDbControl IDL interface */
gchar* gnome_db_control_widget_get_version (GnomeDbControlWidget *wid);
gchar* gnome_db_control_widget_get_authors (GnomeDbControlWidget *wid);

void   gnome_db_control_widget_run         (GnomeDbControlWidget *wid);

void   gnome_db_control_widget_set_owner          (GnomeDbControlWidget *wid);
void   gnome_db_control_widget_unset_owner        (GnomeDbControlWidget *wid);

void   gnome_db_control_widget_do_print           (GnomeDbControlWidget *wid);
void   gnome_db_control_widget_do_cut_clipboard   (GnomeDbControlWidget *wid);
void   gnome_db_control_widget_do_copy_clipboard  (GnomeDbControlWidget *wid);
void   gnome_db_control_widget_do_paste_clipboard (GnomeDbControlWidget *wid);

END_GNOME_DECLS

#endif
