/* GNOME-DB Components
 * Copyrigth (C) 2000-2001 The Free Software Foundation
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <bonobo/bonobo-i18n.h>
#include <gtk/gtkdialog.h>
#include <libgnomedb/gnome-db-browser.h>
#include <libgnomedb/gnome-db-table-editor.h>
#include <libgnomedb/gnome-db-util.h>
#include "components-browser.h"
#include "components-connection.h"

#define PARENT_TYPE GNOME_DB_TYPE_SHELL_COMPONENT

static void components_browser_class_init (ComponentsBrowserClass *klass);
static void components_browser_init       (ComponentsBrowser *comp, ComponentsBrowserClass *klass);
static void components_browser_finalize   (GObject *object);
static gboolean components_browser_select_connection (GnomeDbShellComponent *comp,
						      const gchar *name,
						      const gchar *username,
						      const gchar *password);

static void verb_DatabaseConnect (BonoboUIComponent *uic, void *user_data, const char *path);
static void verb_DatabaseDisconnect (BonoboUIComponent *uic, void *user_data, const char *path);
static void verb_FileNewTable (BonoboUIComponent *uic, void *user_data, const char *path);

static BonoboUIVerb browser_verbs[] = {
	BONOBO_UI_VERB ("FileNewTable", verb_FileNewTable),
	BONOBO_UI_VERB ("DatabaseConnect", verb_DatabaseConnect),
	BONOBO_UI_VERB ("DatabaseDisconnect", verb_DatabaseDisconnect),
	BONOBO_UI_VERB_END
};
static GObjectClass *parent_class = NULL;

/*
 * Callbacks
 */

static void
new_table_response_cb (GtkDialog *dialog, gint response_id, gpointer user_data)
{
	GnomeDbTableEditor *editor = (GnomeDbTableEditor *) user_data;

	g_return_if_fail (GNOME_DB_IS_TABLE_EDITOR (editor));

	if (response_id == GTK_RESPONSE_OK) {
	}

	gtk_widget_destroy (GTK_WIDGET (dialog));
}

static void
verb_DatabaseConnect (BonoboUIComponent *uic, void *user_data, const char *path)
{
	GdaConnection *cnc;
	ComponentsBrowser *comp = (ComponentsBrowser *) user_data;

	g_return_if_fail (COMPONENTS_IS_BROWSER (comp));

	/* open the connection */
	cnc = components_connection_open_dialog (NULL);
	if (!GDA_IS_CONNECTION (cnc))
		return;

	/* display the new connection */
	gnome_db_browser_set_connection (GNOME_DB_BROWSER (comp->browser), cnc);
}

static void
verb_DatabaseDisconnect (BonoboUIComponent *uic, void *user_data, const char *path)
{
	GdaConnection *cnc;
	ComponentsBrowser *comp = (ComponentsBrowser *) user_data;

	g_return_if_fail (COMPONENTS_IS_BROWSER (comp));

	cnc = gnome_db_browser_get_connection (GNOME_DB_BROWSER (comp->browser));
	if (GDA_IS_CONNECTION (cnc)) {
		gnome_db_browser_set_connection (GNOME_DB_BROWSER (comp->browser), NULL);
		components_connection_close (cnc);
	}
}

static void
verb_FileNewTable (BonoboUIComponent *uic, void *user_data, const char *path)
{
	GdaConnection *cnc;
	GtkWidget *dialog;
	GtkWidget *editor;
	ComponentsBrowser *comp = (ComponentsBrowser *) user_data;

	g_return_if_fail (COMPONENTS_IS_BROWSER (comp));

	cnc = cnc = gnome_db_browser_get_connection (GNOME_DB_BROWSER (comp->browser));
	if (!GDA_IS_CONNECTION (cnc))
		return;
		
	/* create the dialog */
	dialog = gtk_dialog_new ();
	gtk_dialog_add_button (GTK_DIALOG (dialog), _("Cancel"), GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button (GTK_DIALOG (dialog), _("OK"), GTK_RESPONSE_OK);
	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);

	editor = gnome_db_table_editor_new ();
	gtk_widget_show (editor);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), editor, TRUE, TRUE, 0);

	g_signal_connect (G_OBJECT (dialog), "response",
			  G_CALLBACK (new_table_response_cb), editor);

	/* run the dialog */
	gtk_widget_show (dialog);
}

/*
 * ComponentsBrowser class implementation
 */

static void
components_browser_class_init (ComponentsBrowserClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GnomeDbShellComponentClass *comp_class = GNOME_DB_SHELL_COMPONENT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = components_browser_finalize;
	comp_class->select_connection = components_browser_select_connection;
}

static void
components_browser_init (ComponentsBrowser *comp, ComponentsBrowserClass *klass)
{
	GnomeDbShellComponent *shell_comp;
	GnomeDbControl *control;

	/* create the browser widget */
	comp->browser = gnome_db_browser_new ();

	/* create the shell component */
	shell_comp = gnome_db_shell_component_construct (
		GNOME_DB_SHELL_COMPONENT (comp), comp->browser);
	if (!GNOME_DB_IS_SHELL_COMPONENT (shell_comp)) {
		g_object_unref (G_OBJECT (comp));
		return;
	}

	control = gnome_db_shell_component_get_control (shell_comp);

	gnome_db_control_set_ui (control,
				 GNOMEDB_DATADIR,
				 "gnome-db-browser.xml",
				 browser_verbs,
				 shell_comp);
}

static void
components_browser_finalize (GObject *object)
{
	ComponentsBrowser *comp = (ComponentsBrowser *) object;

	g_return_if_fail (COMPONENTS_IS_BROWSER (comp));

	/* chain to parent class */
	parent_class->finalize (object);
}

GType
components_browser_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (ComponentsBrowserClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) components_browser_class_init,
			NULL,
			NULL,
			sizeof (ComponentsBrowser),
			0,
			(GInstanceInitFunc) components_browser_init
		};
		type = g_type_register_static (PARENT_TYPE, "ComponentsBrowser", &info, 0);
	}
	return type;
}

GnomeDbShellComponent *
components_browser_new (void)
{
	GnomeDbShellComponent *comp;

	comp = g_object_new (COMPONENTS_TYPE_BROWSER, NULL);
	return comp;
}

static gboolean
components_browser_select_connection (GnomeDbShellComponent *comp,
				      const gchar *name,
				      const gchar *username,
				      const gchar *password)
{
}
