/* GNOME-DB Components
 * Copyrigth (C) 2000-2001 The Free Software Foundation
 *
 * AUTHORS:
 *	Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgnomedb/gnome-db-dsn-config-druid.h>
#include "components-manager.h"

#define PARENT_TYPE GNOME_DB_TYPE_SHELL_COMPONENT

static void components_manager_class_init (ComponentsManagerClass *klass);
static void components_manager_init       (ComponentsManager *manager,
					   ComponentsManagerClass *klass);
static void components_manager_finalize   (GObject *object);

static void verb_ManagerNewDsn (BonoboUIComponent *uic, void *user_data, const char *path);

static BonoboUIVerb manager_verbs[] = {
	BONOBO_UI_VERB ("ManagerNewDsn", verb_ManagerNewDsn),
	BONOBO_UI_VERB_END
};
static GObjectClass *parent_class = NULL;

/*
 * Callbacks
 */

static void
druid_finished_cb (GnomeDbDsnConfigDruid *druid, gboolean error, gpointer user_data)
{
	GtkWidget *window = (GtkWidget *) user_data;

	g_return_if_fail (GTK_IS_WINDOW (window));
	g_return_if_fail (GNOME_DB_IS_DSN_CONFIG_DRUID (druid));

	if (!error) {
		/* FIXME: get the DSN info from the druid, and save it */
	}

	gtk_widget_destroy (window);
}

static void
verb_ManagerNewDsn (BonoboUIComponent *uic, void *user_data, const char *path)
{
	GtkWidget *window;
	GtkWidget *druid;
	ComponentsManager *manager = (ComponentsManager *) user_data;

	g_return_if_fail (COMPONENTS_IS_MANAGER (manager));

	/* create the window to contain the druid */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	druid = gnome_db_dsn_config_druid_new ();
	g_signal_connect (G_OBJECT (druid), "finished", G_CALLBACK (druid_finished_cb), window);
	gtk_widget_show (druid);
	gtk_container_add (GTK_CONTAINER (window), druid);

	gtk_widget_show (window);
}

/*
 * ComponentsManager class implementation
 */

static void
components_manager_class_init (ComponentsManagerClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = components_manager_finalize;
}

static void
components_manager_init (ComponentsManager *manager, ComponentsManagerClass *klass)
{
	GnomeDbShellComponent *shell_comp;
	GnomeDbControl *control;

	shell_comp = gnome_db_shell_component_construct (
		GNOME_DB_SHELL_COMPONENT (manager),
		components_manager_view_new ());
	if (!GNOME_DB_IS_SHELL_COMPONENT (shell_comp)) {
		g_object_unref (G_OBJECT (manager));
		return;
	}

	control = gnome_db_shell_component_get_control (shell_comp);

	g_assert (GNOME_DB_IS_CONTROL (control));

	gnome_db_control_set_ui (control,
				 GNOMEDB_DATADIR,
				 "gnome-db-manager.xml",
				 manager_verbs,
				 shell_comp);
}

static void
components_manager_finalize (GObject *object)
{
	ComponentsManager *manager = (ComponentsManager *) object;

	g_return_if_fail (COMPONENTS_IS_MANAGER (manager));

	parent_class->finalize (object);
}

GType
components_manager_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (ComponentsManagerClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) components_manager_class_init,
			NULL,
			NULL,
			sizeof (ComponentsManager),
			0,
			(GInstanceInitFunc) components_manager_init
		};
		type = g_type_register_static (PARENT_TYPE, "ComponentsManager", &info, 0);
	}
	return type;
}

GnomeDbShellComponent *
components_manager_new (void)
{
	GnomeDbShellComponent *comp;

	comp = g_object_new (COMPONENTS_TYPE_MANAGER, NULL);
	return comp;
}
