# Note that this is NOT a relocatable package
# defaults for redhat
%define name	gnome-db
%define ver	0.8.103

%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}

Summary: GNOME DB
Name: 		%name
Version:	%ver
Release: 	%rel
Copyright: 	GPL
Group: 		Applications/Databases
Source:		ftp://ftp.gnome-db.org/pub/gnome-db/sources/%{ver}/%{name}-%{ver}.tar.gz
BuildRoot: 	%{_tmppath}/%{name}-%{ver}-root
URL: 		http://www.gnome.org/projects/gnome-db/

BuildPrereq: GConf-devel >= 0.11, libxml-devel >= 1.8 , oaf-devel >= 0.6, ORBit-devel >= 0.5, glib-devel >= 1.2, gtk+-devel >= 1.2, bonobo-devel >= 0.36, libgda-devel >= 0.2.9

%description
Gnome DB is a frontend to the GDA architecture, being developed as part
of the GNOME project. It adds, to the already powerful GDA architecture,
a nice GUI front end for users, as well as a whole set of software
components intended to be reused in other unrelated applications.

This package contains the core components of GNOME-DB.

%package devel
Summary: GNOME DB Development
Group: 		Applications/Databases
Requires:	%name = %{PACKAGE_VERSION}, libgda-devel >= 0.2.9, bonobo-devel, gnome-libs-devel

%description devel
Gnome DB is a frontend to the GDA architecture, being developed as part
of the GNOME project. It adds, to the already powerful GDA architecture,
a nice GUI front end for users, as well as a whole set of software
components intended to be reused in other unrelated applications.

This package contains libraries, header files and tools to let
you develop GNOME-DB applications.

%changelog
* Sat Jun  2 2001 Serge Pavlovsky <pal@re.com.ua>
- cleaned
* Fri Aug 11 2000 Rodrigo Moya <rodrigo@linuxave.net>
- Initial spec imported from old GNOME-DB spec

%prep
%setup

%build

# libtool workaround for alphalinux
%ifarch alpha
  ARCH_FLAGS="--host=alpha-redhat-linux"
%endif

# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh $ARCH_FLAGS --prefix=%{_prefix}
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure $ARCH_FLAGS --prefix=%{_prefix}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=%{buildroot} install
%find_lang %{name} --with-gnome

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
							  
%postun -p /sbin/ldconfig
							  
%files -f %{name}.lang
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README 
%{_bindir}/gnomedb-components
%{_bindir}/gnomedb-fe
%{_bindir}/gnomedb-mgr
%{_libdir}/libgnomedb.so.*
%{_libdir}/bonobo/monikers/libdatabase_moniker.so*
%{_datadir}/gnome/apps/Applications/gnomedb-fe.desktop
%{_datadir}/gnome/ui/*.xml
%{_datadir}/pixmaps/*
%{_datadir}/oaf/GNOME_DB_ComponentFactory.oaf
%{_datadir}/oaf/GNOME_DB_Export.oaf
%{_datadir}/oaf/GNOME_DB_Manager.oaf
%{_datadir}/oaf/GNOME_DB_Monikers.oaf
%{_datadir}/oaf/GNOME_DB_Designer.oaf
%{_datadir}/oaf/GNOME_DB_Connection.oaf
%{_datadir}/oaf/GNOME_DB_Log.oaf
%{_datadir}/idl/*

%files devel
%defattr(-, root, root)
%doc %{_datadir}/gnome/html/*
%{_bindir}/gnomedb-config
%{_bindir}/gnomedb-builder
%{_libdir}/libgnomedb.*a
%{_libdir}/libgnomedb.so
%{_includedir}/*
%{_datadir}/oaf/GNOME_DB_Builder.oaf

