/* gnome-rr-config.h
 *
 * Copyright 2007, 2008, Red Hat, Inc.
 * 
 * This file is part of the Gnome Library.
 * 
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * Author: Soren Sandmann <sandmann@redhat.com>
 */
#ifndef GNOME_RR_CONFIG_H
#define GNOME_RR_CONFIG_H

#ifndef GNOME_DESKTOP_USE_UNSTABLE_API
#error   gnome-rr-config.h is unstable API. You must define GNOME_DESKTOP_USE_UNSTABLE_API before including gnome-rr-config.h
#endif

#include <glib.h>
#include <libgnome-desktop/gnome-rr.h>

typedef struct GnomeOutputInfo GnomeOutputInfo;
typedef struct GnomeRRConfig GnomeRRConfig;

/* FIXME:
 *
 * This structure is a Frankenstein monster where all of the fields
 * are generated by the system, but some of them can be changed by
 * the client.
 */

struct GnomeOutputInfo
{
    char *		name;

    gboolean		on; /* whether there is a CRTC assigned to this output (i.e. a signal is being sent to it) */
    int			width;
    int			height;
    int			rate;
    int			x;
    int			y;
    GnomeRRRotation	rotation;

    gboolean		connected; /* whether the output is physically connected to a monitor */
    char		vendor[4];
    guint		product;
    guint		serial;
    double		aspect;
    int			pref_width;
    int			pref_height;
    char *		display_name;
    gboolean            primary;

    gpointer		user_data;
};

struct GnomeRRConfig
{
    /* "clone" means that at least two outputs are at (0, 0) offset and they
     * have the same width/height.  Those outputs are of course connected and on
     * (i.e. they have a CRTC assigned).
     */
    gboolean		clone;
    
    GnomeOutputInfo **	outputs;
};

GnomeRRConfig  *gnome_rr_config_new_current  (GnomeRRScreen  *screen);
GnomeRRConfig  *gnome_rr_config_new_stored   (GnomeRRScreen  *screen,
					      GError        **error);
void            gnome_rr_config_free         (GnomeRRConfig  *configuration);
gboolean        gnome_rr_config_match        (GnomeRRConfig  *config1,
					      GnomeRRConfig  *config2);
gboolean        gnome_rr_config_equal	     (GnomeRRConfig  *config1,
					      GnomeRRConfig  *config2);
gboolean        gnome_rr_config_save         (GnomeRRConfig  *configuration,
					      GError        **error);
void            gnome_rr_config_sanitize     (GnomeRRConfig  *configuration);

#ifndef GNOME_DISABLE_DEPRECATED
gboolean	gnome_rr_config_apply        (GnomeRRConfig  *configuration,
					      GnomeRRScreen  *screen,
					      GError        **error);
#endif

gboolean	gnome_rr_config_apply_with_time (GnomeRRConfig  *configuration,
						 GnomeRRScreen  *screen,
						 guint32         timestamp,
						 GError        **error);

#ifndef GNOME_DISABLE_DEPRECATED
gboolean        gnome_rr_config_apply_stored (GnomeRRScreen  *screen,
					      GError        **error);
#endif

#ifndef GNOME_DISABLE_DEPRECATED
gboolean        gnome_rr_config_apply_from_filename (GnomeRRScreen  *screen,
						     const char     *filename,
						     GError        **error);
#endif

gboolean        gnome_rr_config_apply_from_filename_with_time (GnomeRRScreen  *screen,
							       const char     *filename,
							       guint32         timestamp,
							       GError        **error);

gboolean        gnome_rr_config_applicable   (GnomeRRConfig  *configuration,
					      GnomeRRScreen  *screen,
					      GError        **error);

char *gnome_rr_config_get_backup_filename (void);
char *gnome_rr_config_get_intended_filename (void);

/* A utility function that isn't really in the spirit of this file, but I don't
 * don't know a better place for it.
 */
GnomeRRMode **gnome_rr_create_clone_modes (GnomeRRScreen *screen);

#endif
