/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SRC_RECORDER_H__
#define __SRC_RECORDER_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/iterable.h>
#include <gee/map.h>
#include <gee/set.h>
#include <gee/iterator.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "src/IDBusRecorder.h"
#include "src/OverlapType.h"
#include "src/DeviceGroup.h"
#include "src/Timer.h"
#include "src/Device.h"
#include "src/Recording.h"
#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

G_BEGIN_DECLS


#define DVB_TYPE_RECORDING_THREAD (dvb_recording_thread_get_type ())
#define DVB_RECORDING_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING_THREAD, DVBRecordingThread))
#define DVB_RECORDING_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING_THREAD, DVBRecordingThreadClass))
#define DVB_IS_RECORDING_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING_THREAD))
#define DVB_IS_RECORDING_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING_THREAD))
#define DVB_RECORDING_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING_THREAD, DVBRecordingThreadClass))

typedef struct _DVBRecordingThreadPrivate DVBRecordingThreadPrivate;

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorderPrivate DVBRecorderPrivate;

/**
     * This class does the actual recording for a single device.
     * It record more than one channel, if the channels are part
     * of the same transport stream
     */
struct _DVBRecordingThread {
	GObject parent_instance;
	DVBRecordingThreadPrivate * priv;
};

struct _DVBRecordingThreadClass {
	GObjectClass parent_class;
};

/**
     * This class is responsible for managing upcoming recordings and
     * already recorded items for a single group of devices
     */
struct _DVBRecorder {
	GObject parent_instance;
	DVBRecorderPrivate * priv;
	GeeMap* active_recording_threads;
	GeeSet* active_timers;
};

struct _DVBRecorderClass {
	GObjectClass parent_class;
};


DVBRecordingThread* dvb_recording_thread_construct (GType object_type, DVBDevice* device, DVBEPGScanner* epgscanner);
DVBRecordingThread* dvb_recording_thread_new (DVBDevice* device, DVBEPGScanner* epgscanner);
void dvb_recording_thread_stop_recording (DVBRecordingThread* self, DVBTimer* timer);
void dvb_recording_thread_start_recording (DVBRecordingThread* self, DVBTimer* timer, GFile* location);
DVBDevice* dvb_recording_thread_get_device (DVBRecordingThread* self);
DVBEPGScanner* dvb_recording_thread_get_epgscanner (DVBRecordingThread* self);
guint dvb_recording_thread_get_count (DVBRecordingThread* self);
GType dvb_recording_thread_get_type (void);
DVBRecorder* dvb_recorder_construct (GType object_type, DVBDeviceGroup* dev);
DVBRecorder* dvb_recorder_new (DVBDeviceGroup* dev);
guint32 dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer);
void dvb_recorder_stop (DVBRecorder* self);
DVBTimer* dvb_recorder_create_timer (DVBRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration);
void dvb_recorder_start_recording (DVBRecorder* self, DVBTimer* timer);
void dvb_recorder_stop_recording (DVBRecorder* self, DVBTimer* timer);
DVBDeviceGroup* dvb_recorder_get_DeviceGroup (DVBRecorder* self);
void dvb_recorder_dbus_register_object (DBusConnection* connection, const char* path, void* object);
DBusHandlerResult dvb_recorder_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
GType dvb_recorder_get_type (void);


G_END_DECLS

#endif
