/* gnomine.c generated by valac 0.15.0, the Vala compiler
 * generated from gnomine.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <games-frame.h>
#include <games-clock.h>
#include <games-fullscreen-action.h>
#include <games-pause-action.h>
#include <games-scores.h>
#include <stdlib.h>
#include <string.h>
#include <games-stock.h>
#include <games-score.h>
#include <glib/gi18n-lib.h>
#include <games-settings.h>
#include <gdk/gdk.h>
#include <games-scores-dialog.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <stdio.h>


#define TYPE_GNO_MINE (gno_mine_get_type ())
#define GNO_MINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GNO_MINE, GnoMine))
#define GNO_MINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GNO_MINE, GnoMineClass))
#define IS_GNO_MINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GNO_MINE))
#define IS_GNO_MINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GNO_MINE))
#define GNO_MINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GNO_MINE, GnoMineClass))

typedef struct _GnoMine GnoMine;
typedef struct _GnoMineClass GnoMineClass;
typedef struct _GnoMinePrivate GnoMinePrivate;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _minefield_unref0(var) ((var == NULL) ? NULL : (var = (minefield_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MinefieldPrivate MinefieldPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _GnoMine {
	GtkApplication parent_instance;
	GnoMinePrivate * priv;
};

struct _GnoMineClass {
	GtkApplicationClass parent_class;
};

struct _GnoMinePrivate {
	GSettings* settings;
	GtkImage* win_face_image;
	GtkImage* sad_face_image;
	GtkImage* smile_face_image;
	GtkImage* cool_face_image;
	GtkImage* worried_face_image;
	GtkImage* current_face_image;
	GtkWindow* window;
	Minefield* minefield;
	MinefieldView* minefield_view;
	GtkDialog* pref_dialog;
	GtkLabel* flag_label;
	GtkSpinButton* n_mines_spin;
	GtkButton* new_game_button;
	GamesFrame* custom_size_frame;
	GamesClock* clock;
	GtkAction* hint_action;
	GamesFullscreenAction* fullscreen_action;
	GamesPauseAction* pause_action;
	GamesScores* highscores;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};


static gpointer gno_mine_parent_class = NULL;

GType gno_mine_get_type (void) G_GNUC_CONST;
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
GType minefield_view_get_type (void) G_GNUC_CONST;
#define GNO_MINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GNO_MINE, GnoMinePrivate))
enum  {
	GNO_MINE_DUMMY_PROPERTY
};
#define GNO_MINE_KEY_XSIZE "xsize"
#define GNO_MINE_XSIZE_MIN 4
#define GNO_MINE_XSIZE_MAX 100
#define GNO_MINE_KEY_YSIZE "ysize"
#define GNO_MINE_YSIZE_MIN 4
#define GNO_MINE_YSIZE_MAX 100
#define GNO_MINE_KEY_NMINES "nmines"
#define GNO_MINE_KEY_MODE "mode"
#define GNO_MINE_KEY_USE_QUESTION_MARKS "use-question-marks"
#define GNO_MINE_KEY_USE_OVERMINE_WARNING "use-overmine-warning"
#define GNO_MINE_KEY_USE_AUTOFLAG "use-autoflag"
static void gno_mine_new_game_cb (GnoMine* self);
static void _gno_mine_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gno_mine_hint_cb (GnoMine* self);
static void _gno_mine_hint_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gno_mine_scores_cb (GnoMine* self);
static void _gno_mine_scores_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gno_mine_quit_game_cb (GnoMine* self);
static void _gno_mine_quit_game_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gno_mine_preferences_cb (GnoMine* self);
static void _gno_mine_preferences_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gno_mine_help_cb (GnoMine* self);
static void _gno_mine_help_cb_gtk_action_callback (GtkAction* action, gpointer self);
static void gno_mine_about_cb (GnoMine* self);
static void _gno_mine_about_cb_gtk_action_callback (GtkAction* action, gpointer self);
#define GNO_MINE_ui_description "<ui>" "    <menubar name='MainMenu'>" "        <menu action='GameMenu'>" "            <menuitem action='NewGame'/>" "            <menuitem action='Hint'/>" "            <menuitem action='PauseGame'/>" "            <separator/>" "            <menuitem action='Scores'/>" "            <separator/>" "            <menuitem action='Quit'/>" "        </menu>" "        <menu action='SettingsMenu'>" "            <menuitem action='Fullscreen'/>" "            <menuitem action='Preferences'/>" "        </menu>" "        <menu action='HelpMenu'>" "            <menuitem action='Contents'/>" "            <menuitem action='About'/>" "        </menu>" "    </menubar>" "</ui>"
GnoMine* gno_mine_new (void);
GnoMine* gno_mine_construct (GType object_type);
static GtkUIManager* gno_mine_create_ui_manager (GnoMine* self, const gchar* group);
static void gno_mine_new_game (GnoMine* self);
static void _gno_mine_new_game_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GtkImage* gno_mine_load_face_image (GnoMine* self, const gchar* name);
MinefieldView* minefield_view_new (void);
MinefieldView* minefield_view_construct (GType object_type);
void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks);
void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning);
void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag);
static gboolean gno_mine_view_button_press_event (GnoMine* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _gno_mine_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void gno_mine_look_cb (GnoMine* self, MinefieldView* minefield_view);
static void _gno_mine_look_cb_minefield_view_look (MinefieldView* _sender, gpointer self);
static void gno_mine_unlook_cb (GnoMine* self, MinefieldView* minefield_view);
static void _gno_mine_unlook_cb_minefield_view_unlook (MinefieldView* _sender, gpointer self);
void gno_mine_start (GnoMine* self);
static void gno_mine_set_face_image (GnoMine* self, GtkImage* face_image);
static void gno_mine_real_activate (GApplication* base);
static void gno_mine_update_flag_label (GnoMine* self);
guint minefield_get_n_flags (Minefield* self);
static gint gno_mine_show_scores (GnoMine* self, gint pos, gboolean endofgame);
guint minefield_get_n_cleared (Minefield* self);
gboolean minefield_get_is_complete (Minefield* self);
Minefield* minefield_new (guint width, guint height, guint n_mines);
Minefield* minefield_construct (GType object_type, guint width, guint height, guint n_mines);
static void gno_mine_marks_changed_cb (GnoMine* self, Minefield* minefield);
static void _gno_mine_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self);
static void gno_mine_explode_cb (GnoMine* self, Minefield* minefield);
static void _gno_mine_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void gno_mine_cleared_cb (GnoMine* self, Minefield* minefield);
static void _gno_mine_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
void minefield_view_set_paused (MinefieldView* self, gboolean value);
void minefield_hint (Minefield* self, guint* x, guint* y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static void gno_mine_pause_cb (GnoMine* self, GtkAction* action);
static void gno_mine_set_n_mines_limit (GnoMine* self);
static void gno_mine_xsize_spin_cb (GnoMine* self, GtkSpinButton* spin);
static void gno_mine_ysize_spin_cb (GnoMine* self, GtkSpinButton* spin);
static void gno_mine_n_mines_spin_cb (GnoMine* self, GtkSpinButton* spin);
static void gno_mine_use_question_toggle_cb (GnoMine* self, GtkToggleButton* button);
static void gno_mine_use_overmine_toggle_cb (GnoMine* self, GtkToggleButton* button);
static GtkDialog* gno_mine_create_preferences (GnoMine* self);
static void gno_mine_small_size_toggled_cb (GnoMine* self, GtkToggleButton* button);
static void _gno_mine_small_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void gno_mine_medium_size_toggled_cb (GnoMine* self, GtkToggleButton* button);
static void _gno_mine_medium_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void gno_mine_large_size_toggled_cb (GnoMine* self, GtkToggleButton* button);
static void _gno_mine_large_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void gno_mine_custom_size_toggled_cb (GnoMine* self, GtkToggleButton* button);
static void _gno_mine_custom_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _gno_mine_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void _gno_mine_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void _gno_mine_n_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void _gno_mine_use_question_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _gno_mine_use_overmine_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void gno_mine_pref_response_cb (GnoMine* self, GtkDialog* dialog, gint response_id);
static void _gno_mine_pref_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean gno_mine_pref_delete_event_cb (GnoMine* self, GtkWidget* widget, GdkEventAny* event);
static gboolean _gno_mine_pref_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void gno_mine_set_mode (GnoMine* self, gint mode);
static void _gno_mine_pause_cb_games_pause_action_state_changed (GamesPauseAction* _sender, gpointer self);
gint gno_mine_main (gchar** args, int args_length1);
static void gno_mine_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GamesScoresCategory GNO_MINE_scorecats[4] = {{"Small", "Small"}, {"Medium", "Medium"}, {"Large", "Large"}, {"Custom", "Custom"}};
static const GtkActionEntry GNO_MINE_actions[10] = {{"GameMenu", NULL, "_Game"}, {"SettingsMenu", NULL, "_Settings"}, {"HelpMenu", NULL, "_Help"}, {"NewGame", GAMES_STOCK_NEW_GAME, NULL, NULL, NULL, (GCallback) _gno_mine_new_game_cb_gtk_action_callback}, {"Hint", GAMES_STOCK_HINT, NULL, NULL, NULL, (GCallback) _gno_mine_hint_cb_gtk_action_callback}, {"Scores", GAMES_STOCK_SCORES, NULL, NULL, NULL, (GCallback) _gno_mine_scores_cb_gtk_action_callback}, {"Quit", GTK_STOCK_QUIT, NULL, NULL, NULL, (GCallback) _gno_mine_quit_game_cb_gtk_action_callback}, {"Preferences", GTK_STOCK_PREFERENCES, NULL, NULL, NULL, (GCallback) _gno_mine_preferences_cb_gtk_action_callback}, {"Contents", GAMES_STOCK_CONTENTS, NULL, NULL, NULL, (GCallback) _gno_mine_help_cb_gtk_action_callback}, {"About", GTK_STOCK_ABOUT, NULL, NULL, NULL, (GCallback) _gno_mine_about_cb_gtk_action_callback}};

static void _gno_mine_new_game_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gno_mine_new_game_cb (self);
}


static void _gno_mine_hint_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gno_mine_hint_cb (self);
}


static void _gno_mine_scores_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gno_mine_scores_cb (self);
}


static void _gno_mine_quit_game_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gno_mine_quit_game_cb (self);
}


static void _gno_mine_preferences_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gno_mine_preferences_cb (self);
}


static void _gno_mine_help_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gno_mine_help_cb (self);
}


static void _gno_mine_about_cb_gtk_action_callback (GtkAction* action, gpointer self) {
	gno_mine_about_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gno_mine_new_game_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	gno_mine_new_game (self);
}


static gboolean _gno_mine_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = gno_mine_view_button_press_event (self, _sender, event);
	return result;
}


static void _gno_mine_look_cb_minefield_view_look (MinefieldView* _sender, gpointer self) {
	gno_mine_look_cb (self, _sender);
}


static void _gno_mine_unlook_cb_minefield_view_unlook (MinefieldView* _sender, gpointer self) {
	gno_mine_unlook_cb (self, _sender);
}


GnoMine* gno_mine_construct (GType object_type) {
	GnoMine * self = NULL;
	GSettings* _tmp0_;
	GamesScores* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GtkWindow* _tmp6_;
	GtkWindow* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* main_vbox;
	GtkWindow* _tmp10_;
	GtkUIManager* _tmp11_ = NULL;
	GtkUIManager* ui_manager;
	GtkWindow* _tmp12_;
	GtkAccelGroup* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	GtkMenuBar* _tmp15_;
	GtkMenuBar* menubar;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* vbox;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* status_box;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkAlignment* _tmp24_;
	GtkAlignment* _tmp25_;
	GtkAlignment* new_game_button_alignment;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkBox* _tmp31_;
	GtkBox* _tmp32_;
	GtkBox* face_box;
	GtkButton* _tmp33_;
	GtkImage* _tmp34_ = NULL;
	GtkImage* _tmp35_ = NULL;
	GtkImage* _tmp36_ = NULL;
	GtkImage* _tmp37_ = NULL;
	GtkImage* _tmp38_ = NULL;
	GtkImage* _tmp39_;
	GtkImage* _tmp40_;
	GtkImage* _tmp41_;
	GtkImage* _tmp42_;
	GtkImage* _tmp43_;
	GtkBox* _tmp44_;
	GtkBox* _tmp45_;
	GtkBox* box;
	const gchar* _tmp46_ = NULL;
	GtkLabel* _tmp47_;
	GtkLabel* _tmp48_;
	GtkLabel* label;
	GamesClock* _tmp49_;
	GamesClock* _tmp50_;
	GamesClock* _tmp51_;
	GamesClock* _tmp52_;
	MinefieldView* _tmp53_;
	MinefieldView* _tmp54_;
	MinefieldView* _tmp55_;
	GSettings* _tmp56_;
	gboolean _tmp57_ = FALSE;
	MinefieldView* _tmp58_;
	GSettings* _tmp59_;
	gboolean _tmp60_ = FALSE;
	MinefieldView* _tmp61_;
	GSettings* _tmp62_;
	gboolean _tmp63_ = FALSE;
	MinefieldView* _tmp64_;
	MinefieldView* _tmp65_;
	MinefieldView* _tmp66_;
	MinefieldView* _tmp67_;
	MinefieldView* _tmp68_;
	self = (GnoMine*) g_object_new (object_type, "application-id", "org.gnome.gnomine", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnomine");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = games_scores_new ("gnomine", GNO_MINE_scorecats, G_N_ELEMENTS (GNO_MINE_scorecats), "board size", NULL, 0, GAMES_SCORES_STYLE_TIME_ASCENDING);
	_g_object_unref0 (self->priv->highscores);
	self->priv->highscores = _tmp1_;
	gtk_window_set_default_icon_name ("gnome-mines");
	_tmp2_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp3_;
	_tmp4_ = self->priv->window;
	_tmp5_ = _ ("Mines");
	gtk_window_set_title (_tmp4_, _tmp5_);
	_tmp6_ = self->priv->window;
	games_settings_bind_window_state ("/org/gnome/gnomine/", _tmp6_);
	_tmp7_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp7_);
	games_stock_init ();
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	main_vbox = _tmp9_;
	_tmp10_ = self->priv->window;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) main_vbox);
	gtk_widget_show ((GtkWidget*) main_vbox);
	_tmp11_ = gno_mine_create_ui_manager (self, "GnomineActions");
	ui_manager = _tmp11_;
	_tmp12_ = self->priv->window;
	_tmp13_ = gtk_ui_manager_get_accel_group (ui_manager);
	gtk_window_add_accel_group (_tmp12_, _tmp13_);
	_tmp14_ = gtk_ui_manager_get_widget (ui_manager, "/MainMenu");
	_tmp15_ = _g_object_ref0 (GTK_MENU_BAR (_tmp14_));
	menubar = _tmp15_;
	gtk_widget_show ((GtkWidget*) menubar);
	gtk_box_pack_start (main_vbox, (GtkWidget*) menubar, FALSE, FALSE, (guint) 0);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp17_ = g_object_ref_sink (_tmp16_);
	vbox = _tmp17_;
	gtk_container_set_border_width ((GtkContainer*) vbox, (guint) 6);
	gtk_widget_show ((GtkWidget*) vbox);
	gtk_box_pack_start (main_vbox, (GtkWidget*) vbox, TRUE, TRUE, (guint) 0);
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp19_ = g_object_ref_sink (_tmp18_);
	status_box = _tmp19_;
	gtk_box_set_homogeneous (status_box, TRUE);
	gtk_box_pack_start (vbox, (GtkWidget*) status_box, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) status_box);
	_tmp20_ = (GtkLabel*) gtk_label_new ("");
	_tmp21_ = g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->flag_label);
	self->priv->flag_label = _tmp21_;
	_tmp22_ = self->priv->flag_label;
	gtk_box_pack_start (status_box, (GtkWidget*) _tmp22_, FALSE, FALSE, (guint) 0);
	_tmp23_ = self->priv->flag_label;
	gtk_widget_show ((GtkWidget*) _tmp23_);
	_tmp24_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	_tmp25_ = g_object_ref_sink (_tmp24_);
	new_game_button_alignment = _tmp25_;
	gtk_box_pack_start (status_box, (GtkWidget*) new_game_button_alignment, FALSE, FALSE, (guint) 0);
	gtk_widget_show ((GtkWidget*) new_game_button_alignment);
	_tmp26_ = (GtkButton*) gtk_button_new ();
	_tmp27_ = g_object_ref_sink (_tmp26_);
	_g_object_unref0 (self->priv->new_game_button);
	self->priv->new_game_button = _tmp27_;
	_tmp28_ = self->priv->new_game_button;
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) _gno_mine_new_game_gtk_button_clicked, self, 0);
	_tmp29_ = self->priv->new_game_button;
	gtk_container_add ((GtkContainer*) new_game_button_alignment, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp30_);
	_tmp31_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	_tmp32_ = g_object_ref_sink (_tmp31_);
	face_box = _tmp32_;
	_tmp33_ = self->priv->new_game_button;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) face_box);
	gtk_widget_show ((GtkWidget*) face_box);
	_tmp34_ = gno_mine_load_face_image (self, "face-win.svg");
	_g_object_unref0 (self->priv->win_face_image);
	self->priv->win_face_image = _tmp34_;
	_tmp35_ = gno_mine_load_face_image (self, "face-sad.svg");
	_g_object_unref0 (self->priv->sad_face_image);
	self->priv->sad_face_image = _tmp35_;
	_tmp36_ = gno_mine_load_face_image (self, "face-smile.svg");
	_g_object_unref0 (self->priv->smile_face_image);
	self->priv->smile_face_image = _tmp36_;
	_tmp37_ = gno_mine_load_face_image (self, "face-cool.svg");
	_g_object_unref0 (self->priv->cool_face_image);
	self->priv->cool_face_image = _tmp37_;
	_tmp38_ = gno_mine_load_face_image (self, "face-worried.svg");
	_g_object_unref0 (self->priv->worried_face_image);
	self->priv->worried_face_image = _tmp38_;
	_tmp39_ = self->priv->win_face_image;
	gtk_box_pack_start (face_box, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
	_tmp40_ = self->priv->sad_face_image;
	gtk_box_pack_start (face_box, (GtkWidget*) _tmp40_, FALSE, FALSE, (guint) 0);
	_tmp41_ = self->priv->smile_face_image;
	gtk_box_pack_start (face_box, (GtkWidget*) _tmp41_, FALSE, FALSE, (guint) 0);
	_tmp42_ = self->priv->cool_face_image;
	gtk_box_pack_start (face_box, (GtkWidget*) _tmp42_, FALSE, FALSE, (guint) 0);
	_tmp43_ = self->priv->worried_face_image;
	gtk_box_pack_start (face_box, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 0);
	_tmp44_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp45_ = g_object_ref_sink (_tmp44_);
	box = _tmp45_;
	gtk_widget_show ((GtkWidget*) box);
	gtk_box_pack_start (status_box, (GtkWidget*) box, FALSE, FALSE, (guint) 0);
	_tmp46_ = _ ("Time: ");
	_tmp47_ = (GtkLabel*) gtk_label_new (_tmp46_);
	_tmp48_ = g_object_ref_sink (_tmp47_);
	label = _tmp48_;
	gtk_box_pack_start (box, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	_tmp49_ = games_clock_new ();
	_tmp50_ = g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->clock);
	self->priv->clock = _tmp50_;
	_tmp51_ = self->priv->clock;
	gtk_widget_show ((GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->clock;
	gtk_box_pack_start (box, (GtkWidget*) _tmp52_, FALSE, FALSE, (guint) 0);
	_tmp53_ = minefield_view_new ();
	_tmp54_ = g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->minefield_view);
	self->priv->minefield_view = _tmp54_;
	_tmp55_ = self->priv->minefield_view;
	_tmp56_ = self->priv->settings;
	_tmp57_ = g_settings_get_boolean (_tmp56_, GNO_MINE_KEY_USE_QUESTION_MARKS);
	minefield_view_set_use_question_marks (_tmp55_, _tmp57_);
	_tmp58_ = self->priv->minefield_view;
	_tmp59_ = self->priv->settings;
	_tmp60_ = g_settings_get_boolean (_tmp59_, GNO_MINE_KEY_USE_OVERMINE_WARNING);
	minefield_view_set_use_overmine_warning (_tmp58_, _tmp60_);
	_tmp61_ = self->priv->minefield_view;
	_tmp62_ = self->priv->settings;
	_tmp63_ = g_settings_get_boolean (_tmp62_, GNO_MINE_KEY_USE_AUTOFLAG);
	minefield_view_set_use_autoflag (_tmp61_, _tmp63_);
	_tmp64_ = self->priv->minefield_view;
	g_signal_connect_object ((GtkWidget*) _tmp64_, "button-press-event", (GCallback) _gno_mine_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp65_ = self->priv->minefield_view;
	g_signal_connect_object (_tmp65_, "look", (GCallback) _gno_mine_look_cb_minefield_view_look, self, 0);
	_tmp66_ = self->priv->minefield_view;
	g_signal_connect_object (_tmp66_, "unlook", (GCallback) _gno_mine_unlook_cb_minefield_view_unlook, self, 0);
	_tmp67_ = self->priv->minefield_view;
	gtk_widget_show ((GtkWidget*) _tmp67_);
	_tmp68_ = self->priv->minefield_view;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp68_, TRUE, TRUE, (guint) 0);
	gno_mine_new_game (self);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	_g_object_unref0 (face_box);
	_g_object_unref0 (new_game_button_alignment);
	_g_object_unref0 (status_box);
	_g_object_unref0 (vbox);
	_g_object_unref0 (menubar);
	_g_object_unref0 (ui_manager);
	_g_object_unref0 (main_vbox);
	return self;
}


GnoMine* gno_mine_new (void) {
	return gno_mine_construct (TYPE_GNO_MINE);
}


void gno_mine_start (GnoMine* self) {
	GtkWindow* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->win_face_image;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->sad_face_image;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->cool_face_image;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->worried_face_image;
	gtk_widget_hide ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->smile_face_image;
	gno_mine_set_face_image (self, _tmp5_);
}


static void gno_mine_real_activate (GApplication* base) {
	GnoMine * self;
	GtkWindow* _tmp0_;
	self = (GnoMine*) base;
	_tmp0_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


static GtkImage* gno_mine_load_face_image (GnoMine* self, const gchar* name) {
	GtkImage* result = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* image;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* filename;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	image = _tmp1_;
	_tmp2_ = name;
	_tmp3_ = g_build_filename (DATA_DIRECTORY, _tmp2_, NULL);
	filename = _tmp3_;
	_tmp4_ = filename;
	if (_tmp4_ != NULL) {
		GtkImage* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = image;
		_tmp6_ = filename;
		gtk_image_set_from_file (_tmp5_, _tmp6_);
	}
	result = image;
	_g_free0 (filename);
	return result;
}


static void gno_mine_set_face_image (GnoMine* self, GtkImage* face_image) {
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	gboolean _tmp4_ = FALSE;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkAction* _tmp9_;
	gboolean _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (face_image != NULL);
	_tmp0_ = self->priv->current_face_image;
	_tmp1_ = face_image;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->current_face_image;
	if (_tmp2_ != NULL) {
		GtkImage* _tmp3_;
		_tmp3_ = self->priv->current_face_image;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
	_tmp5_ = face_image;
	_tmp6_ = self->priv->cool_face_image;
	if (_tmp5_ == _tmp6_) {
		_tmp4_ = TRUE;
	} else {
		GtkImage* _tmp7_;
		GtkImage* _tmp8_;
		_tmp7_ = face_image;
		_tmp8_ = self->priv->smile_face_image;
		_tmp4_ = _tmp7_ == _tmp8_;
	}
	_tmp9_ = self->priv->hint_action;
	_tmp10_ = _tmp4_;
	gtk_action_set_sensitive (_tmp9_, _tmp10_);
	_tmp11_ = face_image;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = face_image;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->current_face_image);
	self->priv->current_face_image = _tmp13_;
}


static gboolean gno_mine_view_button_press_event (GnoMine* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GamesPauseAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->pause_action;
	_tmp1_ = games_pause_action_get_is_paused (_tmp0_);
	if (_tmp1_) {
		GamesPauseAction* _tmp2_;
		_tmp2_ = self->priv->pause_action;
		games_pause_action_set_is_paused (_tmp2_, FALSE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void gno_mine_quit_game_cb (GnoMine* self) {
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void gno_mine_update_flag_label (GnoMine* self) {
	GtkLabel* _tmp0_;
	Minefield* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	Minefield* _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flag_label;
	_tmp1_ = self->priv->minefield;
	_tmp2_ = minefield_get_n_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->minefield;
	_tmp5_ = _tmp4_->n_mines;
	_tmp6_ = g_strdup_printf ("Flags: %u/%u", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_text (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
}


static gint gno_mine_show_scores (GnoMine* self, gint pos, gboolean endofgame) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = endofgame;
	if (_tmp1_) {
		gint _tmp2_;
		_tmp2_ = pos;
		_tmp0_ = _tmp2_ <= 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GtkWindow* _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GtkMessageDialog* _tmp7_;
		GtkMessageDialog* _tmp8_;
		GtkMessageDialog* dialog;
		GtkMessageDialog* _tmp9_;
		const gchar* _tmp10_ = NULL;
		GtkMessageDialog* _tmp11_;
		GtkMessageDialog* _tmp12_;
		GtkMessageDialog* _tmp13_;
		gint _tmp14_ = 0;
		gint _result_;
		GtkMessageDialog* _tmp15_;
		_tmp4_ = self->priv->window;
		_tmp5_ = _ ("The Mines Have Been Cleared!");
		_tmp6_ = _ ("Great work, but unfortunately your score did not make the top ten.");
		_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp4_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "<b>%s</b>\n%s", _tmp5_, _tmp6_);
		_tmp8_ = g_object_ref_sink (_tmp7_);
		dialog = _tmp8_;
		_tmp9_ = dialog;
		_tmp10_ = _ ("_New Game");
		gtk_dialog_add_buttons ((GtkDialog*) _tmp9_, GTK_STOCK_QUIT, GTK_RESPONSE_REJECT, _tmp10_, GTK_RESPONSE_ACCEPT, NULL, NULL);
		_tmp11_ = dialog;
		gtk_dialog_set_default_response ((GtkDialog*) _tmp11_, (gint) GTK_RESPONSE_ACCEPT);
		_tmp12_ = dialog;
		gtk_window_set_title ((GtkWindow*) _tmp12_, "");
		_tmp13_ = dialog;
		_tmp14_ = gtk_dialog_run ((GtkDialog*) _tmp13_);
		_result_ = _tmp14_;
		_tmp15_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp15_);
		result = _result_;
		_g_object_unref0 (dialog);
		return result;
	} else {
		GtkWindow* _tmp16_;
		GamesScores* _tmp17_;
		const gchar* _tmp18_ = NULL;
		GamesScoresDialog* _tmp19_;
		GamesScoresDialog* _tmp20_;
		GamesScoresDialog* dialog;
		GamesScoresDialog* _tmp21_;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_;
		gboolean _tmp36_;
		GamesScoresDialog* _tmp39_;
		gint _tmp40_ = 0;
		gint _result_;
		GamesScoresDialog* _tmp41_;
		_tmp16_ = self->priv->window;
		_tmp17_ = self->priv->highscores;
		_tmp18_ = _ ("Mines Scores");
		_tmp19_ = games_scores_dialog_new (_tmp16_, _tmp17_, _tmp18_);
		_tmp20_ = g_object_ref_sink (_tmp19_);
		dialog = _tmp20_;
		_tmp21_ = dialog;
		_tmp22_ = _ ("Size:");
		games_scores_dialog_set_category_description (_tmp21_, _tmp22_);
		_tmp23_ = pos;
		if (_tmp23_ > 0) {
			GamesScoresDialog* _tmp24_;
			gint _tmp25_;
			const gchar* _tmp26_ = NULL;
			gint _tmp27_;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* message;
			GamesScoresDialog* _tmp33_;
			const gchar* _tmp34_;
			_tmp24_ = dialog;
			_tmp25_ = pos;
			games_scores_dialog_set_hilight (_tmp24_, (guint) _tmp25_);
			_tmp27_ = pos;
			if (_tmp27_ == 1) {
				const gchar* _tmp28_ = NULL;
				_tmp28_ = _ ("Your score is the best!");
				_tmp26_ = _tmp28_;
			} else {
				const gchar* _tmp29_ = NULL;
				_tmp29_ = _ ("Your score has made the top ten.");
				_tmp26_ = _tmp29_;
			}
			_tmp30_ = _ ("Congratulations!");
			_tmp31_ = _tmp26_;
			_tmp32_ = g_strdup_printf ("<b>%s</b>\n\n%s", _tmp30_, _tmp31_);
			message = _tmp32_;
			_tmp33_ = dialog;
			_tmp34_ = message;
			games_scores_dialog_set_message (_tmp33_, _tmp34_);
			_g_free0 (message);
		} else {
			GamesScoresDialog* _tmp35_;
			_tmp35_ = dialog;
			games_scores_dialog_set_message (_tmp35_, NULL);
		}
		_tmp36_ = endofgame;
		if (_tmp36_) {
			GamesScoresDialog* _tmp37_;
			_tmp37_ = dialog;
			games_scores_dialog_set_buttons (_tmp37_, (guint) (GAMES_SCORES_QUIT_BUTTON | GAMES_SCORES_NEW_GAME_BUTTON));
		} else {
			GamesScoresDialog* _tmp38_;
			_tmp38_ = dialog;
			games_scores_dialog_set_buttons (_tmp38_, (guint) 0);
		}
		_tmp39_ = dialog;
		_tmp40_ = gtk_dialog_run ((GtkDialog*) _tmp39_);
		_result_ = _tmp40_;
		_tmp41_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp41_);
		result = _result_;
		_g_object_unref0 (dialog);
		return result;
	}
}


static void gno_mine_scores_cb (GnoMine* self) {
	g_return_if_fail (self != NULL);
	gno_mine_show_scores (self, 0, FALSE);
}


static void _gno_mine_marks_changed_cb_minefield_marks_changed (Minefield* _sender, gpointer self) {
	gno_mine_marks_changed_cb (self, _sender);
}


static void _gno_mine_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	gno_mine_explode_cb (self, _sender);
}


static void _gno_mine_cleared_cb_minefield_cleared (Minefield* _sender, gpointer self) {
	gno_mine_cleared_cb (self, _sender);
}


static void gno_mine_new_game (GnoMine* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Minefield* _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	GamesClock* _tmp26_;
	GtkImage* _tmp27_;
	gint x = 0;
	gint y = 0;
	gint n = 0;
	gchar* _tmp28_;
	gchar* score_key;
	GSettings* _tmp29_;
	gint _tmp30_ = 0;
	GamesScores* _tmp46_;
	const gchar* _tmp47_;
	Minefield* _tmp48_;
	gint _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	Minefield* _tmp53_;
	Minefield* _tmp54_;
	Minefield* _tmp55_;
	Minefield* _tmp56_;
	MinefieldView* _tmp57_;
	Minefield* _tmp58_;
	GamesPauseAction* _tmp59_;
	MinefieldView* _tmp60_;
	g_return_if_fail (self != NULL);
	_tmp3_ = self->priv->minefield;
	if (_tmp3_ != NULL) {
		Minefield* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp4_ = self->priv->minefield;
		_tmp5_ = minefield_get_n_cleared (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		Minefield* _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = self->priv->minefield;
		_tmp9_ = _tmp8_->exploded;
		_tmp1_ = !_tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		Minefield* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->minefield;
		_tmp12_ = minefield_get_is_complete (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp0_ = !_tmp13_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp14_ = _tmp0_;
	if (_tmp14_) {
		GtkWindow* _tmp15_;
		const gchar* _tmp16_ = NULL;
		GtkMessageDialog* _tmp17_;
		GtkMessageDialog* _tmp18_;
		GtkMessageDialog* dialog;
		GtkMessageDialog* _tmp19_;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GtkMessageDialog* _tmp22_;
		gint _tmp23_ = 0;
		gint _result_;
		GtkMessageDialog* _tmp24_;
		gint _tmp25_;
		_tmp15_ = self->priv->window;
		_tmp16_ = _ ("Cancel current game?");
		_tmp17_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp15_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _tmp16_);
		_tmp18_ = g_object_ref_sink (_tmp17_);
		dialog = _tmp18_;
		_tmp19_ = dialog;
		_tmp20_ = _ ("Start New Game");
		_tmp21_ = _ ("Keep Current Game");
		gtk_dialog_add_buttons ((GtkDialog*) _tmp19_, _tmp20_, GTK_RESPONSE_ACCEPT, _tmp21_, GTK_RESPONSE_REJECT, NULL, NULL);
		_tmp22_ = dialog;
		_tmp23_ = gtk_dialog_run ((GtkDialog*) _tmp22_);
		_result_ = _tmp23_;
		_tmp24_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp24_);
		_tmp25_ = _result_;
		if (_tmp25_ == ((gint) GTK_RESPONSE_REJECT)) {
			_g_object_unref0 (dialog);
			return;
		}
		_g_object_unref0 (dialog);
	}
	_tmp26_ = self->priv->clock;
	games_clock_reset (_tmp26_);
	_tmp27_ = self->priv->smile_face_image;
	gno_mine_set_face_image (self, _tmp27_);
	_tmp28_ = g_strdup ("");
	score_key = _tmp28_;
	_tmp29_ = self->priv->settings;
	_tmp30_ = g_settings_get_int (_tmp29_, GNO_MINE_KEY_MODE);
	switch (_tmp30_) {
		case 0:
		{
			gchar* _tmp31_;
			x = 8;
			y = 8;
			n = 10;
			_tmp31_ = g_strdup ("Small");
			_g_free0 (score_key);
			score_key = _tmp31_;
			break;
		}
		case 1:
		{
			gchar* _tmp32_;
			x = 16;
			y = 16;
			n = 40;
			_tmp32_ = g_strdup ("Medium");
			_g_free0 (score_key);
			score_key = _tmp32_;
			break;
		}
		case 2:
		{
			gchar* _tmp33_;
			x = 30;
			y = 16;
			n = 99;
			_tmp33_ = g_strdup ("Large");
			_g_free0 (score_key);
			score_key = _tmp33_;
			break;
		}
		default:
		case 3:
		{
			GSettings* _tmp34_;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			GSettings* _tmp37_;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			GSettings* _tmp40_;
			gint _tmp41_ = 0;
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_ = 0;
			gchar* _tmp45_;
			_tmp34_ = self->priv->settings;
			_tmp35_ = g_settings_get_int (_tmp34_, GNO_MINE_KEY_XSIZE);
			_tmp36_ = CLAMP (_tmp35_, GNO_MINE_XSIZE_MIN, GNO_MINE_XSIZE_MAX);
			x = _tmp36_;
			_tmp37_ = self->priv->settings;
			_tmp38_ = g_settings_get_int (_tmp37_, GNO_MINE_KEY_YSIZE);
			_tmp39_ = CLAMP (_tmp38_, GNO_MINE_YSIZE_MIN, GNO_MINE_YSIZE_MAX);
			y = _tmp39_;
			_tmp40_ = self->priv->settings;
			_tmp41_ = g_settings_get_int (_tmp40_, GNO_MINE_KEY_NMINES);
			_tmp42_ = x;
			_tmp43_ = y;
			_tmp44_ = CLAMP (_tmp41_, 1, (_tmp42_ * _tmp43_) - 10);
			n = _tmp44_;
			_tmp45_ = g_strdup ("Custom");
			_g_free0 (score_key);
			score_key = _tmp45_;
			break;
		}
	}
	_tmp46_ = self->priv->highscores;
	_tmp47_ = score_key;
	games_scores_set_category (_tmp46_, _tmp47_);
	_tmp48_ = self->priv->minefield;
	if (_tmp48_ != NULL) {
		Minefield* _tmp49_;
		_tmp49_ = self->priv->minefield;
		g_signal_handlers_disconnect_by_func (_tmp49_, NULL, self);
	}
	_tmp50_ = x;
	_tmp51_ = y;
	_tmp52_ = n;
	_tmp53_ = minefield_new ((guint) _tmp50_, (guint) _tmp51_, (guint) _tmp52_);
	_minefield_unref0 (self->priv->minefield);
	self->priv->minefield = _tmp53_;
	_tmp54_ = self->priv->minefield;
	g_signal_connect_object (_tmp54_, "marks-changed", (GCallback) _gno_mine_marks_changed_cb_minefield_marks_changed, self, 0);
	_tmp55_ = self->priv->minefield;
	g_signal_connect_object (_tmp55_, "explode", (GCallback) _gno_mine_explode_cb_minefield_explode, self, 0);
	_tmp56_ = self->priv->minefield;
	g_signal_connect_object (_tmp56_, "cleared", (GCallback) _gno_mine_cleared_cb_minefield_cleared, self, 0);
	_tmp57_ = self->priv->minefield_view;
	_tmp58_ = self->priv->minefield;
	minefield_view_set_minefield (_tmp57_, _tmp58_);
	gno_mine_update_flag_label (self);
	_tmp59_ = self->priv->pause_action;
	gtk_action_set_sensitive ((GtkAction*) _tmp59_, TRUE);
	_tmp60_ = self->priv->minefield_view;
	minefield_view_set_paused (_tmp60_, FALSE);
	_g_free0 (score_key);
}


static void gno_mine_hint_cb (GnoMine* self) {
	guint x = 0U;
	guint y = 0U;
	Minefield* _tmp0_;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	Minefield* _tmp3_;
	GamesClock* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->minefield;
	minefield_hint (_tmp0_, &_tmp1_, &_tmp2_);
	x = _tmp1_;
	y = _tmp2_;
	_tmp3_ = self->priv->minefield;
	minefield_clear_mine (_tmp3_, x, y);
	_tmp4_ = self->priv->clock;
	games_clock_add_seconds (_tmp4_, (time_t) 10);
}


static void gno_mine_new_game_cb (GnoMine* self) {
	g_return_if_fail (self != NULL);
	gno_mine_new_game (self);
}


static void gno_mine_pause_cb (GnoMine* self, GtkAction* action) {
	GamesPauseAction* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->pause_action;
	_tmp1_ = games_pause_action_get_is_paused (_tmp0_);
	if (_tmp1_) {
		MinefieldView* _tmp2_;
		GtkAction* _tmp3_;
		GamesClock* _tmp4_;
		_tmp2_ = self->priv->minefield_view;
		minefield_view_set_paused (_tmp2_, TRUE);
		_tmp3_ = self->priv->hint_action;
		gtk_action_set_sensitive (_tmp3_, FALSE);
		_tmp4_ = self->priv->clock;
		games_clock_stop (_tmp4_);
	} else {
		MinefieldView* _tmp5_;
		GtkAction* _tmp6_;
		GamesClock* _tmp7_;
		_tmp5_ = self->priv->minefield_view;
		minefield_view_set_paused (_tmp5_, FALSE);
		_tmp6_ = self->priv->hint_action;
		gtk_action_set_sensitive (_tmp6_, TRUE);
		_tmp7_ = self->priv->clock;
		games_clock_start (_tmp7_);
	}
}


static void gno_mine_marks_changed_cb (GnoMine* self, Minefield* minefield) {
	GamesClock* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	gno_mine_update_flag_label (self);
	_tmp0_ = self->priv->clock;
	games_clock_start (_tmp0_);
}


static void gno_mine_explode_cb (GnoMine* self, Minefield* minefield) {
	GtkImage* _tmp0_;
	GtkButton* _tmp1_;
	GamesClock* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = self->priv->sad_face_image;
	gno_mine_set_face_image (self, _tmp0_);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->clock;
	games_clock_stop (_tmp2_);
}


static void gno_mine_cleared_cb (GnoMine* self, Minefield* minefield) {
	GamesClock* _tmp0_;
	GtkButton* _tmp1_;
	GtkImage* _tmp2_;
	GamesClock* _tmp3_;
	time_t _tmp4_ = 0;
	time_t seconds;
	GamesScores* _tmp5_;
	time_t _tmp6_;
	time_t _tmp7_;
	gint _tmp8_ = 0;
	gint pos;
	gint _tmp9_;
	gint _tmp10_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	_tmp0_ = self->priv->clock;
	games_clock_stop (_tmp0_);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->win_face_image;
	gno_mine_set_face_image (self, _tmp2_);
	_tmp3_ = self->priv->clock;
	_tmp4_ = games_clock_get_seconds (_tmp3_);
	seconds = _tmp4_;
	_tmp5_ = self->priv->highscores;
	_tmp6_ = seconds;
	_tmp7_ = seconds;
	_tmp8_ = games_scores_add_time_score (_tmp5_, (gdouble) (((gfloat) (_tmp6_ / 60)) + (((gfloat) (_tmp7_ % 60)) / 100)));
	pos = _tmp8_;
	_tmp9_ = pos;
	_tmp10_ = gno_mine_show_scores (self, _tmp9_, TRUE);
	if (_tmp10_ == ((gint) GTK_RESPONSE_REJECT)) {
		GtkWindow* _tmp11_;
		_tmp11_ = self->priv->window;
		gtk_widget_destroy ((GtkWidget*) _tmp11_);
	} else {
		gno_mine_new_game (self);
	}
}


static void gno_mine_look_cb (GnoMine* self, MinefieldView* minefield_view) {
	GtkImage* _tmp0_;
	GamesClock* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield_view != NULL);
	_tmp0_ = self->priv->worried_face_image;
	gno_mine_set_face_image (self, _tmp0_);
	_tmp1_ = self->priv->clock;
	games_clock_start (_tmp1_);
}


static void gno_mine_unlook_cb (GnoMine* self, MinefieldView* minefield_view) {
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield_view != NULL);
	_tmp0_ = self->priv->cool_face_image;
	gno_mine_set_face_image (self, _tmp0_);
}


static void gno_mine_about_cb (GnoMine* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_ = NULL;
	gchar** authors;
	gint authors_length1;
	gint _authors_size_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_ = NULL;
	gchar** artists;
	gint artists_length1;
	gint _artists_size_;
	gchar* _tmp24_;
	gchar** _tmp25_ = NULL;
	gchar** documenters;
	gint documenters_length1;
	gint _documenters_size_;
	GtkWindow* _tmp26_;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Main game:");
	_tmp1_ = g_strdup (_tmp0_);
	_tmp2_ = g_strdup ("Pista");
	_tmp3_ = g_strdup ("Szekeres Istvan");
	_tmp4_ = g_strdup ("Robert Ancell");
	_tmp5_ = g_strdup ("");
	_tmp6_ = _ ("Score:");
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = g_strdup ("Horacio J. Pe\xc3\xb1a");
	_tmp9_ = g_strdup ("");
	_tmp10_ = _ ("Resizing and SVG support:");
	_tmp11_ = g_strdup (_tmp10_);
	_tmp12_ = g_strdup ("Steve Chaplin");
	_tmp13_ = g_strdup ("Callum McKenzie");
	_tmp14_ = g_new0 (gchar*, 12 + 1);
	_tmp14_[0] = _tmp1_;
	_tmp14_[1] = _tmp2_;
	_tmp14_[2] = _tmp3_;
	_tmp14_[3] = _tmp4_;
	_tmp14_[4] = _tmp5_;
	_tmp14_[5] = _tmp7_;
	_tmp14_[6] = _tmp8_;
	_tmp14_[7] = _tmp9_;
	_tmp14_[8] = _tmp11_;
	_tmp14_[9] = _tmp12_;
	_tmp14_[10] = _tmp13_;
	_tmp14_[11] = NULL;
	authors = _tmp14_;
	authors_length1 = 12;
	_authors_size_ = authors_length1;
	_tmp15_ = _ ("Faces:");
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = g_strdup ("tigert");
	_tmp18_ = g_strdup ("Lapo Calamandrei and Ulisse Perusin");
	_tmp19_ = g_strdup ("");
	_tmp20_ = _ ("Graphics:");
	_tmp21_ = g_strdup (_tmp20_);
	_tmp22_ = g_strdup ("Richard Hoelscher");
	_tmp23_ = g_new0 (gchar*, 7 + 1);
	_tmp23_[0] = _tmp16_;
	_tmp23_[1] = _tmp17_;
	_tmp23_[2] = _tmp18_;
	_tmp23_[3] = _tmp19_;
	_tmp23_[4] = _tmp21_;
	_tmp23_[5] = _tmp22_;
	_tmp23_[6] = NULL;
	artists = _tmp23_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp24_ = g_strdup ("Callum McKenzie");
	_tmp25_ = g_new0 (gchar*, 2 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp25_[1] = NULL;
	documenters = _tmp25_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp26_ = self->priv->window;
	_tmp27_ = _ ("Mines");
	_tmp28_ = _ ("The popular logic puzzle minesweeper. Clear mines from a board using h" \
"ints from squares you have already uncovered.\n" \
"\n" \
"Mines is a part of GNOME Games.");
	_tmp29_ = _ ("Mines");
	_tmp30_ = games_get_license (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = _ ("translator-credits");
	_tmp33_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp26_, "name", _tmp27_, "version", VERSION, "comments", _tmp28_, "copyright", "Copyright \xc2\xa9 1997-2008 Free Software Foundation, Inc.", "license", _tmp31_, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _tmp32_, "logo-icon-name", "gnomine", "website", "http://www.gnome.org/projects/gnome-games/", "website-label", _tmp33_, "wrap-license", TRUE, NULL, NULL);
	_g_free0 (_tmp31_);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void gno_mine_set_n_mines_limit (GnoMine* self) {
	GSettings* _tmp0_;
	gint _tmp1_ = 0;
	GSettings* _tmp2_;
	gint _tmp3_ = 0;
	gint max_mines;
	GSettings* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	GtkSpinButton* _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_int (_tmp0_, GNO_MINE_KEY_XSIZE);
	_tmp2_ = self->priv->settings;
	_tmp3_ = g_settings_get_int (_tmp2_, GNO_MINE_KEY_YSIZE);
	max_mines = (_tmp1_ * _tmp3_) - 10;
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_int (_tmp4_, GNO_MINE_KEY_NMINES);
	_tmp6_ = max_mines;
	if (_tmp5_ > _tmp6_) {
		GSettings* _tmp7_;
		gint _tmp8_;
		GtkSpinButton* _tmp9_;
		gint _tmp10_;
		_tmp7_ = self->priv->settings;
		_tmp8_ = max_mines;
		g_settings_set_int (_tmp7_, GNO_MINE_KEY_NMINES, _tmp8_);
		_tmp9_ = self->priv->n_mines_spin;
		_tmp10_ = max_mines;
		gtk_spin_button_set_value (_tmp9_, (gdouble) _tmp10_);
	}
	_tmp11_ = self->priv->n_mines_spin;
	_tmp12_ = max_mines;
	gtk_spin_button_set_range (_tmp11_, (gdouble) 1, (gdouble) _tmp12_);
}


static void gno_mine_xsize_spin_cb (GnoMine* self, GtkSpinButton* spin) {
	GtkSpinButton* _tmp0_;
	gint _tmp1_ = 0;
	gint xsize;
	gint _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_ = 0;
	GSettings* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	xsize = _tmp1_;
	_tmp2_ = xsize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, GNO_MINE_KEY_XSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = xsize;
	g_settings_set_int (_tmp5_, GNO_MINE_KEY_XSIZE, _tmp6_);
	gno_mine_set_n_mines_limit (self);
	gno_mine_new_game (self);
}


static void gno_mine_ysize_spin_cb (GnoMine* self, GtkSpinButton* spin) {
	GtkSpinButton* _tmp0_;
	gint _tmp1_ = 0;
	gint ysize;
	gint _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_ = 0;
	GSettings* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	ysize = _tmp1_;
	_tmp2_ = ysize;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, GNO_MINE_KEY_YSIZE);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = ysize;
	g_settings_set_int (_tmp5_, GNO_MINE_KEY_YSIZE, _tmp6_);
	gno_mine_set_n_mines_limit (self);
	gno_mine_new_game (self);
}


static void gno_mine_n_mines_spin_cb (GnoMine* self, GtkSpinButton* spin) {
	GtkSpinButton* _tmp0_;
	gint _tmp1_ = 0;
	gint n_mines;
	gint _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_ = 0;
	GSettings* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spin != NULL);
	_tmp0_ = spin;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	n_mines = _tmp1_;
	_tmp2_ = n_mines;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_int (_tmp3_, GNO_MINE_KEY_NMINES);
	if (_tmp2_ == _tmp4_) {
		return;
	}
	_tmp5_ = self->priv->settings;
	_tmp6_ = n_mines;
	g_settings_set_int (_tmp5_, GNO_MINE_KEY_NMINES, _tmp6_);
	gno_mine_new_game (self);
}


static void gno_mine_use_question_toggle_cb (GnoMine* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean use_question_marks;
	GSettings* _tmp2_;
	MinefieldView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	use_question_marks = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, GNO_MINE_KEY_USE_QUESTION_MARKS, use_question_marks);
	_tmp3_ = self->priv->minefield_view;
	minefield_view_set_use_question_marks (_tmp3_, use_question_marks);
}


static void gno_mine_use_overmine_toggle_cb (GnoMine* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean use_overmine_warning;
	GSettings* _tmp2_;
	MinefieldView* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	use_overmine_warning = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, GNO_MINE_KEY_USE_OVERMINE_WARNING, use_overmine_warning);
	_tmp3_ = self->priv->minefield_view;
	minefield_view_set_use_overmine_warning (_tmp3_, use_overmine_warning);
}


static void _gno_mine_small_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	gno_mine_small_size_toggled_cb (self, _sender);
}


static void _gno_mine_medium_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	gno_mine_medium_size_toggled_cb (self, _sender);
}


static void _gno_mine_large_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	gno_mine_large_size_toggled_cb (self, _sender);
}


static void _gno_mine_custom_size_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	gno_mine_custom_size_toggled_cb (self, _sender);
}


static void _gno_mine_xsize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	gno_mine_xsize_spin_cb (self, _sender);
}


static void _gno_mine_ysize_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	gno_mine_ysize_spin_cb (self, _sender);
}


static void _gno_mine_n_mines_spin_cb_gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	gno_mine_n_mines_spin_cb (self, _sender);
}


static void _gno_mine_use_question_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	gno_mine_use_question_toggle_cb (self, _sender);
}


static void _gno_mine_use_overmine_toggle_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	gno_mine_use_overmine_toggle_cb (self, _sender);
}


static void _gno_mine_pref_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	gno_mine_pref_response_cb (self, _sender, response_id);
}


static gboolean _gno_mine_pref_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = gno_mine_pref_delete_event_cb (self, _sender, event);
	return result;
}


static GtkDialog* gno_mine_create_preferences (GnoMine* self) {
	GtkDialog* result = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* grid;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GamesFrame* _tmp6_;
	GamesFrame* _tmp7_;
	GamesFrame* frame;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* vbox;
	const gchar* _tmp10_ = NULL;
	GtkRadioButton* _tmp11_;
	GtkRadioButton* _tmp12_;
	GtkRadioButton* small_button;
	GtkRadioButton* _tmp13_;
	GtkBox* _tmp14_;
	GtkRadioButton* _tmp15_;
	GtkRadioButton* _tmp16_;
	GSList* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkRadioButton* _tmp19_;
	GtkRadioButton* _tmp20_;
	GtkRadioButton* medium_button;
	GtkRadioButton* _tmp21_;
	GtkBox* _tmp22_;
	GtkRadioButton* _tmp23_;
	GtkRadioButton* _tmp24_;
	GSList* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	GtkRadioButton* _tmp27_;
	GtkRadioButton* _tmp28_;
	GtkRadioButton* large_button;
	GtkRadioButton* _tmp29_;
	GtkBox* _tmp30_;
	GtkRadioButton* _tmp31_;
	GtkRadioButton* _tmp32_;
	GSList* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	GtkRadioButton* _tmp35_;
	GtkRadioButton* _tmp36_;
	GtkRadioButton* custom_button;
	GtkRadioButton* _tmp37_;
	GtkBox* _tmp38_;
	GtkRadioButton* _tmp39_;
	GSettings* _tmp40_;
	gint _tmp41_ = 0;
	GamesFrame* _tmp46_;
	GtkBox* _tmp47_;
	GtkGrid* _tmp48_;
	GamesFrame* _tmp49_;
	const gchar* _tmp50_ = NULL;
	GamesFrame* _tmp51_;
	GamesFrame* _tmp52_;
	GamesFrame* _tmp53_;
	GSettings* _tmp54_;
	gint _tmp55_ = 0;
	GtkGrid* _tmp56_;
	GtkGrid* _tmp57_;
	GtkGrid* custom_field_grid;
	GamesFrame* _tmp58_;
	const gchar* _tmp59_ = NULL;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* label;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	GtkSpinButton* _tmp64_;
	GtkSpinButton* _tmp65_;
	GtkSpinButton* field_width_entry;
	GSettings* _tmp66_;
	gint _tmp67_ = 0;
	GtkLabel* _tmp68_;
	const gchar* _tmp69_ = NULL;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkLabel* _tmp73_;
	GtkSpinButton* _tmp74_;
	GtkSpinButton* _tmp75_;
	GtkSpinButton* field_height_entry;
	GSettings* _tmp76_;
	gint _tmp77_ = 0;
	GtkLabel* _tmp78_;
	const gchar* _tmp79_ = NULL;
	GtkLabel* _tmp80_;
	GtkLabel* _tmp81_;
	GtkLabel* _tmp82_;
	GtkLabel* _tmp83_;
	GtkSpinButton* _tmp84_;
	GtkSpinButton* _tmp85_;
	GtkSpinButton* _tmp86_;
	GtkSpinButton* _tmp87_;
	GSettings* _tmp88_;
	gint _tmp89_ = 0;
	GtkSpinButton* _tmp90_;
	GtkLabel* _tmp91_;
	GtkSpinButton* _tmp92_;
	GtkGrid* _tmp93_;
	GamesFrame* _tmp94_;
	const gchar* _tmp95_ = NULL;
	GamesFrame* _tmp96_;
	GamesFrame* _tmp97_;
	GtkGrid* _tmp98_;
	GamesFrame* _tmp99_;
	GtkBox* _tmp100_;
	GtkBox* _tmp101_;
	GtkBox* flag_options_vbox;
	GamesFrame* _tmp102_;
	const gchar* _tmp103_ = NULL;
	GtkCheckButton* _tmp104_;
	GtkCheckButton* _tmp105_;
	GtkCheckButton* question_toggle;
	GSettings* _tmp106_;
	gboolean _tmp107_ = FALSE;
	const gchar* _tmp108_ = NULL;
	GtkCheckButton* _tmp109_;
	GtkCheckButton* _tmp110_;
	GtkCheckButton* overmine_toggle;
	GSettings* _tmp111_;
	gboolean _tmp112_ = FALSE;
	const gchar* _tmp113_ = NULL;
	GtkWindow* _tmp114_;
	GtkDialog* _tmp115_;
	GtkDialog* _tmp116_;
	GtkDialog* dialog;
	GtkWidget* _tmp117_ = NULL;
	GtkBox* _tmp118_;
	GtkBox* box;
	GtkGrid* _tmp119_;
	GtkGrid* _tmp120_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	grid = _tmp1_;
	_tmp2_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp2_, (guint) 5);
	_tmp3_ = grid;
	gtk_grid_set_row_spacing (_tmp3_, (guint) 18);
	_tmp4_ = grid;
	gtk_grid_set_column_spacing (_tmp4_, (guint) 18);
	_tmp5_ = _ ("Field Size");
	_tmp6_ = games_frame_new (_tmp5_);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	frame = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	vbox = _tmp9_;
	_tmp10_ = g_dpgettext2 (NULL, "board size", "_Small");
	_tmp11_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _tmp10_);
	_tmp12_ = g_object_ref_sink (_tmp11_);
	small_button = _tmp12_;
	_tmp13_ = small_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp13_, "toggled", (GCallback) _gno_mine_small_size_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp14_ = vbox;
	_tmp15_ = small_button;
	gtk_box_pack_start (_tmp14_, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
	_tmp16_ = small_button;
	_tmp17_ = gtk_radio_button_get_group (_tmp16_);
	_tmp18_ = g_dpgettext2 (NULL, "board size", "_Medium");
	_tmp19_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (_tmp17_, _tmp18_);
	_tmp20_ = g_object_ref_sink (_tmp19_);
	medium_button = _tmp20_;
	_tmp21_ = medium_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp21_, "toggled", (GCallback) _gno_mine_medium_size_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp22_ = vbox;
	_tmp23_ = medium_button;
	gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, FALSE, FALSE, (guint) 0);
	_tmp24_ = medium_button;
	_tmp25_ = gtk_radio_button_get_group (_tmp24_);
	_tmp26_ = g_dpgettext2 (NULL, "board size", "_Large");
	_tmp27_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (_tmp25_, _tmp26_);
	_tmp28_ = g_object_ref_sink (_tmp27_);
	large_button = _tmp28_;
	_tmp29_ = large_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp29_, "toggled", (GCallback) _gno_mine_large_size_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp30_ = vbox;
	_tmp31_ = large_button;
	gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp31_, FALSE, FALSE, (guint) 0);
	_tmp32_ = large_button;
	_tmp33_ = gtk_radio_button_get_group (_tmp32_);
	_tmp34_ = g_dpgettext2 (NULL, "board size", "_Custom");
	_tmp35_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (_tmp33_, _tmp34_);
	_tmp36_ = g_object_ref_sink (_tmp35_);
	custom_button = _tmp36_;
	_tmp37_ = custom_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp37_, "toggled", (GCallback) _gno_mine_custom_size_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp38_ = vbox;
	_tmp39_ = custom_button;
	gtk_box_pack_start (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
	_tmp40_ = self->priv->settings;
	_tmp41_ = g_settings_get_int (_tmp40_, GNO_MINE_KEY_MODE);
	switch (_tmp41_) {
		case 0:
		{
			GtkRadioButton* _tmp42_;
			_tmp42_ = small_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp42_, TRUE);
			break;
		}
		case 1:
		{
			GtkRadioButton* _tmp43_;
			_tmp43_ = medium_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp43_, TRUE);
			break;
		}
		case 2:
		{
			GtkRadioButton* _tmp44_;
			_tmp44_ = large_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp44_, TRUE);
			break;
		}
		default:
		case 3:
		{
			GtkRadioButton* _tmp45_;
			_tmp45_ = custom_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp45_, TRUE);
			break;
		}
	}
	_tmp46_ = frame;
	_tmp47_ = vbox;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = grid;
	_tmp49_ = frame;
	gtk_grid_attach (_tmp48_, (GtkWidget*) _tmp49_, 0, 0, 1, 1);
	_tmp50_ = _ ("Custom Size");
	_tmp51_ = games_frame_new (_tmp50_);
	_tmp52_ = g_object_ref_sink (_tmp51_);
	_g_object_unref0 (self->priv->custom_size_frame);
	self->priv->custom_size_frame = _tmp52_;
	_tmp53_ = self->priv->custom_size_frame;
	_tmp54_ = self->priv->settings;
	_tmp55_ = g_settings_get_int (_tmp54_, GNO_MINE_KEY_MODE);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp53_, _tmp55_ == 3);
	_tmp56_ = (GtkGrid*) gtk_grid_new ();
	_tmp57_ = g_object_ref_sink (_tmp56_);
	custom_field_grid = _tmp57_;
	gtk_grid_set_row_spacing (custom_field_grid, (guint) 6);
	gtk_grid_set_column_spacing (custom_field_grid, (guint) 12);
	_tmp58_ = self->priv->custom_size_frame;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) custom_field_grid);
	_tmp59_ = _ ("_Horizontal:");
	_tmp60_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp59_);
	_tmp61_ = g_object_ref_sink (_tmp60_);
	label = _tmp61_;
	_tmp62_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp62_, (gfloat) 0, 0.5f);
	_tmp63_ = label;
	gtk_grid_attach (custom_field_grid, (GtkWidget*) _tmp63_, 0, 0, 1, 1);
	_tmp64_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) GNO_MINE_XSIZE_MIN, (gdouble) GNO_MINE_XSIZE_MAX, (gdouble) 1);
	_tmp65_ = g_object_ref_sink (_tmp64_);
	field_width_entry = _tmp65_;
	g_signal_connect_object (field_width_entry, "value-changed", (GCallback) _gno_mine_xsize_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp66_ = self->priv->settings;
	_tmp67_ = g_settings_get_int (_tmp66_, GNO_MINE_KEY_XSIZE);
	gtk_spin_button_set_value (field_width_entry, (gdouble) _tmp67_);
	gtk_grid_attach (custom_field_grid, (GtkWidget*) field_width_entry, 1, 0, 1, 1);
	_tmp68_ = label;
	gtk_label_set_mnemonic_widget (_tmp68_, (GtkWidget*) field_width_entry);
	_tmp69_ = _ ("_Vertical:");
	_tmp70_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp69_);
	_tmp71_ = g_object_ref_sink (_tmp70_);
	_g_object_unref0 (label);
	label = _tmp71_;
	_tmp72_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp72_, (gfloat) 0, 0.5f);
	_tmp73_ = label;
	gtk_grid_attach (custom_field_grid, (GtkWidget*) _tmp73_, 0, 1, 1, 1);
	_tmp74_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) GNO_MINE_YSIZE_MIN, (gdouble) GNO_MINE_YSIZE_MAX, (gdouble) 1);
	_tmp75_ = g_object_ref_sink (_tmp74_);
	field_height_entry = _tmp75_;
	g_signal_connect_object (field_height_entry, "value-changed", (GCallback) _gno_mine_ysize_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp76_ = self->priv->settings;
	_tmp77_ = g_settings_get_int (_tmp76_, GNO_MINE_KEY_YSIZE);
	gtk_spin_button_set_value (field_height_entry, (gdouble) _tmp77_);
	gtk_grid_attach (custom_field_grid, (GtkWidget*) field_height_entry, 1, 1, 1, 1);
	_tmp78_ = label;
	gtk_label_set_mnemonic_widget (_tmp78_, (GtkWidget*) field_height_entry);
	_tmp79_ = _ ("_Number of mines:");
	_tmp80_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp79_);
	_tmp81_ = g_object_ref_sink (_tmp80_);
	_g_object_unref0 (label);
	label = _tmp81_;
	_tmp82_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp82_, (gfloat) 0, 0.5f);
	_tmp83_ = label;
	gtk_grid_attach (custom_field_grid, (GtkWidget*) _tmp83_, 0, 2, 1, 1);
	_tmp84_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) (GNO_MINE_XSIZE_MAX * GNO_MINE_YSIZE_MAX), (gdouble) 1);
	_tmp85_ = g_object_ref_sink (_tmp84_);
	_g_object_unref0 (self->priv->n_mines_spin);
	self->priv->n_mines_spin = _tmp85_;
	_tmp86_ = self->priv->n_mines_spin;
	g_signal_connect_object (_tmp86_, "value-changed", (GCallback) _gno_mine_n_mines_spin_cb_gtk_spin_button_value_changed, self, 0);
	_tmp87_ = self->priv->n_mines_spin;
	_tmp88_ = self->priv->settings;
	_tmp89_ = g_settings_get_int (_tmp88_, GNO_MINE_KEY_NMINES);
	gtk_spin_button_set_value (_tmp87_, (gdouble) _tmp89_);
	_tmp90_ = self->priv->n_mines_spin;
	gtk_grid_attach (custom_field_grid, (GtkWidget*) _tmp90_, 1, 2, 1, 1);
	gno_mine_set_n_mines_limit (self);
	_tmp91_ = label;
	_tmp92_ = self->priv->n_mines_spin;
	gtk_label_set_mnemonic_widget (_tmp91_, (GtkWidget*) _tmp92_);
	_tmp93_ = grid;
	_tmp94_ = self->priv->custom_size_frame;
	gtk_grid_attach (_tmp93_, (GtkWidget*) _tmp94_, 1, 0, 1, 1);
	_tmp95_ = _ ("Flags");
	_tmp96_ = games_frame_new (_tmp95_);
	_tmp97_ = g_object_ref_sink (_tmp96_);
	_g_object_unref0 (frame);
	frame = _tmp97_;
	_tmp98_ = grid;
	_tmp99_ = frame;
	gtk_grid_attach (_tmp98_, (GtkWidget*) _tmp99_, 0, 1, 2, 1);
	_tmp100_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_tmp101_ = g_object_ref_sink (_tmp100_);
	flag_options_vbox = _tmp101_;
	gtk_widget_show ((GtkWidget*) flag_options_vbox);
	_tmp102_ = frame;
	gtk_container_add ((GtkContainer*) _tmp102_, (GtkWidget*) flag_options_vbox);
	_tmp103_ = _ ("_Use \"I'm not sure\" flags");
	_tmp104_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp103_);
	_tmp105_ = g_object_ref_sink (_tmp104_);
	question_toggle = _tmp105_;
	g_signal_connect_object ((GtkToggleButton*) question_toggle, "toggled", (GCallback) _gno_mine_use_question_toggle_cb_gtk_toggle_button_toggled, self, 0);
	_tmp106_ = self->priv->settings;
	_tmp107_ = g_settings_get_boolean (_tmp106_, GNO_MINE_KEY_USE_QUESTION_MARKS);
	gtk_toggle_button_set_active ((GtkToggleButton*) question_toggle, _tmp107_);
	gtk_box_pack_start (flag_options_vbox, (GtkWidget*) question_toggle, FALSE, TRUE, (guint) 0);
	_tmp108_ = _ ("_Warn if too many flags placed");
	_tmp109_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp108_);
	_tmp110_ = g_object_ref_sink (_tmp109_);
	overmine_toggle = _tmp110_;
	g_signal_connect_object ((GtkToggleButton*) overmine_toggle, "toggled", (GCallback) _gno_mine_use_overmine_toggle_cb_gtk_toggle_button_toggled, self, 0);
	_tmp111_ = self->priv->settings;
	_tmp112_ = g_settings_get_boolean (_tmp111_, GNO_MINE_KEY_USE_OVERMINE_WARNING);
	gtk_toggle_button_set_active ((GtkToggleButton*) overmine_toggle, _tmp112_);
	gtk_box_pack_start (flag_options_vbox, (GtkWidget*) overmine_toggle, FALSE, TRUE, (guint) 0);
	_tmp113_ = _ ("Mines Preferences");
	_tmp114_ = self->priv->window;
	_tmp115_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp113_, _tmp114_, 0, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
	_tmp116_ = g_object_ref_sink (_tmp115_);
	dialog = _tmp116_;
	gtk_container_set_border_width ((GtkContainer*) dialog, (guint) 5);
	gtk_window_set_resizable ((GtkWindow*) dialog, FALSE);
	_tmp117_ = gtk_dialog_get_content_area (dialog);
	_tmp118_ = _g_object_ref0 (GTK_BOX (_tmp117_));
	box = _tmp118_;
	gtk_box_set_spacing (box, 2);
	_tmp119_ = grid;
	gtk_box_pack_start (box, (GtkWidget*) _tmp119_, FALSE, FALSE, (guint) 0);
	g_signal_connect_object (dialog, "response", (GCallback) _gno_mine_pref_response_cb_gtk_dialog_response, self, 0);
	g_signal_connect_object ((GtkWidget*) dialog, "delete-event", (GCallback) _gno_mine_pref_delete_event_cb_gtk_widget_delete_event, self, 0);
	_tmp120_ = grid;
	gtk_widget_show_all ((GtkWidget*) _tmp120_);
	result = dialog;
	_g_object_unref0 (box);
	_g_object_unref0 (overmine_toggle);
	_g_object_unref0 (question_toggle);
	_g_object_unref0 (flag_options_vbox);
	_g_object_unref0 (field_height_entry);
	_g_object_unref0 (field_width_entry);
	_g_object_unref0 (label);
	_g_object_unref0 (custom_field_grid);
	_g_object_unref0 (custom_button);
	_g_object_unref0 (large_button);
	_g_object_unref0 (medium_button);
	_g_object_unref0 (small_button);
	_g_object_unref0 (vbox);
	_g_object_unref0 (frame);
	_g_object_unref0 (grid);
	return result;
}


static void gno_mine_set_mode (GnoMine* self, gint mode) {
	gint _tmp0_;
	GSettings* _tmp1_;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	gint _tmp4_;
	GamesFrame* _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_int (_tmp1_, GNO_MINE_KEY_MODE);
	if (_tmp0_ == _tmp2_) {
		return;
	}
	_tmp3_ = self->priv->settings;
	_tmp4_ = mode;
	g_settings_set_int (_tmp3_, GNO_MINE_KEY_MODE, _tmp4_);
	_tmp5_ = self->priv->custom_size_frame;
	_tmp6_ = mode;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp6_ == 3);
	gno_mine_new_game (self);
}


static void gno_mine_small_size_toggled_cb (GnoMine* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gno_mine_set_mode (self, 0);
	}
}


static void gno_mine_medium_size_toggled_cb (GnoMine* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gno_mine_set_mode (self, 1);
	}
}


static void gno_mine_large_size_toggled_cb (GnoMine* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gno_mine_set_mode (self, 2);
	}
}


static void gno_mine_custom_size_toggled_cb (GnoMine* self, GtkToggleButton* button) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gno_mine_set_mode (self, 3);
	}
}


static void gno_mine_pref_response_cb (GnoMine* self, GtkDialog* dialog, gint response_id) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->pref_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


static gboolean gno_mine_pref_delete_event_cb (GnoMine* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkDialog* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->pref_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	result = TRUE;
	return result;
}


static void gno_mine_preferences_cb (GnoMine* self) {
	GtkDialog* _tmp0_;
	GtkDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pref_dialog;
	if (_tmp0_ == NULL) {
		GtkDialog* _tmp1_ = NULL;
		_tmp1_ = gno_mine_create_preferences (self);
		_g_object_unref0 (self->priv->pref_dialog);
		self->priv->pref_dialog = _tmp1_;
	}
	_tmp2_ = self->priv->pref_dialog;
	gtk_window_present ((GtkWindow*) _tmp2_);
}


static void gno_mine_help_cb (GnoMine* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "ghelp:gnomine", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("gnomine.vala:701: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _gno_mine_pause_cb_games_pause_action_state_changed (GamesPauseAction* _sender, gpointer self) {
	gno_mine_pause_cb (self, _sender);
}


static GtkUIManager* gno_mine_create_ui_manager (GnoMine* self, const gchar* group) {
	GtkUIManager* result = NULL;
	GtkActionGroup* _tmp0_;
	GtkActionGroup* action_group;
	GtkUIManager* _tmp1_;
	GtkUIManager* ui_manager;
	GtkAction* _tmp2_ = NULL;
	GtkAction* _tmp3_;
	GtkWindow* _tmp4_;
	GamesFullscreenAction* _tmp5_;
	GamesFullscreenAction* _tmp6_;
	GamesPauseAction* _tmp7_;
	GamesPauseAction* _tmp8_;
	GamesPauseAction* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	_tmp0_ = gtk_action_group_new ("group");
	action_group = _tmp0_;
	gtk_action_group_set_translation_domain (action_group, GETTEXT_PACKAGE);
	gtk_action_group_add_actions (action_group, GNO_MINE_actions, G_N_ELEMENTS (GNO_MINE_actions), self);
	_tmp1_ = gtk_ui_manager_new ();
	ui_manager = _tmp1_;
	gtk_ui_manager_insert_action_group (ui_manager, action_group, 0);
	{
		gtk_ui_manager_add_ui_from_string (ui_manager, GNO_MINE_ui_description, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (ui_manager);
		_g_object_unref0 (action_group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = gtk_action_group_get_action (action_group, "Hint");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->hint_action);
	self->priv->hint_action = _tmp3_;
	_tmp4_ = self->priv->window;
	_tmp5_ = games_fullscreen_action_new ("Fullscreen", _tmp4_);
	_g_object_unref0 (self->priv->fullscreen_action);
	self->priv->fullscreen_action = _tmp5_;
	_tmp6_ = self->priv->fullscreen_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp6_, NULL);
	_tmp7_ = games_pause_action_new ("PauseGame");
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp7_;
	_tmp8_ = self->priv->pause_action;
	g_signal_connect_object (_tmp8_, "state-changed", (GCallback) _gno_mine_pause_cb_games_pause_action_state_changed, self, 0);
	_tmp9_ = self->priv->pause_action;
	gtk_action_group_add_action_with_accel (action_group, (GtkAction*) _tmp9_, NULL);
	result = ui_manager;
	_g_object_unref0 (action_group);
	return result;
}


gint gno_mine_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* context;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionGroup* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	GnoMine* _tmp9_;
	GnoMine* app;
	GnoMine* _tmp10_;
	GnoMine* _tmp11_;
	gint _tmp12_ = 0;
	gint _result_;
	GError * _inner_error_ = NULL;
	games_scores_startup ();
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = _ ("Mines");
	g_set_application_name (_tmp8_);
	_tmp9_ = gno_mine_new ();
	app = _tmp9_;
	_tmp10_ = app;
	gno_mine_start (_tmp10_);
	_tmp11_ = app;
	_tmp12_ = g_application_run ((GApplication*) _tmp11_, 0, NULL);
	_result_ = _tmp12_;
	g_settings_sync ();
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return gno_mine_main (argv, argc);
}


static void gno_mine_class_init (GnoMineClass * klass) {
	gno_mine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnoMinePrivate));
	G_APPLICATION_CLASS (klass)->activate = gno_mine_real_activate;
	G_OBJECT_CLASS (klass)->finalize = gno_mine_finalize;
}


static void gno_mine_instance_init (GnoMine * self) {
	self->priv = GNO_MINE_GET_PRIVATE (self);
	self->priv->current_face_image = NULL;
	self->priv->pref_dialog = NULL;
}


static void gno_mine_finalize (GObject* obj) {
	GnoMine * self;
	self = GNO_MINE (obj);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->win_face_image);
	_g_object_unref0 (self->priv->sad_face_image);
	_g_object_unref0 (self->priv->smile_face_image);
	_g_object_unref0 (self->priv->cool_face_image);
	_g_object_unref0 (self->priv->worried_face_image);
	_g_object_unref0 (self->priv->current_face_image);
	_g_object_unref0 (self->priv->window);
	_minefield_unref0 (self->priv->minefield);
	_g_object_unref0 (self->priv->minefield_view);
	_g_object_unref0 (self->priv->pref_dialog);
	_g_object_unref0 (self->priv->flag_label);
	_g_object_unref0 (self->priv->n_mines_spin);
	_g_object_unref0 (self->priv->new_game_button);
	_g_object_unref0 (self->priv->custom_size_frame);
	_g_object_unref0 (self->priv->clock);
	_g_object_unref0 (self->priv->hint_action);
	_g_object_unref0 (self->priv->fullscreen_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->highscores);
	G_OBJECT_CLASS (gno_mine_parent_class)->finalize (obj);
}


GType gno_mine_get_type (void) {
	static volatile gsize gno_mine_type_id__volatile = 0;
	if (g_once_init_enter (&gno_mine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GnoMineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gno_mine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnoMine), 0, (GInstanceInitFunc) gno_mine_instance_init, NULL };
		GType gno_mine_type_id;
		gno_mine_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "GnoMine", &g_define_type_info, 0);
		g_once_init_leave (&gno_mine_type_id__volatile, gno_mine_type_id);
	}
	return gno_mine_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



