/* document_structure.c generated by valac 0.39.2.21-6056, the Vala compiler
 * generated from document_structure.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>


#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _DocumentStructurePrivate DocumentStructurePrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;

#define DOCUMENT_STRUCTURE_TYPE_ENV_DATA (document_structure_env_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _DocumentStructureEnvData DocumentStructureEnvData;
enum  {
	DOCUMENT_STRUCTURE_0_PROPERTY,
	DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY,
	DOCUMENT_STRUCTURE_NUM_PROPERTIES
};
static GParamSpec* document_structure_properties[DOCUMENT_STRUCTURE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _document_structure_env_data_free0(var) ((var == NULL) ? NULL : (var = (document_structure_env_data_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

struct _DocumentStructure {
	GObject parent_instance;
	DocumentStructurePrivate * priv;
};

struct _DocumentStructureClass {
	GObjectClass parent_class;
};

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _DocumentStructureEnvData {
	GtkTreePath* path;
	StructType type;
	gchar* first_caption;
};

struct _DocumentStructurePrivate {
	Document* _doc;
	gint _nb_marks;
	GtkTextMark* _end_document_mark;
	StructureModel* _model;
	gboolean _in_verbatim_env;
	DocumentStructureEnvData* _last_env_data;
	gint _start_parsing_line;
	GTimer* _timer;
	gboolean _parsing_done;
};

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;


static gpointer document_structure_parent_class = NULL;
static GRegex* document_structure__chars_regex;
static GRegex* document_structure__chars_regex = NULL;
static GRegex* document_structure__comment_regex;
static GRegex* document_structure__comment_regex = NULL;
static GRegex* document_structure__command_name_regex;
static GRegex* document_structure__command_name_regex = NULL;
static gchar** document_structure__section_names;
static gint document_structure__section_names_length1;
static gchar** document_structure__section_names = NULL;
static gint document_structure__section_names_length1 = 0;
static gint _document_structure__section_names_size_ = 0;

GType document_structure_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType structure_model_get_type (void) G_GNUC_CONST;
static GType document_structure_env_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType struct_type_get_type (void) G_GNUC_CONST;
static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self);
static void document_structure_env_data_free (DocumentStructureEnvData* self);
static void document_structure_env_data_copy (const DocumentStructureEnvData* self, 
                                       DocumentStructureEnvData* dest);
static void document_structure_env_data_destroy (DocumentStructureEnvData* self);
#define DOCUMENT_STRUCTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_STRUCTURE, DocumentStructurePrivate))
#define DOCUMENT_STRUCTURE_MARK_NAME_PREFIX "struct_item_"
#define DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH 60
#define DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE 2000
#define DOCUMENT_STRUCTURE__measure_parsing_time FALSE
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, 
                                                 Document* doc);
void document_structure_parse (DocumentStructure* self);
static void document_structure_set_parsing_done (DocumentStructure* self, 
                                          gboolean value);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void document_structure_clear_all_structure_marks (DocumentStructure* self);
static gboolean __lambda6_ (DocumentStructure* self);
static gboolean document_structure_parse_impl (DocumentStructure* self);
static gboolean ___lambda6__gsource_func (gpointer self);
StructureModel* document_structure_get_model (DocumentStructure* self);
static gchar* document_structure_get_line_contents_at_iter (DocumentStructure* self, 
                                                     GtkTextIter* iter);
static gboolean document_structure_search_low_level_item (DocumentStructure* self, 
                                                   const gchar* line, 
                                                   gint start_index, 
                                                   StructType** type, 
                                                   gchar* * contents, 
                                                   gint** start_match_index, 
                                                   gint** end_match_index);
static void document_structure_handle_item (DocumentStructure* self, 
                                     StructType type, 
                                     const gchar* contents, 
                                     GtkTextIter* iter);
static gint* _int_dup (gint* self);
gboolean utils_char_is_escaped (const gchar* text, 
                                glong char_index);
static gboolean document_structure_search_markup (DocumentStructure* self, 
                                           const gchar* line, 
                                           gint after_backslash_index, 
                                           StructType** type, 
                                           gchar* * contents, 
                                           gint** end_match_index);
static gboolean document_structure_search_comment (DocumentStructure* self, 
                                            const gchar* line, 
                                            gint after_percent_index, 
                                            StructType** type, 
                                            gchar* * contents, 
                                            gint** end_match_index);
static gchar* document_structure_get_markup_name (DocumentStructure* self, 
                                           const gchar* line, 
                                           gint after_backslash_index, 
                                           gint** begin_contents_index);
static gboolean document_structure_search_env (DocumentStructure* self, 
                                        const gchar* line, 
                                        gint begin_contents_index, 
                                        gboolean is_begin_env, 
                                        StructType** type, 
                                        gint** end_match_index);
static StructType* document_structure_get_markup_type (DocumentStructure* self, 
                                                const gchar* markup_name);
static gchar* document_structure_get_markup_contents (DocumentStructure* self, 
                                               const gchar* line, 
                                               gint begin_contents_index, 
                                               gint** end_match_index);
static StructType* _struct_type_dup (StructType* self);
static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self, 
                                                          const gchar* line, 
                                                          gint start_index, 
                                                          gint* begin_contents_index);
static gchar* document_structure_truncate (DocumentStructure* self, 
                                    const gchar* text);
static GtkTreeIter* document_structure_add_item (DocumentStructure* self, 
                                          StructType type, 
                                          const gchar* text, 
                                          GtkTextIter* start_iter);
gboolean structure_is_common_type (StructType type);
static void document_structure_create_new_environment (DocumentStructure* self, 
                                                StructType type, 
                                                GtkTextIter* start_iter);
static gboolean document_structure_verify_end_environment_type (DocumentStructure* self, 
                                                         StructType type);
static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self, 
                                                            GtkTextIter* iter);
void structure_model_modify_data (StructureModel* self, 
                                  GtkTreePath* path, 
                                  const gchar* text, 
                                  GtkTextMark* end_mark);
static void _vala_GtkTreePath_free (GtkTreePath* self);
GType struct_data_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self, 
                       StructData* dest);
void struct_data_destroy (StructData* self);
static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self, 
                                               StructData* data);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, 
                                              StructData* item);
GType struct_action_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self, 
                                   StructAction action_type, 
                                   GtkTreeIter* tree_iter, 
                                   gboolean* refresh_simple_list, 
                                   GError** error);
static gboolean document_structure_comment_item (DocumentStructure* self, 
                                          GtkTreeIter* tree_iter);
void structure_model_delete (StructureModel* self, 
                             GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self, 
                                                     GtkTreeIter* iter);
static gboolean document_structure_shift_item (DocumentStructure* self, 
                                        GtkTreeIter* tree_iter, 
                                        gboolean shift_right, 
                                        gboolean* doc_modified);
void structure_model_shift_right (StructureModel* self, 
                                  GtkTreeIter* iter);
void structure_model_shift_left (StructureModel* self, 
                                 GtkTreeIter* iter);
static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self, 
                                                   GtkTreeIter* tree_iter, 
                                                   GtkTextIter* start_iter, 
                                                   GtkTextIter* end_iter);
static void document_structure_backward_indentation (DocumentStructure* self, 
                                              GtkTextIter* iter);
GType struct_column_get_type (void) G_GNUC_CONST;
gboolean structure_is_section (StructType type);
void document_comment_between (Document* self, 
                               GtkTextIter* start_iter, 
                               GtkTextIter* end_iter, 
                               gboolean end_iter_set);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, 
                                                         GtkTreeIter* section_iter, 
                                                         GError** error);
static void document_structure_get_end_document_iter (DocumentStructure* self, 
                                               gboolean* end_of_file, 
                                               GtkTextIter* result);
static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self, 
                                                       StructType item_type, 
                                                       const gchar* item_contents, 
                                                       GtkTextIter* start_match_iter, 
                                                       gboolean is_start, 
                                                       GtkTextIter* end_match_iter);
static gboolean _int_equal (const gint * s1, 
                     const gint * s2);
static gboolean document_structure_same_items (DocumentStructure* self, 
                                        StructType item_type, 
                                        const gchar* item_contents, 
                                        StructType item_found_type, 
                                        const gchar* item_found_contents, 
                                        gboolean start);
static gchar* document_structure_get_section_name_from_type (DocumentStructure* self, 
                                                      StructType type);
void document_insert (Document* self, 
                      GtkTextIter* iter, 
                      const gchar* text, 
                      gint len);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void document_structure_finalize (GObject * obj);
static void _vala_document_structure_get_property (GObject * object, 
                                            guint property_id, 
                                            GValue * value, 
                                            GParamSpec * pspec);
static void _vala_document_structure_set_property (GObject * object, 
                                            guint property_id, 
                                            const GValue * value, 
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);


DocumentStructure*
document_structure_construct (GType object_type, 
                              Document* doc)
{
	DocumentStructure * self = NULL;
	GRegex* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentStructure*) g_object_new (object_type, NULL);
	self->priv->_doc = doc;
	_tmp0_ = document_structure__chars_regex;
	if (_tmp0_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
		_tmp2_ = g_regex_new ("\\\\|%", 0, 0, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (document_structure__chars_regex);
		document_structure__chars_regex = _tmp3_;
		_tmp5_ = g_regex_new ("^(?P<type>TODO|FIXME)\\s*:?\\s*(?P<text>.*)$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_regex_unref0 (document_structure__comment_regex);
		document_structure__comment_regex = _tmp6_;
		_tmp8_ = g_regex_new ("^(?P<name>[a-z]+\\*?)\\s*(\\[|{)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch3_g_regex_error;
			}
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_regex_unref0 (document_structure__command_name_regex);
		document_structure__command_name_regex = _tmp9_;
		_g_regex_unref0 (_tmp7_);
		_g_regex_unref0 (_tmp4_);
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("document_structure.vala:86: Structure: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


DocumentStructure*
document_structure_new (Document* doc)
{
	return document_structure_construct (TYPE_DOCUMENT_STRUCTURE, doc);
}


static gboolean
__lambda6_ (DocumentStructure* self)
{
	gboolean result = FALSE;
	result = document_structure_parse_impl (self);
	return result;
}


static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((DocumentStructure*) self);
	return result;
}


void
document_structure_parse (DocumentStructure* self)
{
	StructureModel* _tmp0_;
	g_return_if_fail (self != NULL);
	document_structure_set_parsing_done (self, FALSE);
	_tmp0_ = structure_model_new ();
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	_g_object_unref0 (self->priv->_end_document_mark);
	self->priv->_end_document_mark = NULL;
	document_structure_clear_all_structure_marks (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


StructureModel*
document_structure_get_model (DocumentStructure* self)
{
	StructureModel* result = NULL;
	StructureModel* _tmp0_;
	StructureModel* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/*************************************************************************/
static gboolean
document_structure_parse_impl (DocumentStructure* self)
{
	gboolean result = FALSE;
	GtkTextIter line_iter = {0};
	Document* _tmp3_;
	gint _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gint nb_lines_parsed = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp0_;
		_tmp0_ = self->priv->_timer;
		if (_tmp0_ == NULL) {
			GTimer* _tmp1_;
			_tmp1_ = g_timer_new ();
			_g_timer_destroy0 (self->priv->_timer);
			self->priv->_timer = _tmp1_;
		} else {
			GTimer* _tmp2_;
			_tmp2_ = self->priv->_timer;
			g_timer_continue (_tmp2_);
		}
	}
	_tmp3_ = self->priv->_doc;
	_tmp4_ = self->priv->_start_parsing_line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	line_iter = _tmp5_;
	nb_lines_parsed = 0;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gint _tmp7_;
			gchar* line_text = NULL;
			GtkTextIter _tmp10_;
			gchar* _tmp11_;
			gint start_index = 0;
			gint line_length = 0;
			const gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp31_;
			if (!_tmp6_) {
				if (!gtk_text_iter_forward_line (&line_iter)) {
					break;
				}
			}
			_tmp6_ = FALSE;
			_tmp7_ = nb_lines_parsed;
			if (_tmp7_ == DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE) {
				gint _tmp8_;
				_tmp8_ = self->priv->_start_parsing_line;
				self->priv->_start_parsing_line = _tmp8_ + DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE;
				if (DOCUMENT_STRUCTURE__measure_parsing_time) {
					GTimer* _tmp9_;
					_tmp9_ = self->priv->_timer;
					g_timer_stop (_tmp9_);
				}
				result = TRUE;
				return result;
			}
			_tmp10_ = line_iter;
			_tmp11_ = document_structure_get_line_contents_at_iter (self, &_tmp10_);
			line_text = _tmp11_;
			start_index = 0;
			_tmp12_ = line_text;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			line_length = _tmp14_;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				StructType* type = NULL;
				gchar* contents = NULL;
				gint* start_match_index = NULL;
				gint* end_match_index = NULL;
				gboolean item_found = FALSE;
				const gchar* _tmp17_;
				gint _tmp18_;
				StructType* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gint* _tmp21_ = NULL;
				gint* _tmp22_ = NULL;
				gboolean _tmp23_;
				gboolean _tmp24_;
				GtkTextIter iter = {0};
				GtkTextIter _tmp25_;
				gint* _tmp26_;
				StructType* _tmp27_;
				const gchar* _tmp28_;
				GtkTextIter _tmp29_;
				gint* _tmp30_;
				_tmp15_ = start_index;
				_tmp16_ = line_length;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = line_text;
				_tmp18_ = start_index;
				_tmp23_ = document_structure_search_low_level_item (self, _tmp17_, _tmp18_, &_tmp19_, &_tmp20_, &_tmp21_, &_tmp22_);
				_g_free0 (type);
				type = _tmp19_;
				_g_free0 (contents);
				contents = _tmp20_;
				_g_free0 (start_match_index);
				start_match_index = _tmp21_;
				_g_free0 (end_match_index);
				end_match_index = _tmp22_;
				item_found = _tmp23_;
				_tmp24_ = item_found;
				if (!_tmp24_) {
					_g_free0 (end_match_index);
					_g_free0 (start_match_index);
					_g_free0 (contents);
					_g_free0 (type);
					break;
				}
				_tmp25_ = line_iter;
				iter = _tmp25_;
				_tmp26_ = start_match_index;
				gtk_text_iter_set_line_index (&iter, *_tmp26_);
				_tmp27_ = type;
				_tmp28_ = contents;
				_tmp29_ = iter;
				document_structure_handle_item (self, *_tmp27_, _tmp28_, &_tmp29_);
				_tmp30_ = end_match_index;
				start_index = *_tmp30_;
				_g_free0 (end_match_index);
				_g_free0 (start_match_index);
				_g_free0 (contents);
				_g_free0 (type);
			}
			_tmp31_ = nb_lines_parsed;
			nb_lines_parsed = _tmp31_ + 1;
			_g_free0 (line_text);
		}
	}
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp32_;
		GTimer* _tmp33_;
		gdouble _tmp34_;
		GTimer* _tmp35_;
		_tmp32_ = self->priv->_timer;
		g_timer_stop (_tmp32_);
		_tmp33_ = self->priv->_timer;
		_tmp34_ = g_timer_elapsed (_tmp33_, NULL);
		g_message ("document_structure.vala:179: Structure parsing took %f seconds", _tmp34_);
		_tmp35_ = self->priv->_timer;
		g_timer_reset (_tmp35_);
	}
	document_structure_set_parsing_done (self, TRUE);
	result = FALSE;
	return result;
}


static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}


static gboolean
document_structure_search_low_level_item (DocumentStructure* self, 
                                          const gchar* line, 
                                          gint start_index, 
                                          StructType** type, 
                                          gchar* * contents, 
                                          gint** start_match_index, 
                                          gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_start_match_index = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	GMatchInfo* match_info = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_start_match_index);
	_vala_start_match_index = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	{
		GRegex* _tmp0_;
		GMatchInfo* _tmp1_ = NULL;
		_tmp0_ = document_structure__chars_regex;
		g_regex_match_full (_tmp0_, line, (gssize) -1, start_index, 0, &_tmp1_, &_inner_error_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("document_structure.vala:211: Structure parsing: chars regex: %s", _tmp3_);
		result = FALSE;
		_g_error_free0 (e);
		_g_match_info_unref0 (match_info);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (start_match_index) {
			*start_match_index = _vala_start_match_index;
		} else {
			_g_free0 (_vala_start_match_index);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		_g_match_info_unref0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp4_;
	}
	while (TRUE) {
		GMatchInfo* _tmp5_;
		gint after_char_index = 0;
		GMatchInfo* _tmp6_;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_;
		gint _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
		_tmp5_ = match_info;
		if (!g_match_info_matches (_tmp5_)) {
			break;
		}
		_tmp6_ = match_info;
		_tmp9_ = g_match_info_fetch_pos (_tmp6_, 0, &_tmp7_, &_tmp8_);
		_g_free0 (_vala_start_match_index);
		_tmp10_ = _tmp7_;
		_tmp11_ = __int_dup0 (&_tmp10_);
		_vala_start_match_index = _tmp11_;
		after_char_index = _tmp8_;
		if (!_tmp9_) {
			g_warning ("document_structure.vala:220: Structure parsing: position can not be fe" \
"tched");
			result = FALSE;
			_g_match_info_unref0 (match_info);
			if (type) {
				*type = _vala_type;
			} else {
				_g_free0 (_vala_type);
			}
			if (contents) {
				*contents = _vala_contents;
			} else {
				_g_free0 (_vala_contents);
			}
			if (start_match_index) {
				*start_match_index = _vala_start_match_index;
			} else {
				_g_free0 (_vala_start_match_index);
			}
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		_tmp12_ = _vala_start_match_index;
		if (!utils_char_is_escaped (line, *_tmp12_)) {
			gchar* char_matched = NULL;
			GMatchInfo* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = match_info;
			_tmp14_ = g_match_info_fetch (_tmp13_, 0);
			char_matched = _tmp14_;
			_tmp15_ = char_matched;
			if (g_strcmp0 (_tmp15_, "\\") == 0) {
				gboolean markup_found = FALSE;
				gint _tmp16_;
				StructType* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gint* _tmp19_ = NULL;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp16_ = after_char_index;
				_tmp20_ = document_structure_search_markup (self, line, _tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
				_g_free0 (_vala_type);
				_vala_type = _tmp17_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp18_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp19_;
				markup_found = _tmp20_;
				_tmp21_ = markup_found;
				if (_tmp21_) {
					result = TRUE;
					_g_free0 (char_matched);
					_g_match_info_unref0 (match_info);
					if (type) {
						*type = _vala_type;
					} else {
						_g_free0 (_vala_type);
					}
					if (contents) {
						*contents = _vala_contents;
					} else {
						_g_free0 (_vala_contents);
					}
					if (start_match_index) {
						*start_match_index = _vala_start_match_index;
					} else {
						_g_free0 (_vala_start_match_index);
					}
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			} else {
				gint _tmp22_;
				StructType* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				gint* _tmp25_ = NULL;
				gboolean _tmp26_;
				_tmp22_ = after_char_index;
				_tmp26_ = document_structure_search_comment (self, line, _tmp22_, &_tmp23_, &_tmp24_, &_tmp25_);
				_g_free0 (_vala_type);
				_vala_type = _tmp23_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp24_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp25_;
				result = _tmp26_;
				_g_free0 (char_matched);
				_g_match_info_unref0 (match_info);
				if (type) {
					*type = _vala_type;
				} else {
					_g_free0 (_vala_type);
				}
				if (contents) {
					*contents = _vala_contents;
				} else {
					_g_free0 (_vala_contents);
				}
				if (start_match_index) {
					*start_match_index = _vala_start_match_index;
				} else {
					_g_free0 (_vala_start_match_index);
				}
				if (end_match_index) {
					*end_match_index = _vala_end_match_index;
				} else {
					_g_free0 (_vala_end_match_index);
				}
				return result;
			}
			_g_free0 (char_matched);
		}
		{
			GMatchInfo* _tmp27_;
			_tmp27_ = match_info;
			g_match_info_next (_tmp27_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp28_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch5_g_regex_error;
				}
				_g_match_info_unref0 (match_info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp28_;
			}
		}
		goto __finally5;
		__catch5_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp29_;
			const gchar* _tmp30_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp29_ = e;
			_tmp30_ = _tmp29_->message;
			g_warning ("document_structure.vala:256: Structure parsing: %s", _tmp30_);
			_g_error_free0 (e);
			break;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp31_ = FALSE;
			_g_match_info_unref0 (match_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp31_;
		}
	}
	result = FALSE;
	_g_match_info_unref0 (match_info);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (start_match_index) {
		*start_match_index = _vala_start_match_index;
	} else {
		_g_free0 (_vala_start_match_index);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static gboolean
document_structure_search_markup (DocumentStructure* self, 
                                  const gchar* line, 
                                  gint after_backslash_index, 
                                  StructType** type, 
                                  gchar* * contents, 
                                  gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gint* begin_contents_index = NULL;
	gchar* name = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean is_begin_env = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	const gchar* _tmp12_;
	StructType* _tmp13_;
	StructType* _tmp14_;
	gint* _tmp15_;
	gint* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp1_ = document_structure_get_markup_name (self, line, after_backslash_index, &_tmp0_);
	_g_free0 (begin_contents_index);
	begin_contents_index = _tmp0_;
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp3_ = name;
	is_begin_env = g_strcmp0 (_tmp3_, "begin") == 0;
	_tmp5_ = is_begin_env;
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = name;
		_tmp4_ = g_strcmp0 (_tmp6_, "end") == 0;
	}
	if (_tmp4_) {
		gint* _tmp7_;
		gboolean _tmp8_;
		StructType* _tmp9_ = NULL;
		gint* _tmp10_ = NULL;
		gboolean _tmp11_;
		_g_free0 (_vala_contents);
		_vala_contents = NULL;
		_tmp7_ = begin_contents_index;
		_tmp8_ = is_begin_env;
		_tmp11_ = document_structure_search_env (self, line, *_tmp7_, _tmp8_, &_tmp9_, &_tmp10_);
		_g_free0 (_vala_type);
		_vala_type = _tmp9_;
		_g_free0 (_vala_end_match_index);
		_vala_end_match_index = _tmp10_;
		result = _tmp11_;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp12_ = name;
	_tmp13_ = document_structure_get_markup_type (self, _tmp12_);
	_g_free0 (_vala_type);
	_vala_type = _tmp13_;
	_tmp14_ = _vala_type;
	if (_tmp14_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp15_ = begin_contents_index;
	_tmp17_ = document_structure_get_markup_contents (self, line, *_tmp15_, &_tmp16_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp16_;
	_g_free0 (_vala_contents);
	_vala_contents = _tmp17_;
	_tmp18_ = _vala_contents;
	result = _tmp18_ != NULL;
	_g_free0 (name);
	_g_free0 (begin_contents_index);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static StructType*
_struct_type_dup (StructType* self)
{
	StructType* dup;
	dup = g_new0 (StructType, 1);
	memcpy (dup, self, sizeof (StructType));
	return dup;
}


static gpointer
__struct_type_dup0 (gpointer self)
{
	return self ? _struct_type_dup (self) : NULL;
}


static gboolean
document_structure_search_env (DocumentStructure* self, 
                               const gchar* line, 
                               gint begin_contents_index, 
                               gboolean is_begin_env, 
                               StructType** type, 
                               gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gchar* contents = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_tmp1_ = document_structure_get_markup_contents (self, line, begin_contents_index, &_tmp0_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp0_;
	contents = _tmp1_;
	_tmp2_ = contents;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp4_ = contents;
	if (g_strcmp0 (_tmp4_, "verbatim") == 0) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = contents;
		_tmp3_ = g_strcmp0 (_tmp5_, "verbatim*") == 0;
	}
	if (_tmp3_) {
		StructType _tmp6_ = 0;
		StructType* _tmp7_;
		if (is_begin_env) {
			_tmp6_ = STRUCT_TYPE_BEGIN_VERBATIM;
		} else {
			_tmp6_ = STRUCT_TYPE_END_VERBATIM;
		}
		_tmp7_ = __struct_type_dup0 (&_tmp6_);
		_g_free0 (_vala_type);
		_vala_type = _tmp7_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp8_ = contents;
	if (g_strcmp0 (_tmp8_, "figure") == 0) {
		StructType _tmp9_ = 0;
		StructType* _tmp10_;
		if (is_begin_env) {
			_tmp9_ = STRUCT_TYPE_BEGIN_FIGURE;
		} else {
			_tmp9_ = STRUCT_TYPE_END_FIGURE;
		}
		_tmp10_ = __struct_type_dup0 (&_tmp9_);
		_g_free0 (_vala_type);
		_vala_type = _tmp10_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp11_ = contents;
	if (g_strcmp0 (_tmp11_, "table") == 0) {
		StructType _tmp12_ = 0;
		StructType* _tmp13_;
		if (is_begin_env) {
			_tmp12_ = STRUCT_TYPE_BEGIN_TABLE;
		} else {
			_tmp12_ = STRUCT_TYPE_END_TABLE;
		}
		_tmp13_ = __struct_type_dup0 (&_tmp12_);
		_g_free0 (_vala_type);
		_vala_type = _tmp13_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp15_ = contents;
	if (g_strcmp0 (_tmp15_, "document") == 0) {
		_tmp14_ = !is_begin_env;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		StructType _tmp16_;
		StructType* _tmp17_;
		_tmp16_ = STRUCT_TYPE_END_DOCUMENT;
		_tmp17_ = __struct_type_dup0 (&_tmp16_);
		_g_free0 (_vala_type);
		_vala_type = _tmp17_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	result = FALSE;
	_g_free0 (contents);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static glong
string_strnlen (gchar* str, 
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self, 
                  glong offset, 
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
document_structure_get_markup_name (DocumentStructure* self, 
                                    const gchar* line, 
                                    gint after_backslash_index, 
                                    gint** begin_contents_index)
{
	gint* _vala_begin_contents_index = NULL;
	gchar* result = NULL;
	gchar* after_backslash_text = NULL;
	gchar* _tmp0_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp1_;
	const gchar* _tmp2_;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	gint pos = 0;
	GMatchInfo* _tmp5_;
	gint _tmp6_ = 0;
	gint begin_first_arg_index = 0;
	gint _tmp7_;
	gchar* markup_name = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_ = 0;
	gboolean _tmp12_;
	gint _tmp13_;
	gint* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_begin_contents_index);
	_vala_begin_contents_index = NULL;
	_tmp0_ = string_substring (line, (glong) after_backslash_index, (glong) -1);
	after_backslash_text = _tmp0_;
	_tmp1_ = document_structure__command_name_regex;
	_tmp2_ = after_backslash_text;
	_tmp4_ = g_regex_match (_tmp1_, _tmp2_, 0, &_tmp3_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp3_;
	if (!_tmp4_) {
		result = NULL;
		_g_match_info_unref0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	_tmp5_ = match_info;
	g_match_info_fetch_pos (_tmp5_, 0, NULL, &_tmp6_);
	pos = _tmp6_;
	_tmp7_ = pos;
	begin_first_arg_index = after_backslash_index + _tmp7_;
	_tmp8_ = match_info;
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "name");
	markup_name = _tmp9_;
	_tmp10_ = begin_first_arg_index;
	_tmp12_ = document_structure_search_firt_non_optional_arg (self, line, _tmp10_ - 1, &_tmp11_);
	_g_free0 (_vala_begin_contents_index);
	_tmp13_ = _tmp11_;
	_tmp14_ = __int_dup0 (&_tmp13_);
	_vala_begin_contents_index = _tmp14_;
	if (_tmp12_) {
		result = markup_name;
		_g_match_info_unref0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	result = NULL;
	_g_free0 (markup_name);
	_g_match_info_unref0 (match_info);
	_g_free0 (after_backslash_text);
	if (begin_contents_index) {
		*begin_contents_index = _vala_begin_contents_index;
	} else {
		_g_free0 (_vala_begin_contents_index);
	}
	return result;
}


static gboolean
string_get_next_char (const gchar* self, 
                      gint* index, 
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	_tmp0_ = _vala_c;
	if (_tmp0_ != ((gunichar) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp1_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gboolean
document_structure_search_firt_non_optional_arg (DocumentStructure* self, 
                                                 const gchar* line, 
                                                 gint start_index, 
                                                 gint* begin_contents_index)
{
	gint _vala_begin_contents_index = 0;
	gboolean result = FALSE;
	gint cur_index = 0;
	gboolean in_optional_arg = FALSE;
	gint additional_bracket_level = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_vala_begin_contents_index = 0;
	cur_index = start_index;
	in_optional_arg = FALSE;
	additional_bracket_level = 0;
	while (TRUE) {
		gint next_index = 0;
		gint _tmp0_;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp12_;
		gint _tmp13_;
		_tmp0_ = cur_index;
		next_index = _tmp0_;
		_tmp2_ = string_get_next_char (line, &next_index, &_tmp1_);
		cur_char = _tmp1_;
		end = !_tmp2_;
		_tmp3_ = in_optional_arg;
		if (_tmp3_) {
			gunichar _tmp4_;
			_tmp4_ = cur_char;
			switch (_tmp4_) {
				case ']':
				{
					gint _tmp5_;
					_tmp5_ = cur_index;
					if (!utils_char_is_escaped (line, (glong) _tmp5_)) {
						gint _tmp6_;
						_tmp6_ = additional_bracket_level;
						if (0 < _tmp6_) {
							gint _tmp7_;
							_tmp7_ = additional_bracket_level;
							additional_bracket_level = _tmp7_ - 1;
						} else {
							in_optional_arg = FALSE;
						}
					}
					break;
				}
				case '[':
				{
					gint _tmp8_;
					_tmp8_ = cur_index;
					if (!utils_char_is_escaped (line, (glong) _tmp8_)) {
						gint _tmp9_;
						_tmp9_ = additional_bracket_level;
						additional_bracket_level = _tmp9_ + 1;
					}
					break;
				}
				default:
				break;
			}
		} else {
			gunichar _tmp10_;
			_tmp10_ = cur_char;
			switch (_tmp10_) {
				case '{':
				{
					gint _tmp11_;
					_tmp11_ = next_index;
					_vala_begin_contents_index = _tmp11_;
					result = TRUE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
				case '[':
				{
					in_optional_arg = TRUE;
					break;
				}
				case ' ':
				case '\t':
				{
					break;
				}
				default:
				{
					result = FALSE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
			}
		}
		_tmp12_ = end;
		if (_tmp12_) {
			result = FALSE;
			if (begin_contents_index) {
				*begin_contents_index = _vala_begin_contents_index;
			}
			return result;
		}
		_tmp13_ = next_index;
		cur_index = _tmp13_;
	}
	if (begin_contents_index) {
		*begin_contents_index = _vala_begin_contents_index;
	}
}


static gchar*
string_slice (const gchar* self, 
              glong start, 
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static gchar*
document_structure_get_markup_contents (DocumentStructure* self, 
                                        const gchar* line, 
                                        gint begin_contents_index, 
                                        gint** end_match_index)
{
	gint* _vala_end_match_index = NULL;
	gchar* result = NULL;
	gint brace_level = 0;
	gint cur_index = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	brace_level = 0;
	cur_index = begin_contents_index;
	while (TRUE) {
		gint next_index = 0;
		gint _tmp0_;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_ = FALSE;
		gunichar _tmp4_;
		gboolean _tmp17_;
		gint _tmp18_;
		_tmp0_ = cur_index;
		next_index = _tmp0_;
		_tmp2_ = string_get_next_char (line, &next_index, &_tmp1_);
		cur_char = _tmp1_;
		end = !_tmp2_;
		_tmp4_ = cur_char;
		if (_tmp4_ == ((gunichar) '{')) {
			gint _tmp5_;
			_tmp5_ = cur_index;
			_tmp3_ = !utils_char_is_escaped (line, (glong) _tmp5_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp6_;
			_tmp6_ = brace_level;
			brace_level = _tmp6_ + 1;
		} else {
			gboolean _tmp7_ = FALSE;
			gunichar _tmp8_;
			_tmp8_ = cur_char;
			if (_tmp8_ == ((gunichar) '}')) {
				gint _tmp9_;
				_tmp9_ = cur_index;
				_tmp7_ = !utils_char_is_escaped (line, (glong) _tmp9_);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				gint _tmp10_;
				_tmp10_ = brace_level;
				if (_tmp10_ > 0) {
					gint _tmp11_;
					_tmp11_ = brace_level;
					brace_level = _tmp11_ - 1;
				} else {
					gchar* contents = NULL;
					gint _tmp12_;
					gchar* _tmp13_;
					const gchar* _tmp14_;
					gint _tmp15_;
					gint* _tmp16_;
					_tmp12_ = cur_index;
					_tmp13_ = string_slice (line, (glong) begin_contents_index, (glong) _tmp12_);
					contents = _tmp13_;
					_tmp14_ = contents;
					if (g_strcmp0 (_tmp14_, "") == 0) {
						result = NULL;
						_g_free0 (contents);
						if (end_match_index) {
							*end_match_index = _vala_end_match_index;
						} else {
							_g_free0 (_vala_end_match_index);
						}
						return result;
					}
					_tmp15_ = next_index;
					_tmp16_ = __int_dup0 (&_tmp15_);
					_g_free0 (_vala_end_match_index);
					_vala_end_match_index = _tmp16_;
					result = contents;
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			}
		}
		_tmp17_ = end;
		if (_tmp17_) {
			result = NULL;
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		_tmp18_ = next_index;
		cur_index = _tmp18_;
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean
document_structure_search_comment (DocumentStructure* self, 
                                   const gchar* line, 
                                   gint after_percent_index, 
                                   StructType** type, 
                                   gchar* * contents, 
                                   gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gchar* text_after = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	StructType _tmp10_ = 0;
	const gchar* _tmp11_;
	StructType* _tmp12_;
	GMatchInfo* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint* _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp0_ = string_substring (line, (glong) after_percent_index, (glong) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	text_after = _tmp3_;
	_tmp4_ = document_structure__comment_regex;
	_tmp5_ = text_after;
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp6_;
	if (!_tmp7_) {
		result = FALSE;
		_g_match_info_unref0 (match_info);
		_g_free0 (text_after);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp8_ = match_info;
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "type");
	type_str = _tmp9_;
	_tmp11_ = type_str;
	if (g_strcmp0 (_tmp11_, "TODO") == 0) {
		_tmp10_ = STRUCT_TYPE_TODO;
	} else {
		_tmp10_ = STRUCT_TYPE_FIXME;
	}
	_tmp12_ = __struct_type_dup0 (&_tmp10_);
	_g_free0 (_vala_type);
	_vala_type = _tmp12_;
	_tmp13_ = match_info;
	_tmp14_ = g_match_info_fetch_named (_tmp13_, "text");
	_g_free0 (_vala_contents);
	_vala_contents = _tmp14_;
	_tmp15_ = strlen (line);
	_tmp16_ = _tmp15_;
	_tmp17_ = __int_dup0 (&_tmp16_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp17_;
	result = TRUE;
	_g_free0 (type_str);
	_g_match_info_unref0 (match_info);
	_g_free0 (text_after);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static void
document_structure_handle_item (DocumentStructure* self, 
                                StructType type, 
                                const gchar* contents, 
                                GtkTextIter* iter)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->_in_verbatim_env;
	if (_tmp0_) {
		if (type == STRUCT_TYPE_END_VERBATIM) {
			self->priv->_in_verbatim_env = FALSE;
		}
		return;
	}
	if (type == STRUCT_TYPE_TODO) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == STRUCT_TYPE_FIXME;
	}
	if (_tmp1_) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		GtkTextIter _tmp5_;
		GtkTreeIter* _tmp6_;
		GtkTreeIter* _tmp7_;
		_tmp3_ = document_structure_truncate (self, contents);
		_tmp2_ = _tmp3_;
		if (_tmp2_ == NULL) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup (contents);
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp4_;
		}
		_tmp5_ = *iter;
		_tmp6_ = document_structure_add_item (self, type, _tmp2_, &_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp2_);
	} else {
		if (structure_is_common_type (type)) {
			GtkTextIter _tmp8_;
			GtkTreeIter* _tmp9_;
			GtkTreeIter* _tmp10_;
			_tmp8_ = *iter;
			_tmp9_ = document_structure_add_item (self, type, contents, &_tmp8_);
			_tmp10_ = _tmp9_;
			_g_free0 (_tmp10_);
		} else {
			if (type == STRUCT_TYPE_BEGIN_VERBATIM) {
				self->priv->_in_verbatim_env = TRUE;
			} else {
				gboolean _tmp11_ = FALSE;
				if (type == STRUCT_TYPE_BEGIN_FIGURE) {
					_tmp11_ = TRUE;
				} else {
					_tmp11_ = type == STRUCT_TYPE_BEGIN_TABLE;
				}
				if (_tmp11_) {
					GtkTextIter _tmp12_;
					_tmp12_ = *iter;
					document_structure_create_new_environment (self, type, &_tmp12_);
				} else {
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					if (type == STRUCT_TYPE_CAPTION) {
						DocumentStructureEnvData* _tmp15_;
						_tmp15_ = self->priv->_last_env_data;
						_tmp14_ = _tmp15_ != NULL;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						DocumentStructureEnvData* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = self->priv->_last_env_data;
						_tmp17_ = (*_tmp16_).first_caption;
						_tmp13_ = _tmp17_ == NULL;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						gchar* _tmp18_ = NULL;
						gchar* _tmp19_;
						DocumentStructureEnvData* _tmp21_;
						gchar* _tmp22_;
						_tmp19_ = document_structure_truncate (self, contents);
						_tmp18_ = _tmp19_;
						if (_tmp18_ == NULL) {
							gchar* _tmp20_;
							_tmp20_ = g_strdup (contents);
							_g_free0 (_tmp18_);
							_tmp18_ = _tmp20_;
						}
						_tmp21_ = self->priv->_last_env_data;
						_tmp22_ = _tmp18_;
						_tmp18_ = NULL;
						_g_free0 ((*_tmp21_).first_caption);
						(*_tmp21_).first_caption = _tmp22_;
						_g_free0 (_tmp18_);
					} else {
						if (document_structure_verify_end_environment_type (self, type)) {
							GtkTextMark* end_mark = NULL;
							GtkTextIter _tmp23_;
							GtkTextMark* _tmp24_;
							StructureModel* _tmp25_;
							DocumentStructureEnvData* _tmp26_;
							GtkTreePath* _tmp27_;
							DocumentStructureEnvData* _tmp28_;
							const gchar* _tmp29_;
							GtkTextMark* _tmp30_;
							_tmp23_ = *iter;
							_tmp24_ = document_structure_create_text_mark_from_iter (self, &_tmp23_);
							end_mark = _tmp24_;
							_tmp25_ = self->priv->_model;
							_tmp26_ = self->priv->_last_env_data;
							_tmp27_ = (*_tmp26_).path;
							_tmp28_ = self->priv->_last_env_data;
							_tmp29_ = (*_tmp28_).first_caption;
							_tmp30_ = end_mark;
							structure_model_modify_data (_tmp25_, _tmp27_, _tmp29_, _tmp30_);
							_document_structure_env_data_free0 (self->priv->_last_env_data);
							self->priv->_last_env_data = NULL;
							_g_object_unref0 (end_mark);
						} else {
							if (type == STRUCT_TYPE_END_DOCUMENT) {
								GtkTextIter _tmp31_;
								GtkTextMark* _tmp32_;
								_tmp31_ = *iter;
								_tmp32_ = document_structure_create_text_mark_from_iter (self, &_tmp31_);
								_g_object_unref0 (self->priv->_end_document_mark);
								self->priv->_end_document_mark = _tmp32_;
							}
						}
					}
				}
			}
		}
	}
}


static gpointer
_document_structure_env_data_dup0 (gpointer self)
{
	return self ? document_structure_env_data_dup (self) : NULL;
}


static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}


static void
document_structure_create_new_environment (DocumentStructure* self, 
                                           StructType type, 
                                           GtkTextIter* start_iter)
{
	gboolean _tmp0_ = FALSE;
	DocumentStructureEnvData _tmp1_ = {0};
	DocumentStructureEnvData _tmp2_;
	DocumentStructureEnvData* _tmp3_;
	DocumentStructureEnvData* _tmp4_;
	GtkTreeIter tree_iter = {0};
	DocumentStructureEnvData* _tmp7_;
	StructType _tmp8_;
	GtkTextIter _tmp9_;
	GtkTreeIter* _tmp10_;
	GtkTreeIter* _tmp11_;
	GtkTreeIter _tmp12_;
	DocumentStructureEnvData* _tmp13_;
	StructureModel* _tmp14_;
	GtkTreeIter _tmp15_;
	GtkTreePath* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	if (type == STRUCT_TYPE_BEGIN_FIGURE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == STRUCT_TYPE_BEGIN_TABLE;
	}
	g_return_if_fail (_tmp0_);
	memset (&_tmp1_, 0, sizeof (DocumentStructureEnvData));
	_tmp2_ = _tmp1_;
	_tmp3_ = _document_structure_env_data_dup0 (&_tmp2_);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = _tmp3_;
	document_structure_env_data_destroy (&_tmp2_);
	_tmp4_ = self->priv->_last_env_data;
	_g_free0 ((*_tmp4_).first_caption);
	(*_tmp4_).first_caption = NULL;
	if (type == STRUCT_TYPE_BEGIN_TABLE) {
		DocumentStructureEnvData* _tmp5_;
		_tmp5_ = self->priv->_last_env_data;
		(*_tmp5_).type = STRUCT_TYPE_TABLE;
	} else {
		DocumentStructureEnvData* _tmp6_;
		_tmp6_ = self->priv->_last_env_data;
		(*_tmp6_).type = STRUCT_TYPE_FIGURE;
	}
	_tmp7_ = self->priv->_last_env_data;
	_tmp8_ = (*_tmp7_).type;
	_tmp9_ = *start_iter;
	_tmp10_ = document_structure_add_item (self, _tmp8_, NULL, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = *_tmp11_;
	_g_free0 (_tmp11_);
	tree_iter = _tmp12_;
	_tmp13_ = self->priv->_last_env_data;
	_tmp14_ = self->priv->_model;
	_tmp15_ = tree_iter;
	_tmp16_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp14_, &_tmp15_);
	__vala_GtkTreePath_free0 ((*_tmp13_).path);
	(*_tmp13_).path = _tmp16_;
}


static gboolean
document_structure_verify_end_environment_type (DocumentStructure* self, 
                                                StructType type)
{
	gboolean result = FALSE;
	DocumentStructureEnvData* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_last_env_data;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	if (type == STRUCT_TYPE_END_TABLE) {
		DocumentStructureEnvData* _tmp1_;
		StructType _tmp2_;
		_tmp1_ = self->priv->_last_env_data;
		_tmp2_ = (*_tmp1_).type;
		result = _tmp2_ == STRUCT_TYPE_TABLE;
		return result;
	}
	if (type == STRUCT_TYPE_END_FIGURE) {
		DocumentStructureEnvData* _tmp3_;
		StructType _tmp4_;
		_tmp3_ = self->priv->_last_env_data;
		_tmp4_ = (*_tmp3_).type;
		result = _tmp4_ == STRUCT_TYPE_FIGURE;
		return result;
	}
	result = FALSE;
	return result;
}


static GtkTreeIter*
document_structure_add_item (DocumentStructure* self, 
                             StructType type, 
                             const gchar* text, 
                             GtkTextIter* start_iter)
{
	GtkTreeIter* result = NULL;
	StructData data = {0};
	StructData _tmp0_ = {0};
	gchar* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextMark* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start_iter != NULL, NULL);
	data = _tmp0_;
	data.type = type;
	_tmp1_ = g_strdup (text);
	_g_free0 (data.text);
	data.text = _tmp1_;
	_tmp2_ = *start_iter;
	_tmp3_ = document_structure_create_text_mark_from_iter (self, &_tmp2_);
	_g_object_unref0 (data.start_mark);
	data.start_mark = _tmp3_;
	_g_object_unref0 (data.end_mark);
	data.end_mark = NULL;
	_tmp4_ = data;
	_tmp5_ = document_structure_add_item_data (self, &_tmp4_);
	result = _tmp5_;
	struct_data_destroy (&data);
	return result;
}


static GtkTreeIter*
document_structure_add_item_data (DocumentStructure* self, 
                                  StructData* data)
{
	GtkTreeIter* result = NULL;
	StructData _tmp0_;
	const gchar* _tmp1_;
	StructureModel* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.text;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 ((*data).text);
		(*data).text = _tmp2_;
	}
	_tmp3_ = self->priv->_model;
	_tmp4_ = *data;
	_tmp5_ = structure_model_add_item_at_end (_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}


static GtkTextMark*
document_structure_create_text_mark_from_iter (DocumentStructure* self, 
                                               GtkTextIter* iter)
{
	GtkTextMark* result = NULL;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* name = NULL;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextMark* _tmp9_;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = self->priv->_nb_marks;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	name = _tmp6_;
	_tmp7_ = *iter;
	_tmp8_ = gtk_text_buffer_create_mark (doc, name, &_tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	mark = _tmp9_;
	_tmp10_ = self->priv->_nb_marks;
	self->priv->_nb_marks = _tmp10_ + 1;
	result = mark;
	_g_free0 (name);
	_g_object_unref0 (doc);
	return result;
}


static void
document_structure_clear_all_structure_marks (DocumentStructure* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gchar* mark_name = NULL;
				gint _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GtkTextMark* mark = NULL;
				Document* _tmp9_;
				const gchar* _tmp10_;
				GtkTextMark* _tmp11_;
				GtkTextMark* _tmp12_;
				GtkTextMark* _tmp13_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_nb_marks;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = g_strdup_printf ("%i", _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp6_, NULL);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				mark_name = _tmp8_;
				_tmp9_ = self->priv->_doc;
				_tmp10_ = mark_name;
				_tmp11_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) _tmp9_, _tmp10_);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				mark = _tmp12_;
				_tmp13_ = mark;
				if (_tmp13_ != NULL) {
					Document* _tmp14_;
					GtkTextMark* _tmp15_;
					_tmp14_ = self->priv->_doc;
					_tmp15_ = mark;
					gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp14_, _tmp15_);
				}
				_g_object_unref0 (mark);
				_g_free0 (mark_name);
			}
		}
	}
	self->priv->_nb_marks = 0;
}


static gint
string_index_of_nth_char (const gchar* self, 
                          glong c)
{
	gint result = 0;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}


static gchar*
document_structure_truncate (DocumentStructure* self, 
                             const gchar* text)
{
	gchar* result = NULL;
	gint index = 0;
	gint _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (text == NULL) {
		result = NULL;
		return result;
	}
	if (g_utf8_strlen (text, (gssize) -1) <= DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH) {
		result = NULL;
		return result;
	}
	index = string_index_of_nth_char (text, (glong) DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH);
	_tmp0_ = index;
	_tmp1_ = string_substring (text, (glong) 0, (glong) _tmp0_);
	result = _tmp1_;
	return result;
}


static StructType*
document_structure_get_markup_type (DocumentStructure* self, 
                                    const gchar* markup_name)
{
	StructType* result = NULL;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	static GQuark _tmp1_label9 = 0;
	static GQuark _tmp1_label10 = 0;
	static GQuark _tmp1_label11 = 0;
	static GQuark _tmp1_label12 = 0;
	static GQuark _tmp1_label13 = 0;
	static GQuark _tmp1_label14 = 0;
	static GQuark _tmp1_label15 = 0;
	static GQuark _tmp1_label16 = 0;
	static GQuark _tmp1_label17 = 0;
	static GQuark _tmp1_label18 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup_name != NULL, NULL);
	_tmp0_ = markup_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("part")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("part*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp3_;
				StructType* _tmp4_;
				_tmp3_ = STRUCT_TYPE_PART;
				_tmp4_ = __struct_type_dup0 (&_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("chapter")))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("chapter*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp5_;
				StructType* _tmp6_;
				_tmp5_ = STRUCT_TYPE_CHAPTER;
				_tmp6_ = __struct_type_dup0 (&_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("section")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("section*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp7_;
				StructType* _tmp8_;
				_tmp7_ = STRUCT_TYPE_SECTION;
				_tmp8_ = __struct_type_dup0 (&_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("subsection")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("subsection*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp9_;
				StructType* _tmp10_;
				_tmp9_ = STRUCT_TYPE_SUBSECTION;
				_tmp10_ = __struct_type_dup0 (&_tmp9_);
				result = _tmp10_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("subsubsection")))) || (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("subsubsection*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp11_;
				StructType* _tmp12_;
				_tmp11_ = STRUCT_TYPE_SUBSUBSECTION;
				_tmp12_ = __struct_type_dup0 (&_tmp11_);
				result = _tmp12_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("paragraph")))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("paragraph*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp13_;
				StructType* _tmp14_;
				_tmp13_ = STRUCT_TYPE_PARAGRAPH;
				_tmp14_ = __struct_type_dup0 (&_tmp13_);
				result = _tmp14_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("subparagraph")))) || (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("subparagraph*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp15_;
				StructType* _tmp16_;
				_tmp15_ = STRUCT_TYPE_SUBPARAGRAPH;
				_tmp16_ = __struct_type_dup0 (&_tmp15_);
				result = _tmp16_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				StructType _tmp17_;
				StructType* _tmp18_;
				_tmp17_ = STRUCT_TYPE_LABEL;
				_tmp18_ = __struct_type_dup0 (&_tmp17_);
				result = _tmp18_;
				return result;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("input")))) || (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("include"))))) {
		switch (0) {
			default:
			{
				StructType _tmp19_;
				StructType* _tmp20_;
				_tmp19_ = STRUCT_TYPE_INCLUDE;
				_tmp20_ = __struct_type_dup0 (&_tmp19_);
				result = _tmp20_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("includegraphics")))) {
		switch (0) {
			default:
			{
				StructType _tmp21_;
				StructType* _tmp22_;
				_tmp21_ = STRUCT_TYPE_IMAGE;
				_tmp22_ = __struct_type_dup0 (&_tmp21_);
				result = _tmp22_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("caption")))) {
		switch (0) {
			default:
			{
				StructType _tmp23_;
				StructType* _tmp24_;
				_tmp23_ = STRUCT_TYPE_CAPTION;
				_tmp24_ = __struct_type_dup0 (&_tmp23_);
				result = _tmp24_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


static gchar*
document_structure_get_line_contents_at_iter (DocumentStructure* self, 
                                              GtkTextIter* iter)
{
	gchar* result = NULL;
	GtkTextIter begin_line = {0};
	GtkTextIter _tmp0_;
	GtkTextIter end_line = {0};
	GtkTextIter _tmp1_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	begin_line = _tmp0_;
	gtk_text_iter_set_line_offset (&begin_line, 0);
	_tmp1_ = *iter;
	end_line = _tmp1_;
	if (!gtk_text_iter_ends_line (iter)) {
		gtk_text_iter_forward_to_line_end (&end_line);
	}
	_tmp2_ = gtk_text_iter_get_buffer (iter);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = begin_line;
	_tmp5_ = end_line;
	_tmp6_ = gtk_text_buffer_get_text (buffer, &_tmp4_, &_tmp5_, FALSE);
	result = _tmp6_;
	_g_object_unref0 (buffer);
	return result;
}


/*************************************************************************/
void
document_structure_do_action (DocumentStructure* self, 
                              StructAction action_type, 
                              GtkTreeIter* tree_iter, 
                              gboolean* refresh_simple_list, 
                              GError** error)
{
	gboolean _vala_refresh_simple_list = FALSE;
	gboolean shift_right = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gboolean found = FALSE;
	GtkTreeIter _tmp26_;
	GtkTextIter _tmp27_ = {0};
	GtkTextIter _tmp28_ = {0};
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp44_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_iter != NULL);
	_vala_refresh_simple_list = FALSE;
	if (action_type == STRUCT_ACTION_COMMENT) {
		GtkTreeIter _tmp0_;
		StructureModel* _tmp2_;
		GtkTreeIter _tmp3_;
		_tmp0_ = *tree_iter;
		if (!document_structure_comment_item (self, &_tmp0_)) {
			GError* _tmp1_;
			_tmp1_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp1_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp2_ = self->priv->_model;
		_tmp3_ = *tree_iter;
		structure_model_delete (_tmp2_, &_tmp3_);
		_vala_refresh_simple_list = TRUE;
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	shift_right = action_type == STRUCT_ACTION_SHIFT_RIGHT;
	_tmp5_ = shift_right;
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = action_type == STRUCT_ACTION_SHIFT_LEFT;
	}
	if (_tmp4_) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_;
		Document* _tmp11_;
		gboolean doc_modified = FALSE;
		gboolean success = FALSE;
		GtkTreeIter _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		Document* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp21_;
		_tmp7_ = shift_right;
		if (_tmp7_) {
			StructureModel* _tmp8_;
			GtkTreeIter _tmp9_;
			_tmp8_ = self->priv->_model;
			_tmp9_ = *tree_iter;
			_tmp6_ = structure_model_item_contains_subparagraph (_tmp8_, &_tmp9_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GError* _tmp10_;
			_tmp10_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, _ ("The structure item already contains a sub-paragraph."));
			_inner_error_ = _tmp10_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp11_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp11_);
		_tmp12_ = *tree_iter;
		_tmp13_ = shift_right;
		_tmp15_ = document_structure_shift_item (self, &_tmp12_, _tmp13_, &_tmp14_);
		doc_modified = _tmp14_;
		success = _tmp15_;
		_tmp16_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp16_);
		_tmp17_ = success;
		if (!_tmp17_) {
			gboolean _tmp18_;
			GError* _tmp20_;
			_tmp18_ = doc_modified;
			if (_tmp18_) {
				Document* _tmp19_;
				_tmp19_ = self->priv->_doc;
				gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp19_);
			}
			_tmp20_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp20_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp21_ = shift_right;
		if (_tmp21_) {
			StructureModel* _tmp22_;
			GtkTreeIter _tmp23_;
			_tmp22_ = self->priv->_model;
			_tmp23_ = *tree_iter;
			structure_model_shift_right (_tmp22_, &_tmp23_);
		} else {
			StructureModel* _tmp24_;
			GtkTreeIter _tmp25_;
			_tmp24_ = self->priv->_model;
			_tmp25_ = *tree_iter;
			structure_model_shift_left (_tmp24_, &_tmp25_);
		}
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp26_ = *tree_iter;
	_tmp29_ = document_structure_get_exact_item_bounds (self, &_tmp26_, &_tmp27_, &_tmp28_);
	start_iter = _tmp27_;
	end_iter = _tmp28_;
	found = _tmp29_;
	_tmp30_ = found;
	if (!_tmp30_) {
		GError* _tmp31_;
		_tmp31_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
		_inner_error_ = _tmp31_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (gtk_text_iter_get_line (&start_iter) != gtk_text_iter_get_line (&end_iter)) {
		document_structure_backward_indentation (self, &start_iter);
		document_structure_backward_indentation (self, &end_iter);
	}
	if (action_type == STRUCT_ACTION_SELECT) {
		Document* _tmp32_;
		GtkTextIter _tmp33_;
		GtkTextIter _tmp34_;
		_tmp32_ = self->priv->_doc;
		_tmp33_ = start_iter;
		_tmp34_ = end_iter;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp32_, &_tmp33_, &_tmp34_);
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	if (action_type == STRUCT_ACTION_COPY) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = action_type == STRUCT_ACTION_CUT;
	}
	if (_tmp35_) {
		gchar* data = NULL;
		Document* _tmp36_;
		GtkTextIter _tmp37_;
		GtkTextIter _tmp38_;
		gchar* _tmp39_;
		GtkClipboard* clipboard = NULL;
		GtkClipboard* _tmp40_;
		GtkClipboard* _tmp41_;
		GtkClipboard* _tmp42_;
		const gchar* _tmp43_;
		_tmp36_ = self->priv->_doc;
		_tmp37_ = start_iter;
		_tmp38_ = end_iter;
		_tmp39_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp36_, &_tmp37_, &_tmp38_, FALSE);
		data = _tmp39_;
		_tmp40_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
		_tmp41_ = _g_object_ref0 (_tmp40_);
		clipboard = _tmp41_;
		_tmp42_ = clipboard;
		_tmp43_ = data;
		gtk_clipboard_set_text (_tmp42_, _tmp43_, -1);
		_g_object_unref0 (clipboard);
		_g_free0 (data);
	}
	if (action_type == STRUCT_ACTION_DELETE) {
		_tmp44_ = TRUE;
	} else {
		_tmp44_ = action_type == STRUCT_ACTION_CUT;
	}
	if (_tmp44_) {
		Document* _tmp45_;
		Document* _tmp46_;
		Document* _tmp47_;
		StructureModel* _tmp48_;
		GtkTreeIter _tmp49_;
		_tmp45_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp45_);
		_tmp46_ = self->priv->_doc;
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp46_, &start_iter, &end_iter);
		_tmp47_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp47_);
		_tmp48_ = self->priv->_model;
		_tmp49_ = *tree_iter;
		structure_model_delete (_tmp48_, &_tmp49_);
		_vala_refresh_simple_list = TRUE;
	}
	if (refresh_simple_list) {
		*refresh_simple_list = _vala_refresh_simple_list;
	}
}


static gboolean
document_structure_comment_item (DocumentStructure* self, 
                                 GtkTreeIter* tree_iter)
{
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean end_iter_set = FALSE;
	Document* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextMark* _tmp6_;
	StructType _tmp10_;
	GtkTreeIter* next_section_iter = NULL;
	gboolean go_one_line_backward = FALSE;
	GtkTreeIter* _tmp24_;
	gboolean _tmp34_;
	Document* _tmp35_;
	GtkTextIter _tmp36_;
	GtkTextIter _tmp37_;
	gboolean _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, -1, -1);
	end_iter = _tmp2_;
	end_iter_set = FALSE;
	_tmp3_ = self->priv->_doc;
	_tmp4_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	start_iter = _tmp5_;
	_tmp6_ = end_mark;
	if (_tmp6_ != NULL) {
		Document* _tmp7_;
		GtkTextMark* _tmp8_;
		GtkTextIter _tmp9_ = {0};
		_tmp7_ = self->priv->_doc;
		_tmp8_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
		end_iter = _tmp9_;
		end_iter_set = TRUE;
	}
	_tmp10_ = type;
	if (!structure_is_section (_tmp10_)) {
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		gboolean _tmp14_;
		_tmp11_ = self->priv->_doc;
		_tmp12_ = start_iter;
		_tmp13_ = end_iter;
		_tmp14_ = end_iter_set;
		document_comment_between (_tmp11_, &_tmp12_, &_tmp13_, _tmp14_);
		result = TRUE;
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	next_section_iter = NULL;
	{
		GtkTreeIter* _tmp15_ = NULL;
		StructureModel* _tmp16_;
		GtkTreeIter _tmp17_;
		GtkTreeIter* _tmp18_;
		GtkTreeIter* _tmp20_;
		_tmp16_ = self->priv->_model;
		_tmp17_ = *tree_iter;
		_tmp18_ = structure_model_get_next_sibling_or_parent (_tmp16_, &_tmp17_, &_inner_error_);
		_tmp15_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp19_ = FALSE;
			if (_inner_error_->domain == STRUCT_ERROR) {
				goto __catch6_struct_error;
			}
			_g_free0 (next_section_iter);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp19_;
		}
		_tmp20_ = _tmp15_;
		_tmp15_ = NULL;
		_g_free0 (next_section_iter);
		next_section_iter = _tmp20_;
		_g_free0 (_tmp15_);
	}
	goto __finally6;
	__catch6_struct_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("document_structure.vala:823: Structure: get next sibling or parent: %s", _tmp22_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp23_ = FALSE;
		_g_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp23_;
	}
	go_one_line_backward = TRUE;
	_tmp24_ = next_section_iter;
	if (_tmp24_ == NULL) {
		gboolean end_of_file = FALSE;
		gboolean _tmp25_ = FALSE;
		GtkTextIter _tmp26_ = {0};
		gboolean _tmp27_;
		document_structure_get_end_document_iter (self, &_tmp25_, &_tmp26_);
		end_of_file = _tmp25_;
		end_iter = _tmp26_;
		end_iter_set = TRUE;
		_tmp27_ = end_of_file;
		go_one_line_backward = !_tmp27_;
	} else {
		StructureModel* _tmp28_;
		GtkTreeIter* _tmp29_;
		GtkTreeIter _tmp30_;
		Document* _tmp31_;
		GtkTextMark* _tmp32_;
		GtkTextIter _tmp33_ = {0};
		_tmp28_ = self->priv->_model;
		_tmp29_ = next_section_iter;
		_tmp30_ = *_tmp29_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp28_, &_tmp30_, STRUCT_COLUMN_START_MARK, &end_mark, -1, -1);
		_tmp31_ = self->priv->_doc;
		_tmp32_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp31_, &_tmp33_, _tmp32_);
		end_iter = _tmp33_;
		end_iter_set = TRUE;
	}
	_tmp34_ = go_one_line_backward;
	if (_tmp34_) {
		if (!gtk_text_iter_backward_line (&end_iter)) {
			end_iter_set = FALSE;
		}
	}
	_tmp35_ = self->priv->_doc;
	_tmp36_ = start_iter;
	_tmp37_ = end_iter;
	_tmp38_ = end_iter_set;
	document_comment_between (_tmp35_, &_tmp36_, &_tmp37_, _tmp38_);
	result = TRUE;
	_g_free0 (next_section_iter);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	return result;
}


static gboolean
document_structure_get_exact_item_bounds (DocumentStructure* self, 
                                          GtkTreeIter* tree_iter, 
                                          GtkTextIter* start_iter, 
                                          GtkTextIter* end_iter)
{
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gboolean result = FALSE;
	StructType item_type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	gchar* item_contents = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	Document* _tmp2_;
	GtkTextMark* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gboolean found = FALSE;
	StructType _tmp5_;
	const gchar* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gboolean _tmp9_;
	gboolean _tmp10_;
	StructType _tmp11_;
	GtkTextMark* _tmp34_;
	GtkTextIter end_env_iter = {0};
	Document* _tmp35_;
	GtkTextMark* _tmp36_;
	GtkTextIter _tmp37_ = {0};
	StructType _tmp38_;
	const gchar* _tmp39_;
	GtkTextIter _tmp40_;
	GtkTextIter _tmp41_ = {0};
	gboolean _tmp42_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	item_contents = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
	_tmp2_ = self->priv->_doc;
	_tmp3_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp2_, &_tmp4_, _tmp3_);
	_vala_start_iter = _tmp4_;
	_tmp5_ = item_type;
	_tmp6_ = item_contents;
	_tmp7_ = _vala_start_iter;
	_tmp9_ = document_structure_get_low_level_item_bounds (self, _tmp5_, _tmp6_, &_tmp7_, TRUE, &_tmp8_);
	_vala_end_iter = _tmp8_;
	found = _tmp9_;
	_tmp10_ = found;
	if (!_tmp10_) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	_tmp11_ = item_type;
	if (structure_is_section (_tmp11_)) {
		GtkTreeIter* next_section_iter = NULL;
		GtkTreeIter* _tmp21_;
		StructureModel* _tmp23_;
		GtkTreeIter* _tmp24_;
		GtkTreeIter _tmp25_;
		Document* _tmp26_;
		GtkTextMark* _tmp27_;
		GtkTextIter _tmp28_ = {0};
		StructType _tmp29_;
		const gchar* _tmp30_;
		GtkTextIter _tmp31_;
		gboolean _tmp32_;
		next_section_iter = NULL;
		{
			GtkTreeIter* _tmp12_ = NULL;
			StructureModel* _tmp13_;
			GtkTreeIter _tmp14_;
			GtkTreeIter* _tmp15_;
			GtkTreeIter* _tmp17_;
			_tmp13_ = self->priv->_model;
			_tmp14_ = *tree_iter;
			_tmp15_ = structure_model_get_next_sibling_or_parent (_tmp13_, &_tmp14_, &_inner_error_);
			_tmp12_ = _tmp15_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp16_ = FALSE;
				if (_inner_error_->domain == STRUCT_ERROR) {
					goto __catch7_struct_error;
				}
				_g_free0 (next_section_iter);
				_g_free0 (item_contents);
				_g_object_unref0 (end_mark);
				_g_object_unref0 (start_mark);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp16_;
			}
			_tmp17_ = _tmp12_;
			_tmp12_ = NULL;
			_g_free0 (next_section_iter);
			next_section_iter = _tmp17_;
			_g_free0 (_tmp12_);
		}
		goto __finally7;
		__catch7_struct_error:
		{
			GError* e = NULL;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("document_structure.vala:898: Structure: get next sibling or parent: %s", _tmp19_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp20_ = FALSE;
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp20_;
		}
		_tmp21_ = next_section_iter;
		if (_tmp21_ == NULL) {
			GtkTextIter _tmp22_ = {0};
			document_structure_get_end_document_iter (self, NULL, &_tmp22_);
			_vala_end_iter = _tmp22_;
			result = TRUE;
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		_tmp23_ = self->priv->_model;
		_tmp24_ = next_section_iter;
		_tmp25_ = *_tmp24_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp23_, &_tmp25_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
		_tmp26_ = self->priv->_doc;
		_tmp27_ = start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp26_, &_tmp28_, _tmp27_);
		_vala_end_iter = _tmp28_;
		_tmp29_ = item_type;
		_tmp30_ = item_contents;
		_tmp31_ = _vala_end_iter;
		_tmp32_ = document_structure_get_low_level_item_bounds (self, _tmp29_, _tmp30_, &_tmp31_, TRUE, NULL);
		result = _tmp32_;
		_g_free0 (next_section_iter);
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	} else {
		StructType _tmp33_;
		_tmp33_ = item_type;
		if (structure_is_common_type (_tmp33_)) {
			result = TRUE;
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
	}
	_tmp34_ = end_mark;
	if (_tmp34_ == NULL) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	_tmp35_ = self->priv->_doc;
	_tmp36_ = end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp35_, &_tmp37_, _tmp36_);
	end_env_iter = _tmp37_;
	_tmp38_ = item_type;
	_tmp39_ = item_contents;
	_tmp40_ = end_env_iter;
	_tmp42_ = document_structure_get_low_level_item_bounds (self, _tmp38_, _tmp39_, &_tmp40_, FALSE, &_tmp41_);
	_vala_end_iter = _tmp41_;
	result = _tmp42_;
	_g_free0 (item_contents);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}


static gboolean
_int_equal (const gint * s1, 
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean
document_structure_get_low_level_item_bounds (DocumentStructure* self, 
                                              StructType item_type, 
                                              const gchar* item_contents, 
                                              GtkTextIter* start_match_iter, 
                                              gboolean is_start, 
                                              GtkTextIter* end_match_iter)
{
	GtkTextIter _vala_end_match_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp1_;
	gchar* _tmp2_;
	gint start_index = 0;
	StructType* low_level_type = NULL;
	gchar* contents = NULL;
	gint* start_match_index = NULL;
	gint* end_match_index = NULL;
	gboolean found = FALSE;
	const gchar* _tmp3_;
	gint _tmp4_;
	StructType* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gint* _tmp7_ = NULL;
	gint* _tmp8_ = NULL;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	const gchar* _tmp14_;
	StructType* _tmp16_;
	const gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (start_match_iter != NULL, FALSE);
	_vala_end_match_iter = _tmp0_;
	_tmp1_ = *start_match_iter;
	_tmp2_ = document_structure_get_line_contents_at_iter (self, &_tmp1_);
	line = _tmp2_;
	start_index = gtk_text_iter_get_line_index (start_match_iter);
	_tmp3_ = line;
	_tmp4_ = start_index;
	_tmp9_ = document_structure_search_low_level_item (self, _tmp3_, _tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	_g_free0 (low_level_type);
	low_level_type = _tmp5_;
	_g_free0 (contents);
	contents = _tmp6_;
	_g_free0 (start_match_index);
	start_match_index = _tmp7_;
	_g_free0 (end_match_index);
	end_match_index = _tmp8_;
	found = _tmp9_;
	_tmp11_ = found;
	if (!_tmp11_) {
		_tmp10_ = TRUE;
	} else {
		gint _tmp12_;
		gint* _tmp13_;
		_tmp12_ = start_index;
		_tmp13_ = start_match_index;
		_tmp10_ = _int_equal (&_tmp12_, _tmp13_) != TRUE;
	}
	if (_tmp10_) {
		result = FALSE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	_tmp14_ = contents;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp15_;
	}
	_tmp16_ = low_level_type;
	_tmp17_ = contents;
	if (document_structure_same_items (self, item_type, item_contents, *_tmp16_, _tmp17_, is_start)) {
		GtkTextIter _tmp18_;
		gint* _tmp19_;
		_tmp18_ = *start_match_iter;
		_vala_end_match_iter = _tmp18_;
		_tmp19_ = end_match_index;
		gtk_text_iter_set_line_index (&_vala_end_match_iter, *_tmp19_);
		result = TRUE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	result = FALSE;
	_g_free0 (end_match_index);
	_g_free0 (start_match_index);
	_g_free0 (contents);
	_g_free0 (low_level_type);
	_g_free0 (line);
	if (end_match_iter) {
		*end_match_iter = _vala_end_match_iter;
	}
	return result;
}


static gboolean
document_structure_same_items (DocumentStructure* self, 
                               StructType item_type, 
                               const gchar* item_contents, 
                               StructType item_found_type, 
                               const gchar* item_found_contents, 
                               gboolean start)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (item_found_contents != NULL, FALSE);
	if (structure_is_common_type (item_found_type)) {
		gboolean same_type = FALSE;
		gboolean same_contents = FALSE;
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		same_type = item_type == item_found_type;
		same_contents = g_strcmp0 (item_contents, item_found_contents) == 0;
		_tmp1_ = same_type;
		if (_tmp1_) {
			gboolean _tmp2_;
			_tmp2_ = same_contents;
			_tmp0_ = _tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
	if (item_type == STRUCT_TYPE_FIGURE) {
		if (start) {
			result = item_found_type == STRUCT_TYPE_BEGIN_FIGURE;
			return result;
		} else {
			result = item_found_type == STRUCT_TYPE_END_FIGURE;
			return result;
		}
	}
	if (item_type == STRUCT_TYPE_TABLE) {
		if (start) {
			result = item_found_type == STRUCT_TYPE_BEGIN_TABLE;
			return result;
		} else {
			result = item_found_type == STRUCT_TYPE_END_TABLE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static void
document_structure_get_end_document_iter (DocumentStructure* self, 
                                          gboolean* end_of_file, 
                                          GtkTextIter* result)
{
	gboolean _vala_end_of_file = FALSE;
	GtkTextMark* _tmp0_;
	GtkTextIter eof_iter = {0};
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_end_document_mark;
	if (_tmp0_ != NULL) {
		GtkTextIter end_document_iter = {0};
		Document* _tmp1_;
		GtkTextMark* _tmp2_;
		GtkTextIter _tmp3_ = {0};
		_vala_end_of_file = FALSE;
		_tmp1_ = self->priv->_doc;
		_tmp2_ = self->priv->_end_document_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp1_, &_tmp3_, _tmp2_);
		end_document_iter = _tmp3_;
		*result = end_document_iter;
		if (end_of_file) {
			*end_of_file = _vala_end_of_file;
		}
		return;
	}
	_vala_end_of_file = TRUE;
	_tmp4_ = self->priv->_doc;
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) _tmp4_, &_tmp5_);
	eof_iter = _tmp5_;
	*result = eof_iter;
	if (end_of_file) {
		*end_of_file = _vala_end_of_file;
	}
	return;
}


static void
document_structure_backward_indentation (DocumentStructure* self, 
                                         GtkTextIter* iter)
{
	gint line_num = 0;
	GtkTextIter begin_line_iter = {0};
	Document* _tmp0_;
	gint _tmp1_;
	GtkTextIter _tmp2_ = {0};
	gchar* text_between = NULL;
	Document* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	if (gtk_text_iter_starts_line (iter)) {
		return;
	}
	line_num = gtk_text_iter_get_line (iter);
	_tmp0_ = self->priv->_doc;
	_tmp1_ = line_num;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp0_, &_tmp2_, _tmp1_);
	begin_line_iter = _tmp2_;
	_tmp3_ = self->priv->_doc;
	_tmp4_ = begin_line_iter;
	_tmp5_ = *iter;
	_tmp6_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp3_, &_tmp4_, &_tmp5_, FALSE);
	text_between = _tmp6_;
	_tmp7_ = text_between;
	_tmp8_ = string_strip (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strcmp0 (_tmp9_, "") == 0;
	_g_free0 (_tmp9_);
	if (_tmp10_) {
		GtkTextIter _tmp11_;
		_tmp11_ = begin_line_iter;
		*iter = _tmp11_;
	}
	_g_free0 (text_between);
}


static gchar
string_get (const gchar* self, 
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
document_structure_shift_item (DocumentStructure* self, 
                               GtkTreeIter* tree_iter, 
                               gboolean shift_right, 
                               gboolean* doc_modified)
{
	gboolean _vala_doc_modified = FALSE;
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp4_;
	GtkTextIter text_iter = {0};
	Document* _tmp5_;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp8_;
	gchar* _tmp9_;
	gint backslash_index = 0;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint after_backslash_index = 0;
	gint _tmp12_;
	gchar* markup_name = NULL;
	const gchar* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	StructType* markup_type = NULL;
	const gchar* _tmp17_;
	StructType* _tmp18_;
	StructType* _tmp19_;
	StructType markup_type_hack = 0;
	StructType* _tmp20_;
	StructType _tmp21_;
	StructType _tmp22_;
	gboolean with_star = FALSE;
	const gchar* _tmp23_;
	StructType new_type = 0;
	gchar* new_markup_name = NULL;
	StructType _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp29_;
	GtkTextIter begin_markup_name_iter = {0};
	GtkTextIter _tmp32_;
	gint _tmp33_;
	GtkTextIter end_markup_name_iter = {0};
	GtkTextIter _tmp34_;
	gint _tmp35_;
	const gchar* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	Document* _tmp39_;
	Document* _tmp40_;
	const gchar* _tmp41_;
	gint nb_children = 0;
	StructureModel* _tmp42_;
	GtkTreeIter _tmp43_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	_vala_doc_modified = FALSE;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &mark, -1);
	if (shift_right) {
		StructType _tmp2_;
		_tmp2_ = type;
		g_return_val_if_fail (_tmp2_ != STRUCT_TYPE_SUBPARAGRAPH, FALSE);
	} else {
		StructType _tmp3_;
		_tmp3_ = type;
		g_return_val_if_fail (_tmp3_ != STRUCT_TYPE_PART, FALSE);
	}
	_tmp4_ = type;
	if (!structure_is_section (_tmp4_)) {
		result = TRUE;
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp5_ = self->priv->_doc;
	_tmp6_ = mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp5_, &_tmp7_, _tmp6_);
	text_iter = _tmp7_;
	_tmp8_ = text_iter;
	_tmp9_ = document_structure_get_line_contents_at_iter (self, &_tmp8_);
	line = _tmp9_;
	backslash_index = gtk_text_iter_get_line_index (&text_iter);
	_tmp10_ = line;
	_tmp11_ = backslash_index;
	if (string_get (_tmp10_, (glong) _tmp11_) != '\\') {
		result = FALSE;
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp12_ = backslash_index;
	after_backslash_index = _tmp12_ + 1;
	_tmp13_ = line;
	_tmp14_ = after_backslash_index;
	_tmp15_ = document_structure_get_markup_name (self, _tmp13_, _tmp14_, NULL);
	markup_name = _tmp15_;
	_tmp16_ = markup_name;
	if (_tmp16_ == NULL) {
		result = FALSE;
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp17_ = markup_name;
	_tmp18_ = document_structure_get_markup_type (self, _tmp17_);
	markup_type = _tmp18_;
	_tmp19_ = markup_type;
	if (_tmp19_ == NULL) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp20_ = markup_type;
	markup_type_hack = *_tmp20_;
	_tmp21_ = type;
	_tmp22_ = markup_type_hack;
	if (((gint) _tmp21_) != ((gint) _tmp22_)) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp23_ = markup_name;
	with_star = g_str_has_suffix (_tmp23_, "*");
	if (shift_right) {
		StructType _tmp24_;
		_tmp24_ = type;
		new_type = _tmp24_ + 1;
	} else {
		StructType _tmp25_;
		_tmp25_ = type;
		new_type = _tmp25_ - 1;
	}
	_tmp26_ = new_type;
	_tmp27_ = document_structure_get_section_name_from_type (self, _tmp26_);
	new_markup_name = _tmp27_;
	_tmp28_ = new_markup_name;
	g_return_val_if_fail (_tmp28_ != NULL, FALSE);
	_tmp29_ = with_star;
	if (_tmp29_) {
		const gchar* _tmp30_;
		gchar* _tmp31_;
		_tmp30_ = new_markup_name;
		_tmp31_ = g_strconcat (_tmp30_, "*", NULL);
		_g_free0 (new_markup_name);
		new_markup_name = _tmp31_;
	}
	_tmp32_ = text_iter;
	begin_markup_name_iter = _tmp32_;
	_tmp33_ = after_backslash_index;
	gtk_text_iter_set_line_index (&begin_markup_name_iter, _tmp33_);
	_tmp34_ = text_iter;
	end_markup_name_iter = _tmp34_;
	_tmp35_ = after_backslash_index;
	_tmp36_ = markup_name;
	_tmp37_ = strlen (_tmp36_);
	_tmp38_ = _tmp37_;
	gtk_text_iter_set_line_index (&end_markup_name_iter, _tmp35_ + _tmp38_);
	_tmp39_ = self->priv->_doc;
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp39_, &begin_markup_name_iter, &end_markup_name_iter);
	_tmp40_ = self->priv->_doc;
	_tmp41_ = new_markup_name;
	document_insert (_tmp40_, &begin_markup_name_iter, _tmp41_, -1);
	_vala_doc_modified = TRUE;
	_tmp42_ = self->priv->_model;
	_tmp43_ = *tree_iter;
	nb_children = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp42_, &_tmp43_);
	{
		gint child_num = 0;
		child_num = 0;
		{
			gboolean _tmp44_ = FALSE;
			_tmp44_ = TRUE;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				GtkTreeIter child_iter = {0};
				gboolean child_iter_set = FALSE;
				StructureModel* _tmp48_;
				GtkTreeIter _tmp49_;
				gint _tmp50_;
				GtkTreeIter _tmp51_ = {0};
				gboolean _tmp52_;
				gboolean _tmp53_;
				GtkTreeIter _tmp54_;
				gboolean _tmp55_;
				if (!_tmp44_) {
					gint _tmp45_;
					_tmp45_ = child_num;
					child_num = _tmp45_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp46_ = child_num;
				_tmp47_ = nb_children;
				if (!(_tmp46_ < _tmp47_)) {
					break;
				}
				_tmp48_ = self->priv->_model;
				_tmp49_ = *tree_iter;
				_tmp50_ = child_num;
				_tmp52_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp48_, &_tmp51_, &_tmp49_, _tmp50_);
				child_iter = _tmp51_;
				child_iter_set = _tmp52_;
				_tmp53_ = child_iter_set;
				g_return_val_if_fail (_tmp53_, FALSE);
				_tmp54_ = child_iter;
				_tmp55_ = document_structure_shift_item (self, &_tmp54_, shift_right, NULL);
				if (!_tmp55_) {
					result = FALSE;
					_g_free0 (new_markup_name);
					_g_free0 (markup_type);
					_g_free0 (markup_name);
					_g_free0 (line);
					_g_object_unref0 (mark);
					if (doc_modified) {
						*doc_modified = _vala_doc_modified;
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (new_markup_name);
	_g_free0 (markup_type);
	_g_free0 (markup_name);
	_g_free0 (line);
	_g_object_unref0 (mark);
	if (doc_modified) {
		*doc_modified = _vala_doc_modified;
	}
	return result;
}


static gchar*
document_structure_get_section_name_from_type (DocumentStructure* self, 
                                               StructType type)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_structure__section_names;
	_tmp0__length1 = document_structure__section_names_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp1_ = g_new0 (gchar*, 7 + 1);
		document_structure__section_names = (_vala_array_free (document_structure__section_names, document_structure__section_names_length1, (GDestroyNotify) g_free), NULL);
		document_structure__section_names = _tmp1_;
		document_structure__section_names_length1 = 7;
		_document_structure__section_names_size_ = document_structure__section_names_length1;
		_tmp2_ = document_structure__section_names;
		_tmp2__length1 = document_structure__section_names_length1;
		_tmp3_ = g_strdup ("part");
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
		_tmp4_ = _tmp2_[STRUCT_TYPE_PART];
		_tmp5_ = document_structure__section_names;
		_tmp5__length1 = document_structure__section_names_length1;
		_tmp6_ = g_strdup ("chapter");
		_g_free0 (_tmp5_[STRUCT_TYPE_CHAPTER]);
		_tmp5_[STRUCT_TYPE_CHAPTER] = _tmp6_;
		_tmp7_ = _tmp5_[STRUCT_TYPE_CHAPTER];
		_tmp8_ = document_structure__section_names;
		_tmp8__length1 = document_structure__section_names_length1;
		_tmp9_ = g_strdup ("section");
		_g_free0 (_tmp8_[STRUCT_TYPE_SECTION]);
		_tmp8_[STRUCT_TYPE_SECTION] = _tmp9_;
		_tmp10_ = _tmp8_[STRUCT_TYPE_SECTION];
		_tmp11_ = document_structure__section_names;
		_tmp11__length1 = document_structure__section_names_length1;
		_tmp12_ = g_strdup ("subsection");
		_g_free0 (_tmp11_[STRUCT_TYPE_SUBSECTION]);
		_tmp11_[STRUCT_TYPE_SUBSECTION] = _tmp12_;
		_tmp13_ = _tmp11_[STRUCT_TYPE_SUBSECTION];
		_tmp14_ = document_structure__section_names;
		_tmp14__length1 = document_structure__section_names_length1;
		_tmp15_ = g_strdup ("subsubsection");
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBSUBSECTION]);
		_tmp14_[STRUCT_TYPE_SUBSUBSECTION] = _tmp15_;
		_tmp16_ = _tmp14_[STRUCT_TYPE_SUBSUBSECTION];
		_tmp17_ = document_structure__section_names;
		_tmp17__length1 = document_structure__section_names_length1;
		_tmp18_ = g_strdup ("paragraph");
		_g_free0 (_tmp17_[STRUCT_TYPE_PARAGRAPH]);
		_tmp17_[STRUCT_TYPE_PARAGRAPH] = _tmp18_;
		_tmp19_ = _tmp17_[STRUCT_TYPE_PARAGRAPH];
		_tmp20_ = document_structure__section_names;
		_tmp20__length1 = document_structure__section_names_length1;
		_tmp21_ = g_strdup ("subparagraph");
		_g_free0 (_tmp20_[STRUCT_TYPE_SUBPARAGRAPH]);
		_tmp20_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp21_;
		_tmp22_ = _tmp20_[STRUCT_TYPE_SUBPARAGRAPH];
	}
	g_return_val_if_fail (structure_is_section (type), NULL);
	_tmp23_ = document_structure__section_names;
	_tmp23__length1 = document_structure__section_names_length1;
	_tmp24_ = _tmp23_[type];
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	return result;
}


gboolean
document_structure_get_parsing_done (DocumentStructure* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_parsing_done;
	result = _tmp0_;
	return result;
}


static void
document_structure_set_parsing_done (DocumentStructure* self, 
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	if (document_structure_get_parsing_done (self) != value) {
		self->priv->_parsing_done = value;
		g_object_notify_by_pspec ((GObject *) self, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY]);
	}
}


static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}


static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}


static void
document_structure_env_data_copy (const DocumentStructureEnvData* self, 
                                  DocumentStructureEnvData* dest)
{
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	StructType _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = (*self).path;
	_tmp1_ = __vala_GtkTreePath_copy0 (_tmp0_);
	__vala_GtkTreePath_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	_tmp2_ = (*self).type;
	(*dest).type = _tmp2_;
	_tmp3_ = (*self).first_caption;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).first_caption);
	(*dest).first_caption = _tmp4_;
}


static void
document_structure_env_data_destroy (DocumentStructureEnvData* self)
{
	__vala_GtkTreePath_free0 ((*self).path);
	_g_free0 ((*self).first_caption);
}


static DocumentStructureEnvData*
document_structure_env_data_dup (const DocumentStructureEnvData* self)
{
	DocumentStructureEnvData* dup;
	dup = g_new0 (DocumentStructureEnvData, 1);
	document_structure_env_data_copy (self, dup);
	return dup;
}


static void
document_structure_env_data_free (DocumentStructureEnvData* self)
{
	document_structure_env_data_destroy (self);
	g_free (self);
}


static GType
document_structure_env_data_get_type (void)
{
	static volatile gsize document_structure_env_data_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_env_data_type_id__volatile)) {
		GType document_structure_env_data_type_id;
		document_structure_env_data_type_id = g_boxed_type_register_static ("DocumentStructureEnvData", (GBoxedCopyFunc) document_structure_env_data_dup, (GBoxedFreeFunc) document_structure_env_data_free);
		g_once_init_leave (&document_structure_env_data_type_id__volatile, document_structure_env_data_type_id);
	}
	return document_structure_env_data_type_id__volatile;
}


static void
document_structure_class_init (DocumentStructureClass * klass)
{
	document_structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentStructurePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_structure_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_structure_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_structure_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY] = g_param_spec_boolean ("parsing-done", "parsing-done", "parsing-done", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void
document_structure_instance_init (DocumentStructure * self)
{
	self->priv = DOCUMENT_STRUCTURE_GET_PRIVATE (self);
	self->priv->_nb_marks = 0;
	self->priv->_end_document_mark = NULL;
	self->priv->_model = NULL;
	self->priv->_in_verbatim_env = FALSE;
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	self->priv->_timer = NULL;
	self->priv->_parsing_done = FALSE;
}


static void
document_structure_finalize (GObject * obj)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	_g_object_unref0 (self->priv->_end_document_mark);
	_g_object_unref0 (self->priv->_model);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	_g_timer_destroy0 (self->priv->_timer);
	G_OBJECT_CLASS (document_structure_parent_class)->finalize (obj);
}


GType
document_structure_get_type (void)
{
	static volatile gsize document_structure_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentStructure), 0, (GInstanceInitFunc) document_structure_instance_init, NULL };
		GType document_structure_type_id;
		document_structure_type_id = g_type_register_static (G_TYPE_OBJECT, "DocumentStructure", &g_define_type_info, 0);
		g_once_init_leave (&document_structure_type_id__volatile, document_structure_type_id);
	}
	return document_structure_type_id__volatile;
}


static void
_vala_document_structure_get_property (GObject * object, 
                                       guint property_id, 
                                       GValue * value, 
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
		g_value_set_boolean (value, document_structure_get_parsing_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_document_structure_set_property (GObject * object, 
                                       guint property_id, 
                                       const GValue * value, 
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
		document_structure_set_parsing_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



