/* glatex_app.c generated by valac 0.39.91.20-3233, the Vala compiler
 * generated from glatex_app.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2015, 2017, 2018 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <latexila.h>
#include <gdk/gdk.h>
#include <gee.h>


#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;
typedef struct _GlatexAppPrivate GlatexAppPrivate;
enum  {
	GLATEX_APP_0_PROPERTY,
	GLATEX_APP_NUM_PROPERTIES
};
static GParamSpec* glatex_app_properties[GLATEX_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block21Data Block21Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

struct _GlatexApp {
	GtkApplication parent_instance;
	GlatexAppPrivate * priv;
};

struct _GlatexAppClass {
	GtkApplicationClass parent_class;
};

struct _Block21Data {
	int _ref_count_;
	GlatexApp* self;
	gboolean show_version;
	gboolean new_document;
	gboolean new_window;
};


static gpointer glatex_app_parent_class = NULL;
static GtkCssProvider* glatex_app__provider;
static GtkCssProvider* glatex_app__provider = NULL;

GType glatex_app_get_type (void) G_GNUC_CONST;
static void glatex_app_new_document_cb (GlatexApp* self);
static void _glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void glatex_app_preferences_cb (GlatexApp* self);
static void _glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void glatex_app_manage_build_tools_cb (GlatexApp* self);
static void _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void glatex_app_help_cb (GlatexApp* self);
static void _glatex_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void glatex_app_fundraising_cb (GlatexApp* self);
static void _glatex_app_fundraising_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void glatex_app_about_cb (GlatexApp* self);
static void _glatex_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void glatex_app_quit_cb (GlatexApp* self);
static void _glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
GlatexApp* glatex_app_new (void);
GlatexApp* glatex_app_construct (GType object_type);
static void glatex_app_setup_main_option_entries (GlatexApp* self);
static void glatex_app_startup_cb (GlatexApp* self);
static void _glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                                   gpointer self);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                int files_length1);
static void _glatex_app_open_documents_g_application_open (GApplication* _sender,
                                                    GFile** files,
                                                    int n_files,
                                                    const gchar* hint,
                                                    gpointer self);
static void glatex_app_shutdown_cb (GlatexApp* self);
static void _glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                     gpointer self);
GlatexApp* glatex_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gint __lambda120_ (Block21Data* _data21_);
static gint ___lambda120__g_application_handle_local_options (GApplication* _sender,
                                                       GVariantDict* options,
                                                       gpointer self);
void stock_icons_register_stock_icons (void);
static void glatex_app_setup_theme_extensions (GlatexApp* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void glatex_app_support_backward_search (GlatexApp* self);
static gchar* glatex_app_get_accel_filename (GlatexApp* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
void projects_save (Projects* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
MainWindow* glatex_app_create_window (GlatexApp* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
void preferences_dialog_show_me (GtkWindow* parent);
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type,
                                                          GtkWindow* parent_window);
GType build_tools_preferences_get_type (void) G_GNUC_CONST;
void finance_show_dialog (GtkWindow* parent_window,
                          gboolean startup);
gboolean main_window_quit (MainWindow* self);
static void glatex_app_update_theme (GlatexApp* self);
static void _glatex_app_update_theme_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
GType document_get_type (void) G_GNUC_CONST;
GeeList* glatex_app_get_documents (GlatexApp* self);
GeeList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GeeList* glatex_app_get_views (GlatexApp* self);
GeeList* main_window_get_views (MainWindow* self);
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void __lambda121_ (GlatexApp* self,
                   const gchar* tex_uri,
                   gint line,
                   guint timestamp);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
static void ___lambda121__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                     const gchar* tex_uri,
                                                     gint line,
                                                     guint timestamp,
                                                     gpointer self);
static void glatex_app_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry GLATEX_APP__app_actions[7] = {{"new-document", _glatex_app_new_document_cb_gsimple_action_activate_callback}, {"preferences", _glatex_app_preferences_cb_gsimple_action_activate_callback}, {"manage-build-tools", _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback}, {"help", _glatex_app_help_cb_gsimple_action_activate_callback}, {"fundraising", _glatex_app_fundraising_cb_gsimple_action_activate_callback}, {"about", _glatex_app_about_cb_gsimple_action_activate_callback}, {"quit", _glatex_app_quit_cb_gsimple_action_activate_callback}};

static void
_glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	glatex_app_new_document_cb ((GlatexApp*) self);
}


static void
_glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	glatex_app_preferences_cb ((GlatexApp*) self);
}


static void
_glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	glatex_app_manage_build_tools_cb ((GlatexApp*) self);
}


static void
_glatex_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	glatex_app_help_cb ((GlatexApp*) self);
}


static void
_glatex_app_fundraising_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	glatex_app_fundraising_cb ((GlatexApp*) self);
}


static void
_glatex_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	glatex_app_about_cb ((GlatexApp*) self);
}


static void
_glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	glatex_app_quit_cb ((GlatexApp*) self);
}


static void
_glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                              gpointer self)
{
	glatex_app_startup_cb ((GlatexApp*) self);
}


static void
_glatex_app_open_documents_g_application_open (GApplication* _sender,
                                               GFile** files,
                                               int n_files,
                                               const gchar* hint,
                                               gpointer self)
{
	glatex_app_open_documents ((GlatexApp*) self, files, n_files);
}


static void
_glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                gpointer self)
{
	glatex_app_shutdown_cb ((GlatexApp*) self);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


GlatexApp*
glatex_app_construct (GType object_type)
{
	GlatexApp * self = NULL;
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
	self = (GlatexApp*) g_object_new (object_type, "application-id", "org.gnome.gnome-latex", NULL);
	g_application_set_flags ((GApplication*) self, G_APPLICATION_HANDLES_OPEN);
	g_set_application_name (PACKAGE_NAME);
	gtk_window_set_default_icon_name ("gnome-latex");
	glatex_app_setup_main_option_entries (self);
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _glatex_app_startup_cb_g_application_startup, self, 0);
	g_signal_connect_object ((GApplication*) self, "open", (GCallback) _glatex_app_open_documents_g_application_open, self, 0);
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) _glatex_app_shutdown_cb_g_application_shutdown, self, 0);
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_app = _tmp1_;
	tepl_application_handle_activate (tepl_app);
	_g_object_unref0 (tepl_app);
	return self;
}


GlatexApp*
glatex_app_new (void)
{
	return glatex_app_construct (TYPE_GLATEX_APP);
}


GlatexApp*
glatex_app_get_instance (void)
{
	GlatexApp* result = NULL;
	GApplication* _tmp0_;
	GlatexApp* _tmp1_;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_GLATEX_APP) ? ((GlatexApp*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}


MainWindow*
glatex_app_get_active_main_window (GlatexApp* self)
{
	MainWindow* result = NULL;
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
	GtkApplicationWindow* main_window = NULL;
	TeplApplication* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	GtkApplicationWindow* _tmp6_;
	MainWindow* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tepl_app = _tmp1_;
	_tmp2_ = tepl_app;
	_tmp3_ = tepl_application_get_active_main_window (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	main_window = _tmp4_;
	_tmp5_ = main_window;
	if (_tmp5_ == NULL) {
		result = NULL;
		_g_object_unref0 (main_window);
		_g_object_unref0 (tepl_app);
		return result;
	}
	_tmp6_ = main_window;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp6_) : NULL);
	result = _tmp7_;
	_g_object_unref0 (main_window);
	_g_object_unref0 (tepl_app);
	return result;
}


static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}


static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		GlatexApp* self;
		self = _data21_->self;
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}


static gint
__lambda120_ (Block21Data* _data21_)
{
	GlatexApp* self;
	gint result = 0;
	GError * _inner_error_ = NULL;
	self = _data21_->self;
	if (_data21_->show_version) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	{
		g_application_register ((GApplication*) self, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch26_g_error;
		}
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e->message;
		g_error ("glatex_app.vala:105: Failed to register the application: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp2_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp2_;
	}
	if (_data21_->new_window) {
		g_action_group_activate_action ((GActionGroup*) self, "tepl-new-window", NULL);
	}
	if (_data21_->new_document) {
		g_action_group_activate_action ((GActionGroup*) self, "new-document", NULL);
	}
	result = -1;
	return result;
}


static gint
___lambda120__g_application_handle_local_options (GApplication* _sender,
                                                  GVariantDict* options,
                                                  gpointer self)
{
	gint result;
	result = __lambda120_ (self);
	return result;
}


static void
glatex_app_setup_main_option_entries (GlatexApp* self)
{
	Block21Data* _data21_;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp0_;
	gint options_length1;
	gint _options_size_;
	GOptionEntry _tmp1_ = {0};
	GOptionEntry _tmp2_;
	GOptionEntry _tmp3_ = {0};
	GOptionEntry _tmp4_;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_;
	GOptionEntry _tmp7_ = {0};
	GOptionEntry _tmp8_;
	g_return_if_fail (self != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_data21_->show_version = FALSE;
	_data21_->new_document = FALSE;
	_data21_->new_window = FALSE;
	_tmp0_ = g_new0 (GOptionEntry, 4);
	options = _tmp0_;
	options_length1 = 4;
	_options_size_ = options_length1;
	_tmp1_.long_name = "version";
	_tmp1_.short_name = 'V';
	_tmp1_.flags = 0;
	_tmp1_.arg = G_OPTION_ARG_NONE;
	_tmp1_.arg_data = &_data21_->show_version;
	_tmp1_.description = N_ ("Show the application's version");
	_tmp1_.arg_description = NULL;
	options[0] = _tmp1_;
	_tmp2_ = options[0];
	_tmp3_.long_name = "new-document";
	_tmp3_.short_name = 'n';
	_tmp3_.flags = 0;
	_tmp3_.arg = G_OPTION_ARG_NONE;
	_tmp3_.arg_data = &_data21_->new_document;
	_tmp3_.description = N_ ("Create new document");
	_tmp3_.arg_description = NULL;
	options[1] = _tmp3_;
	_tmp4_ = options[1];
	_tmp5_.long_name = "new-window";
	_tmp5_.short_name = (gchar) 0;
	_tmp5_.flags = 0;
	_tmp5_.arg = G_OPTION_ARG_NONE;
	_tmp5_.arg_data = &_data21_->new_window;
	_tmp5_.description = N_ ("Create a new top-level window in an existing instance of GNOME LaTeX");
	_tmp5_.arg_description = NULL;
	options[2] = _tmp5_;
	_tmp6_ = options[2];
	_tmp7_.long_name = NULL;
	options[3] = _tmp7_;
	_tmp8_ = options[3];
	g_application_add_main_option_entries ((GApplication*) self, options);
	g_signal_connect_data ((GApplication*) self, "handle-local-options", (GCallback) ___lambda120__g_application_handle_local_options, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
	options = (g_free (options), NULL);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}


static void
glatex_app_startup_cb (GlatexApp* self)
{
	GMenuModel* manual_app_menu = NULL;
	GMenu* _tmp0_;
	GMenuModel* _tmp1_;
	GMenuModel* _tmp2_;
	AppSettings* _tmp4_;
	AppSettings* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	latexila_utils_migrate_latexila_to_gnome_latex ();
	g_action_map_add_action_entries ((GActionMap*) self, GLATEX_APP__app_actions, G_N_ELEMENTS (GLATEX_APP__app_actions), self);
	latexila_latex_commands_add_action_infos ((GtkApplication*) self);
	_tmp0_ = gtk_application_get_menu_by_id ((GtkApplication*) self, "manual-app-menu");
	_tmp1_ = _g_object_ref0 ((GMenuModel*) _tmp0_);
	manual_app_menu = _tmp1_;
	_tmp2_ = manual_app_menu;
	if (_tmp2_ == NULL) {
		g_warning ("glatex_app.vala:129: manual-app-menu not available.");
	}
	if (gtk_application_prefers_app_menu ((GtkApplication*) self)) {
		GMenuModel* _tmp3_;
		_tmp3_ = manual_app_menu;
		gtk_application_set_app_menu ((GtkApplication*) self, _tmp3_);
	}
	latexila_utils_register_icons ();
	stock_icons_register_stock_icons ();
	glatex_app_setup_theme_extensions (self);
	_tmp4_ = app_settings_get_default ();
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	glatex_app_support_backward_search (self);
	_tmp6_ = glatex_app_get_accel_filename (self);
	_tmp7_ = _tmp6_;
	gtk_accel_map_load (_tmp7_);
	_g_free0 (_tmp7_);
	g_application_release ((GApplication*) self);
	_g_object_unref0 (manual_app_menu);
}


static void
glatex_app_shutdown_cb (GlatexApp* self)
{
	Projects* _tmp0_;
	Projects* _tmp1_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
	gchar* accel_filename = NULL;
	gchar* _tmp4_;
	GFile* accel_file = NULL;
	GFile* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	projects_save (_tmp1_);
	_projects_unref0 (_tmp1_);
	_tmp2_ = most_used_symbols_get_default ();
	_tmp3_ = _tmp2_;
	most_used_symbols_save (_tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = glatex_app_get_accel_filename (self);
	accel_filename = _tmp4_;
	_tmp5_ = g_file_new_for_path (accel_filename);
	accel_file = _tmp5_;
	{
		latexila_utils_create_parent_directories (accel_file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
		gtk_accel_map_save (accel_filename);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("glatex_app.vala:165: Error when saving accel file: %s", _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (accel_file);
		_g_free0 (accel_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_application_release ((GApplication*) self);
	_g_object_unref0 (accel_file);
	_g_free0 (accel_filename);
}


static void
glatex_app_new_document_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	window = _tmp0_;
	_tmp1_ = window;
	if (_tmp1_ == NULL) {
		MainWindow* _tmp2_;
		_tmp2_ = glatex_app_create_window (self);
		_g_object_unref0 (window);
		window = _tmp2_;
	}
	_tmp3_ = window;
	_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (window);
}


static void
glatex_app_preferences_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	_tmp1_ = _tmp0_;
	preferences_dialog_show_me ((GtkWindow*) _tmp1_);
	_g_object_unref0 (_tmp1_);
}


static void
glatex_app_manage_build_tools_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	BuildToolsPreferences* _tmp2_;
	BuildToolsPreferences* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = build_tools_preferences_new ((GtkWindow*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}


static void
glatex_app_help_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	window = _tmp0_;
	{
		latexila_utils_show_uri ((GtkWidget*) window, "help:gnome-latex", (guint32) GDK_CURRENT_TIME, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("glatex_app.vala:200: Impossible to open the documentation: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (window);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (window);
}


static void
glatex_app_fundraising_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	_tmp1_ = _tmp0_;
	finance_show_dialog ((GtkWindow*) _tmp1_, FALSE);
	_g_object_unref0 (_tmp1_);
}


static void
glatex_app_about_cb (GlatexApp* self)
{
	gchar* comments = NULL;
	gchar* _tmp0_;
	gchar* copyright = NULL;
	gchar* _tmp1_;
	gchar* website = NULL;
	gchar* _tmp2_;
	gchar** authors = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint artists_length1;
	gint _artists_size_;
	MainWindow* _tmp11_;
	MainWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("GNOME LaTeX is a LaTeX editor for the GNOME desktop"));
	comments = _tmp0_;
	_tmp1_ = g_strdup ("Copyright 2009-2018 – Sébastien Wilmet");
	copyright = _tmp1_;
	_tmp2_ = g_strdup ("https://wiki.gnome.org/Apps/GNOME-LaTeX");
	website = _tmp2_;
	_tmp3_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	authors = _tmp4_;
	authors_length1 = 2;
	_authors_size_ = authors_length1;
	_tmp5_ = g_strdup ("Eric Forgeot <e.forgeot@laposte.net>");
	_tmp6_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
	_tmp7_ = g_strdup ("Alexander Wilms <f.alexander.wilms@gmail.com>");
	_tmp8_ = g_strdup ("The Kile Team http://kile.sourceforge.net/");
	_tmp9_ = g_strdup ("Gedit LaTeX Plugin https://wiki.gnome.org/Apps/Gedit/LaTeXPlugin");
	_tmp10_ = g_new0 (gchar*, 6 + 1);
	_tmp10_[0] = _tmp5_;
	_tmp10_[1] = _tmp6_;
	_tmp10_[2] = _tmp7_;
	_tmp10_[3] = _tmp8_;
	_tmp10_[4] = _tmp9_;
	_tmp10_[5] = NULL;
	artists = _tmp10_;
	artists_length1 = 6;
	_artists_size_ = artists_length1;
	_tmp11_ = glatex_app_get_active_main_window (self);
	_tmp12_ = _tmp11_;
	gtk_show_about_dialog ((GtkWindow*) _tmp12_, "program-name", PACKAGE_NAME, "version", PACKAGE_VERSION, "authors", authors, "artists", artists, "comments", comments, "copyright", copyright, "license-type", GTK_LICENSE_GPL_3_0, "title", _ ("About GNOME LaTeX"), "translator-credits", _ ("translator-credits"), "website", website, "logo-icon-name", "gnome-latex", NULL);
	_g_object_unref0 (_tmp12_);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (website);
	_g_free0 (copyright);
	_g_free0 (comments);
}


static void
glatex_app_quit_cb (GlatexApp* self)
{
	gboolean cont = FALSE;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_application_hold ((GApplication*) self);
	cont = TRUE;
	while (TRUE) {
		gboolean _tmp0_;
		MainWindow* main_window = NULL;
		MainWindow* _tmp1_;
		MainWindow* _tmp2_;
		MainWindow* _tmp3_;
		MainWindow* _tmp4_;
		_tmp0_ = cont;
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = glatex_app_get_active_main_window (self);
		main_window = _tmp1_;
		_tmp2_ = main_window;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (main_window);
			break;
		}
		_tmp3_ = main_window;
		gtk_window_present ((GtkWindow*) _tmp3_);
		_tmp4_ = main_window;
		cont = main_window_quit (_tmp4_);
		_g_object_unref0 (main_window);
	}
	_tmp5_ = cont;
	if (_tmp5_) {
		while (TRUE) {
			GtkWindow* _tmp6_;
			GtkWindow* _tmp7_;
			GtkWindow* _tmp8_;
			GtkWindow* _tmp9_;
			_tmp6_ = gtk_application_get_active_window ((GtkApplication*) self);
			_tmp7_ = _tmp6_;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = gtk_application_get_active_window ((GtkApplication*) self);
			_tmp9_ = _tmp8_;
			gtk_widget_destroy ((GtkWidget*) _tmp9_);
		}
	}
	g_application_release ((GApplication*) self);
}


static void
_glatex_app_update_theme_g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
	glatex_app_update_theme ((GlatexApp*) self);
}


static void
glatex_app_setup_theme_extensions (GlatexApp* self)
{
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	g_signal_connect_object ((GObject*) settings, "notify::gtk-theme-name", (GCallback) _glatex_app_update_theme_g_object_notify, self, 0);
	glatex_app_update_theme (self);
	_g_object_unref0 (settings);
}


static void
glatex_app_update_theme (GlatexApp* self)
{
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GtkSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	screen = _tmp3_;
	_tmp4_ = settings;
	g_object_get (_tmp4_, "gtk-theme-name", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strcmp0 (_tmp7_, "Adwaita") == 0;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		GtkCssProvider* _tmp9_;
		GdkScreen* _tmp16_;
		GtkCssProvider* _tmp17_;
		_tmp9_ = glatex_app__provider;
		if (_tmp9_ == NULL) {
			GtkCssProvider* _tmp10_;
			GFile* file = NULL;
			GFile* _tmp11_;
			_tmp10_ = gtk_css_provider_new ();
			_g_object_unref0 (glatex_app__provider);
			glatex_app__provider = _tmp10_;
			_tmp11_ = g_file_new_for_uri ("resource:///org/gnome/gnome-latex/ui/gnome-latex.adwaita.css");
			file = _tmp11_;
			{
				GtkCssProvider* _tmp12_;
				GFile* _tmp13_;
				_tmp12_ = glatex_app__provider;
				_tmp13_ = file;
				gtk_css_provider_load_from_file (_tmp12_, _tmp13_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch29_g_error;
				}
			}
			goto __finally29;
			__catch29_g_error:
			{
				GError* e = NULL;
				GError* _tmp14_;
				const gchar* _tmp15_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp14_ = e;
				_tmp15_ = _tmp14_->message;
				g_warning ("glatex_app.vala:296: Cannot load CSS: %s", _tmp15_);
				_g_error_free0 (e);
			}
			__finally29:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (file);
				_g_object_unref0 (screen);
				_g_object_unref0 (settings);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (file);
		}
		_tmp16_ = screen;
		_tmp17_ = glatex_app__provider;
		gtk_style_context_add_provider_for_screen (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	} else {
		GtkCssProvider* _tmp18_;
		_tmp18_ = glatex_app__provider;
		if (_tmp18_ != NULL) {
			GdkScreen* _tmp19_;
			GtkCssProvider* _tmp20_;
			_tmp19_ = screen;
			_tmp20_ = glatex_app__provider;
			gtk_style_context_remove_provider_for_screen (_tmp19_, (GtkStyleProvider*) _tmp20_);
			_g_object_unref0 (glatex_app__provider);
			glatex_app__provider = NULL;
		}
	}
	_g_object_unref0 (screen);
	_g_object_unref0 (settings);
}


GeeList*
glatex_app_get_documents (GlatexApp* self)
{
	GeeList* result = NULL;
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_documents = (GeeList*) _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				GtkWindow* _tmp3_;
				_tmp3_ = window;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
					_tmp4_ = window;
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp4_) : NULL);
					main_window = _tmp5_;
					_tmp6_ = all_documents;
					_tmp7_ = main_window;
					_tmp8_ = main_window_get_documents (_tmp7_);
					_tmp9_ = _tmp8_;
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
					_g_object_unref0 (_tmp9_);
					_g_object_unref0 (main_window);
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = all_documents;
	return result;
}


GeeList*
glatex_app_get_views (GlatexApp* self)
{
	GeeList* result = NULL;
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_views = (GeeList*) _tmp0_;
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp2_;
			{
				GtkWindow* _tmp3_;
				_tmp3_ = window;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
					_tmp4_ = window;
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp4_) : NULL);
					main_window = _tmp5_;
					_tmp6_ = all_views;
					_tmp7_ = main_window;
					_tmp8_ = main_window_get_views (_tmp7_);
					_tmp9_ = _tmp8_;
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
					_g_object_unref0 (_tmp9_);
					_g_object_unref0 (main_window);
				}
				_g_object_unref0 (window);
			}
		}
	}
	result = all_views;
	return result;
}


MainWindow*
glatex_app_create_window (GlatexApp* self)
{
	MainWindow* result = NULL;
	TeplAbstractFactoryVala* factory = NULL;
	TeplAbstractFactory* _tmp0_;
	TeplAbstractFactoryVala* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	MainWindow* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tepl_abstract_factory_get_singleton ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, tepl_abstract_factory_vala_get_type ()) ? ((TeplAbstractFactoryVala*) _tmp0_) : NULL);
	factory = _tmp1_;
	_tmp2_ = tepl_abstract_factory_vala_create_main_window_vala (factory, (GtkApplication*) self);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	result = _tmp3_;
	_g_object_unref0 (factory);
	return result;
}


void
glatex_app_open_documents (GlatexApp* self,
                           GFile** files,
                           int files_length1)
{
	MainWindow* main_window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	gboolean jump_to = FALSE;
	MainWindow* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_active_main_window (self);
	main_window = _tmp0_;
	_tmp1_ = main_window;
	if (_tmp1_ == NULL) {
		MainWindow* _tmp2_;
		_tmp2_ = glatex_app_create_window (self);
		_g_object_unref0 (main_window);
		main_window = _tmp2_;
	}
	jump_to = TRUE;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < files_length1; file_it = file_it + 1) {
			GFile* _tmp3_;
			GFile* file = NULL;
			_tmp3_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp3_;
			{
				MainWindow* _tmp4_;
				GFile* _tmp5_;
				gboolean _tmp6_;
				DocumentTab* _tmp7_;
				DocumentTab* _tmp8_;
				_tmp4_ = main_window;
				_tmp5_ = file;
				_tmp6_ = jump_to;
				_tmp7_ = main_window_open_document (_tmp4_, _tmp5_, _tmp6_);
				_tmp8_ = _tmp7_;
				_g_object_unref0 (_tmp8_);
				jump_to = FALSE;
				_g_object_unref0 (file);
			}
		}
	}
	_tmp9_ = main_window;
	gtk_window_present ((GtkWindow*) _tmp9_);
	_g_object_unref0 (main_window);
}


static gchar*
glatex_app_get_accel_filename (GlatexApp* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "accels", NULL);
	result = _tmp1_;
	return result;
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void
__lambda121_ (GlatexApp* self,
              const gchar* tex_uri,
              gint line,
              guint timestamp)
{
	GFile* tex_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	MainWindow* main_window = NULL;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
	g_return_if_fail (tex_uri != NULL);
	_tmp0_ = g_file_new_for_uri (tex_uri);
	tex_file = _tmp0_;
	_tmp1_ = tex_file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = string_to_string (tex_uri);
		_tmp3_ = g_strconcat ("Backward search: the file \"", _tmp2_, "\" doesn't exist.", NULL);
		_tmp4_ = _tmp3_;
		g_warning ("glatex_app.vala:381: %s", _tmp4_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (tex_file);
		return;
	}
	_tmp5_ = glatex_app_get_active_main_window (self);
	main_window = _tmp5_;
	_tmp6_ = main_window;
	if (_tmp6_ != NULL) {
		MainWindow* _tmp7_;
		GFile* _tmp8_;
		MainWindow* _tmp9_;
		_tmp7_ = main_window;
		_tmp8_ = tex_file;
		main_window_jump_to_file_position (_tmp7_, _tmp8_, line, line);
		_tmp9_ = main_window;
		gtk_window_present_with_time ((GtkWindow*) _tmp9_, (guint32) timestamp);
	}
	_g_object_unref0 (main_window);
	_g_object_unref0 (tex_file);
}


static void
___lambda121__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                const gchar* tex_uri,
                                                gint line,
                                                guint timestamp,
                                                gpointer self)
{
	__lambda121_ ((GlatexApp*) self, tex_uri, line, timestamp);
}


static void
glatex_app_support_backward_search (GlatexApp* self)
{
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp0_;
	LatexilaSynctex* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = latexila_synctex_get_instance ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	synctex = _tmp1_;
	g_signal_connect_object (synctex, "backward-search", (GCallback) ___lambda121__latexila_synctex_backward_search, self, 0);
	_g_object_unref0 (synctex);
}


static void
glatex_app_class_init (GlatexAppClass * klass)
{
	glatex_app_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = glatex_app_finalize;
}


static void
glatex_app_instance_init (GlatexApp * self)
{
}


static void
glatex_app_finalize (GObject * obj)
{
	GlatexApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GLATEX_APP, GlatexApp);
	G_OBJECT_CLASS (glatex_app_parent_class)->finalize (obj);
}


GType
glatex_app_get_type (void)
{
	static volatile gsize glatex_app_type_id__volatile = 0;
	if (g_once_init_enter (&glatex_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GlatexAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) glatex_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlatexApp), 0, (GInstanceInitFunc) glatex_app_instance_init, NULL };
		GType glatex_app_type_id;
		glatex_app_type_id = g_type_register_static (gtk_application_get_type (), "GlatexApp", &g_define_type_info, 0);
		g_once_init_leave (&glatex_app_type_id__volatile, glatex_app_type_id);
	}
	return glatex_app_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



