/* project_dialogs.c generated by valac 0.39.91.20-3233, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011, 2015 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <gio/gio.h>
#include <tepl/tepl.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block28Data Block28Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block29Data Block29Data;

struct _Block28Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block29Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void __lambda62_ (Block28Data* _data28_);
static void ___lambda62__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender,
                                                    gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window,
                                                    GFile* main_file,
                                                    GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self,
                       Project* new_project,
                       GFile* * conflict_file);
gboolean project_dialogs_configure_project (GtkWindow* main_window,
                                            gint project_id);
Project* projects_get (Projects* self,
                       gint id);
gboolean projects_change_main_file (Projects* self,
                                    gint num,
                                    GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda63_ (Block29Data* _data29_);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void ___lambda63__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda64_ (Block29Data* _data29_);
void projects_delete (Projects* self,
                      gint num);
static void ___lambda64__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda65_ (Block29Data* _data29_);
void projects_clear_all (Projects* self);
static void ___lambda65__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		_g_object_unref0 (_data28_->main_file_chooser);
		_g_object_unref0 (_data28_->directory_chooser);
		g_slice_free (Block28Data, _data28_);
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
__lambda62_ (Block28Data* _data28_)
{
	GFile* dir = NULL;
	GtkFileChooserButton* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	_tmp0_ = _data28_->directory_chooser;
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
	dir = _tmp1_;
	{
		GtkFileChooserButton* _tmp2_;
		_tmp2_ = _data28_->main_file_chooser;
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp2_, dir, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (dir);
}


static void
___lambda62__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender,
                                               gpointer self)
{
	__lambda62_ (self);
}


void
project_dialogs_new_project (MainWindow* main_window)
{
	Block28Data* _data28_;
	GtkDialog* dialog = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkFileChooserButton* _tmp13_;
	GtkWidget* component = NULL;
	GtkFileChooserButton* _tmp14_;
	GtkWidget* _tmp15_;
	GtkWidget* _tmp16_;
	GtkBox* _tmp17_;
	GtkWidget* _tmp18_;
	GtkFileChooserButton* _tmp19_;
	GtkFileChooserButton* _tmp20_;
	GtkWidget* _tmp21_;
	GtkWidget* _tmp22_;
	GtkBox* _tmp23_;
	GtkWidget* _tmp24_;
	GtkBox* _tmp25_;
	GtkFileChooserButton* _tmp26_;
	Document* doc = NULL;
	Document* _tmp27_;
	Document* _tmp28_;
	Document* _tmp29_;
	gboolean _tmp30_ = FALSE;
	Document* _tmp31_;
	GtkDialog* _tmp78_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (main_window != NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	dialog = _tmp2_;
	_tmp3_ = dialog;
	gtk_window_set_title ((GtkWindow*) _tmp3_, _ ("New Project"));
	_tmp4_ = dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp4_, TRUE);
	_tmp5_ = dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) main_window);
	_tmp6_ = dialog;
	gtk_dialog_add_button (_tmp6_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp7_ = dialog;
	gtk_dialog_add_button (_tmp7_, _ ("Crea_te"), (gint) GTK_RESPONSE_OK);
	_tmp8_ = dialog;
	gtk_dialog_set_default_response (_tmp8_, (gint) GTK_RESPONSE_OK);
	_tmp9_ = dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 450, -1);
	_tmp10_ = dialog;
	_tmp11_ = gtk_dialog_get_content_area (_tmp10_);
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_box_get_type ()) ? ((GtkBox*) _tmp11_) : NULL);
	content_area = _tmp12_;
	_tmp13_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	g_object_ref_sink (_tmp13_);
	_data28_->directory_chooser = _tmp13_;
	_tmp14_ = _data28_->directory_chooser;
	_tmp15_ = latexila_utils_get_dialog_component (_ ("Directory"), (GtkWidget*) _tmp14_);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	component = _tmp16_;
	_tmp17_ = content_area;
	_tmp18_ = component;
	gtk_box_pack_start (_tmp17_, _tmp18_, FALSE, TRUE, (guint) 0);
	_tmp19_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Main File"), GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp19_);
	_data28_->main_file_chooser = _tmp19_;
	_tmp20_ = _data28_->main_file_chooser;
	_tmp21_ = latexila_utils_get_dialog_component (_ ("Main File"), (GtkWidget*) _tmp20_);
	_tmp22_ = _g_object_ref0 (_tmp21_);
	_g_object_unref0 (component);
	component = _tmp22_;
	_tmp23_ = content_area;
	_tmp24_ = component;
	gtk_box_pack_start (_tmp23_, _tmp24_, FALSE, TRUE, (guint) 0);
	_tmp25_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	_tmp26_ = _data28_->directory_chooser;
	g_signal_connect_data (_tmp26_, "file-set", (GCallback) ___lambda62__gtk_file_chooser_button_file_set, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	_tmp27_ = main_window_get_active_document (main_window);
	_tmp28_ = _tmp27_;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	doc = _tmp29_;
	_tmp31_ = doc;
	if (_tmp31_ != NULL) {
		Document* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
		_tmp32_ = doc;
		_tmp33_ = document_get_location (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp30_ = _tmp34_ != NULL;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		{
			GtkFileChooserButton* _tmp35_;
			Document* _tmp36_;
			GFile* _tmp37_;
			GFile* _tmp38_;
			GFile* _tmp39_;
			GFile* _tmp40_;
			GtkFileChooserButton* _tmp41_;
			Document* _tmp42_;
			GFile* _tmp43_;
			GFile* _tmp44_;
			_tmp35_ = _data28_->directory_chooser;
			_tmp36_ = doc;
			_tmp37_ = document_get_location (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_file_get_parent (_tmp38_);
			_tmp40_ = _tmp39_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp35_, _tmp40_, &_inner_error_);
			_g_object_unref0 (_tmp40_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch37_g_error;
			}
			_tmp41_ = _data28_->main_file_chooser;
			_tmp42_ = doc;
			_tmp43_ = document_get_location (_tmp42_);
			_tmp44_ = _tmp43_;
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp41_, _tmp44_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch37_g_error;
			}
		}
		goto __finally37;
		__catch37_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally37:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (doc);
			_g_object_unref0 (component);
			_g_object_unref0 (content_area);
			_g_object_unref0 (dialog);
			block28_data_unref (_data28_);
			_data28_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		GtkDialog* _tmp45_;
		GFile* directory = NULL;
		GtkFileChooserButton* _tmp46_;
		GFile* _tmp47_;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp48_;
		GFile* _tmp49_;
		gboolean _tmp50_ = FALSE;
		GFile* _tmp51_;
		GtkDialog* _tmp53_;
		GFile* _tmp54_;
		GFile* _tmp55_;
		Project project = {0};
		GFile* _tmp56_;
		GFile* _tmp57_;
		GFile* _tmp58_;
		GFile* _tmp59_;
		GFile* conflict = NULL;
		Projects* _tmp60_;
		Projects* _tmp61_;
		Project _tmp62_;
		GFile* _tmp63_ = NULL;
		gboolean _tmp64_;
		gboolean _tmp65_;
		GtkDialog* error_dialog = NULL;
		GtkDialog* _tmp66_;
		GFile* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		GtkMessageDialog* _tmp74_;
		GtkDialog* _tmp75_;
		GtkDialog* _tmp76_;
		GtkDialog* _tmp77_;
		_tmp45_ = dialog;
		if (!(gtk_dialog_run (_tmp45_) == ((gint) GTK_RESPONSE_OK))) {
			break;
		}
		_tmp46_ = _data28_->directory_chooser;
		_tmp47_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp46_);
		directory = _tmp47_;
		_tmp48_ = _data28_->main_file_chooser;
		_tmp49_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp48_);
		main_file = _tmp49_;
		_tmp51_ = directory;
		if (_tmp51_ == NULL) {
			_tmp50_ = TRUE;
		} else {
			GFile* _tmp52_;
			_tmp52_ = main_file;
			_tmp50_ = _tmp52_ == NULL;
		}
		if (_tmp50_) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		_tmp53_ = dialog;
		_tmp54_ = main_file;
		_tmp55_ = directory;
		if (!project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp53_, _tmp54_, _tmp55_)) {
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			continue;
		}
		memset (&project, 0, sizeof (Project));
		_tmp56_ = directory;
		_tmp57_ = _g_object_ref0 (_tmp56_);
		_g_object_unref0 (project.directory);
		project.directory = _tmp57_;
		_tmp58_ = main_file;
		_tmp59_ = _g_object_ref0 (_tmp58_);
		_g_object_unref0 (project.main_file);
		project.main_file = _tmp59_;
		_tmp60_ = projects_get_default ();
		_tmp61_ = _tmp60_;
		_tmp62_ = project;
		_tmp64_ = projects_add (_tmp61_, &_tmp62_, &_tmp63_);
		_g_object_unref0 (conflict);
		conflict = _tmp63_;
		_tmp65_ = _tmp64_;
		_projects_unref0 (_tmp61_);
		if (_tmp65_) {
			_g_object_unref0 (conflict);
			project_destroy (&project);
			_g_object_unref0 (main_file);
			_g_object_unref0 (directory);
			break;
		}
		_tmp66_ = dialog;
		_tmp67_ = conflict;
		_tmp68_ = g_file_get_parse_name (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = latexila_utils_replace_home_dir_with_tilde (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strconcat (_tmp71_, "/", NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp66_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("There is a conflict with the project \"%s\"."), _tmp73_);
		g_object_ref_sink (_tmp74_);
		_tmp75_ = (GtkDialog*) _tmp74_;
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
		_g_free0 (_tmp69_);
		error_dialog = _tmp75_;
		_tmp76_ = error_dialog;
		gtk_dialog_run (_tmp76_);
		_tmp77_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp77_);
		_g_object_unref0 (error_dialog);
		_g_object_unref0 (conflict);
		project_destroy (&project);
		_g_object_unref0 (main_file);
		_g_object_unref0 (directory);
	}
	_tmp78_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp78_);
	_g_object_unref0 (doc);
	_g_object_unref0 (component);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}


gboolean
project_dialogs_configure_project (GtkWindow* main_window,
                                   gint project_id)
{
	gboolean result = FALSE;
	Project* project = NULL;
	Projects* _tmp0_;
	Projects* _tmp1_;
	Project* _tmp2_;
	Project* _tmp3_;
	Project* _tmp4_;
	GtkDialog* dialog = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkDialog* _tmp13_;
	GtkDialog* _tmp14_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	gchar* project_dir = NULL;
	Project* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkLabel* location = NULL;
	const gchar* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkWidget* component = NULL;
	GtkLabel* _tmp29_;
	GtkWidget* _tmp30_;
	GtkWidget* _tmp31_;
	GtkBox* _tmp32_;
	GtkWidget* _tmp33_;
	GtkFileChooserButton* main_file_chooser = NULL;
	GtkFileChooserButton* _tmp34_;
	GtkFileChooserButton* _tmp35_;
	GtkWidget* _tmp36_;
	GtkWidget* _tmp37_;
	GtkBox* _tmp38_;
	GtkWidget* _tmp39_;
	GtkBox* _tmp40_;
	gboolean ret = FALSE;
	GtkDialog* _tmp56_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (main_window != NULL, FALSE);
	_tmp0_ = projects_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = projects_get (_tmp1_, project_id);
	_tmp3_ = _tmp2_;
	_projects_unref0 (_tmp1_);
	project = _tmp3_;
	_tmp4_ = project;
	g_return_val_if_fail (_tmp4_ != NULL, FALSE);
	_tmp5_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_tmp6_);
	}
	dialog = _tmp7_;
	_tmp8_ = dialog;
	gtk_window_set_title ((GtkWindow*) _tmp8_, _ ("Configure Project"));
	_tmp9_ = dialog;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp9_, TRUE);
	_tmp10_ = dialog;
	gtk_window_set_transient_for ((GtkWindow*) _tmp10_, main_window);
	_tmp11_ = dialog;
	gtk_dialog_add_button (_tmp11_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp12_ = dialog;
	gtk_dialog_add_button (_tmp12_, _ ("_Apply"), (gint) GTK_RESPONSE_APPLY);
	_tmp13_ = dialog;
	gtk_dialog_set_default_response (_tmp13_, (gint) GTK_RESPONSE_APPLY);
	_tmp14_ = dialog;
	gtk_widget_set_size_request ((GtkWidget*) _tmp14_, 450, -1);
	_tmp15_ = dialog;
	_tmp16_ = gtk_dialog_get_content_area (_tmp15_);
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_box_get_type ()) ? ((GtkBox*) _tmp16_) : NULL);
	content_area = _tmp17_;
	_tmp18_ = project;
	_tmp19_ = (*_tmp18_).directory;
	_tmp20_ = g_file_get_parse_name (_tmp19_);
	project_dir = _tmp20_;
	_tmp21_ = project_dir;
	_tmp22_ = latexila_utils_replace_home_dir_with_tilde (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, "/", NULL);
	_g_free0 (project_dir);
	project_dir = _tmp24_;
	_g_free0 (_tmp23_);
	_tmp25_ = project_dir;
	_tmp26_ = (GtkLabel*) gtk_label_new (_tmp25_);
	g_object_ref_sink (_tmp26_);
	location = _tmp26_;
	_tmp27_ = location;
	gtk_label_set_line_wrap (_tmp27_, TRUE);
	_tmp28_ = location;
	gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
	_tmp29_ = location;
	_tmp30_ = latexila_utils_get_dialog_component (_ ("Location of the project"), (GtkWidget*) _tmp29_);
	_tmp31_ = _g_object_ref0 (_tmp30_);
	component = _tmp31_;
	_tmp32_ = content_area;
	_tmp33_ = component;
	gtk_box_pack_start (_tmp32_, _tmp33_, FALSE, TRUE, (guint) 0);
	_tmp34_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Main File"), GTK_FILE_CHOOSER_ACTION_OPEN);
	g_object_ref_sink (_tmp34_);
	main_file_chooser = _tmp34_;
	_tmp35_ = main_file_chooser;
	_tmp36_ = latexila_utils_get_dialog_component (_ ("Main File"), (GtkWidget*) _tmp35_);
	_tmp37_ = _g_object_ref0 (_tmp36_);
	_g_object_unref0 (component);
	component = _tmp37_;
	_tmp38_ = content_area;
	_tmp39_ = component;
	gtk_box_pack_start (_tmp38_, _tmp39_, FALSE, TRUE, (guint) 0);
	_tmp40_ = content_area;
	gtk_widget_show_all ((GtkWidget*) _tmp40_);
	{
		GtkFileChooserButton* _tmp41_;
		Project* _tmp42_;
		GFile* _tmp43_;
		_tmp41_ = main_file_chooser;
		_tmp42_ = project;
		_tmp43_ = (*_tmp42_).main_file;
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp41_, _tmp43_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch38_g_error;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp44_ = FALSE;
		_g_object_unref0 (main_file_chooser);
		_g_object_unref0 (component);
		_g_object_unref0 (location);
		_g_free0 (project_dir);
		_g_object_unref0 (content_area);
		_g_object_unref0 (dialog);
		_project_free0 (project);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp44_;
	}
	ret = FALSE;
	while (TRUE) {
		GtkDialog* _tmp45_;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp46_;
		GFile* _tmp47_;
		GFile* _tmp48_;
		GtkDialog* _tmp49_;
		GFile* _tmp50_;
		Project* _tmp51_;
		GFile* _tmp52_;
		Projects* _tmp53_;
		Projects* _tmp54_;
		GFile* _tmp55_;
		_tmp45_ = dialog;
		if (!(gtk_dialog_run (_tmp45_) == ((gint) GTK_RESPONSE_APPLY))) {
			break;
		}
		_tmp46_ = main_file_chooser;
		_tmp47_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp46_);
		main_file = _tmp47_;
		_tmp48_ = main_file;
		if (_tmp48_ == NULL) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp49_ = dialog;
		_tmp50_ = main_file;
		_tmp51_ = project;
		_tmp52_ = (*_tmp51_).directory;
		if (!project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp49_, _tmp50_, _tmp52_)) {
			_g_object_unref0 (main_file);
			continue;
		}
		_tmp53_ = projects_get_default ();
		_tmp54_ = _tmp53_;
		_tmp55_ = main_file;
		ret = projects_change_main_file (_tmp54_, project_id, _tmp55_);
		_projects_unref0 (_tmp54_);
		_g_object_unref0 (main_file);
		break;
	}
	_tmp56_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp56_);
	result = ret;
	_g_object_unref0 (main_file_chooser);
	_g_object_unref0 (component);
	_g_object_unref0 (location);
	_g_free0 (project_dir);
	_g_object_unref0 (content_area);
	_g_object_unref0 (dialog);
	_project_free0 (project);
	return result;
}


GType
project_dialogs_project_column_get_type (void)
{
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		_g_object_unref0 (_data29_->treeview);
		_g_object_unref0 (_data29_->store);
		_g_object_unref0 (_data29_->dialog);
		g_slice_free (Block29Data, _data29_);
	}
}


static void
__lambda63_ (Block29Data* _data29_)
{
	gint i = 0;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	_tmp0_ = utils_get_selected_row (_data29_->treeview, NULL);
	i = _tmp0_;
	_tmp2_ = i;
	if (_tmp2_ != -1) {
		gint _tmp3_;
		_tmp3_ = i;
		_tmp1_ = project_dialogs_configure_project ((GtkWindow*) _data29_->dialog, _tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		project_dialogs_update_model (_data29_->store);
	}
}


static void
___lambda63__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda63_ (self);
}


static void
__lambda64_ (Block29Data* _data29_)
{
	GtkTreeIter iter = {0};
	gint i = 0;
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp2_;
	gchar* directory = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GtkDialog* delete_dialog = NULL;
	const gchar* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp13_;
	_tmp1_ = utils_get_selected_row (_data29_->treeview, &_tmp0_);
	iter = _tmp0_;
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == -1) {
		return;
	}
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data29_->store, gtk_tree_model_get_type (), GtkTreeModel));
	model = _tmp3_;
	_tmp4_ = model;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
	_tmp6_ = directory;
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data29_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Do you really want to delete the project \"%s\"?"), _tmp6_);
	g_object_ref_sink (_tmp7_);
	delete_dialog = (GtkDialog*) _tmp7_;
	_tmp8_ = delete_dialog;
	gtk_dialog_add_buttons (_tmp8_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_YES, NULL);
	_tmp9_ = delete_dialog;
	if (gtk_dialog_run (_tmp9_) == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp10_;
		Projects* _tmp11_;
		gint _tmp12_;
		gtk_list_store_remove (_data29_->store, &iter);
		_tmp10_ = projects_get_default ();
		_tmp11_ = _tmp10_;
		_tmp12_ = i;
		projects_delete (_tmp11_, _tmp12_);
		_projects_unref0 (_tmp11_);
	}
	_tmp13_ = delete_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
	_g_object_unref0 (delete_dialog);
	_g_object_unref0 (model);
	_g_free0 (directory);
}


static void
___lambda64__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda64_ (self);
}


static void
__lambda65_ (Block29Data* _data29_)
{
	GtkDialog* clear_dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp6_;
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data29_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you really want to clear all projects?"));
	g_object_ref_sink (_tmp0_);
	clear_dialog = (GtkDialog*) _tmp0_;
	_tmp1_ = clear_dialog;
	gtk_dialog_add_button (_tmp1_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = clear_dialog;
	gtk_dialog_add_button (_tmp2_, _ ("Clear _All"), (gint) GTK_RESPONSE_YES);
	_tmp3_ = clear_dialog;
	if (gtk_dialog_run (_tmp3_) == ((gint) GTK_RESPONSE_YES)) {
		Projects* _tmp4_;
		Projects* _tmp5_;
		_tmp4_ = projects_get_default ();
		_tmp5_ = _tmp4_;
		projects_clear_all (_tmp5_);
		_projects_unref0 (_tmp5_);
		gtk_list_store_clear (_data29_->store);
	}
	_tmp6_ = clear_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
	_g_object_unref0 (clear_dialog);
}


static void
___lambda65__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda65_ (self);
}


void
project_dialogs_manage_projects (MainWindow* main_window)
{
	Block29Data* _data29_;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkListStore* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp10_;
	GtkCellRendererPixbuf* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	GtkCellRendererPixbuf* _tmp13_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp14_;
	GtkTreeViewColumn* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkTreeViewColumn* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	GtkCellRendererPixbuf* _tmp22_;
	GtkCellRendererPixbuf* _tmp23_;
	GtkTreeViewColumn* _tmp24_;
	GtkCellRendererPixbuf* _tmp25_;
	GtkCellRendererText* _tmp26_;
	GtkTreeViewColumn* _tmp27_;
	GtkCellRendererText* _tmp28_;
	GtkTreeViewColumn* _tmp29_;
	GtkCellRendererText* _tmp30_;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp31_;
	GtkTreeSelection* _tmp32_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp33_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp34_;
	GtkButton* edit_button = NULL;
	GtkButton* _tmp35_;
	GtkButton* delete_button = NULL;
	GtkButton* _tmp36_;
	GtkButton* clear_all_button = NULL;
	GtkButton* _tmp37_;
	g_return_if_fail (main_window != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_tmp1_);
	}
	_data29_->dialog = _tmp2_;
	gtk_window_set_title ((GtkWindow*) _data29_->dialog, _ ("Manage Projects"));
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data29_->dialog, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _data29_->dialog, (GtkWindow*) main_window);
	_tmp3_ = gtk_dialog_get_content_area (_data29_->dialog);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
	content_area = _tmp4_;
	gtk_widget_set_size_request ((GtkWidget*) content_area, 450, 250);
	_tmp5_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
	_data29_->store = _tmp5_;
	project_dialogs_update_model (_data29_->store);
	_tmp6_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data29_->store);
	g_object_ref_sink (_tmp6_);
	_data29_->treeview = _tmp6_;
	_tmp7_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp7_);
	column = _tmp7_;
	_tmp8_ = column;
	gtk_tree_view_append_column (_data29_->treeview, _tmp8_);
	_tmp9_ = column;
	gtk_tree_view_column_set_title (_tmp9_, _ ("Directory"));
	_tmp10_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp10_);
	pixbuf_renderer = _tmp10_;
	_tmp11_ = pixbuf_renderer;
	g_object_set (_tmp11_, "icon-name", "folder", NULL);
	_tmp12_ = column;
	_tmp13_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) _tmp13_, FALSE);
	_tmp14_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp14_);
	text_renderer = _tmp14_;
	_tmp15_ = column;
	_tmp16_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) _tmp16_, TRUE);
	_tmp17_ = column;
	_tmp18_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp17_, (GtkCellRenderer*) _tmp18_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
	_tmp19_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (column);
	column = _tmp19_;
	_tmp20_ = column;
	gtk_tree_view_append_column (_data29_->treeview, _tmp20_);
	_tmp21_ = column;
	gtk_tree_view_column_set_title (_tmp21_, _ ("Main File"));
	_tmp22_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (pixbuf_renderer);
	pixbuf_renderer = _tmp22_;
	_tmp23_ = pixbuf_renderer;
	g_object_set (_tmp23_, "icon-name", "text-x-generic", NULL);
	_tmp24_ = column;
	_tmp25_ = pixbuf_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, FALSE);
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (text_renderer);
	text_renderer = _tmp26_;
	_tmp27_ = column;
	_tmp28_ = text_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
	_tmp29_ = column;
	_tmp30_ = text_renderer;
	gtk_tree_view_column_set_attributes (_tmp29_, (GtkCellRenderer*) _tmp30_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
	_tmp31_ = gtk_tree_view_get_selection (_data29_->treeview);
	_tmp32_ = _g_object_ref0 (_tmp31_);
	select = _tmp32_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	_tmp33_ = utils_add_scrollbar ((GtkWidget*) _data29_->treeview);
	sw = _tmp33_;
	gtk_box_pack_start (content_area, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	_tmp34_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp34_);
	grid = _tmp34_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (grid, (guint) 5);
	gtk_box_pack_start (content_area, (GtkWidget*) grid, FALSE, FALSE, (guint) 5);
	_tmp35_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Properties"));
	g_object_ref_sink (_tmp35_);
	edit_button = _tmp35_;
	_tmp36_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Delete"));
	g_object_ref_sink (_tmp36_);
	delete_button = _tmp36_;
	_tmp37_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Clear All"));
	g_object_ref_sink (_tmp37_);
	clear_all_button = _tmp37_;
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) edit_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) delete_button);
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) clear_all_button);
	gtk_widget_show_all ((GtkWidget*) content_area);
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda63__gtk_button_clicked, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda64__gtk_button_clicked, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda65__gtk_button_clicked, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	gtk_dialog_run (_data29_->dialog);
	gtk_widget_destroy ((GtkWidget*) _data29_->dialog);
	_g_object_unref0 (clear_all_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (grid);
	_g_object_unref0 (sw);
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (content_area);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


gboolean
project_dialogs_main_file_is_in_directory (GtkWindow* window,
                                           GFile* main_file,
                                           GFile* directory)
{
	gboolean result = FALSE;
	GtkDialog* error_dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (main_file != NULL, FALSE);
	g_return_val_if_fail (directory != NULL, FALSE);
	if (g_file_has_prefix (main_file, directory)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _ ("The Main File is not in the directory."));
	g_object_ref_sink (_tmp0_);
	error_dialog = (GtkDialog*) _tmp0_;
	_tmp1_ = error_dialog;
	gtk_dialog_run (_tmp1_);
	_tmp2_ = error_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
	result = FALSE;
	_g_object_unref0 (error_dialog);
	return result;
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


void
project_dialogs_update_model (GtkListStore* model)
{
	g_return_if_fail (model != NULL);
	gtk_list_store_clear (model);
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = projects_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = projects_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_projects_unref0 (_tmp1_);
		_project_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			Project project = {0};
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_ = {0};
			Project _tmp9_;
			gchar* uri_directory = NULL;
			Project _tmp10_;
			GFile* _tmp11_;
			gchar* _tmp12_;
			gchar* uri_main_file = NULL;
			Project _tmp13_;
			GFile* _tmp14_;
			gchar* _tmp15_;
			gchar* dir = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* main_file = NULL;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			const gchar* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gchar* _tmp28_;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp29_ = {0};
			GtkTreeIter _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp4_ = _project_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _project_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			_tmp7_ = (Project*) _tmp6_;
			project_copy (_tmp7_, &_tmp8_);
			_tmp9_ = _tmp8_;
			_project_free0 (_tmp7_);
			project = _tmp9_;
			_tmp10_ = project;
			_tmp11_ = _tmp10_.directory;
			_tmp12_ = g_file_get_parse_name (_tmp11_);
			uri_directory = _tmp12_;
			_tmp13_ = project;
			_tmp14_ = _tmp13_.main_file;
			_tmp15_ = g_file_get_parse_name (_tmp14_);
			uri_main_file = _tmp15_;
			_tmp16_ = uri_directory;
			_tmp17_ = latexila_utils_replace_home_dir_with_tilde (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp18_);
			dir = _tmp20_;
			_tmp21_ = uri_main_file;
			_tmp22_ = uri_directory;
			_tmp23_ = strlen (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = uri_main_file;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = string_slice (_tmp21_, (glong) (_tmp24_ + 1), (glong) _tmp27_);
			main_file = _tmp28_;
			gtk_list_store_append (model, &_tmp29_);
			iter = _tmp29_;
			_tmp30_ = iter;
			_tmp31_ = dir;
			_tmp32_ = main_file;
			gtk_list_store_set (model, &_tmp30_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp31_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp32_, -1, -1);
			_g_free0 (main_file);
			_g_free0 (dir);
			_g_free0 (uri_main_file);
			_g_free0 (uri_directory);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
}



