/* projects.c generated by valac 0.39.91.20-3233, the Vala compiler
 * generated from projects.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
typedef struct _ProjectsPrivate ProjectsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _ParamSpecProjects ParamSpecProjects;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Projects {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectsPrivate * priv;
};

struct _ProjectsClass {
	GTypeClass parent_class;
	void (*finalize) (Projects *self);
};

struct _ProjectsPrivate {
	GeeLinkedList* projects;
	gboolean modified;
};

struct _ParamSpecProjects {
	GParamSpec parent_instance;
};


static gpointer projects_parent_class = NULL;
static Projects* projects_instance;
static Projects* projects_instance = NULL;

GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
#define PROJECTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROJECTS, ProjectsPrivate))
static Projects* projects_new (void);
static Projects* projects_construct (GType object_type);
static GFile* projects_get_xml_file (Projects* self);
gchar* utils_load_file (GFile* file);
static void projects_parser_start (Projects* self,
                            GMarkupParseContext* context,
                            const gchar* name,
                            gchar** attr_names,
                            int attr_names_length1,
                            gchar** attr_values,
                            int attr_values_length1,
                            GError** error);
static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                               const gchar* element_name,
                                                               gchar** attribute_names,
                                                               gchar** attribute_values,
                                                               gpointer self,
                                                               GError** error);
static void projects_update_all_documents (Projects* self);
static void projects_update_all_menus (Projects* self);
Projects* projects_get_default (void);
Project* projects_get (Projects* self,
                       gint id);
GeeIterator* projects_iterator (Projects* self);
GType glatex_app_get_type (void) G_GNUC_CONST;
GlatexApp* glatex_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
void main_window_update_config_project_sensitivity (MainWindow* self);
gboolean projects_add (Projects* self,
                       Project* new_project,
                       GFile* * conflict_file);
static gboolean projects_conflict (Projects* self,
                            GFile* dir1,
                            GFile* dir2);
GType document_get_type (void) G_GNUC_CONST;
GeeList* glatex_app_get_documents (GlatexApp* self);
gint document_get_project_id (Document* self);
GFile* document_get_location (Document* self);
void document_set_project_id (Document* self,
                              gint value);
gboolean projects_change_main_file (Projects* self,
                                    gint num,
                                    GFile* new_main_file);
void projects_delete (Projects* self,
                      gint num);
void projects_clear_all (Projects* self);
void projects_save (Projects* self);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
static void projects_finalize (Projects * obj);
static gint _vala_array_length (gpointer array);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
project_copy (const Project* self,
              Project* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	_tmp0_ = (*self).directory;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).directory);
	(*dest).directory = _tmp1_;
	_tmp2_ = (*self).main_file;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).main_file);
	(*dest).main_file = _tmp3_;
}


void
project_destroy (Project* self)
{
	_g_object_unref0 ((*self).directory);
	_g_object_unref0 ((*self).main_file);
}


Project*
project_dup (const Project* self)
{
	Project* dup;
	dup = g_new0 (Project, 1);
	project_copy (self, dup);
	return dup;
}


void
project_free (Project* self)
{
	project_destroy (self);
	g_free (self);
}


GType
project_get_type (void)
{
	static volatile gsize project_type_id__volatile = 0;
	if (g_once_init_enter (&project_type_id__volatile)) {
		GType project_type_id;
		project_type_id = g_boxed_type_register_static ("Project", (GBoxedCopyFunc) project_dup, (GBoxedFreeFunc) project_free);
		g_once_init_leave (&project_type_id__volatile, project_type_id);
	}
	return project_type_id__volatile;
}


static void
_projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                          const gchar* element_name,
                                                          gchar** attribute_names,
                                                          gchar** attribute_values,
                                                          gpointer self,
                                                          GError** error)
{
	projects_parser_start ((Projects*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static Projects*
projects_construct (GType object_type)
{
	Projects* self = NULL;
	GeeLinkedList* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* contents = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	self = (Projects*) g_type_create_instance (object_type);
	_tmp0_ = gee_linked_list_new (TYPE_PROJECT, (GBoxedCopyFunc) project_dup, (GDestroyNotify) project_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->projects);
	self->priv->projects = _tmp0_;
	_tmp1_ = projects_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = file;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		_g_object_unref0 (file);
		return self;
	}
	_tmp3_ = file;
	_tmp4_ = utils_load_file (_tmp3_);
	contents = _tmp4_;
	_tmp5_ = contents;
	if (_tmp5_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return self;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp6_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp7_;
		GMarkupParseContext* _tmp8_;
		GMarkupParseContext* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_.start_element = _projects_parser_start_gmarkup_parser_start_element_func;
		_tmp6_.end_element = NULL;
		_tmp6_.text = NULL;
		_tmp6_.passthrough = NULL;
		_tmp6_.error = NULL;
		parser = _tmp6_;
		_tmp7_ = parser;
		_tmp8_ = g_markup_parse_context_new (&_tmp7_, 0, self, NULL);
		context = _tmp8_;
		_tmp9_ = context;
		_tmp10_ = contents;
		g_markup_parse_context_parse (_tmp9_, _tmp10_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch39_g_error;
		}
		projects_update_all_documents (self);
		projects_update_all_menus (self);
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("projects.vala:59: Impossible to load the projects: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
	return self;
}


static Projects*
projects_new (void)
{
	return projects_construct (TYPE_PROJECTS);
}


static gpointer
_projects_ref0 (gpointer self)
{
	return self ? projects_ref (self) : NULL;
}


Projects*
projects_get_default (void)
{
	Projects* result = NULL;
	Projects* _tmp0_;
	Projects* _tmp2_;
	Projects* _tmp3_;
	_tmp0_ = projects_instance;
	if (_tmp0_ == NULL) {
		Projects* _tmp1_;
		_tmp1_ = projects_new ();
		_projects_unref0 (projects_instance);
		projects_instance = _tmp1_;
	}
	_tmp2_ = projects_instance;
	_tmp3_ = _projects_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


Project*
projects_get (Projects* self,
              gint id)
{
	Project* result = NULL;
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	if (id >= 0) {
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->projects;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = id < _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp4_ = self->priv->projects;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, id);
	result = (Project*) _tmp5_;
	return result;
}


GeeIterator*
projects_iterator (Projects* self)
{
	GeeIterator* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->projects;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERATOR, GeeIterator);
	return result;
}


static void
projects_update_all_menus (Projects* self)
{
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp3_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
			window = _tmp4_;
			{
				GtkWindow* _tmp5_;
				_tmp5_ = window;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_MAIN_WINDOW)) {
					MainWindow* main_window = NULL;
					GtkWindow* _tmp6_;
					MainWindow* _tmp7_;
					MainWindow* _tmp8_;
					_tmp6_ = window;
					_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp6_) : NULL);
					main_window = _tmp7_;
					_tmp8_ = main_window;
					main_window_update_config_project_sensitivity (_tmp8_);
					_g_object_unref0 (main_window);
				}
				_g_object_unref0 (window);
			}
		}
	}
}


gboolean
projects_add (Projects* self,
              Project* new_project,
              GFile* * conflict_file)
{
	GFile* _vala_conflict_file = NULL;
	gboolean result = FALSE;
	GeeLinkedList* _tmp21_;
	Project _tmp22_;
	GeeList* docs = NULL;
	GlatexApp* _tmp23_;
	GlatexApp* _tmp24_;
	GeeList* _tmp25_;
	GeeList* _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_project != NULL, FALSE);
	_g_object_unref0 (_vala_conflict_file);
	_vala_conflict_file = NULL;
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _project_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _project_index = 0;
		_tmp0_ = self->priv->projects;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_project_list = _tmp1_;
		_tmp2_ = _project_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_project_size = _tmp4_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			Project project = {0};
			GeeLinkedList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			Project* _tmp11_;
			Project _tmp12_ = {0};
			Project _tmp13_;
			Project _tmp14_;
			GFile* _tmp15_;
			Project _tmp16_;
			GFile* _tmp17_;
			_tmp5_ = _project_index;
			_project_index = _tmp5_ + 1;
			_tmp6_ = _project_index;
			_tmp7_ = _project_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _project_list;
			_tmp9_ = _project_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			_tmp11_ = (Project*) _tmp10_;
			project_copy (_tmp11_, &_tmp12_);
			_tmp13_ = _tmp12_;
			_project_free0 (_tmp11_);
			project = _tmp13_;
			_tmp14_ = project;
			_tmp15_ = _tmp14_.directory;
			_tmp16_ = *new_project;
			_tmp17_ = _tmp16_.directory;
			if (projects_conflict (self, _tmp15_, _tmp17_)) {
				Project _tmp18_;
				GFile* _tmp19_;
				GFile* _tmp20_;
				_tmp18_ = project;
				_tmp19_ = _tmp18_.directory;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (_vala_conflict_file);
				_vala_conflict_file = _tmp20_;
				result = FALSE;
				project_destroy (&project);
				_g_object_unref0 (_project_list);
				if (conflict_file) {
					*conflict_file = _vala_conflict_file;
				} else {
					_g_object_unref0 (_vala_conflict_file);
				}
				return result;
			}
			project_destroy (&project);
		}
		_g_object_unref0 (_project_list);
	}
	_tmp21_ = self->priv->projects;
	_tmp22_ = *new_project;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, &_tmp22_);
	self->priv->modified = TRUE;
	_tmp23_ = glatex_app_get_instance ();
	_tmp24_ = _tmp23_;
	_tmp25_ = glatex_app_get_documents (_tmp24_);
	_tmp26_ = _tmp25_;
	_g_object_unref0 (_tmp24_);
	docs = _tmp26_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp27_;
		GeeList* _tmp28_;
		gint _doc_size = 0;
		GeeList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _doc_index = 0;
		_tmp27_ = docs;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_doc_list = _tmp28_;
		_tmp29_ = _doc_list;
		_tmp30_ = gee_collection_get_size ((GeeCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_doc_size = _tmp31_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			Document* doc = NULL;
			GeeList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_;
			gboolean _tmp38_ = FALSE;
			Document* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			Document* _tmp45_;
			GFile* _tmp46_;
			GFile* _tmp47_;
			Project _tmp48_;
			GFile* _tmp49_;
			_tmp32_ = _doc_index;
			_doc_index = _tmp32_ + 1;
			_tmp33_ = _doc_index;
			_tmp34_ = _doc_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _doc_list;
			_tmp36_ = _doc_index;
			_tmp37_ = gee_list_get (_tmp35_, _tmp36_);
			doc = (Document*) _tmp37_;
			_tmp39_ = doc;
			_tmp40_ = document_get_project_id (_tmp39_);
			_tmp41_ = _tmp40_;
			if (_tmp41_ != -1) {
				_tmp38_ = TRUE;
			} else {
				Document* _tmp42_;
				GFile* _tmp43_;
				GFile* _tmp44_;
				_tmp42_ = doc;
				_tmp43_ = document_get_location (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp38_ = _tmp44_ == NULL;
			}
			if (_tmp38_) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp45_ = doc;
			_tmp46_ = document_get_location (_tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = *new_project;
			_tmp49_ = _tmp48_.directory;
			if (g_file_has_prefix (_tmp47_, _tmp49_)) {
				Document* _tmp50_;
				GeeLinkedList* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				_tmp50_ = doc;
				_tmp51_ = self->priv->projects;
				_tmp52_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp51_);
				_tmp53_ = _tmp52_;
				document_set_project_id (_tmp50_, _tmp53_ - 1);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	projects_update_all_menus (self);
	result = TRUE;
	_g_object_unref0 (docs);
	if (conflict_file) {
		*conflict_file = _vala_conflict_file;
	} else {
		_g_object_unref0 (_vala_conflict_file);
	}
	return result;
}


gboolean
projects_change_main_file (Projects* self,
                           gint num,
                           GFile* new_main_file)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Project project = {0};
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	Project _tmp7_ = {0};
	Project _tmp8_;
	Project _tmp9_;
	GFile* _tmp10_;
	Project _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GeeLinkedList* _tmp14_;
	Project _tmp15_;
	GeeList* docs = NULL;
	GlatexApp* _tmp16_;
	GlatexApp* _tmp17_;
	GeeList* _tmp18_;
	GeeList* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_main_file != NULL, FALSE);
	if (num >= 0) {
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->projects;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = num < _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, FALSE);
	_tmp4_ = self->priv->projects;
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, num);
	_tmp6_ = (Project*) _tmp5_;
	project_copy (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_project_free0 (_tmp6_);
	project = _tmp8_;
	_tmp9_ = project;
	_tmp10_ = _tmp9_.main_file;
	if (g_file_equal (new_main_file, _tmp10_)) {
		result = FALSE;
		project_destroy (&project);
		return result;
	}
	_tmp11_ = project;
	_tmp12_ = _tmp11_.directory;
	g_return_val_if_fail (g_file_has_prefix (new_main_file, _tmp12_), FALSE);
	_tmp13_ = _g_object_ref0 (new_main_file);
	_g_object_unref0 (project.main_file);
	project.main_file = _tmp13_;
	_tmp14_ = self->priv->projects;
	_tmp15_ = project;
	gee_abstract_list_set ((GeeAbstractList*) _tmp14_, num, &_tmp15_);
	self->priv->modified = TRUE;
	_tmp16_ = glatex_app_get_instance ();
	_tmp17_ = _tmp16_;
	_tmp18_ = glatex_app_get_documents (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp17_);
	docs = _tmp19_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp20_;
		GeeList* _tmp21_;
		gint _doc_size = 0;
		GeeList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _doc_index = 0;
		_tmp20_ = docs;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_doc_list = _tmp21_;
		_tmp22_ = _doc_list;
		_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_doc_size = _tmp24_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			Document* doc = NULL;
			GeeList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			Document* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			_tmp25_ = _doc_index;
			_doc_index = _tmp25_ + 1;
			_tmp26_ = _doc_index;
			_tmp27_ = _doc_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _doc_list;
			_tmp29_ = _doc_index;
			_tmp30_ = gee_list_get (_tmp28_, _tmp29_);
			doc = (Document*) _tmp30_;
			_tmp31_ = doc;
			_tmp32_ = document_get_project_id (_tmp31_);
			_tmp33_ = _tmp32_;
			if (_tmp33_ == num) {
				Document* _tmp34_;
				_tmp34_ = doc;
				document_set_project_id (_tmp34_, num);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	result = TRUE;
	_g_object_unref0 (docs);
	project_destroy (&project);
	return result;
}


void
projects_delete (Projects* self,
                 gint num)
{
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	GeeList* docs = NULL;
	GlatexApp* _tmp7_;
	GlatexApp* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	g_return_if_fail (self != NULL);
	if (num >= 0) {
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->projects;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = num < _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_if_fail (_tmp0_);
	_tmp4_ = self->priv->projects;
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp4_, num);
	_tmp6_ = (Project*) _tmp5_;
	_project_free0 (_tmp6_);
	self->priv->modified = TRUE;
	_tmp7_ = glatex_app_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = glatex_app_get_documents (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	docs = _tmp10_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		gint _doc_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _doc_index = 0;
		_tmp11_ = docs;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_doc_list = _tmp12_;
		_tmp13_ = _doc_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_doc_size = _tmp15_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			Document* doc = NULL;
			GeeList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			Document* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			_tmp16_ = _doc_index;
			_doc_index = _tmp16_ + 1;
			_tmp17_ = _doc_index;
			_tmp18_ = _doc_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _doc_list;
			_tmp20_ = _doc_index;
			_tmp21_ = gee_list_get (_tmp19_, _tmp20_);
			doc = (Document*) _tmp21_;
			_tmp22_ = doc;
			_tmp23_ = document_get_project_id (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_ == num) {
				Document* _tmp25_;
				_tmp25_ = doc;
				document_set_project_id (_tmp25_, -1);
			} else {
				Document* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				_tmp26_ = doc;
				_tmp27_ = document_get_project_id (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ > num) {
					Document* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					_tmp29_ = doc;
					_tmp30_ = document_get_project_id (_tmp29_);
					_tmp31_ = _tmp30_;
					document_set_project_id (_tmp29_, _tmp31_ - 1);
				}
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	projects_update_all_menus (self);
	_g_object_unref0 (docs);
}


void
projects_clear_all (Projects* self)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->projects;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	self->priv->modified = TRUE;
	projects_update_all_documents (self);
	projects_update_all_menus (self);
}


static void
projects_update_all_documents (Projects* self)
{
	GeeList* docs = NULL;
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = glatex_app_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = glatex_app_get_documents (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	docs = _tmp3_;
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		gint _doc_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _doc_index = 0;
		_tmp4_ = docs;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_doc_list = _tmp5_;
		_tmp6_ = _doc_list;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_doc_size = _tmp8_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			Document* doc = NULL;
			GeeList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			Document* _tmp15_;
			Document* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			_tmp9_ = _doc_index;
			_doc_index = _tmp9_ + 1;
			_tmp10_ = _doc_index;
			_tmp11_ = _doc_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _doc_list;
			_tmp13_ = _doc_index;
			_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
			doc = (Document*) _tmp14_;
			_tmp15_ = doc;
			document_set_project_id (_tmp15_, -1);
			_tmp16_ = doc;
			_tmp17_ = document_get_location (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				_g_object_unref0 (doc);
				continue;
			}
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp19_ = FALSE;
					_tmp19_ = TRUE;
					while (TRUE) {
						gint _tmp21_;
						GeeLinkedList* _tmp22_;
						gint _tmp23_;
						gint _tmp24_;
						Document* _tmp25_;
						GFile* _tmp26_;
						GFile* _tmp27_;
						GeeLinkedList* _tmp28_;
						gint _tmp29_;
						gpointer _tmp30_;
						Project* _tmp31_;
						GFile* _tmp32_;
						gboolean _tmp33_;
						if (!_tmp19_) {
							gint _tmp20_;
							_tmp20_ = i;
							i = _tmp20_ + 1;
						}
						_tmp19_ = FALSE;
						_tmp21_ = i;
						_tmp22_ = self->priv->projects;
						_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
						_tmp24_ = _tmp23_;
						if (!(_tmp21_ < _tmp24_)) {
							break;
						}
						_tmp25_ = doc;
						_tmp26_ = document_get_location (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = self->priv->projects;
						_tmp29_ = i;
						_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
						_tmp31_ = (Project*) _tmp30_;
						_tmp32_ = (*_tmp31_).directory;
						_tmp33_ = g_file_has_prefix (_tmp27_, _tmp32_);
						_project_free0 (_tmp31_);
						if (_tmp33_) {
							Document* _tmp34_;
							gint _tmp35_;
							_tmp34_ = doc;
							_tmp35_ = i;
							document_set_project_id (_tmp34_, _tmp35_);
							break;
						}
					}
				}
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	_g_object_unref0 (docs);
}


static void
projects_parser_start (Projects* self,
                       GMarkupParseContext* context,
                       const gchar* name,
                       gchar** attr_names,
                       int attr_names_length1,
                       gchar** attr_values,
                       int attr_values_length1,
                       GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("projects")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("project")))) {
		switch (0) {
			default:
			{
				Project project = {0};
				GeeLinkedList* _tmp25_;
				Project _tmp26_;
				memset (&project, 0, sizeof (Project));
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gint _tmp6_;
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							GQuark _tmp10_ = 0U;
							static GQuark _tmp9_label0 = 0;
							static GQuark _tmp9_label1 = 0;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = i;
							if (!(_tmp5_ < attr_names_length1)) {
								break;
							}
							_tmp6_ = i;
							_tmp7_ = attr_names[_tmp6_];
							_tmp8_ = _tmp7_;
							_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
							if (_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("directory")))) {
								switch (0) {
									default:
									{
										gint _tmp11_;
										const gchar* _tmp12_;
										GFile* _tmp13_;
										_tmp11_ = i;
										_tmp12_ = attr_values[_tmp11_];
										_tmp13_ = g_file_new_for_uri (_tmp12_);
										_g_object_unref0 (project.directory);
										project.directory = _tmp13_;
										break;
									}
								}
							} else if (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("main_file")))) {
								switch (0) {
									default:
									{
										gint _tmp14_;
										const gchar* _tmp15_;
										GFile* _tmp16_;
										_tmp14_ = i;
										_tmp15_ = attr_values[_tmp14_];
										_tmp16_ = g_file_new_for_uri (_tmp15_);
										_g_object_unref0 (project.main_file);
										project.main_file = _tmp16_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gint _tmp17_;
										const gchar* _tmp18_;
										gchar* _tmp19_;
										gchar* _tmp20_;
										gchar* _tmp21_;
										gchar* _tmp22_;
										GError* _tmp23_;
										GError* _tmp24_;
										_tmp17_ = i;
										_tmp18_ = attr_names[_tmp17_];
										_tmp19_ = g_strconcat ("unknown attribute \"", _tmp18_, NULL);
										_tmp20_ = _tmp19_;
										_tmp21_ = g_strconcat (_tmp20_, "\"", NULL);
										_tmp22_ = _tmp21_;
										_tmp23_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp22_);
										_tmp24_ = _tmp23_;
										_g_free0 (_tmp22_);
										_g_free0 (_tmp20_);
										_inner_error_ = _tmp24_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											project_destroy (&project);
											return;
										} else {
											project_destroy (&project);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				_tmp25_ = self->priv->projects;
				_tmp26_ = project;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, &_tmp26_);
				project_destroy (&project);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GError* _tmp31_;
				GError* _tmp32_;
				_tmp27_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp28_, "\"", NULL);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp30_);
				_tmp32_ = _tmp31_;
				_g_free0 (_tmp30_);
				_g_free0 (_tmp28_);
				_inner_error_ = _tmp32_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile*
projects_get_xml_file (Projects* self)
{
	GFile* result = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "projects.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


void
projects_save (Projects* self)
{
	gboolean _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* content = NULL;
	gchar* _tmp6_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	GFile* _tmp35_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->modified;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = projects_get_xml_file (self);
	file = _tmp1_;
	_tmp2_ = self->priv->projects;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		GFile* _tmp5_;
		_tmp5_ = file;
		utils_delete_file (_tmp5_);
		_g_object_unref0 (file);
		return;
	}
	_tmp6_ = g_strdup ("<projects>\n");
	content = _tmp6_;
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp7_;
		GeeLinkedList* _tmp8_;
		gint _project_size = 0;
		GeeLinkedList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _project_index = 0;
		_tmp7_ = self->priv->projects;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_project_list = _tmp8_;
		_tmp9_ = _project_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_project_size = _tmp11_;
		_project_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			Project project = {0};
			GeeLinkedList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			Project* _tmp18_;
			Project _tmp19_ = {0};
			Project _tmp20_;
			const gchar* _tmp21_;
			Project _tmp22_;
			GFile* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			Project _tmp26_;
			GFile* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp12_ = _project_index;
			_project_index = _tmp12_ + 1;
			_tmp13_ = _project_index;
			_tmp14_ = _project_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _project_list;
			_tmp16_ = _project_index;
			_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
			_tmp18_ = (Project*) _tmp17_;
			project_copy (_tmp18_, &_tmp19_);
			_tmp20_ = _tmp19_;
			_project_free0 (_tmp18_);
			project = _tmp20_;
			_tmp21_ = content;
			_tmp22_ = project;
			_tmp23_ = _tmp22_.directory;
			_tmp24_ = g_file_get_uri (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = project;
			_tmp27_ = _tmp26_.main_file;
			_tmp28_ = g_file_get_uri (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strdup_printf ("  <project directory=\"%s\" main_file=\"%s\" />\n", _tmp25_, _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = g_strconcat (_tmp21_, _tmp31_, NULL);
			_g_free0 (content);
			content = _tmp32_;
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp25_);
			project_destroy (&project);
		}
		_g_object_unref0 (_project_list);
	}
	_tmp33_ = content;
	_tmp34_ = g_strconcat (_tmp33_, "</projects>\n", NULL);
	_g_free0 (content);
	content = _tmp34_;
	_tmp35_ = file;
	_tmp36_ = content;
	utils_save_file (_tmp35_, _tmp36_, FALSE);
	_g_free0 (content);
	_g_object_unref0 (file);
}


static gboolean
projects_conflict (Projects* self,
                   GFile* dir1,
                   GFile* dir2)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir1 != NULL, FALSE);
	g_return_val_if_fail (dir2 != NULL, FALSE);
	if (g_file_has_prefix (dir1, dir2)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_file_has_prefix (dir2, dir1);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_file_equal (dir1, dir2);
	}
	result = _tmp0_;
	return result;
}


static void
value_projects_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
value_projects_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		projects_unref (value->data[0].v_pointer);
	}
}


static void
value_projects_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = projects_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
value_projects_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
value_projects_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Projects * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = projects_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
value_projects_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	Projects ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = projects_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
param_spec_projects (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecProjects* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROJECTS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
value_get_projects (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS), NULL);
	return value->data[0].v_pointer;
}


void
value_set_projects (GValue* value,
                    gpointer v_object)
{
	Projects * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		projects_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}


void
value_take_projects (GValue* value,
                     gpointer v_object)
{
	Projects * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		projects_unref (old);
	}
}


static void
projects_class_init (ProjectsClass * klass)
{
	projects_parent_class = g_type_class_peek_parent (klass);
	((ProjectsClass *) klass)->finalize = projects_finalize;
	g_type_class_add_private (klass, sizeof (ProjectsPrivate));
}


static void
projects_instance_init (Projects * self)
{
	self->priv = PROJECTS_GET_PRIVATE (self);
	self->priv->modified = FALSE;
	self->ref_count = 1;
}


static void
projects_finalize (Projects * obj)
{
	Projects * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECTS, Projects);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->projects);
}


GType
projects_get_type (void)
{
	static volatile gsize projects_type_id__volatile = 0;
	if (g_once_init_enter (&projects_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_projects_init, value_projects_free_value, value_projects_copy_value, value_projects_peek_pointer, "p", value_projects_collect_value, "p", value_projects_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Projects), 0, (GInstanceInitFunc) projects_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType projects_type_id;
		projects_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Projects", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&projects_type_id__volatile, projects_type_id);
	}
	return projects_type_id__volatile;
}


gpointer
projects_ref (gpointer instance)
{
	Projects * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
projects_unref (gpointer instance)
{
	Projects * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROJECTS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



