/* glatex_app.c generated by valac 0.48.6, the Vala compiler
 * generated from glatex_app.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <latexila.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gee.h>

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;
typedef struct _GlatexAppPrivate GlatexAppPrivate;
enum  {
	GLATEX_APP_0_PROPERTY,
	GLATEX_APP_NUM_PROPERTIES
};
static GParamSpec* glatex_app_properties[GLATEX_APP_NUM_PROPERTIES];

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GlatexApp {
	LatexilaApp parent_instance;
	GlatexAppPrivate * priv;
};

struct _GlatexAppClass {
	LatexilaAppClass parent_class;
};

static gpointer glatex_app_parent_class = NULL;

GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
static void glatex_app_new_document_cb (GlatexApp* self);
static void _glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void glatex_app_preferences_cb (GlatexApp* self);
static void _glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void glatex_app_manage_build_tools_cb (GlatexApp* self);
static void _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void glatex_app_quit_cb (GlatexApp* self);
static void _glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
GlatexApp* glatex_app_new (void);
GlatexApp* glatex_app_construct (GType object_type);
static void glatex_app_startup_cb (GlatexApp* self);
static void _glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                                   gpointer self);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                gint files_length1);
static void _glatex_app_open_documents_g_application_open (GApplication* _sender,
                                                    GFile** files,
                                                    gint n_files,
                                                    const gchar* hint,
                                                    gpointer self);
static void glatex_app_shutdown_cb (GlatexApp* self);
static void _glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                     gpointer self);
GlatexApp* glatex_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
AppSettings* app_settings_get_default (void);
static void glatex_app_support_backward_search (GlatexApp* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
Projects* projects_get_default (void);
void projects_save (Projects* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
MainWindow* glatex_app_create_window (GlatexApp* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
void preferences_dialog_show_me (GtkWindow* parent);
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type,
                                                          GtkWindow* parent_window);
GType build_tools_preferences_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolsPreferences, g_object_unref)
gboolean main_window_quit (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GeeList* glatex_app_get_documents (GlatexApp* self);
GeeList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
GeeList* glatex_app_get_views (GlatexApp* self);
GeeList* main_window_get_views (MainWindow* self);
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void __lambda113_ (GlatexApp* self,
                   const gchar* tex_uri,
                   gint line,
                   guint timestamp);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
static void ___lambda113__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                     const gchar* tex_uri,
                                                     gint line,
                                                     guint timestamp,
                                                     gpointer self);
static GType glatex_app_get_type_once (void);

static const GActionEntry GLATEX_APP__app_actions[4] = {{"new-document", _glatex_app_new_document_cb_gsimple_action_activate_callback}, {"preferences", _glatex_app_preferences_cb_gsimple_action_activate_callback}, {"manage-build-tools", _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback}, {"quit", _glatex_app_quit_cb_gsimple_action_activate_callback}};

static void
_glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
#line 24 "glatex_app.vala"
	glatex_app_new_document_cb ((GlatexApp*) self);
#line 255 "glatex_app.c"
}

static void
_glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
#line 24 "glatex_app.vala"
	glatex_app_preferences_cb ((GlatexApp*) self);
#line 265 "glatex_app.c"
}

static void
_glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
#line 24 "glatex_app.vala"
	glatex_app_manage_build_tools_cb ((GlatexApp*) self);
#line 275 "glatex_app.c"
}

static void
_glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 24 "glatex_app.vala"
	glatex_app_quit_cb ((GlatexApp*) self);
#line 285 "glatex_app.c"
}

static void
_glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                              gpointer self)
{
#line 34 "glatex_app.vala"
	glatex_app_startup_cb ((GlatexApp*) self);
#line 294 "glatex_app.c"
}

static void
_glatex_app_open_documents_g_application_open (GApplication* _sender,
                                               GFile** files,
                                               gint n_files,
                                               const gchar* hint,
                                               gpointer self)
{
#line 35 "glatex_app.vala"
	glatex_app_open_documents ((GlatexApp*) self, files, n_files);
#line 306 "glatex_app.c"
}

static void
_glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                gpointer self)
{
#line 36 "glatex_app.vala"
	glatex_app_shutdown_cb ((GlatexApp*) self);
#line 315 "glatex_app.c"
}

GlatexApp*
glatex_app_construct (GType object_type)
{
	GlatexApp * self = NULL;
#line 32 "glatex_app.vala"
	self = (GlatexApp*) g_object_new (object_type, NULL);
#line 34 "glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _glatex_app_startup_cb_g_application_startup, self, 0);
#line 35 "glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "open", (GCallback) _glatex_app_open_documents_g_application_open, self, 0);
#line 36 "glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) _glatex_app_shutdown_cb_g_application_shutdown, self, 0);
#line 32 "glatex_app.vala"
	return self;
#line 332 "glatex_app.c"
}

GlatexApp*
glatex_app_new (void)
{
#line 32 "glatex_app.vala"
	return glatex_app_construct (TYPE_GLATEX_APP);
#line 340 "glatex_app.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 41 "glatex_app.vala"
	return self ? g_object_ref (self) : NULL;
#line 348 "glatex_app.c"
}

GlatexApp*
glatex_app_get_instance (void)
{
	GApplication* _tmp0_;
	GlatexApp* _tmp1_;
	GlatexApp* result = NULL;
#line 41 "glatex_app.vala"
	_tmp0_ = g_application_get_default ();
#line 41 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (IS_GLATEX_APP (_tmp0_) ? ((GlatexApp*) _tmp0_) : NULL);
#line 41 "glatex_app.vala"
	result = _tmp1_;
#line 41 "glatex_app.vala"
	return result;
#line 365 "glatex_app.c"
}

MainWindow*
glatex_app_get_active_main_window (GlatexApp* self)
{
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
	GtkApplicationWindow* main_window = NULL;
	TeplApplication* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	GtkApplicationWindow* _tmp6_;
	MainWindow* _tmp7_;
	MainWindow* result = NULL;
#line 44 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "glatex_app.vala"
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
#line 46 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 46 "glatex_app.vala"
	tepl_app = _tmp1_;
#line 47 "glatex_app.vala"
	_tmp2_ = tepl_app;
#line 47 "glatex_app.vala"
	_tmp3_ = tepl_application_get_active_main_window (_tmp2_);
#line 47 "glatex_app.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 47 "glatex_app.vala"
	main_window = _tmp4_;
#line 49 "glatex_app.vala"
	_tmp5_ = main_window;
#line 49 "glatex_app.vala"
	if (_tmp5_ == NULL) {
#line 50 "glatex_app.vala"
		result = NULL;
#line 50 "glatex_app.vala"
		_g_object_unref0 (main_window);
#line 50 "glatex_app.vala"
		_g_object_unref0 (tepl_app);
#line 50 "glatex_app.vala"
		return result;
#line 410 "glatex_app.c"
	}
#line 52 "glatex_app.vala"
	_tmp6_ = main_window;
#line 52 "glatex_app.vala"
	_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
#line 52 "glatex_app.vala"
	result = _tmp7_;
#line 52 "glatex_app.vala"
	_g_object_unref0 (main_window);
#line 52 "glatex_app.vala"
	_g_object_unref0 (tepl_app);
#line 52 "glatex_app.vala"
	return result;
#line 424 "glatex_app.c"
}

static void
glatex_app_startup_cb (GlatexApp* self)
{
	AppSettings* _tmp0_;
	AppSettings* _tmp1_;
#line 55 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 57 "glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 58 "glatex_app.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GLATEX_APP__app_actions, (gint) G_N_ELEMENTS (GLATEX_APP__app_actions), self);
#line 59 "glatex_app.vala"
	_tmp0_ = app_settings_get_default ();
#line 59 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 59 "glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 60 "glatex_app.vala"
	glatex_app_support_backward_search (self);
#line 61 "glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 448 "glatex_app.c"
}

static void
glatex_app_shutdown_cb (GlatexApp* self)
{
	Projects* _tmp0_;
	Projects* _tmp1_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
#line 64 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 66 "glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 67 "glatex_app.vala"
	_tmp0_ = projects_get_default ();
#line 67 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 67 "glatex_app.vala"
	projects_save (_tmp1_);
#line 67 "glatex_app.vala"
	_projects_unref0 (_tmp1_);
#line 68 "glatex_app.vala"
	_tmp2_ = most_used_symbols_get_default ();
#line 68 "glatex_app.vala"
	_tmp3_ = _tmp2_;
#line 68 "glatex_app.vala"
	most_used_symbols_save (_tmp3_);
#line 68 "glatex_app.vala"
	_g_object_unref0 (_tmp3_);
#line 69 "glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 480 "glatex_app.c"
}

static void
glatex_app_new_document_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
#line 72 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 74 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 74 "glatex_app.vala"
	window = _tmp0_;
#line 75 "glatex_app.vala"
	_tmp1_ = window;
#line 75 "glatex_app.vala"
	if (_tmp1_ == NULL) {
#line 502 "glatex_app.c"
		MainWindow* _tmp2_;
#line 76 "glatex_app.vala"
		_tmp2_ = glatex_app_create_window (self);
#line 76 "glatex_app.vala"
		_g_object_unref0 (window);
#line 76 "glatex_app.vala"
		window = _tmp2_;
#line 510 "glatex_app.c"
	}
#line 78 "glatex_app.vala"
	_tmp3_ = window;
#line 78 "glatex_app.vala"
	_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
#line 78 "glatex_app.vala"
	_tmp5_ = _tmp4_;
#line 78 "glatex_app.vala"
	_g_object_unref0 (_tmp5_);
#line 72 "glatex_app.vala"
	_g_object_unref0 (window);
#line 522 "glatex_app.c"
}

static void
glatex_app_preferences_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
#line 81 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 83 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 83 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 83 "glatex_app.vala"
	preferences_dialog_show_me ((GtkWindow*) _tmp1_);
#line 83 "glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 540 "glatex_app.c"
}

static void
glatex_app_manage_build_tools_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	BuildToolsPreferences* _tmp2_;
	BuildToolsPreferences* _tmp3_;
#line 86 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 88 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 88 "glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 88 "glatex_app.vala"
	_tmp2_ = build_tools_preferences_new ((GtkWindow*) _tmp1_);
#line 88 "glatex_app.vala"
	_tmp3_ = _tmp2_;
#line 88 "glatex_app.vala"
	_g_object_unref0 (_tmp3_);
#line 88 "glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 564 "glatex_app.c"
}

static void
glatex_app_quit_cb (GlatexApp* self)
{
	gboolean cont = FALSE;
#line 91 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 93 "glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 95 "glatex_app.vala"
	cont = TRUE;
#line 96 "glatex_app.vala"
	while (TRUE) {
#line 579 "glatex_app.c"
		MainWindow* main_window = NULL;
		MainWindow* _tmp0_;
		MainWindow* _tmp1_;
		MainWindow* _tmp2_;
		MainWindow* _tmp3_;
#line 96 "glatex_app.vala"
		if (!cont) {
#line 96 "glatex_app.vala"
			break;
#line 589 "glatex_app.c"
		}
#line 98 "glatex_app.vala"
		_tmp0_ = glatex_app_get_active_main_window (self);
#line 98 "glatex_app.vala"
		main_window = _tmp0_;
#line 99 "glatex_app.vala"
		_tmp1_ = main_window;
#line 99 "glatex_app.vala"
		if (_tmp1_ == NULL) {
#line 100 "glatex_app.vala"
			_g_object_unref0 (main_window);
#line 100 "glatex_app.vala"
			break;
#line 603 "glatex_app.c"
		}
#line 102 "glatex_app.vala"
		_tmp2_ = main_window;
#line 102 "glatex_app.vala"
		gtk_window_present ((GtkWindow*) _tmp2_);
#line 103 "glatex_app.vala"
		_tmp3_ = main_window;
#line 103 "glatex_app.vala"
		cont = main_window_quit (_tmp3_);
#line 96 "glatex_app.vala"
		_g_object_unref0 (main_window);
#line 615 "glatex_app.c"
	}
#line 106 "glatex_app.vala"
	if (cont) {
#line 108 "glatex_app.vala"
		while (TRUE) {
#line 621 "glatex_app.c"
			GtkWindow* _tmp4_;
			GtkWindow* _tmp5_;
			GtkWindow* _tmp6_;
			GtkWindow* _tmp7_;
#line 108 "glatex_app.vala"
			_tmp4_ = gtk_application_get_active_window ((GtkApplication*) self);
#line 108 "glatex_app.vala"
			_tmp5_ = _tmp4_;
#line 108 "glatex_app.vala"
			if (!(_tmp5_ != NULL)) {
#line 108 "glatex_app.vala"
				break;
#line 634 "glatex_app.c"
			}
#line 109 "glatex_app.vala"
			_tmp6_ = gtk_application_get_active_window ((GtkApplication*) self);
#line 109 "glatex_app.vala"
			_tmp7_ = _tmp6_;
#line 109 "glatex_app.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp7_);
#line 642 "glatex_app.c"
		}
	}
#line 112 "glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 647 "glatex_app.c"
}

GeeList*
glatex_app_get_documents (GlatexApp* self)
{
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	GeeList* result = NULL;
#line 116 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "glatex_app.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 118 "glatex_app.vala"
	all_documents = (GeeList*) _tmp0_;
#line 119 "glatex_app.vala"
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
#line 665 "glatex_app.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 119 "glatex_app.vala"
		window_collection = _tmp1_;
#line 119 "glatex_app.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 673 "glatex_app.c"
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
#line 119 "glatex_app.vala"
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 119 "glatex_app.vala"
			window = _tmp2_;
#line 680 "glatex_app.c"
			{
				GtkWindow* _tmp3_;
#line 121 "glatex_app.vala"
				_tmp3_ = window;
#line 121 "glatex_app.vala"
				if (IS_MAIN_WINDOW (_tmp3_)) {
#line 687 "glatex_app.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
#line 123 "glatex_app.vala"
					_tmp4_ = window;
#line 123 "glatex_app.vala"
					_tmp5_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp4_) ? ((MainWindow*) _tmp4_) : NULL);
#line 123 "glatex_app.vala"
					main_window = _tmp5_;
#line 124 "glatex_app.vala"
					_tmp6_ = all_documents;
#line 124 "glatex_app.vala"
					_tmp7_ = main_window;
#line 124 "glatex_app.vala"
					_tmp8_ = main_window_get_documents (_tmp7_);
#line 124 "glatex_app.vala"
					_tmp9_ = _tmp8_;
#line 124 "glatex_app.vala"
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
#line 124 "glatex_app.vala"
					_g_object_unref0 (_tmp9_);
#line 121 "glatex_app.vala"
					_g_object_unref0 (main_window);
#line 715 "glatex_app.c"
				}
#line 119 "glatex_app.vala"
				_g_object_unref0 (window);
#line 719 "glatex_app.c"
			}
		}
	}
#line 128 "glatex_app.vala"
	result = all_documents;
#line 128 "glatex_app.vala"
	return result;
#line 727 "glatex_app.c"
}

GeeList*
glatex_app_get_views (GlatexApp* self)
{
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
	GeeList* result = NULL;
#line 132 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 134 "glatex_app.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 134 "glatex_app.vala"
	all_views = (GeeList*) _tmp0_;
#line 135 "glatex_app.vala"
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
#line 745 "glatex_app.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 135 "glatex_app.vala"
		window_collection = _tmp1_;
#line 135 "glatex_app.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 753 "glatex_app.c"
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
#line 135 "glatex_app.vala"
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 135 "glatex_app.vala"
			window = _tmp2_;
#line 760 "glatex_app.c"
			{
				GtkWindow* _tmp3_;
#line 137 "glatex_app.vala"
				_tmp3_ = window;
#line 137 "glatex_app.vala"
				if (IS_MAIN_WINDOW (_tmp3_)) {
#line 767 "glatex_app.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
#line 139 "glatex_app.vala"
					_tmp4_ = window;
#line 139 "glatex_app.vala"
					_tmp5_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp4_) ? ((MainWindow*) _tmp4_) : NULL);
#line 139 "glatex_app.vala"
					main_window = _tmp5_;
#line 140 "glatex_app.vala"
					_tmp6_ = all_views;
#line 140 "glatex_app.vala"
					_tmp7_ = main_window;
#line 140 "glatex_app.vala"
					_tmp8_ = main_window_get_views (_tmp7_);
#line 140 "glatex_app.vala"
					_tmp9_ = _tmp8_;
#line 140 "glatex_app.vala"
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
#line 140 "glatex_app.vala"
					_g_object_unref0 (_tmp9_);
#line 137 "glatex_app.vala"
					_g_object_unref0 (main_window);
#line 795 "glatex_app.c"
				}
#line 135 "glatex_app.vala"
				_g_object_unref0 (window);
#line 799 "glatex_app.c"
			}
		}
	}
#line 144 "glatex_app.vala"
	result = all_views;
#line 144 "glatex_app.vala"
	return result;
#line 807 "glatex_app.c"
}

MainWindow*
glatex_app_create_window (GlatexApp* self)
{
	TeplAbstractFactory* factory = NULL;
	TeplAbstractFactory* _tmp0_;
	TeplAbstractFactory* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	MainWindow* _tmp3_;
	MainWindow* result = NULL;
#line 147 "glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 149 "glatex_app.vala"
	_tmp0_ = tepl_abstract_factory_get_singleton ();
#line 149 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 149 "glatex_app.vala"
	factory = _tmp1_;
#line 151 "glatex_app.vala"
	_tmp2_ = tepl_abstract_factory_create_main_window (factory, (GtkApplication*) self);
#line 151 "glatex_app.vala"
	_tmp3_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp2_) ? ((MainWindow*) _tmp2_) : NULL);
#line 151 "glatex_app.vala"
	result = _tmp3_;
#line 151 "glatex_app.vala"
	_g_object_unref0 (factory);
#line 151 "glatex_app.vala"
	return result;
#line 837 "glatex_app.c"
}

void
glatex_app_open_documents (GlatexApp* self,
                           GFile** files,
                           gint files_length1)
{
	MainWindow* main_window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	gboolean jump_to = FALSE;
	MainWindow* _tmp8_;
#line 154 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 156 "glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 156 "glatex_app.vala"
	main_window = _tmp0_;
#line 157 "glatex_app.vala"
	_tmp1_ = main_window;
#line 157 "glatex_app.vala"
	if (_tmp1_ == NULL) {
#line 860 "glatex_app.c"
		MainWindow* _tmp2_;
#line 158 "glatex_app.vala"
		_tmp2_ = glatex_app_create_window (self);
#line 158 "glatex_app.vala"
		_g_object_unref0 (main_window);
#line 158 "glatex_app.vala"
		main_window = _tmp2_;
#line 868 "glatex_app.c"
	}
#line 160 "glatex_app.vala"
	jump_to = TRUE;
#line 872 "glatex_app.c"
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
#line 161 "glatex_app.vala"
		file_collection = files;
#line 161 "glatex_app.vala"
		file_collection_length1 = files_length1;
#line 161 "glatex_app.vala"
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
#line 884 "glatex_app.c"
			GFile* _tmp3_;
			GFile* file = NULL;
#line 161 "glatex_app.vala"
			_tmp3_ = _g_object_ref0 (file_collection[file_it]);
#line 161 "glatex_app.vala"
			file = _tmp3_;
#line 891 "glatex_app.c"
			{
				MainWindow* _tmp4_;
				GFile* _tmp5_;
				DocumentTab* _tmp6_;
				DocumentTab* _tmp7_;
#line 163 "glatex_app.vala"
				_tmp4_ = main_window;
#line 163 "glatex_app.vala"
				_tmp5_ = file;
#line 163 "glatex_app.vala"
				_tmp6_ = main_window_open_document (_tmp4_, _tmp5_, jump_to);
#line 163 "glatex_app.vala"
				_tmp7_ = _tmp6_;
#line 163 "glatex_app.vala"
				_g_object_unref0 (_tmp7_);
#line 164 "glatex_app.vala"
				jump_to = FALSE;
#line 161 "glatex_app.vala"
				_g_object_unref0 (file);
#line 911 "glatex_app.c"
			}
		}
	}
#line 167 "glatex_app.vala"
	_tmp8_ = main_window;
#line 167 "glatex_app.vala"
	gtk_window_present ((GtkWindow*) _tmp8_);
#line 154 "glatex_app.vala"
	_g_object_unref0 (main_window);
#line 921 "glatex_app.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 934 "glatex_app.c"
}

static void
__lambda113_ (GlatexApp* self,
              const gchar* tex_uri,
              gint line,
              guint timestamp)
{
	GFile* tex_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	MainWindow* main_window = NULL;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
#line 174 "glatex_app.vala"
	g_return_if_fail (tex_uri != NULL);
#line 176 "glatex_app.vala"
	_tmp0_ = g_file_new_for_uri (tex_uri);
#line 176 "glatex_app.vala"
	tex_file = _tmp0_;
#line 177 "glatex_app.vala"
	_tmp1_ = tex_file;
#line 177 "glatex_app.vala"
	if (!g_file_query_exists (_tmp1_, NULL)) {
#line 959 "glatex_app.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 179 "glatex_app.vala"
		_tmp2_ = string_to_string (tex_uri);
#line 179 "glatex_app.vala"
		_tmp3_ = g_strconcat ("Backward search: the file \"", _tmp2_, "\" doesn't exist.", NULL);
#line 179 "glatex_app.vala"
		_tmp4_ = _tmp3_;
#line 179 "glatex_app.vala"
		g_warning ("glatex_app.vala:179: %s", _tmp4_);
#line 179 "glatex_app.vala"
		_g_free0 (_tmp4_);
#line 180 "glatex_app.vala"
		_g_object_unref0 (tex_file);
#line 180 "glatex_app.vala"
		return;
#line 977 "glatex_app.c"
	}
#line 185 "glatex_app.vala"
	_tmp5_ = glatex_app_get_active_main_window (self);
#line 185 "glatex_app.vala"
	main_window = _tmp5_;
#line 186 "glatex_app.vala"
	_tmp6_ = main_window;
#line 186 "glatex_app.vala"
	if (_tmp6_ != NULL) {
#line 987 "glatex_app.c"
		MainWindow* _tmp7_;
		GFile* _tmp8_;
		MainWindow* _tmp9_;
#line 188 "glatex_app.vala"
		_tmp7_ = main_window;
#line 188 "glatex_app.vala"
		_tmp8_ = tex_file;
#line 188 "glatex_app.vala"
		main_window_jump_to_file_position (_tmp7_, _tmp8_, line, line);
#line 189 "glatex_app.vala"
		_tmp9_ = main_window;
#line 189 "glatex_app.vala"
		gtk_window_present_with_time ((GtkWindow*) _tmp9_, (guint32) timestamp);
#line 1001 "glatex_app.c"
	}
#line 174 "glatex_app.vala"
	_g_object_unref0 (main_window);
#line 174 "glatex_app.vala"
	_g_object_unref0 (tex_file);
#line 1007 "glatex_app.c"
}

static void
___lambda113__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                const gchar* tex_uri,
                                                gint line,
                                                guint timestamp,
                                                gpointer self)
{
#line 174 "glatex_app.vala"
	__lambda113_ ((GlatexApp*) self, tex_uri, line, timestamp);
#line 1019 "glatex_app.c"
}

static void
glatex_app_support_backward_search (GlatexApp* self)
{
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp0_;
	LatexilaSynctex* _tmp1_;
#line 170 "glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 172 "glatex_app.vala"
	_tmp0_ = latexila_synctex_get_instance ();
#line 172 "glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 172 "glatex_app.vala"
	synctex = _tmp1_;
#line 174 "glatex_app.vala"
	g_signal_connect_object (synctex, "backward-search", (GCallback) ___lambda113__latexila_synctex_backward_search, self, 0);
#line 170 "glatex_app.vala"
	_g_object_unref0 (synctex);
#line 1040 "glatex_app.c"
}

static void
glatex_app_class_init (GlatexAppClass * klass,
                       gpointer klass_data)
{
#line 22 "glatex_app.vala"
	glatex_app_parent_class = g_type_class_peek_parent (klass);
#line 1049 "glatex_app.c"
}

static void
glatex_app_instance_init (GlatexApp * self,
                          gpointer klass)
{
}

static GType
glatex_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GlatexAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) glatex_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlatexApp), 0, (GInstanceInitFunc) glatex_app_instance_init, NULL };
	GType glatex_app_type_id;
	glatex_app_type_id = g_type_register_static (latexila_app_get_type (), "GlatexApp", &g_define_type_info, 0);
	return glatex_app_type_id;
}

GType
glatex_app_get_type (void)
{
	static volatile gsize glatex_app_type_id__volatile = 0;
	if (g_once_init_enter (&glatex_app_type_id__volatile)) {
		GType glatex_app_type_id;
		glatex_app_type_id = glatex_app_get_type_once ();
		g_once_init_leave (&glatex_app_type_id__volatile, glatex_app_type_id);
	}
	return glatex_app_type_id__volatile;
}

