/* main_window_documents.c generated by valac 0.48.6, the Vala compiler
 * generated from main_window_documents.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012, 2015, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <latexila.h>
#include <gobject/gvaluecollector.h>

#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;
typedef struct _MainWindowDocumentsPrivate MainWindowDocumentsPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _ParamSpecMainWindowDocuments ParamSpecMainWindowDocuments;

struct _MainWindowDocuments {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainWindowDocumentsPrivate * priv;
};

struct _MainWindowDocumentsClass {
	GTypeClass parent_class;
	void (*finalize) (MainWindowDocuments *self);
};

struct _MainWindowDocumentsPrivate {
	MainWindow* _main_window;
	GtkUIManager* _ui_manager;
	DocumentsPanel* _documents_panel;
	GtkActionGroup* _static_action_group;
	GtkActionGroup* _list_action_group;
	guint _list_id;
};

struct _ParamSpecMainWindowDocuments {
	GParamSpec parent_instance;
};

static gint MainWindowDocuments_private_offset;
static gpointer main_window_documents_parent_class = NULL;

gpointer main_window_documents_ref (gpointer instance);
void main_window_documents_unref (gpointer instance);
GParamSpec* param_spec_main_window_documents (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_documents (GValue* value,
                                      gpointer v_object);
void value_take_main_window_documents (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_documents (const GValue* value);
GType main_window_documents_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowDocuments, main_window_documents_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType documents_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentsPanel, g_object_unref)
void main_window_documents_on_save_all (MainWindowDocuments* self);
static void _main_window_documents_on_save_all_gtk_action_callback (GtkAction* action,
                                                             gpointer self);
void main_window_documents_on_close_all (MainWindowDocuments* self);
static void _main_window_documents_on_close_all_gtk_action_callback (GtkAction* action,
                                                              gpointer self);
void main_window_documents_on_previous (MainWindowDocuments* self);
static void _main_window_documents_on_previous_gtk_action_callback (GtkAction* action,
                                                             gpointer self);
void main_window_documents_on_next (MainWindowDocuments* self);
static void _main_window_documents_on_next_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_documents_on_move_to_new_window (MainWindowDocuments* self);
static void _main_window_documents_on_move_to_new_window_gtk_action_callback (GtkAction* action,
                                                                       gpointer self);
MainWindowDocuments* main_window_documents_new (MainWindow* main_window,
                                                GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_construct (GType object_type,
                                                      MainWindow* main_window,
                                                      GtkUIManager* ui_manager);
void main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                                DocumentsPanel* documents_panel);
static void main_window_documents_connect_signals (MainWindowDocuments* self);
static void main_window_documents_update_sensitivity (MainWindowDocuments* self);
static void __lambda22_ (MainWindowDocuments* self);
static void main_window_documents_update_documents_list (MainWindowDocuments* self);
static void ___lambda22__gtk_notebook_page_reordered (GtkNotebook* _sender,
                                               GtkWidget* child,
                                               guint page_num,
                                               gpointer self);
static void __lambda23_ (MainWindowDocuments* self,
                  GtkWidget* pg,
                  guint page_num);
static void main_window_documents_set_active_document (MainWindowDocuments* self,
                                                guint doc_num);
static void ___lambda23__gtk_notebook_switch_page (GtkNotebook* _sender,
                                            GtkWidget* page,
                                            guint page_num,
                                            gpointer self);
static void __lambda24_ (MainWindowDocuments* self);
static void ___lambda24__gtk_notebook_page_removed (GtkNotebook* _sender,
                                             GtkWidget* child,
                                             guint page_num,
                                             gpointer self);
static void __lambda25_ (MainWindowDocuments* self);
static void ___lambda25__gtk_notebook_page_added (GtkNotebook* _sender,
                                           GtkWidget* child,
                                           guint page_num,
                                           gpointer self);
static void main_window_documents_list_action_activate (MainWindowDocuments* self,
                                                 GtkAction* action);
static void _main_window_documents_list_action_activate_gtk_action_activate (GtkAction* _sender,
                                                                      gpointer self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
static gchar* main_window_documents_get_list_action_name (MainWindowDocuments* self,
                                                   guint doc_num);
gchar* document_tab_get_menu_tip (DocumentTab* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
void main_window_documents_update_document_name (MainWindowDocuments* self,
                                                 DocumentTab* tab);
static void main_window_documents_update_next_prev_doc_sensitivity (MainWindowDocuments* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GeeList* main_window_get_unsaved_documents (MainWindow* self);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
gboolean main_window_close_all_documents (MainWindow* self);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
MainWindow* glatex_app_create_window (GlatexApp* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* document_tab_get_document_view (DocumentTab* self);
void documents_panel_remove_tab (DocumentsPanel* self,
                                 DocumentTab* tab);
void main_window_create_tab_with_view (MainWindow* self,
                                       DocumentView* view);
static void main_window_documents_finalize (MainWindowDocuments * obj);
static GType main_window_documents_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GtkActionEntry MAIN_WINDOW_DOCUMENTS__action_entries[6] = {{"Documents", NULL, N_ ("_Documents")}, {"DocumentsSaveAll", "document-save", N_ ("_Save All"), "<Shift><Control>L", N_ ("Save all open files"), (GCallback) _main_window_documents_on_save_all_gtk_action_callback}, {"DocumentsCloseAll", "window-close", N_ ("_Close All"), "<Shift><Control>W", N_ ("Close all open files"), (GCallback) _main_window_documents_on_close_all_gtk_action_callback}, {"DocumentsPrevious", "go-previous", N_ ("_Previous Document"), "<Control>Page_Up", N_ ("Activate previous document"), (GCallback) _main_window_documents_on_previous_gtk_action_callback}, {"DocumentsNext", "go-next", N_ ("_Next Document"), "<Control>Page_Down", N_ ("Activate next document"), (GCallback) _main_window_documents_on_next_gtk_action_callback}, {"DocumentsMoveToNewWindow", NULL, N_ ("_Move to New Window"), NULL, N_ ("Move the current document to a new window"), (GCallback) _main_window_documents_on_move_to_new_window_gtk_action_callback}};

static inline gpointer
main_window_documents_get_instance_private (MainWindowDocuments* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindowDocuments_private_offset);
}

static void
_main_window_documents_on_save_all_gtk_action_callback (GtkAction* action,
                                                        gpointer self)
{
#line 28 "main_window_documents.vala"
	main_window_documents_on_save_all ((MainWindowDocuments*) self);
#line 261 "main_window_documents.c"
}

static void
_main_window_documents_on_close_all_gtk_action_callback (GtkAction* action,
                                                         gpointer self)
{
#line 28 "main_window_documents.vala"
	main_window_documents_on_close_all ((MainWindowDocuments*) self);
#line 270 "main_window_documents.c"
}

static void
_main_window_documents_on_previous_gtk_action_callback (GtkAction* action,
                                                        gpointer self)
{
#line 28 "main_window_documents.vala"
	main_window_documents_on_previous ((MainWindowDocuments*) self);
#line 279 "main_window_documents.c"
}

static void
_main_window_documents_on_next_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 28 "main_window_documents.vala"
	main_window_documents_on_next ((MainWindowDocuments*) self);
#line 288 "main_window_documents.c"
}

static void
_main_window_documents_on_move_to_new_window_gtk_action_callback (GtkAction* action,
                                                                  gpointer self)
{
#line 28 "main_window_documents.vala"
	main_window_documents_on_move_to_new_window ((MainWindowDocuments*) self);
#line 297 "main_window_documents.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 61 "main_window_documents.vala"
	return self ? g_object_ref (self) : NULL;
#line 305 "main_window_documents.c"
}

MainWindowDocuments*
main_window_documents_construct (GType object_type,
                                 MainWindow* main_window,
                                 GtkUIManager* ui_manager)
{
	MainWindowDocuments* self = NULL;
	GtkUIManager* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkActionGroup* _tmp6_;
#line 58 "main_window_documents.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 58 "main_window_documents.vala"
	g_return_val_if_fail (ui_manager != NULL, NULL);
#line 58 "main_window_documents.vala"
	self = (MainWindowDocuments*) g_type_create_instance (object_type);
#line 60 "main_window_documents.vala"
	self->priv->_main_window = main_window;
#line 61 "main_window_documents.vala"
	_tmp0_ = _g_object_ref0 (ui_manager);
#line 61 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 61 "main_window_documents.vala"
	self->priv->_ui_manager = _tmp0_;
#line 63 "main_window_documents.vala"
	_tmp1_ = gtk_action_group_new ("DocumentsMenuActionGroup");
#line 63 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_static_action_group);
#line 63 "main_window_documents.vala"
	self->priv->_static_action_group = _tmp1_;
#line 64 "main_window_documents.vala"
	_tmp2_ = self->priv->_static_action_group;
#line 64 "main_window_documents.vala"
	gtk_action_group_set_translation_domain (_tmp2_, GETTEXT_PACKAGE);
#line 65 "main_window_documents.vala"
	_tmp3_ = self->priv->_static_action_group;
#line 65 "main_window_documents.vala"
	gtk_action_group_add_actions (_tmp3_, MAIN_WINDOW_DOCUMENTS__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW_DOCUMENTS__action_entries), self);
#line 66 "main_window_documents.vala"
	_tmp4_ = self->priv->_static_action_group;
#line 66 "main_window_documents.vala"
	gtk_ui_manager_insert_action_group (ui_manager, _tmp4_, 0);
#line 68 "main_window_documents.vala"
	_tmp5_ = gtk_action_group_new ("DocumentsListActionGroup");
#line 68 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_list_action_group);
#line 68 "main_window_documents.vala"
	self->priv->_list_action_group = _tmp5_;
#line 69 "main_window_documents.vala"
	_tmp6_ = self->priv->_list_action_group;
#line 69 "main_window_documents.vala"
	gtk_ui_manager_insert_action_group (ui_manager, _tmp6_, 0);
#line 58 "main_window_documents.vala"
	return self;
#line 365 "main_window_documents.c"
}

MainWindowDocuments*
main_window_documents_new (MainWindow* main_window,
                           GtkUIManager* ui_manager)
{
#line 58 "main_window_documents.vala"
	return main_window_documents_construct (TYPE_MAIN_WINDOW_DOCUMENTS, main_window, ui_manager);
#line 374 "main_window_documents.c"
}

void
main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                           DocumentsPanel* documents_panel)
{
	DocumentsPanel* _tmp0_;
#line 72 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 72 "main_window_documents.vala"
	g_return_if_fail (documents_panel != NULL);
#line 74 "main_window_documents.vala"
	_tmp0_ = _g_object_ref0 (documents_panel);
#line 74 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 74 "main_window_documents.vala"
	self->priv->_documents_panel = _tmp0_;
#line 75 "main_window_documents.vala"
	main_window_documents_connect_signals (self);
#line 76 "main_window_documents.vala"
	main_window_documents_update_sensitivity (self);
#line 396 "main_window_documents.c"
}

static void
__lambda22_ (MainWindowDocuments* self)
{
#line 85 "main_window_documents.vala"
	main_window_documents_update_sensitivity (self);
#line 86 "main_window_documents.vala"
	main_window_documents_update_documents_list (self);
#line 406 "main_window_documents.c"
}

static void
___lambda22__gtk_notebook_page_reordered (GtkNotebook* _sender,
                                          GtkWidget* child,
                                          guint page_num,
                                          gpointer self)
{
#line 83 "main_window_documents.vala"
	__lambda22_ ((MainWindowDocuments*) self);
#line 417 "main_window_documents.c"
}

static void
__lambda23_ (MainWindowDocuments* self,
             GtkWidget* pg,
             guint page_num)
{
#line 89 "main_window_documents.vala"
	g_return_if_fail (pg != NULL);
#line 91 "main_window_documents.vala"
	main_window_documents_set_active_document (self, page_num);
#line 92 "main_window_documents.vala"
	main_window_documents_update_sensitivity (self);
#line 431 "main_window_documents.c"
}

static void
___lambda23__gtk_notebook_switch_page (GtkNotebook* _sender,
                                       GtkWidget* page,
                                       guint page_num,
                                       gpointer self)
{
#line 89 "main_window_documents.vala"
	__lambda23_ ((MainWindowDocuments*) self, page, page_num);
#line 442 "main_window_documents.c"
}

static void
__lambda24_ (MainWindowDocuments* self)
{
#line 97 "main_window_documents.vala"
	main_window_documents_update_documents_list (self);
#line 98 "main_window_documents.vala"
	main_window_documents_update_sensitivity (self);
#line 452 "main_window_documents.c"
}

static void
___lambda24__gtk_notebook_page_removed (GtkNotebook* _sender,
                                        GtkWidget* child,
                                        guint page_num,
                                        gpointer self)
{
#line 95 "main_window_documents.vala"
	__lambda24_ ((MainWindowDocuments*) self);
#line 463 "main_window_documents.c"
}

static void
__lambda25_ (MainWindowDocuments* self)
{
#line 103 "main_window_documents.vala"
	main_window_documents_update_documents_list (self);
#line 104 "main_window_documents.vala"
	main_window_documents_update_sensitivity (self);
#line 473 "main_window_documents.c"
}

static void
___lambda25__gtk_notebook_page_added (GtkNotebook* _sender,
                                      GtkWidget* child,
                                      guint page_num,
                                      gpointer self)
{
#line 101 "main_window_documents.vala"
	__lambda25_ ((MainWindowDocuments*) self);
#line 484 "main_window_documents.c"
}

static void
main_window_documents_connect_signals (MainWindowDocuments* self)
{
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	DocumentsPanel* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
#line 79 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 81 "main_window_documents.vala"
	_tmp0_ = self->priv->_documents_panel;
#line 81 "main_window_documents.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 83 "main_window_documents.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 83 "main_window_documents.vala"
	g_signal_connect_after ((GtkNotebook*) _tmp1_, "page-reordered", (GCallback) ___lambda22__gtk_notebook_page_reordered, self);
#line 89 "main_window_documents.vala"
	_tmp2_ = self->priv->_documents_panel;
#line 89 "main_window_documents.vala"
	g_signal_connect_after ((GtkNotebook*) _tmp2_, "switch-page", (GCallback) ___lambda23__gtk_notebook_switch_page, self);
#line 95 "main_window_documents.vala"
	_tmp3_ = self->priv->_documents_panel;
#line 95 "main_window_documents.vala"
	g_signal_connect_after ((GtkNotebook*) _tmp3_, "page-removed", (GCallback) ___lambda24__gtk_notebook_page_removed, self);
#line 101 "main_window_documents.vala"
	_tmp4_ = self->priv->_documents_panel;
#line 101 "main_window_documents.vala"
	g_signal_connect_after ((GtkNotebook*) _tmp4_, "page-added", (GCallback) ___lambda25__gtk_notebook_page_added, self);
#line 517 "main_window_documents.c"
}

static void
_main_window_documents_list_action_activate_gtk_action_activate (GtkAction* _sender,
                                                                 gpointer self)
{
#line 118 "main_window_documents.vala"
	main_window_documents_list_action_activate ((MainWindowDocuments*) self, _sender);
#line 526 "main_window_documents.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 548 "main_window_documents.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 552 "main_window_documents.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 558 "main_window_documents.c"
	} else {
#line 1535 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 562 "main_window_documents.c"
	}
#line 1535 "glib-2.0.vapi"
	if (_tmp0_) {
#line 566 "main_window_documents.c"
		gchar* _tmp2_;
#line 1536 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1536 "glib-2.0.vapi"
		result = _tmp2_;
#line 1536 "glib-2.0.vapi"
		return result;
#line 574 "main_window_documents.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1539 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1539 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1539 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1539 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1539 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1539 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1539 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1539 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 602 "main_window_documents.c"
				goto __catch0_g_regex_error;
			}
#line 1539 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1539 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1539 "glib-2.0.vapi"
			return NULL;
#line 611 "main_window_documents.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1540 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1540 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1540 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1540 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 625 "main_window_documents.c"
				goto __catch0_g_regex_error;
			}
#line 1540 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1540 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1540 "glib-2.0.vapi"
			return NULL;
#line 634 "main_window_documents.c"
		}
#line 1540 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1540 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1540 "glib-2.0.vapi"
		result = _tmp10_;
#line 1540 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1540 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1540 "glib-2.0.vapi"
		return result;
#line 648 "main_window_documents.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1538 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1542 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 657 "main_window_documents.c"
	}
	__finally0:
#line 1538 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1538 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1538 "glib-2.0.vapi"
	return NULL;
#line 666 "main_window_documents.c"
}

static void
main_window_documents_update_documents_list (MainWindowDocuments* self)
{
	GtkActionGroup* _tmp0_;
	DocumentsPanel* _tmp1_;
	GtkActionGroup* _tmp3_;
	GList* _tmp4_;
	gint nb_docs = 0;
	DocumentsPanel* _tmp10_;
	GtkUIManager* _tmp11_;
	GSList* group = NULL;
#line 108 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 110 "main_window_documents.vala"
	_tmp0_ = self->priv->_list_action_group;
#line 110 "main_window_documents.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 111 "main_window_documents.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 111 "main_window_documents.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 113 "main_window_documents.vala"
	if (self->priv->_list_id != ((guint) 0)) {
#line 692 "main_window_documents.c"
		GtkUIManager* _tmp2_;
#line 114 "main_window_documents.vala"
		_tmp2_ = self->priv->_ui_manager;
#line 114 "main_window_documents.vala"
		gtk_ui_manager_remove_ui (_tmp2_, self->priv->_list_id);
#line 698 "main_window_documents.c"
	}
#line 116 "main_window_documents.vala"
	_tmp3_ = self->priv->_list_action_group;
#line 116 "main_window_documents.vala"
	_tmp4_ = gtk_action_group_list_actions (_tmp3_);
#line 704 "main_window_documents.c"
	{
		GList* action_collection = NULL;
		GList* action_it = NULL;
#line 116 "main_window_documents.vala"
		action_collection = _tmp4_;
#line 116 "main_window_documents.vala"
		for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
#line 712 "main_window_documents.c"
			GtkAction* _tmp5_;
			GtkAction* action = NULL;
#line 116 "main_window_documents.vala"
			_tmp5_ = _g_object_ref0 ((GtkAction*) action_it->data);
#line 116 "main_window_documents.vala"
			action = _tmp5_;
#line 719 "main_window_documents.c"
			{
				GtkAction* _tmp6_;
				guint _tmp7_;
				GtkActionGroup* _tmp8_;
				GtkAction* _tmp9_;
#line 118 "main_window_documents.vala"
				_tmp6_ = action;
#line 118 "main_window_documents.vala"
				g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp7_, NULL, FALSE);
#line 118 "main_window_documents.vala"
				g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
#line 119 "main_window_documents.vala"
				_tmp8_ = self->priv->_list_action_group;
#line 119 "main_window_documents.vala"
				_tmp9_ = action;
#line 119 "main_window_documents.vala"
				gtk_action_group_remove_action (_tmp8_, _tmp9_);
#line 116 "main_window_documents.vala"
				_g_object_unref0 (action);
#line 739 "main_window_documents.c"
			}
		}
#line 116 "main_window_documents.vala"
		(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
#line 744 "main_window_documents.c"
	}
#line 122 "main_window_documents.vala"
	self->priv->_list_id = (guint) 0;
#line 124 "main_window_documents.vala"
	_tmp10_ = self->priv->_documents_panel;
#line 124 "main_window_documents.vala"
	nb_docs = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp10_);
#line 125 "main_window_documents.vala"
	if (nb_docs == 0) {
#line 126 "main_window_documents.vala"
		return;
#line 756 "main_window_documents.c"
	}
#line 128 "main_window_documents.vala"
	_tmp11_ = self->priv->_ui_manager;
#line 128 "main_window_documents.vala"
	self->priv->_list_id = gtk_ui_manager_new_merge_id (_tmp11_);
#line 130 "main_window_documents.vala"
	group = NULL;
#line 764 "main_window_documents.c"
	{
		gint doc_num = 0;
#line 132 "main_window_documents.vala"
		doc_num = 0;
#line 769 "main_window_documents.c"
		{
			gboolean _tmp12_ = FALSE;
#line 132 "main_window_documents.vala"
			_tmp12_ = TRUE;
#line 132 "main_window_documents.vala"
			while (TRUE) {
#line 776 "main_window_documents.c"
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp14_;
				GtkWidget* _tmp15_;
				DocumentTab* _tmp16_;
				gchar* action_name = NULL;
				gchar* _tmp17_;
				gchar* name = NULL;
				DocumentTab* _tmp18_;
				TeplBuffer* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* tip = NULL;
				DocumentTab* _tmp24_;
				gchar* _tmp25_;
				gchar* accel = NULL;
				GtkRadioAction* action = NULL;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				GtkRadioAction* _tmp30_;
				GSList* _tmp31_;
				GtkRadioAction* _tmp34_;
				GSList* _tmp35_;
				GtkActionGroup* _tmp36_;
				GtkRadioAction* _tmp37_;
				const gchar* _tmp38_;
				GtkRadioAction* _tmp39_;
				GtkUIManager* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				DocumentTab* _tmp43_;
				MainWindow* _tmp44_;
				DocumentTab* _tmp45_;
				DocumentTab* _tmp46_;
#line 132 "main_window_documents.vala"
				if (!_tmp12_) {
#line 815 "main_window_documents.c"
					gint _tmp13_;
#line 132 "main_window_documents.vala"
					_tmp13_ = doc_num;
#line 132 "main_window_documents.vala"
					doc_num = _tmp13_ + 1;
#line 821 "main_window_documents.c"
				}
#line 132 "main_window_documents.vala"
				_tmp12_ = FALSE;
#line 132 "main_window_documents.vala"
				if (!(doc_num < nb_docs)) {
#line 132 "main_window_documents.vala"
					break;
#line 829 "main_window_documents.c"
				}
#line 134 "main_window_documents.vala"
				_tmp14_ = self->priv->_documents_panel;
#line 134 "main_window_documents.vala"
				_tmp15_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp14_, doc_num);
#line 134 "main_window_documents.vala"
				_tmp16_ = _g_object_ref0 (IS_DOCUMENT_TAB (_tmp15_) ? ((DocumentTab*) _tmp15_) : NULL);
#line 134 "main_window_documents.vala"
				tab = _tmp16_;
#line 135 "main_window_documents.vala"
				_tmp17_ = main_window_documents_get_list_action_name (self, (guint) doc_num);
#line 135 "main_window_documents.vala"
				action_name = _tmp17_;
#line 136 "main_window_documents.vala"
				_tmp18_ = tab;
#line 136 "main_window_documents.vala"
				_tmp19_ = tepl_tab_get_buffer ((TeplTab*) _tmp18_);
#line 136 "main_window_documents.vala"
				_tmp20_ = tepl_buffer_get_short_title (_tmp19_);
#line 136 "main_window_documents.vala"
				_tmp21_ = _tmp20_;
#line 136 "main_window_documents.vala"
				_tmp22_ = string_replace (_tmp21_, "_", "__");
#line 136 "main_window_documents.vala"
				_tmp23_ = _tmp22_;
#line 136 "main_window_documents.vala"
				_g_free0 (_tmp21_);
#line 136 "main_window_documents.vala"
				name = _tmp23_;
#line 137 "main_window_documents.vala"
				_tmp24_ = tab;
#line 137 "main_window_documents.vala"
				_tmp25_ = document_tab_get_menu_tip (_tmp24_);
#line 137 "main_window_documents.vala"
				tip = _tmp25_;
#line 139 "main_window_documents.vala"
				accel = NULL;
#line 140 "main_window_documents.vala"
				if (doc_num < 10) {
#line 869 "main_window_documents.c"
					gchar* _tmp26_;
#line 141 "main_window_documents.vala"
					_tmp26_ = g_strdup_printf ("<alt>%d", (doc_num + 1) % 10);
#line 141 "main_window_documents.vala"
					_g_free0 (accel);
#line 141 "main_window_documents.vala"
					accel = _tmp26_;
#line 877 "main_window_documents.c"
				}
#line 143 "main_window_documents.vala"
				_tmp27_ = action_name;
#line 143 "main_window_documents.vala"
				_tmp28_ = name;
#line 143 "main_window_documents.vala"
				_tmp29_ = tip;
#line 143 "main_window_documents.vala"
				_tmp30_ = gtk_radio_action_new (_tmp27_, _tmp28_, _tmp29_, NULL, doc_num);
#line 143 "main_window_documents.vala"
				action = _tmp30_;
#line 144 "main_window_documents.vala"
				_tmp31_ = group;
#line 144 "main_window_documents.vala"
				if (_tmp31_ != NULL) {
#line 893 "main_window_documents.c"
					GtkRadioAction* _tmp32_;
					GSList* _tmp33_;
#line 145 "main_window_documents.vala"
					_tmp32_ = action;
#line 145 "main_window_documents.vala"
					_tmp33_ = group;
#line 145 "main_window_documents.vala"
					gtk_radio_action_set_group (_tmp32_, _tmp33_);
#line 902 "main_window_documents.c"
				}
#line 148 "main_window_documents.vala"
				_tmp34_ = action;
#line 148 "main_window_documents.vala"
				_tmp35_ = gtk_radio_action_get_group (_tmp34_);
#line 148 "main_window_documents.vala"
				group = _tmp35_;
#line 150 "main_window_documents.vala"
				_tmp36_ = self->priv->_list_action_group;
#line 150 "main_window_documents.vala"
				_tmp37_ = action;
#line 150 "main_window_documents.vala"
				_tmp38_ = accel;
#line 150 "main_window_documents.vala"
				gtk_action_group_add_action_with_accel (_tmp36_, (GtkAction*) _tmp37_, _tmp38_);
#line 152 "main_window_documents.vala"
				_tmp39_ = action;
#line 152 "main_window_documents.vala"
				g_signal_connect ((GtkAction*) _tmp39_, "activate", (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
#line 154 "main_window_documents.vala"
				_tmp40_ = self->priv->_ui_manager;
#line 154 "main_window_documents.vala"
				_tmp41_ = action_name;
#line 154 "main_window_documents.vala"
				_tmp42_ = action_name;
#line 154 "main_window_documents.vala"
				gtk_ui_manager_add_ui (_tmp40_, self->priv->_list_id, "/MainMenu/DocumentsMenu/DocumentsListPlaceholder", _tmp41_, _tmp42_, GTK_UI_MANAGER_MENUITEM, FALSE);
#line 158 "main_window_documents.vala"
				_tmp43_ = tab;
#line 158 "main_window_documents.vala"
				_tmp44_ = self->priv->_main_window;
#line 158 "main_window_documents.vala"
				_tmp45_ = main_window_get_active_tab (_tmp44_);
#line 158 "main_window_documents.vala"
				_tmp46_ = _tmp45_;
#line 158 "main_window_documents.vala"
				if (_tmp43_ == _tmp46_) {
#line 940 "main_window_documents.c"
					GtkRadioAction* _tmp47_;
#line 159 "main_window_documents.vala"
					_tmp47_ = action;
#line 159 "main_window_documents.vala"
					gtk_toggle_action_set_active ((GtkToggleAction*) _tmp47_, TRUE);
#line 946 "main_window_documents.c"
				}
#line 132 "main_window_documents.vala"
				_g_object_unref0 (action);
#line 132 "main_window_documents.vala"
				_g_free0 (accel);
#line 132 "main_window_documents.vala"
				_g_free0 (tip);
#line 132 "main_window_documents.vala"
				_g_free0 (name);
#line 132 "main_window_documents.vala"
				_g_free0 (action_name);
#line 132 "main_window_documents.vala"
				_g_object_unref0 (tab);
#line 960 "main_window_documents.c"
			}
		}
	}
}

static void
main_window_documents_set_active_document (MainWindowDocuments* self,
                                           guint doc_num)
{
	gchar* action_name = NULL;
	gchar* _tmp0_;
	GtkRadioAction* action = NULL;
	GtkActionGroup* _tmp1_;
	const gchar* _tmp2_;
	GtkAction* _tmp3_;
	GtkRadioAction* _tmp4_;
	GtkRadioAction* _tmp5_;
#line 163 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 165 "main_window_documents.vala"
	_tmp0_ = main_window_documents_get_list_action_name (self, doc_num);
#line 165 "main_window_documents.vala"
	action_name = _tmp0_;
#line 166 "main_window_documents.vala"
	_tmp1_ = self->priv->_list_action_group;
#line 166 "main_window_documents.vala"
	_tmp2_ = action_name;
#line 166 "main_window_documents.vala"
	_tmp3_ = gtk_action_group_get_action (_tmp1_, _tmp2_);
#line 166 "main_window_documents.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_radio_action_get_type ()) ? ((GtkRadioAction*) _tmp3_) : NULL);
#line 166 "main_window_documents.vala"
	action = _tmp4_;
#line 168 "main_window_documents.vala"
	_tmp5_ = action;
#line 168 "main_window_documents.vala"
	if (_tmp5_ != NULL) {
#line 998 "main_window_documents.c"
		GtkRadioAction* _tmp6_;
		guint _tmp7_;
		GtkRadioAction* _tmp8_;
		GtkRadioAction* _tmp9_;
#line 171 "main_window_documents.vala"
		_tmp6_ = action;
#line 171 "main_window_documents.vala"
		g_signal_parse_name ("activate", gtk_action_get_type (), &_tmp7_, NULL, FALSE);
#line 171 "main_window_documents.vala"
		g_signal_handlers_disconnect_matched ((GtkAction*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
#line 172 "main_window_documents.vala"
		_tmp8_ = action;
#line 172 "main_window_documents.vala"
		gtk_toggle_action_set_active ((GtkToggleAction*) _tmp8_, TRUE);
#line 173 "main_window_documents.vala"
		_tmp9_ = action;
#line 173 "main_window_documents.vala"
		g_signal_connect ((GtkAction*) _tmp9_, "activate", (GCallback) _main_window_documents_list_action_activate_gtk_action_activate, self);
#line 1017 "main_window_documents.c"
	}
#line 163 "main_window_documents.vala"
	_g_object_unref0 (action);
#line 163 "main_window_documents.vala"
	_g_free0 (action_name);
#line 1023 "main_window_documents.c"
}

void
main_window_documents_update_document_name (MainWindowDocuments* self,
                                            DocumentTab* tab)
{
	DocumentsPanel* _tmp0_;
	gint doc_num = 0;
	DocumentsPanel* _tmp1_;
	gchar* action_name = NULL;
	gchar* _tmp2_;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp3_;
	GtkAction* _tmp4_;
	GtkAction* _tmp5_;
	TeplBuffer* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 177 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 177 "main_window_documents.vala"
	g_return_if_fail (tab != NULL);
#line 179 "main_window_documents.vala"
	_tmp0_ = self->priv->_documents_panel;
#line 179 "main_window_documents.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 181 "main_window_documents.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 181 "main_window_documents.vala"
	doc_num = gtk_notebook_page_num ((GtkNotebook*) _tmp1_, (GtkWidget*) tab);
#line 182 "main_window_documents.vala"
	_tmp2_ = main_window_documents_get_list_action_name (self, (guint) doc_num);
#line 182 "main_window_documents.vala"
	action_name = _tmp2_;
#line 184 "main_window_documents.vala"
	_tmp3_ = self->priv->_list_action_group;
#line 184 "main_window_documents.vala"
	_tmp4_ = gtk_action_group_get_action (_tmp3_, action_name);
#line 184 "main_window_documents.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 184 "main_window_documents.vala"
	action = _tmp5_;
#line 185 "main_window_documents.vala"
	g_return_if_fail (action != NULL);
#line 187 "main_window_documents.vala"
	_tmp6_ = tepl_tab_get_buffer ((TeplTab*) tab);
#line 187 "main_window_documents.vala"
	_tmp7_ = tepl_buffer_get_short_title (_tmp6_);
#line 187 "main_window_documents.vala"
	_tmp8_ = _tmp7_;
#line 187 "main_window_documents.vala"
	_tmp9_ = string_replace (_tmp8_, "_", "__");
#line 187 "main_window_documents.vala"
	_tmp10_ = _tmp9_;
#line 187 "main_window_documents.vala"
	gtk_action_set_label (action, _tmp10_);
#line 187 "main_window_documents.vala"
	_g_free0 (_tmp10_);
#line 187 "main_window_documents.vala"
	_g_free0 (_tmp8_);
#line 188 "main_window_documents.vala"
	_tmp11_ = document_tab_get_menu_tip (tab);
#line 188 "main_window_documents.vala"
	_tmp12_ = _tmp11_;
#line 188 "main_window_documents.vala"
	gtk_action_set_tooltip (action, _tmp12_);
#line 188 "main_window_documents.vala"
	_g_free0 (_tmp12_);
#line 177 "main_window_documents.vala"
	_g_object_unref0 (action);
#line 177 "main_window_documents.vala"
	_g_free0 (action_name);
#line 1100 "main_window_documents.c"
}

static void
main_window_documents_list_action_activate (MainWindowDocuments* self,
                                            GtkAction* action)
{
	DocumentsPanel* _tmp0_;
	GtkRadioAction* radio_action = NULL;
	GtkRadioAction* _tmp1_;
	GtkRadioAction* _tmp2_;
	DocumentsPanel* _tmp3_;
	GtkRadioAction* _tmp4_;
#line 191 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 191 "main_window_documents.vala"
	g_return_if_fail (action != NULL);
#line 193 "main_window_documents.vala"
	_tmp0_ = self->priv->_documents_panel;
#line 193 "main_window_documents.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 195 "main_window_documents.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (action, gtk_radio_action_get_type ()) ? ((GtkRadioAction*) action) : NULL);
#line 195 "main_window_documents.vala"
	radio_action = _tmp1_;
#line 196 "main_window_documents.vala"
	_tmp2_ = radio_action;
#line 196 "main_window_documents.vala"
	if (!gtk_toggle_action_get_active ((GtkToggleAction*) _tmp2_)) {
#line 197 "main_window_documents.vala"
		_g_object_unref0 (radio_action);
#line 197 "main_window_documents.vala"
		return;
#line 1133 "main_window_documents.c"
	}
#line 199 "main_window_documents.vala"
	_tmp3_ = self->priv->_documents_panel;
#line 199 "main_window_documents.vala"
	_tmp4_ = radio_action;
#line 199 "main_window_documents.vala"
	gtk_notebook_set_current_page ((GtkNotebook*) _tmp3_, gtk_radio_action_get_current_value (_tmp4_));
#line 191 "main_window_documents.vala"
	_g_object_unref0 (radio_action);
#line 1143 "main_window_documents.c"
}

static gchar*
main_window_documents_get_list_action_name (MainWindowDocuments* self,
                                            guint doc_num)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 202 "main_window_documents.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 204 "main_window_documents.vala"
	_tmp0_ = g_strdup_printf ("%u", doc_num);
#line 204 "main_window_documents.vala"
	_tmp1_ = _tmp0_;
#line 204 "main_window_documents.vala"
	_tmp2_ = g_strconcat ("Tab_", _tmp1_, NULL);
#line 204 "main_window_documents.vala"
	_tmp3_ = _tmp2_;
#line 204 "main_window_documents.vala"
	_g_free0 (_tmp1_);
#line 204 "main_window_documents.vala"
	result = _tmp3_;
#line 204 "main_window_documents.vala"
	return result;
#line 1171 "main_window_documents.c"
}

static void
main_window_documents_update_sensitivity (MainWindowDocuments* self)
{
	gboolean sensitive = FALSE;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	gchar** action_names = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint action_names_length1;
	gint _action_names_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
#line 209 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 211 "main_window_documents.vala"
	_tmp0_ = self->priv->_main_window;
#line 211 "main_window_documents.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 211 "main_window_documents.vala"
	_tmp2_ = _tmp1_;
#line 211 "main_window_documents.vala"
	sensitive = _tmp2_ != NULL;
#line 213 "main_window_documents.vala"
	_tmp3_ = g_strdup ("DocumentsSaveAll");
#line 213 "main_window_documents.vala"
	_tmp4_ = g_strdup ("DocumentsCloseAll");
#line 213 "main_window_documents.vala"
	_tmp5_ = g_strdup ("DocumentsMoveToNewWindow");
#line 213 "main_window_documents.vala"
	_tmp6_ = g_new0 (gchar*, 3 + 1);
#line 213 "main_window_documents.vala"
	_tmp6_[0] = _tmp3_;
#line 213 "main_window_documents.vala"
	_tmp6_[1] = _tmp4_;
#line 213 "main_window_documents.vala"
	_tmp6_[2] = _tmp5_;
#line 213 "main_window_documents.vala"
	action_names = _tmp6_;
#line 213 "main_window_documents.vala"
	action_names_length1 = 3;
#line 213 "main_window_documents.vala"
	_action_names_size_ = action_names_length1;
#line 220 "main_window_documents.vala"
	_tmp7_ = action_names;
#line 220 "main_window_documents.vala"
	_tmp7__length1 = action_names_length1;
#line 1224 "main_window_documents.c"
	{
		gchar** action_name_collection = NULL;
		gint action_name_collection_length1 = 0;
		gint _action_name_collection_size_ = 0;
		gint action_name_it = 0;
#line 220 "main_window_documents.vala"
		action_name_collection = _tmp7_;
#line 220 "main_window_documents.vala"
		action_name_collection_length1 = _tmp7__length1;
#line 220 "main_window_documents.vala"
		for (action_name_it = 0; action_name_it < action_name_collection_length1; action_name_it = action_name_it + 1) {
#line 1236 "main_window_documents.c"
			gchar* _tmp8_;
			gchar* action_name = NULL;
#line 220 "main_window_documents.vala"
			_tmp8_ = g_strdup (action_name_collection[action_name_it]);
#line 220 "main_window_documents.vala"
			action_name = _tmp8_;
#line 1243 "main_window_documents.c"
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp9_;
				const gchar* _tmp10_;
				GtkAction* _tmp11_;
				GtkAction* _tmp12_;
				GtkAction* _tmp13_;
#line 222 "main_window_documents.vala"
				_tmp9_ = self->priv->_static_action_group;
#line 222 "main_window_documents.vala"
				_tmp10_ = action_name;
#line 222 "main_window_documents.vala"
				_tmp11_ = gtk_action_group_get_action (_tmp9_, _tmp10_);
#line 222 "main_window_documents.vala"
				_tmp12_ = _g_object_ref0 (_tmp11_);
#line 222 "main_window_documents.vala"
				action = _tmp12_;
#line 223 "main_window_documents.vala"
				_tmp13_ = action;
#line 223 "main_window_documents.vala"
				gtk_action_set_sensitive (_tmp13_, sensitive);
#line 220 "main_window_documents.vala"
				_g_object_unref0 (action);
#line 220 "main_window_documents.vala"
				_g_free0 (action_name);
#line 1269 "main_window_documents.c"
			}
		}
	}
#line 226 "main_window_documents.vala"
	main_window_documents_update_next_prev_doc_sensitivity (self);
#line 209 "main_window_documents.vala"
	action_names = (_vala_array_free (action_names, action_names_length1, (GDestroyNotify) g_free), NULL);
#line 1277 "main_window_documents.c"
}

static void
main_window_documents_update_next_prev_doc_sensitivity (MainWindowDocuments* self)
{
	DocumentsPanel* _tmp0_;
	GtkAction* action_prev = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	GtkAction* action_next = NULL;
	GtkActionGroup* _tmp4_;
	GtkAction* _tmp5_;
	GtkAction* _tmp6_;
	MainWindow* _tmp7_;
	DocumentTab* _tmp8_;
	DocumentTab* _tmp9_;
	gint current_page = 0;
	DocumentsPanel* _tmp12_;
	MainWindow* _tmp13_;
	DocumentTab* _tmp14_;
	DocumentTab* _tmp15_;
	GtkAction* _tmp16_;
	gint nb_pages = 0;
	DocumentsPanel* _tmp17_;
	GtkAction* _tmp18_;
#line 229 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 231 "main_window_documents.vala"
	_tmp0_ = self->priv->_documents_panel;
#line 231 "main_window_documents.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 233 "main_window_documents.vala"
	_tmp1_ = self->priv->_static_action_group;
#line 233 "main_window_documents.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "DocumentsPrevious");
#line 233 "main_window_documents.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 233 "main_window_documents.vala"
	action_prev = _tmp3_;
#line 234 "main_window_documents.vala"
	_tmp4_ = self->priv->_static_action_group;
#line 234 "main_window_documents.vala"
	_tmp5_ = gtk_action_group_get_action (_tmp4_, "DocumentsNext");
#line 234 "main_window_documents.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 234 "main_window_documents.vala"
	action_next = _tmp6_;
#line 236 "main_window_documents.vala"
	_tmp7_ = self->priv->_main_window;
#line 236 "main_window_documents.vala"
	_tmp8_ = main_window_get_active_tab (_tmp7_);
#line 236 "main_window_documents.vala"
	_tmp9_ = _tmp8_;
#line 236 "main_window_documents.vala"
	if (_tmp9_ == NULL) {
#line 1334 "main_window_documents.c"
		GtkAction* _tmp10_;
		GtkAction* _tmp11_;
#line 238 "main_window_documents.vala"
		_tmp10_ = action_prev;
#line 238 "main_window_documents.vala"
		gtk_action_set_sensitive (_tmp10_, FALSE);
#line 239 "main_window_documents.vala"
		_tmp11_ = action_next;
#line 239 "main_window_documents.vala"
		gtk_action_set_sensitive (_tmp11_, FALSE);
#line 240 "main_window_documents.vala"
		_g_object_unref0 (action_next);
#line 240 "main_window_documents.vala"
		_g_object_unref0 (action_prev);
#line 240 "main_window_documents.vala"
		return;
#line 1351 "main_window_documents.c"
	}
#line 243 "main_window_documents.vala"
	_tmp12_ = self->priv->_documents_panel;
#line 243 "main_window_documents.vala"
	_tmp13_ = self->priv->_main_window;
#line 243 "main_window_documents.vala"
	_tmp14_ = main_window_get_active_tab (_tmp13_);
#line 243 "main_window_documents.vala"
	_tmp15_ = _tmp14_;
#line 243 "main_window_documents.vala"
	current_page = gtk_notebook_page_num ((GtkNotebook*) _tmp12_, (GtkWidget*) _tmp15_);
#line 244 "main_window_documents.vala"
	_tmp16_ = action_prev;
#line 244 "main_window_documents.vala"
	gtk_action_set_sensitive (_tmp16_, current_page > 0);
#line 246 "main_window_documents.vala"
	_tmp17_ = self->priv->_documents_panel;
#line 246 "main_window_documents.vala"
	nb_pages = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp17_);
#line 247 "main_window_documents.vala"
	_tmp18_ = action_next;
#line 247 "main_window_documents.vala"
	gtk_action_set_sensitive (_tmp18_, current_page < (nb_pages - 1));
#line 229 "main_window_documents.vala"
	_g_object_unref0 (action_next);
#line 229 "main_window_documents.vala"
	_g_object_unref0 (action_prev);
#line 1379 "main_window_documents.c"
}

void
main_window_documents_on_save_all (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
#line 252 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 254 "main_window_documents.vala"
	_tmp0_ = self->priv->_main_window;
#line 254 "main_window_documents.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 254 "main_window_documents.vala"
	_tmp2_ = _tmp1_;
#line 254 "main_window_documents.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 1398 "main_window_documents.c"
	{
		GeeList* _doc_list = NULL;
		MainWindow* _tmp3_;
		GeeList* _tmp4_;
		gint _doc_size = 0;
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _doc_index = 0;
#line 256 "main_window_documents.vala"
		_tmp3_ = self->priv->_main_window;
#line 256 "main_window_documents.vala"
		_tmp4_ = main_window_get_unsaved_documents (_tmp3_);
#line 256 "main_window_documents.vala"
		_doc_list = _tmp4_;
#line 256 "main_window_documents.vala"
		_tmp5_ = _doc_list;
#line 256 "main_window_documents.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 256 "main_window_documents.vala"
		_tmp7_ = _tmp6_;
#line 256 "main_window_documents.vala"
		_doc_size = _tmp7_;
#line 256 "main_window_documents.vala"
		_doc_index = -1;
#line 256 "main_window_documents.vala"
		while (TRUE) {
#line 1426 "main_window_documents.c"
			Document* doc = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			Document* _tmp10_;
#line 256 "main_window_documents.vala"
			_doc_index = _doc_index + 1;
#line 256 "main_window_documents.vala"
			if (!(_doc_index < _doc_size)) {
#line 256 "main_window_documents.vala"
				break;
#line 1437 "main_window_documents.c"
			}
#line 256 "main_window_documents.vala"
			_tmp8_ = _doc_list;
#line 256 "main_window_documents.vala"
			_tmp9_ = gee_list_get (_tmp8_, _doc_index);
#line 256 "main_window_documents.vala"
			doc = (Document*) _tmp9_;
#line 257 "main_window_documents.vala"
			_tmp10_ = doc;
#line 257 "main_window_documents.vala"
			document_save (_tmp10_, TRUE, FALSE);
#line 256 "main_window_documents.vala"
			_g_object_unref0 (doc);
#line 1451 "main_window_documents.c"
		}
#line 256 "main_window_documents.vala"
		_g_object_unref0 (_doc_list);
#line 1455 "main_window_documents.c"
	}
}

void
main_window_documents_on_close_all (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	MainWindow* _tmp3_;
#line 260 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 262 "main_window_documents.vala"
	_tmp0_ = self->priv->_main_window;
#line 262 "main_window_documents.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 262 "main_window_documents.vala"
	_tmp2_ = _tmp1_;
#line 262 "main_window_documents.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 263 "main_window_documents.vala"
	_tmp3_ = self->priv->_main_window;
#line 263 "main_window_documents.vala"
	main_window_close_all_documents (_tmp3_);
#line 1480 "main_window_documents.c"
}

void
main_window_documents_on_previous (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
#line 266 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 268 "main_window_documents.vala"
	_tmp0_ = self->priv->_main_window;
#line 268 "main_window_documents.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 268 "main_window_documents.vala"
	_tmp2_ = _tmp1_;
#line 268 "main_window_documents.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 269 "main_window_documents.vala"
	_tmp3_ = self->priv->_documents_panel;
#line 269 "main_window_documents.vala"
	g_return_if_fail (_tmp3_ != NULL);
#line 270 "main_window_documents.vala"
	_tmp4_ = self->priv->_documents_panel;
#line 270 "main_window_documents.vala"
	gtk_notebook_prev_page ((GtkNotebook*) _tmp4_);
#line 1509 "main_window_documents.c"
}

void
main_window_documents_on_next (MainWindowDocuments* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
#line 273 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 275 "main_window_documents.vala"
	_tmp0_ = self->priv->_main_window;
#line 275 "main_window_documents.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 275 "main_window_documents.vala"
	_tmp2_ = _tmp1_;
#line 275 "main_window_documents.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 276 "main_window_documents.vala"
	_tmp3_ = self->priv->_documents_panel;
#line 276 "main_window_documents.vala"
	g_return_if_fail (_tmp3_ != NULL);
#line 277 "main_window_documents.vala"
	_tmp4_ = self->priv->_documents_panel;
#line 277 "main_window_documents.vala"
	gtk_notebook_next_page ((GtkNotebook*) _tmp4_);
#line 1538 "main_window_documents.c"
}

void
main_window_documents_on_move_to_new_window (MainWindowDocuments* self)
{
	DocumentTab* tab = NULL;
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	DocumentTab* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentsPanel* _tmp5_;
	MainWindow* new_window = NULL;
	GlatexApp* _tmp6_;
	GlatexApp* _tmp7_;
	MainWindow* _tmp8_;
	MainWindow* _tmp9_;
	DocumentView* view = NULL;
	DocumentTab* _tmp10_;
	DocumentView* _tmp11_;
	DocumentView* _tmp12_;
	DocumentView* _tmp13_;
	DocumentsPanel* _tmp14_;
	DocumentTab* _tmp15_;
	GtkContainer* parent = NULL;
	DocumentView* _tmp16_;
	GtkContainer* _tmp17_;
	GtkContainer* _tmp18_;
	GtkContainer* _tmp19_;
	MainWindow* _tmp22_;
	DocumentView* _tmp23_;
#line 280 "main_window_documents.vala"
	g_return_if_fail (self != NULL);
#line 282 "main_window_documents.vala"
	_tmp0_ = self->priv->_main_window;
#line 282 "main_window_documents.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 282 "main_window_documents.vala"
	_tmp2_ = _tmp1_;
#line 282 "main_window_documents.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 282 "main_window_documents.vala"
	tab = _tmp3_;
#line 283 "main_window_documents.vala"
	_tmp4_ = tab;
#line 283 "main_window_documents.vala"
	g_return_if_fail (_tmp4_ != NULL);
#line 284 "main_window_documents.vala"
	_tmp5_ = self->priv->_documents_panel;
#line 284 "main_window_documents.vala"
	g_return_if_fail (_tmp5_ != NULL);
#line 286 "main_window_documents.vala"
	_tmp6_ = glatex_app_get_instance ();
#line 286 "main_window_documents.vala"
	_tmp7_ = _tmp6_;
#line 286 "main_window_documents.vala"
	_tmp8_ = glatex_app_create_window (_tmp7_);
#line 286 "main_window_documents.vala"
	_tmp9_ = _tmp8_;
#line 286 "main_window_documents.vala"
	_g_object_unref0 (_tmp7_);
#line 286 "main_window_documents.vala"
	new_window = _tmp9_;
#line 287 "main_window_documents.vala"
	_tmp10_ = tab;
#line 287 "main_window_documents.vala"
	_tmp11_ = document_tab_get_document_view (_tmp10_);
#line 287 "main_window_documents.vala"
	_tmp12_ = _tmp11_;
#line 287 "main_window_documents.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 287 "main_window_documents.vala"
	view = _tmp13_;
#line 288 "main_window_documents.vala"
	_tmp14_ = self->priv->_documents_panel;
#line 288 "main_window_documents.vala"
	_tmp15_ = tab;
#line 288 "main_window_documents.vala"
	documents_panel_remove_tab (_tmp14_, _tmp15_);
#line 290 "main_window_documents.vala"
	_tmp16_ = view;
#line 290 "main_window_documents.vala"
	_tmp17_ = gtk_widget_get_parent ((GtkWidget*) _tmp16_);
#line 290 "main_window_documents.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer));
#line 290 "main_window_documents.vala"
	parent = _tmp18_;
#line 291 "main_window_documents.vala"
	_tmp19_ = parent;
#line 291 "main_window_documents.vala"
	if (_tmp19_ != NULL) {
#line 1630 "main_window_documents.c"
		GtkContainer* _tmp20_;
		DocumentView* _tmp21_;
#line 292 "main_window_documents.vala"
		_tmp20_ = parent;
#line 292 "main_window_documents.vala"
		_tmp21_ = view;
#line 292 "main_window_documents.vala"
		gtk_container_remove (_tmp20_, (GtkWidget*) _tmp21_);
#line 1639 "main_window_documents.c"
	}
#line 294 "main_window_documents.vala"
	_tmp22_ = new_window;
#line 294 "main_window_documents.vala"
	_tmp23_ = view;
#line 294 "main_window_documents.vala"
	main_window_create_tab_with_view (_tmp22_, _tmp23_);
#line 280 "main_window_documents.vala"
	_g_object_unref0 (parent);
#line 280 "main_window_documents.vala"
	_g_object_unref0 (view);
#line 280 "main_window_documents.vala"
	_g_object_unref0 (new_window);
#line 280 "main_window_documents.vala"
	_g_object_unref0 (tab);
#line 1655 "main_window_documents.c"
}

static void
value_main_window_documents_init (GValue* value)
{
#line 26 "main_window_documents.vala"
	value->data[0].v_pointer = NULL;
#line 1663 "main_window_documents.c"
}

static void
value_main_window_documents_free_value (GValue* value)
{
#line 26 "main_window_documents.vala"
	if (value->data[0].v_pointer) {
#line 26 "main_window_documents.vala"
		main_window_documents_unref (value->data[0].v_pointer);
#line 1673 "main_window_documents.c"
	}
}

static void
value_main_window_documents_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
#line 26 "main_window_documents.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "main_window_documents.vala"
		dest_value->data[0].v_pointer = main_window_documents_ref (src_value->data[0].v_pointer);
#line 1685 "main_window_documents.c"
	} else {
#line 26 "main_window_documents.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1689 "main_window_documents.c"
	}
}

static gpointer
value_main_window_documents_peek_pointer (const GValue* value)
{
#line 26 "main_window_documents.vala"
	return value->data[0].v_pointer;
#line 1698 "main_window_documents.c"
}

static gchar*
value_main_window_documents_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
#line 26 "main_window_documents.vala"
	if (collect_values[0].v_pointer) {
#line 1709 "main_window_documents.c"
		MainWindowDocuments * object;
		object = collect_values[0].v_pointer;
#line 26 "main_window_documents.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "main_window_documents.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1716 "main_window_documents.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "main_window_documents.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1720 "main_window_documents.c"
		}
#line 26 "main_window_documents.vala"
		value->data[0].v_pointer = main_window_documents_ref (object);
#line 1724 "main_window_documents.c"
	} else {
#line 26 "main_window_documents.vala"
		value->data[0].v_pointer = NULL;
#line 1728 "main_window_documents.c"
	}
#line 26 "main_window_documents.vala"
	return NULL;
#line 1732 "main_window_documents.c"
}

static gchar*
value_main_window_documents_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	MainWindowDocuments ** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "main_window_documents.vala"
	if (!object_p) {
#line 26 "main_window_documents.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1747 "main_window_documents.c"
	}
#line 26 "main_window_documents.vala"
	if (!value->data[0].v_pointer) {
#line 26 "main_window_documents.vala"
		*object_p = NULL;
#line 1753 "main_window_documents.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "main_window_documents.vala"
		*object_p = value->data[0].v_pointer;
#line 1757 "main_window_documents.c"
	} else {
#line 26 "main_window_documents.vala"
		*object_p = main_window_documents_ref (value->data[0].v_pointer);
#line 1761 "main_window_documents.c"
	}
#line 26 "main_window_documents.vala"
	return NULL;
#line 1765 "main_window_documents.c"
}

GParamSpec*
param_spec_main_window_documents (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	ParamSpecMainWindowDocuments* spec;
#line 26 "main_window_documents.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN_WINDOW_DOCUMENTS), NULL);
#line 26 "main_window_documents.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "main_window_documents.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "main_window_documents.vala"
	return G_PARAM_SPEC (spec);
#line 1784 "main_window_documents.c"
}

gpointer
value_get_main_window_documents (const GValue* value)
{
#line 26 "main_window_documents.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS), NULL);
#line 26 "main_window_documents.vala"
	return value->data[0].v_pointer;
#line 1794 "main_window_documents.c"
}

void
value_set_main_window_documents (GValue* value,
                                 gpointer v_object)
{
	MainWindowDocuments * old;
#line 26 "main_window_documents.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS));
#line 26 "main_window_documents.vala"
	old = value->data[0].v_pointer;
#line 26 "main_window_documents.vala"
	if (v_object) {
#line 26 "main_window_documents.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_DOCUMENTS));
#line 26 "main_window_documents.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "main_window_documents.vala"
		value->data[0].v_pointer = v_object;
#line 26 "main_window_documents.vala"
		main_window_documents_ref (value->data[0].v_pointer);
#line 1816 "main_window_documents.c"
	} else {
#line 26 "main_window_documents.vala"
		value->data[0].v_pointer = NULL;
#line 1820 "main_window_documents.c"
	}
#line 26 "main_window_documents.vala"
	if (old) {
#line 26 "main_window_documents.vala"
		main_window_documents_unref (old);
#line 1826 "main_window_documents.c"
	}
}

void
value_take_main_window_documents (GValue* value,
                                  gpointer v_object)
{
	MainWindowDocuments * old;
#line 26 "main_window_documents.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN_WINDOW_DOCUMENTS));
#line 26 "main_window_documents.vala"
	old = value->data[0].v_pointer;
#line 26 "main_window_documents.vala"
	if (v_object) {
#line 26 "main_window_documents.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN_WINDOW_DOCUMENTS));
#line 26 "main_window_documents.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "main_window_documents.vala"
		value->data[0].v_pointer = v_object;
#line 1847 "main_window_documents.c"
	} else {
#line 26 "main_window_documents.vala"
		value->data[0].v_pointer = NULL;
#line 1851 "main_window_documents.c"
	}
#line 26 "main_window_documents.vala"
	if (old) {
#line 26 "main_window_documents.vala"
		main_window_documents_unref (old);
#line 1857 "main_window_documents.c"
	}
}

static void
main_window_documents_class_init (MainWindowDocumentsClass * klass,
                                  gpointer klass_data)
{
#line 26 "main_window_documents.vala"
	main_window_documents_parent_class = g_type_class_peek_parent (klass);
#line 26 "main_window_documents.vala"
	((MainWindowDocumentsClass *) klass)->finalize = main_window_documents_finalize;
#line 26 "main_window_documents.vala"
	g_type_class_adjust_private_offset (klass, &MainWindowDocuments_private_offset);
#line 1871 "main_window_documents.c"
}

static void
main_window_documents_instance_init (MainWindowDocuments * self,
                                     gpointer klass)
{
#line 26 "main_window_documents.vala"
	self->priv = main_window_documents_get_instance_private (self);
#line 26 "main_window_documents.vala"
	self->ref_count = 1;
#line 1882 "main_window_documents.c"
}

static void
main_window_documents_finalize (MainWindowDocuments * obj)
{
	MainWindowDocuments * self;
#line 26 "main_window_documents.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments);
#line 26 "main_window_documents.vala"
	g_signal_handlers_destroy (self);
#line 49 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 50 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 52 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_static_action_group);
#line 55 "main_window_documents.vala"
	_g_object_unref0 (self->priv->_list_action_group);
#line 1901 "main_window_documents.c"
}

static GType
main_window_documents_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_main_window_documents_init, value_main_window_documents_free_value, value_main_window_documents_copy_value, value_main_window_documents_peek_pointer, "p", value_main_window_documents_collect_value, "p", value_main_window_documents_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MainWindowDocumentsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_documents_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindowDocuments), 0, (GInstanceInitFunc) main_window_documents_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType main_window_documents_type_id;
	main_window_documents_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MainWindowDocuments", &g_define_type_info, &g_define_type_fundamental_info, 0);
	MainWindowDocuments_private_offset = g_type_add_instance_private (main_window_documents_type_id, sizeof (MainWindowDocumentsPrivate));
	return main_window_documents_type_id;
}

GType
main_window_documents_get_type (void)
{
	static volatile gsize main_window_documents_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_documents_type_id__volatile)) {
		GType main_window_documents_type_id;
		main_window_documents_type_id = main_window_documents_get_type_once ();
		g_once_init_leave (&main_window_documents_type_id__volatile, main_window_documents_type_id);
	}
	return main_window_documents_type_id__volatile;
}

gpointer
main_window_documents_ref (gpointer instance)
{
	MainWindowDocuments * self;
	self = instance;
#line 26 "main_window_documents.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "main_window_documents.vala"
	return instance;
#line 1937 "main_window_documents.c"
}

void
main_window_documents_unref (gpointer instance)
{
	MainWindowDocuments * self;
	self = instance;
#line 26 "main_window_documents.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "main_window_documents.vala"
		MAIN_WINDOW_DOCUMENTS_GET_CLASS (self)->finalize (self);
#line 26 "main_window_documents.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1951 "main_window_documents.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1962 "main_window_documents.c"
		gint i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1970 "main_window_documents.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 1985 "main_window_documents.c"
}

