/* projects.c generated by valac 0.48.6, the Vala compiler
 * generated from projects.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <latexila.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gobject/gvaluecollector.h>

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
typedef struct _ProjectsPrivate ProjectsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _ParamSpecProjects ParamSpecProjects;

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Projects {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ProjectsPrivate * priv;
};

struct _ProjectsClass {
	GTypeClass parent_class;
	void (*finalize) (Projects *self);
};

struct _ProjectsPrivate {
	GeeLinkedList* projects;
	gboolean modified;
};

struct _ParamSpecProjects {
	GParamSpec parent_instance;
};

static gint Projects_private_offset;
static gpointer projects_parent_class = NULL;
static Projects* projects_instance;
static Projects* projects_instance = NULL;

GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
static Projects* projects_new (void);
static Projects* projects_construct (GType object_type);
static GFile* projects_get_xml_file (Projects* self);
gchar* utils_load_file (GFile* file);
static void projects_parser_start (Projects* self,
                            GMarkupParseContext* context,
                            const gchar* name,
                            gchar** attr_names,
                            gint attr_names_length1,
                            gchar** attr_values,
                            gint attr_values_length1,
                            GError** error);
static void _projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                               const gchar* element_name,
                                                               gchar** attribute_names,
                                                               gchar** attribute_values,
                                                               gpointer self,
                                                               GError** error);
static void projects_update_all_documents (Projects* self);
static void projects_update_all_menus (Projects* self);
Projects* projects_get_default (void);
Project* projects_get (Projects* self,
                       gint id);
GeeIterator* projects_iterator (Projects* self);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
void main_window_update_config_project_sensitivity (MainWindow* self);
gboolean projects_add (Projects* self,
                       Project* new_project,
                       GFile* * conflict_file);
static gboolean projects_conflict (Projects* self,
                            GFile* dir1,
                            GFile* dir2);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GeeList* glatex_app_get_documents (GlatexApp* self);
gint document_get_project_id (Document* self);
GFile* document_get_location (Document* self);
void document_set_project_id (Document* self,
                              gint value);
gboolean projects_change_main_file (Projects* self,
                                    gint num,
                                    GFile* new_main_file);
void projects_delete (Projects* self,
                      gint num);
void projects_clear_all (Projects* self);
void projects_save (Projects* self);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
static void projects_finalize (Projects * obj);
static GType projects_get_type_once (void);
static gint _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
#line 22 "projects.vala"
	return self ? g_object_ref (self) : NULL;
#line 199 "projects.c"
}

void
project_copy (const Project* self,
              Project* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 22 "projects.vala"
	_tmp0_ = (*self).directory;
#line 22 "projects.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 22 "projects.vala"
	_g_object_unref0 ((*dest).directory);
#line 22 "projects.vala"
	(*dest).directory = _tmp1_;
#line 22 "projects.vala"
	_tmp2_ = (*self).main_file;
#line 22 "projects.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 22 "projects.vala"
	_g_object_unref0 ((*dest).main_file);
#line 22 "projects.vala"
	(*dest).main_file = _tmp3_;
#line 226 "projects.c"
}

void
project_destroy (Project* self)
{
#line 24 "projects.vala"
	_g_object_unref0 ((*self).directory);
#line 25 "projects.vala"
	_g_object_unref0 ((*self).main_file);
#line 236 "projects.c"
}

Project*
project_dup (const Project* self)
{
	Project* dup;
#line 22 "projects.vala"
	dup = g_new0 (Project, 1);
#line 22 "projects.vala"
	project_copy (self, dup);
#line 22 "projects.vala"
	return dup;
#line 249 "projects.c"
}

void
project_free (Project* self)
{
#line 22 "projects.vala"
	project_destroy (self);
#line 22 "projects.vala"
	g_free (self);
#line 259 "projects.c"
}

static GType
project_get_type_once (void)
{
	GType project_type_id;
	project_type_id = g_boxed_type_register_static ("Project", (GBoxedCopyFunc) project_dup, (GBoxedFreeFunc) project_free);
	return project_type_id;
}

GType
project_get_type (void)
{
	static volatile gsize project_type_id__volatile = 0;
	if (g_once_init_enter (&project_type_id__volatile)) {
		GType project_type_id;
		project_type_id = project_get_type_once ();
		g_once_init_leave (&project_type_id__volatile, project_type_id);
	}
	return project_type_id__volatile;
}

static inline gpointer
projects_get_instance_private (Projects* self)
{
	return G_STRUCT_MEMBER_P (self, Projects_private_offset);
}

static void
_projects_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                          const gchar* element_name,
                                                          gchar** attribute_names,
                                                          gchar** attribute_values,
                                                          gpointer self,
                                                          GError** error)
{
#line 50 "projects.vala"
	projects_parser_start ((Projects*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
#line 298 "projects.c"
}

static Projects*
projects_construct (GType object_type)
{
	Projects* self = NULL;
	GeeLinkedList* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* contents = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
#line 35 "projects.vala"
	self = (Projects*) g_type_create_instance (object_type);
#line 37 "projects.vala"
	_tmp0_ = gee_linked_list_new (TYPE_PROJECT, (GBoxedCopyFunc) project_dup, (GDestroyNotify) project_free, NULL, NULL, NULL);
#line 37 "projects.vala"
	_g_object_unref0 (self->priv->projects);
#line 37 "projects.vala"
	self->priv->projects = _tmp0_;
#line 40 "projects.vala"
	_tmp1_ = projects_get_xml_file (self);
#line 40 "projects.vala"
	file = _tmp1_;
#line 41 "projects.vala"
	_tmp2_ = file;
#line 41 "projects.vala"
	if (!g_file_query_exists (_tmp2_, NULL)) {
#line 42 "projects.vala"
		_g_object_unref0 (file);
#line 42 "projects.vala"
		return self;
#line 334 "projects.c"
	}
#line 44 "projects.vala"
	_tmp3_ = file;
#line 44 "projects.vala"
	_tmp4_ = utils_load_file (_tmp3_);
#line 44 "projects.vala"
	contents = _tmp4_;
#line 45 "projects.vala"
	_tmp5_ = contents;
#line 45 "projects.vala"
	if (_tmp5_ == NULL) {
#line 46 "projects.vala"
		_g_free0 (contents);
#line 46 "projects.vala"
		_g_object_unref0 (file);
#line 46 "projects.vala"
		return self;
#line 352 "projects.c"
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp6_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp7_;
		GMarkupParseContext* _tmp8_;
		GMarkupParseContext* _tmp9_;
		const gchar* _tmp10_;
#line 50 "projects.vala"
		_tmp6_.start_element = _projects_parser_start_gmarkup_parser_start_element_func;
#line 50 "projects.vala"
		_tmp6_.end_element = NULL;
#line 50 "projects.vala"
		_tmp6_.text = NULL;
#line 50 "projects.vala"
		_tmp6_.passthrough = NULL;
#line 50 "projects.vala"
		_tmp6_.error = NULL;
#line 50 "projects.vala"
		parser = _tmp6_;
#line 51 "projects.vala"
		_tmp7_ = parser;
#line 51 "projects.vala"
		_tmp8_ = g_markup_parse_context_new (&_tmp7_, 0, self, NULL);
#line 51 "projects.vala"
		context = _tmp8_;
#line 52 "projects.vala"
		_tmp9_ = context;
#line 52 "projects.vala"
		_tmp10_ = contents;
#line 52 "projects.vala"
		g_markup_parse_context_parse (_tmp9_, _tmp10_, (gssize) -1, &_inner_error0_);
#line 52 "projects.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 52 "projects.vala"
			_g_markup_parse_context_unref0 (context);
#line 390 "projects.c"
			goto __catch0_g_error;
		}
#line 54 "projects.vala"
		projects_update_all_documents (self);
#line 55 "projects.vala"
		projects_update_all_menus (self);
#line 48 "projects.vala"
		_g_markup_parse_context_unref0 (context);
#line 399 "projects.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 48 "projects.vala"
		e = _inner_error0_;
#line 48 "projects.vala"
		_inner_error0_ = NULL;
#line 59 "projects.vala"
		_tmp11_ = e;
#line 59 "projects.vala"
		_tmp12_ = _tmp11_->message;
#line 59 "projects.vala"
		g_warning ("projects.vala:59: Impossible to load the projects: %s", _tmp12_);
#line 48 "projects.vala"
		_g_error_free0 (e);
#line 419 "projects.c"
	}
	__finally0:
#line 48 "projects.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 48 "projects.vala"
		_g_free0 (contents);
#line 48 "projects.vala"
		_g_object_unref0 (file);
#line 48 "projects.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 48 "projects.vala"
		g_clear_error (&_inner_error0_);
#line 48 "projects.vala"
		return NULL;
#line 434 "projects.c"
	}
#line 35 "projects.vala"
	_g_free0 (contents);
#line 35 "projects.vala"
	_g_object_unref0 (file);
#line 35 "projects.vala"
	return self;
#line 442 "projects.c"
}

static Projects*
projects_new (void)
{
#line 35 "projects.vala"
	return projects_construct (TYPE_PROJECTS);
#line 450 "projects.c"
}

static gpointer
_projects_ref0 (gpointer self)
{
#line 67 "projects.vala"
	return self ? projects_ref (self) : NULL;
#line 458 "projects.c"
}

Projects*
projects_get_default (void)
{
	Projects* _tmp0_;
	Projects* _tmp2_;
	Projects* _tmp3_;
	Projects* result = NULL;
#line 65 "projects.vala"
	_tmp0_ = projects_instance;
#line 65 "projects.vala"
	if (_tmp0_ == NULL) {
#line 472 "projects.c"
		Projects* _tmp1_;
#line 66 "projects.vala"
		_tmp1_ = projects_new ();
#line 66 "projects.vala"
		_projects_unref0 (projects_instance);
#line 66 "projects.vala"
		projects_instance = _tmp1_;
#line 480 "projects.c"
	}
#line 67 "projects.vala"
	_tmp2_ = projects_instance;
#line 67 "projects.vala"
	_tmp3_ = _projects_ref0 (_tmp2_);
#line 67 "projects.vala"
	result = _tmp3_;
#line 67 "projects.vala"
	return result;
#line 490 "projects.c"
}

Project*
projects_get (Projects* self,
              gint id)
{
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* result = NULL;
#line 70 "projects.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "projects.vala"
	if (id >= 0) {
#line 505 "projects.c"
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 72 "projects.vala"
		_tmp1_ = self->priv->projects;
#line 72 "projects.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 72 "projects.vala"
		_tmp3_ = _tmp2_;
#line 72 "projects.vala"
		_tmp0_ = id < _tmp3_;
#line 517 "projects.c"
	} else {
#line 72 "projects.vala"
		_tmp0_ = FALSE;
#line 521 "projects.c"
	}
#line 72 "projects.vala"
	g_return_val_if_fail (_tmp0_, NULL);
#line 73 "projects.vala"
	_tmp4_ = self->priv->projects;
#line 73 "projects.vala"
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, id);
#line 73 "projects.vala"
	result = (Project*) _tmp5_;
#line 73 "projects.vala"
	return result;
#line 533 "projects.c"
}

GeeIterator*
projects_iterator (Projects* self)
{
	GeeLinkedList* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result = NULL;
#line 76 "projects.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 78 "projects.vala"
	_tmp0_ = self->priv->projects;
#line 78 "projects.vala"
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
#line 78 "projects.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERATOR, GeeIterator);
#line 78 "projects.vala"
	return result;
#line 552 "projects.c"
}

static void
projects_update_all_menus (Projects* self)
{
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
#line 81 "projects.vala"
	g_return_if_fail (self != NULL);
#line 83 "projects.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 83 "projects.vala"
	_tmp1_ = _tmp0_;
#line 83 "projects.vala"
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
#line 83 "projects.vala"
	_tmp3_ = _tmp2_;
#line 83 "projects.vala"
	_g_object_unref0 (_tmp1_);
#line 574 "projects.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 83 "projects.vala"
		window_collection = _tmp3_;
#line 83 "projects.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 582 "projects.c"
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
#line 83 "projects.vala"
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 83 "projects.vala"
			window = _tmp4_;
#line 589 "projects.c"
			{
				GtkWindow* _tmp5_;
#line 85 "projects.vala"
				_tmp5_ = window;
#line 85 "projects.vala"
				if (IS_MAIN_WINDOW (_tmp5_)) {
#line 596 "projects.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp6_;
					MainWindow* _tmp7_;
					MainWindow* _tmp8_;
#line 87 "projects.vala"
					_tmp6_ = window;
#line 87 "projects.vala"
					_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
#line 87 "projects.vala"
					main_window = _tmp7_;
#line 88 "projects.vala"
					_tmp8_ = main_window;
#line 88 "projects.vala"
					main_window_update_config_project_sensitivity (_tmp8_);
#line 85 "projects.vala"
					_g_object_unref0 (main_window);
#line 613 "projects.c"
				}
#line 83 "projects.vala"
				_g_object_unref0 (window);
#line 617 "projects.c"
			}
		}
	}
}

gboolean
projects_add (Projects* self,
              Project* new_project,
              GFile* * conflict_file)
{
	GFile* _vala_conflict_file = NULL;
	GeeLinkedList* _tmp18_;
	Project _tmp19_;
	GeeList* docs = NULL;
	GlatexApp* _tmp20_;
	GlatexApp* _tmp21_;
	GeeList* _tmp22_;
	GeeList* _tmp23_;
	gboolean result = FALSE;
#line 94 "projects.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 94 "projects.vala"
	g_return_val_if_fail (new_project != NULL, FALSE);
#line 96 "projects.vala"
	_g_object_unref0 (_vala_conflict_file);
#line 96 "projects.vala"
	_vala_conflict_file = NULL;
#line 645 "projects.c"
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _project_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _project_index = 0;
#line 98 "projects.vala"
		_tmp0_ = self->priv->projects;
#line 98 "projects.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 98 "projects.vala"
		_project_list = _tmp1_;
#line 98 "projects.vala"
		_tmp2_ = _project_list;
#line 98 "projects.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 98 "projects.vala"
		_tmp4_ = _tmp3_;
#line 98 "projects.vala"
		_project_size = _tmp4_;
#line 98 "projects.vala"
		_project_index = -1;
#line 98 "projects.vala"
		while (TRUE) {
#line 673 "projects.c"
			Project project = {0};
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_;
			Project _tmp9_ = {0};
			Project _tmp10_;
			Project _tmp11_;
			GFile* _tmp12_;
			Project _tmp13_;
			GFile* _tmp14_;
#line 98 "projects.vala"
			_project_index = _project_index + 1;
#line 98 "projects.vala"
			if (!(_project_index < _project_size)) {
#line 98 "projects.vala"
				break;
#line 691 "projects.c"
			}
#line 98 "projects.vala"
			_tmp5_ = _project_list;
#line 98 "projects.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _project_index);
#line 98 "projects.vala"
			_tmp7_ = (Project*) _tmp6_;
#line 98 "projects.vala"
			_tmp8_ = *_tmp7_;
#line 98 "projects.vala"
			project_copy (&_tmp8_, &_tmp9_);
#line 98 "projects.vala"
			_tmp10_ = _tmp9_;
#line 98 "projects.vala"
			_project_free0 (_tmp7_);
#line 98 "projects.vala"
			project = _tmp10_;
#line 100 "projects.vala"
			_tmp11_ = project;
#line 100 "projects.vala"
			_tmp12_ = _tmp11_.directory;
#line 100 "projects.vala"
			_tmp13_ = *new_project;
#line 100 "projects.vala"
			_tmp14_ = _tmp13_.directory;
#line 100 "projects.vala"
			if (projects_conflict (self, _tmp12_, _tmp14_)) {
#line 719 "projects.c"
				Project _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
#line 102 "projects.vala"
				_tmp15_ = project;
#line 102 "projects.vala"
				_tmp16_ = _tmp15_.directory;
#line 102 "projects.vala"
				_tmp17_ = _g_object_ref0 (_tmp16_);
#line 102 "projects.vala"
				_g_object_unref0 (_vala_conflict_file);
#line 102 "projects.vala"
				_vala_conflict_file = _tmp17_;
#line 103 "projects.vala"
				result = FALSE;
#line 103 "projects.vala"
				project_destroy (&project);
#line 103 "projects.vala"
				_g_object_unref0 (_project_list);
#line 103 "projects.vala"
				if (conflict_file) {
#line 103 "projects.vala"
					*conflict_file = _vala_conflict_file;
#line 743 "projects.c"
				} else {
#line 103 "projects.vala"
					_g_object_unref0 (_vala_conflict_file);
#line 747 "projects.c"
				}
#line 103 "projects.vala"
				return result;
#line 751 "projects.c"
			}
#line 98 "projects.vala"
			project_destroy (&project);
#line 755 "projects.c"
		}
#line 98 "projects.vala"
		_g_object_unref0 (_project_list);
#line 759 "projects.c"
	}
#line 107 "projects.vala"
	_tmp18_ = self->priv->projects;
#line 107 "projects.vala"
	_tmp19_ = *new_project;
#line 107 "projects.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, &_tmp19_);
#line 108 "projects.vala"
	self->priv->modified = TRUE;
#line 111 "projects.vala"
	_tmp20_ = glatex_app_get_instance ();
#line 111 "projects.vala"
	_tmp21_ = _tmp20_;
#line 111 "projects.vala"
	_tmp22_ = glatex_app_get_documents (_tmp21_);
#line 111 "projects.vala"
	_tmp23_ = _tmp22_;
#line 111 "projects.vala"
	_g_object_unref0 (_tmp21_);
#line 111 "projects.vala"
	docs = _tmp23_;
#line 781 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp24_;
		GeeList* _tmp25_;
		gint _doc_size = 0;
		GeeList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _doc_index = 0;
#line 112 "projects.vala"
		_tmp24_ = docs;
#line 112 "projects.vala"
		_tmp25_ = _g_object_ref0 (_tmp24_);
#line 112 "projects.vala"
		_doc_list = _tmp25_;
#line 112 "projects.vala"
		_tmp26_ = _doc_list;
#line 112 "projects.vala"
		_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
#line 112 "projects.vala"
		_tmp28_ = _tmp27_;
#line 112 "projects.vala"
		_doc_size = _tmp28_;
#line 112 "projects.vala"
		_doc_index = -1;
#line 112 "projects.vala"
		while (TRUE) {
#line 809 "projects.c"
			Document* doc = NULL;
			GeeList* _tmp29_;
			gpointer _tmp30_;
			gboolean _tmp31_ = FALSE;
			Document* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			Document* _tmp38_;
			GFile* _tmp39_;
			GFile* _tmp40_;
			Project _tmp41_;
			GFile* _tmp42_;
#line 112 "projects.vala"
			_doc_index = _doc_index + 1;
#line 112 "projects.vala"
			if (!(_doc_index < _doc_size)) {
#line 112 "projects.vala"
				break;
#line 828 "projects.c"
			}
#line 112 "projects.vala"
			_tmp29_ = _doc_list;
#line 112 "projects.vala"
			_tmp30_ = gee_list_get (_tmp29_, _doc_index);
#line 112 "projects.vala"
			doc = (Document*) _tmp30_;
#line 114 "projects.vala"
			_tmp32_ = doc;
#line 114 "projects.vala"
			_tmp33_ = document_get_project_id (_tmp32_);
#line 114 "projects.vala"
			_tmp34_ = _tmp33_;
#line 114 "projects.vala"
			if (_tmp34_ != -1) {
#line 114 "projects.vala"
				_tmp31_ = TRUE;
#line 846 "projects.c"
			} else {
				Document* _tmp35_;
				GFile* _tmp36_;
				GFile* _tmp37_;
#line 114 "projects.vala"
				_tmp35_ = doc;
#line 114 "projects.vala"
				_tmp36_ = document_get_location (_tmp35_);
#line 114 "projects.vala"
				_tmp37_ = _tmp36_;
#line 114 "projects.vala"
				_tmp31_ = _tmp37_ == NULL;
#line 859 "projects.c"
			}
#line 114 "projects.vala"
			if (_tmp31_) {
#line 115 "projects.vala"
				_g_object_unref0 (doc);
#line 115 "projects.vala"
				continue;
#line 867 "projects.c"
			}
#line 117 "projects.vala"
			_tmp38_ = doc;
#line 117 "projects.vala"
			_tmp39_ = document_get_location (_tmp38_);
#line 117 "projects.vala"
			_tmp40_ = _tmp39_;
#line 117 "projects.vala"
			_tmp41_ = *new_project;
#line 117 "projects.vala"
			_tmp42_ = _tmp41_.directory;
#line 117 "projects.vala"
			if (g_file_has_prefix (_tmp40_, _tmp42_)) {
#line 881 "projects.c"
				Document* _tmp43_;
				GeeLinkedList* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
#line 118 "projects.vala"
				_tmp43_ = doc;
#line 118 "projects.vala"
				_tmp44_ = self->priv->projects;
#line 118 "projects.vala"
				_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
#line 118 "projects.vala"
				_tmp46_ = _tmp45_;
#line 118 "projects.vala"
				document_set_project_id (_tmp43_, _tmp46_ - 1);
#line 896 "projects.c"
			}
#line 112 "projects.vala"
			_g_object_unref0 (doc);
#line 900 "projects.c"
		}
#line 112 "projects.vala"
		_g_object_unref0 (_doc_list);
#line 904 "projects.c"
	}
#line 121 "projects.vala"
	projects_update_all_menus (self);
#line 123 "projects.vala"
	result = TRUE;
#line 123 "projects.vala"
	_g_object_unref0 (docs);
#line 123 "projects.vala"
	if (conflict_file) {
#line 123 "projects.vala"
		*conflict_file = _vala_conflict_file;
#line 916 "projects.c"
	} else {
#line 123 "projects.vala"
		_g_object_unref0 (_vala_conflict_file);
#line 920 "projects.c"
	}
#line 123 "projects.vala"
	return result;
#line 924 "projects.c"
}

gboolean
projects_change_main_file (Projects* self,
                           gint num,
                           GFile* new_main_file)
{
	gboolean _tmp0_ = FALSE;
	Project project = {0};
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	Project _tmp7_;
	Project _tmp8_ = {0};
	Project _tmp9_;
	Project _tmp10_;
	GFile* _tmp11_;
	Project _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GeeLinkedList* _tmp15_;
	Project _tmp16_;
	GeeList* docs = NULL;
	GlatexApp* _tmp17_;
	GlatexApp* _tmp18_;
	GeeList* _tmp19_;
	GeeList* _tmp20_;
	gboolean result = FALSE;
#line 127 "projects.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 127 "projects.vala"
	g_return_val_if_fail (new_main_file != NULL, FALSE);
#line 129 "projects.vala"
	if (num >= 0) {
#line 959 "projects.c"
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 129 "projects.vala"
		_tmp1_ = self->priv->projects;
#line 129 "projects.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 129 "projects.vala"
		_tmp3_ = _tmp2_;
#line 129 "projects.vala"
		_tmp0_ = num < _tmp3_;
#line 971 "projects.c"
	} else {
#line 129 "projects.vala"
		_tmp0_ = FALSE;
#line 975 "projects.c"
	}
#line 129 "projects.vala"
	g_return_val_if_fail (_tmp0_, FALSE);
#line 130 "projects.vala"
	_tmp4_ = self->priv->projects;
#line 130 "projects.vala"
	_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _tmp4_, num);
#line 130 "projects.vala"
	_tmp6_ = (Project*) _tmp5_;
#line 130 "projects.vala"
	_tmp7_ = *_tmp6_;
#line 130 "projects.vala"
	project_copy (&_tmp7_, &_tmp8_);
#line 130 "projects.vala"
	_tmp9_ = _tmp8_;
#line 130 "projects.vala"
	_project_free0 (_tmp6_);
#line 130 "projects.vala"
	project = _tmp9_;
#line 132 "projects.vala"
	_tmp10_ = project;
#line 132 "projects.vala"
	_tmp11_ = _tmp10_.main_file;
#line 132 "projects.vala"
	if (g_file_equal (new_main_file, _tmp11_)) {
#line 133 "projects.vala"
		result = FALSE;
#line 133 "projects.vala"
		project_destroy (&project);
#line 133 "projects.vala"
		return result;
#line 1007 "projects.c"
	}
#line 135 "projects.vala"
	_tmp12_ = project;
#line 135 "projects.vala"
	_tmp13_ = _tmp12_.directory;
#line 135 "projects.vala"
	g_return_val_if_fail (g_file_has_prefix (new_main_file, _tmp13_), FALSE);
#line 137 "projects.vala"
	_tmp14_ = _g_object_ref0 (new_main_file);
#line 137 "projects.vala"
	_g_object_unref0 (project.main_file);
#line 137 "projects.vala"
	project.main_file = _tmp14_;
#line 138 "projects.vala"
	_tmp15_ = self->priv->projects;
#line 138 "projects.vala"
	_tmp16_ = project;
#line 138 "projects.vala"
	gee_abstract_list_set ((GeeAbstractList*) _tmp15_, num, &_tmp16_);
#line 139 "projects.vala"
	self->priv->modified = TRUE;
#line 142 "projects.vala"
	_tmp17_ = glatex_app_get_instance ();
#line 142 "projects.vala"
	_tmp18_ = _tmp17_;
#line 142 "projects.vala"
	_tmp19_ = glatex_app_get_documents (_tmp18_);
#line 142 "projects.vala"
	_tmp20_ = _tmp19_;
#line 142 "projects.vala"
	_g_object_unref0 (_tmp18_);
#line 142 "projects.vala"
	docs = _tmp20_;
#line 1041 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp21_;
		GeeList* _tmp22_;
		gint _doc_size = 0;
		GeeList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _doc_index = 0;
#line 143 "projects.vala"
		_tmp21_ = docs;
#line 143 "projects.vala"
		_tmp22_ = _g_object_ref0 (_tmp21_);
#line 143 "projects.vala"
		_doc_list = _tmp22_;
#line 143 "projects.vala"
		_tmp23_ = _doc_list;
#line 143 "projects.vala"
		_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
#line 143 "projects.vala"
		_tmp25_ = _tmp24_;
#line 143 "projects.vala"
		_doc_size = _tmp25_;
#line 143 "projects.vala"
		_doc_index = -1;
#line 143 "projects.vala"
		while (TRUE) {
#line 1069 "projects.c"
			Document* doc = NULL;
			GeeList* _tmp26_;
			gpointer _tmp27_;
			Document* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
#line 143 "projects.vala"
			_doc_index = _doc_index + 1;
#line 143 "projects.vala"
			if (!(_doc_index < _doc_size)) {
#line 143 "projects.vala"
				break;
#line 1082 "projects.c"
			}
#line 143 "projects.vala"
			_tmp26_ = _doc_list;
#line 143 "projects.vala"
			_tmp27_ = gee_list_get (_tmp26_, _doc_index);
#line 143 "projects.vala"
			doc = (Document*) _tmp27_;
#line 145 "projects.vala"
			_tmp28_ = doc;
#line 145 "projects.vala"
			_tmp29_ = document_get_project_id (_tmp28_);
#line 145 "projects.vala"
			_tmp30_ = _tmp29_;
#line 145 "projects.vala"
			if (_tmp30_ == num) {
#line 1098 "projects.c"
				Document* _tmp31_;
#line 146 "projects.vala"
				_tmp31_ = doc;
#line 146 "projects.vala"
				document_set_project_id (_tmp31_, num);
#line 1104 "projects.c"
			}
#line 143 "projects.vala"
			_g_object_unref0 (doc);
#line 1108 "projects.c"
		}
#line 143 "projects.vala"
		_g_object_unref0 (_doc_list);
#line 1112 "projects.c"
	}
#line 149 "projects.vala"
	result = TRUE;
#line 149 "projects.vala"
	_g_object_unref0 (docs);
#line 149 "projects.vala"
	project_destroy (&project);
#line 149 "projects.vala"
	return result;
#line 1122 "projects.c"
}

void
projects_delete (Projects* self,
                 gint num)
{
	gboolean _tmp0_ = FALSE;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	Project* _tmp6_;
	GeeList* docs = NULL;
	GlatexApp* _tmp7_;
	GlatexApp* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
#line 152 "projects.vala"
	g_return_if_fail (self != NULL);
#line 154 "projects.vala"
	if (num >= 0) {
#line 1142 "projects.c"
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 154 "projects.vala"
		_tmp1_ = self->priv->projects;
#line 154 "projects.vala"
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 154 "projects.vala"
		_tmp3_ = _tmp2_;
#line 154 "projects.vala"
		_tmp0_ = num < _tmp3_;
#line 1154 "projects.c"
	} else {
#line 154 "projects.vala"
		_tmp0_ = FALSE;
#line 1158 "projects.c"
	}
#line 154 "projects.vala"
	g_return_if_fail (_tmp0_);
#line 155 "projects.vala"
	_tmp4_ = self->priv->projects;
#line 155 "projects.vala"
	_tmp5_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp4_, num);
#line 155 "projects.vala"
	_tmp6_ = (Project*) _tmp5_;
#line 155 "projects.vala"
	_project_free0 (_tmp6_);
#line 156 "projects.vala"
	self->priv->modified = TRUE;
#line 159 "projects.vala"
	_tmp7_ = glatex_app_get_instance ();
#line 159 "projects.vala"
	_tmp8_ = _tmp7_;
#line 159 "projects.vala"
	_tmp9_ = glatex_app_get_documents (_tmp8_);
#line 159 "projects.vala"
	_tmp10_ = _tmp9_;
#line 159 "projects.vala"
	_g_object_unref0 (_tmp8_);
#line 159 "projects.vala"
	docs = _tmp10_;
#line 1184 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		gint _doc_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _doc_index = 0;
#line 160 "projects.vala"
		_tmp11_ = docs;
#line 160 "projects.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 160 "projects.vala"
		_doc_list = _tmp12_;
#line 160 "projects.vala"
		_tmp13_ = _doc_list;
#line 160 "projects.vala"
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
#line 160 "projects.vala"
		_tmp15_ = _tmp14_;
#line 160 "projects.vala"
		_doc_size = _tmp15_;
#line 160 "projects.vala"
		_doc_index = -1;
#line 160 "projects.vala"
		while (TRUE) {
#line 1212 "projects.c"
			Document* doc = NULL;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			Document* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
#line 160 "projects.vala"
			_doc_index = _doc_index + 1;
#line 160 "projects.vala"
			if (!(_doc_index < _doc_size)) {
#line 160 "projects.vala"
				break;
#line 1225 "projects.c"
			}
#line 160 "projects.vala"
			_tmp16_ = _doc_list;
#line 160 "projects.vala"
			_tmp17_ = gee_list_get (_tmp16_, _doc_index);
#line 160 "projects.vala"
			doc = (Document*) _tmp17_;
#line 162 "projects.vala"
			_tmp18_ = doc;
#line 162 "projects.vala"
			_tmp19_ = document_get_project_id (_tmp18_);
#line 162 "projects.vala"
			_tmp20_ = _tmp19_;
#line 162 "projects.vala"
			if (_tmp20_ == num) {
#line 1241 "projects.c"
				Document* _tmp21_;
#line 163 "projects.vala"
				_tmp21_ = doc;
#line 163 "projects.vala"
				document_set_project_id (_tmp21_, -1);
#line 1247 "projects.c"
			} else {
				Document* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
#line 164 "projects.vala"
				_tmp22_ = doc;
#line 164 "projects.vala"
				_tmp23_ = document_get_project_id (_tmp22_);
#line 164 "projects.vala"
				_tmp24_ = _tmp23_;
#line 164 "projects.vala"
				if (_tmp24_ > num) {
#line 1260 "projects.c"
					Document* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
#line 165 "projects.vala"
					_tmp25_ = doc;
#line 165 "projects.vala"
					_tmp26_ = document_get_project_id (_tmp25_);
#line 165 "projects.vala"
					_tmp27_ = _tmp26_;
#line 165 "projects.vala"
					document_set_project_id (_tmp25_, _tmp27_ - 1);
#line 1272 "projects.c"
				}
			}
#line 160 "projects.vala"
			_g_object_unref0 (doc);
#line 1277 "projects.c"
		}
#line 160 "projects.vala"
		_g_object_unref0 (_doc_list);
#line 1281 "projects.c"
	}
#line 168 "projects.vala"
	projects_update_all_menus (self);
#line 152 "projects.vala"
	_g_object_unref0 (docs);
#line 1287 "projects.c"
}

void
projects_clear_all (Projects* self)
{
	GeeLinkedList* _tmp0_;
#line 171 "projects.vala"
	g_return_if_fail (self != NULL);
#line 173 "projects.vala"
	_tmp0_ = self->priv->projects;
#line 173 "projects.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 174 "projects.vala"
	self->priv->modified = TRUE;
#line 175 "projects.vala"
	projects_update_all_documents (self);
#line 176 "projects.vala"
	projects_update_all_menus (self);
#line 1306 "projects.c"
}

static void
projects_update_all_documents (Projects* self)
{
	GeeList* docs = NULL;
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
#line 179 "projects.vala"
	g_return_if_fail (self != NULL);
#line 181 "projects.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 181 "projects.vala"
	_tmp1_ = _tmp0_;
#line 181 "projects.vala"
	_tmp2_ = glatex_app_get_documents (_tmp1_);
#line 181 "projects.vala"
	_tmp3_ = _tmp2_;
#line 181 "projects.vala"
	_g_object_unref0 (_tmp1_);
#line 181 "projects.vala"
	docs = _tmp3_;
#line 1331 "projects.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp4_;
		GeeList* _tmp5_;
		gint _doc_size = 0;
		GeeList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _doc_index = 0;
#line 182 "projects.vala"
		_tmp4_ = docs;
#line 182 "projects.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 182 "projects.vala"
		_doc_list = _tmp5_;
#line 182 "projects.vala"
		_tmp6_ = _doc_list;
#line 182 "projects.vala"
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 182 "projects.vala"
		_tmp8_ = _tmp7_;
#line 182 "projects.vala"
		_doc_size = _tmp8_;
#line 182 "projects.vala"
		_doc_index = -1;
#line 182 "projects.vala"
		while (TRUE) {
#line 1359 "projects.c"
			Document* doc = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			Document* _tmp11_;
			Document* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
#line 182 "projects.vala"
			_doc_index = _doc_index + 1;
#line 182 "projects.vala"
			if (!(_doc_index < _doc_size)) {
#line 182 "projects.vala"
				break;
#line 1373 "projects.c"
			}
#line 182 "projects.vala"
			_tmp9_ = _doc_list;
#line 182 "projects.vala"
			_tmp10_ = gee_list_get (_tmp9_, _doc_index);
#line 182 "projects.vala"
			doc = (Document*) _tmp10_;
#line 184 "projects.vala"
			_tmp11_ = doc;
#line 184 "projects.vala"
			document_set_project_id (_tmp11_, -1);
#line 186 "projects.vala"
			_tmp12_ = doc;
#line 186 "projects.vala"
			_tmp13_ = document_get_location (_tmp12_);
#line 186 "projects.vala"
			_tmp14_ = _tmp13_;
#line 186 "projects.vala"
			if (_tmp14_ == NULL) {
#line 187 "projects.vala"
				_g_object_unref0 (doc);
#line 187 "projects.vala"
				continue;
#line 1397 "projects.c"
			}
			{
				gint i = 0;
#line 189 "projects.vala"
				i = 0;
#line 1403 "projects.c"
				{
					gboolean _tmp15_ = FALSE;
#line 189 "projects.vala"
					_tmp15_ = TRUE;
#line 189 "projects.vala"
					while (TRUE) {
#line 1410 "projects.c"
						GeeLinkedList* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						Document* _tmp20_;
						GFile* _tmp21_;
						GFile* _tmp22_;
						GeeLinkedList* _tmp23_;
						gpointer _tmp24_;
						Project* _tmp25_;
						GFile* _tmp26_;
						gboolean _tmp27_;
#line 189 "projects.vala"
						if (!_tmp15_) {
#line 1424 "projects.c"
							gint _tmp16_;
#line 189 "projects.vala"
							_tmp16_ = i;
#line 189 "projects.vala"
							i = _tmp16_ + 1;
#line 1430 "projects.c"
						}
#line 189 "projects.vala"
						_tmp15_ = FALSE;
#line 189 "projects.vala"
						_tmp17_ = self->priv->projects;
#line 189 "projects.vala"
						_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
#line 189 "projects.vala"
						_tmp19_ = _tmp18_;
#line 189 "projects.vala"
						if (!(i < _tmp19_)) {
#line 189 "projects.vala"
							break;
#line 1444 "projects.c"
						}
#line 191 "projects.vala"
						_tmp20_ = doc;
#line 191 "projects.vala"
						_tmp21_ = document_get_location (_tmp20_);
#line 191 "projects.vala"
						_tmp22_ = _tmp21_;
#line 191 "projects.vala"
						_tmp23_ = self->priv->projects;
#line 191 "projects.vala"
						_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, i);
#line 191 "projects.vala"
						_tmp25_ = (Project*) _tmp24_;
#line 191 "projects.vala"
						_tmp26_ = (*_tmp25_).directory;
#line 191 "projects.vala"
						_tmp27_ = g_file_has_prefix (_tmp22_, _tmp26_);
#line 191 "projects.vala"
						_project_free0 (_tmp25_);
#line 191 "projects.vala"
						if (_tmp27_) {
#line 1466 "projects.c"
							Document* _tmp28_;
#line 193 "projects.vala"
							_tmp28_ = doc;
#line 193 "projects.vala"
							document_set_project_id (_tmp28_, i);
#line 194 "projects.vala"
							break;
#line 1474 "projects.c"
						}
					}
				}
			}
#line 182 "projects.vala"
			_g_object_unref0 (doc);
#line 1481 "projects.c"
		}
#line 182 "projects.vala"
		_g_object_unref0 (_doc_list);
#line 1485 "projects.c"
	}
#line 179 "projects.vala"
	_g_object_unref0 (docs);
#line 1489 "projects.c"
}

static void
projects_parser_start (Projects* self,
                       GMarkupParseContext* context,
                       const gchar* name,
                       gchar** attr_names,
                       gint attr_names_length1,
                       gchar** attr_values,
                       gint attr_values_length1,
                       GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 203 "projects.vala"
	static GQuark _tmp1_label0 = 0;
#line 203 "projects.vala"
	static GQuark _tmp1_label1 = 0;
#line 1508 "projects.c"
	GError* _inner_error0_ = NULL;
#line 200 "projects.vala"
	g_return_if_fail (self != NULL);
#line 200 "projects.vala"
	g_return_if_fail (context != NULL);
#line 200 "projects.vala"
	g_return_if_fail (name != NULL);
#line 203 "projects.vala"
	_tmp0_ = name;
#line 203 "projects.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 203 "projects.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("projects")))) {
#line 203 "projects.vala"
		switch (0) {
#line 1524 "projects.c"
			default:
			{
#line 206 "projects.vala"
				return;
#line 1529 "projects.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("project")))) {
#line 203 "projects.vala"
		switch (0) {
#line 1535 "projects.c"
			default:
			{
				Project project = {0};
				GeeLinkedList* _tmp20_;
				Project _tmp21_;
#line 209 "projects.vala"
				memset (&project, 0, sizeof (Project));
#line 1543 "projects.c"
				{
					gint i = 0;
#line 210 "projects.vala"
					i = 0;
#line 1548 "projects.c"
					{
						gboolean _tmp3_ = FALSE;
#line 210 "projects.vala"
						_tmp3_ = TRUE;
#line 210 "projects.vala"
						while (TRUE) {
#line 1555 "projects.c"
							const gchar* _tmp5_;
							const gchar* _tmp6_;
							GQuark _tmp8_ = 0U;
#line 212 "projects.vala"
							static GQuark _tmp7_label0 = 0;
#line 212 "projects.vala"
							static GQuark _tmp7_label1 = 0;
#line 210 "projects.vala"
							if (!_tmp3_) {
#line 1565 "projects.c"
								gint _tmp4_;
#line 210 "projects.vala"
								_tmp4_ = i;
#line 210 "projects.vala"
								i = _tmp4_ + 1;
#line 1571 "projects.c"
							}
#line 210 "projects.vala"
							_tmp3_ = FALSE;
#line 210 "projects.vala"
							if (!(i < attr_names_length1)) {
#line 210 "projects.vala"
								break;
#line 1579 "projects.c"
							}
#line 212 "projects.vala"
							_tmp5_ = attr_names[i];
#line 212 "projects.vala"
							_tmp6_ = _tmp5_;
#line 212 "projects.vala"
							_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
#line 212 "projects.vala"
							if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("directory")))) {
#line 212 "projects.vala"
								switch (0) {
#line 1591 "projects.c"
									default:
									{
										const gchar* _tmp9_;
										GFile* _tmp10_;
#line 215 "projects.vala"
										_tmp9_ = attr_values[i];
#line 215 "projects.vala"
										_tmp10_ = g_file_new_for_uri (_tmp9_);
#line 215 "projects.vala"
										_g_object_unref0 (project.directory);
#line 215 "projects.vala"
										project.directory = _tmp10_;
#line 216 "projects.vala"
										break;
#line 1606 "projects.c"
									}
								}
							} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("main_file")))) {
#line 212 "projects.vala"
								switch (0) {
#line 1612 "projects.c"
									default:
									{
										const gchar* _tmp11_;
										GFile* _tmp12_;
#line 218 "projects.vala"
										_tmp11_ = attr_values[i];
#line 218 "projects.vala"
										_tmp12_ = g_file_new_for_uri (_tmp11_);
#line 218 "projects.vala"
										_g_object_unref0 (project.main_file);
#line 218 "projects.vala"
										project.main_file = _tmp12_;
#line 219 "projects.vala"
										break;
#line 1627 "projects.c"
									}
								}
							} else {
#line 212 "projects.vala"
								switch (0) {
#line 1633 "projects.c"
									default:
									{
										const gchar* _tmp13_;
										gchar* _tmp14_;
										gchar* _tmp15_;
										gchar* _tmp16_;
										gchar* _tmp17_;
										GError* _tmp18_;
										GError* _tmp19_;
#line 221 "projects.vala"
										_tmp13_ = attr_names[i];
#line 221 "projects.vala"
										_tmp14_ = g_strconcat ("unknown attribute \"", _tmp13_, NULL);
#line 221 "projects.vala"
										_tmp15_ = _tmp14_;
#line 221 "projects.vala"
										_tmp16_ = g_strconcat (_tmp15_, "\"", NULL);
#line 221 "projects.vala"
										_tmp17_ = _tmp16_;
#line 221 "projects.vala"
										_tmp18_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp17_);
#line 221 "projects.vala"
										_tmp19_ = _tmp18_;
#line 221 "projects.vala"
										_g_free0 (_tmp17_);
#line 221 "projects.vala"
										_g_free0 (_tmp15_);
#line 221 "projects.vala"
										_inner_error0_ = _tmp19_;
#line 221 "projects.vala"
										if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 221 "projects.vala"
											g_propagate_error (error, _inner_error0_);
#line 221 "projects.vala"
											project_destroy (&project);
#line 221 "projects.vala"
											return;
#line 1671 "projects.c"
										} else {
#line 221 "projects.vala"
											project_destroy (&project);
#line 221 "projects.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 221 "projects.vala"
											g_clear_error (&_inner_error0_);
#line 221 "projects.vala"
											return;
#line 1681 "projects.c"
										}
									}
								}
							}
						}
					}
				}
#line 225 "projects.vala"
				_tmp20_ = self->priv->projects;
#line 225 "projects.vala"
				_tmp21_ = project;
#line 225 "projects.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, &_tmp21_);
#line 226 "projects.vala"
				project_destroy (&project);
#line 226 "projects.vala"
				break;
#line 1699 "projects.c"
			}
		}
	} else {
#line 203 "projects.vala"
		switch (0) {
#line 1705 "projects.c"
			default:
			{
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				GError* _tmp26_;
				GError* _tmp27_;
#line 229 "projects.vala"
				_tmp22_ = g_strconcat ("unknown element \"", name, NULL);
#line 229 "projects.vala"
				_tmp23_ = _tmp22_;
#line 229 "projects.vala"
				_tmp24_ = g_strconcat (_tmp23_, "\"", NULL);
#line 229 "projects.vala"
				_tmp25_ = _tmp24_;
#line 229 "projects.vala"
				_tmp26_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp25_);
#line 229 "projects.vala"
				_tmp27_ = _tmp26_;
#line 229 "projects.vala"
				_g_free0 (_tmp25_);
#line 229 "projects.vala"
				_g_free0 (_tmp23_);
#line 229 "projects.vala"
				_inner_error0_ = _tmp27_;
#line 229 "projects.vala"
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 229 "projects.vala"
					g_propagate_error (error, _inner_error0_);
#line 229 "projects.vala"
					return;
#line 1738 "projects.c"
				} else {
#line 229 "projects.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 229 "projects.vala"
					g_clear_error (&_inner_error0_);
#line 229 "projects.vala"
					return;
#line 1746 "projects.c"
				}
			}
		}
	}
}

static GFile*
projects_get_xml_file (Projects* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* result = NULL;
#line 234 "projects.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 236 "projects.vala"
	_tmp0_ = g_get_user_data_dir ();
#line 236 "projects.vala"
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "projects.xml", NULL, NULL);
#line 236 "projects.vala"
	path = _tmp1_;
#line 238 "projects.vala"
	_tmp2_ = g_file_new_for_path (path);
#line 238 "projects.vala"
	result = _tmp2_;
#line 238 "projects.vala"
	_g_free0 (path);
#line 238 "projects.vala"
	return result;
#line 1777 "projects.c"
}

void
projects_save (Projects* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GeeLinkedList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* content = NULL;
	gchar* _tmp5_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	GFile* _tmp31_;
	const gchar* _tmp32_;
#line 241 "projects.vala"
	g_return_if_fail (self != NULL);
#line 243 "projects.vala"
	if (!self->priv->modified) {
#line 244 "projects.vala"
		return;
#line 1800 "projects.c"
	}
#line 246 "projects.vala"
	_tmp0_ = projects_get_xml_file (self);
#line 246 "projects.vala"
	file = _tmp0_;
#line 249 "projects.vala"
	_tmp1_ = self->priv->projects;
#line 249 "projects.vala"
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
#line 249 "projects.vala"
	_tmp3_ = _tmp2_;
#line 249 "projects.vala"
	if (_tmp3_ == 0) {
#line 1814 "projects.c"
		GFile* _tmp4_;
#line 251 "projects.vala"
		_tmp4_ = file;
#line 251 "projects.vala"
		utils_delete_file (_tmp4_);
#line 252 "projects.vala"
		_g_object_unref0 (file);
#line 252 "projects.vala"
		return;
#line 1824 "projects.c"
	}
#line 255 "projects.vala"
	_tmp5_ = g_strdup ("<projects>\n");
#line 255 "projects.vala"
	content = _tmp5_;
#line 1830 "projects.c"
	{
		GeeLinkedList* _project_list = NULL;
		GeeLinkedList* _tmp6_;
		GeeLinkedList* _tmp7_;
		gint _project_size = 0;
		GeeLinkedList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _project_index = 0;
#line 256 "projects.vala"
		_tmp6_ = self->priv->projects;
#line 256 "projects.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 256 "projects.vala"
		_project_list = _tmp7_;
#line 256 "projects.vala"
		_tmp8_ = _project_list;
#line 256 "projects.vala"
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
#line 256 "projects.vala"
		_tmp10_ = _tmp9_;
#line 256 "projects.vala"
		_project_size = _tmp10_;
#line 256 "projects.vala"
		_project_index = -1;
#line 256 "projects.vala"
		while (TRUE) {
#line 1858 "projects.c"
			Project project = {0};
			GeeLinkedList* _tmp11_;
			gpointer _tmp12_;
			Project* _tmp13_;
			Project _tmp14_;
			Project _tmp15_ = {0};
			Project _tmp16_;
			const gchar* _tmp17_;
			Project _tmp18_;
			GFile* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			Project _tmp22_;
			GFile* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
#line 256 "projects.vala"
			_project_index = _project_index + 1;
#line 256 "projects.vala"
			if (!(_project_index < _project_size)) {
#line 256 "projects.vala"
				break;
#line 1884 "projects.c"
			}
#line 256 "projects.vala"
			_tmp11_ = _project_list;
#line 256 "projects.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _project_index);
#line 256 "projects.vala"
			_tmp13_ = (Project*) _tmp12_;
#line 256 "projects.vala"
			_tmp14_ = *_tmp13_;
#line 256 "projects.vala"
			project_copy (&_tmp14_, &_tmp15_);
#line 256 "projects.vala"
			_tmp16_ = _tmp15_;
#line 256 "projects.vala"
			_project_free0 (_tmp13_);
#line 256 "projects.vala"
			project = _tmp16_;
#line 258 "projects.vala"
			_tmp17_ = content;
#line 258 "projects.vala"
			_tmp18_ = project;
#line 258 "projects.vala"
			_tmp19_ = _tmp18_.directory;
#line 258 "projects.vala"
			_tmp20_ = g_file_get_uri (_tmp19_);
#line 258 "projects.vala"
			_tmp21_ = _tmp20_;
#line 258 "projects.vala"
			_tmp22_ = project;
#line 258 "projects.vala"
			_tmp23_ = _tmp22_.main_file;
#line 258 "projects.vala"
			_tmp24_ = g_file_get_uri (_tmp23_);
#line 258 "projects.vala"
			_tmp25_ = _tmp24_;
#line 258 "projects.vala"
			_tmp26_ = g_strdup_printf ("  <project directory=\"%s\" main_file=\"%s\" />\n", _tmp21_, _tmp25_);
#line 258 "projects.vala"
			_tmp27_ = _tmp26_;
#line 258 "projects.vala"
			_tmp28_ = g_strconcat (_tmp17_, _tmp27_, NULL);
#line 258 "projects.vala"
			_g_free0 (content);
#line 258 "projects.vala"
			content = _tmp28_;
#line 258 "projects.vala"
			_g_free0 (_tmp27_);
#line 258 "projects.vala"
			_g_free0 (_tmp25_);
#line 258 "projects.vala"
			_g_free0 (_tmp21_);
#line 256 "projects.vala"
			project_destroy (&project);
#line 1938 "projects.c"
		}
#line 256 "projects.vala"
		_g_object_unref0 (_project_list);
#line 1942 "projects.c"
	}
#line 261 "projects.vala"
	_tmp29_ = content;
#line 261 "projects.vala"
	_tmp30_ = g_strconcat (_tmp29_, "</projects>\n", NULL);
#line 261 "projects.vala"
	_g_free0 (content);
#line 261 "projects.vala"
	content = _tmp30_;
#line 263 "projects.vala"
	_tmp31_ = file;
#line 263 "projects.vala"
	_tmp32_ = content;
#line 263 "projects.vala"
	utils_save_file (_tmp31_, _tmp32_, FALSE);
#line 241 "projects.vala"
	_g_free0 (content);
#line 241 "projects.vala"
	_g_object_unref0 (file);
#line 1962 "projects.c"
}

static gboolean
projects_conflict (Projects* self,
                   GFile* dir1,
                   GFile* dir2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result = FALSE;
#line 267 "projects.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 267 "projects.vala"
	g_return_val_if_fail (dir1 != NULL, FALSE);
#line 267 "projects.vala"
	g_return_val_if_fail (dir2 != NULL, FALSE);
#line 269 "projects.vala"
	if (g_file_has_prefix (dir1, dir2)) {
#line 269 "projects.vala"
		_tmp1_ = TRUE;
#line 1983 "projects.c"
	} else {
#line 269 "projects.vala"
		_tmp1_ = g_file_has_prefix (dir2, dir1);
#line 1987 "projects.c"
	}
#line 269 "projects.vala"
	if (_tmp1_) {
#line 269 "projects.vala"
		_tmp0_ = TRUE;
#line 1993 "projects.c"
	} else {
#line 269 "projects.vala"
		_tmp0_ = g_file_equal (dir1, dir2);
#line 1997 "projects.c"
	}
#line 269 "projects.vala"
	result = _tmp0_;
#line 269 "projects.vala"
	return result;
#line 2003 "projects.c"
}

static void
value_projects_init (GValue* value)
{
#line 28 "projects.vala"
	value->data[0].v_pointer = NULL;
#line 2011 "projects.c"
}

static void
value_projects_free_value (GValue* value)
{
#line 28 "projects.vala"
	if (value->data[0].v_pointer) {
#line 28 "projects.vala"
		projects_unref (value->data[0].v_pointer);
#line 2021 "projects.c"
	}
}

static void
value_projects_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
#line 28 "projects.vala"
	if (src_value->data[0].v_pointer) {
#line 28 "projects.vala"
		dest_value->data[0].v_pointer = projects_ref (src_value->data[0].v_pointer);
#line 2033 "projects.c"
	} else {
#line 28 "projects.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2037 "projects.c"
	}
}

static gpointer
value_projects_peek_pointer (const GValue* value)
{
#line 28 "projects.vala"
	return value->data[0].v_pointer;
#line 2046 "projects.c"
}

static gchar*
value_projects_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
#line 28 "projects.vala"
	if (collect_values[0].v_pointer) {
#line 2057 "projects.c"
		Projects * object;
		object = collect_values[0].v_pointer;
#line 28 "projects.vala"
		if (object->parent_instance.g_class == NULL) {
#line 28 "projects.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2064 "projects.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 28 "projects.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2068 "projects.c"
		}
#line 28 "projects.vala"
		value->data[0].v_pointer = projects_ref (object);
#line 2072 "projects.c"
	} else {
#line 28 "projects.vala"
		value->data[0].v_pointer = NULL;
#line 2076 "projects.c"
	}
#line 28 "projects.vala"
	return NULL;
#line 2080 "projects.c"
}

static gchar*
value_projects_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	Projects ** object_p;
	object_p = collect_values[0].v_pointer;
#line 28 "projects.vala"
	if (!object_p) {
#line 28 "projects.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2095 "projects.c"
	}
#line 28 "projects.vala"
	if (!value->data[0].v_pointer) {
#line 28 "projects.vala"
		*object_p = NULL;
#line 2101 "projects.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 28 "projects.vala"
		*object_p = value->data[0].v_pointer;
#line 2105 "projects.c"
	} else {
#line 28 "projects.vala"
		*object_p = projects_ref (value->data[0].v_pointer);
#line 2109 "projects.c"
	}
#line 28 "projects.vala"
	return NULL;
#line 2113 "projects.c"
}

GParamSpec*
param_spec_projects (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecProjects* spec;
#line 28 "projects.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PROJECTS), NULL);
#line 28 "projects.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 28 "projects.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 28 "projects.vala"
	return G_PARAM_SPEC (spec);
#line 2132 "projects.c"
}

gpointer
value_get_projects (const GValue* value)
{
#line 28 "projects.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS), NULL);
#line 28 "projects.vala"
	return value->data[0].v_pointer;
#line 2142 "projects.c"
}

void
value_set_projects (GValue* value,
                    gpointer v_object)
{
	Projects * old;
#line 28 "projects.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
#line 28 "projects.vala"
	old = value->data[0].v_pointer;
#line 28 "projects.vala"
	if (v_object) {
#line 28 "projects.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
#line 28 "projects.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "projects.vala"
		value->data[0].v_pointer = v_object;
#line 28 "projects.vala"
		projects_ref (value->data[0].v_pointer);
#line 2164 "projects.c"
	} else {
#line 28 "projects.vala"
		value->data[0].v_pointer = NULL;
#line 2168 "projects.c"
	}
#line 28 "projects.vala"
	if (old) {
#line 28 "projects.vala"
		projects_unref (old);
#line 2174 "projects.c"
	}
}

void
value_take_projects (GValue* value,
                     gpointer v_object)
{
	Projects * old;
#line 28 "projects.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PROJECTS));
#line 28 "projects.vala"
	old = value->data[0].v_pointer;
#line 28 "projects.vala"
	if (v_object) {
#line 28 "projects.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PROJECTS));
#line 28 "projects.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 28 "projects.vala"
		value->data[0].v_pointer = v_object;
#line 2195 "projects.c"
	} else {
#line 28 "projects.vala"
		value->data[0].v_pointer = NULL;
#line 2199 "projects.c"
	}
#line 28 "projects.vala"
	if (old) {
#line 28 "projects.vala"
		projects_unref (old);
#line 2205 "projects.c"
	}
}

static void
projects_class_init (ProjectsClass * klass,
                     gpointer klass_data)
{
#line 28 "projects.vala"
	projects_parent_class = g_type_class_peek_parent (klass);
#line 28 "projects.vala"
	((ProjectsClass *) klass)->finalize = projects_finalize;
#line 28 "projects.vala"
	g_type_class_adjust_private_offset (klass, &Projects_private_offset);
#line 2219 "projects.c"
}

static void
projects_instance_init (Projects * self,
                        gpointer klass)
{
#line 28 "projects.vala"
	self->priv = projects_get_instance_private (self);
#line 33 "projects.vala"
	self->priv->modified = FALSE;
#line 28 "projects.vala"
	self->ref_count = 1;
#line 2232 "projects.c"
}

static void
projects_finalize (Projects * obj)
{
	Projects * self;
#line 28 "projects.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROJECTS, Projects);
#line 28 "projects.vala"
	g_signal_handlers_destroy (self);
#line 32 "projects.vala"
	_g_object_unref0 (self->priv->projects);
#line 2245 "projects.c"
}

static GType
projects_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_projects_init, value_projects_free_value, value_projects_copy_value, value_projects_peek_pointer, "p", value_projects_collect_value, "p", value_projects_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ProjectsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) projects_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Projects), 0, (GInstanceInitFunc) projects_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType projects_type_id;
	projects_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Projects", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Projects_private_offset = g_type_add_instance_private (projects_type_id, sizeof (ProjectsPrivate));
	return projects_type_id;
}

GType
projects_get_type (void)
{
	static volatile gsize projects_type_id__volatile = 0;
	if (g_once_init_enter (&projects_type_id__volatile)) {
		GType projects_type_id;
		projects_type_id = projects_get_type_once ();
		g_once_init_leave (&projects_type_id__volatile, projects_type_id);
	}
	return projects_type_id__volatile;
}

gpointer
projects_ref (gpointer instance)
{
	Projects * self;
	self = instance;
#line 28 "projects.vala"
	g_atomic_int_inc (&self->ref_count);
#line 28 "projects.vala"
	return instance;
#line 2281 "projects.c"
}

void
projects_unref (gpointer instance)
{
	Projects * self;
	self = instance;
#line 28 "projects.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 28 "projects.vala"
		PROJECTS_GET_CLASS (self)->finalize (self);
#line 28 "projects.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2295 "projects.c"
	}
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 183 "project_dialogs.vala"
	if (array) {
#line 183 "project_dialogs.vala"
		while (((gpointer*) array)[length]) {
#line 183 "project_dialogs.vala"
			length++;
#line 2310 "projects.c"
		}
	}
#line 183 "project_dialogs.vala"
	return length;
#line 2315 "projects.c"
}

