#include <config.h>

/* needed for sigaction and friends under 'gcc -ansi -pedantic' on 
 * GNU/Linux */
#ifndef _POSIX_SOURCE
#  define _POSIX_SOURCE 1
#endif
#include <sys/types.h>

#include <unistd.h>
#include <gnome.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>

int retval = 1;

int main(int argc, char *argv[])
{
  GtkWidget *mainwin;
  gchar* msg;
  struct sigaction sa;
  poptContext ctx;
  char **args;

  /* We do this twice to make sure we don't start running ourselves... :) */
  memset(&sa, 0, sizeof(sa));
  sa.sa_handler = SIG_IGN;
  sigaction(SIGSEGV, &sa, NULL);


  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);
  gnome_init_with_popt_table("gnome_segv", VERSION, argc, argv, NULL, 0, &ctx);

  memset(&sa, 0, sizeof(sa));
  sa.sa_handler = SIG_IGN;
  sigaction(SIGSEGV, &sa, NULL);

  args = poptGetArgs(ctx);
  if (args && args[0] && args[1])
    {
      msg = g_strdup_printf(_("Application \"%s\" (process %d) has crashed due to a bug in the software.\n(%s)\nFor more information, see http://www.gnome.org/application_crashed.shtml"),
                       args[0], getppid(), g_strsignal(atoi(args[1])));
    }
  else
    {
      fprintf(stderr, "Usage: gnome_segv appname signum\n");
      return 1;
    }

  poptFreeContext(ctx);

  mainwin = gnome_message_box_new(msg,
                                  GNOME_MESSAGE_BOX_ERROR,
                                  GNOME_STOCK_BUTTON_CLOSE,
                                  NULL);

  g_free(msg);

  gnome_dialog_run(GNOME_DIALOG(mainwin));

  return 0;
}
