/* nibbles-game.c generated by valac 0.44.6, the Vala compiler
 * generated from nibbles-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <time.h>
#include <string.h>

typedef enum  {
	GAME_STATUS_GAMEOVER,
	GAME_STATUS_VICTORY,
	GAME_STATUS_NEWROUND
} GameStatus;

#define TYPE_GAME_STATUS (game_status_get_type ())

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
enum  {
	NIBBLES_GAME_0_PROPERTY,
	NIBBLES_GAME_START_LEVEL_PROPERTY,
	NIBBLES_GAME_CURRENT_LEVEL_PROPERTY,
	NIBBLES_GAME_SPEED_PROPERTY,
	NIBBLES_GAME_TILE_SIZE_PROPERTY,
	NIBBLES_GAME_NUMHUMANS_PROPERTY,
	NIBBLES_GAME_NUMAI_PROPERTY,
	NIBBLES_GAME_NUMWORMS_PROPERTY,
	NIBBLES_GAME_WORMS_PROPERTY,
	NIBBLES_GAME_BONI_PROPERTY,
	NIBBLES_GAME_WARP_MANAGER_PROPERTY,
	NIBBLES_GAME_WORM_PROPS_PROPERTY,
	NIBBLES_GAME_IS_RUNNING_PROPERTY,
	NIBBLES_GAME_IS_PAUSED_PROPERTY,
	NIBBLES_GAME_FAKES_PROPERTY,
	NIBBLES_GAME_NUM_PROPERTIES
};
static GParamSpec* nibbles_game_properties[NIBBLES_GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _WormPrivate WormPrivate;
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
typedef struct _BoniPrivate BoniPrivate;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef struct _BonusPrivate BonusPrivate;
typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
enum  {
	NIBBLES_GAME_WORM_MOVED_SIGNAL,
	NIBBLES_GAME_BONUS_APPLIED_SIGNAL,
	NIBBLES_GAME_LOG_SCORE_SIGNAL,
	NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL,
	NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL,
	NIBBLES_GAME_NUM_SIGNALS
};
static guint nibbles_game_signals[NIBBLES_GAME_NUM_SIGNALS] = {0};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _NibblesGamePrivate {
	gint _start_level;
	gint _current_level;
	gint _speed;
	gint _tile_size;
	gint _numhumans;
	gint _numai;
	gint _numworms;
	GeeLinkedList* _worms;
	Boni* _boni;
	WarpManager* _warp_manager;
	GeeHashMap* _worm_props;
	gboolean _is_running;
	gboolean _is_paused;
	guint main_id;
	guint add_bonus_id;
	gboolean _fakes;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};

static gint NibblesGame_private_offset;
static gpointer nibbles_game_parent_class = NULL;

GType game_status_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType boni_get_type (void) G_GNUC_CONST;
GType warp_manager_get_type (void) G_GNUC_CONST;
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_GAMEDELAY 35
#define NIBBLES_GAME_BONUSDELAY 100
#define NIBBLES_GAME_MAX_HUMANS 4
#define NIBBLES_GAME_MAX_AI 5
#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_GAME_MAX_SPEED 4
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
#define NIBBLES_GAME_EMPTYCHAR 'a'
#define NIBBLES_GAME_WORMCHAR 'w'
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_MAX_LEVEL 26
NibblesGame* nibbles_game_new (GSettings* settings);
NibblesGame* nibbles_game_construct (GType object_type,
                                     GSettings* settings);
gint nibbles_game_get_numworms (NibblesGame* self);
Boni* boni_new (gint numworms);
Boni* boni_construct (GType object_type,
                      gint numworms);
static void nibbles_game_set_boni (NibblesGame* self,
                            Boni* value);
WarpManager* warp_manager_new (void);
WarpManager* warp_manager_construct (GType object_type);
static void nibbles_game_set_warp_manager (NibblesGame* self,
                                    WarpManager* value);
static void nibbles_game_set_worms (NibblesGame* self,
                             GeeLinkedList* value);
static void nibbles_game_set_worm_props (NibblesGame* self,
                                  GeeHashMap* value);
static void nibbles_game_set_is_paused (NibblesGame* self,
                                 gboolean value);
void nibbles_game_load_properties (NibblesGame* self,
                                   GSettings* settings);
gint nibbles_game_get_start_level (NibblesGame* self);
static void nibbles_game_set_current_level (NibblesGame* self,
                                     gint value);
void nibbles_game_start (NibblesGame* self);
static void nibbles_game_set_is_running (NibblesGame* self,
                                  gboolean value);
gint nibbles_game_get_speed (NibblesGame* self);
gboolean nibbles_game_main_loop_cb (NibblesGame* self);
static gboolean _nibbles_game_main_loop_cb_gsource_func (gpointer self);
gboolean nibbles_game_add_bonus_cb (NibblesGame* self);
static gboolean _nibbles_game_add_bonus_cb_gsource_func (gpointer self);
void nibbles_game_stop (NibblesGame* self);
void nibbles_game_pause (NibblesGame* self);
void nibbles_game_unpause (NibblesGame* self);
void nibbles_game_reset (NibblesGame* self);
static void nibbles_game_end (NibblesGame* self);
GameStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _game_status_equal (const GameStatus * s1,
                             const GameStatus * s2);
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
gint worm_get_score (Worm* self);
gint nibbles_game_get_current_level (NibblesGame* self);
Worm* nibbles_game_get_winner (NibblesGame* self);
void nibbles_game_move_worms (NibblesGame* self);
void nibbles_game_create_worms (NibblesGame* self);
gint nibbles_game_get_numai (NibblesGame* self);
gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_game_set_numworms (NibblesGame* self,
                                gint value);
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type,
                      gint id);
void nibbles_game_bonus_found_cb (NibblesGame* self,
                                  Worm* worm);
static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                                    gpointer self);
void nibbles_game_warp_found_cb (NibblesGame* self,
                                 Worm* worm);
static void _nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender,
                                                  gpointer self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void nibbles_game_add_worms (NibblesGame* self);
void worm_spawn (Worm* self,
                 gint* board,
                 gint board_length1,
                 gint board_length2);
Boni* nibbles_game_get_boni (NibblesGame* self);
GType bonus_get_type (void) G_GNUC_CONST;
#define BONI_MAX_MISSED 2
void worm_set_score (Worm* self,
                     gint value);
GType bonus_type_get_type (void) G_GNUC_CONST;
void boni_remove_bonus (Boni* self,
                        gint* board,
                        gint board_length1,
                        gint board_length2,
                        Bonus* bonus);
void nibbles_game_add_bonus (NibblesGame* self,
                             gboolean regular);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_ai_move (Worm* self,
                   gint* board,
                   gint board_length1,
                   gint board_length2,
                   gint numworms,
                   GeeLinkedList* worms);
gboolean worm_will_collide_with_head (Worm* self,
                                      Worm* other_worm);
gboolean worm_can_move_to (Worm* self,
                           gint* board,
                           gint board_length1,
                           gint board_length2,
                           gint numworms);
void worm_move (Worm* self,
                gint* board,
                gint board_length1,
                gint board_length2);
gint worm_get_lives (Worm* self);
void worm_reset (Worm* self,
                 gint* board,
                 gint board_length1,
                 gint board_length2);
static void nibbles_game_reverse_worms (NibblesGame* self,
                                 Worm* worm);
void worm_reverse (Worm* self,
                   gint* board,
                   gint board_length1,
                   gint board_length2);
gboolean nibbles_game_get_fakes (NibblesGame* self);
void boni_add_bonus (Boni* self,
                     gint* board,
                     gint board_length1,
                     gint board_length2,
                     gint x,
                     gint y,
                     BonusType type,
                     gboolean fake,
                     gint countdown);
void nibbles_game_apply_bonus (NibblesGame* self,
                               Bonus* bonus,
                               Worm* worm);
void worm_get_head (Worm* self,
                    Position * result);
#define WORM_GROW_FACTOR 4
gint worm_get_length (Worm* self);
void worm_reduce_tail (Worm* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2,
                       gint erase_size);
void worm_add_life (Worm* self);
Bonus* boni_get_bonus (Boni* self,
                       gint* board,
                       gint board_length1,
                       gint board_length2,
                       gint x,
                       gint y);
GType warp_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
Warp* warp_manager_get_warp (WarpManager* self,
                             gint x,
                             gint y);
void worm_warp (Worm* self,
                Warp* warp);
static GameStatus* _game_status_dup (GameStatus* self);
void nibbles_game_set_tile_size (NibblesGame* self,
                                 gint value);
static void nibbles_game_set_start_level (NibblesGame* self,
                                   gint value);
void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
void nibbles_game_save_properties (NibblesGame* self,
                                   GSettings* settings);
gint nibbles_game_get_tile_size (NibblesGame* self);
void nibbles_game_load_worm_properties (NibblesGame* self,
                                        GeeArrayList* worm_settings);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gint worm_get_id (Worm* self);
gboolean nibbles_game_handle_keypress (NibblesGame* self,
                                       guint keyval);
gboolean nibbles_game_get_is_running (NibblesGame* self);
gboolean worm_handle_keypress (Worm* self,
                               guint keyval,
                               GeeHashMap* worm_props);
void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
gboolean nibbles_game_get_is_paused (NibblesGame* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void nibbles_game_finalize (GObject * obj);
static void _vala_nibbles_game_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_nibbles_game_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

GType
game_status_get_type (void)
{
	static volatile gsize game_status_type_id__volatile = 0;
	if (g_once_init_enter (&game_status_type_id__volatile)) {
		static const GEnumValue values[] = {{GAME_STATUS_GAMEOVER, "GAME_STATUS_GAMEOVER", "gameover"}, {GAME_STATUS_VICTORY, "GAME_STATUS_VICTORY", "victory"}, {GAME_STATUS_NEWROUND, "GAME_STATUS_NEWROUND", "newround"}, {0, NULL, NULL}};
		GType game_status_type_id;
		game_status_type_id = g_enum_register_static ("GameStatus", values);
		g_once_init_leave (&game_status_type_id__volatile, game_status_type_id);
	}
	return game_status_type_id__volatile;
}

static inline gpointer
nibbles_game_get_instance_private (NibblesGame* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesGame_private_offset);
}

NibblesGame*
nibbles_game_construct (GType object_type,
                        GSettings* settings)
{
	NibblesGame * self = NULL;
	gint _tmp0_;
	Boni* _tmp1_;
	Boni* _tmp2_;
	WarpManager* _tmp3_;
	WarpManager* _tmp4_;
	gint* _tmp5_;
	GeeLinkedList* _tmp6_;
	GeeLinkedList* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	time_t _tmp10_;
	gint _tmp11_;
#line 86 "nibbles-game.vala"
	g_return_val_if_fail (settings != NULL, NULL);
#line 86 "nibbles-game.vala"
	self = (NibblesGame*) g_object_new (object_type, NULL);
#line 88 "nibbles-game.vala"
	_tmp0_ = self->priv->_numworms;
#line 88 "nibbles-game.vala"
	_tmp1_ = boni_new (_tmp0_);
#line 88 "nibbles-game.vala"
	_tmp2_ = _tmp1_;
#line 88 "nibbles-game.vala"
	nibbles_game_set_boni (self, _tmp2_);
#line 88 "nibbles-game.vala"
	_g_object_unref0 (_tmp2_);
#line 89 "nibbles-game.vala"
	_tmp3_ = warp_manager_new ();
#line 89 "nibbles-game.vala"
	_tmp4_ = _tmp3_;
#line 89 "nibbles-game.vala"
	nibbles_game_set_warp_manager (self, _tmp4_);
#line 89 "nibbles-game.vala"
	_g_object_unref0 (_tmp4_);
#line 90 "nibbles-game.vala"
	_tmp5_ = g_new0 (gint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
#line 90 "nibbles-game.vala"
	self->board = (g_free (self->board), NULL);
#line 90 "nibbles-game.vala"
	self->board = _tmp5_;
#line 90 "nibbles-game.vala"
	self->board_length1 = NIBBLES_GAME_WIDTH;
#line 90 "nibbles-game.vala"
	self->board_length2 = NIBBLES_GAME_HEIGHT;
#line 91 "nibbles-game.vala"
	_tmp6_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 91 "nibbles-game.vala"
	_tmp7_ = _tmp6_;
#line 91 "nibbles-game.vala"
	nibbles_game_set_worms (self, _tmp7_);
#line 91 "nibbles-game.vala"
	_g_object_unref0 (_tmp7_);
#line 92 "nibbles-game.vala"
	_tmp8_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM_PROPERTIES, (GBoxedCopyFunc) worm_properties_dup, (GDestroyNotify) worm_properties_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 92 "nibbles-game.vala"
	_tmp9_ = _tmp8_;
#line 92 "nibbles-game.vala"
	nibbles_game_set_worm_props (self, _tmp9_);
#line 92 "nibbles-game.vala"
	_g_object_unref0 (_tmp9_);
#line 94 "nibbles-game.vala"
	nibbles_game_set_is_paused (self, FALSE);
#line 96 "nibbles-game.vala"
	_tmp10_ = time (NULL);
#line 96 "nibbles-game.vala"
	g_random_set_seed ((guint32) _tmp10_);
#line 97 "nibbles-game.vala"
	nibbles_game_load_properties (self, settings);
#line 98 "nibbles-game.vala"
	_tmp11_ = self->priv->_start_level;
#line 98 "nibbles-game.vala"
	nibbles_game_set_current_level (self, _tmp11_);
#line 86 "nibbles-game.vala"
	return self;
#line 566 "nibbles-game.c"
}

NibblesGame*
nibbles_game_new (GSettings* settings)
{
#line 86 "nibbles-game.vala"
	return nibbles_game_construct (TYPE_NIBBLES_GAME, settings);
#line 574 "nibbles-game.c"
}

static gboolean
_nibbles_game_main_loop_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_game_main_loop_cb ((NibblesGame*) self);
#line 109 "nibbles-game.vala"
	return result;
#line 584 "nibbles-game.c"
}

static gboolean
_nibbles_game_add_bonus_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_game_add_bonus_cb ((NibblesGame*) self);
#line 112 "nibbles-game.vala"
	return result;
#line 594 "nibbles-game.c"
}

void
nibbles_game_start (NibblesGame* self)
{
	gint _tmp0_;
	gint _tmp1_;
#line 105 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 107 "nibbles-game.vala"
	nibbles_game_set_is_running (self, TRUE);
#line 109 "nibbles-game.vala"
	_tmp0_ = self->priv->_speed;
#line 109 "nibbles-game.vala"
	self->priv->main_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * _tmp0_), _nibbles_game_main_loop_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 110 "nibbles-game.vala"
	g_source_set_name_by_id (self->priv->main_id, "[Nibbles] main_loop_cb");
#line 112 "nibbles-game.vala"
	_tmp1_ = self->priv->_speed;
#line 112 "nibbles-game.vala"
	self->priv->add_bonus_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_BONUSDELAY * _tmp1_), _nibbles_game_add_bonus_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 113 "nibbles-game.vala"
	g_source_set_name_by_id (self->priv->add_bonus_id, "[Nibbles] add_bonus_cb");
#line 618 "nibbles-game.c"
}

void
nibbles_game_stop (NibblesGame* self)
{
#line 116 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 118 "nibbles-game.vala"
	nibbles_game_set_is_running (self, FALSE);
#line 120 "nibbles-game.vala"
	if (self->priv->main_id != ((guint) 0)) {
#line 122 "nibbles-game.vala"
		g_source_remove (self->priv->main_id);
#line 123 "nibbles-game.vala"
		self->priv->main_id = (guint) 0;
#line 634 "nibbles-game.c"
	}
#line 126 "nibbles-game.vala"
	if (self->priv->add_bonus_id != ((guint) 0)) {
#line 128 "nibbles-game.vala"
		g_source_remove (self->priv->add_bonus_id);
#line 129 "nibbles-game.vala"
		self->priv->add_bonus_id = (guint) 0;
#line 642 "nibbles-game.c"
	}
}

void
nibbles_game_pause (NibblesGame* self)
{
#line 133 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 135 "nibbles-game.vala"
	nibbles_game_set_is_paused (self, TRUE);
#line 136 "nibbles-game.vala"
	nibbles_game_stop (self);
#line 655 "nibbles-game.c"
}

void
nibbles_game_unpause (NibblesGame* self)
{
#line 139 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 141 "nibbles-game.vala"
	nibbles_game_set_is_paused (self, FALSE);
#line 142 "nibbles-game.vala"
	nibbles_game_start (self);
#line 667 "nibbles-game.c"
}

void
nibbles_game_reset (NibblesGame* self)
{
	gint _tmp0_;
#line 145 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 147 "nibbles-game.vala"
	_tmp0_ = self->priv->_start_level;
#line 147 "nibbles-game.vala"
	nibbles_game_set_current_level (self, _tmp0_);
#line 680 "nibbles-game.c"
}

static void
nibbles_game_end (NibblesGame* self)
{
#line 150 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 152 "nibbles-game.vala"
	nibbles_game_stop (self);
#line 153 "nibbles-game.vala"
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
#line 692 "nibbles-game.c"
}

static gboolean
_game_status_equal (const GameStatus * s1,
                    const GameStatus * s2)
{
#line 160 "nibbles-game.vala"
	if (s1 == s2) {
#line 160 "nibbles-game.vala"
		return TRUE;
#line 703 "nibbles-game.c"
	}
#line 160 "nibbles-game.vala"
	if (s1 == NULL) {
#line 160 "nibbles-game.vala"
		return FALSE;
#line 709 "nibbles-game.c"
	}
#line 160 "nibbles-game.vala"
	if (s2 == NULL) {
#line 160 "nibbles-game.vala"
		return FALSE;
#line 715 "nibbles-game.c"
	}
#line 160 "nibbles-game.vala"
	return (*s1) == (*s2);
#line 719 "nibbles-game.c"
}

gboolean
nibbles_game_main_loop_cb (NibblesGame* self)
{
	gboolean result = FALSE;
	GameStatus* status = NULL;
	GameStatus* _tmp0_;
	GameStatus* _tmp1_;
	GameStatus _tmp2_;
#line 156 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 158 "nibbles-game.vala"
	_tmp0_ = nibbles_game_get_game_status (self);
#line 158 "nibbles-game.vala"
	status = _tmp0_;
#line 160 "nibbles-game.vala"
	_tmp1_ = status;
#line 160 "nibbles-game.vala"
	_tmp2_ = GAME_STATUS_GAMEOVER;
#line 160 "nibbles-game.vala"
	if (_game_status_equal (_tmp1_, &_tmp2_) == TRUE) {
#line 742 "nibbles-game.c"
		GeeLinkedList* _tmp3_;
		gpointer _tmp4_;
		Worm* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 162 "nibbles-game.vala"
		nibbles_game_end (self);
#line 164 "nibbles-game.vala"
		_tmp3_ = self->priv->_worms;
#line 164 "nibbles-game.vala"
		_tmp4_ = gee_linked_list_first (_tmp3_);
#line 164 "nibbles-game.vala"
		_tmp5_ = (Worm*) _tmp4_;
#line 164 "nibbles-game.vala"
		_tmp6_ = worm_get_score (_tmp5_);
#line 164 "nibbles-game.vala"
		_tmp7_ = _tmp6_;
#line 164 "nibbles-game.vala"
		_tmp8_ = self->priv->_current_level;
#line 164 "nibbles-game.vala"
		g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp7_, _tmp8_);
#line 164 "nibbles-game.vala"
		_g_object_unref0 (_tmp5_);
#line 166 "nibbles-game.vala"
		result = G_SOURCE_REMOVE;
#line 166 "nibbles-game.vala"
		_g_free0 (status);
#line 166 "nibbles-game.vala"
		return result;
#line 773 "nibbles-game.c"
	} else {
		GameStatus* _tmp9_;
		GameStatus _tmp10_;
#line 168 "nibbles-game.vala"
		_tmp9_ = status;
#line 168 "nibbles-game.vala"
		_tmp10_ = GAME_STATUS_VICTORY;
#line 168 "nibbles-game.vala"
		if (_game_status_equal (_tmp9_, &_tmp10_) == TRUE) {
#line 783 "nibbles-game.c"
			Worm* winner = NULL;
			Worm* _tmp11_;
			Worm* _tmp12_;
			Worm* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 170 "nibbles-game.vala"
			nibbles_game_end (self);
#line 172 "nibbles-game.vala"
			_tmp11_ = nibbles_game_get_winner (self);
#line 172 "nibbles-game.vala"
			winner = _tmp11_;
#line 173 "nibbles-game.vala"
			_tmp12_ = winner;
#line 173 "nibbles-game.vala"
			if (_tmp12_ == NULL) {
#line 174 "nibbles-game.vala"
				result = G_SOURCE_REMOVE;
#line 174 "nibbles-game.vala"
				_g_object_unref0 (winner);
#line 174 "nibbles-game.vala"
				_g_free0 (status);
#line 174 "nibbles-game.vala"
				return result;
#line 809 "nibbles-game.c"
			}
#line 176 "nibbles-game.vala"
			_tmp13_ = winner;
#line 176 "nibbles-game.vala"
			_tmp14_ = worm_get_score (_tmp13_);
#line 176 "nibbles-game.vala"
			_tmp15_ = _tmp14_;
#line 176 "nibbles-game.vala"
			_tmp16_ = self->priv->_current_level;
#line 176 "nibbles-game.vala"
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp15_, _tmp16_);
#line 178 "nibbles-game.vala"
			result = G_SOURCE_REMOVE;
#line 178 "nibbles-game.vala"
			_g_object_unref0 (winner);
#line 178 "nibbles-game.vala"
			_g_free0 (status);
#line 178 "nibbles-game.vala"
			return result;
#line 829 "nibbles-game.c"
		} else {
			GameStatus* _tmp17_;
			GameStatus _tmp18_;
#line 180 "nibbles-game.vala"
			_tmp17_ = status;
#line 180 "nibbles-game.vala"
			_tmp18_ = GAME_STATUS_NEWROUND;
#line 180 "nibbles-game.vala"
			if (_game_status_equal (_tmp17_, &_tmp18_) == TRUE) {
#line 839 "nibbles-game.c"
				gint _tmp19_;
				gint _tmp20_;
#line 182 "nibbles-game.vala"
				nibbles_game_stop (self);
#line 184 "nibbles-game.vala"
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
#line 185 "nibbles-game.vala"
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL], 0);
#line 187 "nibbles-game.vala"
				_tmp19_ = self->priv->_current_level;
#line 187 "nibbles-game.vala"
				nibbles_game_set_current_level (self, _tmp19_ + 1);
#line 189 "nibbles-game.vala"
				_tmp20_ = self->priv->_current_level;
#line 189 "nibbles-game.vala"
				if (_tmp20_ == (NIBBLES_GAME_MAX_LEVEL + 1)) {
#line 856 "nibbles-game.c"
					GeeLinkedList* _tmp21_;
					gpointer _tmp22_;
					Worm* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
#line 190 "nibbles-game.vala"
					_tmp21_ = self->priv->_worms;
#line 190 "nibbles-game.vala"
					_tmp22_ = gee_linked_list_first (_tmp21_);
#line 190 "nibbles-game.vala"
					_tmp23_ = (Worm*) _tmp22_;
#line 190 "nibbles-game.vala"
					_tmp24_ = worm_get_score (_tmp23_);
#line 190 "nibbles-game.vala"
					_tmp25_ = _tmp24_;
#line 190 "nibbles-game.vala"
					_tmp26_ = self->priv->_current_level;
#line 190 "nibbles-game.vala"
					g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp25_, _tmp26_);
#line 190 "nibbles-game.vala"
					_g_object_unref0 (_tmp23_);
#line 879 "nibbles-game.c"
				}
#line 192 "nibbles-game.vala"
				result = G_SOURCE_REMOVE;
#line 192 "nibbles-game.vala"
				_g_free0 (status);
#line 192 "nibbles-game.vala"
				return result;
#line 887 "nibbles-game.c"
			}
		}
	}
#line 194 "nibbles-game.vala"
	nibbles_game_move_worms (self);
#line 196 "nibbles-game.vala"
	result = G_SOURCE_CONTINUE;
#line 196 "nibbles-game.vala"
	_g_free0 (status);
#line 196 "nibbles-game.vala"
	return result;
#line 899 "nibbles-game.c"
}

static void
_nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                               gpointer self)
{
#line 211 "nibbles-game.vala"
	nibbles_game_bonus_found_cb ((NibblesGame*) self, _sender);
#line 908 "nibbles-game.c"
}

static void
_nibbles_game_warp_found_cb_worm_warp_found (Worm* _sender,
                                             gpointer self)
{
#line 212 "nibbles-game.vala"
	nibbles_game_warp_found_cb ((NibblesGame*) self, _sender);
#line 917 "nibbles-game.c"
}

void
nibbles_game_create_worms (NibblesGame* self)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 203 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 205 "nibbles-game.vala"
	_tmp0_ = self->priv->_worms;
#line 205 "nibbles-game.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 207 "nibbles-game.vala"
	_tmp1_ = self->priv->_numai;
#line 207 "nibbles-game.vala"
	_tmp2_ = self->priv->_numhumans;
#line 207 "nibbles-game.vala"
	nibbles_game_set_numworms (self, _tmp1_ + _tmp2_);
#line 938 "nibbles-game.c"
	{
		gint i = 0;
#line 208 "nibbles-game.vala"
		i = 0;
#line 943 "nibbles-game.c"
		{
			gboolean _tmp3_ = FALSE;
#line 208 "nibbles-game.vala"
			_tmp3_ = TRUE;
#line 208 "nibbles-game.vala"
			while (TRUE) {
#line 950 "nibbles-game.c"
				gint _tmp5_;
				Worm* worm = NULL;
				Worm* _tmp6_;
				Worm* _tmp7_;
				Worm* _tmp8_;
				Worm* _tmp9_;
				gint _tmp10_;
				GeeLinkedList* _tmp11_;
				Worm* _tmp12_;
#line 208 "nibbles-game.vala"
				if (!_tmp3_) {
#line 962 "nibbles-game.c"
					gint _tmp4_;
#line 208 "nibbles-game.vala"
					_tmp4_ = i;
#line 208 "nibbles-game.vala"
					i = _tmp4_ + 1;
#line 968 "nibbles-game.c"
				}
#line 208 "nibbles-game.vala"
				_tmp3_ = FALSE;
#line 208 "nibbles-game.vala"
				_tmp5_ = self->priv->_numworms;
#line 208 "nibbles-game.vala"
				if (!(i < _tmp5_)) {
#line 208 "nibbles-game.vala"
					break;
#line 978 "nibbles-game.c"
				}
#line 210 "nibbles-game.vala"
				_tmp6_ = worm_new (i);
#line 210 "nibbles-game.vala"
				worm = _tmp6_;
#line 211 "nibbles-game.vala"
				_tmp7_ = worm;
#line 211 "nibbles-game.vala"
				g_signal_connect_object (_tmp7_, "bonus-found", (GCallback) _nibbles_game_bonus_found_cb_worm_bonus_found, self, 0);
#line 212 "nibbles-game.vala"
				_tmp8_ = worm;
#line 212 "nibbles-game.vala"
				g_signal_connect_object (_tmp8_, "warp-found", (GCallback) _nibbles_game_warp_found_cb_worm_warp_found, self, 0);
#line 213 "nibbles-game.vala"
				_tmp9_ = worm;
#line 213 "nibbles-game.vala"
				_tmp10_ = self->priv->_numhumans;
#line 213 "nibbles-game.vala"
				_tmp9_->is_human = i < _tmp10_;
#line 214 "nibbles-game.vala"
				_tmp11_ = self->priv->_worms;
#line 214 "nibbles-game.vala"
				_tmp12_ = worm;
#line 214 "nibbles-game.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
#line 208 "nibbles-game.vala"
				_g_object_unref0 (worm);
#line 1006 "nibbles-game.c"
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 220 "nibbles-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 1017 "nibbles-game.c"
}

void
nibbles_game_add_worms (NibblesGame* self)
{
#line 218 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 1025 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
#line 220 "nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 220 "nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 220 "nibbles-game.vala"
		_worm_list = _tmp1_;
#line 220 "nibbles-game.vala"
		_tmp2_ = _worm_list;
#line 220 "nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 220 "nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 220 "nibbles-game.vala"
		_worm_size = _tmp4_;
#line 220 "nibbles-game.vala"
		_worm_index = -1;
#line 220 "nibbles-game.vala"
		while (TRUE) {
#line 1053 "nibbles-game.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			Worm* _tmp7_;
			Worm* _tmp8_;
			gint* _tmp9_;
			gint _tmp9__length1;
			gint _tmp9__length2;
#line 220 "nibbles-game.vala"
			_worm_index = _worm_index + 1;
#line 220 "nibbles-game.vala"
			if (!(_worm_index < _worm_size)) {
#line 220 "nibbles-game.vala"
				break;
#line 1068 "nibbles-game.c"
			}
#line 220 "nibbles-game.vala"
			_tmp5_ = _worm_list;
#line 220 "nibbles-game.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _worm_index);
#line 220 "nibbles-game.vala"
			worm = (Worm*) _tmp6_;
#line 225 "nibbles-game.vala"
			_tmp7_ = worm;
#line 225 "nibbles-game.vala"
			g_signal_emit_by_name (_tmp7_, "added");
#line 227 "nibbles-game.vala"
			_tmp8_ = worm;
#line 227 "nibbles-game.vala"
			_tmp9_ = self->board;
#line 227 "nibbles-game.vala"
			_tmp9__length1 = self->board_length1;
#line 227 "nibbles-game.vala"
			_tmp9__length2 = self->board_length2;
#line 227 "nibbles-game.vala"
			worm_spawn (_tmp8_, _tmp9_, (gint) _tmp9__length1, (gint) _tmp9__length2);
#line 220 "nibbles-game.vala"
			_g_object_unref0 (worm);
#line 1092 "nibbles-game.c"
		}
#line 220 "nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 1096 "nibbles-game.c"
	}
}

void
nibbles_game_move_worms (NibblesGame* self)
{
	Boni* _tmp0_;
	GeeLinkedList* found = NULL;
	GeeLinkedList* _tmp14_;
	Boni* _tmp41_;
	GeeLinkedList* _tmp42_;
	GeeLinkedList* _tmp43_;
	GeeLinkedList* dead_worms = NULL;
	GeeLinkedList* _tmp44_;
#line 231 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 233 "nibbles-game.vala"
	_tmp0_ = self->priv->_boni;
#line 233 "nibbles-game.vala"
	if (_tmp0_->missed > BONI_MAX_MISSED) {
#line 1117 "nibbles-game.c"
		{
			GeeLinkedList* _worm_list = NULL;
			GeeLinkedList* _tmp1_;
			GeeLinkedList* _tmp2_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _worm_index = 0;
#line 235 "nibbles-game.vala"
			_tmp1_ = self->priv->_worms;
#line 235 "nibbles-game.vala"
			_tmp2_ = _g_object_ref0 (_tmp1_);
#line 235 "nibbles-game.vala"
			_worm_list = _tmp2_;
#line 235 "nibbles-game.vala"
			_tmp3_ = _worm_list;
#line 235 "nibbles-game.vala"
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 235 "nibbles-game.vala"
			_tmp5_ = _tmp4_;
#line 235 "nibbles-game.vala"
			_worm_size = _tmp5_;
#line 235 "nibbles-game.vala"
			_worm_index = -1;
#line 235 "nibbles-game.vala"
			while (TRUE) {
#line 1145 "nibbles-game.c"
				Worm* worm = NULL;
				GeeLinkedList* _tmp6_;
				gpointer _tmp7_;
				Worm* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
#line 235 "nibbles-game.vala"
				_worm_index = _worm_index + 1;
#line 235 "nibbles-game.vala"
				if (!(_worm_index < _worm_size)) {
#line 235 "nibbles-game.vala"
					break;
#line 1158 "nibbles-game.c"
				}
#line 235 "nibbles-game.vala"
				_tmp6_ = _worm_list;
#line 235 "nibbles-game.vala"
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
#line 235 "nibbles-game.vala"
				worm = (Worm*) _tmp7_;
#line 237 "nibbles-game.vala"
				_tmp8_ = worm;
#line 237 "nibbles-game.vala"
				_tmp9_ = worm_get_score (_tmp8_);
#line 237 "nibbles-game.vala"
				_tmp10_ = _tmp9_;
#line 237 "nibbles-game.vala"
				if (_tmp10_ > 0) {
#line 1174 "nibbles-game.c"
					Worm* _tmp11_;
					gint _tmp12_;
					gint _tmp13_;
#line 238 "nibbles-game.vala"
					_tmp11_ = worm;
#line 238 "nibbles-game.vala"
					_tmp12_ = worm_get_score (_tmp11_);
#line 238 "nibbles-game.vala"
					_tmp13_ = _tmp12_;
#line 238 "nibbles-game.vala"
					worm_set_score (_tmp11_, _tmp13_ - 1);
#line 1186 "nibbles-game.c"
				}
#line 235 "nibbles-game.vala"
				_g_object_unref0 (worm);
#line 1190 "nibbles-game.c"
			}
#line 235 "nibbles-game.vala"
			_g_object_unref0 (_worm_list);
#line 1194 "nibbles-game.c"
		}
	}
#line 244 "nibbles-game.vala"
	_tmp14_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 244 "nibbles-game.vala"
	found = _tmp14_;
#line 1201 "nibbles-game.c"
	{
		GeeLinkedList* _bonus_list = NULL;
		Boni* _tmp15_;
		GeeLinkedList* _tmp16_;
		GeeLinkedList* _tmp17_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _bonus_index = 0;
#line 245 "nibbles-game.vala"
		_tmp15_ = self->priv->_boni;
#line 245 "nibbles-game.vala"
		_tmp16_ = _tmp15_->bonuses;
#line 245 "nibbles-game.vala"
		_tmp17_ = _g_object_ref0 (_tmp16_);
#line 245 "nibbles-game.vala"
		_bonus_list = _tmp17_;
#line 245 "nibbles-game.vala"
		_tmp18_ = _bonus_list;
#line 245 "nibbles-game.vala"
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
#line 245 "nibbles-game.vala"
		_tmp20_ = _tmp19_;
#line 245 "nibbles-game.vala"
		_bonus_size = _tmp20_;
#line 245 "nibbles-game.vala"
		_bonus_index = -1;
#line 245 "nibbles-game.vala"
		while (TRUE) {
#line 1232 "nibbles-game.c"
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp21_;
			gpointer _tmp22_;
			Bonus* _tmp23_;
			gint _tmp24_;
#line 245 "nibbles-game.vala"
			_bonus_index = _bonus_index + 1;
#line 245 "nibbles-game.vala"
			if (!(_bonus_index < _bonus_size)) {
#line 245 "nibbles-game.vala"
				break;
#line 1244 "nibbles-game.c"
			}
#line 245 "nibbles-game.vala"
			_tmp21_ = _bonus_list;
#line 245 "nibbles-game.vala"
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _bonus_index);
#line 245 "nibbles-game.vala"
			bonus = (Bonus*) _tmp22_;
#line 247 "nibbles-game.vala"
			_tmp23_ = bonus;
#line 247 "nibbles-game.vala"
			_tmp24_ = _tmp23_->countdown;
#line 247 "nibbles-game.vala"
			_tmp23_->countdown = _tmp24_ - 1;
#line 247 "nibbles-game.vala"
			if (_tmp24_ == 0) {
#line 1260 "nibbles-game.c"
				gboolean _tmp25_ = FALSE;
				Bonus* _tmp26_;
				BonusType _tmp27_;
#line 249 "nibbles-game.vala"
				_tmp26_ = bonus;
#line 249 "nibbles-game.vala"
				_tmp27_ = _tmp26_->type;
#line 249 "nibbles-game.vala"
				if (_tmp27_ == BONUS_TYPE_REGULAR) {
#line 1270 "nibbles-game.c"
					Bonus* _tmp28_;
#line 249 "nibbles-game.vala"
					_tmp28_ = bonus;
#line 249 "nibbles-game.vala"
					_tmp25_ = !_tmp28_->fake;
#line 1276 "nibbles-game.c"
				} else {
#line 249 "nibbles-game.vala"
					_tmp25_ = FALSE;
#line 1280 "nibbles-game.c"
				}
#line 249 "nibbles-game.vala"
				if (_tmp25_) {
#line 1284 "nibbles-game.c"
					GeeLinkedList* _tmp29_;
					Bonus* _tmp30_;
					Boni* _tmp31_;
					gint* _tmp32_;
					gint _tmp32__length1;
					gint _tmp32__length2;
					Bonus* _tmp33_;
					Boni* _tmp34_;
					gint _tmp35_;
#line 251 "nibbles-game.vala"
					_tmp29_ = found;
#line 251 "nibbles-game.vala"
					_tmp30_ = bonus;
#line 251 "nibbles-game.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
#line 252 "nibbles-game.vala"
					_tmp31_ = self->priv->_boni;
#line 252 "nibbles-game.vala"
					_tmp32_ = self->board;
#line 252 "nibbles-game.vala"
					_tmp32__length1 = self->board_length1;
#line 252 "nibbles-game.vala"
					_tmp32__length2 = self->board_length2;
#line 252 "nibbles-game.vala"
					_tmp33_ = bonus;
#line 252 "nibbles-game.vala"
					boni_remove_bonus (_tmp31_, _tmp32_, (gint) _tmp32__length1, (gint) _tmp32__length2, _tmp33_);
#line 253 "nibbles-game.vala"
					_tmp34_ = self->priv->_boni;
#line 253 "nibbles-game.vala"
					_tmp35_ = _tmp34_->missed;
#line 253 "nibbles-game.vala"
					_tmp34_->missed = _tmp35_ + 1;
#line 255 "nibbles-game.vala"
					nibbles_game_add_bonus (self, TRUE);
#line 1320 "nibbles-game.c"
				} else {
					GeeLinkedList* _tmp36_;
					Bonus* _tmp37_;
					Boni* _tmp38_;
					gint* _tmp39_;
					gint _tmp39__length1;
					gint _tmp39__length2;
					Bonus* _tmp40_;
#line 259 "nibbles-game.vala"
					_tmp36_ = found;
#line 259 "nibbles-game.vala"
					_tmp37_ = bonus;
#line 259 "nibbles-game.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, _tmp37_);
#line 260 "nibbles-game.vala"
					_tmp38_ = self->priv->_boni;
#line 260 "nibbles-game.vala"
					_tmp39_ = self->board;
#line 260 "nibbles-game.vala"
					_tmp39__length1 = self->board_length1;
#line 260 "nibbles-game.vala"
					_tmp39__length2 = self->board_length2;
#line 260 "nibbles-game.vala"
					_tmp40_ = bonus;
#line 260 "nibbles-game.vala"
					boni_remove_bonus (_tmp38_, _tmp39_, (gint) _tmp39__length1, (gint) _tmp39__length2, _tmp40_);
#line 1347 "nibbles-game.c"
				}
			}
#line 245 "nibbles-game.vala"
			_g_object_unref0 (bonus);
#line 1352 "nibbles-game.c"
		}
#line 245 "nibbles-game.vala"
		_g_object_unref0 (_bonus_list);
#line 1356 "nibbles-game.c"
	}
#line 264 "nibbles-game.vala"
	_tmp41_ = self->priv->_boni;
#line 264 "nibbles-game.vala"
	_tmp42_ = _tmp41_->bonuses;
#line 264 "nibbles-game.vala"
	_tmp43_ = found;
#line 264 "nibbles-game.vala"
	gee_collection_remove_all ((GeeCollection*) _tmp42_, (GeeCollection*) _tmp43_);
#line 267 "nibbles-game.vala"
	_tmp44_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 267 "nibbles-game.vala"
	dead_worms = _tmp44_;
#line 1370 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp45_;
		GeeLinkedList* _tmp46_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _worm_index = 0;
#line 268 "nibbles-game.vala"
		_tmp45_ = self->priv->_worms;
#line 268 "nibbles-game.vala"
		_tmp46_ = _g_object_ref0 (_tmp45_);
#line 268 "nibbles-game.vala"
		_worm_list = _tmp46_;
#line 268 "nibbles-game.vala"
		_tmp47_ = _worm_list;
#line 268 "nibbles-game.vala"
		_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp47_);
#line 268 "nibbles-game.vala"
		_tmp49_ = _tmp48_;
#line 268 "nibbles-game.vala"
		_worm_size = _tmp49_;
#line 268 "nibbles-game.vala"
		_worm_index = -1;
#line 268 "nibbles-game.vala"
		while (TRUE) {
#line 1398 "nibbles-game.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp50_;
			gpointer _tmp51_;
			Worm* _tmp52_;
			Worm* _tmp53_;
			GeeLinkedList* _tmp54_;
			GeeLinkedList* _tmp55_;
			gboolean _tmp56_;
			gboolean _tmp57_;
			Worm* _tmp58_;
			Worm* _tmp85_;
			gint* _tmp86_;
			gint _tmp86__length1;
			gint _tmp86__length2;
			gint _tmp87_;
			Worm* _tmp90_;
			gint* _tmp91_;
			gint _tmp91__length1;
			gint _tmp91__length2;
#line 268 "nibbles-game.vala"
			_worm_index = _worm_index + 1;
#line 268 "nibbles-game.vala"
			if (!(_worm_index < _worm_size)) {
#line 268 "nibbles-game.vala"
				break;
#line 1424 "nibbles-game.c"
			}
#line 268 "nibbles-game.vala"
			_tmp50_ = _worm_list;
#line 268 "nibbles-game.vala"
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _worm_index);
#line 268 "nibbles-game.vala"
			worm = (Worm*) _tmp51_;
#line 270 "nibbles-game.vala"
			_tmp52_ = worm;
#line 270 "nibbles-game.vala"
			if (_tmp52_->is_stopped) {
#line 271 "nibbles-game.vala"
				_g_object_unref0 (worm);
#line 271 "nibbles-game.vala"
				continue;
#line 1440 "nibbles-game.c"
			}
#line 273 "nibbles-game.vala"
			_tmp53_ = worm;
#line 273 "nibbles-game.vala"
			_tmp54_ = worm_get_list (_tmp53_);
#line 273 "nibbles-game.vala"
			_tmp55_ = _tmp54_;
#line 273 "nibbles-game.vala"
			_tmp56_ = gee_collection_get_is_empty ((GeeCollection*) _tmp55_);
#line 273 "nibbles-game.vala"
			_tmp57_ = _tmp56_;
#line 273 "nibbles-game.vala"
			if (_tmp57_) {
#line 274 "nibbles-game.vala"
				_g_object_unref0 (worm);
#line 274 "nibbles-game.vala"
				continue;
#line 1458 "nibbles-game.c"
			}
#line 276 "nibbles-game.vala"
			_tmp58_ = worm;
#line 276 "nibbles-game.vala"
			if (!_tmp58_->is_human) {
#line 1464 "nibbles-game.c"
				Worm* _tmp59_;
				gint* _tmp60_;
				gint _tmp60__length1;
				gint _tmp60__length2;
				gint _tmp61_;
				GeeLinkedList* _tmp62_;
#line 277 "nibbles-game.vala"
				_tmp59_ = worm;
#line 277 "nibbles-game.vala"
				_tmp60_ = self->board;
#line 277 "nibbles-game.vala"
				_tmp60__length1 = self->board_length1;
#line 277 "nibbles-game.vala"
				_tmp60__length2 = self->board_length2;
#line 277 "nibbles-game.vala"
				_tmp61_ = self->priv->_numworms;
#line 277 "nibbles-game.vala"
				_tmp62_ = self->priv->_worms;
#line 277 "nibbles-game.vala"
				worm_ai_move (_tmp59_, _tmp60_, (gint) _tmp60__length1, (gint) _tmp60__length2, _tmp61_, _tmp62_);
#line 1485 "nibbles-game.c"
			}
			{
				GeeLinkedList* _other_worm_list = NULL;
				GeeLinkedList* _tmp63_;
				GeeLinkedList* _tmp64_;
				gint _other_worm_size = 0;
				GeeLinkedList* _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				gint _other_worm_index = 0;
#line 279 "nibbles-game.vala"
				_tmp63_ = self->priv->_worms;
#line 279 "nibbles-game.vala"
				_tmp64_ = _g_object_ref0 (_tmp63_);
#line 279 "nibbles-game.vala"
				_other_worm_list = _tmp64_;
#line 279 "nibbles-game.vala"
				_tmp65_ = _other_worm_list;
#line 279 "nibbles-game.vala"
				_tmp66_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp65_);
#line 279 "nibbles-game.vala"
				_tmp67_ = _tmp66_;
#line 279 "nibbles-game.vala"
				_other_worm_size = _tmp67_;
#line 279 "nibbles-game.vala"
				_other_worm_index = -1;
#line 279 "nibbles-game.vala"
				while (TRUE) {
#line 1514 "nibbles-game.c"
					Worm* other_worm = NULL;
					GeeLinkedList* _tmp68_;
					gpointer _tmp69_;
					gboolean _tmp70_ = FALSE;
					gboolean _tmp71_ = FALSE;
					Worm* _tmp72_;
					Worm* _tmp73_;
#line 279 "nibbles-game.vala"
					_other_worm_index = _other_worm_index + 1;
#line 279 "nibbles-game.vala"
					if (!(_other_worm_index < _other_worm_size)) {
#line 279 "nibbles-game.vala"
						break;
#line 1528 "nibbles-game.c"
					}
#line 279 "nibbles-game.vala"
					_tmp68_ = _other_worm_list;
#line 279 "nibbles-game.vala"
					_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, _other_worm_index);
#line 279 "nibbles-game.vala"
					other_worm = (Worm*) _tmp69_;
#line 281 "nibbles-game.vala"
					_tmp72_ = worm;
#line 281 "nibbles-game.vala"
					_tmp73_ = other_worm;
#line 281 "nibbles-game.vala"
					if (_tmp72_ != _tmp73_) {
#line 1542 "nibbles-game.c"
						Worm* _tmp74_;
#line 282 "nibbles-game.vala"
						_tmp74_ = other_worm;
#line 282 "nibbles-game.vala"
						_tmp71_ = !_tmp74_->is_stopped;
#line 1548 "nibbles-game.c"
					} else {
#line 281 "nibbles-game.vala"
						_tmp71_ = FALSE;
#line 1552 "nibbles-game.c"
					}
#line 281 "nibbles-game.vala"
					if (_tmp71_) {
#line 1556 "nibbles-game.c"
						Worm* _tmp75_;
						Worm* _tmp76_;
#line 283 "nibbles-game.vala"
						_tmp75_ = worm;
#line 283 "nibbles-game.vala"
						_tmp76_ = other_worm;
#line 283 "nibbles-game.vala"
						_tmp70_ = worm_will_collide_with_head (_tmp75_, _tmp76_);
#line 1565 "nibbles-game.c"
					} else {
#line 281 "nibbles-game.vala"
						_tmp70_ = FALSE;
#line 1569 "nibbles-game.c"
					}
#line 281 "nibbles-game.vala"
					if (_tmp70_) {
#line 1573 "nibbles-game.c"
						GeeLinkedList* _tmp77_;
						Worm* _tmp78_;
						GeeLinkedList* _tmp81_;
						Worm* _tmp82_;
#line 285 "nibbles-game.vala"
						_tmp77_ = dead_worms;
#line 285 "nibbles-game.vala"
						_tmp78_ = worm;
#line 285 "nibbles-game.vala"
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp77_, _tmp78_)) {
#line 1584 "nibbles-game.c"
							GeeLinkedList* _tmp79_;
							Worm* _tmp80_;
#line 286 "nibbles-game.vala"
							_tmp79_ = dead_worms;
#line 286 "nibbles-game.vala"
							_tmp80_ = worm;
#line 286 "nibbles-game.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp79_, _tmp80_);
#line 1593 "nibbles-game.c"
						}
#line 287 "nibbles-game.vala"
						_tmp81_ = dead_worms;
#line 287 "nibbles-game.vala"
						_tmp82_ = other_worm;
#line 287 "nibbles-game.vala"
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp81_, _tmp82_)) {
#line 1601 "nibbles-game.c"
							GeeLinkedList* _tmp83_;
							Worm* _tmp84_;
#line 288 "nibbles-game.vala"
							_tmp83_ = dead_worms;
#line 288 "nibbles-game.vala"
							_tmp84_ = other_worm;
#line 288 "nibbles-game.vala"
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, _tmp84_);
#line 1610 "nibbles-game.c"
						}
#line 289 "nibbles-game.vala"
						_g_object_unref0 (other_worm);
#line 289 "nibbles-game.vala"
						continue;
#line 1616 "nibbles-game.c"
					}
#line 279 "nibbles-game.vala"
					_g_object_unref0 (other_worm);
#line 1620 "nibbles-game.c"
				}
#line 279 "nibbles-game.vala"
				_g_object_unref0 (_other_worm_list);
#line 1624 "nibbles-game.c"
			}
#line 293 "nibbles-game.vala"
			_tmp85_ = worm;
#line 293 "nibbles-game.vala"
			_tmp86_ = self->board;
#line 293 "nibbles-game.vala"
			_tmp86__length1 = self->board_length1;
#line 293 "nibbles-game.vala"
			_tmp86__length2 = self->board_length2;
#line 293 "nibbles-game.vala"
			_tmp87_ = self->priv->_numworms;
#line 293 "nibbles-game.vala"
			if (!worm_can_move_to (_tmp85_, _tmp86_, (gint) _tmp86__length1, (gint) _tmp86__length2, _tmp87_)) {
#line 1638 "nibbles-game.c"
				GeeLinkedList* _tmp88_;
				Worm* _tmp89_;
#line 295 "nibbles-game.vala"
				_tmp88_ = dead_worms;
#line 295 "nibbles-game.vala"
				_tmp89_ = worm;
#line 295 "nibbles-game.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp88_, _tmp89_);
#line 296 "nibbles-game.vala"
				_g_object_unref0 (worm);
#line 296 "nibbles-game.vala"
				continue;
#line 1651 "nibbles-game.c"
			}
#line 299 "nibbles-game.vala"
			_tmp90_ = worm;
#line 299 "nibbles-game.vala"
			_tmp91_ = self->board;
#line 299 "nibbles-game.vala"
			_tmp91__length1 = self->board_length1;
#line 299 "nibbles-game.vala"
			_tmp91__length2 = self->board_length2;
#line 299 "nibbles-game.vala"
			worm_move (_tmp90_, _tmp91_, (gint) _tmp91__length1, (gint) _tmp91__length2);
#line 268 "nibbles-game.vala"
			_g_object_unref0 (worm);
#line 1665 "nibbles-game.c"
		}
#line 268 "nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 1669 "nibbles-game.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp92_;
		GeeLinkedList* _tmp93_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _worm_index = 0;
#line 302 "nibbles-game.vala"
		_tmp92_ = dead_worms;
#line 302 "nibbles-game.vala"
		_tmp93_ = _g_object_ref0 (_tmp92_);
#line 302 "nibbles-game.vala"
		_worm_list = _tmp93_;
#line 302 "nibbles-game.vala"
		_tmp94_ = _worm_list;
#line 302 "nibbles-game.vala"
		_tmp95_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp94_);
#line 302 "nibbles-game.vala"
		_tmp96_ = _tmp95_;
#line 302 "nibbles-game.vala"
		_worm_size = _tmp96_;
#line 302 "nibbles-game.vala"
		_worm_index = -1;
#line 302 "nibbles-game.vala"
		while (TRUE) {
#line 1698 "nibbles-game.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp97_;
			gpointer _tmp98_;
			gint _tmp99_;
			Worm* _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
#line 302 "nibbles-game.vala"
			_worm_index = _worm_index + 1;
#line 302 "nibbles-game.vala"
			if (!(_worm_index < _worm_size)) {
#line 302 "nibbles-game.vala"
				break;
#line 1712 "nibbles-game.c"
			}
#line 302 "nibbles-game.vala"
			_tmp97_ = _worm_list;
#line 302 "nibbles-game.vala"
			_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, _worm_index);
#line 302 "nibbles-game.vala"
			worm = (Worm*) _tmp98_;
#line 304 "nibbles-game.vala"
			_tmp99_ = self->priv->_numworms;
#line 304 "nibbles-game.vala"
			if (_tmp99_ > 1) {
#line 1724 "nibbles-game.c"
				Worm* _tmp100_;
				Worm* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
#line 305 "nibbles-game.vala"
				_tmp100_ = worm;
#line 305 "nibbles-game.vala"
				_tmp101_ = worm;
#line 305 "nibbles-game.vala"
				_tmp102_ = worm_get_score (_tmp101_);
#line 305 "nibbles-game.vala"
				_tmp103_ = _tmp102_;
#line 305 "nibbles-game.vala"
				worm_set_score (_tmp100_, (_tmp103_ * 7) / 10);
#line 1739 "nibbles-game.c"
			}
#line 307 "nibbles-game.vala"
			_tmp104_ = worm;
#line 307 "nibbles-game.vala"
			_tmp105_ = worm_get_lives (_tmp104_);
#line 307 "nibbles-game.vala"
			_tmp106_ = _tmp105_;
#line 307 "nibbles-game.vala"
			if (_tmp106_ > 0) {
#line 1749 "nibbles-game.c"
				Worm* _tmp107_;
				gint* _tmp108_;
				gint _tmp108__length1;
				gint _tmp108__length2;
#line 308 "nibbles-game.vala"
				_tmp107_ = worm;
#line 308 "nibbles-game.vala"
				_tmp108_ = self->board;
#line 308 "nibbles-game.vala"
				_tmp108__length1 = self->board_length1;
#line 308 "nibbles-game.vala"
				_tmp108__length2 = self->board_length2;
#line 308 "nibbles-game.vala"
				worm_reset (_tmp107_, _tmp108_, (gint) _tmp108__length1, (gint) _tmp108__length2);
#line 1764 "nibbles-game.c"
			}
#line 302 "nibbles-game.vala"
			_g_object_unref0 (worm);
#line 1768 "nibbles-game.c"
		}
#line 302 "nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 1772 "nibbles-game.c"
	}
#line 231 "nibbles-game.vala"
	_g_object_unref0 (dead_worms);
#line 231 "nibbles-game.vala"
	_g_object_unref0 (found);
#line 1778 "nibbles-game.c"
}

static void
nibbles_game_reverse_worms (NibblesGame* self,
                            Worm* worm)
{
#line 312 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 312 "nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 1789 "nibbles-game.c"
	{
		GeeLinkedList* _other_worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _other_worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _other_worm_index = 0;
#line 314 "nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 314 "nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 314 "nibbles-game.vala"
		_other_worm_list = _tmp1_;
#line 314 "nibbles-game.vala"
		_tmp2_ = _other_worm_list;
#line 314 "nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 314 "nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 314 "nibbles-game.vala"
		_other_worm_size = _tmp4_;
#line 314 "nibbles-game.vala"
		_other_worm_index = -1;
#line 314 "nibbles-game.vala"
		while (TRUE) {
#line 1817 "nibbles-game.c"
			Worm* other_worm = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			Worm* _tmp7_;
#line 314 "nibbles-game.vala"
			_other_worm_index = _other_worm_index + 1;
#line 314 "nibbles-game.vala"
			if (!(_other_worm_index < _other_worm_size)) {
#line 314 "nibbles-game.vala"
				break;
#line 1828 "nibbles-game.c"
			}
#line 314 "nibbles-game.vala"
			_tmp5_ = _other_worm_list;
#line 314 "nibbles-game.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _other_worm_index);
#line 314 "nibbles-game.vala"
			other_worm = (Worm*) _tmp6_;
#line 315 "nibbles-game.vala"
			_tmp7_ = other_worm;
#line 315 "nibbles-game.vala"
			if (worm != _tmp7_) {
#line 1840 "nibbles-game.c"
				Worm* _tmp8_;
				gint* _tmp9_;
				gint _tmp9__length1;
				gint _tmp9__length2;
#line 316 "nibbles-game.vala"
				_tmp8_ = other_worm;
#line 316 "nibbles-game.vala"
				_tmp9_ = self->board;
#line 316 "nibbles-game.vala"
				_tmp9__length1 = self->board_length1;
#line 316 "nibbles-game.vala"
				_tmp9__length2 = self->board_length2;
#line 316 "nibbles-game.vala"
				worm_reverse (_tmp8_, _tmp9_, (gint) _tmp9__length1, (gint) _tmp9__length2);
#line 1855 "nibbles-game.c"
			}
#line 314 "nibbles-game.vala"
			_g_object_unref0 (other_worm);
#line 1859 "nibbles-game.c"
		}
#line 314 "nibbles-game.vala"
		_g_object_unref0 (_other_worm_list);
#line 1863 "nibbles-game.c"
	}
}

void
nibbles_game_add_bonus (NibblesGame* self,
                        gboolean regular)
{
	gboolean good = FALSE;
	gint x = 0;
	gint y = 0;
#line 323 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 325 "nibbles-game.vala"
	good = FALSE;
#line 326 "nibbles-game.vala"
	x = 0;
#line 326 "nibbles-game.vala"
	y = 0;
#line 328 "nibbles-game.vala"
	if (!regular) {
#line 330 "nibbles-game.vala"
		if (g_random_int_range ((gint32) 0, (gint32) 50) != ((gint32) 0)) {
#line 331 "nibbles-game.vala"
			return;
#line 1888 "nibbles-game.c"
		}
	}
	{
		gboolean _tmp0_ = FALSE;
#line 334 "nibbles-game.vala"
		_tmp0_ = TRUE;
#line 334 "nibbles-game.vala"
		while (TRUE) {
#line 1897 "nibbles-game.c"
			gint* _tmp1_;
			gint _tmp1__length1;
			gint _tmp1__length2;
			gint _tmp2_;
			gint* _tmp3_;
			gint _tmp3__length1;
			gint _tmp3__length2;
			gint _tmp4_;
			gint* _tmp5_;
			gint _tmp5__length1;
			gint _tmp5__length2;
			gint _tmp6_;
			gint* _tmp7_;
			gint _tmp7__length1;
			gint _tmp7__length2;
			gint _tmp8_;
#line 334 "nibbles-game.vala"
			if (!_tmp0_) {
#line 348 "nibbles-game.vala"
				if (!(!good)) {
#line 348 "nibbles-game.vala"
					break;
#line 1920 "nibbles-game.c"
				}
			}
#line 334 "nibbles-game.vala"
			_tmp0_ = FALSE;
#line 336 "nibbles-game.vala"
			good = TRUE;
#line 337 "nibbles-game.vala"
			x = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
#line 338 "nibbles-game.vala"
			y = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
#line 340 "nibbles-game.vala"
			_tmp1_ = self->board;
#line 340 "nibbles-game.vala"
			_tmp1__length1 = self->board_length1;
#line 340 "nibbles-game.vala"
			_tmp1__length2 = self->board_length2;
#line 340 "nibbles-game.vala"
			_tmp2_ = _tmp1_[(x * _tmp1__length2) + y];
#line 340 "nibbles-game.vala"
			if (_tmp2_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 341 "nibbles-game.vala"
				good = FALSE;
#line 1943 "nibbles-game.c"
			}
#line 342 "nibbles-game.vala"
			_tmp3_ = self->board;
#line 342 "nibbles-game.vala"
			_tmp3__length1 = self->board_length1;
#line 342 "nibbles-game.vala"
			_tmp3__length2 = self->board_length2;
#line 342 "nibbles-game.vala"
			_tmp4_ = _tmp3_[((x + 1) * _tmp3__length2) + y];
#line 342 "nibbles-game.vala"
			if (_tmp4_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 343 "nibbles-game.vala"
				good = FALSE;
#line 1957 "nibbles-game.c"
			}
#line 344 "nibbles-game.vala"
			_tmp5_ = self->board;
#line 344 "nibbles-game.vala"
			_tmp5__length1 = self->board_length1;
#line 344 "nibbles-game.vala"
			_tmp5__length2 = self->board_length2;
#line 344 "nibbles-game.vala"
			_tmp6_ = _tmp5_[(x * _tmp5__length2) + (y + 1)];
#line 344 "nibbles-game.vala"
			if (_tmp6_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 345 "nibbles-game.vala"
				good = FALSE;
#line 1971 "nibbles-game.c"
			}
#line 346 "nibbles-game.vala"
			_tmp7_ = self->board;
#line 346 "nibbles-game.vala"
			_tmp7__length1 = self->board_length1;
#line 346 "nibbles-game.vala"
			_tmp7__length2 = self->board_length2;
#line 346 "nibbles-game.vala"
			_tmp8_ = _tmp7_[((x + 1) * _tmp7__length2) + (y + 1)];
#line 346 "nibbles-game.vala"
			if (_tmp8_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 347 "nibbles-game.vala"
				good = FALSE;
#line 1985 "nibbles-game.c"
			}
		}
	}
#line 350 "nibbles-game.vala"
	if (regular) {
#line 1991 "nibbles-game.c"
		gboolean _tmp9_ = FALSE;
		Boni* _tmp21_;
		gint* _tmp22_;
		gint _tmp22__length1;
		gint _tmp22__length2;
#line 352 "nibbles-game.vala"
		if (g_random_int_range ((gint32) 0, (gint32) 7) == ((gint32) 0)) {
#line 1999 "nibbles-game.c"
			gboolean _tmp10_;
#line 352 "nibbles-game.vala"
			_tmp10_ = self->priv->_fakes;
#line 352 "nibbles-game.vala"
			_tmp9_ = _tmp10_;
#line 2005 "nibbles-game.c"
		} else {
#line 352 "nibbles-game.vala"
			_tmp9_ = FALSE;
#line 2009 "nibbles-game.c"
		}
#line 352 "nibbles-game.vala"
		if (_tmp9_) {
#line 2013 "nibbles-game.c"
			Boni* _tmp11_;
			gint* _tmp12_;
			gint _tmp12__length1;
			gint _tmp12__length2;
#line 353 "nibbles-game.vala"
			_tmp11_ = self->priv->_boni;
#line 353 "nibbles-game.vala"
			_tmp12_ = self->board;
#line 353 "nibbles-game.vala"
			_tmp12__length1 = self->board_length1;
#line 353 "nibbles-game.vala"
			_tmp12__length2 = self->board_length2;
#line 353 "nibbles-game.vala"
			boni_add_bonus (_tmp11_, _tmp12_, (gint) _tmp12__length1, (gint) _tmp12__length2, x, y, BONUS_TYPE_REGULAR, TRUE, 300);
#line 2028 "nibbles-game.c"
		}
#line 355 "nibbles-game.vala"
		good = FALSE;
#line 356 "nibbles-game.vala"
		while (TRUE) {
#line 2034 "nibbles-game.c"
			gint* _tmp13_;
			gint _tmp13__length1;
			gint _tmp13__length2;
			gint _tmp14_;
			gint* _tmp15_;
			gint _tmp15__length1;
			gint _tmp15__length2;
			gint _tmp16_;
			gint* _tmp17_;
			gint _tmp17__length1;
			gint _tmp17__length2;
			gint _tmp18_;
			gint* _tmp19_;
			gint _tmp19__length1;
			gint _tmp19__length2;
			gint _tmp20_;
#line 356 "nibbles-game.vala"
			if (!(!good)) {
#line 356 "nibbles-game.vala"
				break;
#line 2055 "nibbles-game.c"
			}
#line 358 "nibbles-game.vala"
			good = TRUE;
#line 360 "nibbles-game.vala"
			x = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_WIDTH - 1));
#line 361 "nibbles-game.vala"
			y = (gint) g_random_int_range ((gint32) 0, (gint32) (NIBBLES_GAME_HEIGHT - 1));
#line 362 "nibbles-game.vala"
			_tmp13_ = self->board;
#line 362 "nibbles-game.vala"
			_tmp13__length1 = self->board_length1;
#line 362 "nibbles-game.vala"
			_tmp13__length2 = self->board_length2;
#line 362 "nibbles-game.vala"
			_tmp14_ = _tmp13_[(x * _tmp13__length2) + y];
#line 362 "nibbles-game.vala"
			if (_tmp14_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 363 "nibbles-game.vala"
				good = FALSE;
#line 2075 "nibbles-game.c"
			}
#line 364 "nibbles-game.vala"
			_tmp15_ = self->board;
#line 364 "nibbles-game.vala"
			_tmp15__length1 = self->board_length1;
#line 364 "nibbles-game.vala"
			_tmp15__length2 = self->board_length2;
#line 364 "nibbles-game.vala"
			_tmp16_ = _tmp15_[((x + 1) * _tmp15__length2) + y];
#line 364 "nibbles-game.vala"
			if (_tmp16_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 365 "nibbles-game.vala"
				good = FALSE;
#line 2089 "nibbles-game.c"
			}
#line 366 "nibbles-game.vala"
			_tmp17_ = self->board;
#line 366 "nibbles-game.vala"
			_tmp17__length1 = self->board_length1;
#line 366 "nibbles-game.vala"
			_tmp17__length2 = self->board_length2;
#line 366 "nibbles-game.vala"
			_tmp18_ = _tmp17_[(x * _tmp17__length2) + (y + 1)];
#line 366 "nibbles-game.vala"
			if (_tmp18_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 367 "nibbles-game.vala"
				good = FALSE;
#line 2103 "nibbles-game.c"
			}
#line 368 "nibbles-game.vala"
			_tmp19_ = self->board;
#line 368 "nibbles-game.vala"
			_tmp19__length1 = self->board_length1;
#line 368 "nibbles-game.vala"
			_tmp19__length2 = self->board_length2;
#line 368 "nibbles-game.vala"
			_tmp20_ = _tmp19_[((x + 1) * _tmp19__length2) + (y + 1)];
#line 368 "nibbles-game.vala"
			if (_tmp20_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 369 "nibbles-game.vala"
				good = FALSE;
#line 2117 "nibbles-game.c"
			}
		}
#line 371 "nibbles-game.vala"
		_tmp21_ = self->priv->_boni;
#line 371 "nibbles-game.vala"
		_tmp22_ = self->board;
#line 371 "nibbles-game.vala"
		_tmp22__length1 = self->board_length1;
#line 371 "nibbles-game.vala"
		_tmp22__length2 = self->board_length2;
#line 371 "nibbles-game.vala"
		boni_add_bonus (_tmp21_, _tmp22_, (gint) _tmp22__length1, (gint) _tmp22__length2, x, y, BONUS_TYPE_REGULAR, FALSE, 300);
#line 2130 "nibbles-game.c"
	} else {
		Boni* _tmp23_;
#line 373 "nibbles-game.vala"
		_tmp23_ = self->priv->_boni;
#line 373 "nibbles-game.vala"
		if (_tmp23_->missed <= BONI_MAX_MISSED) {
#line 2137 "nibbles-game.c"
			gboolean _tmp24_ = FALSE;
#line 375 "nibbles-game.vala"
			if (g_random_int_range ((gint32) 0, (gint32) 7) != ((gint32) 0)) {
#line 376 "nibbles-game.vala"
				good = FALSE;
#line 2143 "nibbles-game.c"
			} else {
#line 378 "nibbles-game.vala"
				good = TRUE;
#line 2147 "nibbles-game.c"
			}
#line 380 "nibbles-game.vala"
			if (good) {
#line 2151 "nibbles-game.c"
				gboolean _tmp25_;
#line 380 "nibbles-game.vala"
				_tmp25_ = self->priv->_fakes;
#line 380 "nibbles-game.vala"
				_tmp24_ = !_tmp25_;
#line 2157 "nibbles-game.c"
			} else {
#line 380 "nibbles-game.vala"
				_tmp24_ = FALSE;
#line 2161 "nibbles-game.c"
			}
#line 380 "nibbles-game.vala"
			if (_tmp24_) {
#line 381 "nibbles-game.vala"
				return;
#line 2167 "nibbles-game.c"
			}
#line 383 "nibbles-game.vala"
			switch (g_random_int_range ((gint32) 0, (gint32) 21)) {
#line 383 "nibbles-game.vala"
				case 0:
#line 383 "nibbles-game.vala"
				case 1:
#line 383 "nibbles-game.vala"
				case 2:
#line 383 "nibbles-game.vala"
				case 3:
#line 383 "nibbles-game.vala"
				case 4:
#line 383 "nibbles-game.vala"
				case 5:
#line 383 "nibbles-game.vala"
				case 6:
#line 383 "nibbles-game.vala"
				case 7:
#line 383 "nibbles-game.vala"
				case 8:
#line 383 "nibbles-game.vala"
				case 9:
#line 2191 "nibbles-game.c"
				{
					Boni* _tmp26_;
					gint* _tmp27_;
					gint _tmp27__length1;
					gint _tmp27__length2;
#line 395 "nibbles-game.vala"
					_tmp26_ = self->priv->_boni;
#line 395 "nibbles-game.vala"
					_tmp27_ = self->board;
#line 395 "nibbles-game.vala"
					_tmp27__length1 = self->board_length1;
#line 395 "nibbles-game.vala"
					_tmp27__length2 = self->board_length2;
#line 395 "nibbles-game.vala"
					boni_add_bonus (_tmp26_, _tmp27_, (gint) _tmp27__length1, (gint) _tmp27__length2, x, y, BONUS_TYPE_HALF, good, 200);
#line 396 "nibbles-game.vala"
					break;
#line 2209 "nibbles-game.c"
				}
#line 383 "nibbles-game.vala"
				case 10:
#line 383 "nibbles-game.vala"
				case 11:
#line 383 "nibbles-game.vala"
				case 12:
#line 383 "nibbles-game.vala"
				case 13:
#line 383 "nibbles-game.vala"
				case 14:
#line 2221 "nibbles-game.c"
				{
					Boni* _tmp28_;
					gint* _tmp29_;
					gint _tmp29__length1;
					gint _tmp29__length2;
#line 402 "nibbles-game.vala"
					_tmp28_ = self->priv->_boni;
#line 402 "nibbles-game.vala"
					_tmp29_ = self->board;
#line 402 "nibbles-game.vala"
					_tmp29__length1 = self->board_length1;
#line 402 "nibbles-game.vala"
					_tmp29__length2 = self->board_length2;
#line 402 "nibbles-game.vala"
					boni_add_bonus (_tmp28_, _tmp29_, (gint) _tmp29__length1, (gint) _tmp29__length2, x, y, BONUS_TYPE_DOUBLE, good, 150);
#line 403 "nibbles-game.vala"
					break;
#line 2239 "nibbles-game.c"
				}
#line 383 "nibbles-game.vala"
				case 15:
#line 2243 "nibbles-game.c"
				{
					Boni* _tmp30_;
					gint* _tmp31_;
					gint _tmp31__length1;
					gint _tmp31__length2;
#line 405 "nibbles-game.vala"
					_tmp30_ = self->priv->_boni;
#line 405 "nibbles-game.vala"
					_tmp31_ = self->board;
#line 405 "nibbles-game.vala"
					_tmp31__length1 = self->board_length1;
#line 405 "nibbles-game.vala"
					_tmp31__length2 = self->board_length2;
#line 405 "nibbles-game.vala"
					boni_add_bonus (_tmp30_, _tmp31_, (gint) _tmp31__length1, (gint) _tmp31__length2, x, y, BONUS_TYPE_LIFE, good, 100);
#line 406 "nibbles-game.vala"
					break;
#line 2261 "nibbles-game.c"
				}
#line 383 "nibbles-game.vala"
				case 16:
#line 383 "nibbles-game.vala"
				case 17:
#line 383 "nibbles-game.vala"
				case 18:
#line 383 "nibbles-game.vala"
				case 19:
#line 383 "nibbles-game.vala"
				case 20:
#line 2273 "nibbles-game.c"
				{
					gint _tmp32_;
#line 412 "nibbles-game.vala"
					_tmp32_ = self->priv->_numworms;
#line 412 "nibbles-game.vala"
					if (_tmp32_ > 1) {
#line 2280 "nibbles-game.c"
						Boni* _tmp33_;
						gint* _tmp34_;
						gint _tmp34__length1;
						gint _tmp34__length2;
#line 413 "nibbles-game.vala"
						_tmp33_ = self->priv->_boni;
#line 413 "nibbles-game.vala"
						_tmp34_ = self->board;
#line 413 "nibbles-game.vala"
						_tmp34__length1 = self->board_length1;
#line 413 "nibbles-game.vala"
						_tmp34__length2 = self->board_length2;
#line 413 "nibbles-game.vala"
						boni_add_bonus (_tmp33_, _tmp34_, (gint) _tmp34__length1, (gint) _tmp34__length2, x, y, BONUS_TYPE_REVERSE, good, 150);
#line 2295 "nibbles-game.c"
					}
#line 414 "nibbles-game.vala"
					break;
#line 2299 "nibbles-game.c"
				}
				default:
#line 383 "nibbles-game.vala"
				break;
#line 2304 "nibbles-game.c"
			}
		}
	}
}

void
nibbles_game_apply_bonus (NibblesGame* self,
                          Bonus* bonus,
                          Worm* worm)
{
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	Position _tmp2_ = {0};
	Position _tmp3_;
	Position _tmp4_ = {0};
	Position _tmp5_;
	gint _tmp6_;
#line 419 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 419 "nibbles-game.vala"
	g_return_if_fail (bonus != NULL);
#line 419 "nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 421 "nibbles-game.vala"
	if (bonus->fake) {
#line 2331 "nibbles-game.c"
		gint* _tmp0_;
		gint _tmp0__length1;
		gint _tmp0__length2;
#line 423 "nibbles-game.vala"
		_tmp0_ = self->board;
#line 423 "nibbles-game.vala"
		_tmp0__length1 = self->board_length1;
#line 423 "nibbles-game.vala"
		_tmp0__length2 = self->board_length2;
#line 423 "nibbles-game.vala"
		worm_reverse (worm, _tmp0_, (gint) _tmp0__length1, (gint) _tmp0__length2);
#line 425 "nibbles-game.vala"
		return;
#line 2345 "nibbles-game.c"
	}
#line 428 "nibbles-game.vala"
	_tmp1_ = self->board;
#line 428 "nibbles-game.vala"
	_tmp1__length1 = self->board_length1;
#line 428 "nibbles-game.vala"
	_tmp1__length2 = self->board_length2;
#line 428 "nibbles-game.vala"
	worm_get_head (worm, &_tmp2_);
#line 428 "nibbles-game.vala"
	_tmp3_ = _tmp2_;
#line 428 "nibbles-game.vala"
	worm_get_head (worm, &_tmp4_);
#line 428 "nibbles-game.vala"
	_tmp5_ = _tmp4_;
#line 428 "nibbles-game.vala"
	_tmp6_ = _tmp1_[(_tmp3_.x * _tmp1__length2) + _tmp5_.y];
#line 428 "nibbles-game.vala"
	switch (_tmp6_ - 'A') {
#line 428 "nibbles-game.vala"
		case BONUS_TYPE_REGULAR:
#line 2367 "nibbles-game.c"
		{
			Boni* _tmp7_;
			gint _tmp8_;
			Boni* _tmp9_;
			Boni* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			Boni* _tmp13_;
			Boni* _tmp14_;
			gint _tmp15_;
#line 431 "nibbles-game.vala"
			_tmp7_ = self->priv->_boni;
#line 431 "nibbles-game.vala"
			_tmp8_ = _tmp7_->numleft;
#line 431 "nibbles-game.vala"
			_tmp7_->numleft = _tmp8_ - 1;
#line 432 "nibbles-game.vala"
			_tmp9_ = self->priv->_boni;
#line 432 "nibbles-game.vala"
			_tmp10_ = self->priv->_boni;
#line 432 "nibbles-game.vala"
			worm->change = worm->change + ((_tmp9_->numboni - _tmp10_->numleft) * WORM_GROW_FACTOR);
#line 433 "nibbles-game.vala"
			_tmp11_ = worm_get_score (worm);
#line 433 "nibbles-game.vala"
			_tmp12_ = _tmp11_;
#line 433 "nibbles-game.vala"
			_tmp13_ = self->priv->_boni;
#line 433 "nibbles-game.vala"
			_tmp14_ = self->priv->_boni;
#line 433 "nibbles-game.vala"
			_tmp15_ = self->priv->_current_level;
#line 433 "nibbles-game.vala"
			worm_set_score (worm, _tmp12_ + ((_tmp13_->numboni - _tmp14_->numleft) * _tmp15_));
#line 434 "nibbles-game.vala"
			break;
#line 2404 "nibbles-game.c"
		}
#line 428 "nibbles-game.vala"
		case BONUS_TYPE_DOUBLE:
#line 2408 "nibbles-game.c"
		{
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
#line 436 "nibbles-game.vala"
			_tmp16_ = worm_get_score (worm);
#line 436 "nibbles-game.vala"
			_tmp17_ = _tmp16_;
#line 436 "nibbles-game.vala"
			_tmp18_ = worm_get_length (worm);
#line 436 "nibbles-game.vala"
			_tmp19_ = _tmp18_;
#line 436 "nibbles-game.vala"
			_tmp20_ = self->priv->_current_level;
#line 436 "nibbles-game.vala"
			worm_set_score (worm, _tmp17_ + ((_tmp19_ + worm->change) * _tmp20_));
#line 437 "nibbles-game.vala"
			_tmp21_ = worm_get_length (worm);
#line 437 "nibbles-game.vala"
			_tmp22_ = _tmp21_;
#line 437 "nibbles-game.vala"
			worm->change = worm->change + (_tmp22_ + worm->change);
#line 438 "nibbles-game.vala"
			break;
#line 2437 "nibbles-game.c"
		}
#line 428 "nibbles-game.vala"
		case BONUS_TYPE_HALF:
#line 2441 "nibbles-game.c"
		{
			gint _tmp23_;
			gint _tmp24_;
#line 440 "nibbles-game.vala"
			_tmp23_ = worm_get_length (worm);
#line 440 "nibbles-game.vala"
			_tmp24_ = _tmp23_;
#line 440 "nibbles-game.vala"
			if ((_tmp24_ + worm->change) > 2) {
#line 2451 "nibbles-game.c"
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint* _tmp30_;
				gint _tmp30__length1;
				gint _tmp30__length2;
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
#line 442 "nibbles-game.vala"
				_tmp25_ = worm_get_score (worm);
#line 442 "nibbles-game.vala"
				_tmp26_ = _tmp25_;
#line 442 "nibbles-game.vala"
				_tmp27_ = worm_get_length (worm);
#line 442 "nibbles-game.vala"
				_tmp28_ = _tmp27_;
#line 442 "nibbles-game.vala"
				_tmp29_ = self->priv->_current_level;
#line 442 "nibbles-game.vala"
				worm_set_score (worm, _tmp26_ + ((_tmp28_ + (worm->change / 2)) * _tmp29_));
#line 443 "nibbles-game.vala"
				_tmp30_ = self->board;
#line 443 "nibbles-game.vala"
				_tmp30__length1 = self->board_length1;
#line 443 "nibbles-game.vala"
				_tmp30__length2 = self->board_length2;
#line 443 "nibbles-game.vala"
				_tmp31_ = worm_get_length (worm);
#line 443 "nibbles-game.vala"
				_tmp32_ = _tmp31_;
#line 443 "nibbles-game.vala"
				worm_reduce_tail (worm, _tmp30_, (gint) _tmp30__length1, (gint) _tmp30__length2, _tmp32_ / 2);
#line 444 "nibbles-game.vala"
				_tmp33_ = worm_get_length (worm);
#line 444 "nibbles-game.vala"
				_tmp34_ = _tmp33_;
#line 444 "nibbles-game.vala"
				worm->change = worm->change - ((_tmp34_ + worm->change) / 2);
#line 2494 "nibbles-game.c"
			}
#line 446 "nibbles-game.vala"
			break;
#line 2498 "nibbles-game.c"
		}
#line 428 "nibbles-game.vala"
		case BONUS_TYPE_LIFE:
#line 2502 "nibbles-game.c"
		{
#line 448 "nibbles-game.vala"
			worm_add_life (worm);
#line 449 "nibbles-game.vala"
			break;
#line 2508 "nibbles-game.c"
		}
#line 428 "nibbles-game.vala"
		case BONUS_TYPE_REVERSE:
#line 2512 "nibbles-game.c"
		{
#line 451 "nibbles-game.vala"
			nibbles_game_reverse_worms (self, worm);
#line 452 "nibbles-game.vala"
			break;
#line 2518 "nibbles-game.c"
		}
		default:
#line 428 "nibbles-game.vala"
		break;
#line 2523 "nibbles-game.c"
	}
}

gboolean
nibbles_game_add_bonus_cb (NibblesGame* self)
{
	gboolean result = FALSE;
#line 456 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 458 "nibbles-game.vala"
	nibbles_game_add_bonus (self, FALSE);
#line 460 "nibbles-game.vala"
	result = G_SOURCE_CONTINUE;
#line 460 "nibbles-game.vala"
	return result;
#line 2539 "nibbles-game.c"
}

void
nibbles_game_bonus_found_cb (NibblesGame* self,
                             Worm* worm)
{
	Bonus* bonus = NULL;
	Boni* _tmp0_;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	Position _tmp2_ = {0};
	Position _tmp3_;
	Position _tmp4_ = {0};
	Position _tmp5_;
	Bonus* _tmp6_;
	Bonus* _tmp7_;
	Bonus* _tmp8_;
	Bonus* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	Position _tmp12_ = {0};
	Position _tmp13_;
	Position _tmp14_ = {0};
	Position _tmp15_;
	gint _tmp16_;
#line 463 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 463 "nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 465 "nibbles-game.vala"
	_tmp0_ = self->priv->_boni;
#line 465 "nibbles-game.vala"
	_tmp1_ = self->board;
#line 465 "nibbles-game.vala"
	_tmp1__length1 = self->board_length1;
#line 465 "nibbles-game.vala"
	_tmp1__length2 = self->board_length2;
#line 465 "nibbles-game.vala"
	worm_get_head (worm, &_tmp2_);
#line 465 "nibbles-game.vala"
	_tmp3_ = _tmp2_;
#line 465 "nibbles-game.vala"
	worm_get_head (worm, &_tmp4_);
#line 465 "nibbles-game.vala"
	_tmp5_ = _tmp4_;
#line 465 "nibbles-game.vala"
	_tmp6_ = boni_get_bonus (_tmp0_, _tmp1_, (gint) _tmp1__length1, (gint) _tmp1__length2, _tmp3_.x, _tmp5_.y);
#line 465 "nibbles-game.vala"
	bonus = _tmp6_;
#line 466 "nibbles-game.vala"
	_tmp7_ = bonus;
#line 466 "nibbles-game.vala"
	if (_tmp7_ == NULL) {
#line 467 "nibbles-game.vala"
		_g_object_unref0 (bonus);
#line 467 "nibbles-game.vala"
		return;
#line 2600 "nibbles-game.c"
	}
#line 468 "nibbles-game.vala"
	_tmp8_ = bonus;
#line 468 "nibbles-game.vala"
	nibbles_game_apply_bonus (self, _tmp8_, worm);
#line 469 "nibbles-game.vala"
	_tmp9_ = bonus;
#line 469 "nibbles-game.vala"
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL], 0, _tmp9_, worm);
#line 471 "nibbles-game.vala"
	_tmp11_ = self->board;
#line 471 "nibbles-game.vala"
	_tmp11__length1 = self->board_length1;
#line 471 "nibbles-game.vala"
	_tmp11__length2 = self->board_length2;
#line 471 "nibbles-game.vala"
	worm_get_head (worm, &_tmp12_);
#line 471 "nibbles-game.vala"
	_tmp13_ = _tmp12_;
#line 471 "nibbles-game.vala"
	worm_get_head (worm, &_tmp14_);
#line 471 "nibbles-game.vala"
	_tmp15_ = _tmp14_;
#line 471 "nibbles-game.vala"
	_tmp16_ = _tmp11_[(_tmp13_.x * _tmp11__length2) + _tmp15_.y];
#line 471 "nibbles-game.vala"
	if (_tmp16_ == ((gint) (BONUS_TYPE_REGULAR + 'A'))) {
#line 2628 "nibbles-game.c"
		Bonus* _tmp17_;
#line 472 "nibbles-game.vala"
		_tmp17_ = bonus;
#line 472 "nibbles-game.vala"
		_tmp10_ = !_tmp17_->fake;
#line 2634 "nibbles-game.c"
	} else {
#line 471 "nibbles-game.vala"
		_tmp10_ = FALSE;
#line 2638 "nibbles-game.c"
	}
#line 471 "nibbles-game.vala"
	if (_tmp10_) {
#line 2642 "nibbles-game.c"
		Boni* _tmp18_;
		gint* _tmp19_;
		gint _tmp19__length1;
		gint _tmp19__length2;
		Bonus* _tmp20_;
		Boni* _tmp21_;
		GeeLinkedList* _tmp22_;
		Bonus* _tmp23_;
		Boni* _tmp24_;
#line 475 "nibbles-game.vala"
		_tmp18_ = self->priv->_boni;
#line 475 "nibbles-game.vala"
		_tmp19_ = self->board;
#line 475 "nibbles-game.vala"
		_tmp19__length1 = self->board_length1;
#line 475 "nibbles-game.vala"
		_tmp19__length2 = self->board_length2;
#line 475 "nibbles-game.vala"
		_tmp20_ = bonus;
#line 475 "nibbles-game.vala"
		boni_remove_bonus (_tmp18_, _tmp19_, (gint) _tmp19__length1, (gint) _tmp19__length2, _tmp20_);
#line 476 "nibbles-game.vala"
		_tmp21_ = self->priv->_boni;
#line 476 "nibbles-game.vala"
		_tmp22_ = _tmp21_->bonuses;
#line 476 "nibbles-game.vala"
		_tmp23_ = bonus;
#line 476 "nibbles-game.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp22_, _tmp23_);
#line 478 "nibbles-game.vala"
		_tmp24_ = self->priv->_boni;
#line 478 "nibbles-game.vala"
		if (_tmp24_->numleft != 0) {
#line 479 "nibbles-game.vala"
			nibbles_game_add_bonus (self, TRUE);
#line 2678 "nibbles-game.c"
		}
	} else {
		Boni* _tmp25_;
		gint* _tmp26_;
		gint _tmp26__length1;
		gint _tmp26__length2;
		Bonus* _tmp27_;
		Boni* _tmp28_;
		GeeLinkedList* _tmp29_;
		Bonus* _tmp30_;
#line 484 "nibbles-game.vala"
		_tmp25_ = self->priv->_boni;
#line 484 "nibbles-game.vala"
		_tmp26_ = self->board;
#line 484 "nibbles-game.vala"
		_tmp26__length1 = self->board_length1;
#line 484 "nibbles-game.vala"
		_tmp26__length2 = self->board_length2;
#line 484 "nibbles-game.vala"
		_tmp27_ = bonus;
#line 484 "nibbles-game.vala"
		boni_remove_bonus (_tmp25_, _tmp26_, (gint) _tmp26__length1, (gint) _tmp26__length2, _tmp27_);
#line 485 "nibbles-game.vala"
		_tmp28_ = self->priv->_boni;
#line 485 "nibbles-game.vala"
		_tmp29_ = _tmp28_->bonuses;
#line 485 "nibbles-game.vala"
		_tmp30_ = bonus;
#line 485 "nibbles-game.vala"
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp29_, _tmp30_);
#line 2709 "nibbles-game.c"
	}
#line 463 "nibbles-game.vala"
	_g_object_unref0 (bonus);
#line 2713 "nibbles-game.c"
}

void
nibbles_game_warp_found_cb (NibblesGame* self,
                            Worm* worm)
{
	Warp* warp = NULL;
	WarpManager* _tmp0_;
	Position _tmp1_ = {0};
	Position _tmp2_;
	Position _tmp3_ = {0};
	Position _tmp4_;
	Warp* _tmp5_;
	Warp* _tmp6_;
	Warp* _tmp7_;
#line 489 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 489 "nibbles-game.vala"
	g_return_if_fail (worm != NULL);
#line 491 "nibbles-game.vala"
	_tmp0_ = self->priv->_warp_manager;
#line 491 "nibbles-game.vala"
	worm_get_head (worm, &_tmp1_);
#line 491 "nibbles-game.vala"
	_tmp2_ = _tmp1_;
#line 491 "nibbles-game.vala"
	worm_get_head (worm, &_tmp3_);
#line 491 "nibbles-game.vala"
	_tmp4_ = _tmp3_;
#line 491 "nibbles-game.vala"
	_tmp5_ = warp_manager_get_warp (_tmp0_, _tmp2_.x, _tmp4_.y);
#line 491 "nibbles-game.vala"
	warp = _tmp5_;
#line 492 "nibbles-game.vala"
	_tmp6_ = warp;
#line 492 "nibbles-game.vala"
	if (_tmp6_ == NULL) {
#line 493 "nibbles-game.vala"
		_g_object_unref0 (warp);
#line 493 "nibbles-game.vala"
		return;
#line 2755 "nibbles-game.c"
	}
#line 495 "nibbles-game.vala"
	_tmp7_ = warp;
#line 495 "nibbles-game.vala"
	worm_warp (worm, _tmp7_);
#line 489 "nibbles-game.vala"
	_g_object_unref0 (warp);
#line 2763 "nibbles-game.c"
}

static GameStatus*
_game_status_dup (GameStatus* self)
{
	GameStatus* dup;
#line 506 "nibbles-game.vala"
	dup = g_new0 (GameStatus, 1);
#line 506 "nibbles-game.vala"
	memcpy (dup, self, sizeof (GameStatus));
#line 506 "nibbles-game.vala"
	return dup;
#line 2776 "nibbles-game.c"
}

static gpointer
__game_status_dup0 (gpointer self)
{
#line 506 "nibbles-game.vala"
	return self ? _game_status_dup (self) : NULL;
#line 2784 "nibbles-game.c"
}

GameStatus*
nibbles_game_get_game_status (NibblesGame* self)
{
	GameStatus* result = NULL;
	gint worms_left = 0;
	gboolean _tmp17_ = FALSE;
	Boni* _tmp23_;
#line 498 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 500 "nibbles-game.vala"
	worms_left = 0;
#line 2798 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
#line 501 "nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 501 "nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 501 "nibbles-game.vala"
		_worm_list = _tmp1_;
#line 501 "nibbles-game.vala"
		_tmp2_ = _worm_list;
#line 501 "nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 501 "nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 501 "nibbles-game.vala"
		_worm_size = _tmp4_;
#line 501 "nibbles-game.vala"
		_worm_index = -1;
#line 501 "nibbles-game.vala"
		while (TRUE) {
#line 2826 "nibbles-game.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			Worm* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
#line 501 "nibbles-game.vala"
			_worm_index = _worm_index + 1;
#line 501 "nibbles-game.vala"
			if (!(_worm_index < _worm_size)) {
#line 501 "nibbles-game.vala"
				break;
#line 2839 "nibbles-game.c"
			}
#line 501 "nibbles-game.vala"
			_tmp5_ = _worm_list;
#line 501 "nibbles-game.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _worm_index);
#line 501 "nibbles-game.vala"
			worm = (Worm*) _tmp6_;
#line 503 "nibbles-game.vala"
			_tmp7_ = worm;
#line 503 "nibbles-game.vala"
			_tmp8_ = worm_get_lives (_tmp7_);
#line 503 "nibbles-game.vala"
			_tmp9_ = _tmp8_;
#line 503 "nibbles-game.vala"
			if (_tmp9_ > 0) {
#line 504 "nibbles-game.vala"
				worms_left = worms_left + 1;
#line 2857 "nibbles-game.c"
			} else {
				gboolean _tmp10_ = FALSE;
				Worm* _tmp11_;
#line 505 "nibbles-game.vala"
				_tmp11_ = worm;
#line 505 "nibbles-game.vala"
				if (_tmp11_->is_human) {
#line 2865 "nibbles-game.c"
					Worm* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
#line 505 "nibbles-game.vala"
					_tmp12_ = worm;
#line 505 "nibbles-game.vala"
					_tmp13_ = worm_get_lives (_tmp12_);
#line 505 "nibbles-game.vala"
					_tmp14_ = _tmp13_;
#line 505 "nibbles-game.vala"
					_tmp10_ = _tmp14_ <= 0;
#line 2877 "nibbles-game.c"
				} else {
#line 505 "nibbles-game.vala"
					_tmp10_ = FALSE;
#line 2881 "nibbles-game.c"
				}
#line 505 "nibbles-game.vala"
				if (_tmp10_) {
#line 2885 "nibbles-game.c"
					GameStatus _tmp15_;
					GameStatus* _tmp16_;
#line 506 "nibbles-game.vala"
					_tmp15_ = GAME_STATUS_GAMEOVER;
#line 506 "nibbles-game.vala"
					_tmp16_ = __game_status_dup0 (&_tmp15_);
#line 506 "nibbles-game.vala"
					result = _tmp16_;
#line 506 "nibbles-game.vala"
					_g_object_unref0 (worm);
#line 506 "nibbles-game.vala"
					_g_object_unref0 (_worm_list);
#line 506 "nibbles-game.vala"
					return result;
#line 2900 "nibbles-game.c"
				}
			}
#line 501 "nibbles-game.vala"
			_g_object_unref0 (worm);
#line 2905 "nibbles-game.c"
		}
#line 501 "nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 2909 "nibbles-game.c"
	}
#line 509 "nibbles-game.vala"
	if (worms_left == 1) {
#line 2913 "nibbles-game.c"
		gint _tmp18_;
#line 509 "nibbles-game.vala"
		_tmp18_ = self->priv->_numworms;
#line 509 "nibbles-game.vala"
		_tmp17_ = _tmp18_ > 1;
#line 2919 "nibbles-game.c"
	} else {
#line 509 "nibbles-game.vala"
		_tmp17_ = FALSE;
#line 2923 "nibbles-game.c"
	}
#line 509 "nibbles-game.vala"
	if (_tmp17_) {
#line 2927 "nibbles-game.c"
		GameStatus _tmp19_;
		GameStatus* _tmp20_;
#line 512 "nibbles-game.vala"
		_tmp19_ = GAME_STATUS_VICTORY;
#line 512 "nibbles-game.vala"
		_tmp20_ = __game_status_dup0 (&_tmp19_);
#line 512 "nibbles-game.vala"
		result = _tmp20_;
#line 512 "nibbles-game.vala"
		return result;
#line 2938 "nibbles-game.c"
	} else {
#line 514 "nibbles-game.vala"
		if (worms_left == 0) {
#line 2942 "nibbles-game.c"
			GameStatus _tmp21_;
			GameStatus* _tmp22_;
#line 517 "nibbles-game.vala"
			_tmp21_ = GAME_STATUS_GAMEOVER;
#line 517 "nibbles-game.vala"
			_tmp22_ = __game_status_dup0 (&_tmp21_);
#line 517 "nibbles-game.vala"
			result = _tmp22_;
#line 517 "nibbles-game.vala"
			return result;
#line 2953 "nibbles-game.c"
		}
	}
#line 520 "nibbles-game.vala"
	_tmp23_ = self->priv->_boni;
#line 520 "nibbles-game.vala"
	if (_tmp23_->numleft == 0) {
#line 2960 "nibbles-game.c"
		GameStatus _tmp24_;
		GameStatus* _tmp25_;
#line 521 "nibbles-game.vala"
		_tmp24_ = GAME_STATUS_NEWROUND;
#line 521 "nibbles-game.vala"
		_tmp25_ = __game_status_dup0 (&_tmp24_);
#line 521 "nibbles-game.vala"
		result = _tmp25_;
#line 521 "nibbles-game.vala"
		return result;
#line 2971 "nibbles-game.c"
	}
#line 523 "nibbles-game.vala"
	result = NULL;
#line 523 "nibbles-game.vala"
	return result;
#line 2977 "nibbles-game.c"
}

Worm*
nibbles_game_get_winner (NibblesGame* self)
{
	Worm* result = NULL;
#line 526 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2986 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
#line 528 "nibbles-game.vala"
		_tmp0_ = self->priv->_worms;
#line 528 "nibbles-game.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 528 "nibbles-game.vala"
		_worm_list = _tmp1_;
#line 528 "nibbles-game.vala"
		_tmp2_ = _worm_list;
#line 528 "nibbles-game.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 528 "nibbles-game.vala"
		_tmp4_ = _tmp3_;
#line 528 "nibbles-game.vala"
		_worm_size = _tmp4_;
#line 528 "nibbles-game.vala"
		_worm_index = -1;
#line 528 "nibbles-game.vala"
		while (TRUE) {
#line 3014 "nibbles-game.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp5_;
			gpointer _tmp6_;
			Worm* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
#line 528 "nibbles-game.vala"
			_worm_index = _worm_index + 1;
#line 528 "nibbles-game.vala"
			if (!(_worm_index < _worm_size)) {
#line 528 "nibbles-game.vala"
				break;
#line 3027 "nibbles-game.c"
			}
#line 528 "nibbles-game.vala"
			_tmp5_ = _worm_list;
#line 528 "nibbles-game.vala"
			_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _worm_index);
#line 528 "nibbles-game.vala"
			worm = (Worm*) _tmp6_;
#line 530 "nibbles-game.vala"
			_tmp7_ = worm;
#line 530 "nibbles-game.vala"
			_tmp8_ = worm_get_lives (_tmp7_);
#line 530 "nibbles-game.vala"
			_tmp9_ = _tmp8_;
#line 530 "nibbles-game.vala"
			if (_tmp9_ > 0) {
#line 531 "nibbles-game.vala"
				result = worm;
#line 531 "nibbles-game.vala"
				_g_object_unref0 (_worm_list);
#line 531 "nibbles-game.vala"
				return result;
#line 3049 "nibbles-game.c"
			}
#line 528 "nibbles-game.vala"
			_g_object_unref0 (worm);
#line 3053 "nibbles-game.c"
		}
#line 528 "nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 3057 "nibbles-game.c"
	}
#line 534 "nibbles-game.vala"
	result = NULL;
#line 534 "nibbles-game.vala"
	return result;
#line 3063 "nibbles-game.c"
}

void
nibbles_game_load_properties (NibblesGame* self,
                              GSettings* settings)
{
#line 541 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 541 "nibbles-game.vala"
	g_return_if_fail (settings != NULL);
#line 543 "nibbles-game.vala"
	nibbles_game_set_tile_size (self, g_settings_get_int (settings, "tile-size"));
#line 544 "nibbles-game.vala"
	nibbles_game_set_start_level (self, g_settings_get_int (settings, "start-level"));
#line 545 "nibbles-game.vala"
	nibbles_game_set_speed (self, g_settings_get_int (settings, "speed"));
#line 546 "nibbles-game.vala"
	nibbles_game_set_fakes (self, g_settings_get_boolean (settings, "fakes"));
#line 3082 "nibbles-game.c"
}

void
nibbles_game_save_properties (NibblesGame* self,
                              GSettings* settings)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
#line 549 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 549 "nibbles-game.vala"
	g_return_if_fail (settings != NULL);
#line 551 "nibbles-game.vala"
	_tmp0_ = self->priv->_tile_size;
#line 551 "nibbles-game.vala"
	g_settings_set_int (settings, "tile-size", _tmp0_);
#line 552 "nibbles-game.vala"
	_tmp1_ = self->priv->_start_level;
#line 552 "nibbles-game.vala"
	g_settings_set_int (settings, "start-level", _tmp1_);
#line 553 "nibbles-game.vala"
	_tmp2_ = self->priv->_speed;
#line 553 "nibbles-game.vala"
	g_settings_set_int (settings, "speed", _tmp2_);
#line 554 "nibbles-game.vala"
	_tmp3_ = self->priv->_fakes;
#line 554 "nibbles-game.vala"
	g_settings_set_boolean (settings, "fakes", _tmp3_);
#line 3113 "nibbles-game.c"
}

void
nibbles_game_load_worm_properties (NibblesGame* self,
                                   GeeArrayList* worm_settings)
{
	GeeHashMap* _tmp0_;
#line 557 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 557 "nibbles-game.vala"
	g_return_if_fail (worm_settings != NULL);
#line 559 "nibbles-game.vala"
	_tmp0_ = self->priv->_worm_props;
#line 559 "nibbles-game.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
#line 3129 "nibbles-game.c"
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _worm_index = 0;
#line 560 "nibbles-game.vala"
		_tmp1_ = self->priv->_worms;
#line 560 "nibbles-game.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 560 "nibbles-game.vala"
		_worm_list = _tmp2_;
#line 560 "nibbles-game.vala"
		_tmp3_ = _worm_list;
#line 560 "nibbles-game.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 560 "nibbles-game.vala"
		_tmp5_ = _tmp4_;
#line 560 "nibbles-game.vala"
		_worm_size = _tmp5_;
#line 560 "nibbles-game.vala"
		_worm_index = -1;
#line 560 "nibbles-game.vala"
		while (TRUE) {
#line 3157 "nibbles-game.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			WormProperties properties = {0};
			Worm* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			GSettings* _tmp12_;
			Worm* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			GSettings* _tmp17_;
			Worm* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			GSettings* _tmp22_;
			Worm* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_;
			GSettings* _tmp27_;
			Worm* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gpointer _tmp31_;
			GSettings* _tmp32_;
			GeeHashMap* _tmp33_;
			Worm* _tmp34_;
			WormProperties _tmp35_;
#line 560 "nibbles-game.vala"
			_worm_index = _worm_index + 1;
#line 560 "nibbles-game.vala"
			if (!(_worm_index < _worm_size)) {
#line 560 "nibbles-game.vala"
				break;
#line 3196 "nibbles-game.c"
			}
#line 560 "nibbles-game.vala"
			_tmp6_ = _worm_list;
#line 560 "nibbles-game.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
#line 560 "nibbles-game.vala"
			worm = (Worm*) _tmp7_;
#line 562 "nibbles-game.vala"
			memset (&properties, 0, sizeof (WormProperties));
#line 563 "nibbles-game.vala"
			_tmp8_ = worm;
#line 563 "nibbles-game.vala"
			_tmp9_ = worm_get_id (_tmp8_);
#line 563 "nibbles-game.vala"
			_tmp10_ = _tmp9_;
#line 563 "nibbles-game.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp10_);
#line 563 "nibbles-game.vala"
			_tmp12_ = (GSettings*) _tmp11_;
#line 563 "nibbles-game.vala"
			properties.color = g_settings_get_enum (_tmp12_, "color");
#line 563 "nibbles-game.vala"
			_g_object_unref0 (_tmp12_);
#line 564 "nibbles-game.vala"
			_tmp13_ = worm;
#line 564 "nibbles-game.vala"
			_tmp14_ = worm_get_id (_tmp13_);
#line 564 "nibbles-game.vala"
			_tmp15_ = _tmp14_;
#line 564 "nibbles-game.vala"
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp15_);
#line 564 "nibbles-game.vala"
			_tmp17_ = (GSettings*) _tmp16_;
#line 564 "nibbles-game.vala"
			properties.up = (guint) g_settings_get_int (_tmp17_, "key-up");
#line 564 "nibbles-game.vala"
			_g_object_unref0 (_tmp17_);
#line 565 "nibbles-game.vala"
			_tmp18_ = worm;
#line 565 "nibbles-game.vala"
			_tmp19_ = worm_get_id (_tmp18_);
#line 565 "nibbles-game.vala"
			_tmp20_ = _tmp19_;
#line 565 "nibbles-game.vala"
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp20_);
#line 565 "nibbles-game.vala"
			_tmp22_ = (GSettings*) _tmp21_;
#line 565 "nibbles-game.vala"
			properties.down = (guint) g_settings_get_int (_tmp22_, "key-down");
#line 565 "nibbles-game.vala"
			_g_object_unref0 (_tmp22_);
#line 566 "nibbles-game.vala"
			_tmp23_ = worm;
#line 566 "nibbles-game.vala"
			_tmp24_ = worm_get_id (_tmp23_);
#line 566 "nibbles-game.vala"
			_tmp25_ = _tmp24_;
#line 566 "nibbles-game.vala"
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp25_);
#line 566 "nibbles-game.vala"
			_tmp27_ = (GSettings*) _tmp26_;
#line 566 "nibbles-game.vala"
			properties.left = (guint) g_settings_get_int (_tmp27_, "key-left");
#line 566 "nibbles-game.vala"
			_g_object_unref0 (_tmp27_);
#line 567 "nibbles-game.vala"
			_tmp28_ = worm;
#line 567 "nibbles-game.vala"
			_tmp29_ = worm_get_id (_tmp28_);
#line 567 "nibbles-game.vala"
			_tmp30_ = _tmp29_;
#line 567 "nibbles-game.vala"
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp30_);
#line 567 "nibbles-game.vala"
			_tmp32_ = (GSettings*) _tmp31_;
#line 567 "nibbles-game.vala"
			properties.right = (guint) g_settings_get_int (_tmp32_, "key-right");
#line 567 "nibbles-game.vala"
			_g_object_unref0 (_tmp32_);
#line 569 "nibbles-game.vala"
			_tmp33_ = self->priv->_worm_props;
#line 569 "nibbles-game.vala"
			_tmp34_ = worm;
#line 569 "nibbles-game.vala"
			_tmp35_ = properties;
#line 569 "nibbles-game.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, _tmp34_, &_tmp35_);
#line 560 "nibbles-game.vala"
			_g_object_unref0 (worm);
#line 3286 "nibbles-game.c"
		}
#line 560 "nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 3290 "nibbles-game.c"
	}
}

gboolean
nibbles_game_handle_keypress (NibblesGame* self,
                              guint keyval)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 573 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 575 "nibbles-game.vala"
	_tmp0_ = self->priv->_is_running;
#line 575 "nibbles-game.vala"
	if (!_tmp0_) {
#line 576 "nibbles-game.vala"
		result = FALSE;
#line 576 "nibbles-game.vala"
		return result;
#line 3310 "nibbles-game.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		GeeLinkedList* _tmp2_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _worm_index = 0;
#line 578 "nibbles-game.vala"
		_tmp1_ = self->priv->_worms;
#line 578 "nibbles-game.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 578 "nibbles-game.vala"
		_worm_list = _tmp2_;
#line 578 "nibbles-game.vala"
		_tmp3_ = _worm_list;
#line 578 "nibbles-game.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 578 "nibbles-game.vala"
		_tmp5_ = _tmp4_;
#line 578 "nibbles-game.vala"
		_worm_size = _tmp5_;
#line 578 "nibbles-game.vala"
		_worm_index = -1;
#line 578 "nibbles-game.vala"
		while (TRUE) {
#line 3339 "nibbles-game.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
#line 578 "nibbles-game.vala"
			_worm_index = _worm_index + 1;
#line 578 "nibbles-game.vala"
			if (!(_worm_index < _worm_size)) {
#line 578 "nibbles-game.vala"
				break;
#line 3350 "nibbles-game.c"
			}
#line 578 "nibbles-game.vala"
			_tmp6_ = _worm_list;
#line 578 "nibbles-game.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
#line 578 "nibbles-game.vala"
			worm = (Worm*) _tmp7_;
#line 580 "nibbles-game.vala"
			_tmp8_ = worm;
#line 580 "nibbles-game.vala"
			if (_tmp8_->is_human) {
#line 3362 "nibbles-game.c"
				Worm* _tmp9_;
				GeeHashMap* _tmp10_;
#line 582 "nibbles-game.vala"
				_tmp9_ = worm;
#line 582 "nibbles-game.vala"
				_tmp10_ = self->priv->_worm_props;
#line 582 "nibbles-game.vala"
				if (worm_handle_keypress (_tmp9_, keyval, _tmp10_)) {
#line 583 "nibbles-game.vala"
					result = TRUE;
#line 583 "nibbles-game.vala"
					_g_object_unref0 (worm);
#line 583 "nibbles-game.vala"
					_g_object_unref0 (_worm_list);
#line 583 "nibbles-game.vala"
					return result;
#line 3379 "nibbles-game.c"
				}
			}
#line 578 "nibbles-game.vala"
			_g_object_unref0 (worm);
#line 3384 "nibbles-game.c"
		}
#line 578 "nibbles-game.vala"
		_g_object_unref0 (_worm_list);
#line 3388 "nibbles-game.c"
	}
#line 587 "nibbles-game.vala"
	result = FALSE;
#line 587 "nibbles-game.vala"
	return result;
#line 3394 "nibbles-game.c"
}

gint
nibbles_game_get_start_level (NibblesGame* self)
{
	gint result;
#line 52 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 52 "nibbles-game.vala"
	result = self->priv->_start_level;
#line 52 "nibbles-game.vala"
	return result;
#line 3407 "nibbles-game.c"
}

static void
nibbles_game_set_start_level (NibblesGame* self,
                              gint value)
{
#line 52 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 52 "nibbles-game.vala"
	if (nibbles_game_get_start_level (self) != value) {
#line 52 "nibbles-game.vala"
		self->priv->_start_level = value;
#line 52 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_START_LEVEL_PROPERTY]);
#line 3422 "nibbles-game.c"
	}
}

gint
nibbles_game_get_current_level (NibblesGame* self)
{
	gint result;
#line 53 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 53 "nibbles-game.vala"
	result = self->priv->_current_level;
#line 53 "nibbles-game.vala"
	return result;
#line 3436 "nibbles-game.c"
}

static void
nibbles_game_set_current_level (NibblesGame* self,
                                gint value)
{
#line 53 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 53 "nibbles-game.vala"
	if (nibbles_game_get_current_level (self) != value) {
#line 53 "nibbles-game.vala"
		self->priv->_current_level = value;
#line 53 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY]);
#line 3451 "nibbles-game.c"
	}
}

gint
nibbles_game_get_speed (NibblesGame* self)
{
	gint result;
#line 54 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 54 "nibbles-game.vala"
	result = self->priv->_speed;
#line 54 "nibbles-game.vala"
	return result;
#line 3465 "nibbles-game.c"
}

void
nibbles_game_set_speed (NibblesGame* self,
                        gint value)
{
#line 54 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 54 "nibbles-game.vala"
	if (nibbles_game_get_speed (self) != value) {
#line 54 "nibbles-game.vala"
		self->priv->_speed = value;
#line 54 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY]);
#line 3480 "nibbles-game.c"
	}
}

gint
nibbles_game_get_tile_size (NibblesGame* self)
{
	gint result;
#line 57 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 57 "nibbles-game.vala"
	result = self->priv->_tile_size;
#line 57 "nibbles-game.vala"
	return result;
#line 3494 "nibbles-game.c"
}

void
nibbles_game_set_tile_size (NibblesGame* self,
                            gint value)
{
#line 57 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 57 "nibbles-game.vala"
	if (nibbles_game_get_tile_size (self) != value) {
#line 57 "nibbles-game.vala"
		self->priv->_tile_size = value;
#line 57 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_TILE_SIZE_PROPERTY]);
#line 3509 "nibbles-game.c"
	}
}

gint
nibbles_game_get_numhumans (NibblesGame* self)
{
	gint result;
#line 61 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 61 "nibbles-game.vala"
	result = self->priv->_numhumans;
#line 61 "nibbles-game.vala"
	return result;
#line 3523 "nibbles-game.c"
}

void
nibbles_game_set_numhumans (NibblesGame* self,
                            gint value)
{
#line 61 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 61 "nibbles-game.vala"
	if (nibbles_game_get_numhumans (self) != value) {
#line 61 "nibbles-game.vala"
		self->priv->_numhumans = value;
#line 61 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY]);
#line 3538 "nibbles-game.c"
	}
}

gint
nibbles_game_get_numai (NibblesGame* self)
{
	gint result;
#line 62 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 62 "nibbles-game.vala"
	result = self->priv->_numai;
#line 62 "nibbles-game.vala"
	return result;
#line 3552 "nibbles-game.c"
}

void
nibbles_game_set_numai (NibblesGame* self,
                        gint value)
{
#line 62 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 62 "nibbles-game.vala"
	if (nibbles_game_get_numai (self) != value) {
#line 62 "nibbles-game.vala"
		self->priv->_numai = value;
#line 62 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY]);
#line 3567 "nibbles-game.c"
	}
}

gint
nibbles_game_get_numworms (NibblesGame* self)
{
	gint result;
#line 63 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "nibbles-game.vala"
	result = self->priv->_numworms;
#line 63 "nibbles-game.vala"
	return result;
#line 3581 "nibbles-game.c"
}

static void
nibbles_game_set_numworms (NibblesGame* self,
                           gint value)
{
#line 63 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 63 "nibbles-game.vala"
	if (nibbles_game_get_numworms (self) != value) {
#line 63 "nibbles-game.vala"
		self->priv->_numworms = value;
#line 63 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY]);
#line 3596 "nibbles-game.c"
	}
}

GeeLinkedList*
nibbles_game_get_worms (NibblesGame* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
#line 66 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "nibbles-game.vala"
	_tmp0_ = self->priv->_worms;
#line 66 "nibbles-game.vala"
	result = _tmp0_;
#line 66 "nibbles-game.vala"
	return result;
#line 3613 "nibbles-game.c"
}

static void
nibbles_game_set_worms (NibblesGame* self,
                        GeeLinkedList* value)
{
#line 66 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 66 "nibbles-game.vala"
	if (nibbles_game_get_worms (self) != value) {
#line 3624 "nibbles-game.c"
		GeeLinkedList* _tmp0_;
#line 66 "nibbles-game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 66 "nibbles-game.vala"
		_g_object_unref0 (self->priv->_worms);
#line 66 "nibbles-game.vala"
		self->priv->_worms = _tmp0_;
#line 66 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WORMS_PROPERTY]);
#line 3634 "nibbles-game.c"
	}
}

Boni*
nibbles_game_get_boni (NibblesGame* self)
{
	Boni* result;
	Boni* _tmp0_;
#line 67 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 67 "nibbles-game.vala"
	_tmp0_ = self->priv->_boni;
#line 67 "nibbles-game.vala"
	result = _tmp0_;
#line 67 "nibbles-game.vala"
	return result;
#line 3651 "nibbles-game.c"
}

static void
nibbles_game_set_boni (NibblesGame* self,
                       Boni* value)
{
#line 67 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 67 "nibbles-game.vala"
	if (nibbles_game_get_boni (self) != value) {
#line 3662 "nibbles-game.c"
		Boni* _tmp0_;
#line 67 "nibbles-game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 67 "nibbles-game.vala"
		_g_object_unref0 (self->priv->_boni);
#line 67 "nibbles-game.vala"
		self->priv->_boni = _tmp0_;
#line 67 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_BONI_PROPERTY]);
#line 3672 "nibbles-game.c"
	}
}

WarpManager*
nibbles_game_get_warp_manager (NibblesGame* self)
{
	WarpManager* result;
	WarpManager* _tmp0_;
#line 68 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "nibbles-game.vala"
	_tmp0_ = self->priv->_warp_manager;
#line 68 "nibbles-game.vala"
	result = _tmp0_;
#line 68 "nibbles-game.vala"
	return result;
#line 3689 "nibbles-game.c"
}

static void
nibbles_game_set_warp_manager (NibblesGame* self,
                               WarpManager* value)
{
#line 68 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 68 "nibbles-game.vala"
	if (nibbles_game_get_warp_manager (self) != value) {
#line 3700 "nibbles-game.c"
		WarpManager* _tmp0_;
#line 68 "nibbles-game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 68 "nibbles-game.vala"
		_g_object_unref0 (self->priv->_warp_manager);
#line 68 "nibbles-game.vala"
		self->priv->_warp_manager = _tmp0_;
#line 68 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WARP_MANAGER_PROPERTY]);
#line 3710 "nibbles-game.c"
	}
}

GeeHashMap*
nibbles_game_get_worm_props (NibblesGame* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
#line 69 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "nibbles-game.vala"
	_tmp0_ = self->priv->_worm_props;
#line 69 "nibbles-game.vala"
	result = _tmp0_;
#line 69 "nibbles-game.vala"
	return result;
#line 3727 "nibbles-game.c"
}

static void
nibbles_game_set_worm_props (NibblesGame* self,
                             GeeHashMap* value)
{
#line 69 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 69 "nibbles-game.vala"
	if (nibbles_game_get_worm_props (self) != value) {
#line 3738 "nibbles-game.c"
		GeeHashMap* _tmp0_;
#line 69 "nibbles-game.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 69 "nibbles-game.vala"
		_g_object_unref0 (self->priv->_worm_props);
#line 69 "nibbles-game.vala"
		self->priv->_worm_props = _tmp0_;
#line 69 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WORM_PROPS_PROPERTY]);
#line 3748 "nibbles-game.c"
	}
}

gboolean
nibbles_game_get_is_running (NibblesGame* self)
{
	gboolean result;
#line 72 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "nibbles-game.vala"
	result = self->priv->_is_running;
#line 72 "nibbles-game.vala"
	return result;
#line 3762 "nibbles-game.c"
}

static void
nibbles_game_set_is_running (NibblesGame* self,
                             gboolean value)
{
#line 72 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 72 "nibbles-game.vala"
	if (nibbles_game_get_is_running (self) != value) {
#line 72 "nibbles-game.vala"
		self->priv->_is_running = value;
#line 72 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY]);
#line 3777 "nibbles-game.c"
	}
}

gboolean
nibbles_game_get_is_paused (NibblesGame* self)
{
	gboolean result;
#line 73 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "nibbles-game.vala"
	result = self->priv->_is_paused;
#line 73 "nibbles-game.vala"
	return result;
#line 3791 "nibbles-game.c"
}

static void
nibbles_game_set_is_paused (NibblesGame* self,
                            gboolean value)
{
#line 73 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 73 "nibbles-game.vala"
	if (nibbles_game_get_is_paused (self) != value) {
#line 73 "nibbles-game.vala"
		self->priv->_is_paused = value;
#line 73 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_IS_PAUSED_PROPERTY]);
#line 3806 "nibbles-game.c"
	}
}

gboolean
nibbles_game_get_fakes (NibblesGame* self)
{
	gboolean result;
#line 78 "nibbles-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 78 "nibbles-game.vala"
	result = self->priv->_fakes;
#line 78 "nibbles-game.vala"
	return result;
#line 3820 "nibbles-game.c"
}

void
nibbles_game_set_fakes (NibblesGame* self,
                        gboolean value)
{
#line 78 "nibbles-game.vala"
	g_return_if_fail (self != NULL);
#line 78 "nibbles-game.vala"
	if (nibbles_game_get_fakes (self) != value) {
#line 78 "nibbles-game.vala"
		self->priv->_fakes = value;
#line 78 "nibbles-game.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY]);
#line 3835 "nibbles-game.c"
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 29 "nibbles-game.vala"
	g_return_if_fail (n_param_values == 3);
#line 29 "nibbles-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 29 "nibbles-game.vala"
		data1 = closure->data;
#line 29 "nibbles-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 3861 "nibbles-game.c"
	} else {
#line 29 "nibbles-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 29 "nibbles-game.vala"
		data2 = closure->data;
#line 3867 "nibbles-game.c"
	}
#line 29 "nibbles-game.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 29 "nibbles-game.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 3873 "nibbles-game.c"
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 29 "nibbles-game.vala"
	g_return_if_fail (n_param_values == 3);
#line 29 "nibbles-game.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 29 "nibbles-game.vala"
		data1 = closure->data;
#line 29 "nibbles-game.vala"
		data2 = param_values->data[0].v_pointer;
#line 3898 "nibbles-game.c"
	} else {
#line 29 "nibbles-game.vala"
		data1 = param_values->data[0].v_pointer;
#line 29 "nibbles-game.vala"
		data2 = closure->data;
#line 3904 "nibbles-game.c"
	}
#line 29 "nibbles-game.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 29 "nibbles-game.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 3910 "nibbles-game.c"
}

static void
nibbles_game_class_init (NibblesGameClass * klass,
                         gpointer klass_data)
{
#line 29 "nibbles-game.vala"
	nibbles_game_parent_class = g_type_class_peek_parent (klass);
#line 29 "nibbles-game.vala"
	g_type_class_adjust_private_offset (klass, &NibblesGame_private_offset);
#line 29 "nibbles-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_game_get_property;
#line 29 "nibbles-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_game_set_property;
#line 29 "nibbles-game.vala"
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_finalize;
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_START_LEVEL_PROPERTY, nibbles_game_properties[NIBBLES_GAME_START_LEVEL_PROPERTY] = g_param_spec_int ("start-level", "start-level", "start-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_CURRENT_LEVEL_PROPERTY, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY] = g_param_spec_int ("current-level", "current-level", "current-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SPEED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY] = g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_TILE_SIZE_PROPERTY, nibbles_game_properties[NIBBLES_GAME_TILE_SIZE_PROPERTY] = g_param_spec_int ("tile-size", "tile-size", "tile-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMHUMANS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY] = g_param_spec_int ("numhumans", "numhumans", "numhumans", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMAI_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY] = g_param_spec_int ("numai", "numai", "numai", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMWORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY] = g_param_spec_int ("numworms", "numworms", "numworms", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORMS_PROPERTY] = g_param_spec_object ("worms", "worms", "worms", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_BONI_PROPERTY, nibbles_game_properties[NIBBLES_GAME_BONI_PROPERTY] = g_param_spec_object ("boni", "boni", "boni", TYPE_BONI, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WARP_MANAGER_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WARP_MANAGER_PROPERTY] = g_param_spec_object ("warp-manager", "warp-manager", "warp-manager", TYPE_WARP_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORM_PROPS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORM_PROPS_PROPERTY] = g_param_spec_object ("worm-props", "worm-props", "worm-props", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_RUNNING_PROPERTY, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_PAUSED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_IS_PAUSED_PROPERTY] = g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 29 "nibbles-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_FAKES_PROPERTY, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY] = g_param_spec_boolean ("fakes", "fakes", "fakes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 29 "nibbles-game.vala"
	nibbles_game_signals[NIBBLES_GAME_WORM_MOVED_SIGNAL] = g_signal_new ("worm-moved", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_WORM);
#line 29 "nibbles-game.vala"
	nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL] = g_signal_new ("bonus-applied", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_BONUS, TYPE_WORM);
#line 29 "nibbles-game.vala"
	nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL] = g_signal_new ("log-score", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 29 "nibbles-game.vala"
	nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL] = g_signal_new ("animate-end-game", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 29 "nibbles-game.vala"
	nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL] = g_signal_new ("level-completed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 3965 "nibbles-game.c"
}

static void
nibbles_game_instance_init (NibblesGame * self,
                            gpointer klass)
{
#line 29 "nibbles-game.vala"
	self->priv = nibbles_game_get_instance_private (self);
#line 72 "nibbles-game.vala"
	self->priv->_is_running = FALSE;
#line 75 "nibbles-game.vala"
	self->priv->main_id = (guint) 0;
#line 76 "nibbles-game.vala"
	self->priv->add_bonus_id = (guint) 0;
#line 3980 "nibbles-game.c"
}

static void
nibbles_game_finalize (GObject * obj)
{
	NibblesGame * self;
#line 29 "nibbles-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
#line 58 "nibbles-game.vala"
	self->board = (g_free (self->board), NULL);
#line 66 "nibbles-game.vala"
	_g_object_unref0 (self->priv->_worms);
#line 67 "nibbles-game.vala"
	_g_object_unref0 (self->priv->_boni);
#line 68 "nibbles-game.vala"
	_g_object_unref0 (self->priv->_warp_manager);
#line 69 "nibbles-game.vala"
	_g_object_unref0 (self->priv->_worm_props);
#line 29 "nibbles-game.vala"
	G_OBJECT_CLASS (nibbles_game_parent_class)->finalize (obj);
#line 4001 "nibbles-game.c"
}

GType
nibbles_game_get_type (void)
{
	static volatile gsize nibbles_game_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGame), 0, (GInstanceInitFunc) nibbles_game_instance_init, NULL };
		GType nibbles_game_type_id;
		nibbles_game_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGame", &g_define_type_info, 0);
		NibblesGame_private_offset = g_type_add_instance_private (nibbles_game_type_id, sizeof (NibblesGamePrivate));
		g_once_init_leave (&nibbles_game_type_id__volatile, nibbles_game_type_id);
	}
	return nibbles_game_type_id__volatile;
}

static void
_vala_nibbles_game_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
#line 29 "nibbles-game.vala"
	switch (property_id) {
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_START_LEVEL_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_start_level (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_current_level (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_SPEED_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_speed (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_TILE_SIZE_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_tile_size (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_numhumans (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_NUMAI_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_numai (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_int (value, nibbles_game_get_numworms (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_WORMS_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_worms (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_BONI_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_boni (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_WARP_MANAGER_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_warp_manager (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_WORM_PROPS_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_object (value, nibbles_game_get_worm_props (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_boolean (value, nibbles_game_get_is_running (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_IS_PAUSED_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_boolean (value, nibbles_game_get_is_paused (self));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_FAKES_PROPERTY:
#line 29 "nibbles-game.vala"
		g_value_set_boolean (value, nibbles_game_get_fakes (self));
#line 29 "nibbles-game.vala"
		break;
#line 4112 "nibbles-game.c"
		default:
#line 29 "nibbles-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "nibbles-game.vala"
		break;
#line 4118 "nibbles-game.c"
	}
}

static void
_vala_nibbles_game_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
#line 29 "nibbles-game.vala"
	switch (property_id) {
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_START_LEVEL_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_start_level (self, g_value_get_int (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_current_level (self, g_value_get_int (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_SPEED_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_speed (self, g_value_get_int (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_TILE_SIZE_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_tile_size (self, g_value_get_int (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_numhumans (self, g_value_get_int (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_NUMAI_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_numai (self, g_value_get_int (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_numworms (self, g_value_get_int (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_WORMS_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_worms (self, g_value_get_object (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_BONI_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_boni (self, g_value_get_object (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_WARP_MANAGER_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_warp_manager (self, g_value_get_object (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_WORM_PROPS_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_worm_props (self, g_value_get_object (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_is_running (self, g_value_get_boolean (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_IS_PAUSED_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_is_paused (self, g_value_get_boolean (value));
#line 29 "nibbles-game.vala"
		break;
#line 29 "nibbles-game.vala"
		case NIBBLES_GAME_FAKES_PROPERTY:
#line 29 "nibbles-game.vala"
		nibbles_game_set_fakes (self, g_value_get_boolean (value));
#line 29 "nibbles-game.vala"
		break;
#line 4216 "nibbles-game.c"
		default:
#line 29 "nibbles-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 29 "nibbles-game.vala"
		break;
#line 4222 "nibbles-game.c"
	}
}

