/* nibbles-view.c generated by valac 0.44.6, the Vala compiler
 * generated from nibbles-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter-gtk/clutter-gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <canberra-gtk.h>
#include <canberra.h>

#define TYPE_WORM_ACTOR (worm_actor_get_type ())
#define WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_ACTOR, WormActor))
#define WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_ACTOR, WormActorClass))
#define IS_WORM_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_ACTOR))
#define IS_WORM_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_ACTOR))
#define WORM_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_ACTOR, WormActorClass))

typedef struct _WormActor WormActor;
typedef struct _WormActorClass WormActorClass;
typedef struct _WormActorPrivate WormActorPrivate;
enum  {
	WORM_ACTOR_0_PROPERTY,
	WORM_ACTOR_NUM_PROPERTIES
};
static GParamSpec* worm_actor_properties[WORM_ACTOR_NUM_PROPERTIES];

#define TYPE_BONUS_TEXTURE (bonus_texture_get_type ())
#define BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS_TEXTURE, BonusTexture))
#define BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS_TEXTURE, BonusTextureClass))
#define IS_BONUS_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS_TEXTURE))
#define IS_BONUS_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS_TEXTURE))
#define BONUS_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS_TEXTURE, BonusTextureClass))

typedef struct _BonusTexture BonusTexture;
typedef struct _BonusTextureClass BonusTextureClass;
typedef struct _BonusTexturePrivate BonusTexturePrivate;
enum  {
	BONUS_TEXTURE_0_PROPERTY,
	BONUS_TEXTURE_NUM_PROPERTIES
};
static GParamSpec* bonus_texture_properties[BONUS_TEXTURE_NUM_PROPERTIES];

#define TYPE_WARP_TEXTURE (warp_texture_get_type ())
#define WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_TEXTURE, WarpTexture))
#define WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_TEXTURE, WarpTextureClass))
#define IS_WARP_TEXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_TEXTURE))
#define IS_WARP_TEXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_TEXTURE))
#define WARP_TEXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_TEXTURE, WarpTextureClass))

typedef struct _WarpTexture WarpTexture;
typedef struct _WarpTextureClass WarpTextureClass;
typedef struct _WarpTexturePrivate WarpTexturePrivate;
enum  {
	WARP_TEXTURE_0_PROPERTY,
	WARP_TEXTURE_NUM_PROPERTIES
};
static GParamSpec* warp_texture_properties[WARP_TEXTURE_NUM_PROPERTIES];

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
enum  {
	NIBBLES_VIEW_0_PROPERTY,
	NIBBLES_VIEW_NAME_LABELS_PROPERTY,
	NIBBLES_VIEW_GAME_PROPERTY,
	NIBBLES_VIEW_NUM_PROPERTIES
};
static GParamSpec* nibbles_view_properties[NIBBLES_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _NibblesGamePrivate NibblesGamePrivate;
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _WormPrivate WormPrivate;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _BoniPrivate BoniPrivate;
typedef struct _BonusPrivate BonusPrivate;
typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
typedef struct _WarpPrivate WarpPrivate;

struct _WormActor {
	ClutterActor parent_instance;
	WormActorPrivate * priv;
};

struct _WormActorClass {
	ClutterActorClass parent_class;
};

struct _BonusTexture {
	GtkClutterTexture parent_instance;
	BonusTexturePrivate * priv;
};

struct _BonusTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _WarpTexture {
	GtkClutterTexture parent_instance;
	WarpTexturePrivate * priv;
};

struct _WarpTextureClass {
	GtkClutterTextureClass parent_class;
};

struct _NibblesView {
	GtkClutterEmbed parent_instance;
	NibblesViewPrivate * priv;
	gboolean is_muted;
};

struct _NibblesViewClass {
	GtkClutterEmbedClass parent_class;
};

struct _NibblesViewPrivate {
	GdkPixbuf* wall_pixmaps[11];
	GdkPixbuf* worm_pixmaps[6];
	GdkPixbuf* boni_pixmaps[9];
	ClutterStage* stage;
	ClutterActor* level;
	ClutterActor* _name_labels;
	GeeHashMap* worm_actors;
	GeeHashMap* bonus_actors;
	GeeHashMap* warp_actors;
	NibblesGame* _game;
};

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
	GeeLinkedList* warps;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _Block6Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Block7Data {
	int _ref_count_;
	NibblesView* self;
	Worm* worm;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
	GeeLinkedList* bonuses;
	gint missed;
	gint numleft;
	gint numboni;
	gint numbonuses;
};

struct _BoniClass {
	GObjectClass parent_class;
};

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
	gint x;
	gint y;
	BonusType type;
	gboolean fake;
	gint countdown;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

static gpointer worm_actor_parent_class = NULL;
static gpointer bonus_texture_parent_class = NULL;
static gpointer warp_texture_parent_class = NULL;
static gint NibblesView_private_offset;
static gpointer nibbles_view_parent_class = NULL;
extern gchar** nibbles_view_color_lookup;
extern gint nibbles_view_color_lookup_length1;
gchar** nibbles_view_color_lookup = NULL;
gint nibbles_view_color_lookup_length1 = 0;

GType worm_actor_get_type (void) G_GNUC_CONST;
static void worm_actor_real_show (ClutterActor* base);
#define NIBBLES_GAME_GAMEDELAY 35
static void worm_actor_real_hide (ClutterActor* base);
WormActor* worm_actor_new (void);
WormActor* worm_actor_construct (GType object_type);
GType bonus_texture_get_type (void) G_GNUC_CONST;
#define BONUS_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void bonus_texture_real_show (ClutterActor* base);
void bonus_texture_set_size (BonusTexture* self,
                             gfloat width,
                             gfloat height);
BonusTexture* bonus_texture_new (void);
BonusTexture* bonus_texture_construct (GType object_type);
GType warp_texture_get_type (void) G_GNUC_CONST;
#define WARP_TEXTURE_SIZE_MULTIPLIER ((gfloat) 2)
static void warp_texture_real_show (ClutterActor* base);
static void warp_texture_real_hide (ClutterActor* base);
void warp_texture_set_size (WarpTexture* self,
                            gfloat width,
                            gfloat height);
WarpTexture* warp_texture_new (void);
WarpTexture* warp_texture_construct (GType object_type);
GType nibbles_view_get_type (void) G_GNUC_CONST;
GType worm_get_type (void) G_GNUC_CONST;
GType bonus_get_type (void) G_GNUC_CONST;
GType warp_get_type (void) G_GNUC_CONST;
GType nibbles_game_get_type (void) G_GNUC_CONST;
#define NIBBLES_VIEW_NUM_COLORS 6
NibblesView* nibbles_view_new (NibblesGame* game);
NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game);
void nibbles_view_set_game (NibblesView* self,
                            NibblesGame* value);
#define NIBBLES_GAME_MINIMUM_TILE_SIZE 7
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
static void nibbles_view_load_pixmap (NibblesView* self);
void nibbles_view_new_level (NibblesView* self,
                             gint level);
NibblesGame* nibbles_view_get_game (NibblesView* self);
GType boni_get_type (void) G_GNUC_CONST;
Boni* nibbles_game_get_boni (NibblesGame* self);
void boni_reset (Boni* self,
                 gint numworms);
gint nibbles_game_get_numworms (NibblesGame* self);
GType warp_manager_get_type (void) G_GNUC_CONST;
WarpManager* nibbles_game_get_warp_manager (NibblesGame* self);
#define NIBBLES_GAME_EMPTYCHAR 'a'
GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
GType worm_direction_get_type (void) G_GNUC_CONST;
void worm_set_start (Worm* self,
                     gint xhead,
                     gint yhead,
                     WormDirection direction);
static void nibbles_view_load_level (NibblesView* self);
gint nibbles_game_get_tile_size (NibblesGame* self);
void warp_manager_add_warp (WarpManager* self,
                            gint* board,
                            gint board_length1,
                            gint board_length2,
                            gint x,
                            gint y,
                            gint wx,
                            gint wy);
GdkPixbuf* nibbles_view_load_pixmap_file (NibblesView* self,
                                          const gchar* pixmap,
                                          gint xsize,
                                          gint ysize);
void nibbles_view_connect_worm_signals (NibblesView* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void nibbles_view_worm_added_cb (NibblesView* self,
                                 Worm* worm);
static void _nibbles_view_worm_added_cb_worm_added (Worm* _sender,
                                             gpointer self);
static void nibbles_view_worm_finish_added_cb (NibblesView* self,
                                        Worm* worm);
static void _nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender,
                                                           gpointer self);
static void nibbles_view_worm_moved_cb (NibblesView* self,
                                 Worm* worm);
static void _nibbles_view_worm_moved_cb_worm_moved (Worm* _sender,
                                             gpointer self);
static void nibbles_view_worm_rescaled_cb (NibblesView* self,
                                    Worm* worm,
                                    gint tile_size);
static void _nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender,
                                                   gint tile_size,
                                                   gpointer self);
static void nibbles_view_worm_died_cb (NibblesView* self,
                                Worm* worm);
static void _nibbles_view_worm_died_cb_worm_died (Worm* _sender,
                                           gpointer self);
static void nibbles_view_worm_tail_reduced_cb (NibblesView* self,
                                        Worm* worm,
                                        gint erase_size);
static void _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender,
                                                           gint erase_size,
                                                           gpointer self);
static void nibbles_view_worm_reversed_cb (NibblesView* self,
                                    Worm* worm);
static void _nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender,
                                                   gpointer self);
static void ____lambda6_ (Block6Data* _data6_);
gboolean worm_get_is_materialized (Worm* self);
static void _____lambda6__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
void nibbles_view_board_rescale (NibblesView* self,
                                 gint tile_size);
ClutterActor* nibbles_view_get_name_labels (NibblesView* self);
gint worm_get_id (Worm* self);
gint worm_get_length (Worm* self);
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GeeLinkedList* worm_get_list (Worm* self);
void worm_get_head (Worm* self,
                    Position * result);
static void nibbles_view_animate_end_game_cb (NibblesView* self);
void nibbles_view_create_name_labels (NibblesView* self);
static void nibbles_view_set_name_labels (NibblesView* self,
                                   ClutterActor* value);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
gchar* nibbles_view_colorval_name (gint colorval);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
void worm_dematerialize (Worm* self,
                         gint* board,
                         gint board_length1,
                         gint board_length2,
                         gint rounds);
static gboolean __lambda5_ (Block7Data* _data7_);
static gboolean ___lambda5__gsource_func (gpointer self);
static void nibbles_view_play_sound (NibblesView* self,
                              const gchar* name);
static void nibbles_view_bonus_added_cb (NibblesView* self);
GType bonus_type_get_type (void) G_GNUC_CONST;
static void nibbles_view_bonus_removed_cb (NibblesView* self,
                                    Bonus* bonus);
static void nibbles_view_bonus_applied_cb (NibblesView* self,
                                    Bonus* bonus,
                                    Worm* worm);
void nibbles_view_boni_rescale (NibblesView* self,
                                gint tile_size);
static void nibbles_view_warp_added_cb (NibblesView* self,
                                 Warp* warp);
void nibbles_view_warps_rescale (NibblesView* self,
                                 gint tile_size);
static void _nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender,
                                                    gpointer self);
static void _nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender,
                                                        Bonus* bonus,
                                                        gpointer self);
static void _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender,
                                                                Bonus* bonus,
                                                                Worm* worm,
                                                                gpointer self);
static void _nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender,
                                                          Warp* warp,
                                                          gpointer self);
static void _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender,
                                                                      gpointer self);
static void nibbles_view_finalize (GObject * obj);
static void _vala_nibbles_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_nibbles_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static void
worm_actor_real_show (ClutterActor* base)
{
	WormActor * self;
#line 21 "nibbles-view.vala"
	self = (WormActor*) base;
#line 23 "nibbles-view.vala"
	CLUTTER_ACTOR_CLASS (worm_actor_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
#line 25 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 26 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
#line 28 "nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 29 "nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
#line 30 "nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 26));
#line 31 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
#line 32 "nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 33 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
#line 34 "nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 578 "nibbles-view.c"
}

static void
worm_actor_real_hide (ClutterActor* base)
{
	WormActor * self;
#line 37 "nibbles-view.vala"
	self = (WormActor*) base;
#line 39 "nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 40 "nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
#line 41 "nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 42 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
#line 43 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 44 "nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 599 "nibbles-view.c"
}

WormActor*
worm_actor_construct (GType object_type)
{
	WormActor * self = NULL;
#line 19 "nibbles-view.vala"
	self = (WormActor*) g_object_new (object_type, NULL);
#line 19 "nibbles-view.vala"
	return self;
#line 610 "nibbles-view.c"
}

WormActor*
worm_actor_new (void)
{
#line 19 "nibbles-view.vala"
	return worm_actor_construct (TYPE_WORM_ACTOR);
#line 618 "nibbles-view.c"
}

static void
worm_actor_class_init (WormActorClass * klass,
                       gpointer klass_data)
{
#line 19 "nibbles-view.vala"
	worm_actor_parent_class = g_type_class_peek_parent (klass);
#line 19 "nibbles-view.vala"
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor*)) worm_actor_real_show;
#line 19 "nibbles-view.vala"
	((ClutterActorClass *) klass)->hide = (void (*) (ClutterActor*)) worm_actor_real_hide;
#line 631 "nibbles-view.c"
}

static void
worm_actor_instance_init (WormActor * self,
                          gpointer klass)
{
}

GType
worm_actor_get_type (void)
{
	static volatile gsize worm_actor_type_id__volatile = 0;
	if (g_once_init_enter (&worm_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WormActor), 0, (GInstanceInitFunc) worm_actor_instance_init, NULL };
		GType worm_actor_type_id;
		worm_actor_type_id = g_type_register_static (clutter_actor_get_type (), "WormActor", &g_define_type_info, 0);
		g_once_init_leave (&worm_actor_type_id__volatile, worm_actor_type_id);
	}
	return worm_actor_type_id__volatile;
}

static void
bonus_texture_real_show (ClutterActor* base)
{
	BonusTexture * self;
#line 52 "nibbles-view.vala"
	self = (BonusTexture*) base;
#line 54 "nibbles-view.vala"
	CLUTTER_ACTOR_CLASS (bonus_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
#line 56 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 57 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
#line 59 "nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 60 "nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BOUNCE);
#line 61 "nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
#line 62 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
#line 63 "nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 64 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
#line 65 "nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 679 "nibbles-view.c"
}

void
bonus_texture_set_size (BonusTexture* self,
                        gfloat width,
                        gfloat height)
{
#line 68 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 70 "nibbles-view.vala"
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), BONUS_TEXTURE_SIZE_MULTIPLIER * width, BONUS_TEXTURE_SIZE_MULTIPLIER * height);
#line 691 "nibbles-view.c"
}

BonusTexture*
bonus_texture_construct (GType object_type)
{
	BonusTexture * self = NULL;
#line 48 "nibbles-view.vala"
	self = (BonusTexture*) g_object_new (object_type, NULL);
#line 48 "nibbles-view.vala"
	return self;
#line 702 "nibbles-view.c"
}

BonusTexture*
bonus_texture_new (void)
{
#line 48 "nibbles-view.vala"
	return bonus_texture_construct (TYPE_BONUS_TEXTURE);
#line 710 "nibbles-view.c"
}

static void
bonus_texture_class_init (BonusTextureClass * klass,
                          gpointer klass_data)
{
#line 48 "nibbles-view.vala"
	bonus_texture_parent_class = g_type_class_peek_parent (klass);
#line 48 "nibbles-view.vala"
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor*)) bonus_texture_real_show;
#line 721 "nibbles-view.c"
}

static void
bonus_texture_instance_init (BonusTexture * self,
                             gpointer klass)
{
}

GType
bonus_texture_get_type (void)
{
	static volatile gsize bonus_texture_type_id__volatile = 0;
	if (g_once_init_enter (&bonus_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BonusTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bonus_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BonusTexture), 0, (GInstanceInitFunc) bonus_texture_instance_init, NULL };
		GType bonus_texture_type_id;
		bonus_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "BonusTexture", &g_define_type_info, 0);
		g_once_init_leave (&bonus_texture_type_id__volatile, bonus_texture_type_id);
	}
	return bonus_texture_type_id__volatile;
}

static void
warp_texture_real_show (ClutterActor* base)
{
	WarpTexture * self;
#line 78 "nibbles-view.vala"
	self = (WarpTexture*) base;
#line 80 "nibbles-view.vala"
	CLUTTER_ACTOR_CLASS (warp_texture_parent_class)->show ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture));
#line 82 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 83 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 3.0, 3.0);
#line 85 "nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 86 "nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_CIRC);
#line 87 "nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 88 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 1.0, 1.0);
#line 89 "nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 90 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0xff);
#line 91 "nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 769 "nibbles-view.c"
}

static void
warp_texture_real_hide (ClutterActor* base)
{
	WarpTexture * self;
#line 94 "nibbles-view.vala"
	self = (WarpTexture*) base;
#line 96 "nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) self);
#line 97 "nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
#line 98 "nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 99 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, (gdouble) 0.4f, (gdouble) 0.4f);
#line 100 "nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
#line 101 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 102 "nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) self);
#line 792 "nibbles-view.c"
}

void
warp_texture_set_size (WarpTexture* self,
                       gfloat width,
                       gfloat height)
{
#line 105 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 107 "nibbles-view.vala"
	clutter_actor_set_size ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_clutter_texture_get_type (), GtkClutterTexture), WARP_TEXTURE_SIZE_MULTIPLIER * width, WARP_TEXTURE_SIZE_MULTIPLIER * height);
#line 804 "nibbles-view.c"
}

WarpTexture*
warp_texture_construct (GType object_type)
{
	WarpTexture * self = NULL;
#line 74 "nibbles-view.vala"
	self = (WarpTexture*) g_object_new (object_type, NULL);
#line 74 "nibbles-view.vala"
	return self;
#line 815 "nibbles-view.c"
}

WarpTexture*
warp_texture_new (void)
{
#line 74 "nibbles-view.vala"
	return warp_texture_construct (TYPE_WARP_TEXTURE);
#line 823 "nibbles-view.c"
}

static void
warp_texture_class_init (WarpTextureClass * klass,
                         gpointer klass_data)
{
#line 74 "nibbles-view.vala"
	warp_texture_parent_class = g_type_class_peek_parent (klass);
#line 74 "nibbles-view.vala"
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor*)) warp_texture_real_show;
#line 74 "nibbles-view.vala"
	((ClutterActorClass *) klass)->hide = (void (*) (ClutterActor*)) warp_texture_real_hide;
#line 836 "nibbles-view.c"
}

static void
warp_texture_instance_init (WarpTexture * self,
                            gpointer klass)
{
}

GType
warp_texture_get_type (void)
{
	static volatile gsize warp_texture_type_id__volatile = 0;
	if (g_once_init_enter (&warp_texture_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WarpTextureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_texture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpTexture), 0, (GInstanceInitFunc) warp_texture_instance_init, NULL };
		GType warp_texture_type_id;
		warp_texture_type_id = g_type_register_static (gtk_clutter_texture_get_type (), "WarpTexture", &g_define_type_info, 0);
		g_once_init_leave (&warp_texture_type_id__volatile, warp_texture_type_id);
	}
	return warp_texture_type_id__volatile;
}

static inline gpointer
nibbles_view_get_instance_private (NibblesView* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 168 "nibbles-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 869 "nibbles-view.c"
}

NibblesView*
nibbles_view_construct (GType object_type,
                        NibblesGame* game)
{
	NibblesView * self = NULL;
	ClutterActor* _tmp0_;
	ClutterStage* _tmp1_;
	ClutterColor stage_color = {0};
	ClutterColor _tmp2_ = {0};
	ClutterStage* _tmp3_;
	ClutterColor _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
#line 164 "nibbles-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 164 "nibbles-view.vala"
	self = (NibblesView*) g_object_new (object_type, NULL);
#line 166 "nibbles-view.vala"
	nibbles_view_set_game (self, game);
#line 168 "nibbles-view.vala"
	_tmp0_ = gtk_clutter_embed_get_stage ((GtkClutterEmbed*) self);
#line 168 "nibbles-view.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, clutter_stage_get_type (), ClutterStage));
#line 168 "nibbles-view.vala"
	_g_object_unref0 (self->priv->stage);
#line 168 "nibbles-view.vala"
	self->priv->stage = _tmp1_;
#line 169 "nibbles-view.vala"
	_tmp2_.red = (guint8) 0x00;
#line 169 "nibbles-view.vala"
	_tmp2_.green = (guint8) 0x00;
#line 169 "nibbles-view.vala"
	_tmp2_.blue = (guint8) 0x00;
#line 169 "nibbles-view.vala"
	_tmp2_.alpha = (guint8) 0xff;
#line 169 "nibbles-view.vala"
	stage_color = _tmp2_;
#line 170 "nibbles-view.vala"
	_tmp3_ = self->priv->stage;
#line 170 "nibbles-view.vala"
	_tmp4_ = stage_color;
#line 170 "nibbles-view.vala"
	clutter_actor_set_background_color ((ClutterActor*) _tmp3_, &_tmp4_);
#line 172 "nibbles-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_WIDTH, NIBBLES_GAME_MINIMUM_TILE_SIZE * NIBBLES_GAME_HEIGHT);
#line 175 "nibbles-view.vala"
	_tmp5_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM_ACTOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 175 "nibbles-view.vala"
	_g_object_unref0 (self->priv->worm_actors);
#line 175 "nibbles-view.vala"
	self->priv->worm_actors = _tmp5_;
#line 176 "nibbles-view.vala"
	_tmp6_ = gee_hash_map_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_BONUS_TEXTURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 176 "nibbles-view.vala"
	_g_object_unref0 (self->priv->bonus_actors);
#line 176 "nibbles-view.vala"
	self->priv->bonus_actors = _tmp6_;
#line 177 "nibbles-view.vala"
	_tmp7_ = gee_hash_map_new (TYPE_WARP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WARP_TEXTURE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 177 "nibbles-view.vala"
	_g_object_unref0 (self->priv->warp_actors);
#line 177 "nibbles-view.vala"
	self->priv->warp_actors = _tmp7_;
#line 179 "nibbles-view.vala"
	nibbles_view_load_pixmap (self);
#line 164 "nibbles-view.vala"
	return self;
#line 940 "nibbles-view.c"
}

NibblesView*
nibbles_view_new (NibblesGame* game)
{
#line 164 "nibbles-view.vala"
	return nibbles_view_construct (TYPE_NIBBLES_VIEW, game);
#line 948 "nibbles-view.c"
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
#line 3656 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 3658 "glib-2.0.vapi"
	ret = NULL;
#line 3659 "glib-2.0.vapi"
	while (TRUE) {
#line 964 "nibbles-view.c"
		GString* _tmp0_;
		GString* _tmp2_;
#line 3659 "glib-2.0.vapi"
		c = fgetc (self);
#line 3659 "glib-2.0.vapi"
		if (!(c != EOF)) {
#line 3659 "glib-2.0.vapi"
			break;
#line 973 "nibbles-view.c"
		}
#line 3660 "glib-2.0.vapi"
		_tmp0_ = ret;
#line 3660 "glib-2.0.vapi"
		if (_tmp0_ == NULL) {
#line 979 "nibbles-view.c"
			GString* _tmp1_;
#line 3661 "glib-2.0.vapi"
			_tmp1_ = g_string_new ("");
#line 3661 "glib-2.0.vapi"
			_g_string_free0 (ret);
#line 3661 "glib-2.0.vapi"
			ret = _tmp1_;
#line 987 "nibbles-view.c"
		}
#line 3663 "glib-2.0.vapi"
		if (c == ((gint) '\n')) {
#line 3664 "glib-2.0.vapi"
			break;
#line 993 "nibbles-view.c"
		}
#line 3666 "glib-2.0.vapi"
		_tmp2_ = ret;
#line 3666 "glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
#line 999 "nibbles-view.c"
	}
#line 3668 "glib-2.0.vapi"
	_tmp3_ = ret;
#line 3668 "glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 3669 "glib-2.0.vapi"
		result = NULL;
#line 3669 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3669 "glib-2.0.vapi"
		return result;
#line 1011 "nibbles-view.c"
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
#line 3671 "glib-2.0.vapi"
		_tmp4_ = ret;
#line 3671 "glib-2.0.vapi"
		_tmp5_ = ((GString*) _tmp4_)->str;
#line 3671 "glib-2.0.vapi"
		_tmp6_ = g_strdup (_tmp5_);
#line 3671 "glib-2.0.vapi"
		result = _tmp6_;
#line 3671 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 3671 "glib-2.0.vapi"
		return result;
#line 1028 "nibbles-view.c"
	}
#line 3656 "glib-2.0.vapi"
	_g_string_free0 (ret);
#line 1032 "nibbles-view.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1180 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1181 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1181 "glib-2.0.vapi"
	result = _tmp0_;
#line 1181 "glib-2.0.vapi"
	return result;
#line 1049 "nibbles-view.c"
}

void
nibbles_view_new_level (NibblesView* self,
                        gint level)
{
	gchar* level_name = NULL;
	gchar* filename = NULL;
	gchar* tmpboard = NULL;
	gint count = 0;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* file = NULL;
	const gchar* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	GeeHashMap* _tmp17_;
	GeeHashMap* _tmp28_;
	GeeHashMap* _tmp39_;
	NibblesGame* _tmp40_;
	NibblesGame* _tmp41_;
	Boni* _tmp42_;
	Boni* _tmp43_;
	NibblesGame* _tmp44_;
	NibblesGame* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	NibblesGame* _tmp48_;
	NibblesGame* _tmp49_;
	WarpManager* _tmp50_;
	WarpManager* _tmp51_;
	GeeLinkedList* _tmp52_;
#line 186 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 191 "nibbles-view.vala"
	count = 0;
#line 193 "nibbles-view.vala"
	_tmp0_ = g_strdup_printf ("level%03d.gnl", level);
#line 193 "nibbles-view.vala"
	_g_free0 (level_name);
#line 193 "nibbles-view.vala"
	level_name = _tmp0_;
#line 194 "nibbles-view.vala"
	_tmp1_ = level_name;
#line 194 "nibbles-view.vala"
	_tmp2_ = g_build_filename (PKGDATADIR, "levels", _tmp1_, NULL, NULL);
#line 194 "nibbles-view.vala"
	_g_free0 (filename);
#line 194 "nibbles-view.vala"
	filename = _tmp2_;
#line 197 "nibbles-view.vala"
	_tmp3_ = filename;
#line 197 "nibbles-view.vala"
	_tmp4_ = g_fopen (_tmp3_, "r");
#line 197 "nibbles-view.vala"
	_fclose0 (file);
#line 197 "nibbles-view.vala"
	file = _tmp4_;
#line 197 "nibbles-view.vala"
	_tmp5_ = file;
#line 197 "nibbles-view.vala"
	if (_tmp5_ == NULL) {
#line 1113 "nibbles-view.c"
		const gchar* _tmp6_;
#line 198 "nibbles-view.vala"
		_tmp6_ = filename;
#line 198 "nibbles-view.vala"
		g_error ("nibbles-view.vala:198: Nibbles couldn't find pixmap file: %s", _tmp6_);
#line 1119 "nibbles-view.c"
	}
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeCollection* _tmp10_;
		GeeIterator* _tmp11_;
		GeeIterator* _tmp12_;
#line 200 "nibbles-view.vala"
		_tmp7_ = self->priv->worm_actors;
#line 200 "nibbles-view.vala"
		_tmp8_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp7_);
#line 200 "nibbles-view.vala"
		_tmp9_ = _tmp8_;
#line 200 "nibbles-view.vala"
		_tmp10_ = _tmp9_;
#line 200 "nibbles-view.vala"
		_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
#line 200 "nibbles-view.vala"
		_tmp12_ = _tmp11_;
#line 200 "nibbles-view.vala"
		_g_object_unref0 (_tmp10_);
#line 200 "nibbles-view.vala"
		_actor_it = _tmp12_;
#line 200 "nibbles-view.vala"
		while (TRUE) {
#line 1147 "nibbles-view.c"
			GeeIterator* _tmp13_;
			WormActor* actor = NULL;
			GeeIterator* _tmp14_;
			gpointer _tmp15_;
			WormActor* _tmp16_;
#line 200 "nibbles-view.vala"
			_tmp13_ = _actor_it;
#line 200 "nibbles-view.vala"
			if (!gee_iterator_next (_tmp13_)) {
#line 200 "nibbles-view.vala"
				break;
#line 1159 "nibbles-view.c"
			}
#line 200 "nibbles-view.vala"
			_tmp14_ = _actor_it;
#line 200 "nibbles-view.vala"
			_tmp15_ = gee_iterator_get (_tmp14_);
#line 200 "nibbles-view.vala"
			actor = (WormActor*) _tmp15_;
#line 201 "nibbles-view.vala"
			_tmp16_ = actor;
#line 201 "nibbles-view.vala"
			clutter_actor_destroy ((ClutterActor*) _tmp16_);
#line 200 "nibbles-view.vala"
			_g_object_unref0 (actor);
#line 1173 "nibbles-view.c"
		}
#line 200 "nibbles-view.vala"
		_g_object_unref0 (_actor_it);
#line 1177 "nibbles-view.c"
	}
#line 202 "nibbles-view.vala"
	_tmp17_ = self->priv->worm_actors;
#line 202 "nibbles-view.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp17_);
#line 1183 "nibbles-view.c"
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp18_;
		GeeCollection* _tmp19_;
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeIterator* _tmp22_;
		GeeIterator* _tmp23_;
#line 204 "nibbles-view.vala"
		_tmp18_ = self->priv->bonus_actors;
#line 204 "nibbles-view.vala"
		_tmp19_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp18_);
#line 204 "nibbles-view.vala"
		_tmp20_ = _tmp19_;
#line 204 "nibbles-view.vala"
		_tmp21_ = _tmp20_;
#line 204 "nibbles-view.vala"
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
#line 204 "nibbles-view.vala"
		_tmp23_ = _tmp22_;
#line 204 "nibbles-view.vala"
		_g_object_unref0 (_tmp21_);
#line 204 "nibbles-view.vala"
		_actor_it = _tmp23_;
#line 204 "nibbles-view.vala"
		while (TRUE) {
#line 1210 "nibbles-view.c"
			GeeIterator* _tmp24_;
			BonusTexture* actor = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			BonusTexture* _tmp27_;
#line 204 "nibbles-view.vala"
			_tmp24_ = _actor_it;
#line 204 "nibbles-view.vala"
			if (!gee_iterator_next (_tmp24_)) {
#line 204 "nibbles-view.vala"
				break;
#line 1222 "nibbles-view.c"
			}
#line 204 "nibbles-view.vala"
			_tmp25_ = _actor_it;
#line 204 "nibbles-view.vala"
			_tmp26_ = gee_iterator_get (_tmp25_);
#line 204 "nibbles-view.vala"
			actor = (BonusTexture*) _tmp26_;
#line 205 "nibbles-view.vala"
			_tmp27_ = actor;
#line 205 "nibbles-view.vala"
			clutter_actor_destroy ((ClutterActor*) _tmp27_);
#line 204 "nibbles-view.vala"
			_g_object_unref0 (actor);
#line 1236 "nibbles-view.c"
		}
#line 204 "nibbles-view.vala"
		_g_object_unref0 (_actor_it);
#line 1240 "nibbles-view.c"
	}
#line 206 "nibbles-view.vala"
	_tmp28_ = self->priv->bonus_actors;
#line 206 "nibbles-view.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp28_);
#line 1246 "nibbles-view.c"
	{
		GeeIterator* _actor_it = NULL;
		GeeHashMap* _tmp29_;
		GeeCollection* _tmp30_;
		GeeCollection* _tmp31_;
		GeeCollection* _tmp32_;
		GeeIterator* _tmp33_;
		GeeIterator* _tmp34_;
#line 208 "nibbles-view.vala"
		_tmp29_ = self->priv->warp_actors;
#line 208 "nibbles-view.vala"
		_tmp30_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp29_);
#line 208 "nibbles-view.vala"
		_tmp31_ = _tmp30_;
#line 208 "nibbles-view.vala"
		_tmp32_ = _tmp31_;
#line 208 "nibbles-view.vala"
		_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
#line 208 "nibbles-view.vala"
		_tmp34_ = _tmp33_;
#line 208 "nibbles-view.vala"
		_g_object_unref0 (_tmp32_);
#line 208 "nibbles-view.vala"
		_actor_it = _tmp34_;
#line 208 "nibbles-view.vala"
		while (TRUE) {
#line 1273 "nibbles-view.c"
			GeeIterator* _tmp35_;
			WarpTexture* actor = NULL;
			GeeIterator* _tmp36_;
			gpointer _tmp37_;
			WarpTexture* _tmp38_;
#line 208 "nibbles-view.vala"
			_tmp35_ = _actor_it;
#line 208 "nibbles-view.vala"
			if (!gee_iterator_next (_tmp35_)) {
#line 208 "nibbles-view.vala"
				break;
#line 1285 "nibbles-view.c"
			}
#line 208 "nibbles-view.vala"
			_tmp36_ = _actor_it;
#line 208 "nibbles-view.vala"
			_tmp37_ = gee_iterator_get (_tmp36_);
#line 208 "nibbles-view.vala"
			actor = (WarpTexture*) _tmp37_;
#line 209 "nibbles-view.vala"
			_tmp38_ = actor;
#line 209 "nibbles-view.vala"
			clutter_actor_destroy ((ClutterActor*) _tmp38_);
#line 208 "nibbles-view.vala"
			_g_object_unref0 (actor);
#line 1299 "nibbles-view.c"
		}
#line 208 "nibbles-view.vala"
		_g_object_unref0 (_actor_it);
#line 1303 "nibbles-view.c"
	}
#line 210 "nibbles-view.vala"
	_tmp39_ = self->priv->warp_actors;
#line 210 "nibbles-view.vala"
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp39_);
#line 212 "nibbles-view.vala"
	_tmp40_ = nibbles_view_get_game (self);
#line 212 "nibbles-view.vala"
	_tmp41_ = _tmp40_;
#line 212 "nibbles-view.vala"
	_tmp42_ = nibbles_game_get_boni (_tmp41_);
#line 212 "nibbles-view.vala"
	_tmp43_ = _tmp42_;
#line 212 "nibbles-view.vala"
	_tmp44_ = nibbles_view_get_game (self);
#line 212 "nibbles-view.vala"
	_tmp45_ = _tmp44_;
#line 212 "nibbles-view.vala"
	_tmp46_ = nibbles_game_get_numworms (_tmp45_);
#line 212 "nibbles-view.vala"
	_tmp47_ = _tmp46_;
#line 212 "nibbles-view.vala"
	boni_reset (_tmp43_, _tmp47_);
#line 213 "nibbles-view.vala"
	_tmp48_ = nibbles_view_get_game (self);
#line 213 "nibbles-view.vala"
	_tmp49_ = _tmp48_;
#line 213 "nibbles-view.vala"
	_tmp50_ = nibbles_game_get_warp_manager (_tmp49_);
#line 213 "nibbles-view.vala"
	_tmp51_ = _tmp50_;
#line 213 "nibbles-view.vala"
	_tmp52_ = _tmp51_->warps;
#line 213 "nibbles-view.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp52_);
#line 1339 "nibbles-view.c"
	{
		gint i = 0;
#line 215 "nibbles-view.vala"
		i = 0;
#line 1344 "nibbles-view.c"
		{
			gboolean _tmp53_ = FALSE;
#line 215 "nibbles-view.vala"
			_tmp53_ = TRUE;
#line 215 "nibbles-view.vala"
			while (TRUE) {
#line 1351 "nibbles-view.c"
				FILE* _tmp55_;
				gchar* _tmp56_;
				const gchar* _tmp57_;
#line 215 "nibbles-view.vala"
				if (!_tmp53_) {
#line 1357 "nibbles-view.c"
					gint _tmp54_;
#line 215 "nibbles-view.vala"
					_tmp54_ = i;
#line 215 "nibbles-view.vala"
					i = _tmp54_ + 1;
#line 1363 "nibbles-view.c"
				}
#line 215 "nibbles-view.vala"
				_tmp53_ = FALSE;
#line 215 "nibbles-view.vala"
				if (!(i < NIBBLES_GAME_HEIGHT)) {
#line 215 "nibbles-view.vala"
					break;
#line 1371 "nibbles-view.c"
				}
#line 217 "nibbles-view.vala"
				_tmp55_ = file;
#line 217 "nibbles-view.vala"
				_tmp56_ = g_file_stream_read_line (_tmp55_);
#line 217 "nibbles-view.vala"
				_g_free0 (tmpboard);
#line 217 "nibbles-view.vala"
				tmpboard = _tmp56_;
#line 217 "nibbles-view.vala"
				_tmp57_ = tmpboard;
#line 217 "nibbles-view.vala"
				if (_tmp57_ == NULL) {
#line 1385 "nibbles-view.c"
					const gchar* _tmp58_;
#line 218 "nibbles-view.vala"
					_tmp58_ = filename;
#line 218 "nibbles-view.vala"
					g_error ("nibbles-view.vala:218: Level file appears to be damaged: %s", _tmp58_);
#line 1391 "nibbles-view.c"
				}
				{
					gint j = 0;
#line 220 "nibbles-view.vala"
					j = 0;
#line 1397 "nibbles-view.c"
					{
						gboolean _tmp59_ = FALSE;
#line 220 "nibbles-view.vala"
						_tmp59_ = TRUE;
#line 220 "nibbles-view.vala"
						while (TRUE) {
#line 1404 "nibbles-view.c"
							NibblesGame* _tmp61_;
							NibblesGame* _tmp62_;
							gint* _tmp63_;
							gint _tmp63__length1;
							gint _tmp63__length2;
							const gchar* _tmp64_;
							NibblesGame* _tmp65_;
							NibblesGame* _tmp66_;
							gint* _tmp67_;
							gint _tmp67__length1;
							gint _tmp67__length2;
							gint _tmp68_;
#line 220 "nibbles-view.vala"
							if (!_tmp59_) {
#line 1419 "nibbles-view.c"
								gint _tmp60_;
#line 220 "nibbles-view.vala"
								_tmp60_ = j;
#line 220 "nibbles-view.vala"
								j = _tmp60_ + 1;
#line 1425 "nibbles-view.c"
							}
#line 220 "nibbles-view.vala"
							_tmp59_ = FALSE;
#line 220 "nibbles-view.vala"
							if (!(j < NIBBLES_GAME_WIDTH)) {
#line 220 "nibbles-view.vala"
								break;
#line 1433 "nibbles-view.c"
							}
#line 222 "nibbles-view.vala"
							_tmp61_ = nibbles_view_get_game (self);
#line 222 "nibbles-view.vala"
							_tmp62_ = _tmp61_;
#line 222 "nibbles-view.vala"
							_tmp63_ = _tmp62_->board;
#line 222 "nibbles-view.vala"
							_tmp63__length1 = _tmp62_->board_length1;
#line 222 "nibbles-view.vala"
							_tmp63__length2 = _tmp62_->board_length2;
#line 222 "nibbles-view.vala"
							_tmp64_ = tmpboard;
#line 222 "nibbles-view.vala"
							_tmp63_[(j * _tmp63__length2) + i] = (gint) string_get (_tmp64_, (glong) j);
#line 223 "nibbles-view.vala"
							_tmp65_ = nibbles_view_get_game (self);
#line 223 "nibbles-view.vala"
							_tmp66_ = _tmp65_;
#line 223 "nibbles-view.vala"
							_tmp67_ = _tmp66_->board;
#line 223 "nibbles-view.vala"
							_tmp67__length1 = _tmp66_->board_length1;
#line 223 "nibbles-view.vala"
							_tmp67__length2 = _tmp66_->board_length2;
#line 223 "nibbles-view.vala"
							_tmp68_ = _tmp67_[(j * _tmp67__length2) + i];
#line 223 "nibbles-view.vala"
							switch (_tmp68_) {
#line 223 "nibbles-view.vala"
								case 'm':
#line 1465 "nibbles-view.c"
								{
									NibblesGame* _tmp69_;
									NibblesGame* _tmp70_;
									gint* _tmp71_;
									gint _tmp71__length1;
									gint _tmp71__length2;
									NibblesGame* _tmp72_;
									NibblesGame* _tmp73_;
									gint _tmp74_;
									gint _tmp75_;
#line 226 "nibbles-view.vala"
									_tmp69_ = nibbles_view_get_game (self);
#line 226 "nibbles-view.vala"
									_tmp70_ = _tmp69_;
#line 226 "nibbles-view.vala"
									_tmp71_ = _tmp70_->board;
#line 226 "nibbles-view.vala"
									_tmp71__length1 = _tmp70_->board_length1;
#line 226 "nibbles-view.vala"
									_tmp71__length2 = _tmp70_->board_length2;
#line 226 "nibbles-view.vala"
									_tmp71_[(j * _tmp71__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 227 "nibbles-view.vala"
									_tmp72_ = nibbles_view_get_game (self);
#line 227 "nibbles-view.vala"
									_tmp73_ = _tmp72_;
#line 227 "nibbles-view.vala"
									_tmp74_ = nibbles_game_get_numworms (_tmp73_);
#line 227 "nibbles-view.vala"
									_tmp75_ = _tmp74_;
#line 227 "nibbles-view.vala"
									if (count < _tmp75_) {
#line 1498 "nibbles-view.c"
										NibblesGame* _tmp76_;
										NibblesGame* _tmp77_;
										GeeLinkedList* _tmp78_;
										GeeLinkedList* _tmp79_;
										gpointer _tmp80_;
										Worm* _tmp81_;
										WormActor* actors = NULL;
										WormActor* _tmp82_;
										ClutterStage* _tmp83_;
										WormActor* _tmp84_;
										GeeHashMap* _tmp85_;
										NibblesGame* _tmp86_;
										NibblesGame* _tmp87_;
										GeeLinkedList* _tmp88_;
										GeeLinkedList* _tmp89_;
										gpointer _tmp90_;
										Worm* _tmp91_;
										WormActor* _tmp92_;
										gint _tmp93_;
#line 229 "nibbles-view.vala"
										_tmp76_ = nibbles_view_get_game (self);
#line 229 "nibbles-view.vala"
										_tmp77_ = _tmp76_;
#line 229 "nibbles-view.vala"
										_tmp78_ = nibbles_game_get_worms (_tmp77_);
#line 229 "nibbles-view.vala"
										_tmp79_ = _tmp78_;
#line 229 "nibbles-view.vala"
										_tmp80_ = gee_abstract_list_get ((GeeAbstractList*) _tmp79_, count);
#line 229 "nibbles-view.vala"
										_tmp81_ = (Worm*) _tmp80_;
#line 229 "nibbles-view.vala"
										worm_set_start (_tmp81_, j, i, WORM_DIRECTION_UP);
#line 229 "nibbles-view.vala"
										_g_object_unref0 (_tmp81_);
#line 231 "nibbles-view.vala"
										_tmp82_ = worm_actor_new ();
#line 231 "nibbles-view.vala"
										g_object_ref_sink (_tmp82_);
#line 231 "nibbles-view.vala"
										actors = _tmp82_;
#line 232 "nibbles-view.vala"
										_tmp83_ = self->priv->stage;
#line 232 "nibbles-view.vala"
										_tmp84_ = actors;
#line 232 "nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp83_, (ClutterActor*) _tmp84_);
#line 233 "nibbles-view.vala"
										_tmp85_ = self->priv->worm_actors;
#line 233 "nibbles-view.vala"
										_tmp86_ = nibbles_view_get_game (self);
#line 233 "nibbles-view.vala"
										_tmp87_ = _tmp86_;
#line 233 "nibbles-view.vala"
										_tmp88_ = nibbles_game_get_worms (_tmp87_);
#line 233 "nibbles-view.vala"
										_tmp89_ = _tmp88_;
#line 233 "nibbles-view.vala"
										_tmp90_ = gee_abstract_list_get ((GeeAbstractList*) _tmp89_, count);
#line 233 "nibbles-view.vala"
										_tmp91_ = (Worm*) _tmp90_;
#line 233 "nibbles-view.vala"
										_tmp92_ = actors;
#line 233 "nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp85_, _tmp91_, _tmp92_);
#line 233 "nibbles-view.vala"
										_g_object_unref0 (_tmp91_);
#line 234 "nibbles-view.vala"
										_tmp93_ = count;
#line 234 "nibbles-view.vala"
										count = _tmp93_ + 1;
#line 227 "nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1572 "nibbles-view.c"
									}
#line 236 "nibbles-view.vala"
									break;
#line 1576 "nibbles-view.c"
								}
#line 223 "nibbles-view.vala"
								case 'n':
#line 1580 "nibbles-view.c"
								{
									NibblesGame* _tmp94_;
									NibblesGame* _tmp95_;
									gint* _tmp96_;
									gint _tmp96__length1;
									gint _tmp96__length2;
									NibblesGame* _tmp97_;
									NibblesGame* _tmp98_;
									gint _tmp99_;
									gint _tmp100_;
#line 238 "nibbles-view.vala"
									_tmp94_ = nibbles_view_get_game (self);
#line 238 "nibbles-view.vala"
									_tmp95_ = _tmp94_;
#line 238 "nibbles-view.vala"
									_tmp96_ = _tmp95_->board;
#line 238 "nibbles-view.vala"
									_tmp96__length1 = _tmp95_->board_length1;
#line 238 "nibbles-view.vala"
									_tmp96__length2 = _tmp95_->board_length2;
#line 238 "nibbles-view.vala"
									_tmp96_[(j * _tmp96__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 239 "nibbles-view.vala"
									_tmp97_ = nibbles_view_get_game (self);
#line 239 "nibbles-view.vala"
									_tmp98_ = _tmp97_;
#line 239 "nibbles-view.vala"
									_tmp99_ = nibbles_game_get_numworms (_tmp98_);
#line 239 "nibbles-view.vala"
									_tmp100_ = _tmp99_;
#line 239 "nibbles-view.vala"
									if (count < _tmp100_) {
#line 1613 "nibbles-view.c"
										NibblesGame* _tmp101_;
										NibblesGame* _tmp102_;
										GeeLinkedList* _tmp103_;
										GeeLinkedList* _tmp104_;
										gpointer _tmp105_;
										Worm* _tmp106_;
										WormActor* actors = NULL;
										WormActor* _tmp107_;
										ClutterStage* _tmp108_;
										WormActor* _tmp109_;
										GeeHashMap* _tmp110_;
										NibblesGame* _tmp111_;
										NibblesGame* _tmp112_;
										GeeLinkedList* _tmp113_;
										GeeLinkedList* _tmp114_;
										gpointer _tmp115_;
										Worm* _tmp116_;
										WormActor* _tmp117_;
										gint _tmp118_;
#line 241 "nibbles-view.vala"
										_tmp101_ = nibbles_view_get_game (self);
#line 241 "nibbles-view.vala"
										_tmp102_ = _tmp101_;
#line 241 "nibbles-view.vala"
										_tmp103_ = nibbles_game_get_worms (_tmp102_);
#line 241 "nibbles-view.vala"
										_tmp104_ = _tmp103_;
#line 241 "nibbles-view.vala"
										_tmp105_ = gee_abstract_list_get ((GeeAbstractList*) _tmp104_, count);
#line 241 "nibbles-view.vala"
										_tmp106_ = (Worm*) _tmp105_;
#line 241 "nibbles-view.vala"
										worm_set_start (_tmp106_, j, i, WORM_DIRECTION_LEFT);
#line 241 "nibbles-view.vala"
										_g_object_unref0 (_tmp106_);
#line 243 "nibbles-view.vala"
										_tmp107_ = worm_actor_new ();
#line 243 "nibbles-view.vala"
										g_object_ref_sink (_tmp107_);
#line 243 "nibbles-view.vala"
										actors = _tmp107_;
#line 244 "nibbles-view.vala"
										_tmp108_ = self->priv->stage;
#line 244 "nibbles-view.vala"
										_tmp109_ = actors;
#line 244 "nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp108_, (ClutterActor*) _tmp109_);
#line 245 "nibbles-view.vala"
										_tmp110_ = self->priv->worm_actors;
#line 245 "nibbles-view.vala"
										_tmp111_ = nibbles_view_get_game (self);
#line 245 "nibbles-view.vala"
										_tmp112_ = _tmp111_;
#line 245 "nibbles-view.vala"
										_tmp113_ = nibbles_game_get_worms (_tmp112_);
#line 245 "nibbles-view.vala"
										_tmp114_ = _tmp113_;
#line 245 "nibbles-view.vala"
										_tmp115_ = gee_abstract_list_get ((GeeAbstractList*) _tmp114_, count);
#line 245 "nibbles-view.vala"
										_tmp116_ = (Worm*) _tmp115_;
#line 245 "nibbles-view.vala"
										_tmp117_ = actors;
#line 245 "nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp110_, _tmp116_, _tmp117_);
#line 245 "nibbles-view.vala"
										_g_object_unref0 (_tmp116_);
#line 246 "nibbles-view.vala"
										_tmp118_ = count;
#line 246 "nibbles-view.vala"
										count = _tmp118_ + 1;
#line 239 "nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1687 "nibbles-view.c"
									}
#line 248 "nibbles-view.vala"
									break;
#line 1691 "nibbles-view.c"
								}
#line 223 "nibbles-view.vala"
								case 'o':
#line 1695 "nibbles-view.c"
								{
									NibblesGame* _tmp119_;
									NibblesGame* _tmp120_;
									gint* _tmp121_;
									gint _tmp121__length1;
									gint _tmp121__length2;
									NibblesGame* _tmp122_;
									NibblesGame* _tmp123_;
									gint _tmp124_;
									gint _tmp125_;
#line 250 "nibbles-view.vala"
									_tmp119_ = nibbles_view_get_game (self);
#line 250 "nibbles-view.vala"
									_tmp120_ = _tmp119_;
#line 250 "nibbles-view.vala"
									_tmp121_ = _tmp120_->board;
#line 250 "nibbles-view.vala"
									_tmp121__length1 = _tmp120_->board_length1;
#line 250 "nibbles-view.vala"
									_tmp121__length2 = _tmp120_->board_length2;
#line 250 "nibbles-view.vala"
									_tmp121_[(j * _tmp121__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 251 "nibbles-view.vala"
									_tmp122_ = nibbles_view_get_game (self);
#line 251 "nibbles-view.vala"
									_tmp123_ = _tmp122_;
#line 251 "nibbles-view.vala"
									_tmp124_ = nibbles_game_get_numworms (_tmp123_);
#line 251 "nibbles-view.vala"
									_tmp125_ = _tmp124_;
#line 251 "nibbles-view.vala"
									if (count < _tmp125_) {
#line 1728 "nibbles-view.c"
										NibblesGame* _tmp126_;
										NibblesGame* _tmp127_;
										GeeLinkedList* _tmp128_;
										GeeLinkedList* _tmp129_;
										gpointer _tmp130_;
										Worm* _tmp131_;
										WormActor* actors = NULL;
										WormActor* _tmp132_;
										ClutterStage* _tmp133_;
										WormActor* _tmp134_;
										GeeHashMap* _tmp135_;
										NibblesGame* _tmp136_;
										NibblesGame* _tmp137_;
										GeeLinkedList* _tmp138_;
										GeeLinkedList* _tmp139_;
										gpointer _tmp140_;
										Worm* _tmp141_;
										WormActor* _tmp142_;
										gint _tmp143_;
#line 253 "nibbles-view.vala"
										_tmp126_ = nibbles_view_get_game (self);
#line 253 "nibbles-view.vala"
										_tmp127_ = _tmp126_;
#line 253 "nibbles-view.vala"
										_tmp128_ = nibbles_game_get_worms (_tmp127_);
#line 253 "nibbles-view.vala"
										_tmp129_ = _tmp128_;
#line 253 "nibbles-view.vala"
										_tmp130_ = gee_abstract_list_get ((GeeAbstractList*) _tmp129_, count);
#line 253 "nibbles-view.vala"
										_tmp131_ = (Worm*) _tmp130_;
#line 253 "nibbles-view.vala"
										worm_set_start (_tmp131_, j, i, WORM_DIRECTION_DOWN);
#line 253 "nibbles-view.vala"
										_g_object_unref0 (_tmp131_);
#line 255 "nibbles-view.vala"
										_tmp132_ = worm_actor_new ();
#line 255 "nibbles-view.vala"
										g_object_ref_sink (_tmp132_);
#line 255 "nibbles-view.vala"
										actors = _tmp132_;
#line 256 "nibbles-view.vala"
										_tmp133_ = self->priv->stage;
#line 256 "nibbles-view.vala"
										_tmp134_ = actors;
#line 256 "nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp133_, (ClutterActor*) _tmp134_);
#line 257 "nibbles-view.vala"
										_tmp135_ = self->priv->worm_actors;
#line 257 "nibbles-view.vala"
										_tmp136_ = nibbles_view_get_game (self);
#line 257 "nibbles-view.vala"
										_tmp137_ = _tmp136_;
#line 257 "nibbles-view.vala"
										_tmp138_ = nibbles_game_get_worms (_tmp137_);
#line 257 "nibbles-view.vala"
										_tmp139_ = _tmp138_;
#line 257 "nibbles-view.vala"
										_tmp140_ = gee_abstract_list_get ((GeeAbstractList*) _tmp139_, count);
#line 257 "nibbles-view.vala"
										_tmp141_ = (Worm*) _tmp140_;
#line 257 "nibbles-view.vala"
										_tmp142_ = actors;
#line 257 "nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp135_, _tmp141_, _tmp142_);
#line 257 "nibbles-view.vala"
										_g_object_unref0 (_tmp141_);
#line 258 "nibbles-view.vala"
										_tmp143_ = count;
#line 258 "nibbles-view.vala"
										count = _tmp143_ + 1;
#line 251 "nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1802 "nibbles-view.c"
									}
#line 260 "nibbles-view.vala"
									break;
#line 1806 "nibbles-view.c"
								}
#line 223 "nibbles-view.vala"
								case 'p':
#line 1810 "nibbles-view.c"
								{
									NibblesGame* _tmp144_;
									NibblesGame* _tmp145_;
									gint* _tmp146_;
									gint _tmp146__length1;
									gint _tmp146__length2;
									NibblesGame* _tmp147_;
									NibblesGame* _tmp148_;
									gint _tmp149_;
									gint _tmp150_;
#line 262 "nibbles-view.vala"
									_tmp144_ = nibbles_view_get_game (self);
#line 262 "nibbles-view.vala"
									_tmp145_ = _tmp144_;
#line 262 "nibbles-view.vala"
									_tmp146_ = _tmp145_->board;
#line 262 "nibbles-view.vala"
									_tmp146__length1 = _tmp145_->board_length1;
#line 262 "nibbles-view.vala"
									_tmp146__length2 = _tmp145_->board_length2;
#line 262 "nibbles-view.vala"
									_tmp146_[(j * _tmp146__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 263 "nibbles-view.vala"
									_tmp147_ = nibbles_view_get_game (self);
#line 263 "nibbles-view.vala"
									_tmp148_ = _tmp147_;
#line 263 "nibbles-view.vala"
									_tmp149_ = nibbles_game_get_numworms (_tmp148_);
#line 263 "nibbles-view.vala"
									_tmp150_ = _tmp149_;
#line 263 "nibbles-view.vala"
									if (count < _tmp150_) {
#line 1843 "nibbles-view.c"
										NibblesGame* _tmp151_;
										NibblesGame* _tmp152_;
										GeeLinkedList* _tmp153_;
										GeeLinkedList* _tmp154_;
										gpointer _tmp155_;
										Worm* _tmp156_;
										WormActor* actors = NULL;
										WormActor* _tmp157_;
										ClutterStage* _tmp158_;
										WormActor* _tmp159_;
										GeeHashMap* _tmp160_;
										NibblesGame* _tmp161_;
										NibblesGame* _tmp162_;
										GeeLinkedList* _tmp163_;
										GeeLinkedList* _tmp164_;
										gpointer _tmp165_;
										Worm* _tmp166_;
										WormActor* _tmp167_;
										gint _tmp168_;
#line 265 "nibbles-view.vala"
										_tmp151_ = nibbles_view_get_game (self);
#line 265 "nibbles-view.vala"
										_tmp152_ = _tmp151_;
#line 265 "nibbles-view.vala"
										_tmp153_ = nibbles_game_get_worms (_tmp152_);
#line 265 "nibbles-view.vala"
										_tmp154_ = _tmp153_;
#line 265 "nibbles-view.vala"
										_tmp155_ = gee_abstract_list_get ((GeeAbstractList*) _tmp154_, count);
#line 265 "nibbles-view.vala"
										_tmp156_ = (Worm*) _tmp155_;
#line 265 "nibbles-view.vala"
										worm_set_start (_tmp156_, j, i, WORM_DIRECTION_RIGHT);
#line 265 "nibbles-view.vala"
										_g_object_unref0 (_tmp156_);
#line 267 "nibbles-view.vala"
										_tmp157_ = worm_actor_new ();
#line 267 "nibbles-view.vala"
										g_object_ref_sink (_tmp157_);
#line 267 "nibbles-view.vala"
										actors = _tmp157_;
#line 268 "nibbles-view.vala"
										_tmp158_ = self->priv->stage;
#line 268 "nibbles-view.vala"
										_tmp159_ = actors;
#line 268 "nibbles-view.vala"
										clutter_actor_add_child ((ClutterActor*) _tmp158_, (ClutterActor*) _tmp159_);
#line 269 "nibbles-view.vala"
										_tmp160_ = self->priv->worm_actors;
#line 269 "nibbles-view.vala"
										_tmp161_ = nibbles_view_get_game (self);
#line 269 "nibbles-view.vala"
										_tmp162_ = _tmp161_;
#line 269 "nibbles-view.vala"
										_tmp163_ = nibbles_game_get_worms (_tmp162_);
#line 269 "nibbles-view.vala"
										_tmp164_ = _tmp163_;
#line 269 "nibbles-view.vala"
										_tmp165_ = gee_abstract_list_get ((GeeAbstractList*) _tmp164_, count);
#line 269 "nibbles-view.vala"
										_tmp166_ = (Worm*) _tmp165_;
#line 269 "nibbles-view.vala"
										_tmp167_ = actors;
#line 269 "nibbles-view.vala"
										gee_abstract_map_set ((GeeAbstractMap*) _tmp160_, _tmp166_, _tmp167_);
#line 269 "nibbles-view.vala"
										_g_object_unref0 (_tmp166_);
#line 270 "nibbles-view.vala"
										_tmp168_ = count;
#line 270 "nibbles-view.vala"
										count = _tmp168_ + 1;
#line 263 "nibbles-view.vala"
										_g_object_unref0 (actors);
#line 1917 "nibbles-view.c"
									}
#line 272 "nibbles-view.vala"
									break;
#line 1921 "nibbles-view.c"
								}
								default:
								{
#line 274 "nibbles-view.vala"
									break;
#line 1927 "nibbles-view.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 279 "nibbles-view.vala"
	nibbles_view_load_level (self);
#line 186 "nibbles-view.vala"
	_fclose0 (file);
#line 186 "nibbles-view.vala"
	_g_free0 (tmpboard);
#line 186 "nibbles-view.vala"
	_g_free0 (filename);
#line 186 "nibbles-view.vala"
	_g_free0 (level_name);
#line 1946 "nibbles-view.c"
}

static void
nibbles_view_load_level (NibblesView* self)
{
	gint x_pos = 0;
	gint y_pos = 0;
	GtkClutterTexture* tmp = NULL;
	gboolean is_wall = FALSE;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp4_;
	ClutterStage* _tmp92_;
	ClutterActor* _tmp93_;
	ClutterActor* _tmp94_;
	ClutterActor* _tmp95_;
	ClutterActor* _tmp96_;
	ClutterActor* _tmp97_;
	ClutterActor* _tmp98_;
	ClutterActor* _tmp99_;
	ClutterActor* _tmp100_;
	ClutterActor* _tmp101_;
	ClutterActor* _tmp102_;
	GError* _inner_error0_ = NULL;
#line 282 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 285 "nibbles-view.vala"
	tmp = NULL;
#line 286 "nibbles-view.vala"
	is_wall = TRUE;
#line 288 "nibbles-view.vala"
	_tmp0_ = self->priv->level;
#line 288 "nibbles-view.vala"
	if (_tmp0_ != NULL) {
#line 1980 "nibbles-view.c"
		ClutterActor* _tmp1_;
		ClutterStage* _tmp2_;
		ClutterActor* _tmp3_;
#line 290 "nibbles-view.vala"
		_tmp1_ = self->priv->level;
#line 290 "nibbles-view.vala"
		clutter_actor_remove_all_children (_tmp1_);
#line 291 "nibbles-view.vala"
		_tmp2_ = self->priv->stage;
#line 291 "nibbles-view.vala"
		_tmp3_ = self->priv->level;
#line 291 "nibbles-view.vala"
		clutter_actor_remove_child ((ClutterActor*) _tmp2_, _tmp3_);
#line 1994 "nibbles-view.c"
	}
#line 294 "nibbles-view.vala"
	_tmp4_ = clutter_actor_new ();
#line 294 "nibbles-view.vala"
	g_object_ref_sink (_tmp4_);
#line 294 "nibbles-view.vala"
	_g_object_unref0 (self->priv->level);
#line 294 "nibbles-view.vala"
	self->priv->level = _tmp4_;
#line 2004 "nibbles-view.c"
	{
		gint i = 0;
#line 297 "nibbles-view.vala"
		i = 0;
#line 2009 "nibbles-view.c"
		{
			gboolean _tmp5_ = FALSE;
#line 297 "nibbles-view.vala"
			_tmp5_ = TRUE;
#line 297 "nibbles-view.vala"
			while (TRUE) {
#line 2016 "nibbles-view.c"
				NibblesGame* _tmp7_;
				NibblesGame* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
#line 297 "nibbles-view.vala"
				if (!_tmp5_) {
#line 2023 "nibbles-view.c"
					gint _tmp6_;
#line 297 "nibbles-view.vala"
					_tmp6_ = i;
#line 297 "nibbles-view.vala"
					i = _tmp6_ + 1;
#line 2029 "nibbles-view.c"
				}
#line 297 "nibbles-view.vala"
				_tmp5_ = FALSE;
#line 297 "nibbles-view.vala"
				if (!(i < NIBBLES_GAME_HEIGHT)) {
#line 297 "nibbles-view.vala"
					break;
#line 2037 "nibbles-view.c"
				}
#line 299 "nibbles-view.vala"
				_tmp7_ = nibbles_view_get_game (self);
#line 299 "nibbles-view.vala"
				_tmp8_ = _tmp7_;
#line 299 "nibbles-view.vala"
				_tmp9_ = nibbles_game_get_tile_size (_tmp8_);
#line 299 "nibbles-view.vala"
				_tmp10_ = _tmp9_;
#line 299 "nibbles-view.vala"
				y_pos = i * _tmp10_;
#line 2049 "nibbles-view.c"
				{
					gint j = 0;
#line 300 "nibbles-view.vala"
					j = 0;
#line 2054 "nibbles-view.c"
					{
						gboolean _tmp11_ = FALSE;
#line 300 "nibbles-view.vala"
						_tmp11_ = TRUE;
#line 300 "nibbles-view.vala"
						while (TRUE) {
#line 300 "nibbles-view.vala"
							if (!_tmp11_) {
#line 2063 "nibbles-view.c"
								gint _tmp12_;
#line 300 "nibbles-view.vala"
								_tmp12_ = j;
#line 300 "nibbles-view.vala"
								j = _tmp12_ + 1;
#line 2069 "nibbles-view.c"
							}
#line 300 "nibbles-view.vala"
							_tmp11_ = FALSE;
#line 300 "nibbles-view.vala"
							if (!(j < NIBBLES_GAME_WIDTH)) {
#line 300 "nibbles-view.vala"
								break;
#line 2077 "nibbles-view.c"
							}
#line 302 "nibbles-view.vala"
							is_wall = TRUE;
#line 2081 "nibbles-view.c"
							{
								NibblesGame* _tmp13_;
								NibblesGame* _tmp14_;
								gint* _tmp15_;
								gint _tmp15__length1;
								gint _tmp15__length2;
								gint _tmp16_;
#line 305 "nibbles-view.vala"
								_tmp13_ = nibbles_view_get_game (self);
#line 305 "nibbles-view.vala"
								_tmp14_ = _tmp13_;
#line 305 "nibbles-view.vala"
								_tmp15_ = _tmp14_->board;
#line 305 "nibbles-view.vala"
								_tmp15__length1 = _tmp14_->board_length1;
#line 305 "nibbles-view.vala"
								_tmp15__length2 = _tmp14_->board_length2;
#line 305 "nibbles-view.vala"
								_tmp16_ = _tmp15_[(j * _tmp15__length2) + i];
#line 305 "nibbles-view.vala"
								switch (_tmp16_) {
#line 305 "nibbles-view.vala"
									case 'a':
#line 2105 "nibbles-view.c"
									{
#line 308 "nibbles-view.vala"
										is_wall = FALSE;
#line 309 "nibbles-view.vala"
										break;
#line 2111 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'b':
#line 2115 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp17_;
										GtkClutterTexture* _tmp18_;
										GdkPixbuf* _tmp19_;
#line 311 "nibbles-view.vala"
										_tmp17_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 311 "nibbles-view.vala"
										g_object_ref_sink (_tmp17_);
#line 311 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 311 "nibbles-view.vala"
										tmp = _tmp17_;
#line 312 "nibbles-view.vala"
										_tmp18_ = tmp;
#line 312 "nibbles-view.vala"
										_tmp19_ = self->priv->wall_pixmaps[0];
#line 312 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp18_, _tmp19_, &_inner_error0_);
#line 312 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2136 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 313 "nibbles-view.vala"
										break;
#line 2141 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'c':
#line 2145 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp20_;
										GtkClutterTexture* _tmp21_;
										GdkPixbuf* _tmp22_;
#line 315 "nibbles-view.vala"
										_tmp20_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 315 "nibbles-view.vala"
										g_object_ref_sink (_tmp20_);
#line 315 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 315 "nibbles-view.vala"
										tmp = _tmp20_;
#line 316 "nibbles-view.vala"
										_tmp21_ = tmp;
#line 316 "nibbles-view.vala"
										_tmp22_ = self->priv->wall_pixmaps[1];
#line 316 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp21_, _tmp22_, &_inner_error0_);
#line 316 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2166 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 317 "nibbles-view.vala"
										break;
#line 2171 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'd':
#line 2175 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp23_;
										GtkClutterTexture* _tmp24_;
										GdkPixbuf* _tmp25_;
#line 319 "nibbles-view.vala"
										_tmp23_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 319 "nibbles-view.vala"
										g_object_ref_sink (_tmp23_);
#line 319 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 319 "nibbles-view.vala"
										tmp = _tmp23_;
#line 320 "nibbles-view.vala"
										_tmp24_ = tmp;
#line 320 "nibbles-view.vala"
										_tmp25_ = self->priv->wall_pixmaps[2];
#line 320 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp24_, _tmp25_, &_inner_error0_);
#line 320 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2196 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 321 "nibbles-view.vala"
										break;
#line 2201 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'e':
#line 2205 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp26_;
										GtkClutterTexture* _tmp27_;
										GdkPixbuf* _tmp28_;
#line 323 "nibbles-view.vala"
										_tmp26_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 323 "nibbles-view.vala"
										g_object_ref_sink (_tmp26_);
#line 323 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 323 "nibbles-view.vala"
										tmp = _tmp26_;
#line 324 "nibbles-view.vala"
										_tmp27_ = tmp;
#line 324 "nibbles-view.vala"
										_tmp28_ = self->priv->wall_pixmaps[3];
#line 324 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp27_, _tmp28_, &_inner_error0_);
#line 324 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2226 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 325 "nibbles-view.vala"
										break;
#line 2231 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'f':
#line 2235 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp29_;
										GtkClutterTexture* _tmp30_;
										GdkPixbuf* _tmp31_;
#line 327 "nibbles-view.vala"
										_tmp29_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 327 "nibbles-view.vala"
										g_object_ref_sink (_tmp29_);
#line 327 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 327 "nibbles-view.vala"
										tmp = _tmp29_;
#line 328 "nibbles-view.vala"
										_tmp30_ = tmp;
#line 328 "nibbles-view.vala"
										_tmp31_ = self->priv->wall_pixmaps[4];
#line 328 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp30_, _tmp31_, &_inner_error0_);
#line 328 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2256 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 329 "nibbles-view.vala"
										break;
#line 2261 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'g':
#line 2265 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp32_;
										GtkClutterTexture* _tmp33_;
										GdkPixbuf* _tmp34_;
#line 331 "nibbles-view.vala"
										_tmp32_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 331 "nibbles-view.vala"
										g_object_ref_sink (_tmp32_);
#line 331 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 331 "nibbles-view.vala"
										tmp = _tmp32_;
#line 332 "nibbles-view.vala"
										_tmp33_ = tmp;
#line 332 "nibbles-view.vala"
										_tmp34_ = self->priv->wall_pixmaps[5];
#line 332 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp33_, _tmp34_, &_inner_error0_);
#line 332 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2286 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 333 "nibbles-view.vala"
										break;
#line 2291 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'h':
#line 2295 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp35_;
										GtkClutterTexture* _tmp36_;
										GdkPixbuf* _tmp37_;
#line 335 "nibbles-view.vala"
										_tmp35_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 335 "nibbles-view.vala"
										g_object_ref_sink (_tmp35_);
#line 335 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 335 "nibbles-view.vala"
										tmp = _tmp35_;
#line 336 "nibbles-view.vala"
										_tmp36_ = tmp;
#line 336 "nibbles-view.vala"
										_tmp37_ = self->priv->wall_pixmaps[6];
#line 336 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp36_, _tmp37_, &_inner_error0_);
#line 336 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2316 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 337 "nibbles-view.vala"
										break;
#line 2321 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'i':
#line 2325 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp38_;
										GtkClutterTexture* _tmp39_;
										GdkPixbuf* _tmp40_;
#line 339 "nibbles-view.vala"
										_tmp38_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 339 "nibbles-view.vala"
										g_object_ref_sink (_tmp38_);
#line 339 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 339 "nibbles-view.vala"
										tmp = _tmp38_;
#line 340 "nibbles-view.vala"
										_tmp39_ = tmp;
#line 340 "nibbles-view.vala"
										_tmp40_ = self->priv->wall_pixmaps[7];
#line 340 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp39_, _tmp40_, &_inner_error0_);
#line 340 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2346 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 341 "nibbles-view.vala"
										break;
#line 2351 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'j':
#line 2355 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp41_;
										GtkClutterTexture* _tmp42_;
										GdkPixbuf* _tmp43_;
#line 343 "nibbles-view.vala"
										_tmp41_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 343 "nibbles-view.vala"
										g_object_ref_sink (_tmp41_);
#line 343 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 343 "nibbles-view.vala"
										tmp = _tmp41_;
#line 344 "nibbles-view.vala"
										_tmp42_ = tmp;
#line 344 "nibbles-view.vala"
										_tmp43_ = self->priv->wall_pixmaps[8];
#line 344 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp42_, _tmp43_, &_inner_error0_);
#line 344 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2376 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 345 "nibbles-view.vala"
										break;
#line 2381 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'k':
#line 2385 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp44_;
										GtkClutterTexture* _tmp45_;
										GdkPixbuf* _tmp46_;
#line 347 "nibbles-view.vala"
										_tmp44_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 347 "nibbles-view.vala"
										g_object_ref_sink (_tmp44_);
#line 347 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 347 "nibbles-view.vala"
										tmp = _tmp44_;
#line 348 "nibbles-view.vala"
										_tmp45_ = tmp;
#line 348 "nibbles-view.vala"
										_tmp46_ = self->priv->wall_pixmaps[9];
#line 348 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp45_, _tmp46_, &_inner_error0_);
#line 348 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2406 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 349 "nibbles-view.vala"
										break;
#line 2411 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'l':
#line 2415 "nibbles-view.c"
									{
										GtkClutterTexture* _tmp47_;
										GtkClutterTexture* _tmp48_;
										GdkPixbuf* _tmp49_;
#line 351 "nibbles-view.vala"
										_tmp47_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 351 "nibbles-view.vala"
										g_object_ref_sink (_tmp47_);
#line 351 "nibbles-view.vala"
										_g_object_unref0 (tmp);
#line 351 "nibbles-view.vala"
										tmp = _tmp47_;
#line 352 "nibbles-view.vala"
										_tmp48_ = tmp;
#line 352 "nibbles-view.vala"
										_tmp49_ = self->priv->wall_pixmaps[10];
#line 352 "nibbles-view.vala"
										gtk_clutter_texture_set_from_pixbuf (_tmp48_, _tmp49_, &_inner_error0_);
#line 352 "nibbles-view.vala"
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2436 "nibbles-view.c"
											goto __catch2_g_error;
										}
#line 353 "nibbles-view.vala"
										break;
#line 2441 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'Q':
#line 305 "nibbles-view.vala"
									case 'R':
#line 305 "nibbles-view.vala"
									case 'S':
#line 305 "nibbles-view.vala"
									case 'T':
#line 305 "nibbles-view.vala"
									case 'U':
#line 305 "nibbles-view.vala"
									case 'V':
#line 305 "nibbles-view.vala"
									case 'W':
#line 305 "nibbles-view.vala"
									case 'X':
#line 305 "nibbles-view.vala"
									case 'Y':
#line 305 "nibbles-view.vala"
									case 'Z':
#line 2463 "nibbles-view.c"
									{
										NibblesGame* _tmp50_;
										NibblesGame* _tmp51_;
										WarpManager* _tmp52_;
										WarpManager* _tmp53_;
										NibblesGame* _tmp54_;
										NibblesGame* _tmp55_;
										gint* _tmp56_;
										gint _tmp56__length1;
										gint _tmp56__length2;
										NibblesGame* _tmp57_;
										NibblesGame* _tmp58_;
										gint* _tmp59_;
										gint _tmp59__length1;
										gint _tmp59__length2;
										gint _tmp60_;
#line 364 "nibbles-view.vala"
										is_wall = FALSE;
#line 365 "nibbles-view.vala"
										_tmp50_ = nibbles_view_get_game (self);
#line 365 "nibbles-view.vala"
										_tmp51_ = _tmp50_;
#line 365 "nibbles-view.vala"
										_tmp52_ = nibbles_game_get_warp_manager (_tmp51_);
#line 365 "nibbles-view.vala"
										_tmp53_ = _tmp52_;
#line 365 "nibbles-view.vala"
										_tmp54_ = nibbles_view_get_game (self);
#line 365 "nibbles-view.vala"
										_tmp55_ = _tmp54_;
#line 365 "nibbles-view.vala"
										_tmp56_ = _tmp55_->board;
#line 365 "nibbles-view.vala"
										_tmp56__length1 = _tmp55_->board_length1;
#line 365 "nibbles-view.vala"
										_tmp56__length2 = _tmp55_->board_length2;
#line 365 "nibbles-view.vala"
										_tmp57_ = nibbles_view_get_game (self);
#line 365 "nibbles-view.vala"
										_tmp58_ = _tmp57_;
#line 365 "nibbles-view.vala"
										_tmp59_ = _tmp58_->board;
#line 365 "nibbles-view.vala"
										_tmp59__length1 = _tmp58_->board_length1;
#line 365 "nibbles-view.vala"
										_tmp59__length2 = _tmp58_->board_length2;
#line 365 "nibbles-view.vala"
										_tmp60_ = _tmp59_[(j * _tmp59__length2) + i];
#line 365 "nibbles-view.vala"
										warp_manager_add_warp (_tmp53_, _tmp56_, (gint) _tmp56__length1, (gint) _tmp56__length2, j - 1, i - 1, -_tmp60_, 0);
#line 366 "nibbles-view.vala"
										break;
#line 2516 "nibbles-view.c"
									}
#line 305 "nibbles-view.vala"
									case 'r':
#line 305 "nibbles-view.vala"
									case 's':
#line 305 "nibbles-view.vala"
									case 't':
#line 305 "nibbles-view.vala"
									case 'u':
#line 305 "nibbles-view.vala"
									case 'v':
#line 305 "nibbles-view.vala"
									case 'w':
#line 305 "nibbles-view.vala"
									case 'x':
#line 305 "nibbles-view.vala"
									case 'y':
#line 305 "nibbles-view.vala"
									case 'z':
#line 2536 "nibbles-view.c"
									{
										NibblesGame* _tmp61_;
										NibblesGame* _tmp62_;
										WarpManager* _tmp63_;
										WarpManager* _tmp64_;
										NibblesGame* _tmp65_;
										NibblesGame* _tmp66_;
										gint* _tmp67_;
										gint _tmp67__length1;
										gint _tmp67__length2;
										NibblesGame* _tmp68_;
										NibblesGame* _tmp69_;
										gint* _tmp70_;
										gint _tmp70__length1;
										gint _tmp70__length2;
										gint _tmp71_;
										NibblesGame* _tmp72_;
										NibblesGame* _tmp73_;
										gint* _tmp74_;
										gint _tmp74__length1;
										gint _tmp74__length2;
#line 376 "nibbles-view.vala"
										is_wall = FALSE;
#line 377 "nibbles-view.vala"
										_tmp61_ = nibbles_view_get_game (self);
#line 377 "nibbles-view.vala"
										_tmp62_ = _tmp61_;
#line 377 "nibbles-view.vala"
										_tmp63_ = nibbles_game_get_warp_manager (_tmp62_);
#line 377 "nibbles-view.vala"
										_tmp64_ = _tmp63_;
#line 377 "nibbles-view.vala"
										_tmp65_ = nibbles_view_get_game (self);
#line 377 "nibbles-view.vala"
										_tmp66_ = _tmp65_;
#line 377 "nibbles-view.vala"
										_tmp67_ = _tmp66_->board;
#line 377 "nibbles-view.vala"
										_tmp67__length1 = _tmp66_->board_length1;
#line 377 "nibbles-view.vala"
										_tmp67__length2 = _tmp66_->board_length2;
#line 377 "nibbles-view.vala"
										_tmp68_ = nibbles_view_get_game (self);
#line 377 "nibbles-view.vala"
										_tmp69_ = _tmp68_;
#line 377 "nibbles-view.vala"
										_tmp70_ = _tmp69_->board;
#line 377 "nibbles-view.vala"
										_tmp70__length1 = _tmp69_->board_length1;
#line 377 "nibbles-view.vala"
										_tmp70__length2 = _tmp69_->board_length2;
#line 377 "nibbles-view.vala"
										_tmp71_ = _tmp70_[(j * _tmp70__length2) + i];
#line 377 "nibbles-view.vala"
										warp_manager_add_warp (_tmp64_, _tmp67_, (gint) _tmp67__length1, (gint) _tmp67__length2, -((_tmp71_ - 'a') + 'A'), 0, j, i);
#line 378 "nibbles-view.vala"
										_tmp72_ = nibbles_view_get_game (self);
#line 378 "nibbles-view.vala"
										_tmp73_ = _tmp72_;
#line 378 "nibbles-view.vala"
										_tmp74_ = _tmp73_->board;
#line 378 "nibbles-view.vala"
										_tmp74__length1 = _tmp73_->board_length1;
#line 378 "nibbles-view.vala"
										_tmp74__length2 = _tmp73_->board_length2;
#line 378 "nibbles-view.vala"
										_tmp74_[(j * _tmp74__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 379 "nibbles-view.vala"
										break;
#line 2606 "nibbles-view.c"
									}
									default:
									{
#line 381 "nibbles-view.vala"
										is_wall = FALSE;
#line 382 "nibbles-view.vala"
										break;
#line 2614 "nibbles-view.c"
									}
								}
							}
							goto __finally2;
							__catch2_g_error:
							{
								GError* e = NULL;
								const gchar* _tmp75_;
#line 303 "nibbles-view.vala"
								e = _inner_error0_;
#line 303 "nibbles-view.vala"
								_inner_error0_ = NULL;
#line 387 "nibbles-view.vala"
								_tmp75_ = e->message;
#line 387 "nibbles-view.vala"
								g_error ("nibbles-view.vala:387: Error loading level: %s", _tmp75_);
#line 303 "nibbles-view.vala"
								_g_error_free0 (e);
#line 2633 "nibbles-view.c"
							}
							__finally2:
#line 303 "nibbles-view.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 303 "nibbles-view.vala"
								_g_object_unref0 (tmp);
#line 303 "nibbles-view.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 303 "nibbles-view.vala"
								g_clear_error (&_inner_error0_);
#line 303 "nibbles-view.vala"
								return;
#line 2646 "nibbles-view.c"
							}
#line 390 "nibbles-view.vala"
							if (is_wall) {
#line 2650 "nibbles-view.c"
								NibblesGame* _tmp76_;
								NibblesGame* _tmp77_;
								gint _tmp78_;
								gint _tmp79_;
								GtkClutterTexture* _tmp80_;
								NibblesGame* _tmp81_;
								NibblesGame* _tmp82_;
								gint _tmp83_;
								gint _tmp84_;
								NibblesGame* _tmp85_;
								NibblesGame* _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								GtkClutterTexture* _tmp89_;
								ClutterActor* _tmp90_;
								GtkClutterTexture* _tmp91_;
#line 392 "nibbles-view.vala"
								_tmp76_ = nibbles_view_get_game (self);
#line 392 "nibbles-view.vala"
								_tmp77_ = _tmp76_;
#line 392 "nibbles-view.vala"
								_tmp78_ = nibbles_game_get_tile_size (_tmp77_);
#line 392 "nibbles-view.vala"
								_tmp79_ = _tmp78_;
#line 392 "nibbles-view.vala"
								x_pos = j * _tmp79_;
#line 394 "nibbles-view.vala"
								_tmp80_ = tmp;
#line 394 "nibbles-view.vala"
								_tmp81_ = nibbles_view_get_game (self);
#line 394 "nibbles-view.vala"
								_tmp82_ = _tmp81_;
#line 394 "nibbles-view.vala"
								_tmp83_ = nibbles_game_get_tile_size (_tmp82_);
#line 394 "nibbles-view.vala"
								_tmp84_ = _tmp83_;
#line 394 "nibbles-view.vala"
								_tmp85_ = nibbles_view_get_game (self);
#line 394 "nibbles-view.vala"
								_tmp86_ = _tmp85_;
#line 394 "nibbles-view.vala"
								_tmp87_ = nibbles_game_get_tile_size (_tmp86_);
#line 394 "nibbles-view.vala"
								_tmp88_ = _tmp87_;
#line 394 "nibbles-view.vala"
								clutter_actor_set_size ((ClutterActor*) _tmp80_, (gfloat) _tmp84_, (gfloat) _tmp88_);
#line 395 "nibbles-view.vala"
								_tmp89_ = tmp;
#line 395 "nibbles-view.vala"
								clutter_actor_set_position ((ClutterActor*) _tmp89_, (gfloat) x_pos, (gfloat) y_pos);
#line 396 "nibbles-view.vala"
								_tmp90_ = self->priv->level;
#line 396 "nibbles-view.vala"
								_tmp91_ = tmp;
#line 396 "nibbles-view.vala"
								clutter_actor_add_child (_tmp90_, (ClutterActor*) _tmp91_);
#line 2707 "nibbles-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 400 "nibbles-view.vala"
	_tmp92_ = self->priv->stage;
#line 400 "nibbles-view.vala"
	_tmp93_ = self->priv->level;
#line 400 "nibbles-view.vala"
	clutter_actor_add_child ((ClutterActor*) _tmp92_, _tmp93_);
#line 402 "nibbles-view.vala"
	_tmp94_ = self->priv->level;
#line 402 "nibbles-view.vala"
	clutter_actor_set_opacity (_tmp94_, (guint8) 0);
#line 403 "nibbles-view.vala"
	_tmp95_ = self->priv->level;
#line 403 "nibbles-view.vala"
	clutter_actor_set_scale (_tmp95_, 0.2, 0.2);
#line 405 "nibbles-view.vala"
	_tmp96_ = self->priv->level;
#line 405 "nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp96_);
#line 406 "nibbles-view.vala"
	_tmp97_ = self->priv->level;
#line 406 "nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp97_, CLUTTER_EASE_OUT_BOUNCE);
#line 407 "nibbles-view.vala"
	_tmp98_ = self->priv->level;
#line 407 "nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp98_, (guint) (NIBBLES_GAME_GAMEDELAY * NIBBLES_GAME_GAMEDELAY));
#line 408 "nibbles-view.vala"
	_tmp99_ = self->priv->level;
#line 408 "nibbles-view.vala"
	clutter_actor_set_scale (_tmp99_, 1.0, 1.0);
#line 409 "nibbles-view.vala"
	_tmp100_ = self->priv->level;
#line 409 "nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp100_, 0.5f, 0.5f);
#line 410 "nibbles-view.vala"
	_tmp101_ = self->priv->level;
#line 410 "nibbles-view.vala"
	clutter_actor_set_opacity (_tmp101_, (guint8) 0xff);
#line 411 "nibbles-view.vala"
	_tmp102_ = self->priv->level;
#line 411 "nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp102_);
#line 282 "nibbles-view.vala"
	_g_object_unref0 (tmp);
#line 2759 "nibbles-view.c"
}

GdkPixbuf*
nibbles_view_load_pixmap_file (NibblesView* self,
                               const gchar* pixmap,
                               gint xsize,
                               gint ysize)
{
	GdkPixbuf* result = NULL;
	gchar* filename = NULL;
	gchar* _tmp0_;
	GdkPixbuf* image = NULL;
	GError* _inner_error0_ = NULL;
#line 418 "nibbles-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 418 "nibbles-view.vala"
	g_return_val_if_fail (pixmap != NULL, NULL);
#line 420 "nibbles-view.vala"
	_tmp0_ = g_build_filename (PKGDATADIR, "pixmaps", pixmap, NULL, NULL);
#line 420 "nibbles-view.vala"
	filename = _tmp0_;
#line 421 "nibbles-view.vala"
	if (filename == NULL) {
#line 422 "nibbles-view.vala"
		g_error ("nibbles-view.vala:422: Nibbles couldn't find pixmap file: %s", filename);
#line 2785 "nibbles-view.c"
	}
#line 424 "nibbles-view.vala"
	image = NULL;
#line 2789 "nibbles-view.c"
	{
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
#line 427 "nibbles-view.vala"
		_tmp2_ = gdk_pixbuf_new_from_file_at_scale (filename, xsize, ysize, TRUE, &_inner_error0_);
#line 427 "nibbles-view.vala"
		_tmp1_ = _tmp2_;
#line 427 "nibbles-view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2800 "nibbles-view.c"
			goto __catch3_g_error;
		}
#line 427 "nibbles-view.vala"
		_tmp3_ = _tmp1_;
#line 427 "nibbles-view.vala"
		_tmp1_ = NULL;
#line 427 "nibbles-view.vala"
		_g_object_unref0 (image);
#line 427 "nibbles-view.vala"
		image = _tmp3_;
#line 425 "nibbles-view.vala"
		_g_object_unref0 (_tmp1_);
#line 2813 "nibbles-view.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 425 "nibbles-view.vala"
		e = _inner_error0_;
#line 425 "nibbles-view.vala"
		_inner_error0_ = NULL;
#line 431 "nibbles-view.vala"
		_tmp4_ = e;
#line 431 "nibbles-view.vala"
		_tmp5_ = _tmp4_->message;
#line 431 "nibbles-view.vala"
		g_warning ("nibbles-view.vala:431: Failed to load pixmap file: %s", _tmp5_);
#line 425 "nibbles-view.vala"
		_g_error_free0 (e);
#line 2833 "nibbles-view.c"
	}
	__finally3:
#line 425 "nibbles-view.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 425 "nibbles-view.vala"
		_g_object_unref0 (image);
#line 425 "nibbles-view.vala"
		_g_free0 (filename);
#line 425 "nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 425 "nibbles-view.vala"
		g_clear_error (&_inner_error0_);
#line 425 "nibbles-view.vala"
		return NULL;
#line 2848 "nibbles-view.c"
	}
#line 434 "nibbles-view.vala"
	result = image;
#line 434 "nibbles-view.vala"
	_g_free0 (filename);
#line 434 "nibbles-view.vala"
	return result;
#line 2856 "nibbles-view.c"
}

static void
nibbles_view_load_pixmap (NibblesView* self)
{
	gchar** bonus_files = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint bonus_files_length1;
	gint _bonus_files_size_;
	gchar** small_files = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gint small_files_length1;
	gint _small_files_size_;
	gchar** worm_files = NULL;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gint worm_files_length1;
	gint _worm_files_size_;
#line 437 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 439 "nibbles-view.vala"
	_tmp0_ = g_strdup ("bonus1.svg");
#line 439 "nibbles-view.vala"
	_tmp1_ = g_strdup ("bonus2.svg");
#line 439 "nibbles-view.vala"
	_tmp2_ = g_strdup ("bonus3.svg");
#line 439 "nibbles-view.vala"
	_tmp3_ = g_strdup ("life.svg");
#line 439 "nibbles-view.vala"
	_tmp4_ = g_strdup ("diamond.svg");
#line 439 "nibbles-view.vala"
	_tmp5_ = g_strdup ("questionmark.svg");
#line 439 "nibbles-view.vala"
	_tmp6_ = g_new0 (gchar*, 6 + 1);
#line 439 "nibbles-view.vala"
	_tmp6_[0] = _tmp0_;
#line 439 "nibbles-view.vala"
	_tmp6_[1] = _tmp1_;
#line 439 "nibbles-view.vala"
	_tmp6_[2] = _tmp2_;
#line 439 "nibbles-view.vala"
	_tmp6_[3] = _tmp3_;
#line 439 "nibbles-view.vala"
	_tmp6_[4] = _tmp4_;
#line 439 "nibbles-view.vala"
	_tmp6_[5] = _tmp5_;
#line 439 "nibbles-view.vala"
	bonus_files = _tmp6_;
#line 439 "nibbles-view.vala"
	bonus_files_length1 = 6;
#line 439 "nibbles-view.vala"
	_bonus_files_size_ = bonus_files_length1;
#line 449 "nibbles-view.vala"
	_tmp7_ = g_strdup ("wall-straight-up.svg");
#line 449 "nibbles-view.vala"
	_tmp8_ = g_strdup ("wall-straight-side.svg");
#line 449 "nibbles-view.vala"
	_tmp9_ = g_strdup ("wall-corner-bottom-left.svg");
#line 449 "nibbles-view.vala"
	_tmp10_ = g_strdup ("wall-corner-bottom-right.svg");
#line 449 "nibbles-view.vala"
	_tmp11_ = g_strdup ("wall-corner-top-left.svg");
#line 449 "nibbles-view.vala"
	_tmp12_ = g_strdup ("wall-corner-top-right.svg");
#line 449 "nibbles-view.vala"
	_tmp13_ = g_strdup ("wall-tee-up.svg");
#line 449 "nibbles-view.vala"
	_tmp14_ = g_strdup ("wall-tee-right.svg");
#line 449 "nibbles-view.vala"
	_tmp15_ = g_strdup ("wall-tee-left.svg");
#line 449 "nibbles-view.vala"
	_tmp16_ = g_strdup ("wall-tee-down.svg");
#line 449 "nibbles-view.vala"
	_tmp17_ = g_strdup ("wall-cross.svg");
#line 449 "nibbles-view.vala"
	_tmp18_ = g_new0 (gchar*, 11 + 1);
#line 449 "nibbles-view.vala"
	_tmp18_[0] = _tmp7_;
#line 449 "nibbles-view.vala"
	_tmp18_[1] = _tmp8_;
#line 449 "nibbles-view.vala"
	_tmp18_[2] = _tmp9_;
#line 449 "nibbles-view.vala"
	_tmp18_[3] = _tmp10_;
#line 449 "nibbles-view.vala"
	_tmp18_[4] = _tmp11_;
#line 449 "nibbles-view.vala"
	_tmp18_[5] = _tmp12_;
#line 449 "nibbles-view.vala"
	_tmp18_[6] = _tmp13_;
#line 449 "nibbles-view.vala"
	_tmp18_[7] = _tmp14_;
#line 449 "nibbles-view.vala"
	_tmp18_[8] = _tmp15_;
#line 449 "nibbles-view.vala"
	_tmp18_[9] = _tmp16_;
#line 449 "nibbles-view.vala"
	_tmp18_[10] = _tmp17_;
#line 449 "nibbles-view.vala"
	small_files = _tmp18_;
#line 449 "nibbles-view.vala"
	small_files_length1 = 11;
#line 449 "nibbles-view.vala"
	_small_files_size_ = small_files_length1;
#line 464 "nibbles-view.vala"
	_tmp19_ = g_strdup ("snake-red.svg");
#line 464 "nibbles-view.vala"
	_tmp20_ = g_strdup ("snake-green.svg");
#line 464 "nibbles-view.vala"
	_tmp21_ = g_strdup ("snake-blue.svg");
#line 464 "nibbles-view.vala"
	_tmp22_ = g_strdup ("snake-yellow.svg");
#line 464 "nibbles-view.vala"
	_tmp23_ = g_strdup ("snake-cyan.svg");
#line 464 "nibbles-view.vala"
	_tmp24_ = g_strdup ("snake-magenta.svg");
#line 464 "nibbles-view.vala"
	_tmp25_ = g_new0 (gchar*, 6 + 1);
#line 464 "nibbles-view.vala"
	_tmp25_[0] = _tmp19_;
#line 464 "nibbles-view.vala"
	_tmp25_[1] = _tmp20_;
#line 464 "nibbles-view.vala"
	_tmp25_[2] = _tmp21_;
#line 464 "nibbles-view.vala"
	_tmp25_[3] = _tmp22_;
#line 464 "nibbles-view.vala"
	_tmp25_[4] = _tmp23_;
#line 464 "nibbles-view.vala"
	_tmp25_[5] = _tmp24_;
#line 464 "nibbles-view.vala"
	worm_files = _tmp25_;
#line 464 "nibbles-view.vala"
	worm_files_length1 = 6;
#line 464 "nibbles-view.vala"
	_worm_files_size_ = worm_files_length1;
#line 3015 "nibbles-view.c"
	{
		gint i = 0;
#line 474 "nibbles-view.vala"
		i = 0;
#line 3020 "nibbles-view.c"
		{
			gboolean _tmp26_ = FALSE;
#line 474 "nibbles-view.vala"
			_tmp26_ = TRUE;
#line 474 "nibbles-view.vala"
			while (TRUE) {
#line 3027 "nibbles-view.c"
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				NibblesGame* _tmp31_;
				NibblesGame* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				NibblesGame* _tmp35_;
				NibblesGame* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				GdkPixbuf* _tmp39_;
#line 474 "nibbles-view.vala"
				if (!_tmp26_) {
#line 3044 "nibbles-view.c"
					gint _tmp27_;
#line 474 "nibbles-view.vala"
					_tmp27_ = i;
#line 474 "nibbles-view.vala"
					i = _tmp27_ + 1;
#line 3050 "nibbles-view.c"
				}
#line 474 "nibbles-view.vala"
				_tmp26_ = FALSE;
#line 474 "nibbles-view.vala"
				_tmp28_ = bonus_files;
#line 474 "nibbles-view.vala"
				_tmp28__length1 = bonus_files_length1;
#line 474 "nibbles-view.vala"
				if (!(i < _tmp28__length1)) {
#line 474 "nibbles-view.vala"
					break;
#line 3062 "nibbles-view.c"
				}
#line 476 "nibbles-view.vala"
				_tmp29_ = bonus_files;
#line 476 "nibbles-view.vala"
				_tmp29__length1 = bonus_files_length1;
#line 476 "nibbles-view.vala"
				_tmp30_ = _tmp29_[i];
#line 476 "nibbles-view.vala"
				_tmp31_ = nibbles_view_get_game (self);
#line 476 "nibbles-view.vala"
				_tmp32_ = _tmp31_;
#line 476 "nibbles-view.vala"
				_tmp33_ = nibbles_game_get_tile_size (_tmp32_);
#line 476 "nibbles-view.vala"
				_tmp34_ = _tmp33_;
#line 476 "nibbles-view.vala"
				_tmp35_ = nibbles_view_get_game (self);
#line 476 "nibbles-view.vala"
				_tmp36_ = _tmp35_;
#line 476 "nibbles-view.vala"
				_tmp37_ = nibbles_game_get_tile_size (_tmp36_);
#line 476 "nibbles-view.vala"
				_tmp38_ = _tmp37_;
#line 476 "nibbles-view.vala"
				_tmp39_ = nibbles_view_load_pixmap_file (self, _tmp30_, 2 * _tmp34_, 2 * _tmp38_);
#line 476 "nibbles-view.vala"
				_g_object_unref0 (self->priv->boni_pixmaps[i]);
#line 476 "nibbles-view.vala"
				self->priv->boni_pixmaps[i] = _tmp39_;
#line 3092 "nibbles-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 480 "nibbles-view.vala"
		i = 0;
#line 3100 "nibbles-view.c"
		{
			gboolean _tmp40_ = FALSE;
#line 480 "nibbles-view.vala"
			_tmp40_ = TRUE;
#line 480 "nibbles-view.vala"
			while (TRUE) {
#line 3107 "nibbles-view.c"
				gchar** _tmp42_;
				gint _tmp42__length1;
				gchar** _tmp43_;
				gint _tmp43__length1;
				const gchar* _tmp44_;
				NibblesGame* _tmp45_;
				NibblesGame* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				NibblesGame* _tmp49_;
				NibblesGame* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				GdkPixbuf* _tmp53_;
#line 480 "nibbles-view.vala"
				if (!_tmp40_) {
#line 3124 "nibbles-view.c"
					gint _tmp41_;
#line 480 "nibbles-view.vala"
					_tmp41_ = i;
#line 480 "nibbles-view.vala"
					i = _tmp41_ + 1;
#line 3130 "nibbles-view.c"
				}
#line 480 "nibbles-view.vala"
				_tmp40_ = FALSE;
#line 480 "nibbles-view.vala"
				_tmp42_ = small_files;
#line 480 "nibbles-view.vala"
				_tmp42__length1 = small_files_length1;
#line 480 "nibbles-view.vala"
				if (!(i < _tmp42__length1)) {
#line 480 "nibbles-view.vala"
					break;
#line 3142 "nibbles-view.c"
				}
#line 482 "nibbles-view.vala"
				_tmp43_ = small_files;
#line 482 "nibbles-view.vala"
				_tmp43__length1 = small_files_length1;
#line 482 "nibbles-view.vala"
				_tmp44_ = _tmp43_[i];
#line 482 "nibbles-view.vala"
				_tmp45_ = nibbles_view_get_game (self);
#line 482 "nibbles-view.vala"
				_tmp46_ = _tmp45_;
#line 482 "nibbles-view.vala"
				_tmp47_ = nibbles_game_get_tile_size (_tmp46_);
#line 482 "nibbles-view.vala"
				_tmp48_ = _tmp47_;
#line 482 "nibbles-view.vala"
				_tmp49_ = nibbles_view_get_game (self);
#line 482 "nibbles-view.vala"
				_tmp50_ = _tmp49_;
#line 482 "nibbles-view.vala"
				_tmp51_ = nibbles_game_get_tile_size (_tmp50_);
#line 482 "nibbles-view.vala"
				_tmp52_ = _tmp51_;
#line 482 "nibbles-view.vala"
				_tmp53_ = nibbles_view_load_pixmap_file (self, _tmp44_, 2 * _tmp48_, 2 * _tmp52_);
#line 482 "nibbles-view.vala"
				_g_object_unref0 (self->priv->wall_pixmaps[i]);
#line 482 "nibbles-view.vala"
				self->priv->wall_pixmaps[i] = _tmp53_;
#line 3172 "nibbles-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 486 "nibbles-view.vala"
		i = 0;
#line 3180 "nibbles-view.c"
		{
			gboolean _tmp54_ = FALSE;
#line 486 "nibbles-view.vala"
			_tmp54_ = TRUE;
#line 486 "nibbles-view.vala"
			while (TRUE) {
#line 3187 "nibbles-view.c"
				gchar** _tmp56_;
				gint _tmp56__length1;
				gchar** _tmp57_;
				gint _tmp57__length1;
				const gchar* _tmp58_;
				NibblesGame* _tmp59_;
				NibblesGame* _tmp60_;
				gint _tmp61_;
				gint _tmp62_;
				NibblesGame* _tmp63_;
				NibblesGame* _tmp64_;
				gint _tmp65_;
				gint _tmp66_;
				GdkPixbuf* _tmp67_;
#line 486 "nibbles-view.vala"
				if (!_tmp54_) {
#line 3204 "nibbles-view.c"
					gint _tmp55_;
#line 486 "nibbles-view.vala"
					_tmp55_ = i;
#line 486 "nibbles-view.vala"
					i = _tmp55_ + 1;
#line 3210 "nibbles-view.c"
				}
#line 486 "nibbles-view.vala"
				_tmp54_ = FALSE;
#line 486 "nibbles-view.vala"
				_tmp56_ = worm_files;
#line 486 "nibbles-view.vala"
				_tmp56__length1 = worm_files_length1;
#line 486 "nibbles-view.vala"
				if (!(i < _tmp56__length1)) {
#line 486 "nibbles-view.vala"
					break;
#line 3222 "nibbles-view.c"
				}
#line 488 "nibbles-view.vala"
				_tmp57_ = worm_files;
#line 488 "nibbles-view.vala"
				_tmp57__length1 = worm_files_length1;
#line 488 "nibbles-view.vala"
				_tmp58_ = _tmp57_[i];
#line 488 "nibbles-view.vala"
				_tmp59_ = nibbles_view_get_game (self);
#line 488 "nibbles-view.vala"
				_tmp60_ = _tmp59_;
#line 488 "nibbles-view.vala"
				_tmp61_ = nibbles_game_get_tile_size (_tmp60_);
#line 488 "nibbles-view.vala"
				_tmp62_ = _tmp61_;
#line 488 "nibbles-view.vala"
				_tmp63_ = nibbles_view_get_game (self);
#line 488 "nibbles-view.vala"
				_tmp64_ = _tmp63_;
#line 488 "nibbles-view.vala"
				_tmp65_ = nibbles_game_get_tile_size (_tmp64_);
#line 488 "nibbles-view.vala"
				_tmp66_ = _tmp65_;
#line 488 "nibbles-view.vala"
				_tmp67_ = nibbles_view_load_pixmap_file (self, _tmp58_, _tmp62_, _tmp66_);
#line 488 "nibbles-view.vala"
				_g_object_unref0 (self->priv->worm_pixmaps[i]);
#line 488 "nibbles-view.vala"
				self->priv->worm_pixmaps[i] = _tmp67_;
#line 3252 "nibbles-view.c"
			}
		}
	}
#line 437 "nibbles-view.vala"
	worm_files = (_vala_array_free (worm_files, worm_files_length1, (GDestroyNotify) g_free), NULL);
#line 437 "nibbles-view.vala"
	small_files = (_vala_array_free (small_files, small_files_length1, (GDestroyNotify) g_free), NULL);
#line 437 "nibbles-view.vala"
	bonus_files = (_vala_array_free (bonus_files, bonus_files_length1, (GDestroyNotify) g_free), NULL);
#line 3262 "nibbles-view.c"
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 495 "nibbles-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 495 "nibbles-view.vala"
	return _data6_;
#line 3272 "nibbles-view.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 495 "nibbles-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 3282 "nibbles-view.c"
		NibblesView* self;
#line 495 "nibbles-view.vala"
		self = _data6_->self;
#line 495 "nibbles-view.vala"
		_g_object_unref0 (_data6_->worm);
#line 495 "nibbles-view.vala"
		_g_object_unref0 (self);
#line 495 "nibbles-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 3292 "nibbles-view.c"
	}
}

static void
_nibbles_view_worm_added_cb_worm_added (Worm* _sender,
                                        gpointer self)
{
#line 497 "nibbles-view.vala"
	nibbles_view_worm_added_cb ((NibblesView*) self, _sender);
#line 3302 "nibbles-view.c"
}

static void
_nibbles_view_worm_finish_added_cb_worm_finish_added (Worm* _sender,
                                                      gpointer self)
{
#line 498 "nibbles-view.vala"
	nibbles_view_worm_finish_added_cb ((NibblesView*) self, _sender);
#line 3311 "nibbles-view.c"
}

static void
_nibbles_view_worm_moved_cb_worm_moved (Worm* _sender,
                                        gpointer self)
{
#line 499 "nibbles-view.vala"
	nibbles_view_worm_moved_cb ((NibblesView*) self, _sender);
#line 3320 "nibbles-view.c"
}

static void
_nibbles_view_worm_rescaled_cb_worm_rescaled (Worm* _sender,
                                              gint tile_size,
                                              gpointer self)
{
#line 500 "nibbles-view.vala"
	nibbles_view_worm_rescaled_cb ((NibblesView*) self, _sender, tile_size);
#line 3330 "nibbles-view.c"
}

static void
_nibbles_view_worm_died_cb_worm_died (Worm* _sender,
                                      gpointer self)
{
#line 501 "nibbles-view.vala"
	nibbles_view_worm_died_cb ((NibblesView*) self, _sender);
#line 3339 "nibbles-view.c"
}

static void
_nibbles_view_worm_tail_reduced_cb_worm_tail_reduced (Worm* _sender,
                                                      gint erase_size,
                                                      gpointer self)
{
#line 502 "nibbles-view.vala"
	nibbles_view_worm_tail_reduced_cb ((NibblesView*) self, _sender, erase_size);
#line 3349 "nibbles-view.c"
}

static void
_nibbles_view_worm_reversed_cb_worm_reversed (Worm* _sender,
                                              gpointer self)
{
#line 503 "nibbles-view.vala"
	nibbles_view_worm_reversed_cb ((NibblesView*) self, _sender);
#line 3358 "nibbles-view.c"
}

static void
____lambda6_ (Block6Data* _data6_)
{
	NibblesView* self;
	guint8 opacity = 0U;
	gint _tmp0_ = 0;
	Worm* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp4_;
	Worm* _tmp5_;
	gpointer _tmp6_;
#line 504 "nibbles-view.vala"
	self = _data6_->self;
#line 506 "nibbles-view.vala"
	_tmp1_ = _data6_->worm;
#line 506 "nibbles-view.vala"
	_tmp2_ = worm_get_is_materialized (_tmp1_);
#line 506 "nibbles-view.vala"
	_tmp3_ = _tmp2_;
#line 506 "nibbles-view.vala"
	if (_tmp3_) {
#line 506 "nibbles-view.vala"
		_tmp0_ = 0xff;
#line 3386 "nibbles-view.c"
	} else {
#line 506 "nibbles-view.vala"
		_tmp0_ = 0x50;
#line 3390 "nibbles-view.c"
	}
#line 506 "nibbles-view.vala"
	opacity = (guint8) _tmp0_;
#line 508 "nibbles-view.vala"
	_tmp4_ = self->priv->worm_actors;
#line 508 "nibbles-view.vala"
	_tmp5_ = _data6_->worm;
#line 508 "nibbles-view.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
#line 508 "nibbles-view.vala"
	actors = (WormActor*) _tmp6_;
#line 510 "nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) actors);
#line 511 "nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 10));
#line 512 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) actors, opacity);
#line 513 "nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
#line 504 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 3412 "nibbles-view.c"
}

static void
_____lambda6__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
#line 504 "nibbles-view.vala"
	____lambda6_ (self);
#line 3422 "nibbles-view.c"
}

void
nibbles_view_connect_worm_signals (NibblesView* self)
{
#line 493 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 3430 "nibbles-view.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _tmp4_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _worm_index = 0;
#line 495 "nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 495 "nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 495 "nibbles-view.vala"
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
#line 495 "nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 495 "nibbles-view.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 495 "nibbles-view.vala"
		_worm_list = _tmp4_;
#line 495 "nibbles-view.vala"
		_tmp5_ = _worm_list;
#line 495 "nibbles-view.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
#line 495 "nibbles-view.vala"
		_tmp7_ = _tmp6_;
#line 495 "nibbles-view.vala"
		_worm_size = _tmp7_;
#line 495 "nibbles-view.vala"
		_worm_index = -1;
#line 495 "nibbles-view.vala"
		while (TRUE) {
#line 3467 "nibbles-view.c"
			Block6Data* _data6_;
			GeeLinkedList* _tmp8_;
			gpointer _tmp9_;
			Worm* _tmp10_;
			Worm* _tmp11_;
			Worm* _tmp12_;
			Worm* _tmp13_;
			Worm* _tmp14_;
			Worm* _tmp15_;
			Worm* _tmp16_;
			Worm* _tmp17_;
#line 495 "nibbles-view.vala"
			_data6_ = g_slice_new0 (Block6Data);
#line 495 "nibbles-view.vala"
			_data6_->_ref_count_ = 1;
#line 495 "nibbles-view.vala"
			_data6_->self = g_object_ref (self);
#line 495 "nibbles-view.vala"
			_worm_index = _worm_index + 1;
#line 495 "nibbles-view.vala"
			if (!(_worm_index < _worm_size)) {
#line 495 "nibbles-view.vala"
				block6_data_unref (_data6_);
#line 495 "nibbles-view.vala"
				_data6_ = NULL;
#line 495 "nibbles-view.vala"
				break;
#line 3495 "nibbles-view.c"
			}
#line 495 "nibbles-view.vala"
			_tmp8_ = _worm_list;
#line 495 "nibbles-view.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _worm_index);
#line 495 "nibbles-view.vala"
			_data6_->worm = (Worm*) _tmp9_;
#line 497 "nibbles-view.vala"
			_tmp10_ = _data6_->worm;
#line 497 "nibbles-view.vala"
			g_signal_connect_object (_tmp10_, "added", (GCallback) _nibbles_view_worm_added_cb_worm_added, self, 0);
#line 498 "nibbles-view.vala"
			_tmp11_ = _data6_->worm;
#line 498 "nibbles-view.vala"
			g_signal_connect_object (_tmp11_, "finish-added", (GCallback) _nibbles_view_worm_finish_added_cb_worm_finish_added, self, 0);
#line 499 "nibbles-view.vala"
			_tmp12_ = _data6_->worm;
#line 499 "nibbles-view.vala"
			g_signal_connect_object (_tmp12_, "moved", (GCallback) _nibbles_view_worm_moved_cb_worm_moved, self, 0);
#line 500 "nibbles-view.vala"
			_tmp13_ = _data6_->worm;
#line 500 "nibbles-view.vala"
			g_signal_connect_object (_tmp13_, "rescaled", (GCallback) _nibbles_view_worm_rescaled_cb_worm_rescaled, self, 0);
#line 501 "nibbles-view.vala"
			_tmp14_ = _data6_->worm;
#line 501 "nibbles-view.vala"
			g_signal_connect_object (_tmp14_, "died", (GCallback) _nibbles_view_worm_died_cb_worm_died, self, 0);
#line 502 "nibbles-view.vala"
			_tmp15_ = _data6_->worm;
#line 502 "nibbles-view.vala"
			g_signal_connect_object (_tmp15_, "tail-reduced", (GCallback) _nibbles_view_worm_tail_reduced_cb_worm_tail_reduced, self, 0);
#line 503 "nibbles-view.vala"
			_tmp16_ = _data6_->worm;
#line 503 "nibbles-view.vala"
			g_signal_connect_object (_tmp16_, "reversed", (GCallback) _nibbles_view_worm_reversed_cb_worm_reversed, self, 0);
#line 504 "nibbles-view.vala"
			_tmp17_ = _data6_->worm;
#line 504 "nibbles-view.vala"
			g_signal_connect_data ((GObject*) _tmp17_, "notify::is-materialized", (GCallback) _____lambda6__g_object_notify, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 495 "nibbles-view.vala"
			block6_data_unref (_data6_);
#line 495 "nibbles-view.vala"
			_data6_ = NULL;
#line 3539 "nibbles-view.c"
		}
#line 495 "nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 3543 "nibbles-view.c"
	}
}

void
nibbles_view_board_rescale (NibblesView* self,
                            gint tile_size)
{
	gint board_width = 0;
	gint board_height = 0;
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	GList* _tmp2_;
	ClutterActor* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
#line 518 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 523 "nibbles-view.vala"
	_tmp0_ = self->priv->level;
#line 523 "nibbles-view.vala"
	if (_tmp0_ == NULL) {
#line 524 "nibbles-view.vala"
		return;
#line 3569 "nibbles-view.c"
	}
#line 526 "nibbles-view.vala"
	board_width = NIBBLES_GAME_WIDTH * tile_size;
#line 527 "nibbles-view.vala"
	board_height = NIBBLES_GAME_HEIGHT * tile_size;
#line 529 "nibbles-view.vala"
	_tmp1_ = self->priv->level;
#line 529 "nibbles-view.vala"
	_tmp2_ = clutter_actor_get_children (_tmp1_);
#line 3579 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 529 "nibbles-view.vala"
		actor_collection = _tmp2_;
#line 529 "nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 3587 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 529 "nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 3591 "nibbles-view.c"
			{
				ClutterActor* _tmp3_;
				gfloat _tmp4_ = 0.0F;
				gfloat _tmp5_ = 0.0F;
				ClutterActor* _tmp6_;
				NibblesGame* _tmp7_;
				NibblesGame* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				NibblesGame* _tmp11_;
				NibblesGame* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				ClutterActor* _tmp15_;
#line 531 "nibbles-view.vala"
				_tmp3_ = actor;
#line 531 "nibbles-view.vala"
				clutter_actor_get_position (_tmp3_, &_tmp4_, &_tmp5_);
#line 531 "nibbles-view.vala"
				x_pos = _tmp4_;
#line 531 "nibbles-view.vala"
				y_pos = _tmp5_;
#line 532 "nibbles-view.vala"
				_tmp6_ = actor;
#line 532 "nibbles-view.vala"
				_tmp7_ = nibbles_view_get_game (self);
#line 532 "nibbles-view.vala"
				_tmp8_ = _tmp7_;
#line 532 "nibbles-view.vala"
				_tmp9_ = nibbles_game_get_tile_size (_tmp8_);
#line 532 "nibbles-view.vala"
				_tmp10_ = _tmp9_;
#line 532 "nibbles-view.vala"
				_tmp11_ = nibbles_view_get_game (self);
#line 532 "nibbles-view.vala"
				_tmp12_ = _tmp11_;
#line 532 "nibbles-view.vala"
				_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
#line 532 "nibbles-view.vala"
				_tmp14_ = _tmp13_;
#line 532 "nibbles-view.vala"
				clutter_actor_set_position (_tmp6_, (x_pos / _tmp10_) * tile_size, (y_pos / _tmp14_) * tile_size);
#line 534 "nibbles-view.vala"
				_tmp15_ = actor;
#line 534 "nibbles-view.vala"
				clutter_actor_set_size (_tmp15_, (gfloat) tile_size, (gfloat) tile_size);
#line 3638 "nibbles-view.c"
			}
		}
#line 529 "nibbles-view.vala"
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
#line 3643 "nibbles-view.c"
	}
#line 537 "nibbles-view.vala"
	_tmp16_ = self->priv->_name_labels;
#line 537 "nibbles-view.vala"
	g_object_get (_tmp16_, "visible", &_tmp17_, NULL);
#line 537 "nibbles-view.vala"
	_tmp18_ = _tmp17_;
#line 537 "nibbles-view.vala"
	if (!_tmp18_) {
#line 538 "nibbles-view.vala"
		return;
#line 3655 "nibbles-view.c"
	}
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp19_;
		NibblesGame* _tmp20_;
		GeeLinkedList* _tmp21_;
		GeeLinkedList* _tmp22_;
		GeeLinkedList* _tmp23_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _worm_index = 0;
#line 540 "nibbles-view.vala"
		_tmp19_ = nibbles_view_get_game (self);
#line 540 "nibbles-view.vala"
		_tmp20_ = _tmp19_;
#line 540 "nibbles-view.vala"
		_tmp21_ = nibbles_game_get_worms (_tmp20_);
#line 540 "nibbles-view.vala"
		_tmp22_ = _tmp21_;
#line 540 "nibbles-view.vala"
		_tmp23_ = _g_object_ref0 (_tmp22_);
#line 540 "nibbles-view.vala"
		_worm_list = _tmp23_;
#line 540 "nibbles-view.vala"
		_tmp24_ = _worm_list;
#line 540 "nibbles-view.vala"
		_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
#line 540 "nibbles-view.vala"
		_tmp26_ = _tmp25_;
#line 540 "nibbles-view.vala"
		_worm_size = _tmp26_;
#line 540 "nibbles-view.vala"
		_worm_index = -1;
#line 540 "nibbles-view.vala"
		while (TRUE) {
#line 3693 "nibbles-view.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp27_;
			gpointer _tmp28_;
			ClutterActor* actor = NULL;
			ClutterActor* _tmp29_;
			Worm* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ClutterActor* _tmp33_;
			ClutterActor* _tmp34_;
			gint middle = 0;
			Worm* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gboolean _tmp38_ = FALSE;
			Worm* _tmp39_;
			WormDirection _tmp40_;
#line 540 "nibbles-view.vala"
			_worm_index = _worm_index + 1;
#line 540 "nibbles-view.vala"
			if (!(_worm_index < _worm_size)) {
#line 540 "nibbles-view.vala"
				break;
#line 3717 "nibbles-view.c"
			}
#line 540 "nibbles-view.vala"
			_tmp27_ = _worm_list;
#line 540 "nibbles-view.vala"
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _worm_index);
#line 540 "nibbles-view.vala"
			worm = (Worm*) _tmp28_;
#line 542 "nibbles-view.vala"
			_tmp29_ = self->priv->_name_labels;
#line 542 "nibbles-view.vala"
			_tmp30_ = worm;
#line 542 "nibbles-view.vala"
			_tmp31_ = worm_get_id (_tmp30_);
#line 542 "nibbles-view.vala"
			_tmp32_ = _tmp31_;
#line 542 "nibbles-view.vala"
			_tmp33_ = clutter_actor_get_child_at_index (_tmp29_, _tmp32_);
#line 542 "nibbles-view.vala"
			_tmp34_ = _g_object_ref0 (_tmp33_);
#line 542 "nibbles-view.vala"
			actor = _tmp34_;
#line 544 "nibbles-view.vala"
			_tmp35_ = worm;
#line 544 "nibbles-view.vala"
			_tmp36_ = worm_get_length (_tmp35_);
#line 544 "nibbles-view.vala"
			_tmp37_ = _tmp36_;
#line 544 "nibbles-view.vala"
			middle = _tmp37_ / 2;
#line 545 "nibbles-view.vala"
			_tmp39_ = worm;
#line 545 "nibbles-view.vala"
			_tmp40_ = _tmp39_->direction;
#line 545 "nibbles-view.vala"
			if (_tmp40_ == WORM_DIRECTION_UP) {
#line 545 "nibbles-view.vala"
				_tmp38_ = TRUE;
#line 3755 "nibbles-view.c"
			} else {
				Worm* _tmp41_;
				WormDirection _tmp42_;
#line 545 "nibbles-view.vala"
				_tmp41_ = worm;
#line 545 "nibbles-view.vala"
				_tmp42_ = _tmp41_->direction;
#line 545 "nibbles-view.vala"
				_tmp38_ = _tmp42_ == WORM_DIRECTION_DOWN;
#line 3765 "nibbles-view.c"
			}
#line 545 "nibbles-view.vala"
			if (_tmp38_) {
#line 3769 "nibbles-view.c"
				ClutterActor* _tmp43_;
				Worm* _tmp44_;
				GeeLinkedList* _tmp45_;
				GeeLinkedList* _tmp46_;
				gpointer _tmp47_;
				Position* _tmp48_;
				ClutterActor* _tmp49_;
				gfloat _tmp50_;
				gfloat _tmp51_;
				ClutterActor* _tmp52_;
				Worm* _tmp53_;
				GeeLinkedList* _tmp54_;
				GeeLinkedList* _tmp55_;
				gpointer _tmp56_;
				Position* _tmp57_;
#line 547 "nibbles-view.vala"
				_tmp43_ = actor;
#line 547 "nibbles-view.vala"
				_tmp44_ = worm;
#line 547 "nibbles-view.vala"
				_tmp45_ = worm_get_list (_tmp44_);
#line 547 "nibbles-view.vala"
				_tmp46_ = _tmp45_;
#line 547 "nibbles-view.vala"
				_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, middle);
#line 547 "nibbles-view.vala"
				_tmp48_ = (Position*) _tmp47_;
#line 547 "nibbles-view.vala"
				_tmp49_ = actor;
#line 547 "nibbles-view.vala"
				_tmp50_ = clutter_actor_get_width (_tmp49_);
#line 547 "nibbles-view.vala"
				_tmp51_ = _tmp50_;
#line 547 "nibbles-view.vala"
				clutter_actor_set_x (_tmp43_, (((*_tmp48_).x * tile_size) - (_tmp51_ / 2)) + (tile_size / 2));
#line 547 "nibbles-view.vala"
				_position_free0 (_tmp48_);
#line 548 "nibbles-view.vala"
				_tmp52_ = actor;
#line 548 "nibbles-view.vala"
				_tmp53_ = worm;
#line 548 "nibbles-view.vala"
				_tmp54_ = worm_get_list (_tmp53_);
#line 548 "nibbles-view.vala"
				_tmp55_ = _tmp54_;
#line 548 "nibbles-view.vala"
				_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, middle);
#line 548 "nibbles-view.vala"
				_tmp57_ = (Position*) _tmp56_;
#line 548 "nibbles-view.vala"
				clutter_actor_set_y (_tmp52_, (gfloat) (((*_tmp57_).y * tile_size) - (5 * tile_size)));
#line 548 "nibbles-view.vala"
				_position_free0 (_tmp57_);
#line 3823 "nibbles-view.c"
			} else {
				gboolean _tmp58_ = FALSE;
				Worm* _tmp59_;
				WormDirection _tmp60_;
#line 550 "nibbles-view.vala"
				_tmp59_ = worm;
#line 550 "nibbles-view.vala"
				_tmp60_ = _tmp59_->direction;
#line 550 "nibbles-view.vala"
				if (_tmp60_ == WORM_DIRECTION_LEFT) {
#line 550 "nibbles-view.vala"
					_tmp58_ = TRUE;
#line 3836 "nibbles-view.c"
				} else {
					Worm* _tmp61_;
					WormDirection _tmp62_;
#line 550 "nibbles-view.vala"
					_tmp61_ = worm;
#line 550 "nibbles-view.vala"
					_tmp62_ = _tmp61_->direction;
#line 550 "nibbles-view.vala"
					_tmp58_ = _tmp62_ == WORM_DIRECTION_RIGHT;
#line 3846 "nibbles-view.c"
				}
#line 550 "nibbles-view.vala"
				if (_tmp58_) {
#line 3850 "nibbles-view.c"
					ClutterActor* _tmp63_;
					Worm* _tmp64_;
					GeeLinkedList* _tmp65_;
					GeeLinkedList* _tmp66_;
					gpointer _tmp67_;
					Position* _tmp68_;
					ClutterActor* _tmp69_;
					gfloat _tmp70_;
					gfloat _tmp71_;
					ClutterActor* _tmp72_;
					Worm* _tmp73_;
					Position _tmp74_ = {0};
					Position _tmp75_;
#line 552 "nibbles-view.vala"
					_tmp63_ = actor;
#line 552 "nibbles-view.vala"
					_tmp64_ = worm;
#line 552 "nibbles-view.vala"
					_tmp65_ = worm_get_list (_tmp64_);
#line 552 "nibbles-view.vala"
					_tmp66_ = _tmp65_;
#line 552 "nibbles-view.vala"
					_tmp67_ = gee_abstract_list_get ((GeeAbstractList*) _tmp66_, middle);
#line 552 "nibbles-view.vala"
					_tmp68_ = (Position*) _tmp67_;
#line 552 "nibbles-view.vala"
					_tmp69_ = actor;
#line 552 "nibbles-view.vala"
					_tmp70_ = clutter_actor_get_width (_tmp69_);
#line 552 "nibbles-view.vala"
					_tmp71_ = _tmp70_;
#line 552 "nibbles-view.vala"
					clutter_actor_set_x (_tmp63_, (((*_tmp68_).x * tile_size) - (_tmp71_ / 2)) + (tile_size / 2));
#line 552 "nibbles-view.vala"
					_position_free0 (_tmp68_);
#line 553 "nibbles-view.vala"
					_tmp72_ = actor;
#line 553 "nibbles-view.vala"
					_tmp73_ = worm;
#line 553 "nibbles-view.vala"
					worm_get_head (_tmp73_, &_tmp74_);
#line 553 "nibbles-view.vala"
					_tmp75_ = _tmp74_;
#line 553 "nibbles-view.vala"
					clutter_actor_set_y (_tmp72_, (gfloat) ((_tmp75_.y * tile_size) - (3 * tile_size)));
#line 3896 "nibbles-view.c"
				}
			}
#line 540 "nibbles-view.vala"
			_g_object_unref0 (actor);
#line 540 "nibbles-view.vala"
			_g_object_unref0 (worm);
#line 3903 "nibbles-view.c"
		}
#line 540 "nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 3907 "nibbles-view.c"
	}
}

static void
nibbles_view_animate_end_game_cb (NibblesView* self)
{
	ClutterActor* _tmp29_;
	ClutterActor* _tmp30_;
	ClutterActor* _tmp31_;
	ClutterActor* _tmp32_;
	ClutterActor* _tmp33_;
	ClutterActor* _tmp34_;
	ClutterActor* _tmp35_;
#line 558 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 3923 "nibbles-view.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		GeeLinkedList* _tmp2_;
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _tmp4_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _worm_index = 0;
#line 560 "nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 560 "nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 560 "nibbles-view.vala"
		_tmp2_ = nibbles_game_get_worms (_tmp1_);
#line 560 "nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 560 "nibbles-view.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 560 "nibbles-view.vala"
		_worm_list = _tmp4_;
#line 560 "nibbles-view.vala"
		_tmp5_ = _worm_list;
#line 560 "nibbles-view.vala"
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
#line 560 "nibbles-view.vala"
		_tmp7_ = _tmp6_;
#line 560 "nibbles-view.vala"
		_worm_size = _tmp7_;
#line 560 "nibbles-view.vala"
		_worm_index = -1;
#line 560 "nibbles-view.vala"
		while (TRUE) {
#line 3960 "nibbles-view.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp8_;
			gpointer _tmp9_;
			GeeHashMap* _tmp10_;
			Worm* _tmp11_;
			gpointer _tmp12_;
			WormActor* _tmp13_;
#line 560 "nibbles-view.vala"
			_worm_index = _worm_index + 1;
#line 560 "nibbles-view.vala"
			if (!(_worm_index < _worm_size)) {
#line 560 "nibbles-view.vala"
				break;
#line 3974 "nibbles-view.c"
			}
#line 560 "nibbles-view.vala"
			_tmp8_ = _worm_list;
#line 560 "nibbles-view.vala"
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _worm_index);
#line 560 "nibbles-view.vala"
			worm = (Worm*) _tmp9_;
#line 561 "nibbles-view.vala"
			_tmp10_ = self->priv->worm_actors;
#line 561 "nibbles-view.vala"
			_tmp11_ = worm;
#line 561 "nibbles-view.vala"
			_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
#line 561 "nibbles-view.vala"
			_tmp13_ = (WormActor*) _tmp12_;
#line 561 "nibbles-view.vala"
			clutter_actor_hide ((ClutterActor*) _tmp13_);
#line 561 "nibbles-view.vala"
			_g_object_unref0 (_tmp13_);
#line 560 "nibbles-view.vala"
			_g_object_unref0 (worm);
#line 3996 "nibbles-view.c"
		}
#line 560 "nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 4000 "nibbles-view.c"
	}
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp14_;
		NibblesGame* _tmp15_;
		WarpManager* _tmp16_;
		WarpManager* _tmp17_;
		GeeLinkedList* _tmp18_;
		GeeLinkedList* _tmp19_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _warp_index = 0;
#line 563 "nibbles-view.vala"
		_tmp14_ = nibbles_view_get_game (self);
#line 563 "nibbles-view.vala"
		_tmp15_ = _tmp14_;
#line 563 "nibbles-view.vala"
		_tmp16_ = nibbles_game_get_warp_manager (_tmp15_);
#line 563 "nibbles-view.vala"
		_tmp17_ = _tmp16_;
#line 563 "nibbles-view.vala"
		_tmp18_ = _tmp17_->warps;
#line 563 "nibbles-view.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 563 "nibbles-view.vala"
		_warp_list = _tmp19_;
#line 563 "nibbles-view.vala"
		_tmp20_ = _warp_list;
#line 563 "nibbles-view.vala"
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
#line 563 "nibbles-view.vala"
		_tmp22_ = _tmp21_;
#line 563 "nibbles-view.vala"
		_warp_size = _tmp22_;
#line 563 "nibbles-view.vala"
		_warp_index = -1;
#line 563 "nibbles-view.vala"
		while (TRUE) {
#line 4041 "nibbles-view.c"
			Warp* warp = NULL;
			GeeLinkedList* _tmp23_;
			gpointer _tmp24_;
			GeeHashMap* _tmp25_;
			Warp* _tmp26_;
			gpointer _tmp27_;
			WarpTexture* _tmp28_;
#line 563 "nibbles-view.vala"
			_warp_index = _warp_index + 1;
#line 563 "nibbles-view.vala"
			if (!(_warp_index < _warp_size)) {
#line 563 "nibbles-view.vala"
				break;
#line 4055 "nibbles-view.c"
			}
#line 563 "nibbles-view.vala"
			_tmp23_ = _warp_list;
#line 563 "nibbles-view.vala"
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _warp_index);
#line 563 "nibbles-view.vala"
			warp = (Warp*) _tmp24_;
#line 564 "nibbles-view.vala"
			_tmp25_ = self->priv->warp_actors;
#line 564 "nibbles-view.vala"
			_tmp26_ = warp;
#line 564 "nibbles-view.vala"
			_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, _tmp26_);
#line 564 "nibbles-view.vala"
			_tmp28_ = (WarpTexture*) _tmp27_;
#line 564 "nibbles-view.vala"
			clutter_actor_hide ((ClutterActor*) _tmp28_);
#line 564 "nibbles-view.vala"
			_g_object_unref0 (_tmp28_);
#line 563 "nibbles-view.vala"
			_g_object_unref0 (warp);
#line 4077 "nibbles-view.c"
		}
#line 563 "nibbles-view.vala"
		_g_object_unref0 (_warp_list);
#line 4081 "nibbles-view.c"
	}
#line 566 "nibbles-view.vala"
	_tmp29_ = self->priv->level;
#line 566 "nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp29_);
#line 567 "nibbles-view.vala"
	_tmp30_ = self->priv->level;
#line 567 "nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp30_, CLUTTER_EASE_IN_QUAD);
#line 568 "nibbles-view.vala"
	_tmp31_ = self->priv->level;
#line 568 "nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp31_, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
#line 569 "nibbles-view.vala"
	_tmp32_ = self->priv->level;
#line 569 "nibbles-view.vala"
	clutter_actor_set_scale (_tmp32_, (gdouble) 0.4f, (gdouble) 0.4f);
#line 570 "nibbles-view.vala"
	_tmp33_ = self->priv->level;
#line 570 "nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp33_, 0.5f, 0.5f);
#line 571 "nibbles-view.vala"
	_tmp34_ = self->priv->level;
#line 571 "nibbles-view.vala"
	clutter_actor_set_opacity (_tmp34_, (guint8) 0);
#line 572 "nibbles-view.vala"
	_tmp35_ = self->priv->level;
#line 572 "nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp35_);
#line 4111 "nibbles-view.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1516 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1517 "glib-2.0.vapi"
	result = self;
#line 1517 "glib-2.0.vapi"
	return result;
#line 4124 "nibbles-view.c"
}

void
nibbles_view_create_name_labels (NibblesView* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp110_;
	ClutterActor* _tmp111_;
#line 575 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 577 "nibbles-view.vala"
	_tmp0_ = clutter_actor_new ();
#line 577 "nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 577 "nibbles-view.vala"
	_tmp1_ = _tmp0_;
#line 577 "nibbles-view.vala"
	nibbles_view_set_name_labels (self, _tmp1_);
#line 577 "nibbles-view.vala"
	_g_object_unref0 (_tmp1_);
#line 4146 "nibbles-view.c"
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp2_;
		NibblesGame* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		GeeLinkedList* _tmp6_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _worm_index = 0;
#line 578 "nibbles-view.vala"
		_tmp2_ = nibbles_view_get_game (self);
#line 578 "nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 578 "nibbles-view.vala"
		_tmp4_ = nibbles_game_get_worms (_tmp3_);
#line 578 "nibbles-view.vala"
		_tmp5_ = _tmp4_;
#line 578 "nibbles-view.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 578 "nibbles-view.vala"
		_worm_list = _tmp6_;
#line 578 "nibbles-view.vala"
		_tmp7_ = _worm_list;
#line 578 "nibbles-view.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
#line 578 "nibbles-view.vala"
		_tmp9_ = _tmp8_;
#line 578 "nibbles-view.vala"
		_worm_size = _tmp9_;
#line 578 "nibbles-view.vala"
		_worm_index = -1;
#line 578 "nibbles-view.vala"
		while (TRUE) {
#line 4183 "nibbles-view.c"
			Worm* worm = NULL;
			GeeLinkedList* _tmp10_;
			gpointer _tmp11_;
			gint color = 0;
			NibblesGame* _tmp12_;
			NibblesGame* _tmp13_;
			GeeHashMap* _tmp14_;
			GeeHashMap* _tmp15_;
			Worm* _tmp16_;
			gpointer _tmp17_;
			WormProperties* _tmp18_;
			gint _tmp19_;
			gchar* player_id = NULL;
			Worm* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gchar* _tmp23_;
			ClutterText* label = NULL;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			ClutterText* _tmp28_;
			ClutterText* _tmp29_;
			ClutterText* _tmp30_;
			ClutterText* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			ClutterColor _tmp34_ = {0};
			gint middle = 0;
			Worm* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gboolean _tmp38_ = FALSE;
			Worm* _tmp39_;
			WormDirection _tmp40_;
			ClutterActor* _tmp108_;
			ClutterText* _tmp109_;
#line 578 "nibbles-view.vala"
			_worm_index = _worm_index + 1;
#line 578 "nibbles-view.vala"
			if (!(_worm_index < _worm_size)) {
#line 578 "nibbles-view.vala"
				break;
#line 4228 "nibbles-view.c"
			}
#line 578 "nibbles-view.vala"
			_tmp10_ = _worm_list;
#line 578 "nibbles-view.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _worm_index);
#line 578 "nibbles-view.vala"
			worm = (Worm*) _tmp11_;
#line 580 "nibbles-view.vala"
			_tmp12_ = nibbles_view_get_game (self);
#line 580 "nibbles-view.vala"
			_tmp13_ = _tmp12_;
#line 580 "nibbles-view.vala"
			_tmp14_ = nibbles_game_get_worm_props (_tmp13_);
#line 580 "nibbles-view.vala"
			_tmp15_ = _tmp14_;
#line 580 "nibbles-view.vala"
			_tmp16_ = worm;
#line 580 "nibbles-view.vala"
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
#line 580 "nibbles-view.vala"
			_tmp18_ = (WormProperties*) _tmp17_;
#line 580 "nibbles-view.vala"
			_tmp19_ = (*_tmp18_).color;
#line 580 "nibbles-view.vala"
			_worm_properties_free0 (_tmp18_);
#line 580 "nibbles-view.vala"
			color = _tmp19_;
#line 583 "nibbles-view.vala"
			_tmp20_ = worm;
#line 583 "nibbles-view.vala"
			_tmp21_ = worm_get_id (_tmp20_);
#line 583 "nibbles-view.vala"
			_tmp22_ = _tmp21_;
#line 583 "nibbles-view.vala"
			_tmp23_ = g_strdup_printf (_ ("Player %d"), _tmp22_ + 1);
#line 583 "nibbles-view.vala"
			player_id = _tmp23_;
#line 584 "nibbles-view.vala"
			_tmp24_ = player_id;
#line 584 "nibbles-view.vala"
			_tmp25_ = string_to_string (_tmp24_);
#line 584 "nibbles-view.vala"
			_tmp26_ = g_strconcat ("<b>", _tmp25_, "</b>", NULL);
#line 584 "nibbles-view.vala"
			_tmp27_ = _tmp26_;
#line 584 "nibbles-view.vala"
			_tmp28_ = (ClutterText*) clutter_text_new_with_text ("Monospace 10", _tmp27_);
#line 584 "nibbles-view.vala"
			g_object_ref_sink (_tmp28_);
#line 584 "nibbles-view.vala"
			_tmp29_ = _tmp28_;
#line 584 "nibbles-view.vala"
			_g_free0 (_tmp27_);
#line 584 "nibbles-view.vala"
			label = _tmp29_;
#line 585 "nibbles-view.vala"
			_tmp30_ = label;
#line 585 "nibbles-view.vala"
			clutter_text_set_use_markup (_tmp30_, TRUE);
#line 586 "nibbles-view.vala"
			_tmp31_ = label;
#line 586 "nibbles-view.vala"
			_tmp32_ = nibbles_view_colorval_name (color);
#line 586 "nibbles-view.vala"
			_tmp33_ = _tmp32_;
#line 586 "nibbles-view.vala"
			clutter_color_from_string (&_tmp34_, _tmp33_);
#line 586 "nibbles-view.vala"
			clutter_text_set_color (_tmp31_, &_tmp34_);
#line 586 "nibbles-view.vala"
			_g_free0 (_tmp33_);
#line 588 "nibbles-view.vala"
			_tmp35_ = worm;
#line 588 "nibbles-view.vala"
			_tmp36_ = worm_get_length (_tmp35_);
#line 588 "nibbles-view.vala"
			_tmp37_ = _tmp36_;
#line 588 "nibbles-view.vala"
			middle = _tmp37_ / 2;
#line 589 "nibbles-view.vala"
			_tmp39_ = worm;
#line 589 "nibbles-view.vala"
			_tmp40_ = _tmp39_->direction;
#line 589 "nibbles-view.vala"
			if (_tmp40_ == WORM_DIRECTION_UP) {
#line 589 "nibbles-view.vala"
				_tmp38_ = TRUE;
#line 4316 "nibbles-view.c"
			} else {
				Worm* _tmp41_;
				WormDirection _tmp42_;
#line 589 "nibbles-view.vala"
				_tmp41_ = worm;
#line 589 "nibbles-view.vala"
				_tmp42_ = _tmp41_->direction;
#line 589 "nibbles-view.vala"
				_tmp38_ = _tmp42_ == WORM_DIRECTION_DOWN;
#line 4326 "nibbles-view.c"
			}
#line 589 "nibbles-view.vala"
			if (_tmp38_) {
#line 4330 "nibbles-view.c"
				ClutterText* _tmp43_;
				Worm* _tmp44_;
				GeeLinkedList* _tmp45_;
				GeeLinkedList* _tmp46_;
				gpointer _tmp47_;
				Position* _tmp48_;
				NibblesGame* _tmp49_;
				NibblesGame* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				ClutterText* _tmp53_;
				gfloat _tmp54_;
				gfloat _tmp55_;
				NibblesGame* _tmp56_;
				NibblesGame* _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				ClutterText* _tmp60_;
				Worm* _tmp61_;
				GeeLinkedList* _tmp62_;
				GeeLinkedList* _tmp63_;
				gpointer _tmp64_;
				Position* _tmp65_;
				NibblesGame* _tmp66_;
				NibblesGame* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				NibblesGame* _tmp70_;
				NibblesGame* _tmp71_;
				gint _tmp72_;
				gint _tmp73_;
#line 591 "nibbles-view.vala"
				_tmp43_ = label;
#line 591 "nibbles-view.vala"
				_tmp44_ = worm;
#line 591 "nibbles-view.vala"
				_tmp45_ = worm_get_list (_tmp44_);
#line 591 "nibbles-view.vala"
				_tmp46_ = _tmp45_;
#line 591 "nibbles-view.vala"
				_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, middle);
#line 591 "nibbles-view.vala"
				_tmp48_ = (Position*) _tmp47_;
#line 591 "nibbles-view.vala"
				_tmp49_ = nibbles_view_get_game (self);
#line 591 "nibbles-view.vala"
				_tmp50_ = _tmp49_;
#line 591 "nibbles-view.vala"
				_tmp51_ = nibbles_game_get_tile_size (_tmp50_);
#line 591 "nibbles-view.vala"
				_tmp52_ = _tmp51_;
#line 591 "nibbles-view.vala"
				_tmp53_ = label;
#line 591 "nibbles-view.vala"
				_tmp54_ = clutter_actor_get_width ((ClutterActor*) _tmp53_);
#line 591 "nibbles-view.vala"
				_tmp55_ = _tmp54_;
#line 591 "nibbles-view.vala"
				_tmp56_ = nibbles_view_get_game (self);
#line 591 "nibbles-view.vala"
				_tmp57_ = _tmp56_;
#line 591 "nibbles-view.vala"
				_tmp58_ = nibbles_game_get_tile_size (_tmp57_);
#line 591 "nibbles-view.vala"
				_tmp59_ = _tmp58_;
#line 591 "nibbles-view.vala"
				clutter_actor_set_x ((ClutterActor*) _tmp43_, (((*_tmp48_).x * _tmp52_) - (_tmp55_ / 2)) + (_tmp59_ / 2));
#line 591 "nibbles-view.vala"
				_position_free0 (_tmp48_);
#line 592 "nibbles-view.vala"
				_tmp60_ = label;
#line 592 "nibbles-view.vala"
				_tmp61_ = worm;
#line 592 "nibbles-view.vala"
				_tmp62_ = worm_get_list (_tmp61_);
#line 592 "nibbles-view.vala"
				_tmp63_ = _tmp62_;
#line 592 "nibbles-view.vala"
				_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, middle);
#line 592 "nibbles-view.vala"
				_tmp65_ = (Position*) _tmp64_;
#line 592 "nibbles-view.vala"
				_tmp66_ = nibbles_view_get_game (self);
#line 592 "nibbles-view.vala"
				_tmp67_ = _tmp66_;
#line 592 "nibbles-view.vala"
				_tmp68_ = nibbles_game_get_tile_size (_tmp67_);
#line 592 "nibbles-view.vala"
				_tmp69_ = _tmp68_;
#line 592 "nibbles-view.vala"
				_tmp70_ = nibbles_view_get_game (self);
#line 592 "nibbles-view.vala"
				_tmp71_ = _tmp70_;
#line 592 "nibbles-view.vala"
				_tmp72_ = nibbles_game_get_tile_size (_tmp71_);
#line 592 "nibbles-view.vala"
				_tmp73_ = _tmp72_;
#line 592 "nibbles-view.vala"
				clutter_actor_set_y ((ClutterActor*) _tmp60_, (gfloat) (((*_tmp65_).y * _tmp69_) - (5 * _tmp73_)));
#line 592 "nibbles-view.vala"
				_position_free0 (_tmp65_);
#line 4432 "nibbles-view.c"
			} else {
				gboolean _tmp74_ = FALSE;
				Worm* _tmp75_;
				WormDirection _tmp76_;
#line 594 "nibbles-view.vala"
				_tmp75_ = worm;
#line 594 "nibbles-view.vala"
				_tmp76_ = _tmp75_->direction;
#line 594 "nibbles-view.vala"
				if (_tmp76_ == WORM_DIRECTION_LEFT) {
#line 594 "nibbles-view.vala"
					_tmp74_ = TRUE;
#line 4445 "nibbles-view.c"
				} else {
					Worm* _tmp77_;
					WormDirection _tmp78_;
#line 594 "nibbles-view.vala"
					_tmp77_ = worm;
#line 594 "nibbles-view.vala"
					_tmp78_ = _tmp77_->direction;
#line 594 "nibbles-view.vala"
					_tmp74_ = _tmp78_ == WORM_DIRECTION_RIGHT;
#line 4455 "nibbles-view.c"
				}
#line 594 "nibbles-view.vala"
				if (_tmp74_) {
#line 4459 "nibbles-view.c"
					ClutterText* _tmp79_;
					Worm* _tmp80_;
					GeeLinkedList* _tmp81_;
					GeeLinkedList* _tmp82_;
					gpointer _tmp83_;
					Position* _tmp84_;
					NibblesGame* _tmp85_;
					NibblesGame* _tmp86_;
					gint _tmp87_;
					gint _tmp88_;
					ClutterText* _tmp89_;
					gfloat _tmp90_;
					gfloat _tmp91_;
					NibblesGame* _tmp92_;
					NibblesGame* _tmp93_;
					gint _tmp94_;
					gint _tmp95_;
					ClutterText* _tmp96_;
					Worm* _tmp97_;
					Position _tmp98_ = {0};
					Position _tmp99_;
					NibblesGame* _tmp100_;
					NibblesGame* _tmp101_;
					gint _tmp102_;
					gint _tmp103_;
					NibblesGame* _tmp104_;
					NibblesGame* _tmp105_;
					gint _tmp106_;
					gint _tmp107_;
#line 596 "nibbles-view.vala"
					_tmp79_ = label;
#line 596 "nibbles-view.vala"
					_tmp80_ = worm;
#line 596 "nibbles-view.vala"
					_tmp81_ = worm_get_list (_tmp80_);
#line 596 "nibbles-view.vala"
					_tmp82_ = _tmp81_;
#line 596 "nibbles-view.vala"
					_tmp83_ = gee_abstract_list_get ((GeeAbstractList*) _tmp82_, middle);
#line 596 "nibbles-view.vala"
					_tmp84_ = (Position*) _tmp83_;
#line 596 "nibbles-view.vala"
					_tmp85_ = nibbles_view_get_game (self);
#line 596 "nibbles-view.vala"
					_tmp86_ = _tmp85_;
#line 596 "nibbles-view.vala"
					_tmp87_ = nibbles_game_get_tile_size (_tmp86_);
#line 596 "nibbles-view.vala"
					_tmp88_ = _tmp87_;
#line 596 "nibbles-view.vala"
					_tmp89_ = label;
#line 596 "nibbles-view.vala"
					_tmp90_ = clutter_actor_get_width ((ClutterActor*) _tmp89_);
#line 596 "nibbles-view.vala"
					_tmp91_ = _tmp90_;
#line 596 "nibbles-view.vala"
					_tmp92_ = nibbles_view_get_game (self);
#line 596 "nibbles-view.vala"
					_tmp93_ = _tmp92_;
#line 596 "nibbles-view.vala"
					_tmp94_ = nibbles_game_get_tile_size (_tmp93_);
#line 596 "nibbles-view.vala"
					_tmp95_ = _tmp94_;
#line 596 "nibbles-view.vala"
					clutter_actor_set_x ((ClutterActor*) _tmp79_, (((*_tmp84_).x * _tmp88_) - (_tmp91_ / 2)) + (_tmp95_ / 2));
#line 596 "nibbles-view.vala"
					_position_free0 (_tmp84_);
#line 597 "nibbles-view.vala"
					_tmp96_ = label;
#line 597 "nibbles-view.vala"
					_tmp97_ = worm;
#line 597 "nibbles-view.vala"
					worm_get_head (_tmp97_, &_tmp98_);
#line 597 "nibbles-view.vala"
					_tmp99_ = _tmp98_;
#line 597 "nibbles-view.vala"
					_tmp100_ = nibbles_view_get_game (self);
#line 597 "nibbles-view.vala"
					_tmp101_ = _tmp100_;
#line 597 "nibbles-view.vala"
					_tmp102_ = nibbles_game_get_tile_size (_tmp101_);
#line 597 "nibbles-view.vala"
					_tmp103_ = _tmp102_;
#line 597 "nibbles-view.vala"
					_tmp104_ = nibbles_view_get_game (self);
#line 597 "nibbles-view.vala"
					_tmp105_ = _tmp104_;
#line 597 "nibbles-view.vala"
					_tmp106_ = nibbles_game_get_tile_size (_tmp105_);
#line 597 "nibbles-view.vala"
					_tmp107_ = _tmp106_;
#line 597 "nibbles-view.vala"
					clutter_actor_set_y ((ClutterActor*) _tmp96_, (gfloat) ((_tmp99_.y * _tmp103_) - (3 * _tmp107_)));
#line 4553 "nibbles-view.c"
				}
			}
#line 599 "nibbles-view.vala"
			_tmp108_ = self->priv->_name_labels;
#line 599 "nibbles-view.vala"
			_tmp109_ = label;
#line 599 "nibbles-view.vala"
			clutter_container_add ((ClutterContainer*) _tmp108_, (ClutterActor*) _tmp109_, NULL);
#line 578 "nibbles-view.vala"
			_g_object_unref0 (label);
#line 578 "nibbles-view.vala"
			_g_free0 (player_id);
#line 578 "nibbles-view.vala"
			_g_object_unref0 (worm);
#line 4568 "nibbles-view.c"
		}
#line 578 "nibbles-view.vala"
		_g_object_unref0 (_worm_list);
#line 4572 "nibbles-view.c"
	}
#line 602 "nibbles-view.vala"
	_tmp110_ = self->priv->level;
#line 602 "nibbles-view.vala"
	_tmp111_ = self->priv->_name_labels;
#line 602 "nibbles-view.vala"
	clutter_actor_add_child (_tmp110_, _tmp111_);
#line 4580 "nibbles-view.c"
}

static void
nibbles_view_worm_added_cb (NibblesView* self,
                            Worm* worm)
{
	GtkClutterTexture* actor = NULL;
	GtkClutterTexture* _tmp0_;
	NibblesGame* _tmp10_;
	NibblesGame* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NibblesGame* _tmp14_;
	NibblesGame* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GeeLinkedList* _tmp18_;
	GeeLinkedList* _tmp19_;
	gpointer _tmp20_;
	Position* _tmp21_;
	NibblesGame* _tmp22_;
	NibblesGame* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GeeLinkedList* _tmp26_;
	GeeLinkedList* _tmp27_;
	gpointer _tmp28_;
	Position* _tmp29_;
	NibblesGame* _tmp30_;
	NibblesGame* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp34_;
	gpointer _tmp35_;
	GError* _inner_error0_ = NULL;
#line 609 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 609 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 611 "nibbles-view.vala"
	_tmp0_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 611 "nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 611 "nibbles-view.vala"
	actor = _tmp0_;
#line 4627 "nibbles-view.c"
	{
		NibblesGame* _tmp1_;
		NibblesGame* _tmp2_;
		GeeHashMap* _tmp3_;
		GeeHashMap* _tmp4_;
		gpointer _tmp5_;
		WormProperties* _tmp6_;
		GdkPixbuf* _tmp7_;
#line 614 "nibbles-view.vala"
		_tmp1_ = nibbles_view_get_game (self);
#line 614 "nibbles-view.vala"
		_tmp2_ = _tmp1_;
#line 614 "nibbles-view.vala"
		_tmp3_ = nibbles_game_get_worm_props (_tmp2_);
#line 614 "nibbles-view.vala"
		_tmp4_ = _tmp3_;
#line 614 "nibbles-view.vala"
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, worm);
#line 614 "nibbles-view.vala"
		_tmp6_ = (WormProperties*) _tmp5_;
#line 614 "nibbles-view.vala"
		_tmp7_ = self->priv->worm_pixmaps[(*_tmp6_).color];
#line 614 "nibbles-view.vala"
		gtk_clutter_texture_set_from_pixbuf (actor, _tmp7_, &_inner_error0_);
#line 614 "nibbles-view.vala"
		_worm_properties_free0 (_tmp6_);
#line 614 "nibbles-view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 614 "nibbles-view.vala"
			if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
#line 4658 "nibbles-view.c"
				goto __catch4_clutter_texture_error;
			}
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
#line 612 "nibbles-view.vala"
		e = _inner_error0_;
#line 612 "nibbles-view.vala"
		_inner_error0_ = NULL;
#line 618 "nibbles-view.vala"
		_tmp8_ = e->message;
#line 618 "nibbles-view.vala"
		g_error ("nibbles-view.vala:618: Nibbles failed to set texture: %s", _tmp8_);
#line 612 "nibbles-view.vala"
		_g_error_free0 (e);
#line 4679 "nibbles-view.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
#line 612 "nibbles-view.vala"
		e = _inner_error0_;
#line 612 "nibbles-view.vala"
		_inner_error0_ = NULL;
#line 622 "nibbles-view.vala"
		_tmp9_ = e->message;
#line 622 "nibbles-view.vala"
		g_error ("nibbles-view.vala:622: Nibbles failed to set texture: %s", _tmp9_);
#line 612 "nibbles-view.vala"
		_g_error_free0 (e);
#line 4696 "nibbles-view.c"
	}
	__finally4:
#line 612 "nibbles-view.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 612 "nibbles-view.vala"
		_g_object_unref0 (actor);
#line 612 "nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 612 "nibbles-view.vala"
		g_clear_error (&_inner_error0_);
#line 612 "nibbles-view.vala"
		return;
#line 4709 "nibbles-view.c"
	}
#line 624 "nibbles-view.vala"
	_tmp10_ = nibbles_view_get_game (self);
#line 624 "nibbles-view.vala"
	_tmp11_ = _tmp10_;
#line 624 "nibbles-view.vala"
	_tmp12_ = nibbles_game_get_tile_size (_tmp11_);
#line 624 "nibbles-view.vala"
	_tmp13_ = _tmp12_;
#line 624 "nibbles-view.vala"
	_tmp14_ = nibbles_view_get_game (self);
#line 624 "nibbles-view.vala"
	_tmp15_ = _tmp14_;
#line 624 "nibbles-view.vala"
	_tmp16_ = nibbles_game_get_tile_size (_tmp15_);
#line 624 "nibbles-view.vala"
	_tmp17_ = _tmp16_;
#line 624 "nibbles-view.vala"
	clutter_actor_set_size ((ClutterActor*) actor, (gfloat) _tmp13_, (gfloat) _tmp17_);
#line 625 "nibbles-view.vala"
	_tmp18_ = worm_get_list (worm);
#line 625 "nibbles-view.vala"
	_tmp19_ = _tmp18_;
#line 625 "nibbles-view.vala"
	_tmp20_ = gee_linked_list_first (_tmp19_);
#line 625 "nibbles-view.vala"
	_tmp21_ = (Position*) _tmp20_;
#line 625 "nibbles-view.vala"
	_tmp22_ = nibbles_view_get_game (self);
#line 625 "nibbles-view.vala"
	_tmp23_ = _tmp22_;
#line 625 "nibbles-view.vala"
	_tmp24_ = nibbles_game_get_tile_size (_tmp23_);
#line 625 "nibbles-view.vala"
	_tmp25_ = _tmp24_;
#line 625 "nibbles-view.vala"
	_tmp26_ = worm_get_list (worm);
#line 625 "nibbles-view.vala"
	_tmp27_ = _tmp26_;
#line 625 "nibbles-view.vala"
	_tmp28_ = gee_linked_list_first (_tmp27_);
#line 625 "nibbles-view.vala"
	_tmp29_ = (Position*) _tmp28_;
#line 625 "nibbles-view.vala"
	_tmp30_ = nibbles_view_get_game (self);
#line 625 "nibbles-view.vala"
	_tmp31_ = _tmp30_;
#line 625 "nibbles-view.vala"
	_tmp32_ = nibbles_game_get_tile_size (_tmp31_);
#line 625 "nibbles-view.vala"
	_tmp33_ = _tmp32_;
#line 625 "nibbles-view.vala"
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) ((*_tmp21_).x * _tmp25_), (gfloat) ((*_tmp29_).y * _tmp33_));
#line 625 "nibbles-view.vala"
	_position_free0 (_tmp29_);
#line 625 "nibbles-view.vala"
	_position_free0 (_tmp21_);
#line 627 "nibbles-view.vala"
	_tmp34_ = self->priv->worm_actors;
#line 627 "nibbles-view.vala"
	_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp34_, worm);
#line 627 "nibbles-view.vala"
	actors = (WormActor*) _tmp35_;
#line 628 "nibbles-view.vala"
	clutter_actor_add_child ((ClutterActor*) actors, (ClutterActor*) actor);
#line 609 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 609 "nibbles-view.vala"
	_g_object_unref0 (actor);
#line 4779 "nibbles-view.c"
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 631 "nibbles-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 631 "nibbles-view.vala"
	return _data7_;
#line 4789 "nibbles-view.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 631 "nibbles-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 4799 "nibbles-view.c"
		NibblesView* self;
#line 631 "nibbles-view.vala"
		self = _data7_->self;
#line 631 "nibbles-view.vala"
		_g_object_unref0 (_data7_->worm);
#line 631 "nibbles-view.vala"
		_g_object_unref0 (self);
#line 631 "nibbles-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 4809 "nibbles-view.c"
	}
}

static gboolean
__lambda5_ (Block7Data* _data7_)
{
	NibblesView* self;
	gboolean result = FALSE;
#line 648 "nibbles-view.vala"
	self = _data7_->self;
#line 649 "nibbles-view.vala"
	_data7_->worm->is_stopped = FALSE;
#line 650 "nibbles-view.vala"
	result = G_SOURCE_REMOVE;
#line 650 "nibbles-view.vala"
	return result;
#line 4826 "nibbles-view.c"
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
#line 648 "nibbles-view.vala"
	return result;
#line 4836 "nibbles-view.c"
}

static void
nibbles_view_worm_finish_added_cb (NibblesView* self,
                                   Worm* worm)
{
	Block7Data* _data7_;
	Worm* _tmp0_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
#line 631 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 631 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 631 "nibbles-view.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 631 "nibbles-view.vala"
	_data7_->_ref_count_ = 1;
#line 631 "nibbles-view.vala"
	_data7_->self = g_object_ref (self);
#line 631 "nibbles-view.vala"
	_tmp0_ = _g_object_ref0 (worm);
#line 631 "nibbles-view.vala"
	_g_object_unref0 (_data7_->worm);
#line 631 "nibbles-view.vala"
	_data7_->worm = _tmp0_;
#line 633 "nibbles-view.vala"
	_tmp1_ = self->priv->worm_actors;
#line 633 "nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _data7_->worm);
#line 633 "nibbles-view.vala"
	actors = (WormActor*) _tmp2_;
#line 635 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0);
#line 636 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) actors, 3.0, 3.0);
#line 638 "nibbles-view.vala"
	clutter_actor_save_easing_state ((ClutterActor*) actors);
#line 639 "nibbles-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) actors, CLUTTER_EASE_OUT);
#line 640 "nibbles-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) actors, (guint) (NIBBLES_GAME_GAMEDELAY * 20));
#line 641 "nibbles-view.vala"
	clutter_actor_set_scale ((ClutterActor*) actors, 1.0, 1.0);
#line 642 "nibbles-view.vala"
	clutter_actor_set_pivot_point ((ClutterActor*) actors, 0.5f, 0.5f);
#line 643 "nibbles-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) actors, (guint8) 0xff);
#line 644 "nibbles-view.vala"
	clutter_actor_restore_easing_state ((ClutterActor*) actors);
#line 646 "nibbles-view.vala"
	_tmp3_ = nibbles_view_get_game (self);
#line 646 "nibbles-view.vala"
	_tmp4_ = _tmp3_;
#line 646 "nibbles-view.vala"
	_tmp5_ = _tmp4_->board;
#line 646 "nibbles-view.vala"
	_tmp5__length1 = _tmp4_->board_length1;
#line 646 "nibbles-view.vala"
	_tmp5__length2 = _tmp4_->board_length2;
#line 646 "nibbles-view.vala"
	worm_dematerialize (_data7_->worm, _tmp5_, (gint) _tmp5__length1, (gint) _tmp5__length2, 3);
#line 648 "nibbles-view.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (NIBBLES_GAME_GAMEDELAY * 27), ___lambda5__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 631 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 631 "nibbles-view.vala"
	block7_data_unref (_data7_);
#line 631 "nibbles-view.vala"
	_data7_ = NULL;
#line 4913 "nibbles-view.c"
}

static void
nibbles_view_worm_moved_cb (NibblesView* self,
                            Worm* worm)
{
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ClutterActor* tail_actor = NULL;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
#line 654 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 654 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 656 "nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 656 "nibbles-view.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
#line 656 "nibbles-view.vala"
	actors = (WormActor*) _tmp1_;
#line 658 "nibbles-view.vala"
	_tmp2_ = clutter_actor_get_first_child ((ClutterActor*) actors);
#line 658 "nibbles-view.vala"
	_tmp3_ = _tmp2_;
#line 658 "nibbles-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 658 "nibbles-view.vala"
	tail_actor = _tmp4_;
#line 659 "nibbles-view.vala"
	clutter_actor_remove_child ((ClutterActor*) actors, tail_actor);
#line 660 "nibbles-view.vala"
	nibbles_view_worm_added_cb (self, worm);
#line 654 "nibbles-view.vala"
	_g_object_unref0 (tail_actor);
#line 654 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 4953 "nibbles-view.c"
}

static void
nibbles_view_worm_rescaled_cb (NibblesView* self,
                               Worm* worm,
                               gint tile_size)
{
	gfloat x_pos = 0.0F;
	gfloat y_pos = 0.0F;
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	WormActor* _tmp2_;
	WormActor* _tmp3_;
	GList* _tmp4_;
#line 663 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 663 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 666 "nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 666 "nibbles-view.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
#line 666 "nibbles-view.vala"
	actors = (WormActor*) _tmp1_;
#line 667 "nibbles-view.vala"
	_tmp2_ = actors;
#line 667 "nibbles-view.vala"
	if (_tmp2_ == NULL) {
#line 668 "nibbles-view.vala"
		_g_object_unref0 (actors);
#line 668 "nibbles-view.vala"
		return;
#line 4987 "nibbles-view.c"
	}
#line 670 "nibbles-view.vala"
	_tmp3_ = actors;
#line 670 "nibbles-view.vala"
	_tmp4_ = clutter_actor_get_children ((ClutterActor*) _tmp3_);
#line 4993 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 670 "nibbles-view.vala"
		actor_collection = _tmp4_;
#line 670 "nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 5001 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 670 "nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 5005 "nibbles-view.c"
			{
				ClutterActor* _tmp5_;
				gfloat _tmp6_ = 0.0F;
				gfloat _tmp7_ = 0.0F;
				ClutterActor* _tmp8_;
				NibblesGame* _tmp9_;
				NibblesGame* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				NibblesGame* _tmp13_;
				NibblesGame* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				ClutterActor* _tmp17_;
#line 672 "nibbles-view.vala"
				_tmp5_ = actor;
#line 672 "nibbles-view.vala"
				clutter_actor_get_position (_tmp5_, &_tmp6_, &_tmp7_);
#line 672 "nibbles-view.vala"
				x_pos = _tmp6_;
#line 672 "nibbles-view.vala"
				y_pos = _tmp7_;
#line 673 "nibbles-view.vala"
				_tmp8_ = actor;
#line 673 "nibbles-view.vala"
				_tmp9_ = nibbles_view_get_game (self);
#line 673 "nibbles-view.vala"
				_tmp10_ = _tmp9_;
#line 673 "nibbles-view.vala"
				_tmp11_ = nibbles_game_get_tile_size (_tmp10_);
#line 673 "nibbles-view.vala"
				_tmp12_ = _tmp11_;
#line 673 "nibbles-view.vala"
				_tmp13_ = nibbles_view_get_game (self);
#line 673 "nibbles-view.vala"
				_tmp14_ = _tmp13_;
#line 673 "nibbles-view.vala"
				_tmp15_ = nibbles_game_get_tile_size (_tmp14_);
#line 673 "nibbles-view.vala"
				_tmp16_ = _tmp15_;
#line 673 "nibbles-view.vala"
				clutter_actor_set_position (_tmp8_, (x_pos / _tmp12_) * tile_size, (y_pos / _tmp16_) * tile_size);
#line 675 "nibbles-view.vala"
				_tmp17_ = actor;
#line 675 "nibbles-view.vala"
				clutter_actor_set_size (_tmp17_, (gfloat) tile_size, (gfloat) tile_size);
#line 5052 "nibbles-view.c"
			}
		}
#line 670 "nibbles-view.vala"
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
#line 5057 "nibbles-view.c"
	}
#line 663 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 5061 "nibbles-view.c"
}

static void
nibbles_view_worm_died_cb (NibblesView* self,
                           Worm* worm)
{
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_;
	WormActor* actors = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	WormActor* _tmp3_;
	GList* _tmp4_;
	WormActor* _tmp32_;
	ClutterActor* _tmp33_;
	ClutterActor* _tmp34_;
	ClutterActor* _tmp35_;
	ClutterActor* _tmp36_;
	ClutterActor* _tmp37_;
	ClutterActor* _tmp38_;
	ClutterActor* _tmp39_;
	ClutterActor* _tmp40_;
	ClutterActor* _tmp41_;
	GError* _inner_error0_ = NULL;
#line 679 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 679 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 682 "nibbles-view.vala"
	_tmp0_ = clutter_actor_new ();
#line 682 "nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 682 "nibbles-view.vala"
	group = _tmp0_;
#line 683 "nibbles-view.vala"
	_tmp1_ = self->priv->worm_actors;
#line 683 "nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, worm);
#line 683 "nibbles-view.vala"
	actors = (WormActor*) _tmp2_;
#line 684 "nibbles-view.vala"
	_tmp3_ = actors;
#line 684 "nibbles-view.vala"
	_tmp4_ = clutter_actor_get_children ((ClutterActor*) _tmp3_);
#line 5108 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 684 "nibbles-view.vala"
		actor_collection = _tmp4_;
#line 684 "nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 5116 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 684 "nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 5120 "nibbles-view.c"
			{
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp5_;
				gint color = 0;
				NibblesGame* _tmp6_;
				NibblesGame* _tmp7_;
				GeeHashMap* _tmp8_;
				GeeHashMap* _tmp9_;
				gpointer _tmp10_;
				WormProperties* _tmp11_;
				gint _tmp12_;
				ClutterActor* _tmp17_;
				gfloat _tmp18_ = 0.0F;
				gfloat _tmp19_ = 0.0F;
				GtkClutterTexture* _tmp20_;
				GtkClutterTexture* _tmp21_;
				NibblesGame* _tmp22_;
				NibblesGame* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				NibblesGame* _tmp26_;
				NibblesGame* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				ClutterActor* _tmp30_;
				GtkClutterTexture* _tmp31_;
#line 686 "nibbles-view.vala"
				_tmp5_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 686 "nibbles-view.vala"
				g_object_ref_sink (_tmp5_);
#line 686 "nibbles-view.vala"
				texture = _tmp5_;
#line 687 "nibbles-view.vala"
				_tmp6_ = nibbles_view_get_game (self);
#line 687 "nibbles-view.vala"
				_tmp7_ = _tmp6_;
#line 687 "nibbles-view.vala"
				_tmp8_ = nibbles_game_get_worm_props (_tmp7_);
#line 687 "nibbles-view.vala"
				_tmp9_ = _tmp8_;
#line 687 "nibbles-view.vala"
				_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, worm);
#line 687 "nibbles-view.vala"
				_tmp11_ = (WormProperties*) _tmp10_;
#line 687 "nibbles-view.vala"
				_tmp12_ = (*_tmp11_).color;
#line 687 "nibbles-view.vala"
				_worm_properties_free0 (_tmp11_);
#line 687 "nibbles-view.vala"
				color = _tmp12_;
#line 5171 "nibbles-view.c"
				{
					GtkClutterTexture* _tmp13_;
					GdkPixbuf* _tmp14_;
#line 690 "nibbles-view.vala"
					_tmp13_ = texture;
#line 690 "nibbles-view.vala"
					_tmp14_ = self->priv->worm_pixmaps[color];
#line 690 "nibbles-view.vala"
					gtk_clutter_texture_set_from_pixbuf (_tmp13_, _tmp14_, &_inner_error0_);
#line 690 "nibbles-view.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 690 "nibbles-view.vala"
						if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
#line 5185 "nibbles-view.c"
							goto __catch5_clutter_texture_error;
						}
						goto __catch5_g_error;
					}
				}
				goto __finally5;
				__catch5_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp15_;
#line 688 "nibbles-view.vala"
					e = _inner_error0_;
#line 688 "nibbles-view.vala"
					_inner_error0_ = NULL;
#line 694 "nibbles-view.vala"
					_tmp15_ = e->message;
#line 694 "nibbles-view.vala"
					g_error ("nibbles-view.vala:694: Nibbles failed to set texture: %s", _tmp15_);
#line 688 "nibbles-view.vala"
					_g_error_free0 (e);
#line 5206 "nibbles-view.c"
				}
				goto __finally5;
				__catch5_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp16_;
#line 688 "nibbles-view.vala"
					e = _inner_error0_;
#line 688 "nibbles-view.vala"
					_inner_error0_ = NULL;
#line 698 "nibbles-view.vala"
					_tmp16_ = e->message;
#line 698 "nibbles-view.vala"
					g_error ("nibbles-view.vala:698: Nibbles failed to set texture: %s", _tmp16_);
#line 688 "nibbles-view.vala"
					_g_error_free0 (e);
#line 5223 "nibbles-view.c"
				}
				__finally5:
#line 688 "nibbles-view.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 688 "nibbles-view.vala"
					_g_object_unref0 (texture);
#line 688 "nibbles-view.vala"
					(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
#line 688 "nibbles-view.vala"
					_g_object_unref0 (actors);
#line 688 "nibbles-view.vala"
					_g_object_unref0 (group);
#line 688 "nibbles-view.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 688 "nibbles-view.vala"
					g_clear_error (&_inner_error0_);
#line 688 "nibbles-view.vala"
					return;
#line 5242 "nibbles-view.c"
				}
#line 701 "nibbles-view.vala"
				_tmp17_ = actor;
#line 701 "nibbles-view.vala"
				clutter_actor_get_position (_tmp17_, &_tmp18_, &_tmp19_);
#line 701 "nibbles-view.vala"
				x = _tmp18_;
#line 701 "nibbles-view.vala"
				y = _tmp19_;
#line 703 "nibbles-view.vala"
				_tmp20_ = texture;
#line 703 "nibbles-view.vala"
				clutter_actor_set_position ((ClutterActor*) _tmp20_, x, y);
#line 704 "nibbles-view.vala"
				_tmp21_ = texture;
#line 704 "nibbles-view.vala"
				_tmp22_ = nibbles_view_get_game (self);
#line 704 "nibbles-view.vala"
				_tmp23_ = _tmp22_;
#line 704 "nibbles-view.vala"
				_tmp24_ = nibbles_game_get_tile_size (_tmp23_);
#line 704 "nibbles-view.vala"
				_tmp25_ = _tmp24_;
#line 704 "nibbles-view.vala"
				_tmp26_ = nibbles_view_get_game (self);
#line 704 "nibbles-view.vala"
				_tmp27_ = _tmp26_;
#line 704 "nibbles-view.vala"
				_tmp28_ = nibbles_game_get_tile_size (_tmp27_);
#line 704 "nibbles-view.vala"
				_tmp29_ = _tmp28_;
#line 704 "nibbles-view.vala"
				clutter_actor_set_size ((ClutterActor*) _tmp21_, (gfloat) _tmp25_, (gfloat) _tmp29_);
#line 705 "nibbles-view.vala"
				_tmp30_ = group;
#line 705 "nibbles-view.vala"
				_tmp31_ = texture;
#line 705 "nibbles-view.vala"
				clutter_actor_add_child (_tmp30_, (ClutterActor*) _tmp31_);
#line 684 "nibbles-view.vala"
				_g_object_unref0 (texture);
#line 5284 "nibbles-view.c"
			}
		}
#line 684 "nibbles-view.vala"
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
#line 5289 "nibbles-view.c"
	}
#line 708 "nibbles-view.vala"
	_tmp32_ = actors;
#line 708 "nibbles-view.vala"
	clutter_actor_remove_all_children ((ClutterActor*) _tmp32_);
#line 710 "nibbles-view.vala"
	_tmp33_ = self->priv->level;
#line 710 "nibbles-view.vala"
	_tmp34_ = group;
#line 710 "nibbles-view.vala"
	clutter_actor_add_child (_tmp33_, _tmp34_);
#line 712 "nibbles-view.vala"
	_tmp35_ = group;
#line 712 "nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp35_);
#line 713 "nibbles-view.vala"
	_tmp36_ = group;
#line 713 "nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp36_, CLUTTER_EASE_OUT_QUAD);
#line 714 "nibbles-view.vala"
	_tmp37_ = group;
#line 714 "nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp37_, (guint) (NIBBLES_GAME_GAMEDELAY * 9));
#line 715 "nibbles-view.vala"
	_tmp38_ = group;
#line 715 "nibbles-view.vala"
	clutter_actor_set_scale (_tmp38_, (gdouble) 2.0f, (gdouble) 2.0f);
#line 716 "nibbles-view.vala"
	_tmp39_ = group;
#line 716 "nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp39_, 0.5f, 0.5f);
#line 717 "nibbles-view.vala"
	_tmp40_ = group;
#line 717 "nibbles-view.vala"
	clutter_actor_set_opacity (_tmp40_, (guint8) 0);
#line 718 "nibbles-view.vala"
	_tmp41_ = group;
#line 718 "nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp41_);
#line 720 "nibbles-view.vala"
	nibbles_view_play_sound (self, "crash");
#line 679 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 679 "nibbles-view.vala"
	_g_object_unref0 (group);
#line 5335 "nibbles-view.c"
}

static void
nibbles_view_worm_tail_reduced_cb (NibblesView* self,
                                   Worm* worm,
                                   gint erase_size)
{
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* group = NULL;
	ClutterActor* _tmp0_;
	WormActor* worm_actors = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gint color = 0;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	GeeHashMap* _tmp5_;
	GeeHashMap* _tmp6_;
	gpointer _tmp7_;
	WormProperties* _tmp8_;
	gint _tmp9_;
	ClutterActor* _tmp38_;
	ClutterActor* _tmp39_;
	ClutterActor* _tmp40_;
	ClutterActor* _tmp41_;
	ClutterActor* _tmp42_;
	ClutterActor* _tmp43_;
	ClutterActor* _tmp44_;
	GError* _inner_error0_ = NULL;
#line 723 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 723 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 726 "nibbles-view.vala"
	_tmp0_ = clutter_actor_new ();
#line 726 "nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 726 "nibbles-view.vala"
	group = _tmp0_;
#line 727 "nibbles-view.vala"
	_tmp1_ = self->priv->worm_actors;
#line 727 "nibbles-view.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, worm);
#line 727 "nibbles-view.vala"
	worm_actors = (WormActor*) _tmp2_;
#line 728 "nibbles-view.vala"
	_tmp3_ = nibbles_view_get_game (self);
#line 728 "nibbles-view.vala"
	_tmp4_ = _tmp3_;
#line 728 "nibbles-view.vala"
	_tmp5_ = nibbles_game_get_worm_props (_tmp4_);
#line 728 "nibbles-view.vala"
	_tmp6_ = _tmp5_;
#line 728 "nibbles-view.vala"
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, worm);
#line 728 "nibbles-view.vala"
	_tmp8_ = (WormProperties*) _tmp7_;
#line 728 "nibbles-view.vala"
	_tmp9_ = (*_tmp8_).color;
#line 728 "nibbles-view.vala"
	_worm_properties_free0 (_tmp8_);
#line 728 "nibbles-view.vala"
	color = _tmp9_;
#line 5400 "nibbles-view.c"
	{
		gint i = 0;
#line 729 "nibbles-view.vala"
		i = 0;
#line 5405 "nibbles-view.c"
		{
			gboolean _tmp10_ = FALSE;
#line 729 "nibbles-view.vala"
			_tmp10_ = TRUE;
#line 729 "nibbles-view.vala"
			while (TRUE) {
#line 5412 "nibbles-view.c"
				GtkClutterTexture* texture = NULL;
				GtkClutterTexture* _tmp12_;
				WormActor* _tmp17_;
				ClutterActor* _tmp18_;
				ClutterActor* _tmp19_;
				gfloat _tmp20_ = 0.0F;
				gfloat _tmp21_ = 0.0F;
				WormActor* _tmp22_;
				WormActor* _tmp23_;
				ClutterActor* _tmp24_;
				ClutterActor* _tmp25_;
				GtkClutterTexture* _tmp26_;
				GtkClutterTexture* _tmp27_;
				NibblesGame* _tmp28_;
				NibblesGame* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				NibblesGame* _tmp32_;
				NibblesGame* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				ClutterActor* _tmp36_;
				GtkClutterTexture* _tmp37_;
#line 729 "nibbles-view.vala"
				if (!_tmp10_) {
#line 5438 "nibbles-view.c"
					gint _tmp11_;
#line 729 "nibbles-view.vala"
					_tmp11_ = i;
#line 729 "nibbles-view.vala"
					i = _tmp11_ + 1;
#line 5444 "nibbles-view.c"
				}
#line 729 "nibbles-view.vala"
				_tmp10_ = FALSE;
#line 729 "nibbles-view.vala"
				if (!(i < erase_size)) {
#line 729 "nibbles-view.vala"
					break;
#line 5452 "nibbles-view.c"
				}
#line 731 "nibbles-view.vala"
				_tmp12_ = (GtkClutterTexture*) gtk_clutter_texture_new ();
#line 731 "nibbles-view.vala"
				g_object_ref_sink (_tmp12_);
#line 731 "nibbles-view.vala"
				texture = _tmp12_;
#line 5460 "nibbles-view.c"
				{
					GtkClutterTexture* _tmp13_;
					GdkPixbuf* _tmp14_;
#line 734 "nibbles-view.vala"
					_tmp13_ = texture;
#line 734 "nibbles-view.vala"
					_tmp14_ = self->priv->worm_pixmaps[color];
#line 734 "nibbles-view.vala"
					gtk_clutter_texture_set_from_pixbuf (_tmp13_, _tmp14_, &_inner_error0_);
#line 734 "nibbles-view.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 734 "nibbles-view.vala"
						if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
#line 5474 "nibbles-view.c"
							goto __catch6_clutter_texture_error;
						}
						goto __catch6_g_error;
					}
				}
				goto __finally6;
				__catch6_clutter_texture_error:
				{
					GError* e = NULL;
					const gchar* _tmp15_;
#line 732 "nibbles-view.vala"
					e = _inner_error0_;
#line 732 "nibbles-view.vala"
					_inner_error0_ = NULL;
#line 738 "nibbles-view.vala"
					_tmp15_ = e->message;
#line 738 "nibbles-view.vala"
					g_error ("nibbles-view.vala:738: Nibbles failed to set texture: %s", _tmp15_);
#line 732 "nibbles-view.vala"
					_g_error_free0 (e);
#line 5495 "nibbles-view.c"
				}
				goto __finally6;
				__catch6_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp16_;
#line 732 "nibbles-view.vala"
					e = _inner_error0_;
#line 732 "nibbles-view.vala"
					_inner_error0_ = NULL;
#line 742 "nibbles-view.vala"
					_tmp16_ = e->message;
#line 742 "nibbles-view.vala"
					g_error ("nibbles-view.vala:742: Nibbles failed to set texture: %s", _tmp16_);
#line 732 "nibbles-view.vala"
					_g_error_free0 (e);
#line 5512 "nibbles-view.c"
				}
				__finally6:
#line 732 "nibbles-view.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 732 "nibbles-view.vala"
					_g_object_unref0 (texture);
#line 732 "nibbles-view.vala"
					_g_object_unref0 (worm_actors);
#line 732 "nibbles-view.vala"
					_g_object_unref0 (group);
#line 732 "nibbles-view.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 732 "nibbles-view.vala"
					g_clear_error (&_inner_error0_);
#line 732 "nibbles-view.vala"
					return;
#line 5529 "nibbles-view.c"
				}
#line 745 "nibbles-view.vala"
				_tmp17_ = worm_actors;
#line 745 "nibbles-view.vala"
				_tmp18_ = clutter_actor_get_first_child ((ClutterActor*) _tmp17_);
#line 745 "nibbles-view.vala"
				_tmp19_ = _tmp18_;
#line 745 "nibbles-view.vala"
				clutter_actor_get_position (_tmp19_, &_tmp20_, &_tmp21_);
#line 745 "nibbles-view.vala"
				x = _tmp20_;
#line 745 "nibbles-view.vala"
				y = _tmp21_;
#line 746 "nibbles-view.vala"
				_tmp22_ = worm_actors;
#line 746 "nibbles-view.vala"
				_tmp23_ = worm_actors;
#line 746 "nibbles-view.vala"
				_tmp24_ = clutter_actor_get_first_child ((ClutterActor*) _tmp23_);
#line 746 "nibbles-view.vala"
				_tmp25_ = _tmp24_;
#line 746 "nibbles-view.vala"
				clutter_actor_remove_child ((ClutterActor*) _tmp22_, _tmp25_);
#line 748 "nibbles-view.vala"
				_tmp26_ = texture;
#line 748 "nibbles-view.vala"
				clutter_actor_set_position ((ClutterActor*) _tmp26_, x, y);
#line 749 "nibbles-view.vala"
				_tmp27_ = texture;
#line 749 "nibbles-view.vala"
				_tmp28_ = nibbles_view_get_game (self);
#line 749 "nibbles-view.vala"
				_tmp29_ = _tmp28_;
#line 749 "nibbles-view.vala"
				_tmp30_ = nibbles_game_get_tile_size (_tmp29_);
#line 749 "nibbles-view.vala"
				_tmp31_ = _tmp30_;
#line 749 "nibbles-view.vala"
				_tmp32_ = nibbles_view_get_game (self);
#line 749 "nibbles-view.vala"
				_tmp33_ = _tmp32_;
#line 749 "nibbles-view.vala"
				_tmp34_ = nibbles_game_get_tile_size (_tmp33_);
#line 749 "nibbles-view.vala"
				_tmp35_ = _tmp34_;
#line 749 "nibbles-view.vala"
				clutter_actor_set_size ((ClutterActor*) _tmp27_, (gfloat) _tmp31_, (gfloat) _tmp35_);
#line 750 "nibbles-view.vala"
				_tmp36_ = group;
#line 750 "nibbles-view.vala"
				_tmp37_ = texture;
#line 750 "nibbles-view.vala"
				clutter_actor_add_child (_tmp36_, (ClutterActor*) _tmp37_);
#line 729 "nibbles-view.vala"
				_g_object_unref0 (texture);
#line 5585 "nibbles-view.c"
			}
		}
	}
#line 752 "nibbles-view.vala"
	_tmp38_ = self->priv->level;
#line 752 "nibbles-view.vala"
	_tmp39_ = group;
#line 752 "nibbles-view.vala"
	clutter_actor_add_child (_tmp38_, _tmp39_);
#line 754 "nibbles-view.vala"
	_tmp40_ = group;
#line 754 "nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp40_);
#line 755 "nibbles-view.vala"
	_tmp41_ = group;
#line 755 "nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp41_, CLUTTER_EASE_OUT_EXPO);
#line 756 "nibbles-view.vala"
	_tmp42_ = group;
#line 756 "nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp42_, (guint) (NIBBLES_GAME_GAMEDELAY * 25));
#line 757 "nibbles-view.vala"
	_tmp43_ = group;
#line 757 "nibbles-view.vala"
	clutter_actor_set_opacity (_tmp43_, (guint8) 0);
#line 758 "nibbles-view.vala"
	_tmp44_ = group;
#line 758 "nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp44_);
#line 723 "nibbles-view.vala"
	_g_object_unref0 (worm_actors);
#line 723 "nibbles-view.vala"
	_g_object_unref0 (group);
#line 5619 "nibbles-view.c"
}

static void
nibbles_view_worm_reversed_cb (NibblesView* self,
                               Worm* worm)
{
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gint count = 0;
	WormActor* _tmp2_;
	GList* _tmp3_;
#line 761 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 761 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 763 "nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 763 "nibbles-view.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
#line 763 "nibbles-view.vala"
	actors = (WormActor*) _tmp1_;
#line 765 "nibbles-view.vala"
	count = 0;
#line 766 "nibbles-view.vala"
	_tmp2_ = actors;
#line 766 "nibbles-view.vala"
	_tmp3_ = clutter_actor_get_children ((ClutterActor*) _tmp2_);
#line 5648 "nibbles-view.c"
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
#line 766 "nibbles-view.vala"
		actor_collection = _tmp3_;
#line 766 "nibbles-view.vala"
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
#line 5656 "nibbles-view.c"
			ClutterActor* actor = NULL;
#line 766 "nibbles-view.vala"
			actor = (ClutterActor*) actor_it->data;
#line 5660 "nibbles-view.c"
			{
				ClutterActor* _tmp4_;
				GeeLinkedList* _tmp5_;
				GeeLinkedList* _tmp6_;
				gpointer _tmp7_;
				Position* _tmp8_;
				NibblesGame* _tmp9_;
				NibblesGame* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				GeeLinkedList* _tmp13_;
				GeeLinkedList* _tmp14_;
				gpointer _tmp15_;
				Position* _tmp16_;
				NibblesGame* _tmp17_;
				NibblesGame* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
#line 768 "nibbles-view.vala"
				_tmp4_ = actor;
#line 768 "nibbles-view.vala"
				_tmp5_ = worm_get_list (worm);
#line 768 "nibbles-view.vala"
				_tmp6_ = _tmp5_;
#line 768 "nibbles-view.vala"
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, count);
#line 768 "nibbles-view.vala"
				_tmp8_ = (Position*) _tmp7_;
#line 768 "nibbles-view.vala"
				_tmp9_ = nibbles_view_get_game (self);
#line 768 "nibbles-view.vala"
				_tmp10_ = _tmp9_;
#line 768 "nibbles-view.vala"
				_tmp11_ = nibbles_game_get_tile_size (_tmp10_);
#line 768 "nibbles-view.vala"
				_tmp12_ = _tmp11_;
#line 768 "nibbles-view.vala"
				_tmp13_ = worm_get_list (worm);
#line 768 "nibbles-view.vala"
				_tmp14_ = _tmp13_;
#line 768 "nibbles-view.vala"
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, count);
#line 768 "nibbles-view.vala"
				_tmp16_ = (Position*) _tmp15_;
#line 768 "nibbles-view.vala"
				_tmp17_ = nibbles_view_get_game (self);
#line 768 "nibbles-view.vala"
				_tmp18_ = _tmp17_;
#line 768 "nibbles-view.vala"
				_tmp19_ = nibbles_game_get_tile_size (_tmp18_);
#line 768 "nibbles-view.vala"
				_tmp20_ = _tmp19_;
#line 768 "nibbles-view.vala"
				clutter_actor_set_position (_tmp4_, (gfloat) ((*_tmp8_).x * _tmp12_), (gfloat) ((*_tmp16_).y * _tmp20_));
#line 768 "nibbles-view.vala"
				_position_free0 (_tmp16_);
#line 768 "nibbles-view.vala"
				_position_free0 (_tmp8_);
#line 769 "nibbles-view.vala"
				_tmp21_ = count;
#line 769 "nibbles-view.vala"
				count = _tmp21_ + 1;
#line 5724 "nibbles-view.c"
			}
		}
#line 766 "nibbles-view.vala"
		(actor_collection == NULL) ? NULL : (actor_collection = (g_list_free (actor_collection), NULL));
#line 5729 "nibbles-view.c"
	}
#line 761 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 5733 "nibbles-view.c"
}

static void
nibbles_view_bonus_added_cb (NibblesView* self)
{
	Bonus* bonus = NULL;
	NibblesGame* _tmp0_;
	NibblesGame* _tmp1_;
	Boni* _tmp2_;
	Boni* _tmp3_;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_;
	BonusTexture* actor = NULL;
	BonusTexture* _tmp6_;
	NibblesGame* _tmp11_;
	NibblesGame* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	NibblesGame* _tmp15_;
	NibblesGame* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	NibblesGame* _tmp19_;
	NibblesGame* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	NibblesGame* _tmp23_;
	NibblesGame* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	ClutterActor* _tmp27_;
	BonusType _tmp28_;
	GeeHashMap* _tmp29_;
	GError* _inner_error0_ = NULL;
#line 777 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 780 "nibbles-view.vala"
	_tmp0_ = nibbles_view_get_game (self);
#line 780 "nibbles-view.vala"
	_tmp1_ = _tmp0_;
#line 780 "nibbles-view.vala"
	_tmp2_ = nibbles_game_get_boni (_tmp1_);
#line 780 "nibbles-view.vala"
	_tmp3_ = _tmp2_;
#line 780 "nibbles-view.vala"
	_tmp4_ = _tmp3_->bonuses;
#line 780 "nibbles-view.vala"
	_tmp5_ = gee_linked_list_last (_tmp4_);
#line 780 "nibbles-view.vala"
	bonus = (Bonus*) _tmp5_;
#line 781 "nibbles-view.vala"
	_tmp6_ = bonus_texture_new ();
#line 781 "nibbles-view.vala"
	g_object_ref_sink (_tmp6_);
#line 781 "nibbles-view.vala"
	actor = _tmp6_;
#line 5790 "nibbles-view.c"
	{
		BonusType _tmp7_;
		GdkPixbuf* _tmp8_;
#line 784 "nibbles-view.vala"
		_tmp7_ = bonus->type;
#line 784 "nibbles-view.vala"
		_tmp8_ = self->priv->boni_pixmaps[_tmp7_];
#line 784 "nibbles-view.vala"
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp8_, &_inner_error0_);
#line 784 "nibbles-view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 784 "nibbles-view.vala"
			if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
#line 5804 "nibbles-view.c"
				goto __catch7_clutter_texture_error;
			}
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
#line 782 "nibbles-view.vala"
		e = _inner_error0_;
#line 782 "nibbles-view.vala"
		_inner_error0_ = NULL;
#line 788 "nibbles-view.vala"
		_tmp9_ = e->message;
#line 788 "nibbles-view.vala"
		g_error ("nibbles-view.vala:788: Nibbles failed to set texture: %s", _tmp9_);
#line 782 "nibbles-view.vala"
		_g_error_free0 (e);
#line 5825 "nibbles-view.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
#line 782 "nibbles-view.vala"
		e = _inner_error0_;
#line 782 "nibbles-view.vala"
		_inner_error0_ = NULL;
#line 792 "nibbles-view.vala"
		_tmp10_ = e->message;
#line 792 "nibbles-view.vala"
		g_error ("nibbles-view.vala:792: Nibbles failed to set texture: %s", _tmp10_);
#line 782 "nibbles-view.vala"
		_g_error_free0 (e);
#line 5842 "nibbles-view.c"
	}
	__finally7:
#line 782 "nibbles-view.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 782 "nibbles-view.vala"
		_g_object_unref0 (actor);
#line 782 "nibbles-view.vala"
		_g_object_unref0 (bonus);
#line 782 "nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 782 "nibbles-view.vala"
		g_clear_error (&_inner_error0_);
#line 782 "nibbles-view.vala"
		return;
#line 5857 "nibbles-view.c"
	}
#line 795 "nibbles-view.vala"
	_tmp11_ = nibbles_view_get_game (self);
#line 795 "nibbles-view.vala"
	_tmp12_ = _tmp11_;
#line 795 "nibbles-view.vala"
	_tmp13_ = nibbles_game_get_tile_size (_tmp12_);
#line 795 "nibbles-view.vala"
	_tmp14_ = _tmp13_;
#line 795 "nibbles-view.vala"
	_tmp15_ = nibbles_view_get_game (self);
#line 795 "nibbles-view.vala"
	_tmp16_ = _tmp15_;
#line 795 "nibbles-view.vala"
	_tmp17_ = nibbles_game_get_tile_size (_tmp16_);
#line 795 "nibbles-view.vala"
	_tmp18_ = _tmp17_;
#line 795 "nibbles-view.vala"
	bonus_texture_set_size (actor, (gfloat) _tmp14_, (gfloat) _tmp18_);
#line 796 "nibbles-view.vala"
	_tmp19_ = nibbles_view_get_game (self);
#line 796 "nibbles-view.vala"
	_tmp20_ = _tmp19_;
#line 796 "nibbles-view.vala"
	_tmp21_ = nibbles_game_get_tile_size (_tmp20_);
#line 796 "nibbles-view.vala"
	_tmp22_ = _tmp21_;
#line 796 "nibbles-view.vala"
	_tmp23_ = nibbles_view_get_game (self);
#line 796 "nibbles-view.vala"
	_tmp24_ = _tmp23_;
#line 796 "nibbles-view.vala"
	_tmp25_ = nibbles_game_get_tile_size (_tmp24_);
#line 796 "nibbles-view.vala"
	_tmp26_ = _tmp25_;
#line 796 "nibbles-view.vala"
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (bonus->x * _tmp22_), (gfloat) (bonus->y * _tmp26_));
#line 798 "nibbles-view.vala"
	_tmp27_ = self->priv->level;
#line 798 "nibbles-view.vala"
	clutter_actor_add_child (_tmp27_, (ClutterActor*) actor);
#line 799 "nibbles-view.vala"
	_tmp28_ = bonus->type;
#line 799 "nibbles-view.vala"
	if (_tmp28_ != BONUS_TYPE_REGULAR) {
#line 800 "nibbles-view.vala"
		nibbles_view_play_sound (self, "appear");
#line 5905 "nibbles-view.c"
	}
#line 802 "nibbles-view.vala"
	_tmp29_ = self->priv->bonus_actors;
#line 802 "nibbles-view.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp29_, bonus, actor);
#line 777 "nibbles-view.vala"
	_g_object_unref0 (actor);
#line 777 "nibbles-view.vala"
	_g_object_unref0 (bonus);
#line 5915 "nibbles-view.c"
}

static void
nibbles_view_bonus_removed_cb (NibblesView* self,
                               Bonus* bonus)
{
	BonusTexture* bonus_actor = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GeeHashMap* _tmp2_;
	ClutterActor* _tmp3_;
#line 805 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 805 "nibbles-view.vala"
	g_return_if_fail (bonus != NULL);
#line 807 "nibbles-view.vala"
	_tmp0_ = self->priv->bonus_actors;
#line 807 "nibbles-view.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, bonus);
#line 807 "nibbles-view.vala"
	bonus_actor = (BonusTexture*) _tmp1_;
#line 808 "nibbles-view.vala"
	_tmp2_ = self->priv->bonus_actors;
#line 808 "nibbles-view.vala"
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, bonus, NULL);
#line 809 "nibbles-view.vala"
	clutter_actor_hide ((ClutterActor*) bonus_actor);
#line 810 "nibbles-view.vala"
	_tmp3_ = self->priv->level;
#line 810 "nibbles-view.vala"
	clutter_actor_remove_child (_tmp3_, (ClutterActor*) bonus_actor);
#line 805 "nibbles-view.vala"
	_g_object_unref0 (bonus_actor);
#line 5949 "nibbles-view.c"
}

static void
nibbles_view_bonus_applied_cb (NibblesView* self,
                               Bonus* bonus,
                               Worm* worm)
{
	WormActor* actors = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ClutterActor* actor = NULL;
	WormActor* _tmp2_;
	ClutterActor* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	BonusType _tmp12_;
#line 813 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 813 "nibbles-view.vala"
	g_return_if_fail (bonus != NULL);
#line 813 "nibbles-view.vala"
	g_return_if_fail (worm != NULL);
#line 815 "nibbles-view.vala"
	_tmp0_ = self->priv->worm_actors;
#line 815 "nibbles-view.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, worm);
#line 815 "nibbles-view.vala"
	actors = (WormActor*) _tmp1_;
#line 816 "nibbles-view.vala"
	_tmp2_ = actors;
#line 816 "nibbles-view.vala"
	_tmp3_ = clutter_actor_get_last_child ((ClutterActor*) _tmp2_);
#line 816 "nibbles-view.vala"
	_tmp4_ = _tmp3_;
#line 816 "nibbles-view.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 816 "nibbles-view.vala"
	actor = _tmp5_;
#line 818 "nibbles-view.vala"
	_tmp6_ = actor;
#line 818 "nibbles-view.vala"
	clutter_actor_save_easing_state (_tmp6_);
#line 819 "nibbles-view.vala"
	_tmp7_ = actor;
#line 819 "nibbles-view.vala"
	clutter_actor_set_easing_mode (_tmp7_, CLUTTER_EASE_OUT_QUINT);
#line 820 "nibbles-view.vala"
	_tmp8_ = actor;
#line 820 "nibbles-view.vala"
	clutter_actor_set_easing_duration (_tmp8_, (guint) (NIBBLES_GAME_GAMEDELAY * 15));
#line 821 "nibbles-view.vala"
	_tmp9_ = actor;
#line 821 "nibbles-view.vala"
	clutter_actor_set_scale (_tmp9_, (gdouble) 1.45f, (gdouble) 1.45f);
#line 822 "nibbles-view.vala"
	_tmp10_ = actor;
#line 822 "nibbles-view.vala"
	clutter_actor_set_pivot_point (_tmp10_, 0.5f, 0.5f);
#line 823 "nibbles-view.vala"
	_tmp11_ = actor;
#line 823 "nibbles-view.vala"
	clutter_actor_restore_easing_state (_tmp11_);
#line 825 "nibbles-view.vala"
	_tmp12_ = bonus->type;
#line 825 "nibbles-view.vala"
	switch (_tmp12_) {
#line 825 "nibbles-view.vala"
		case BONUS_TYPE_REGULAR:
#line 6024 "nibbles-view.c"
		{
#line 828 "nibbles-view.vala"
			nibbles_view_play_sound (self, "gobble");
#line 829 "nibbles-view.vala"
			break;
#line 6030 "nibbles-view.c"
		}
#line 825 "nibbles-view.vala"
		case BONUS_TYPE_DOUBLE:
#line 6034 "nibbles-view.c"
		{
#line 831 "nibbles-view.vala"
			nibbles_view_play_sound (self, "bonus");
#line 832 "nibbles-view.vala"
			break;
#line 6040 "nibbles-view.c"
		}
#line 825 "nibbles-view.vala"
		case BONUS_TYPE_HALF:
#line 6044 "nibbles-view.c"
		{
#line 834 "nibbles-view.vala"
			nibbles_view_play_sound (self, "bonus");
#line 835 "nibbles-view.vala"
			break;
#line 6050 "nibbles-view.c"
		}
#line 825 "nibbles-view.vala"
		case BONUS_TYPE_LIFE:
#line 6054 "nibbles-view.c"
		{
#line 837 "nibbles-view.vala"
			nibbles_view_play_sound (self, "life");
#line 838 "nibbles-view.vala"
			break;
#line 6060 "nibbles-view.c"
		}
#line 825 "nibbles-view.vala"
		case BONUS_TYPE_REVERSE:
#line 6064 "nibbles-view.c"
		{
#line 840 "nibbles-view.vala"
			nibbles_view_play_sound (self, "reverse");
#line 841 "nibbles-view.vala"
			break;
#line 6070 "nibbles-view.c"
		}
		default:
		{
#line 843 "nibbles-view.vala"
			g_assert_not_reached ();
#line 6076 "nibbles-view.c"
		}
	}
#line 813 "nibbles-view.vala"
	_g_object_unref0 (actor);
#line 813 "nibbles-view.vala"
	_g_object_unref0 (actors);
#line 6083 "nibbles-view.c"
}

void
nibbles_view_boni_rescale (NibblesView* self,
                           gint tile_size)
{
#line 847 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 6092 "nibbles-view.c"
	{
		GeeLinkedList* _bonus_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		Boni* _tmp2_;
		Boni* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _bonus_index = 0;
#line 849 "nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 849 "nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 849 "nibbles-view.vala"
		_tmp2_ = nibbles_game_get_boni (_tmp1_);
#line 849 "nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 849 "nibbles-view.vala"
		_tmp4_ = _tmp3_->bonuses;
#line 849 "nibbles-view.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 849 "nibbles-view.vala"
		_bonus_list = _tmp5_;
#line 849 "nibbles-view.vala"
		_tmp6_ = _bonus_list;
#line 849 "nibbles-view.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
#line 849 "nibbles-view.vala"
		_tmp8_ = _tmp7_;
#line 849 "nibbles-view.vala"
		_bonus_size = _tmp8_;
#line 849 "nibbles-view.vala"
		_bonus_index = -1;
#line 849 "nibbles-view.vala"
		while (TRUE) {
#line 6132 "nibbles-view.c"
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp9_;
			gpointer _tmp10_;
			BonusTexture* actor = NULL;
			GeeHashMap* _tmp11_;
			Bonus* _tmp12_;
			gpointer _tmp13_;
			BonusTexture* _tmp14_;
#line 849 "nibbles-view.vala"
			_bonus_index = _bonus_index + 1;
#line 849 "nibbles-view.vala"
			if (!(_bonus_index < _bonus_size)) {
#line 849 "nibbles-view.vala"
				break;
#line 6147 "nibbles-view.c"
			}
#line 849 "nibbles-view.vala"
			_tmp9_ = _bonus_list;
#line 849 "nibbles-view.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _bonus_index);
#line 849 "nibbles-view.vala"
			bonus = (Bonus*) _tmp10_;
#line 851 "nibbles-view.vala"
			_tmp11_ = self->priv->bonus_actors;
#line 851 "nibbles-view.vala"
			_tmp12_ = bonus;
#line 851 "nibbles-view.vala"
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
#line 851 "nibbles-view.vala"
			actor = (BonusTexture*) _tmp13_;
#line 852 "nibbles-view.vala"
			_tmp14_ = actor;
#line 852 "nibbles-view.vala"
			bonus_texture_set_size (_tmp14_, (gfloat) tile_size, (gfloat) tile_size);
#line 849 "nibbles-view.vala"
			_g_object_unref0 (actor);
#line 849 "nibbles-view.vala"
			_g_object_unref0 (bonus);
#line 6171 "nibbles-view.c"
		}
#line 849 "nibbles-view.vala"
		_g_object_unref0 (_bonus_list);
#line 6175 "nibbles-view.c"
	}
}

static void
nibbles_view_warp_added_cb (NibblesView* self,
                            Warp* warp)
{
	WarpTexture* actor = NULL;
	WarpTexture* _tmp0_;
	NibblesGame* _tmp4_;
	NibblesGame* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NibblesGame* _tmp8_;
	NibblesGame* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	NibblesGame* _tmp12_;
	NibblesGame* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	NibblesGame* _tmp16_;
	NibblesGame* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	ClutterActor* _tmp20_;
	GeeHashMap* _tmp21_;
	GError* _inner_error0_ = NULL;
#line 860 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 860 "nibbles-view.vala"
	g_return_if_fail (warp != NULL);
#line 862 "nibbles-view.vala"
	_tmp0_ = warp_texture_new ();
#line 862 "nibbles-view.vala"
	g_object_ref_sink (_tmp0_);
#line 862 "nibbles-view.vala"
	actor = _tmp0_;
#line 6214 "nibbles-view.c"
	{
		GdkPixbuf* _tmp1_;
#line 865 "nibbles-view.vala"
		_tmp1_ = self->priv->boni_pixmaps[BONUS_TYPE_WARP];
#line 865 "nibbles-view.vala"
		gtk_clutter_texture_set_from_pixbuf ((GtkClutterTexture*) actor, _tmp1_, &_inner_error0_);
#line 865 "nibbles-view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 865 "nibbles-view.vala"
			if (_inner_error0_->domain == CLUTTER_TEXTURE_ERROR) {
#line 6225 "nibbles-view.c"
				goto __catch8_clutter_texture_error;
			}
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_clutter_texture_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
#line 863 "nibbles-view.vala"
		e = _inner_error0_;
#line 863 "nibbles-view.vala"
		_inner_error0_ = NULL;
#line 869 "nibbles-view.vala"
		_tmp2_ = e->message;
#line 869 "nibbles-view.vala"
		g_error ("nibbles-view.vala:869: Nibbles failed to set texture: %s", _tmp2_);
#line 863 "nibbles-view.vala"
		_g_error_free0 (e);
#line 6246 "nibbles-view.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
#line 863 "nibbles-view.vala"
		e = _inner_error0_;
#line 863 "nibbles-view.vala"
		_inner_error0_ = NULL;
#line 873 "nibbles-view.vala"
		_tmp3_ = e->message;
#line 873 "nibbles-view.vala"
		g_error ("nibbles-view.vala:873: Nibbles failed to set texture: %s", _tmp3_);
#line 863 "nibbles-view.vala"
		_g_error_free0 (e);
#line 6263 "nibbles-view.c"
	}
	__finally8:
#line 863 "nibbles-view.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 863 "nibbles-view.vala"
		_g_object_unref0 (actor);
#line 863 "nibbles-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 863 "nibbles-view.vala"
		g_clear_error (&_inner_error0_);
#line 863 "nibbles-view.vala"
		return;
#line 6276 "nibbles-view.c"
	}
#line 876 "nibbles-view.vala"
	_tmp4_ = nibbles_view_get_game (self);
#line 876 "nibbles-view.vala"
	_tmp5_ = _tmp4_;
#line 876 "nibbles-view.vala"
	_tmp6_ = nibbles_game_get_tile_size (_tmp5_);
#line 876 "nibbles-view.vala"
	_tmp7_ = _tmp6_;
#line 876 "nibbles-view.vala"
	_tmp8_ = nibbles_view_get_game (self);
#line 876 "nibbles-view.vala"
	_tmp9_ = _tmp8_;
#line 876 "nibbles-view.vala"
	_tmp10_ = nibbles_game_get_tile_size (_tmp9_);
#line 876 "nibbles-view.vala"
	_tmp11_ = _tmp10_;
#line 876 "nibbles-view.vala"
	warp_texture_set_size (actor, (gfloat) _tmp7_, (gfloat) _tmp11_);
#line 877 "nibbles-view.vala"
	_tmp12_ = nibbles_view_get_game (self);
#line 877 "nibbles-view.vala"
	_tmp13_ = _tmp12_;
#line 877 "nibbles-view.vala"
	_tmp14_ = nibbles_game_get_tile_size (_tmp13_);
#line 877 "nibbles-view.vala"
	_tmp15_ = _tmp14_;
#line 877 "nibbles-view.vala"
	_tmp16_ = nibbles_view_get_game (self);
#line 877 "nibbles-view.vala"
	_tmp17_ = _tmp16_;
#line 877 "nibbles-view.vala"
	_tmp18_ = nibbles_game_get_tile_size (_tmp17_);
#line 877 "nibbles-view.vala"
	_tmp19_ = _tmp18_;
#line 877 "nibbles-view.vala"
	clutter_actor_set_position ((ClutterActor*) actor, (gfloat) (warp->x * _tmp15_), (gfloat) (warp->y * _tmp19_));
#line 879 "nibbles-view.vala"
	_tmp20_ = self->priv->level;
#line 879 "nibbles-view.vala"
	clutter_actor_add_child (_tmp20_, (ClutterActor*) actor);
#line 881 "nibbles-view.vala"
	_tmp21_ = self->priv->warp_actors;
#line 881 "nibbles-view.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, warp, actor);
#line 860 "nibbles-view.vala"
	_g_object_unref0 (actor);
#line 6324 "nibbles-view.c"
}

void
nibbles_view_warps_rescale (NibblesView* self,
                            gint tile_size)
{
#line 884 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 6333 "nibbles-view.c"
	{
		GeeLinkedList* _warp_list = NULL;
		NibblesGame* _tmp0_;
		NibblesGame* _tmp1_;
		WarpManager* _tmp2_;
		WarpManager* _tmp3_;
		GeeLinkedList* _tmp4_;
		GeeLinkedList* _tmp5_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _warp_index = 0;
#line 886 "nibbles-view.vala"
		_tmp0_ = nibbles_view_get_game (self);
#line 886 "nibbles-view.vala"
		_tmp1_ = _tmp0_;
#line 886 "nibbles-view.vala"
		_tmp2_ = nibbles_game_get_warp_manager (_tmp1_);
#line 886 "nibbles-view.vala"
		_tmp3_ = _tmp2_;
#line 886 "nibbles-view.vala"
		_tmp4_ = _tmp3_->warps;
#line 886 "nibbles-view.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 886 "nibbles-view.vala"
		_warp_list = _tmp5_;
#line 886 "nibbles-view.vala"
		_tmp6_ = _warp_list;
#line 886 "nibbles-view.vala"
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
#line 886 "nibbles-view.vala"
		_tmp8_ = _tmp7_;
#line 886 "nibbles-view.vala"
		_warp_size = _tmp8_;
#line 886 "nibbles-view.vala"
		_warp_index = -1;
#line 886 "nibbles-view.vala"
		while (TRUE) {
#line 6373 "nibbles-view.c"
			Warp* warp = NULL;
			GeeLinkedList* _tmp9_;
			gpointer _tmp10_;
			WarpTexture* actor = NULL;
			GeeHashMap* _tmp11_;
			Warp* _tmp12_;
			gpointer _tmp13_;
			WarpTexture* _tmp14_;
#line 886 "nibbles-view.vala"
			_warp_index = _warp_index + 1;
#line 886 "nibbles-view.vala"
			if (!(_warp_index < _warp_size)) {
#line 886 "nibbles-view.vala"
				break;
#line 6388 "nibbles-view.c"
			}
#line 886 "nibbles-view.vala"
			_tmp9_ = _warp_list;
#line 886 "nibbles-view.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _warp_index);
#line 886 "nibbles-view.vala"
			warp = (Warp*) _tmp10_;
#line 888 "nibbles-view.vala"
			_tmp11_ = self->priv->warp_actors;
#line 888 "nibbles-view.vala"
			_tmp12_ = warp;
#line 888 "nibbles-view.vala"
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
#line 888 "nibbles-view.vala"
			actor = (WarpTexture*) _tmp13_;
#line 889 "nibbles-view.vala"
			_tmp14_ = actor;
#line 889 "nibbles-view.vala"
			warp_texture_set_size (_tmp14_, (gfloat) tile_size, (gfloat) tile_size);
#line 886 "nibbles-view.vala"
			_g_object_unref0 (actor);
#line 886 "nibbles-view.vala"
			_g_object_unref0 (warp);
#line 6412 "nibbles-view.c"
		}
#line 886 "nibbles-view.vala"
		_g_object_unref0 (_warp_list);
#line 6416 "nibbles-view.c"
	}
}

static void
nibbles_view_play_sound (NibblesView* self,
                         const gchar* name)
{
	gchar* filename = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
#line 897 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 897 "nibbles-view.vala"
	g_return_if_fail (name != NULL);
#line 899 "nibbles-view.vala"
	if (self->is_muted) {
#line 900 "nibbles-view.vala"
		return;
#line 6439 "nibbles-view.c"
	}
#line 902 "nibbles-view.vala"
	_tmp0_ = string_to_string (name);
#line 902 "nibbles-view.vala"
	_tmp1_ = g_strconcat (_tmp0_, ".ogg", NULL);
#line 902 "nibbles-view.vala"
	filename = _tmp1_;
#line 903 "nibbles-view.vala"
	_tmp2_ = filename;
#line 903 "nibbles-view.vala"
	_tmp3_ = g_build_filename (SOUND_DIRECTORY, _tmp2_, NULL, NULL);
#line 903 "nibbles-view.vala"
	path = _tmp3_;
#line 905 "nibbles-view.vala"
	_tmp4_ = path;
#line 905 "nibbles-view.vala"
	ca_gtk_play_for_widget ((GtkWidget*) self, (guint32) 0, CA_PROP_MEDIA_NAME, name, CA_PROP_MEDIA_FILENAME, _tmp4_, NULL);
#line 897 "nibbles-view.vala"
	_g_free0 (path);
#line 897 "nibbles-view.vala"
	_g_free0 (filename);
#line 6461 "nibbles-view.c"
}

gchar*
nibbles_view_colorval_name (gint colorval)
{
	gchar* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 912 "nibbles-view.vala"
	_tmp0_ = nibbles_view_color_lookup;
#line 912 "nibbles-view.vala"
	_tmp0__length1 = nibbles_view_color_lookup_length1;
#line 912 "nibbles-view.vala"
	_tmp1_ = _tmp0_[colorval];
#line 912 "nibbles-view.vala"
	_tmp2_ = g_strdup (_ (_tmp1_));
#line 912 "nibbles-view.vala"
	result = _tmp2_;
#line 912 "nibbles-view.vala"
	return result;
#line 6484 "nibbles-view.c"
}

ClutterActor*
nibbles_view_get_name_labels (NibblesView* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
#line 124 "nibbles-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "nibbles-view.vala"
	_tmp0_ = self->priv->_name_labels;
#line 124 "nibbles-view.vala"
	result = _tmp0_;
#line 124 "nibbles-view.vala"
	return result;
#line 6500 "nibbles-view.c"
}

static void
nibbles_view_set_name_labels (NibblesView* self,
                              ClutterActor* value)
{
#line 124 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 124 "nibbles-view.vala"
	if (nibbles_view_get_name_labels (self) != value) {
#line 6511 "nibbles-view.c"
		ClutterActor* _tmp0_;
#line 124 "nibbles-view.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 124 "nibbles-view.vala"
		_g_object_unref0 (self->priv->_name_labels);
#line 124 "nibbles-view.vala"
		self->priv->_name_labels = _tmp0_;
#line 124 "nibbles-view.vala"
		g_object_notify_by_pspec ((GObject *) self, nibbles_view_properties[NIBBLES_VIEW_NAME_LABELS_PROPERTY]);
#line 6521 "nibbles-view.c"
	}
}

NibblesGame*
nibbles_view_get_game (NibblesView* self)
{
	NibblesGame* result;
	NibblesGame* _tmp0_;
#line 134 "nibbles-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 134 "nibbles-view.vala"
	_tmp0_ = self->priv->_game;
#line 134 "nibbles-view.vala"
	result = _tmp0_;
#line 134 "nibbles-view.vala"
	return result;
#line 6538 "nibbles-view.c"
}

static void
_nibbles_view_bonus_added_cb_boni_bonus_added (Boni* _sender,
                                               gpointer self)
{
#line 141 "nibbles-view.vala"
	nibbles_view_bonus_added_cb ((NibblesView*) self);
#line 6547 "nibbles-view.c"
}

static void
_nibbles_view_bonus_removed_cb_boni_bonus_removed (Boni* _sender,
                                                   Bonus* bonus,
                                                   gpointer self)
{
#line 142 "nibbles-view.vala"
	nibbles_view_bonus_removed_cb ((NibblesView*) self, bonus);
#line 6557 "nibbles-view.c"
}

static void
_nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied (NibblesGame* _sender,
                                                           Bonus* bonus,
                                                           Worm* worm,
                                                           gpointer self)
{
#line 144 "nibbles-view.vala"
	nibbles_view_bonus_applied_cb ((NibblesView*) self, bonus, worm);
#line 6568 "nibbles-view.c"
}

static void
_nibbles_view_warp_added_cb_warp_manager_warp_added (WarpManager* _sender,
                                                     Warp* warp,
                                                     gpointer self)
{
#line 146 "nibbles-view.vala"
	nibbles_view_warp_added_cb ((NibblesView*) self, warp);
#line 6578 "nibbles-view.c"
}

static void
_nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game (NibblesGame* _sender,
                                                                 gpointer self)
{
#line 148 "nibbles-view.vala"
	nibbles_view_animate_end_game_cb ((NibblesView*) self);
#line 6587 "nibbles-view.c"
}

void
nibbles_view_set_game (NibblesView* self,
                       NibblesGame* value)
{
	NibblesGame* _tmp0_;
	NibblesGame* _tmp2_;
	NibblesGame* _tmp3_;
	Boni* _tmp4_;
	Boni* _tmp5_;
	NibblesGame* _tmp6_;
	Boni* _tmp7_;
	Boni* _tmp8_;
	NibblesGame* _tmp9_;
	NibblesGame* _tmp10_;
	WarpManager* _tmp11_;
	WarpManager* _tmp12_;
	NibblesGame* _tmp13_;
#line 135 "nibbles-view.vala"
	g_return_if_fail (self != NULL);
#line 137 "nibbles-view.vala"
	_tmp0_ = self->priv->_game;
#line 137 "nibbles-view.vala"
	if (_tmp0_ != NULL) {
#line 6613 "nibbles-view.c"
		NibblesGame* _tmp1_;
#line 138 "nibbles-view.vala"
		_tmp1_ = self->priv->_game;
#line 138 "nibbles-view.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 6619 "nibbles-view.c"
	}
#line 140 "nibbles-view.vala"
	_tmp2_ = _g_object_ref0 (value);
#line 140 "nibbles-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 140 "nibbles-view.vala"
	self->priv->_game = _tmp2_;
#line 141 "nibbles-view.vala"
	_tmp3_ = self->priv->_game;
#line 141 "nibbles-view.vala"
	_tmp4_ = nibbles_game_get_boni (_tmp3_);
#line 141 "nibbles-view.vala"
	_tmp5_ = _tmp4_;
#line 141 "nibbles-view.vala"
	g_signal_connect_object (_tmp5_, "bonus-added", (GCallback) _nibbles_view_bonus_added_cb_boni_bonus_added, self, 0);
#line 142 "nibbles-view.vala"
	_tmp6_ = self->priv->_game;
#line 142 "nibbles-view.vala"
	_tmp7_ = nibbles_game_get_boni (_tmp6_);
#line 142 "nibbles-view.vala"
	_tmp8_ = _tmp7_;
#line 142 "nibbles-view.vala"
	g_signal_connect_object (_tmp8_, "bonus-removed", (GCallback) _nibbles_view_bonus_removed_cb_boni_bonus_removed, self, 0);
#line 144 "nibbles-view.vala"
	_tmp9_ = self->priv->_game;
#line 144 "nibbles-view.vala"
	g_signal_connect_object (_tmp9_, "bonus-applied", (GCallback) _nibbles_view_bonus_applied_cb_nibbles_game_bonus_applied, self, 0);
#line 146 "nibbles-view.vala"
	_tmp10_ = self->priv->_game;
#line 146 "nibbles-view.vala"
	_tmp11_ = nibbles_game_get_warp_manager (_tmp10_);
#line 146 "nibbles-view.vala"
	_tmp12_ = _tmp11_;
#line 146 "nibbles-view.vala"
	g_signal_connect_object (_tmp12_, "warp-added", (GCallback) _nibbles_view_warp_added_cb_warp_manager_warp_added, self, 0);
#line 148 "nibbles-view.vala"
	_tmp13_ = self->priv->_game;
#line 148 "nibbles-view.vala"
	g_signal_connect_object (_tmp13_, "animate-end-game", (GCallback) _nibbles_view_animate_end_game_cb_nibbles_game_animate_end_game, self, 0);
#line 135 "nibbles-view.vala"
	g_object_notify_by_pspec ((GObject *) self, nibbles_view_properties[NIBBLES_VIEW_GAME_PROPERTY]);
#line 6661 "nibbles-view.c"
}

static void
nibbles_view_class_init (NibblesViewClass * klass,
                         gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
#line 111 "nibbles-view.vala"
	nibbles_view_parent_class = g_type_class_peek_parent (klass);
#line 111 "nibbles-view.vala"
	g_type_class_adjust_private_offset (klass, &NibblesView_private_offset);
#line 111 "nibbles-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_view_get_property;
#line 111 "nibbles-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_view_set_property;
#line 111 "nibbles-view.vala"
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_finalize;
#line 111 "nibbles-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_NAME_LABELS_PROPERTY, nibbles_view_properties[NIBBLES_VIEW_NAME_LABELS_PROPERTY] = g_param_spec_object ("name-labels", "name-labels", "name-labels", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 111 "nibbles-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_VIEW_GAME_PROPERTY, nibbles_view_properties[NIBBLES_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_NIBBLES_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 154 "nibbles-view.vala"
	_tmp0_ = g_strdup (N_ ("red"));
#line 154 "nibbles-view.vala"
	_tmp1_ = g_strdup (N_ ("green"));
#line 154 "nibbles-view.vala"
	_tmp2_ = g_strdup (N_ ("blue"));
#line 154 "nibbles-view.vala"
	_tmp3_ = g_strdup (N_ ("yellow"));
#line 154 "nibbles-view.vala"
	_tmp4_ = g_strdup (N_ ("cyan"));
#line 154 "nibbles-view.vala"
	_tmp5_ = g_strdup (N_ ("purple"));
#line 154 "nibbles-view.vala"
	_tmp6_ = g_new0 (gchar*, 6 + 1);
#line 154 "nibbles-view.vala"
	_tmp6_[0] = _tmp0_;
#line 154 "nibbles-view.vala"
	_tmp6_[1] = _tmp1_;
#line 154 "nibbles-view.vala"
	_tmp6_[2] = _tmp2_;
#line 154 "nibbles-view.vala"
	_tmp6_[3] = _tmp3_;
#line 154 "nibbles-view.vala"
	_tmp6_[4] = _tmp4_;
#line 154 "nibbles-view.vala"
	_tmp6_[5] = _tmp5_;
#line 154 "nibbles-view.vala"
	nibbles_view_color_lookup = _tmp6_;
#line 154 "nibbles-view.vala"
	nibbles_view_color_lookup_length1 = 6;
#line 6719 "nibbles-view.c"
}

static void
nibbles_view_instance_init (NibblesView * self,
                            gpointer klass)
{
#line 111 "nibbles-view.vala"
	self->priv = nibbles_view_get_instance_private (self);
#line 6728 "nibbles-view.c"
}

static void
nibbles_view_finalize (GObject * obj)
{
	NibblesView * self;
#line 111 "nibbles-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_VIEW, NibblesView);
#line 117 "nibbles-view.vala"
	_vala_array_destroy (self->priv->wall_pixmaps, 11, (GDestroyNotify) g_object_unref);
#line 118 "nibbles-view.vala"
	_vala_array_destroy (self->priv->worm_pixmaps, 6, (GDestroyNotify) g_object_unref);
#line 119 "nibbles-view.vala"
	_vala_array_destroy (self->priv->boni_pixmaps, 9, (GDestroyNotify) g_object_unref);
#line 122 "nibbles-view.vala"
	_g_object_unref0 (self->priv->stage);
#line 123 "nibbles-view.vala"
	_g_object_unref0 (self->priv->level);
#line 124 "nibbles-view.vala"
	_g_object_unref0 (self->priv->_name_labels);
#line 126 "nibbles-view.vala"
	_g_object_unref0 (self->priv->worm_actors);
#line 127 "nibbles-view.vala"
	_g_object_unref0 (self->priv->bonus_actors);
#line 128 "nibbles-view.vala"
	_g_object_unref0 (self->priv->warp_actors);
#line 131 "nibbles-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 111 "nibbles-view.vala"
	G_OBJECT_CLASS (nibbles_view_parent_class)->finalize (obj);
#line 6759 "nibbles-view.c"
}

GType
nibbles_view_get_type (void)
{
	static volatile gsize nibbles_view_type_id__volatile = 0;
	if (g_once_init_enter (&nibbles_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NibblesViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesView), 0, (GInstanceInitFunc) nibbles_view_instance_init, NULL };
		GType nibbles_view_type_id;
		nibbles_view_type_id = g_type_register_static (gtk_clutter_embed_get_type (), "NibblesView", &g_define_type_info, 0);
		NibblesView_private_offset = g_type_add_instance_private (nibbles_view_type_id, sizeof (NibblesViewPrivate));
		g_once_init_leave (&nibbles_view_type_id__volatile, nibbles_view_type_id);
	}
	return nibbles_view_type_id__volatile;
}

static void
_vala_nibbles_view_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
#line 111 "nibbles-view.vala"
	switch (property_id) {
#line 111 "nibbles-view.vala"
		case NIBBLES_VIEW_NAME_LABELS_PROPERTY:
#line 111 "nibbles-view.vala"
		g_value_set_object (value, nibbles_view_get_name_labels (self));
#line 111 "nibbles-view.vala"
		break;
#line 111 "nibbles-view.vala"
		case NIBBLES_VIEW_GAME_PROPERTY:
#line 111 "nibbles-view.vala"
		g_value_set_object (value, nibbles_view_get_game (self));
#line 111 "nibbles-view.vala"
		break;
#line 6798 "nibbles-view.c"
		default:
#line 111 "nibbles-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 111 "nibbles-view.vala"
		break;
#line 6804 "nibbles-view.c"
	}
}

static void
_vala_nibbles_view_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_VIEW, NibblesView);
#line 111 "nibbles-view.vala"
	switch (property_id) {
#line 111 "nibbles-view.vala"
		case NIBBLES_VIEW_NAME_LABELS_PROPERTY:
#line 111 "nibbles-view.vala"
		nibbles_view_set_name_labels (self, g_value_get_object (value));
#line 111 "nibbles-view.vala"
		break;
#line 111 "nibbles-view.vala"
		case NIBBLES_VIEW_GAME_PROPERTY:
#line 111 "nibbles-view.vala"
		nibbles_view_set_game (self, g_value_get_object (value));
#line 111 "nibbles-view.vala"
		break;
#line 6830 "nibbles-view.c"
		default:
#line 111 "nibbles-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 111 "nibbles-view.vala"
		break;
#line 6836 "nibbles-view.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

