#include "obgtkContainer.h"

@implementation Gtk_Container

- castGtkContainer:(GtkContainer *) castitem
{
  self = [super castGtkWidget:GTK_WIDGET(castitem)];
  gtkcontainer = castitem;
  return self;
}

- set_border_width:(gint) width
{
  gtk_container_set_border_width(gtkcontainer, width);
  return self;
}

- add:(Gtk_Widget *) widget
{
  gtk_container_add(gtkcontainer, widget->gtkwidget);
  return self;
}

- remove:(Gtk_Widget *) widget
{
  gtk_container_remove(gtkcontainer, widget->gtkwidget);
  return self;
}

- block_resize
{
  gtk_container_block_resize(gtkcontainer);
  return self;
}

- unblock_resize
{
  gtk_container_unblock_resize(gtkcontainer);
  return self;
}

- (gint)need_resize
{
  return gtk_container_need_resize(gtkcontainer);
}

- foreach:
 callback:(GtkCallback) acallback
callbackData:(gpointer) callback_data
{
  gtk_container_foreach(gtkcontainer, acallback, callback_data);
  return self;
}

- foreach_method:(SEL) method
{
  gtk_container_foreach(gtkcontainer, (GtkCallback)obgtk_callback_relay, (gpointer)method);
  return self;
}

- focus:(GtkDirectionType) direction
{
  gtk_container_focus(gtkcontainer, direction);
  return self;
}

- (GList *) children
{
  return gtk_container_children(gtkcontainer);
}

- register_toplevel
{
  gtk_container_register_toplevel(gtkcontainer);
  return self;
}

- unregister_toplevel
{
  gtk_container_unregister_toplevel(gtkcontainer);
  return self;
}
@end
