/* gnome-pilot-conduit.c
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include "gnome-pilot-conduit.h"


static void gnome_pilot_conduit_init		(GnomePilotConduit *pilot_conduit);
static void gnome_pilot_conduit_class_init	(GnomePilotConduitClass	*klass);
static void gnome_pilot_conduit_finalize	(GtkObject *object);


static GtkObjectClass *parent_class = NULL;


GtkType
gnome_pilot_conduit_get_type (void)
{
	static GtkType pilot_conduit_type = 0;

	if (!pilot_conduit_type)
	{
		static const GtkTypeInfo pilot_conduit_info =
		{
			"GnomePilotConduit",
			sizeof (GnomePilotConduit),
			sizeof (GnomePilotConduitClass),
			(GtkClassInitFunc) gnome_pilot_conduit_class_init,
			(GtkObjectInitFunc) gnome_pilot_conduit_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		pilot_conduit_type = gtk_type_unique (gtk_object_get_type (), &pilot_conduit_info);
	}

	return pilot_conduit_type;
}

static void
gnome_pilot_conduit_class_init (GnomePilotConduitClass *klass)
{
	GtkObjectClass *object_class;

	object_class = (GtkObjectClass*) klass;

	parent_class = gtk_type_class (gtk_object_get_type ());

	object_class->finalize = gnome_pilot_conduit_finalize;
}

static void
gnome_pilot_conduit_init (GnomePilotConduit *pilot_conduit)
{
	g_return_if_fail (pilot_conduit != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT (pilot_conduit));

	pilot_conduit->name = NULL;
}

static void
gnome_pilot_conduit_finalize (GtkObject *object)
{
	GnomePilotConduit *conduit;

	g_return_if_fail (object != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT (object));

	conduit = GNOME_PILOT_CONDUIT (object);

	g_free (conduit->name);

	GTK_OBJECT_CLASS (parent_class)->finalize (object);
}

/* Public Functions */
void
gnome_pilot_conduit_construct (GnomePilotConduit *pilot_conduit,
			       const gchar *name)
{
	g_return_if_fail (pilot_conduit != NULL);
	g_return_if_fail (GNOME_IS_PILOT_CONDUIT (pilot_conduit));

	pilot_conduit->name = g_strdup (name);
}

const gchar *
gnome_pilot_conduit_get_name (GnomePilotConduit *pilot_conduit)
{
	g_return_val_if_fail (pilot_conduit != NULL, NULL);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT (pilot_conduit), NULL);

	return (const gchar *) pilot_conduit->name;
}

gint
gnome_pilot_conduit_sync_type_str_to_int(const gchar *s) 
{
	g_return_val_if_fail(s!=NULL,GnomePilotConduitSyncTypeNotSet);

	if (strcmp (s, "synchronize") == 0) {
		return GnomePilotConduitSyncTypeSynchronize;
	} else if (strcmp (s, "copy_to_pilot") == 0) {
		return GnomePilotConduitSyncTypeCopyToPilot;
	} else if (strcmp (s, "copy_from_pilot") == 0) {
		return GnomePilotConduitSyncTypeCopyFromPilot;
	} else if (strcmp (s, "merge_to_pilot") == 0) {
		return GnomePilotConduitSyncTypeMergeToPilot;
	} else if (strcmp (s, "merge_from_pilot") == 0) {
		return GnomePilotConduitSyncTypeMergeFromPilot;
	} else if (strcmp (s, "custom") == 0) {
		return GnomePilotConduitSyncTypeCustom;
	} else if (strcmp (s, "not_set") == 0) {
		return GnomePilotConduitSyncTypeNotSet;
	}
	return GnomePilotConduitSyncTypeNotSet;
}

const gchar* 
gnome_pilot_conduit_sync_type_int_to_str(GnomePilotConduitSyncType e) 
{
	switch(e) {
	case GnomePilotConduitSyncTypeCustom:         return "custom";
	case GnomePilotConduitSyncTypeSynchronize:    return "synchronize";
	case GnomePilotConduitSyncTypeCopyFromPilot:  return "copy_from_pilot";
	case GnomePilotConduitSyncTypeCopyToPilot:    return "copy_to_pilot";
	case GnomePilotConduitSyncTypeMergeFromPilot: return "merge_from_pilot";
	case GnomePilotConduitSyncTypeMergeToPilot:   return "merge_to_pilot";
	case GnomePilotConduitSyncTypeNotSet:         return "not_set";
	default: 
	  g_message("gnome_pilot_conduit_sync_type_int_to_str: invalid sync_type");
	  return "not_set";
	}
}
