/* $Id: backup_conduit.c,v 1.20 2000/01/06 03:06:05 eskil Exp $ */

#include <glib.h>
#include <gnome.h>

#include <pi-source.h>
#include <pi-socket.h>
#include <pi-file.h>
#include <pi-dlp.h>
#include <pi-version.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <utime.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>

#include <gpilotd/gnome-pilot-conduit-backup.h>
#include "backup_conduit.h"

/* Helper functions */
static void
protect_name(char *d, char *s) {
	while(*s) {
		switch(*s) {
		case '/': *(d++) = '='; *(d++) = '2'; *(d++) = 'F'; break;
		case '=': *(d++) = '='; *(d++) = '3'; *(d++) = 'D'; break;
		case '\x0A': *(d++) = '='; *(d++) = '0'; *(d++) = 'A'; break;
		case '\x0D': *(d++) = '='; *(d++) = '0'; *(d++) = 'D'; break;
#if 0
		case ' ': *(d++) = '='; *(d++) = '2'; *(d++) = '0'; break;
#endif
		default: *(d++) = *s;
		}
		++s;
	}
	*d = '\0';
}
static void
prepare_backup_conduit (GnomePilotConduitBackup *conduit,
			guint32 pilotId)
{
	gchar prefix[45];
	gchar *backup_dir;
	gboolean updated_only;
	gboolean remove_deleted;

	g_snprintf(prefix,44,"/gnome-pilot.d/backup-conduit/Pilot_%u/",pilotId);

	gnome_config_push_prefix(prefix);
	backup_dir = gnome_config_get_string("backup_dir");
	updated_only = gnome_config_get_bool("updated_only=TRUE");
	remove_deleted = gnome_config_get_bool("remove_deleted=FALSE");
	gnome_config_pop_prefix();


	if (backup_dir==NULL) {
		char file_name[80];
		g_snprintf (file_name, 79, "%s/pilot/", g_get_home_dir());
		backup_dir = g_strdup(file_name);
	}
	/* let's make sure that this directory exists */
	if (mkdir (backup_dir, (mode_t)0755 ) < 0) { /* Wow, I never though I would use octal in C :)*/
		if(errno != EEXIST) {
			g_warning (_("Unable to create directory:\n\t%s\n"), backup_dir);
			gnome_pilot_conduit_error (GNOME_PILOT_CONDUIT(conduit),
						   _("Unable to create directory:\n\t%s\n"), 
						   backup_dir);
		}
	}
}

/* Signals */
static gint
gnome_real_pilot_conduit_backup_backup_prc (GnomePilotConduitBackup *conduit,
					    GnomePilotDBInfo *dbinfo, 
					    ConduitCfg *cfg)
{
	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (dbinfo != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (conduit), -1);
	return 0;
}
static gint
gnome_real_pilot_conduit_backup_backup_db (GnomePilotConduitBackup *conduit,
					   GnomePilotDBInfo *dbinfo, 
					   ConduitCfg *cfg)
{
	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (dbinfo != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (conduit), -1);
	return 0;
}

static gint
gnome_real_pilot_conduit_backup_backup (GnomePilotConduitBackup *conduit,
					GnomePilotDBInfo *dbinfo, 
					ConduitCfg *cfg)
{
	char name[256];      /* FIXME: potentiel overun  -  (UGH, this sux -jrb) */
	struct pi_file *f;
	struct stat statb;
	struct utimbuf times;
	GList *iterator;

	g_return_val_if_fail (conduit != NULL, -1);
	g_return_val_if_fail (dbinfo != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (conduit), -1);
	
	/* let's see first if we should actually touch this db */
	if( cfg->exclude_files != NULL ) {
	  iterator = cfg->exclude_files;
	  while( iterator != NULL ) {
	    if( ! g_strcasecmp(iterator->data, PI_DBINFO (dbinfo)->name) ) {
	      return 0;
	    }
	    iterator = iterator->next;
	  }
	}

	if (cfg->backup_dir == NULL) {
		g_warning("backup conduit has no backupdir");
		gnome_pilot_conduit_error(GNOME_PILOT_CONDUIT(conduit),
					  "No backup directory specified");
		return -1;
	} 

	strcpy (name, cfg->backup_dir);
	strcat (name,"/");
	protect_name (name + strlen (name), PI_DBINFO (dbinfo)->name);

	if (PI_DBINFO (dbinfo)->flags & dlpDBFlagResource)
		strcat (name,".prc");
	else
		strcat (name,".pdb");

	if (cfg->remove_deleted) {
		GList *link;

		link = g_list_find_custom (cfg->files_in_backup,
					   name,
					   (GCompareFunc) g_strcasecmp);
		cfg->files_in_backup =
			g_list_remove_link (cfg->files_in_backup,
					    link);
	}
	if (cfg->updated_only) {
		if (stat (name, &statb) == 0) {
			if (PI_DBINFO (dbinfo)->modifyDate == statb.st_mtime) {
				return 0;
			}
		}
	}

	PI_DBINFO (dbinfo)->flags &= 0xff;

	g_message(_("Making backup of %s"),PI_DBINFO (dbinfo)->name);
	gnome_pilot_conduit_message(GNOME_PILOT_CONDUIT(conduit),
				    _("Making backup of %s"),PI_DBINFO (dbinfo)->name);

	f = pi_file_create (name, PI_DBINFO (dbinfo));
	if(f==0) {
		g_warning(_("Could not create backup file %s"),name);
		gnome_pilot_conduit_error (GNOME_PILOT_CONDUIT(conduit),
					   _("Could not create backup file %s"),name);
		return -1;
	}

	if(pi_file_retrieve (f, dbinfo->pilot_socket, 0) != 0) {
		/* failed!? */
		pi_file_close (f);
		g_warning(_("Backup of %s failed!"),PI_DBINFO (dbinfo)->name);
		gnome_pilot_conduit_error (GNOME_PILOT_CONDUIT(conduit),
					   _("Backup of %s failed!"),
					   PI_DBINFO (dbinfo)->name);
		return -1;
	} else {
		/* ok */
		pi_file_close (f);
		times.actime = PI_DBINFO (dbinfo)->createDate;
		times.modtime = PI_DBINFO (dbinfo)->modifyDate;
		utime (name, &times);
		return 0;
	}
}
GnomePilotConduit *
conduit_get_gpilot_conduit (guint32 pilotId)
{
	ConduitCfg *cfg;
	GtkObject *retval;

	retval = gnome_pilot_conduit_backup_new ();
	g_assert (retval != NULL);
	load_configuration(&cfg,pilotId);

	gtk_object_set_data(retval,"configuration",cfg);

	gtk_signal_connect (retval, "backup", (GtkSignalFunc) gnome_real_pilot_conduit_backup_backup, cfg);
	gtk_signal_connect (retval, "backup_prc", (GtkSignalFunc) gnome_real_pilot_conduit_backup_backup_prc, cfg);
	gtk_signal_connect (retval, "backup_db", (GtkSignalFunc) gnome_real_pilot_conduit_backup_backup_db, cfg);

	return GNOME_PILOT_CONDUIT (retval);
}
void
conduit_destroy_gpilot_conduit (GnomePilotConduit *conduit)
{
	ConduitCfg *cfg;
	cfg = GET_CFG(conduit);
	destroy_configuration(&cfg);
	gtk_object_destroy (GTK_OBJECT (conduit));
}

