/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gnome-pilot-conduitcap.h
 *
 * Copyright (C) 1998 Red Hat Software       
 * Copyright (C) 1999-2000 Free Software Foundation
 * Copyright (C) 2001  Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Eskil Heyn Olsen
 *          Vadim Strizhevsky
 *          Michael Fulbright <msf@redhat.com>
 *          JP Rosevear <jpr@ximian.com>
 *
 */

#ifndef _GNOME_PILOT_CONDUITCAP_H_
#define _GNOME_PILOT_CONDUITCAP_H_

#include <gnome.h>
#include <gpilotd/gnome-pilot-client.h>
#include <capplet-widget.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GNOME_PILOT_TYPE_CONDUITCAP			(gnome_pilot_conduitcap_get_type ())
#define GNOME_PILOT_CONDUITCAP(obj)			(GTK_CHECK_CAST ((obj), GNOME_PILOT_TYPE_CONDUITCAP, GnomePilotConduitCap))
#define GNOME_PILOT_CONDUITCAP_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_PILOT_TYPE_CONDUITCAP, GnomePilotConduitCapClass))
#define GNOME_PILOT_IS_CONDUITCAP(obj)			(GTK_CHECK_TYPE ((obj), GNOME_PILOT_TYPE_CONDUITCAP))
#define GNOME_PILOT_IS_CONDUITCAP_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_PILOT_TYPE_CONDUITCAP))


typedef struct _GnomePilotConduitCap        GnomePilotConduitCap;
typedef struct _GnomePilotConduitCapPrivate GnomePilotConduitCapPrivate;
typedef struct _GnomePilotConduitCapClass   GnomePilotConduitCapClass;

struct _GnomePilotConduitCap {
	GtkVBox parent;

	GnomePilotConduitCapPrivate *priv;
};

struct _GnomePilotConduitCapClass {
	GtkVBoxClass parent_class;
};


GtkType    gnome_pilot_conduitcap_get_type (void);
GtkWidget *gnome_pilot_conduitcap_new      (GnomePilotClient *gpc);

CappletWidget *gnome_pilot_conduitcap_get_parent (GnomePilotConduitCap *gpcap);
void gnome_pilot_conduitcap_set_parent (GnomePilotConduitCap *gpcap, CappletWidget *cap);

void gnome_pilot_conduitcap_update (GnomePilotConduitCap *gpcap);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _GNOME_PILOT_CONDUITCAP_H_ */
