# Note that this is NOT a relocatable package
%define ver      0.99.3
%define rel      SNAP
%define prefix   /usr

Summary: GNOME Personal Information Manager
Name: gnome-pim
Version: %ver
Release: %rel
Copyright: GPL
Group: X11/Applications
Source: ftp://ftp.gnome.org/pub/GNOME/sources/gnome-pim/gnome-pim-%{ver}.tar.gz
BuildRoot: /var/tmp/gnome-pim-root
Obsoletes: gnome
Packager: Marc Ewing <marc@redhat.com>
URL: http://www.gnome.org

Docdir: %{prefix}/doc
Requires: gnome-libs >= 0.99.0
Requires: ORBit >= 0.3.0

%description
The GNOME Personal Information Manager consists of applications to make
keeping up with your busy life easier.

Currently these apps are present:

 - gnomecal :  personal calendar and todo list
 - gnomecard:  contact list of friends and business associates

%changelog

* Mon Dec 14 1998 Michael Fulbright <drmike@redhat.com>

- first try at an RPM for the 0.99.0 release

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/*
%{prefix}/share/locale/*
%{prefix}/share/idl/*
%{prefix}/share/apps/Productivity/*
%{prefix}/share/gnome/help/cal/*
%{prefix}/share/mime-info/*
