/* A simple printer dialog. */

#include <config.h>
#include <gnome.h>
#include "gnome-printer.h"
#include "gnome-printer-dialog.h"

static void gnome_printer_dialog_class_init (GnomePrinterDialogClass *klass);

static void
gnome_printer_dialog_finalize (GtkObject *object);

static GnomeDialogClass *parent_class = NULL;

GtkType
gnome_printer_dialog_get_type (void)
{
  static GtkType printer_dialog_type = 0;

  if (!printer_dialog_type)
    {
      GtkTypeInfo printer_dialog_info =
      {
	"GnomePrinterDialog",
	sizeof (GnomePrinterDialog),
	sizeof (GnomePrinterDialogClass),
	(GtkClassInitFunc) gnome_printer_dialog_class_init,
	(GtkObjectInitFunc) NULL,
	/* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      printer_dialog_type = gtk_type_unique (gnome_dialog_get_type (), &printer_dialog_info);
    }

  return printer_dialog_type;
}

static void
gnome_printer_dialog_class_init (GnomePrinterDialogClass *class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass*) class;

  parent_class = gtk_type_class (gnome_dialog_get_type ());

  object_class->finalize = gnome_printer_dialog_finalize;


}

static void
gnome_printer_dialog_b_cb (GtkWidget *b, GnomePrinterDialog *pd)
{
  gtk_widget_set_sensitive (pd->e1, b == pd->r1);
  gtk_widget_set_sensitive (pd->e2, b == pd->r2);

}

GtkWidget *
gnome_printer_dialog_new (void)
{
  GtkWidget *printer_dialog;
  GnomePrinterDialog *pd;
  GtkWidget *frame;
  GtkWidget *h;
  GtkWidget *t;
  GtkWidget *r1, *r2;
  GtkWidget *e1, *e2;
  GtkWidget *l;

  pd = gtk_type_new (gnome_printer_dialog_get_type ());
  printer_dialog = GTK_WIDGET (pd);

  gtk_window_set_title (GTK_WINDOW (printer_dialog), _("Select Printer"));

  gnome_dialog_append_button ( GNOME_DIALOG(printer_dialog),
			       GNOME_STOCK_BUTTON_OK);

  gnome_dialog_append_button ( GNOME_DIALOG(printer_dialog),
			       GNOME_STOCK_BUTTON_CANCEL);

  gnome_dialog_set_default( GNOME_DIALOG( printer_dialog ), 0 );

  frame = gtk_frame_new (_("Select printer"));

  t = gtk_table_new (3, 2, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), t);

  l = gtk_label_new (_("Print to:"));
  gtk_misc_set_alignment (GTK_MISC (l), 1, 0.5);
  gtk_table_attach (GTK_TABLE (t), l, 0, 1, 0, 1,
		    GTK_EXPAND | GTK_FILL,
		    GTK_EXPAND | GTK_FILL,
		    2, 2);

  h = gtk_hbox_new (FALSE, 0);
  gtk_table_attach (GTK_TABLE (t), h, 1, 2, 0, 1,
		    GTK_EXPAND | GTK_FILL,
		    GTK_EXPAND | GTK_FILL,
		    2, 2);

  r1 = gtk_radio_button_new_with_label (NULL, _("Printer"));
  pd->r1 = r1;
  gtk_box_pack_start (GTK_BOX (h), r1, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (r1), "clicked",
		      (GtkSignalFunc) gnome_printer_dialog_b_cb,
		      (gpointer) pd);

  r2 = gtk_radio_button_new_with_label (GTK_RADIO_BUTTON (r1)->group,
					_("File"));
  pd->r2 = r2;
  gtk_box_pack_start (GTK_BOX (h), r2, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (r2), "clicked",
		      (GtkSignalFunc) gnome_printer_dialog_b_cb,
		      (gpointer) pd);


  l = gtk_label_new (_("Print Command:"));
  gtk_misc_set_alignment (GTK_MISC (l), 1, 0.5);
  gtk_table_attach (GTK_TABLE (t), l, 0, 1, 1, 2,
		    GTK_EXPAND | GTK_FILL,
		    GTK_EXPAND | GTK_FILL,
		    2, 2);

  e1 = gtk_entry_new ();
  pd->e1 = e1;
  gtk_entry_set_text (GTK_ENTRY (e1), "lpr");
  gtk_table_attach (GTK_TABLE (t), e1, 1, 2, 1, 2,
		    GTK_EXPAND | GTK_FILL,
		    GTK_EXPAND | GTK_FILL,
		    2, 2);

  l = gtk_label_new (_("File Name:"));
  gtk_misc_set_alignment (GTK_MISC (l), 1, 0.5);
  gtk_table_attach (GTK_TABLE (t), l, 0, 1, 2, 3,
		    GTK_EXPAND | GTK_FILL,
		    GTK_EXPAND | GTK_FILL,
		    2, 2);

  e2 = gtk_entry_new ();
  pd->e2 = e2;
  gtk_entry_set_text (GTK_ENTRY (e2), "test.ps");
  gtk_table_attach (GTK_TABLE (t), e2, 1, 2, 2, 3,
		    GTK_EXPAND | GTK_FILL,
		    GTK_EXPAND | GTK_FILL,
		    2, 2);
  gtk_widget_set_sensitive (e2, FALSE);

  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (printer_dialog)->vbox), frame, TRUE, TRUE, 0);
  gtk_widget_show_all (frame);

  return printer_dialog;
}

GnomePrinter *
gnome_printer_dialog_new_modal (void)
{
  GtkWidget *printer_dialog;
  GnomePrinterDialog *pd;
  GnomePrinter *printer;
  int bn;

  printer_dialog = gnome_printer_dialog_new();
  pd = GNOME_PRINTER_DIALOG (printer_dialog);

  gtk_window_set_modal(GTK_WINDOW(printer_dialog),TRUE);
  bn = gnome_dialog_run (GNOME_DIALOG (printer_dialog));

  if (bn < 0)
    return NULL;

  printer = NULL;
  if (bn == 0)
    printer = gnome_printer_dialog_get_printer( pd );

  gtk_widget_destroy (printer_dialog);
  return printer;
}

GnomePrinter *
gnome_printer_dialog_get_printer (GnomePrinterDialog *dialog)
{
  GnomePrinter *printer = NULL;
  if (GTK_TOGGLE_BUTTON (dialog->r1)->active)
    {
      char *com = gtk_entry_get_text (GTK_ENTRY (dialog->e1));
      char *fn;
      
      fn = g_malloc (strlen (com) + 2);
      fn[0] = '|';
      memcpy (fn + 1, com, strlen (com) + 1);
      printer = gnome_printer_new_generic_ps (fn);
      g_free (fn);
    }
  else if (GTK_TOGGLE_BUTTON (dialog->r2)->active)
    {
      char *fn = gtk_entry_get_text (GTK_ENTRY (dialog->e2));
      
      printer = gnome_printer_new_generic_ps (fn);
    }
  return printer;
}

static void
gnome_printer_dialog_finalize (GtkObject *object)
{
  GnomePrinterDialog *printer_dialog;

  g_return_if_fail (object != NULL);
  g_return_if_fail (GNOME_IS_PRINTER_DIALOG (object));

  printer_dialog = GNOME_PRINTER_DIALOG (object);

  

  (* GTK_OBJECT_CLASS (parent_class)->finalize) (object);
}
