/*-*- c -*-*/
/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR  A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with main.c; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

/**
 * SECTION: gnome-scan-init
 * @title: Init and loading
 * @short_description: Module loading and various registration
 */

#ifdef	HAVE_CONFIG_H
#include <config.h>
#endif

#include <gegl.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "gnome-scan-init.h"
#include "gnome-scan-module-manager.h"

static GnomeScanModuleManager *module_manager = NULL;
static GtkIconFactory *factory = NULL;

static GtkStockItem items[] = {
  { GS_STOCK_SCAN,
    N_("_Scan"),
    0, /* modifier */
    0, /* keyval */
    GETTEXT_PACKAGE }
};

/**
 * gnome_scan_init:
 * @argc: a pointer to arg count
 * @argv: a pointer to arg values.
 * 
 * This function must be called before any other gnome_scan
 * function. It initialize #GnomeScanModules and register various
 * stuffs like #GtkStockItem, etc.
 **/
void
gnome_scan_init (gint *argc, gchar ***argv)
{
  g_debug ("Initializing %s for %s (%s)",
	   PACKAGE_STRING,
	   g_get_application_name(),
	   g_get_prgname());
  gchar *path;
  guint i, n_items;
  n_items = G_N_ELEMENTS (items);
  GtkIconSet *set;
  GtkIconSource *source;
  gchar* filename;

  gegl_init (argc, argv);

  /* load modules */
  path = g_strjoin (G_SEARCHPATH_SEPARATOR_S,
		    MODULE_DIR, "modules", "../modules", NULL);

  module_manager = gnome_scan_module_manager_new (path);
  gnome_scan_module_manager_query_modules (module_manager);

  /* init i18n */
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");

  /* add stock items */
  gtk_stock_add_static (items, n_items);

  factory = gtk_icon_factory_new ();
  for (i = 0; i < n_items; i++) {
    set = gtk_icon_set_new ();
    filename = g_build_filename (ICON_DIR,
				 "scalable",
				 "actions",
				 g_strconcat (items[i].stock_id, ".svg", NULL),
				 NULL);
    source = gtk_icon_source_new ();
    gtk_icon_source_set_icon_name (source, items[i].stock_id);
/*     gtk_icon_source_set_filename (source, filename); */
    gtk_icon_source_set_direction_wildcarded (source, TRUE);
    gtk_icon_source_set_size_wildcarded (source, TRUE);
    gtk_icon_source_set_state_wildcarded (source, TRUE);
    gtk_icon_set_add_source (set, source);
    gtk_icon_source_free (source);
    gtk_icon_factory_add (factory,
			  items[i].stock_id,
			  set);
    gtk_icon_set_unref (set);
  }
  gtk_icon_factory_add_default (factory);

  gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (),
				     ICON_DIR);
}

void
gnome_scan_exit (void)
{
  gtk_icon_factory_remove_default (factory);
  g_object_unref (factory);
  gegl_exit ();
  gnome_scan_module_manager_unload_modules (module_manager);
}
