/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*  This file is part of gnome-spell bonobo component
    copied from echo.c written by Miguel de Icaza and updated for Spell.idl needs

    Copyright (C) 1999, 2000 Helix Code, Inc.
    Authors:                 Radek Doulik <rodo@helixcode.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <config.h>
#include <bonobo.h>

#include "Spell.h"
#include "checker.h"

static BonoboObjectClass               *checker_parent_class;
static POA_GNOME_Spell_Checker__vepv    checker_vepv;

static void
checker_object_destroy (GtkObject *object)
{
	GNOMESpellChecker *checker = GNOME_SPELL_CHECKER (object);

	GTK_OBJECT_CLASS (checker_parent_class)->destroy (object);
}

/*
 * If you want users to derive classes from your implementation
 * you need to support this method.
 */
POA_GNOME_Spell_Checker__epv *
gnome_spell_checker_get_epv (void)
{
	POA_GNOME_Spell_Checker__epv *epv;

	epv = g_new0 (POA_GNOME_Spell_Checker__epv, 1);

	/*
	 * This is the method invoked by CORBA
	 */
	// epv->set = impl_gnome_spell_checker_set;

	return epv;
}

static void
init_checker_corba_class (void)
{
	checker_vepv.Bonobo_Unknown_epv         = bonobo_object_get_epv ();
	checker_vepv.GNOME_Spell_Checker_epv = gnome_spell_checker_get_epv ();
}

static void
checker_class_init (GNOMESpellCheckerClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;

	checker_parent_class = gtk_type_class (bonobo_object_get_type ());
	object_class->destroy   = checker_object_destroy;

	init_checker_corba_class ();
}

GtkType
gnome_spell_checker_get_type (void)
{
	static GtkType type = 0;

	if (!type){
		GtkTypeInfo info = {
			"Checker",
			sizeof (GNOMESpellChecker),
			sizeof (GNOMESpellCheckerClass),
			(GtkClassInitFunc) checker_class_init,
			(GtkObjectInitFunc) NULL,
			NULL, /* reserved 1 */
			NULL, /* reserved 2 */
			(GtkClassInitFunc) NULL
		};

		type = gtk_type_unique (bonobo_object_get_type (), &info);
	}

	return type;
}

GNOMESpellChecker *
checker_construct (GNOMESpellChecker *checker, GNOME_Spell_Checker corba_checker)
{
	static int i;
	
	g_return_val_if_fail (checker != NULL, NULL);
	g_return_val_if_fail (IS_GNOME_SPELL_CHECKER (checker), NULL);
	g_return_val_if_fail (corba_checker != CORBA_OBJECT_NIL, NULL);

	/*
	 * Call parent constructor
	 */
	if (!bonobo_object_construct (BONOBO_OBJECT (checker), (CORBA_Object) corba_checker))
		return NULL;

	/*
	 * Initialize checker
	 */
	
	/*
	 * Success: return the GtkType we were given
	 */
	return checker;
}

/*
 * This routine creates the ORBit CORBA server and initializes the
 * CORBA side of things
 */
static GNOME_Spell_Checker
create_checker (BonoboObject *checker)
{
	POA_GNOME_Spell_Checker *servant;
	CORBA_Environment ev;

	servant       = (POA_GNOME_Spell_Checker *) g_new0 (BonoboObjectServant, 1);
	servant->vepv = &checker_vepv;

	CORBA_exception_init (&ev);
	POA_GNOME_Spell_Checker__init ((PortableServer_Servant) servant, &ev);
	ORBIT_OBJECT_KEY (servant->_private)->object = NULL;

	if (ev._major != CORBA_NO_EXCEPTION){
		g_free (servant);
		CORBA_exception_free (&ev);
		return CORBA_OBJECT_NIL;
	}

	CORBA_exception_free (&ev);

	/*
	 * Activates the CORBA object & binds to the servant
	 */
	return (GNOME_Spell_Checker) bonobo_object_activate_servant (checker, servant);
}

GNOMESpellChecker *
gnome_spell_checker_new (void)
{
	GNOMESpellChecker *checker;
	GNOME_Spell_Checker corba_checker;

              checker = gtk_type_new (gnome_spell_checker_get_type ());
	corba_checker = create_checker (BONOBO_OBJECT (checker));

	if (corba_checker == CORBA_OBJECT_NIL) {
		bonobo_object_unref (BONOBO_OBJECT (checker));
		return NULL;
	}
	
	return checker_construct (checker, corba_checker);
}
