/* sudoku-generator.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "qqwing-wrapper.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUDOKU_GENERATOR_TYPE_WORKER (sudoku_generator_worker_get_type ())
#define SUDOKU_GENERATOR_WORKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker))
#define SUDOKU_GENERATOR_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))
#define SUDOKU_GENERATOR_IS_WORKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_IS_WORKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SUDOKU_GENERATOR_TYPE_WORKER))
#define SUDOKU_GENERATOR_WORKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerClass))

typedef struct _SudokuGeneratorWorker SudokuGeneratorWorker;
typedef struct _SudokuGeneratorWorkerClass SudokuGeneratorWorkerClass;
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
typedef struct _SudokuGeneratorGenerateBoardsAsyncData SudokuGeneratorGenerateBoardsAsyncData;
typedef struct _SudokuGeneratorWorkerPrivate SudokuGeneratorWorkerPrivate;

struct _SudokuGenerator {
	GObject parent_instance;
	SudokuGeneratorPrivate * priv;
};

struct _SudokuGeneratorClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _SudokuGeneratorGenerateBoardsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gint nboards;
	DifficultyCategory category;
	GeeList* result;
	GeeArrayList* boards;
	GeeArrayList* _tmp0_;
	GThreadPool* pool;
	guint _tmp1_;
	GThreadPool* _tmp2_;
	gint i;
	gboolean _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GThreadPool* _tmp7_;
	gint _tmp8_;
	DifficultyCategory _tmp9_;
	GeeArrayList* _tmp10_;
	SudokuGeneratorWorker* _tmp11_;
	GError * _inner_error_;
};

struct _SudokuGeneratorWorker {
	GObject parent_instance;
	SudokuGeneratorWorkerPrivate * priv;
};

struct _SudokuGeneratorWorkerClass {
	GObjectClass parent_class;
};

struct _SudokuGeneratorWorkerPrivate {
	gint nsudokus;
	DifficultyCategory level;
	GeeList* boards_list;
	GSourceFunc callback;
	gpointer callback_target;
};


static gpointer sudoku_generator_parent_class = NULL;
static gpointer sudoku_generator_worker_parent_class = NULL;
static GMutex sudoku_generator_worker_mutex;
static GMutex sudoku_generator_worker_mutex = {0};

GType sudoku_generator_get_type (void) G_GNUC_CONST;
enum  {
	SUDOKU_GENERATOR_DUMMY_PROPERTY
};
static SudokuGenerator* sudoku_generator_new (void);
static SudokuGenerator* sudoku_generator_construct (GType object_type);
GType difficulty_category_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
static void sudoku_generator_generate_boards_async_data_free (gpointer _data);
void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error);
static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_);
static GType sudoku_generator_worker_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void __lambda5_ (SudokuGeneratorWorker* worker);
static void sudoku_generator_worker_run (SudokuGeneratorWorker* self);
static void ___lambda5__gfunc (gpointer data, gpointer self);
static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self);
static SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
static SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target);
void sudoku_generator_print_stats (SudokuBoard* board);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
gchar* sudoku_generator_qqwing_version (void);
#define SUDOKU_GENERATOR_WORKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorkerPrivate))
enum  {
	SUDOKU_GENERATOR_WORKER_DUMMY_PROPERTY
};
static gboolean ___lambda4_ (SudokuGeneratorWorker* self);
static gboolean ____lambda4__gsource_func (gpointer self);
static void sudoku_generator_worker_finalize (GObject* obj);


static SudokuGenerator* sudoku_generator_construct (GType object_type) {
	SudokuGenerator * self = NULL;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self = (SudokuGenerator*) g_object_new (object_type, NULL);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 182 "sudoku-generator.c"
}


static SudokuGenerator* sudoku_generator_new (void) {
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return sudoku_generator_construct (TYPE_SUDOKU_GENERATOR);
#line 189 "sudoku-generator.c"
}


SudokuBoard* sudoku_generator_generate_board (DifficultyCategory category) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint* puzzle = NULL;
	DifficultyCategory _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	SudokuBoard* _tmp27_ = NULL;
	DifficultyCategory _tmp28_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = sudoku_board_new (3, 3);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	board = _tmp0_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = category;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = qqwing_generate_puzzle ((gint) _tmp1_);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp2_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = -1;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 218 "sudoku-generator.c"
	{
		gint row = 0;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 223 "sudoku-generator.c"
		{
			gboolean _tmp3_ = FALSE;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp3_ = TRUE;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 230 "sudoku-generator.c"
				gint _tmp5_ = 0;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp3_) {
#line 237 "sudoku-generator.c"
					gint _tmp4_ = 0;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp4_ = row;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp4_ + 1;
#line 243 "sudoku-generator.c"
				}
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp3_ = FALSE;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp5_ = row;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp6_ = board;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp8_ = _tmp7_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp5_ < _tmp8_)) {
#line 70 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 259 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 265 "sudoku-generator.c"
					{
						gboolean _tmp9_ = FALSE;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp9_ = TRUE;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 272 "sudoku-generator.c"
							gint _tmp11_ = 0;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint val = 0;
							gint* _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp16_ = 0;
							SudokuBoard* _tmp17_ = NULL;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp9_) {
#line 289 "sudoku-generator.c"
								gint _tmp10_ = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp10_ = col;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp10_ + 1;
#line 295 "sudoku-generator.c"
							}
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp9_ = FALSE;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp11_ = col;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp12_ = board;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp14_ = _tmp13_;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp11_ < _tmp14_)) {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 311 "sudoku-generator.c"
							}
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp15_ = puzzle;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp15__length1 = puzzle_length1;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp16_ = row;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = board;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp18_ = sudoku_board_get_cols (_tmp17_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = _tmp18_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = col;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = _tmp15_[(_tmp16_ * _tmp19_) + _tmp20_];
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							val = _tmp21_;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = val;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (_tmp22_ != 0) {
#line 335 "sudoku-generator.c"
								SudokuBoard* _tmp23_ = NULL;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp23_ = board;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp24_ = row;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp25_ = col;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp26_ = val;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								sudoku_board_insert (_tmp23_, _tmp24_, _tmp25_, _tmp26_, TRUE);
#line 350 "sudoku-generator.c"
							}
						}
					}
				}
			}
		}
	}
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp27_ = board;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp28_ = category;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_board_set_difficulty_category (_tmp27_, _tmp28_);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = board;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 370 "sudoku-generator.c"
}


static void sudoku_generator_generate_boards_async_data_free (gpointer _data) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	_data_ = _data;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->result);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_slice_free (SudokuGeneratorGenerateBoardsAsyncData, _data_);
#line 381 "sudoku-generator.c"
}


void sudoku_generator_generate_boards_async (gint nboards, DifficultyCategory category, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_ = g_slice_new0 (SudokuGeneratorGenerateBoardsAsyncData);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, sudoku_generator_generate_boards_async);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, sudoku_generator_generate_boards_async_data_free);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = nboards;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->nboards = _tmp0_;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = category;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->category = _tmp1_;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_generate_boards_async_co (_data_);
#line 405 "sudoku-generator.c"
}


GeeList* sudoku_generator_generate_boards_finish (GAsyncResult* _res_, GError** error) {
	GeeList* result;
	SudokuGeneratorGenerateBoardsAsyncData* _data_;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		return NULL;
#line 416 "sudoku-generator.c"
	}
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = _data_->result;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = NULL;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 426 "sudoku-generator.c"
}


static void __lambda5_ (SudokuGeneratorWorker* worker) {
	SudokuGeneratorWorker* _tmp0_ = NULL;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (worker != NULL);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = worker;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_worker_run (_tmp0_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (worker);
#line 440 "sudoku-generator.c"
}


static void ___lambda5__gfunc (gpointer data, gpointer self) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	__lambda5_ ((SudokuGeneratorWorker*) data);
#line 447 "sudoku-generator.c"
}


static gboolean _sudoku_generator_generate_boards_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = sudoku_generator_generate_boards_async_co (self);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 456 "sudoku-generator.c"
}


static gboolean sudoku_generator_generate_boards_async_co (SudokuGeneratorGenerateBoardsAsyncData* _data_) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	switch (_data_->_state_) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		case 0:
#line 465 "sudoku-generator.c"
		goto _state_0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		case 1:
#line 469 "sudoku-generator.c"
		goto _state_1;
		default:
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_assert_not_reached ();
#line 474 "sudoku-generator.c"
	}
	_state_0:
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp0_ = NULL;
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp0_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 84 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->boards = _data_->_tmp0_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp1_ = 0U;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp1_ = g_get_num_processors ();
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp2_ = NULL;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_tmp2_ = g_thread_pool_new (___lambda5__gfunc, NULL, (gint) _data_->_tmp1_, FALSE, &_data_->_inner_error_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->pool = _data_->_tmp2_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		if (_data_->_inner_error_->domain == G_THREAD_ERROR) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_error_free (_data_->_inner_error_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			if (_data_->_state_ == 0) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 507 "sudoku-generator.c"
			} else {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 511 "sudoku-generator.c"
			}
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_object_unref (_data_->_async_result);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 517 "sudoku-generator.c"
		} else {
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_data_->boards);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			g_clear_error (&_data_->_inner_error_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			return FALSE;
#line 527 "sudoku-generator.c"
		}
	}
	{
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		_data_->i = 0;
#line 533 "sudoku-generator.c"
		{
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_data_->_tmp3_ = TRUE;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_data_->_tmp3_) {
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp4_ = 0;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->_tmp4_ = _data_->i;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_data_->i = _data_->_tmp4_ + 1;
#line 547 "sudoku-generator.c"
				}
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp3_ = FALSE;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp5_ = 0;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp5_ = _data_->i;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp6_ = 0;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp6_ = _data_->nboards;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 563 "sudoku-generator.c"
				}
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp7_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp7_ = _data_->pool;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp8_ = 0;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp8_ = _data_->nboards;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp9_ = 0;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp9_ = _data_->category;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp10_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp10_ = _data_->boards;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp11_ = NULL;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_data_->_tmp11_ = sudoku_generator_worker_new (_data_->_tmp8_, _data_->_tmp9_, (GeeList*) _data_->_tmp10_, _sudoku_generator_generate_boards_async_co_gsource_func, _data_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				g_thread_pool_push (_data_->_tmp7_, _data_->_tmp11_, &_data_->_inner_error_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					if (_data_->_inner_error_->domain == G_THREAD_ERROR) {
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_error_free (_data_->_inner_error_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_g_thread_pool_free0 (_data_->pool);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_g_object_unref0 (_data_->boards);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						if (_data_->_state_ == 0) {
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 603 "sudoku-generator.c"
						} else {
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 607 "sudoku-generator.c"
						}
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_object_unref (_data_->_async_result);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						return FALSE;
#line 613 "sudoku-generator.c"
					} else {
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_g_thread_pool_free0 (_data_->pool);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_g_object_unref0 (_data_->boards);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						g_clear_error (&_data_->_inner_error_);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						return FALSE;
#line 625 "sudoku-generator.c"
					}
				}
			}
		}
	}
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->_state_ = 1;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 635 "sudoku-generator.c"
	_state_1:
	;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_data_->result = (GeeList*) _data_->boards;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_thread_pool_free0 (_data_->pool);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_state_ == 0) {
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 646 "sudoku-generator.c"
	} else {
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 650 "sudoku-generator.c"
	}
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_object_unref (_data_->_async_result);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_thread_pool_free0 (_data_->pool);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (_data_->boards);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_data_->_state_ == 0) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 664 "sudoku-generator.c"
	} else {
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 668 "sudoku-generator.c"
	}
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_object_unref (_data_->_async_result);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return FALSE;
#line 674 "sudoku-generator.c"
}


void sudoku_generator_print_stats (SudokuBoard* board) {
	gint* cells = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint cells_length1 = 0;
	gint cells_length2 = 0;
	gint* puzzle = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuBoard* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint* _tmp10_ = NULL;
	gint puzzle_length1 = 0;
	gint _puzzle_size_ = 0;
	gint* _tmp34_ = NULL;
	gint _tmp34__length1 = 0;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (board != NULL);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = board;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = sudoku_board_get_cells (_tmp0_, &_tmp1_, &_tmp2_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells = _tmp3_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length1 = _tmp1_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells_length2 = _tmp2_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = board;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = board;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = sudoku_board_get_cols (_tmp7_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp9_ = _tmp8_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp10_ = g_new0 (gint, _tmp6_ * _tmp9_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = _tmp10_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle_length1 = _tmp6_ * _tmp9_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_puzzle_size_ = puzzle_length1;
#line 730 "sudoku-generator.c"
	{
		gint row = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		row = 0;
#line 735 "sudoku-generator.c"
		{
			gboolean _tmp11_ = FALSE;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = TRUE;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 742 "sudoku-generator.c"
				gint _tmp13_ = 0;
				SudokuBoard* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp11_) {
#line 749 "sudoku-generator.c"
					gint _tmp12_ = 0;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp12_ = row;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					row = _tmp12_ + 1;
#line 755 "sudoku-generator.c"
				}
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp11_ = FALSE;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = row;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = board;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = sudoku_board_get_rows (_tmp14_);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = _tmp15_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp13_ < _tmp16_)) {
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 771 "sudoku-generator.c"
				}
				{
					gint col = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
					col = 0;
#line 777 "sudoku-generator.c"
					{
						gboolean _tmp17_ = FALSE;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp17_ = TRUE;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 784 "sudoku-generator.c"
							gint _tmp19_ = 0;
							SudokuBoard* _tmp20_ = NULL;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint* _tmp23_ = NULL;
							gint _tmp23__length1 = 0;
							gint _tmp24_ = 0;
							SudokuBoard* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint* _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp17_) {
#line 805 "sudoku-generator.c"
								gint _tmp18_ = 0;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp18_ = col;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								col = _tmp18_ + 1;
#line 811 "sudoku-generator.c"
							}
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp17_ = FALSE;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp19_ = col;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp20_ = board;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = sudoku_board_get_cols (_tmp20_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = _tmp21_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp19_ < _tmp22_)) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 827 "sudoku-generator.c"
							}
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_ = puzzle;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23__length1 = puzzle_length1;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp24_ = row;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp25_ = board;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp26_ = sudoku_board_get_cols (_tmp25_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp27_ = _tmp26_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp28_ = col;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29_ = cells;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length1 = cells_length1;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp29__length2 = cells_length2;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp30_ = row;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp31_ = col;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_[(_tmp24_ * _tmp27_) + _tmp28_] = _tmp32_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp33_ = _tmp23_[(_tmp24_ * _tmp27_) + _tmp28_];
#line 859 "sudoku-generator.c"
						}
					}
				}
			}
		}
	}
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34_ = puzzle;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp34__length1 = puzzle_length1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	qqwing_print_stats (_tmp34_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	puzzle = (g_free (puzzle), NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	cells = (g_free (cells), NULL);
#line 876 "sudoku-generator.c"
}


gchar* sudoku_generator_qqwing_version (void) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = qqwing_get_version ();
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = _tmp0_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 889 "sudoku-generator.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return self ? g_object_ref (self) : NULL;
#line 896 "sudoku-generator.c"
}


static SudokuGeneratorWorker* sudoku_generator_worker_construct (GType object_type, gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
	SudokuGeneratorWorker * self = NULL;
	gint _tmp0_ = 0;
	DifficultyCategory _tmp1_ = 0;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	GSourceFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (boards_list != NULL, NULL);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self = (SudokuGeneratorWorker*) g_object_new (object_type, NULL);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = nsudokus;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->nsudokus = _tmp0_;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = level;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->level = _tmp1_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = boards_list;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->boards_list = _tmp3_;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = callback;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4__target = callback_target;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback = _tmp4_;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->callback_target = _tmp4__target;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 938 "sudoku-generator.c"
}


static SudokuGeneratorWorker* sudoku_generator_worker_new (gint nsudokus, DifficultyCategory level, GeeList* boards_list, GSourceFunc callback, void* callback_target) {
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return sudoku_generator_worker_construct (SUDOKU_GENERATOR_TYPE_WORKER, nsudokus, level, boards_list, callback, callback_target);
#line 945 "sudoku-generator.c"
}


static gboolean ___lambda4_ (SudokuGeneratorWorker* self) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = self->priv->callback;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0__target = self->priv->callback_target;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ (_tmp0__target);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	result = G_SOURCE_REMOVE;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 963 "sudoku-generator.c"
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ ((SudokuGeneratorWorker*) self);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 972 "sudoku-generator.c"
}


static void sudoku_generator_worker_run (SudokuGeneratorWorker* self) {
	SudokuBoard* board = NULL;
	DifficultyCategory _tmp0_ = 0;
	SudokuBoard* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	GeeList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (self != NULL);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = self->priv->level;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = sudoku_generator_generate_board (_tmp0_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	board = _tmp1_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_mutex_lock (&sudoku_generator_worker_mutex);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = self->priv->boards_list;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = board;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp3_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = self->priv->boards_list;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = _tmp5_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = self->priv->nsudokus;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp6_ == _tmp7_) {
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
#line 1014 "sudoku-generator.c"
	}
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_mutex_unlock (&sudoku_generator_worker_mutex);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (board);
#line 1020 "sudoku-generator.c"
}


static void sudoku_generator_worker_class_init (SudokuGeneratorWorkerClass * klass) {
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_worker_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	g_type_class_add_private (klass, sizeof (SudokuGeneratorWorkerPrivate));
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_generator_worker_finalize;
#line 1031 "sudoku-generator.c"
}


static void sudoku_generator_worker_instance_init (SudokuGeneratorWorker * self) {
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv = SUDOKU_GENERATOR_WORKER_GET_PRIVATE (self);
#line 1038 "sudoku-generator.c"
}


static void sudoku_generator_worker_finalize (GObject* obj) {
	SudokuGeneratorWorker * self;
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SUDOKU_GENERATOR_TYPE_WORKER, SudokuGeneratorWorker);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->boards_list);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (sudoku_generator_worker_parent_class)->finalize (obj);
#line 1050 "sudoku-generator.c"
}


static GType sudoku_generator_worker_get_type (void) {
	static volatile gsize sudoku_generator_worker_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_worker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorWorkerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_worker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGeneratorWorker), 0, (GInstanceInitFunc) sudoku_generator_worker_instance_init, NULL };
		GType sudoku_generator_worker_type_id;
		sudoku_generator_worker_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGeneratorWorker", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_worker_type_id__volatile, sudoku_generator_worker_type_id);
	}
	return sudoku_generator_worker_type_id__volatile;
}


static void sudoku_generator_class_init (SudokuGeneratorClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_parent_class = g_type_class_peek_parent (klass);
#line 1069 "sudoku-generator.c"
}


static void sudoku_generator_instance_init (SudokuGenerator * self) {
}


GType sudoku_generator_get_type (void) {
	static volatile gsize sudoku_generator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGenerator), 0, (GInstanceInitFunc) sudoku_generator_instance_init, NULL };
		GType sudoku_generator_type_id;
		sudoku_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGenerator", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_type_id__volatile, sudoku_generator_type_id);
	}
	return sudoku_generator_type_id__volatile;
}



