#include <config.h>
#define WNCK_I_KNOW_THIS_IS_UNSTABLE
#include <libwnck/libwnck.h>
#include <dirent.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtkmm.h>

#include "prettytable.h"
#include "defaulttable.h"
#include "proctable.h"
#include "util.h"


namespace
{
  const unsigned APP_ICON_SIZE = 16;
}


Glib::RefPtr<Gdk::Pixbuf>
IconThemeWrapper::load_icon(const Glib::ustring& icon_name,
			    int size, Gtk::IconLookupFlags flags) const
{
  try
    {
      return this->theme->load_icon(icon_name, size, flags);
    }
  catch (Gtk::IconThemeError &error)
    {
      if (error.code() != Gtk::IconThemeError::ICON_THEME_NOT_FOUND)
	throw;
      return Glib::RefPtr<Gdk::Pixbuf>();
    }
}



PrettyTable::PrettyTable()
{
  WnckScreen* screen = wnck_screen_get_default();
  g_signal_connect(G_OBJECT(screen), "application_opened",
		   G_CALLBACK(PrettyTable::on_application_opened), this);
  g_signal_connect(G_OBJECT(screen), "application_closed",
		   G_CALLBACK(PrettyTable::on_application_closed), this);
}


PrettyTable::~PrettyTable()
{
}


void
PrettyTable::on_application_opened(WnckScreen* screen, WnckApplication* app, gpointer data)
{
  pid_t pid = wnck_application_get_pid(app);

  if (pid == 0)
    return;

  // we don't own it
  GList* list = wnck_application_get_windows(app);

  if (not list)
    return;

  WnckWindow* win = static_cast<WnckWindow*>(list->data);

  Glib::RefPtr<Gdk::Pixbuf> icon(Glib::wrap(wnck_window_get_icon(win),
					    /* take_copy */ true));

  if (not icon)
    return;

  icon = icon->scale_simple(APP_ICON_SIZE, APP_ICON_SIZE, Gdk::INTERP_HYPER);

  if (not icon)
    return;

  static_cast<PrettyTable*>(data)->register_application(pid, icon);
}



void
PrettyTable::register_application(pid_t pid, Glib::RefPtr<Gdk::Pixbuf> icon)
{
  /* If process already exists then set the icon. Otherwise put into hash
  ** table to be added later */
  if (ProcInfo* info = ProcInfo::find(pid))
    {
      info->set_icon(icon);
      // move the ref to the map
      this->apps[pid] = icon;
    }
}



void
PrettyTable::on_application_closed(WnckScreen* screen, WnckApplication* app, gpointer data)
{
  pid_t pid = wnck_application_get_pid(app);

  if (pid == 0)
    return;

  static_cast<PrettyTable*>(data)->unregister_application(pid);
}



void
PrettyTable::unregister_application(pid_t pid)
{
  IconsForPID::iterator it(this->apps.find(pid));

  if (it != this->apps.end())
    this->apps.erase(it);
}



Glib::RefPtr<Gdk::Pixbuf>
PrettyTable::get_icon_from_theme(pid_t, const gchar* command)
{
  return this->theme->load_icon(command, APP_ICON_SIZE, Gtk::ICON_LOOKUP_USE_BUILTIN);
}


bool PrettyTable::get_default_icon_name(const string &cmd, string &name)
{
  for (size_t i = 0; i != G_N_ELEMENTS(default_table); ++i) {
    if (default_table[i].command->FullMatch(cmd)) {
      name = default_table[i].icon;
      return true;
    }
  }

  return false;
}

/*
  Try to get an icon from the default_table
  If it's not in defaults, try to load it.
  If there is no default for a command, store NULL in defaults
  so we don't have to lookup again.
*/

Glib::RefPtr<Gdk::Pixbuf>
PrettyTable::get_icon_from_default(pid_t, const gchar* command)
{
  Glib::RefPtr<Gdk::Pixbuf> pix;
  string name;

  if (this->get_default_icon_name(command, name)) {
    IconCache::iterator it(this->defaults.find(name));

    if (it == this->defaults.end()) {
      pix = this->theme->load_icon(name, APP_ICON_SIZE, Gtk::ICON_LOOKUP_USE_BUILTIN);
      if (pix)
	this->defaults[name] = pix;
    } else
      pix = it->second;
  }

  return pix;
}



Glib::RefPtr<Gdk::Pixbuf>
PrettyTable::get_icon_from_wnck(pid_t pid, const gchar*)
{
  Glib::RefPtr<Gdk::Pixbuf> icon;

  IconsForPID::iterator it(this->apps.find(pid));

  if (it != this->apps.end())
    icon = it->second;

  return icon;
}



Glib::RefPtr<Gdk::Pixbuf>
PrettyTable::get_icon_from_name(pid_t, const gchar* command)
{
  return this->theme->load_icon(command, APP_ICON_SIZE, Gtk::ICON_LOOKUP_USE_BUILTIN);
}


Glib::RefPtr<Gdk::Pixbuf>
PrettyTable::get_icon_dummy(pid_t, const gchar*)
{
  return this->theme->load_icon("applications-other", APP_ICON_SIZE, Gtk::ICON_LOOKUP_USE_BUILTIN);
}


Glib::RefPtr<Gdk::Pixbuf>
PrettyTable::get_icon(const gchar* command, pid_t pid)
{
  typedef Glib::RefPtr<Gdk::Pixbuf>
    (PrettyTable::*Getter)(pid_t pid, const gchar* command);

  const Getter getters[] = {
    &PrettyTable::get_icon_from_wnck,
    &PrettyTable::get_icon_from_theme,
    &PrettyTable::get_icon_from_default,
    &PrettyTable::get_icon_from_name,
    &PrettyTable::get_icon_dummy,
  };

  Glib::RefPtr<Gdk::Pixbuf> icon;

  for (size_t i = 0; not icon and i < G_N_ELEMENTS(getters); ++i)
    icon = (this->*getters[i])(pid, command);

  return icon;
}

