/* $Id: application-registry.h,v 1.2 2003/03/23 13:10:54 murrayc Exp $ */

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _LIBGNOMEVFSMM_APPLICATION_REGISTRY_H
#define _LIBGNOMEVFSMM_APPLICATION_REGISTRY_H

#include <glibmm.h>

#include <libgnomevfsmm/enums.h>
#include <libgnomevfs/gnome-vfs-application-registry.h>


namespace Gnome
{

namespace Vfs
{

namespace ApplicationRegistry
{


/***
 * Existance check
 */
bool exists(const Glib::ustring& app_id);

typedef Glib::ListHandle<Glib::ustring> ListHandleStrings;
ListHandleStrings get_keys(const Glib::ustring& app_id);

Glib::ustring peek_value(const Glib::ustring& app_id, const Glib::ustring& key);
bool get_bool_value(const Glib::ustring& app_id, const Glib::ustring& key, bool& got_key);

void remove_application(const Glib::ustring& app_id);
void set_value(const Glib::ustring& app_id, const Glib::ustring& key, const Glib::ustring& value);
void set_value(const Glib::ustring& app_id, const Glib::ustring& key, bool value = true);
void unset_key(const Glib::ustring& app_id, const Glib::ustring& key);

/*
 * Query functions
 */
ListHandleStrings get_applications(const Glib::ustring& mime_type);
ListHandleStrings get_mime_types(const Glib::ustring& app_id);

bool supports_mime_type(const Glib::ustring& app_id, const Glib::ustring& mime_type);
bool supports_uri_scheme(const Glib::ustring& app_id, const Glib::ustring& uri_scheme);

//TODO: bool gnome_vfs_application_is_user_owned_application(const GnomeVFSMimeApplication *application);

/*
 * Mime type functions
 * Note that mime_type can be a specific(image/png) or generic (image/<star>) type
 */

void clear_mime_types(const Glib::ustring& app_id);
void add_mime_type(const Glib::ustring& app_id, const Glib::ustring& mime_type);
void remove_mime_type(const Glib::ustring& app_id, const Glib::ustring& mime_type);


/*
 * Commit function, should be called if ANY stuff changes have been made.
 * Stuff is saved into the user directory.
 */
Result sync();

void shutdown();
void reload();

/*
 * Integrating with gnome-vfs-mime-handlers
 */
//TODO: MimeApplication* get_mime_application(const Glib::ustring& app_id);
//TODO: void save_mime_application(const MimeApplication& application);



} //namespace ApplicationRegistry

} // namespace Vfs
} // namespace Gnome




#endif /* _LIBGNOMEVFSMM_APPLICATION_REGISTRY_H */

