// $Id: options.h,v 1.12 2000/01/02 18:41:37 cactus Exp $ -*- c++ -*-
/*
  Gnomoku Copyright (C) 1998-1999 NAGY Andrs <nagya@telnet.hu>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  (included in the RadioActive distribution in doc/GPL) as published by
  the Free Software Foundation.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef OPTIONS_H
#define OPTIONS_H

#include <gnome--.h>
#include "opponent.h"

// OPTIONS
class Options : public Gnome::Dialog {
    Gtk::OptionMenu combo;
    Gtk::Entry e2, e3;
    Gtk::CheckButton e4;

    op_t &optype, optype_cache;
    string &v1, &v2;
    bool &beep;
public:
    Options(op_t &optype_, string &v1_, string &v2_, bool &beep_);
    SigC::Signal0<void> changed;
private:
    void update();
    void button_clicked(int button);
    void op_change(op_t op);
    gint delete_event_impl(GdkEventAny *);
};

#endif
