/* braille.c
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libsrconf.h"

#include "braille.h"
#include "baumbrl.h"
#include "alvabrl.h"



typedef struct
{
  gchar *device_ID;
  gchar *device_description;
  /* !!! TBR !!! - could add more info here if neded */
} BRLDEV_INFO;

/* Globals */

BRLDEV_INFO   SupportedDevices[] = {

  {"VARIO20", "BAUM VARIO - 20 cells"},
  {"VARIO40", "BAUM VARIO - 40 cells"},
  {"VARIO80", "BAUM VARIO - 80 cells"},
  {"DM80P", "BAUM DM80 - 80 cells"},
  {"ALVA380", "ALVABRAILLE 380"},
  {"ALVA544", "ALVABRAILLE 544"},
  {"ALVA570", "ALVABRAILLE 570"}

 };


static BRL_DEVICE*						CurrentDevice = NULL;
static unsigned char* 					Dots = NULL;

/* static short 										CursorShape = 0x0C;		 dot 7/8 */
/* static short 										CursorMask = 0x0C;       dot 7/8 */
/* static short 										BrailleStyle = 8;             8 dot Braille */
/* static short 										AttrStyle = 0;					 ... */
/* static short 										CursorPos = -1;				 ... no cursor */
/* static char* 									Text = NULL; */
/* static unsigned long* 					Attrs = NULL; */



/* static unsigned char 						*TranslationTable = NULL;	  !!! consider MBCS !!! */

static BRAILLE_EVENT_PROC		ClientEventProc = NULL;

/* Deviceless Functions */

void brl_init()
{
  /* !!! TBR !!! init globals here */

  gint i;
  gchar *brldev_key;

  /* publish into GCONF the list of supported devices */

  i = sizeof(SupportedDevices) / sizeof(BRLDEV_INFO);
  SET_BRAILLE_CONFIG_DATA (BRAILLE_DEVICE_COUNT, CFGT_INT, &i);

  for (i = 0; i < sizeof(SupportedDevices) / sizeof(BRLDEV_INFO); ++i)
  {

    brldev_key = g_strdup_printf ("brldev_%d_ID", i);
    SET_BRAILLE_CONFIG_DATA (brldev_key, CFGT_STRING, SupportedDevices[i].device_ID);
    g_free (brldev_key);


    brldev_key = g_strdup_printf ("brldev_%d_description", i);
    SET_BRAILLE_CONFIG_DATA (brldev_key, CFGT_STRING, SupportedDevices[i].device_description);
    g_free (brldev_key);

   }


   i = 0;
   SET_BRAILLE_CONFIG_DATA (BRAILLE_DEFAULT_DEVICE, CFGT_INT, &i);

}

void brl_terminate()
{
	brl_close_device();
	/* if (TranslationTable) */
	/* { */
	/*	free (TranslationTable); */
	/*	TranslationTable = NULL; */
	/* } */

}

#if 0
int brl_load_translation_table (char* FileName)
{
	int rv = 0;
	FILE *fp;
	
	if (TranslationTable) free (TranslationTable);
	/* !!! TBR !!! consider MBCS */
	TranslationTable = calloc (256, sizeof(unsigned char));

   /* assert (TranslationTable); */

	fp = fopen (FileName, "rb");
	if (fp)
	{
		fread (TranslationTable, 1, 256, fp);
		rv = 1;
	}
	else
	{
		fprintf (stderr, "brl_load_translation_table: could't open the file %s\n", FileName);
		/* errno = */
	}

	return rv;
}

int brl_text_to_braille (char *Text, unsigned char *Dots, short MaxLen)
{
	if (!TranslationTable)
	{
		/* errno = */
		fprintf (stderr, "brl_text_to_braille: translation table not initialized\n");
		return 0;
	}

	return 1;

}
#endif

/* Device Related Functions */

/* Device Callback */
void DeviceCallback (BRAILLE_EVENT_CODE Code, BRAILLE_EVENT_DATA *Data)
{
	/* call the client callback */
	/* NOTE: could add some preprocessing here */
	if (ClientEventProc) ClientEventProc (Code, Data);
}

/* API Functions */

int brl_open_device (char *DeviceName, int Port, BRAILLE_EVENT_PROC EventProc)
{

	int rv = 1;
	
	/* store the client callback */
	ClientEventProc = EventProc;

	/* create an empty BRL_DEVICE structure */
	CurrentDevice = calloc (sizeof(BRL_DEVICE), sizeof(unsigned char));
	
	if (CurrentDevice)
	{
		/* !!! TBR !!! rewrite this for a plugin architecture */
		/* load_library */
		/* open_device */
		

		/* if (stricmp("VARIO", DeviceName) == 0) */
		if (	strcmp("VARIO", DeviceName) == 0 ||	/* same as VARIO 40 */
				strcmp("VARIO40", DeviceName) == 0 ||
				strcmp("VARIO20", DeviceName) == 0 ||
				strcmp("VARIO80", DeviceName) == 0 ||
				strcmp("DM80P", DeviceName) == 0 ||
				strcmp("INKA", DeviceName) == 0
			)
		{
			rv = baum_brl_open_device (DeviceName, Port, DeviceCallback, CurrentDevice);
		}	

		else if (	strcmp("ALVA380", DeviceName) == 0 ||
							strcmp("ALVA544", DeviceName) == 0 ||
							strcmp("ALVA570", DeviceName) == 0 )
		{			
			rv = alva_brl_open_device (DeviceName, Port, DeviceCallback, CurrentDevice);			
		}
		
		else if (strcmp("PB40", DeviceName) == 0)
		{
			/* rv = tsc_open_device (DeviceName, Port, CurrentDevice, deviceCallback);		 */
		}

		/* else if */
		else
		{
			/* unknown device */
			fprintf (stderr, "brl_open_device: unknown device\n");
			rv = 0;
			/* errno = */
		}		

		if (rv)
		{
			/* allocate the the rest of the resources here */

			/* Text = calloc (CurrentDevice->CellCount, sizeof (char)); */
			/* memset (Text, ' ', CurrentDevice->CellCount * sizeof (char)); */
			/* Attrs = calloc (CurrentDevice->CellCount, sizeof (unsigned long)); */
			Dots = calloc (CurrentDevice->CellCount, sizeof (unsigned char));

			/* assert (Text && Attrs && Dots); */

			/* clear all cells			 */
      CurrentDevice->send_dots(Dots, CurrentDevice->CellCount, 1);	/* blocking send ;-) */
		}
		else
		{
			fprintf (stderr, "brl_open_device: open device failed\n");	/* !!! TBR !!! be more explicit here */
			brl_close_device();
		}
	
	}

	{
	    gint i, cnt;
	    cnt = 0;
	    for (i = 0; i < CurrentDevice->DisplayCount; i++)
	    {
/*
		fprintf (stderr, "\nDISPLAY %d from %d to %d", i, 
			(CurrentDevice->Displays[i]).StartCell,
			(CurrentDevice->Displays[i]).Width);
*/
		cnt += (CurrentDevice->Displays[i]).Width;
	    }
	    if (cnt != CurrentDevice->CellCount)
		fprintf (stderr, "\nIncorrect technical data for device %s", 
							    DeviceName);
	    g_assert (cnt == CurrentDevice->CellCount);
	}

	return rv;
}

int brl_get_device (BRL_DEVICE *Device)
{
	if (CurrentDevice)
	{
		memcpy (Device, CurrentDevice, sizeof (BRL_DEVICE));
		return 1;
	}
	else
	{
		fprintf (stderr, "brl_get_device: no device opened");	/* !!! TBR !!! be more explicit here */
		return 0;
	}

}

void brl_close_device ()
{
	if (CurrentDevice)
	{		
		if(CurrentDevice->close_device) CurrentDevice->close_device();
		free (CurrentDevice);
		CurrentDevice = NULL;
	}
	ClientEventProc = NULL;
}

short brl_get_disp_id (char* Role, short No)
{
	int i;
	short rv = -1;
	short type_no = -1;
	
	if (CurrentDevice)
	{
		
		if (Role)
		{
			/* we have a role, search for that role + displayNo */
			for (i = 0; i < CurrentDevice->DisplayCount ; ++i)
			{
 			
  				if ( (strcasecmp (Role, "main") == 0 ) && (CurrentDevice->Displays[i].Type == bdt_main))
        		{        		
        			++type_no;
        			if (type_no == No)
        			{
       				rv = i;
       				break;
       			}
       		}
      			else if ((strcasecmp (Role, "status") == 0 ) && (CurrentDevice->Displays[i].Type == bdt_status))
      			{
	      			++type_no;
	      			if (type_no == No)
        			{
       				rv = i;
       				break;
       			}
      			}
     			else if ((strcasecmp (Role, "auxh") == 0 ) && (CurrentDevice->Displays[i].Type == bdt_aux_horizontal))
     			{
     				++type_no;
     				if (type_no == No)
        			{
       				rv = i;
       				break;
       			}
     			}
      			else if ((strcasecmp (Role, "auxv") == 0 ) && (CurrentDevice->Displays[i].Type == bdt_aux_vertical))
      			{
      				++type_no;
      				if (type_no == No)
        			{
       				rv = i;
       				break;
       			}
      			}
 			
 			}	/* end for */
 		}	
 		else
 		{
 			/* no role, the No is the ID if validated */
 			if (No < CurrentDevice->DisplayCount)
 			{
 				rv = No;
 			}
 		}
	}
	
	return rv;
	
}

void brl_clear_all()
{

	
	if ( CurrentDevice &&
	 	  Dots )
	{				
		memset (&Dots[0], 0, CurrentDevice->CellCount);
	}
	
}

void brl_clear_display (short Display)
{
	BRL_DISPLAY *brd;
	
	/* set to 0 all the cells coresponding to the display */
	if (	Display < (CurrentDevice->DisplayCount) &&
			Display >= 0  &&
			CurrentDevice &&
			Dots)
	{		
		brd = &(CurrentDevice->Displays[Display]);
		memset (&Dots[brd->StartCell], 0, brd->Width);
	}
	
}

void brl_set_dots (short Display, short StartCell, unsigned char *newDots, short CellCount, short Offset, short CursorPosition)
{

	BRL_DISPLAY *brd;

	/* !!! TBI !!! consider offset (i.e. for panning support) */
	
	if (	Display >= 0 &&
			Display < (CurrentDevice->DisplayCount) &&			
			CurrentDevice &&
		 	CurrentDevice->send_dots &&
			Dots &&
			newDots)
	{
			
		brd = &(CurrentDevice->Displays[Display]);
		
		if (	(StartCell >= 0) &&
					(StartCell < brd->Width))
		{
			

      if ((CellCount - Offset) > 0 )  /* accept only offsets smaller then cell count */
			{

        /* automatically adjust the offset to keep cursor visible */

        if (CursorPosition >= 0 && Offset == 0)  /* only if cursor AND no explicit offset...*/
        {
          /* adjust the offset to keep cursor visible */
          Offset = CursorPosition - brd->Width + 1; /* !!! TBR !!! need something smarter here !!! (i.e consider previous pos) */
          if (Offset < 0) Offset = 0;

          /* fprintf (stderr, "Auto offset %d\n", Offset); */

        }

			  if (CellCount > (brd->Width - StartCell + Offset)) CellCount = brd->Width - StartCell + Offset;
			  if (CellCount < 0) CellCount = 0;

        /* clamp cell count to actual display width */			

			  /* fprintf(stderr, "BRL: set dots: cell_cnt:%d, st:%d, off:%d\n", CellCount, StartCell, Offset); */
        memcpy (&Dots[brd->StartCell + StartCell], &newDots[Offset], CellCount - Offset);

        /* !!! TBI !!! fire a callback here */
			}
		}		
	}

}

void brl_update_dots (short Blocking)
{

	if (CurrentDevice && Dots)
	{
		/* send all dots at once */
		CurrentDevice->send_dots(Dots, CurrentDevice->CellCount, Blocking);
	}

}

/* Braille Specific Functions */
