/* gok-input.c
*
* Copyright 2002 Sun Microsystems, Inc.,
* Copyright 2002 University Of Toronto
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Library General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public
* License along with this library; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gconf/gconf-client.h>
#include "gok-gconf-keys.h"
#include "gok-log.h"
#include "gok-input.h"
#include "gok-gconf.h"
#include "main.h"

GSList *
gok_input_get_device_list (void)
{
  GSList       *pList = NULL;
#ifdef HAVE_XINPUT
  XDeviceInfo  *devices;
#endif
  int		i;
  int		num_devices;
  Display      *display;
  GtkWidget    *pMainWindow = gok_main_get_main_window ();

#ifdef HAVE_XINPUT
  if (pMainWindow && pMainWindow->window) {
	  display = GDK_WINDOW_XDISPLAY (pMainWindow->window); 
	  devices = XListInputDevices(display, &num_devices);
	  for (i = 0; i < num_devices; i++) {
		  GokInput *pInput;
		  if (devices[i].use == IsXExtensionDevice) {
			  pInput = g_new0 (GokInput, 1);
			  pInput->name = devices[i].name;
			  pInput->info = &devices[i];
			  pList = g_slist_prepend (pList, pInput);
		  }
	  }
	  /* TODO: do we need to free the XDeviceInfo list? */
  }
#endif
  return pList;
}

#ifdef HAVE_XINPUT
static XDeviceInfo*
find_device_info(Display	*display,
		 char		*name,
		 gboolean       extended_only)
{
	XDeviceInfo	*devices;
	int		i;
	int		num_devices;
	int		len = strlen(name);
	
	devices = XListInputDevices(display, &num_devices);
	
	for(i = 0; i < num_devices; i++) {
		if (extended_only)
			if (devices[i].use != IsXExtensionDevice)
				continue;

		if (!strcmp(devices[i].name, name))
			return &devices[i];
	}
	return NULL;
}

#endif

gboolean
gok_input_init (GokInput *input, GdkFilterFunc filter_func)
{
#ifdef HAVE_XINPUT
	XEventClass      event_list[20];
	int              i, number = 0; 
	GtkWidget       *window = gok_main_get_main_window ();
	Display         *display;
	GdkWindow       *root;
	
	if (!gok_input_open (input))
	{
		g_warning ("Cannot open input device!\n");
		return FALSE;
	}
	
	for (i=0; i < input->info->num_classes; i++) 
	{
		switch (input->device->classes[i].input_class) 
		{
		case KeyClass:
			DeviceKeyPress(input->device, 
				       gok_input_types[GOK_INPUT_TYPE_KEY_PRESS], 
				       event_list[number]); number++;
			DeviceKeyRelease(input->device, 
					 gok_input_types[GOK_INPUT_TYPE_KEY_RELEASE], 
					 event_list[number]); number++;
			break;      
		case ButtonClass:
			DeviceButtonPress(input->device, 
					  gok_input_types[GOK_INPUT_TYPE_BUTTON_PRESS], 
					  event_list[number]); number++;
			DeviceButtonRelease(input->device, 
					    gok_input_types[GOK_INPUT_TYPE_BUTTON_RELEASE], 
					    event_list[number]); number++;
			break;
		case ValuatorClass:
			DeviceMotionNotify(input->device, 
					   gok_input_types[GOK_INPUT_TYPE_MOTION], 
					   event_list[number]); number++;
		}
	}
	printf ("%d event types available\n", number);
	
	root = gdk_screen_get_root_window (gdk_drawable_get_screen (window->window));
	
	if (XSelectExtensionEvent(GDK_WINDOW_XDISPLAY (root), 
				  GDK_WINDOW_XWINDOW (root),
				  event_list, number)) 
	{
		g_warning ("Can't connect to input device!");
		return FALSE;
	}
	
	gdk_window_add_filter (root,
			       filter_func,
			       NULL);
	return TRUE;
#else
	return FALSE;
#endif
}

gboolean
gok_input_set_extension_device_by_name (char *name)
{
	gok_gconf_set_string (gconf_client_get_default(), 
			      GOK_GCONF_INPUT_DEVICE,
			      name);
	return TRUE;
}

gchar *
gok_input_get_extension_device_name (void)
{
        gchar *cp;
        if (gok_gconf_get_string (gconf_client_get_default(), 
				  GOK_GCONF_INPUT_DEVICE,
				  &cp)) {
	        return cp;
	}
	else
	        return NULL;
}

void
gok_input_free (GokInput *pInput)
{
	/* FIXME */
	;
}

GokInput * 
gok_input_find_by_name (char *name, gboolean extended_only)
{
  GtkWidget *window = gok_main_get_main_window ();
  GokInput *input = NULL;
#ifdef HAVE_XINPUT
  XDeviceInfo *device = NULL;
  
  if (window && window->window) 
    {
      device = find_device_info (GDK_WINDOW_XDISPLAY (window->window), name, extended_only);
    }
  if (device)
    {
      input = g_new0 (GokInput, 1); 
      input->info = device;
      input->name = g_strndup (name, 128);
    }
#endif
  return input;
}

gboolean   
gok_input_open (GokInput *input)
{
  GtkWidget *window = gok_main_get_main_window ();
#ifdef HAVE_XINPUT  
  if (window && window->window && 
      input && input->info && (input->info->use == IsXExtensionDevice))
    {
      input->device = XOpenDevice(GDK_WINDOW_XDISPLAY (window->window), 
				  input->info->id);
      return TRUE;
    }
#endif
  return FALSE;
}

GokInput * gok_input_get_current (void)
{
  char *input_device_name;
  GokInput *input;
  gok_gconf_get_string (gconf_client_get_default (), 
			GOK_GCONF_INPUT_DEVICE, 
			&input_device_name);
  input = gok_input_find_by_name (input_device_name, TRUE);
  g_free (input_device_name);
  return input;
}
