# NMake Makefile portion for code generation and
# intermediate build directory creation
# Items in here should not need to be edited unless
# one is maintaining the NMake build files.

.SUFFIXES: .xml.in .xml .po .mo

.\outputdir:
	@if not exist $@\ mkdir $@

# Generate the final xml files
{..\schemas\}.xml.in{.\outputdir\}.xml:
	@if not exist .\outputdir\ $(MAKE) /f Makefile.vc .\outputdir
	$(PYTHON) genschema.py --input=$< --output=$@ --package=$(GETTEXT_PACKAGE) $(GENSCHEMA_DATADIR_ARG)

.\outputdir\org.gnome.desktop.enums.xml: ..\headers\gdesktop-enums.h .\outputdir
	$(GLIB_MKENUMS_INTERP) $(GLIB_MKENUMS) --comments "<!-- @comment@ -->"	\
	--fhead "<schemalist>"	\
	--vhead "  <@type@ id='org.gnome.desktop.@EnumName@'>"	\
	--vprod "    <value nick='@valuenick@' value='@valuenum@'/>"	\
	--vtail "  </@type@>" --ftail "</schemalist>" ..\headers\gdesktop-enums.h	\
	> $@

.\outputdir\gsettings-desktop-schemas.pc: ..\gsettings-desktop-schemas.pc.in .\outputdir
	@echo Generating $@...
	$(PYTHON) genpc.py --prefix=$(PREFIX) --version=$(PACKAGE_VERSION)

# Generate the gettext translated files (*.mo).  This is not generated by
# default as this requires intltool which can be hard to install on Windows,
# and it needs certain utilities from MSYS2 or Cygwin (the file.exe utility,
# for instance) to be in your PATH.  The XML::Parser module is needed for it
# to work.
{..\po\}.po{.\outputdir\}.mo:
	@set INTLTOOL_EXTRACT=$(INTLTOOL_EXTRACT)
	@if not "$(XGETTEXT)" == "" set XGETTEXT=$(XGETTEXT)
	@cd ..\po
	@if not exist $(GETTEXT_PACKAGE).pot $(PERL) $(INTLTOOL_UPDATE) --gettext-package $(GETTEXT_PACKAGE) --pot
	$(PERL) $(INTLTOOL_UPDATE) --gettext-package $(GETTEXT_PACKAGE) --dist -o ..\win32\$@ $(<B)
	@cd ..\win32
