// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MIXER_H
#define _GSTREAMERMM_MIXER_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/interfaces/mixeroptions.h>
#include <gstreamermm/mixertrack.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstMixer GstMixer;
typedef struct _GstMixerClass GstMixerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Mixer_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum MixerType
{
  MIXER_HARDWARE,
  MIXER_SOFTWARE
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MixerType> : public Glib::Value_Enum<Gst::MixerType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MixerFlags operator|(MixerFlags, MixerFlags)</tt><br>
 * <tt>%MixerFlags operator&(MixerFlags, MixerFlags)</tt><br>
 * <tt>%MixerFlags operator^(MixerFlags, MixerFlags)</tt><br>
 * <tt>%MixerFlags operator~(MixerFlags)</tt><br>
 * <tt>%MixerFlags& operator|=(MixerFlags&, MixerFlags)</tt><br>
 * <tt>%MixerFlags& operator&=(MixerFlags&, MixerFlags)</tt><br>
 * <tt>%MixerFlags& operator^=(MixerFlags&, MixerFlags)</tt><br>
 */
enum MixerFlags
{
  MIXER_FLAG_NONE = 0,
  MIXER_FLAG_AUTO_NOTIFICATIONS = 1<<0
};

/** @ingroup gstreamermmEnums */
inline MixerFlags operator|(MixerFlags lhs, MixerFlags rhs)
  { return static_cast<MixerFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MixerFlags operator&(MixerFlags lhs, MixerFlags rhs)
  { return static_cast<MixerFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MixerFlags operator^(MixerFlags lhs, MixerFlags rhs)
  { return static_cast<MixerFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MixerFlags operator~(MixerFlags flags)
  { return static_cast<MixerFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MixerFlags& operator|=(MixerFlags& lhs, MixerFlags rhs)
  { return (lhs = static_cast<MixerFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MixerFlags& operator&=(MixerFlags& lhs, MixerFlags rhs)
  { return (lhs = static_cast<MixerFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MixerFlags& operator^=(MixerFlags& lhs, MixerFlags rhs)
  { return (lhs = static_cast<MixerFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MixerFlags> : public Glib::Value_Flags<Gst::MixerFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum MixerMessageType
{
  MIXER_MESSAGE_INVALID,
  MIXER_MESSAGE_MUTE_TOGGLED,
  MIXER_MESSAGE_RECORD_TOGGLED,
  MIXER_MESSAGE_VOLUME_CHANGED,
  MIXER_MESSAGE_OPTION_CHANGED,
  MIXER_MESSAGE_OPTIONS_LIST_CHANGED,
  MIXER_MESSAGE_MIXER_CHANGED
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MixerMessageType> : public Glib::Value_Enum<Gst::MixerMessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


class MixerOptions;
class MixerTrack;

/** Gst::Mixer - Interface for elements that provide mixer operations.
 * @ingroup GstInterfaces
 */

class Mixer : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Mixer CppObjectType;
  typedef Mixer_Class CppClassType;
  typedef GstMixer BaseObjectType;
  typedef GstMixerClass BaseClassType;

private:
  friend class Mixer_Class;
  static CppClassType mixer_class_;

  // noncopyable
  Mixer(const Mixer&);
  Mixer& operator=(const Mixer&);

protected:
  Mixer(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Mixer(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Mixer(GstMixer* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Mixer();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstMixer*       gobj()       { return reinterpret_cast<GstMixer*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GstMixer* gobj() const { return reinterpret_cast<GstMixer*>(gobject_); }

private:


public:
 

  /** Returns: A List consisting of zero or more Gst::MixerTracks.
   * @return A List consisting of zero or more Gst::MixerTracks.
   */
  Glib::ListHandle< Glib::RefPtr<Gst::MixerTrack> > list_tracks();

 
  /** Returns: A List consisting of zero or more Gst::MixerTracks.
   * @return A List consisting of zero or more Gst::MixerTracks.
   */
  Glib::ListHandle< Glib::RefPtr<const Gst::MixerTrack> > list_tracks() const;

  /** Get the current volume(s) on the given track.
   *
   * @param track the Gst::MixerTrack to get the volume from.
   * @return an array of integers (of size track->num_channels) to with the
   * current volume of each channel in the given track. 
   */
  Glib::ArrayHandle<int> get_volume(const Glib::RefPtr<const Gst::MixerTrack>& track) const;
  

  /** Sets the volume on each channel in a track. Short note about
   * naming: a track is defined as one separate stream owned by
   * the mixer/element, such as 'Line-in' or 'Microphone'. A
   * channel is said to be a mono-stream inside this track. A
   * stereo track thus contains two channels.
   * @param track The Gst::MixerTrack to set the volume on.
   * @param volumes An array of integers (of size track->num_channels)
   * that gives the wanted volume for each channel in
   * this track.
   */
  void set_volume(const Glib::RefPtr<Gst::MixerTrack>& track, const Glib::ArrayHandle<int>& volumes);

  
  /** Mutes or unmutes the given channel. To find out whether a
   * track is currently muted, use GST_MIXER_TRACK_HAS_FLAG ().
   * @param track The Gst::MixerTrack to operate on.
   * @param mute A boolean value indicating whether to turn on or off
   * muting.
   */
  void set_mute(const Glib::RefPtr<Gst::MixerTrack>& track, bool mute);
  
  /** Enables or disables recording on the given track. Note that
   * this is only possible on input tracks, not on output tracks
   * (see GST_MIXER_TRACK_HAS_FLAG () and the GST_MIXER_TRACK_INPUT
   * flag).
   * @param track The Gst::MixerTrack to operate on.
   * @param record A boolean value that indicates whether to turn on
   * or off recording.
   */
  void set_record(const Glib::RefPtr<Gst::MixerTrack>& track, bool record);
  
  /** Sets a name/value option in the mixer to the requested value.
   * @param opts The Gst::MixerOptions that we operate on.
   * @param value The requested new option value.
   */
  void set_option(const Glib::RefPtr<Gst::MixerOptions>& opts, const Glib::ustring& value);
  
  /** This function is called by the mixer implementation to produce
   * a notification message on the bus indicating that the given track
   * has changed mute state.
   * 
   * This function only works for GstElements that are implementing the
   * GstMixer interface, and the element needs to have been provided a bus.
   * @param track The GstMixerTrack that has change mute state.
   * @param mute The new state of the mute flag on the track.
   */
  void mute_toggled(const Glib::RefPtr<Gst::MixerTrack>& track, bool mute);
  
  /** This function is called by the mixer implementation to produce
   * a notification message on the bus indicating that the given track
   * has changed recording state.
   * 
   * This function only works for GstElements that are implementing the
   * GstMixer interface, and the element needs to have been provided a bus.
   * @param track The GstMixerTrack that has changed recording state.
   * @param record The new state of the record flag on the track.
   */
  void record_toggled(const Glib::RefPtr<Gst::MixerTrack>& track, bool record);
  
  /** This function is called by the mixer implementation to produce
   * a notification message on the bus indicating that the volume(s) for the
   * given track have changed.
   * 
   * This function only works for GstElements that are implementing the
   * GstMixer interface, and the element needs to have been provided a bus.
   * @param track The GstMixerTrack that has changed.
   * @param volumes Array of volume values, one per channel on the mixer track.
   */
  void volume_changed(const Glib::RefPtr<Gst::MixerTrack>& track, const Glib::ArrayHandle<int>& volumes);
  
  /** This function is called by the mixer implementation to produce
   * a notification message on the bus indicating that the given options
   * object has changed state. 
   * 
   * This function only works for GstElements that are implementing the
   * GstMixer interface, and the element needs to have been provided a bus.
   * @param opts The GstMixerOptions that has changed value.
   * @param value The new value of the GstMixerOptions.
   */
  void option_changed(const Glib::RefPtr<Gst::MixerOptions>& opts, const Glib::ustring& value);
  
  /** This function is called by the mixer implementation to produce
   * a notification message on the bus indicating that the list of possible
   * options of a given options object has changed.
   * 
   * The new options are not contained in the message on purpose. Applications
   * should call gst_mixer_option_get_values() on @a opts to make @a opts update
   * its internal state and obtain the new list of values.
   * 
   * This function only works for GstElements that are implementing the
   * GstMixer interface, and the element needs to have been provided a bus
   * for this to work.
   * 
   * Since: 0.10.18
   * @param opts The GstMixerOptions whose list of values has changed.
   */
  void options_list_changed(const Glib::RefPtr<Gst::MixerOptions>& opts);
  
  /** Get the current value of a name/value option in the mixer.
   * @param opts The Gst::MixerOptions that we operate on.
   * @return Current value of the name/value option.
   */
  Glib::ustring get_option(const Glib::RefPtr<const Gst::MixerOptions>& opts) const;
  
  /** This function is called by the mixer implementation to produce
   * a notification message on the bus indicating that the list of available
   * mixer tracks for a given mixer object has changed. Applications should
   * rebuild their interface when they receive this message.
   * 
   * This function only works for GstElements that are implementing the
   * GstMixer interface, and the element needs to have been provided a bus.
   * 
   * Since: 0.10.18
   */
  void mixer_changed();
  
  /** Get the set of supported flags for this mixer implementation.
   * @return A set of or-ed GstMixerFlags for supported features.
   */
  Gst::MixerFlags get_mixer_flags() const;

  /* TODO:
  _WRAP_METHOD(satic Gst::MixerMessageType message_get_type(GstMessage *message), gst_mixer_message_get_type)
  _WRAP_METHOD(static void message_parse_mute_toggled(GstMessage *message, GstMixerTrack **track, gboolean *mute), gst_mixer_message_parse_mute_toggled)
  _WRAP_METHOD(static void message_parse_option_changed(GstMessage *message, GstMixerOptions **options, const gchar **value), gst_mixer_message_parse_option_changed)
  _WRAP_METHOD(static void message_parse_record_toggled(GstMessage *message, GstMixerTrack **track, gboolean *record), gst_mixer_message_parse_record_toggled)
  _WRAP_METHOD(static void message_parse_volume_changed(GstMessage *message, GstMixerTrack **track, gint **volumes, gint *num_channels), gst_mixer_message_parse_volume_changed)
  _WRAP_METHOD(static void message_parse_options_list_changed(GstMessage *message, GstMixerOptions **options), gst_mixer_message_parse_options_list_changed)
  */

//TODO:
//#m4 __CONVERSION(`Glib::ListHandle< Glib::RefPtr<Gst::MixerTrack> >', `const GList*', `($3).data()')
  //_WRAP_VFUNC(Glib::ListHandle< Glib::RefPtr<Gst::MixerTrack> > list_tracks() const, "list_tracks")

#ifdef GLIBMM_VFUNCS_ENABLED
// This vfunc is handcoded because we want to have it return the result instead
// of requiring a pointer parameter in which to put it like the C API does.
  virtual Glib::ArrayHandle<int> get_volume_vfunc(const Glib::RefPtr<const Gst::MixerTrack>& track) const;
#endif //GLIBMM_VFUNCS_ENABLED

 
//TODO:
  //_WRAP_VFUNC(void set_volume(const Glib::RefPtr<Gst::MixerTrack>& track, const Glib::ArrayHandle<int>& volumes), "set_volume")

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_mute_vfunc(const Glib::RefPtr<Gst::MixerTrack>& track, bool mute);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_record_vfunc(const Glib::RefPtr<Gst::MixerTrack>& track, bool record);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_option_vfunc(const Glib::RefPtr<Gst::MixerOptions>& opts, const Glib::ustring& value);
#endif //GLIBMM_VFUNCS_ENABLED


  //TODO:
  //_WRAP_VFUNC(Glib::ustring get_option(const Glib::RefPtr<const Gst::MixerOptions>& opts) const, "get_option")

protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Mixer
   */
  Glib::RefPtr<Gst::Mixer> wrap(GstMixer* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_MIXER_H */

