// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_COLORBALANCE_H
#define _GSTREAMERMM_COLORBALANCE_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/interfaces/colorbalance.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstColorBalance GstColorBalance;
typedef struct _GstColorBalanceClass GstColorBalanceClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class ColorBalance_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum ColorBalanceType
{
  COLOR_BALANCE_HARDWARE,
  COLOR_BALANCE_SOFTWARE
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ColorBalanceType> : public Glib::Value_Enum<Gst::ColorBalanceType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


class ColorBalanceChannel;

/** Gst::ColorBalance - Interface for adjusting color balance settings.
 * @ingroup GstInterfaces
 */

class ColorBalance : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ColorBalance CppObjectType;
  typedef ColorBalance_Class CppClassType;
  typedef GstColorBalance BaseObjectType;
  typedef GstColorBalanceClass BaseClassType;

private:
  friend class ColorBalance_Class;
  static CppClassType colorbalance_class_;

  // noncopyable
  ColorBalance(const ColorBalance&);
  ColorBalance& operator=(const ColorBalance&);

protected:
  ColorBalance(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit ColorBalance(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit ColorBalance(GstColorBalance* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ColorBalance();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstColorBalance*       gobj()       { return reinterpret_cast<GstColorBalance*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GstColorBalance* gobj() const { return reinterpret_cast<GstColorBalance*>(gobject_); }

private:


public:
 

  /** Retrieve a list of the available channels.
   * @return A GList containing pointers to Gst::ColorBalanceChannel objects.
   * The list is owned by the Gst::ColorBalance instance and must not
   * be freed.
   */
  Glib::ListHandle< Glib::RefPtr<ColorBalanceChannel> > list_channels();

 
  /** Retrieve a list of the available channels.
   * @return A GList containing pointers to Gst::ColorBalanceChannel objects.
   * The list is owned by the Gst::ColorBalance instance and must not
   * be freed.
   */
  Glib::ListHandle< Glib::RefPtr<const ColorBalanceChannel> > list_channels() const;

  
  /** Retrieve the current value of the indicated channel, between min_value
   * and max_value.
   * 
   * See Also: The Gst::ColorBalanceChannel::min_value and
   * Gst::ColorBalanceChannel::max_value members of the
   * Gst::ColorBalanceChannel object.
   * @param channel A Gst::ColorBalanceChannel instance.
   * @return The current value of the channel.
   */
  int get_value(const Glib::RefPtr<const ColorBalanceChannel>& channel) const;
  
  /** Sets the current value of the channel to the passed value, which must
   * be between min_value and max_value.
   * 
   * See Also: The Gst::ColorBalanceChannel::min_value and
   * Gst::ColorBalanceChannel::max_value members of the
   * Gst::ColorBalanceChannel object.
   * @param channel A Gst::ColorBalanceChannel instance.
   * @param value The new value for the channel.
   */
  void set_value(const Glib::RefPtr<ColorBalanceChannel>& channel, int value);
  
  /** A helper function called by implementations of the GstColorBalance
   * interface. It fires the Gst::ColorBalance::value-changed signal on the
   * instance, and the Gst::ColorBalanceChannel::value-changed signal on the
   * channel object.
   * @param channel A Gst::ColorBalanceChannel whose value has changed.
   * @param value The new value of the channel.
   */
  void value_changed(const Glib::RefPtr<ColorBalanceChannel>& channel, int value);
  
  /** Get the Gst::ColorBalanceType of this implementation.
   * @return A the Gst::ColorBalanceType.
   * 
   * Since: 0.10.24.
   */
  Gst::ColorBalanceType get_balance_type() const;

 
  /** Fired when the value of the indicated channel has changed.
   *
   * @par Prototype:
   * <tt>void on_my_%value_changed(const Glib::RefPtr<ColorBalanceChannel>& channel, int value)</tt>
   */

  Glib::SignalProxy2< void,const Glib::RefPtr<ColorBalanceChannel>&,int > signal_value_changed();


#ifdef GLIBMM_VFUNCS_ENABLED
  /** Lists the channels of the Gst::ColorBalance.
   */
  virtual Glib::ListHandle< Glib::RefPtr<ColorBalanceChannel> > list_channels_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  /** Sets the value of a Gst::ColorBalanceChannel of the Gst::ColorBalance.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_value_vfunc(const Glib::RefPtr<ColorBalanceChannel>& channel, int value);
#endif //GLIBMM_VFUNCS_ENABLED


  /** Gets the value of a Gst::ColorBalanceChannel of the Gst::ColorBalance.
   */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual int get_value_vfunc(const Glib::RefPtr<const ColorBalanceChannel>& channel) const;
#endif //GLIBMM_VFUNCS_ENABLED


protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_value_changed(const Glib::RefPtr<ColorBalanceChannel>& channel, int value);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::ColorBalance
   */
  Glib::RefPtr<Gst::ColorBalance> wrap(GstColorBalance* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_COLORBALANCE_H */

