// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MIXERTRACK_H
#define _GSTREAMERMM_MIXERTRACK_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstMixerTrack GstMixerTrack;
typedef struct _GstMixerTrackClass GstMixerTrackClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class MixerTrack_Class; } // namespace Gst
namespace Gst
{

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MixerTrackFlags operator|(MixerTrackFlags, MixerTrackFlags)</tt><br>
 * <tt>%MixerTrackFlags operator&(MixerTrackFlags, MixerTrackFlags)</tt><br>
 * <tt>%MixerTrackFlags operator^(MixerTrackFlags, MixerTrackFlags)</tt><br>
 * <tt>%MixerTrackFlags operator~(MixerTrackFlags)</tt><br>
 * <tt>%MixerTrackFlags& operator|=(MixerTrackFlags&, MixerTrackFlags)</tt><br>
 * <tt>%MixerTrackFlags& operator&=(MixerTrackFlags&, MixerTrackFlags)</tt><br>
 * <tt>%MixerTrackFlags& operator^=(MixerTrackFlags&, MixerTrackFlags)</tt><br>
 */
enum MixerTrackFlags
{
  MIXER_TRACK_INPUT = 1<<0,
  MIXER_TRACK_OUTPUT = 1<<1,
  MIXER_TRACK_MUTE = 1<<2,
  MIXER_TRACK_RECORD = 1<<3,
  MIXER_TRACK_MASTER = 1<<4,
  MIXER_TRACK_SOFTWARE = 1<<5,
  MIXER_TRACK_NO_RECORD = 1<<6,
  MIXER_TRACK_NO_MUTE = 1<<7,
  MIXER_TRACK_WHITELIST = 1<<8
};

/** @ingroup gstreamermmEnums */
inline MixerTrackFlags operator|(MixerTrackFlags lhs, MixerTrackFlags rhs)
  { return static_cast<MixerTrackFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MixerTrackFlags operator&(MixerTrackFlags lhs, MixerTrackFlags rhs)
  { return static_cast<MixerTrackFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MixerTrackFlags operator^(MixerTrackFlags lhs, MixerTrackFlags rhs)
  { return static_cast<MixerTrackFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MixerTrackFlags operator~(MixerTrackFlags flags)
  { return static_cast<MixerTrackFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MixerTrackFlags& operator|=(MixerTrackFlags& lhs, MixerTrackFlags rhs)
  { return (lhs = static_cast<MixerTrackFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MixerTrackFlags& operator&=(MixerTrackFlags& lhs, MixerTrackFlags rhs)
  { return (lhs = static_cast<MixerTrackFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MixerTrackFlags& operator^=(MixerTrackFlags& lhs, MixerTrackFlags rhs)
  { return (lhs = static_cast<MixerTrackFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MixerTrackFlags> : public Glib::Value_Flags<Gst::MixerTrackFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** Gst::MixerTrack - A track in an element that implement the Gst::Mixer
 * interface.
 * @ingroup GstInterfaces
 */

class MixerTrack : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef MixerTrack CppObjectType;
  typedef MixerTrack_Class CppClassType;
  typedef GstMixerTrack BaseObjectType;
  typedef GstMixerTrackClass BaseClassType;

private:  friend class MixerTrack_Class;
  static CppClassType mixertrack_class_;

private:
  // noncopyable
  MixerTrack(const MixerTrack&);
  MixerTrack& operator=(const MixerTrack&);

protected:
  explicit MixerTrack(const Glib::ConstructParams& construct_params);
  explicit MixerTrack(GstMixerTrack* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~MixerTrack();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstMixerTrack*       gobj()       { return reinterpret_cast<GstMixerTrack*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstMixerTrack* gobj() const { return reinterpret_cast<GstMixerTrack*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstMixerTrack* gobj_copy();

private:


public:
  /** Get a string containing a descriptive name for this track.
   */
   Glib::ustring get_label() const;
   /** Get the number of channels in the Gst::MixerTrack.
   */
   guint32 get_num_channels() const;
 
  /** Get minimum volume of in the Gst::MixerTrack.
   */
   guint32 get_min_volume() const;
 
  /** Get the maximum volume of the Gst::MixerTrack.
   */
   guint32 get_max_volume() const;
 
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags indicating the type of mixer track.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Track index.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_index() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The label assigned to the track (may be translated).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The maximum possible volume level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_volume() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The minimum possible volume level.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_min_volume() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of channels contained within the track.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_num_channels() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The untranslated label assigned to the track (since 0.10.13).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_untranslated_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::MixerTrack
   */
  Glib::RefPtr<Gst::MixerTrack> wrap(GstMixerTrack* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_MIXERTRACK_H */

