// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_PAD_H
#define _GSTREAMERMM_PAD_H


#include <glibmm.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstpad.h>
#include <gstreamermm/object.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/format.h>
#include <gstreamermm/query.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstPad GstPad;
typedef struct _GstPadClass GstPadClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Pad_Class; } // namespace Gst
namespace Gst
{

class Buffer;
class Caps;
class Element;
class Event;
class PadTemplate;
class Query;

//Gst::Iterator<> forward declaration.
template <class CppType>
class Iterator;

/** @addtogroup gstreamermmEnums Enums and Flags */

/**
 * @ingroup gstreamermmEnums
 */
enum PadDirection
{
  PAD_UNKNOWN,
  PAD_SRC,
  PAD_SINK
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadDirection> : public Glib::Value_Enum<Gst::PadDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum PadFlags
{
  PAD_BLOCKED = GST_OBJECT_FLAG_LAST << 0,
  PAD_FLUSHING = GST_OBJECT_FLAG_LAST << 1,
  PAD_IN_GETCAPS = GST_OBJECT_FLAG_LAST << 2,
  PAD_IN_SETCAPS = GST_OBJECT_FLAG_LAST << 3,
  PAD_BLOCKING = GST_OBJECT_FLAG_LAST << 4,
  PAD_FLAG_LAST = GST_OBJECT_FLAG_LAST << 8
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadFlags> : public Glib::Value_Enum<Gst::PadFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum PadLinkReturn
{
  PAD_LINK_OK = 0,
  PAD_LINK_WRONG_HIERARCHY = -1,
  PAD_LINK_WAS_LINKED = -2,
  PAD_LINK_WRONG_DIRECTION = -3,
  PAD_LINK_NOFORMAT = -4,
  PAD_LINK_NOSCHED = -5,
  PAD_LINK_REFUSED = -6
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::PadLinkReturn> : public Glib::Value_Enum<Gst::PadLinkReturn>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum FlowReturn
{
  FLOW_CUSTOM_SUCCESS = 100,
  FLOW_RESEND = 1,
  FLOW_OK = 0,
  FLOW_NOT_LINKED = -1,
  FLOW_WRONG_STATE = -2,
  FLOW_UNEXPECTED = -3,
  FLOW_NOT_NEGOTIATED = -4,
  FLOW_ERROR = -5,
  FLOW_NOT_SUPPORTED = -6,
  FLOW_CUSTOM_ERROR = -100
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::FlowReturn> : public Glib::Value_Enum<Gst::FlowReturn>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/**
 * @ingroup gstreamermmEnums
 */
enum ActivateMode
{
  ACTIVATE_NONE,
  ACTIVATE_PUSH,
  ACTIVATE_PULL
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::ActivateMode> : public Glib::Value_Enum<Gst::ActivateMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** Gst::Pad - Object contained by elements that allows links to other
 * elements.
 * A Gst::Element is linked to other elements via "pads", which are extremely
 * light-weight generic link points. After two pads are retrieved from an
 * element with Element::get_pad(), the pads can be link with link(). (For
 * quick links, you can also use Element::link(), which will make the obvious
 * link for you if it's straightforward.)
 *
 * Pads are typically created from a Gst::PadTemplate with the create() method
 * that takes a Gst::PadTemplate.
 *
 * Pads have Gst::Caps attached to it to describe the media type they are
 * capable of dealing with. get_caps() and set_caps() are used to manipulate
 * the caps of the pads. Pads created from a pad template cannot set
 * capabilities that are incompatible with the pad template capabilities.
 *
 * Pads without pad templates can be created with create(), which takes a
 * direction and a name as an argument.
 *
 * get_parent_element() will retrieve the Gst::Element that owns the pad.
 *
 * A Gst::Element creating a pad will typically use the underlying C API to
 * register callbacks for various events on the pads.
 *
 * Elements will use push() and pull_range() to push out or pull in a buffer.
 *
 * To send a Gst::Event on a pad, use send_event() and push_event().
 *
 * Last reviewed on 2006-07-06 (0.10.9)
 */

class Pad : public Object 
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Pad CppObjectType;
  typedef Pad_Class CppClassType;
  typedef GstPad BaseObjectType;
  typedef GstPadClass BaseClassType;

private:  friend class Pad_Class;
  static CppClassType pad_class_;

private:
  // noncopyable
  Pad(const Pad&);
  Pad& operator=(const Pad&);

protected:
  explicit Pad(const Glib::ConstructParams& construct_params);
  explicit Pad(GstPad* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Pad();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstPad*       gobj()       { return reinterpret_cast<GstPad*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstPad* gobj() const { return reinterpret_cast<GstPad*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstPad* gobj_copy();

private:


protected:
  /** Constructs a Pad given a name and a direction.
   * @param name The desired name of the pad.
   * @param direction The desired direction of the pad.
   */
  explicit Pad(const Glib::ustring& name, PadDirection direction);

  /** Constructs a Pad given a direction without specifying a name.  A unique
   * name will be assigned to the pad.
   * @param direction the direction of the pad.
   */
  explicit Pad(PadDirection direction);

  /** Constructs a Pad from a PadTemplate with the specified name.
   * @param templ The PadTemplate.
   * @param name The desired name of the pad.
   * @throw std::runtime_error if construction fails.
   */
  Pad(const Glib::RefPtr<const Gst::PadTemplate>& templ,
    const Glib::ustring& name);

  /** Constructs a Pad from a PadTemplate without specifying a name.  A unique
   * name will ge assigned to the pad.
   * @param templ The PadTemplate.
   * @throw std::runtime_error if construction fails.
   */
  explicit Pad(const Glib::RefPtr<const Gst::PadTemplate>& templ);

public:
  /** For example,
   * void on_block(const Glib::RefPtr<Gst::Pad>& pad, bool blocked);.
   */
  typedef sigc::slot<void, const Glib::RefPtr<Gst::Pad>&, bool> SlotBlock;

  /** For example,
   * bool on_have_data(const Glib::RefPtr<Gst::Pad>& pad, const
   * Glib::RefPtr<Gst::MiniObjec>& data);.
   * The data method should return true to keep the data in the pipeline, false
   * to drop it (throw it away).
   */
  typedef sigc::slot< bool, const Glib::RefPtr<Gst::Pad>&, const Glib::RefPtr<Gst::MiniObject>& > SlotData;

  /** Creates a new pad with the given name in the given direction.
   *
   * @param name The name of the new pad.
   * @param direction The GstPadDirection of the pad.
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error. MT safe.
   */
  
  static Glib::RefPtr<Pad> create(const Glib::ustring& name, PadDirection dir);


  /** Creates a new pad with a guaranteed unique name (across all pads) in the
   * given direction.
   *
   * @param direction The GstPadDirection of the pad.
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error. MT safe.
   */
  
  static Glib::RefPtr<Pad> create(PadDirection dir);


  /** Creates a new pad with the given name from the given template.
   *
   * @param templ The pad template to use.
   * @param name The name of the element.
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error.
   * @throw std::runtime_error if construction fails.
   */
  
  static Glib::RefPtr<Pad> create(const Glib::RefPtr<const Gst::PadTemplate>& pad_template);


  /** Creates a new pad with a guaranteed unique name (across all pads) from
   * the given template.
   *
   * @param templ The pad template to use.
   * @return A new Gst::Pad, or a null RefPtr<> in case of an error.
   * @throw std::runtime_error if construction fails.
   */
  
  static Glib::RefPtr<Pad> create(const Glib::RefPtr<const Gst::PadTemplate>& pad_template, const Glib::ustring& name);


  /** Gets the direction of the pad. The direction of the pad is
   * decided at construction time so this function does not take
   * the LOCK.
   * @return The Gst::PadDirection of the pad.
   * 
   * MT safe.
   */
  PadDirection get_direction() const;
  
  /** Gets the parent of @a pad, cast to a Gst::Element. If a @a pad has no parent or
   * its parent is not an element, return <tt>0</tt>.
   * @return The parent of the pad. The caller has a reference on the parent, so
   * unref when you're finished with it.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Element> get_parent_element();
  
  /** Gets the parent of @a pad, cast to a Gst::Element. If a @a pad has no parent or
   * its parent is not an element, return <tt>0</tt>.
   * @return The parent of the pad. The caller has a reference on the parent, so
   * unref when you're finished with it.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Element> get_parent_element() const;
  
  /** Gets the template for @a pad.
   * @return The Gst::PadTemplate from which this pad was instantiated, or <tt>0</tt>
   * if this pad has no template.
   * 
   * FIXME: currently returns an unrefcounted padtemplate.
   */
  Glib::RefPtr<Gst::PadTemplate> get_pad_template();
  
  /** Gets the template for @a pad.
   * @return The Gst::PadTemplate from which this pad was instantiated, or <tt>0</tt>
   * if this pad has no template.
   * 
   * FIXME: currently returns an unrefcounted padtemplate.
   */
  Glib::RefPtr<const Gst::PadTemplate> get_pad_template() const;
  
  /** Links the source pad and the sink pad.
   * @param sinkpad The sink Gst::Pad to link.
   * @return A result code indicating if the connection worked or
   * what went wrong.
   * 
   * MT Safe.
   */
  PadLinkReturn link(const Glib::RefPtr<Gst::Pad>& sink_pad);
  
  /** Unlinks the source pad from the sink pad. Will emit the Gst::Pad::unlinked
   * signal on both pads.
   * @param sinkpad The sink Gst::Pad to unlink.
   * @return <tt>true</tt> if the pads were unlinked. This function returns <tt>false</tt> if
   * the pads were not linked together.
   * 
   * MT safe.
   */
  bool unlink(const Glib::RefPtr<Gst::Pad>& sink_pad);
  
  /** Checks if a @a pad is linked to another pad or not.
   * @return <tt>true</tt> if the pad is linked, <tt>false</tt> otherwise.
   * 
   * MT safe.
   */
  bool is_linked() const;
  
  /** Checks if the source pad and the sink pad are compatible so they can be
   * linked.
   * @param sinkpad The sink Gst::Pad.
   * @return <tt>true</tt> if the pads can be linked.
   */
  bool can_link(const Glib::RefPtr<const Gst::Pad>& other_pad) const;
  
  /** Gets the capabilities this pad can produce or consume.
   * Note that this method doesn't necessarily return the caps set by
   * set_caps() - use GST_PAD_CAPS() for that instead.
   * gst_pad_get_caps returns all possible caps a pad can operate with, using
   * the pad's get_caps function;
   * this returns the pad template caps if not explicitly set.
   * @return A newly allocated copy of the Gst::Caps of this pad.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Caps> get_caps();
  
  /** Gets the capabilities this pad can produce or consume.
   * Note that this method doesn't necessarily return the caps set by
   * set_caps() - use GST_PAD_CAPS() for that instead.
   * gst_pad_get_caps returns all possible caps a pad can operate with, using
   * the pad's get_caps function;
   * this returns the pad template caps if not explicitly set.
   * @return A newly allocated copy of the Gst::Caps of this pad.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Caps> get_caps() const;
  
  /** Gets the capabilities of the allowed media types that can flow through
   *  @a pad and its peer.
   * 
   * The allowed capabilities is calculated as the intersection of the results of
   * calling get_caps() on @a pad and its peer. The caller owns a reference
   * on the resulting caps.
   * @return The allowed Gst::Caps of the pad link. Unref the caps when you no
   * longer need it. This function returns <tt>0</tt> when @a pad has no peer.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Caps> get_allowed_caps();
  
  /** Gets the capabilities of the allowed media types that can flow through
   *  @a pad and its peer.
   * 
   * The allowed capabilities is calculated as the intersection of the results of
   * calling get_caps() on @a pad and its peer. The caller owns a reference
   * on the resulting caps.
   * @return The allowed Gst::Caps of the pad link. Unref the caps when you no
   * longer need it. This function returns <tt>0</tt> when @a pad has no peer.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Caps> get_allowed_caps() const;
  
  /** Gets the capabilities of the media type that currently flows through @a pad
   * and its peer.
   * 
   * This function can be used on both src and sinkpads. Note that srcpads are
   * always negotiated before sinkpads so it is possible that the negotiated caps
   * on the srcpad do not match the negotiated caps of the peer.
   * @return The negotiated Gst::Caps of the pad link.  Unref the caps when
   * you no longer need it. This function returns <tt>0</tt> when the @a pad has no
   * peer or is not negotiated yet.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Caps> get_negotiated_caps();
  
  /** Gets the capabilities of the media type that currently flows through @a pad
   * and its peer.
   * 
   * This function can be used on both src and sinkpads. Note that srcpads are
   * always negotiated before sinkpads so it is possible that the negotiated caps
   * on the srcpad do not match the negotiated caps of the peer.
   * @return The negotiated Gst::Caps of the pad link.  Unref the caps when
   * you no longer need it. This function returns <tt>0</tt> when the @a pad has no
   * peer or is not negotiated yet.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Caps> get_negotiated_caps() const;

  //The documentation gst_pad_get_pad_template_caps() suggests that there shouldn't be a non-const return:
  /** Gets the capabilities for pad's template.
   *
   * @return The Gst::Caps of this pad template.
   */
  Glib::RefPtr<const Gst::Caps> get_pad_template_caps() const;
  

  /** Sets the capabilities of this pad. The caps must be fixed. Any previous
   * caps on the pad will be unreffed. This function refs the caps so you should
   * unref if as soon as you don't need it anymore.
   * It is possible to set <tt>0</tt> caps, which will make the pad unnegotiated
   * again.
   * @param caps A Gst::Caps to set.
   * @return <tt>true</tt> if the caps could be set. <tt>false</tt> if the caps were not fixed
   * or bad parameters were provided to this function.
   * 
   * MT safe.
   */
  bool set_caps(const Glib::RefPtr<Gst::Caps>& caps);
  
  /** Gets the peer of @a pad. This function refs the peer pad so
   * you need to unref it after use.
   * @return The peer Gst::Pad. Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Gst::Pad> get_peer();
  
  /** Gets the peer of @a pad. This function refs the peer pad so
   * you need to unref it after use.
   * @return The peer Gst::Pad. Unref after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Gst::Pad> get_peer() const;
  
  /** Gets the capabilities of the peer connected to this pad.
   * @return The Gst::Caps of the peer pad. This function returns a new caps, so
   * use gst_caps_unref to get rid of it. this function returns <tt>0</tt> if there is
   * no peer pad.
   */
  Glib::RefPtr<Gst::Caps> peer_get_caps();
  
  /** Gets the capabilities of the peer connected to this pad.
   * @return The Gst::Caps of the peer pad. This function returns a new caps, so
   * use gst_caps_unref to get rid of it. this function returns <tt>0</tt> if there is
   * no peer pad.
   */
  Glib::RefPtr<const Gst::Caps> peer_get_caps() const;
  
  /** A helper function you can use that sets the
   *  @a gst_pad_get_fixed_caps_func as the getcaps function for the
   * pad. This way the function will always return the negotiated caps
   * or in case the pad is not negotiated, the padtemplate caps.
   * 
   * Use this function on a pad that, once _set_caps() has been called
   * on it, cannot be renegotiated to something else.
   */
  void use_fixed_caps();
  
  /** Query if a pad is active
   * @return <tt>true</tt> if the pad is active.
   * 
   * MT safe.
   */
  bool is_active() const;
  
  /** Blocks or unblocks the dataflow on a pad. This function is
   * a shortcut for set_blocked_async() with a <tt>0</tt>
   * callback.
   * @param blocked Boolean indicating we should block or unblock.
   * @return <tt>true</tt> if the pad could be blocked. This function can fail if the
   * wrong parameters were passed or the pad was already in the requested state.
   * 
   * MT safe.
   */
  bool set_blocked(bool blocked = true);

  /** Blocks or unblocks the dataflow on a pad asynchronously. The provided
   * slot is called when the operation succeeds; this happens right before the
   * next attempt at pushing a buffer on the pad.
   *
   * This can take a while as the pad can only become blocked when real
   * dataflow is happening. When the pipeline is stalled, for example in
   * PAUSED, this can take an indeterminate amount of time. Be careful with
   * this blocking call as it might not return for reasons stated above.
   *
   * @param slot SlotBlock that will be called when the operation succeeds.
   * @param blocked boolean indicating whether the pad should be blocked or
   * unblocked.
   * @return true if the pad could be blocked. This function can fail if the
   * pad was already in the requested state. MT safe.
   */
  bool set_blocked_async(const SlotBlock& slot, bool blocked = true);
  

  /** Checks if the pad is blocked or not. This function returns the
   * last requested state of the pad. It is not certain that the pad
   * is actually blocking at this point (see is_blocking()).
   * @return <tt>true</tt> if the pad is blocked.
   * 
   * MT safe.
   */
  bool is_blocked() const;
  
  /** Checks if the pad is blocking or not. This is a guaranteed state
   * of whether the pad is actually blocking on a Gst::Buffer or a Gst::Event.
   * @return <tt>true</tt> if the pad is blocking.
   * 
   * MT safe.
   * 
   * @newin{0,10}.11.
   */
  bool is_blocking() const;

  /** Adds a "data probe" to a pad. The slot will be called whenever data
   * passes through a pad. In this case data means both events and buffers. The
   * probe will be called with the data as an argument. Note that the data will
   * have a reference count greater than 1, so it will be immutable -- you must
   * not change it.
   *
   * For source pads, the probe will be called after the blocking function, if
   * any (see set_blocked_async()), but before looking up the peer to chain to.
   * For sink pads, the probe function will be called before configuring the
   * sink with new caps, if any, and before calling the pad's chain function.
   *
   * Your data probe should return true to let the data continue to flow, or
   * false to drop it. Dropping data is rarely useful, but occasionally comes
   * in handy with events.
   *
   * To remove a probe, use the appropriate function, such as
   * remove_data_probe().
   *
   * @param slot The slot to call when data is passed over pad (note: slot is
   * not copied because it is connected to a signal).
   * @return The handler id which may be used to remove the connection later.
   */
  gulong add_data_probe(const SlotData& slot);
  

  /** Adds a probe that will be called for all buffers passing through a pad.
   * See add_data_probe() for more information.
   *
   * @param slot The slot to call when buffers are passed over pad.
   * @return The handler id.
   */
  gulong add_buffer_probe(const SlotData& slot);
  

  /** Adds a probe that will be called for all events passing through a pad.
   * See add_data_probe() for more information.
   *
   * @param slot The slot to call when events are passed over pad.
   * @return The handler id.
   */
  gulong add_event_probe(const SlotData& slot);
  

  /** Removes a data probe from @a pad.
   * @param handler_id Handler id returned from gst_pad_add_data_probe.
   */
  void remove_data_probe(guint handler_id);
  
  /** Removes a buffer probe from @a pad.
   * @param handler_id Handler id returned from gst_pad_add_buffer_probe.
   */
  void remove_buffer_probe(guint handler_id);
  
  /** Removes an event probe from @a pad.
   * @param handler_id Handler id returned from gst_pad_add_event_probe.
   */
  void remove_event_probe(guint handler_id);

  //This is handwritten because conversion from Glib::RefPtr<Gst::Buffer>& to
  //GstBuffer** is difficult.
  /** Allocates a new, empty buffer optimized to push to pad pad. This function
   * only works if pad is a source pad and has a peer.
   *
   * A new, empty Gst::Buffer will be put in the buf argument. You need to
   * check the caps of the buffer after performing this function and
   * renegotiate to the format if needed.
   *
   * @param offset The offset of the new buffer in the stream.
   * @param size The size of the new buffer.
   * @param caps The caps of the new buffer.
   * @param buf An uninitialized Glib::RefPtr<> in which to store the new
   * Gst::Buffer.
   * @return A result code indicating success of the operation. Any result code
   * other than Gst::FLOW_OK is an error and buf should not be used. An error
   * can occur if the pad is not connected or when the downstream peer elements
   * cannot provide an acceptable buffer. MT safe.
   */
  FlowReturn alloc_buffer(guint64 offset, int size, const Glib::RefPtr<Gst::Caps>& caps, Glib::RefPtr<Gst::Buffer>& buf);
  

  //This is handwritten because conversion from Glib::RefPtr<Gst::Buffer>& to
  //GstBuffer** is difficult.
  /** In addition to the function alloc_buffer(), this function automatically
   * calls set_caps() when the caps of the newly allocated buffer are different
   * from the pad caps.  Again, the pad must be a source pad.
   *
   * @param offset The offset of the new buffer in the stream.
   * @param size The size of the new buffer.
   * @param caps The caps of the new buffer.
   * @param buf An uninitialized Glib::RefPtr<> in which to store the new
   * Gst::Buffer.
   * @return A result code indicating success of the operation. Any result code
   * other than Gst::FLOW_OK is an error and buf should not be used. An error
   * can occur if the pad is not connected or when the downstream peer elements
   * cannot provide an acceptable buffer. MT safe.
   */
  FlowReturn alloc_buffer_and_set_caps(guint64 offset, int size, const Glib::RefPtr<Gst::Caps>& caps, Glib::RefPtr<Gst::Buffer>& buf);
  

  //This is handwritten because conversion from Glib::RefPtr<Gst::Buffer>& to
  //GstBuffer** is difficult.
  /** When pad is flushing this function returns Gst::FLOW_WRONG_STATE
   * immediatly.  Calls the getrange function of pad.  If pad has no getrange
   * function installed this function returns Gst::FLOW_NOT_SUPPORTED.
   *
   * This is a lowlevel function. Usually pull_range() is used.  This function
   * is designed to be used with a source pad only.
   *
   * @param offset The start offset of the buffer.
   * @param size The length of the buffer.
   * @param buffer An unitialized Glib::RefPtr<> in which to store the
   * Gst::Buffer.
   * @return A Gst::FlowReturn from the pad (Gst::FLOW_NOT_SUPPORTED if pad is
   * not a source pad). MT safe.
   */
  FlowReturn get_range(guint64 offset, guint size, Glib::RefPtr<Gst::Buffer>& buffer);
  

  /** Check if the given pad accepts the caps.
   * @param caps A Gst::Caps to check on the pad.
   * @return <tt>true</tt> if the pad can accept the caps.
   */
  bool accept_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;
  
  /** Calls get_allowed_caps() for every other pad belonging to the
   * same element as @a pad, and returns the intersection of the results.
   * 
   * This function is useful as a default getcaps function for an element
   * that can handle any stream format, but requires all its pads to have
   * the same caps.  Two such elements are tee and aggregator.
   * @return The intersection of the other pads' allowed caps.
   */
  Glib::RefPtr<Gst::Caps> proxy_getcaps();
  
  /** Calls get_allowed_caps() for every other pad belonging to the
   * same element as @a pad, and returns the intersection of the results.
   * 
   * This function is useful as a default getcaps function for an element
   * that can handle any stream format, but requires all its pads to have
   * the same caps.  Two such elements are tee and aggregator.
   * @return The intersection of the other pads' allowed caps.
   */
  Glib::RefPtr<const Gst::Caps> proxy_getcaps() const;
  
  /** Calls set_caps() for every other pad belonging to the
   * same element as @a pad.  If set_caps() fails on any pad,
   * the proxy setcaps fails. May be used only during negotiation.
   * @param caps The Gst::Caps to link with.
   * @return <tt>true</tt> if sucessful.
   */
  bool proxy_setcaps(const Glib::RefPtr<Gst::Caps>& caps);
  
  /** Fixate a caps on the given pad. Modifies the caps in place, so you should
   * make sure that the caps are actually writable (see gst_caps_make_writable()).
   * @param caps The  Gst::Caps to fixate.
   */
  void fixate_caps(const Glib::RefPtr<Gst::Caps>& caps);
  
  /** Check if the peer of @a pad accepts @a caps. If @a pad has no peer, this function
   * Returns: <tt>true</tt> if the peer of @a pad can accept the caps or @a pad has no peer.
   * @param caps A Gst::Caps to check on the pad.
   * @return <tt>true</tt> if the peer of @a pad can accept the caps or @a pad has no peer.
   */
  bool peer_accept_caps(const Glib::RefPtr<const Gst::Caps>& caps) const;

  // This method is written manually because an extra ref is necessary
  /** Pushes a buffer to the peer of the pad. The pad must be a source pad,
   * otherwise this method returns Gst::FLOW_ERROR.
   *
   * This function will call an installed pad block before triggering any
   * installed pad probes.
   *
   * If the caps on buffer are different from the currently configured caps on
   * pad, this function will call any installed setcaps function on pad (see
   * the C API gst_pad_set_setcaps_function()). In case of failure to
   * renegotiate the new format, this function returns
   * Gst::FLOW_NOT_NEGOTIATED.
   *
   * The function proceeds calling chain() on the peer pad and returns the
   * value from that function. If pad has no peer, Gst::FLOW_NOT_LINKED will
   * be returned.
   *
   * @param buffer The Gst::Buffer to push.
   * @return A Gst::FlowReturn from the peer pad. MT safe.
   */
  FlowReturn push(const Glib::RefPtr<Gst::Buffer>& buffer);
  

  // This method is written manually because an extra ref is necessary
  /** Sends the event to the peer of the pad. This function is mainly used by
   * elements to send events to their peer elements.
   *
   * @param event The GstEvent to send to the pad.
   * @return true if the event was handled. MT safe.
   */
  bool push_event(const Glib::RefPtr<Gst::Event>& event);
  

  /** Checks if a pull_range() can be performed on the peer
   * source pad. This function is used by plugins that want to check
   * if they can use random access on the peer source pad.
   * 
   * The peer sourcepad can implement a custom Gst::PadCheckGetRangeFunction
   * if it needs to perform some logic to determine if pull_range is
   * possible.
   * @return A <tt>bool</tt> with the result.
   * 
   * MT safe.
   */
  bool check_pull_range() const;

  /** Pulls a buffer from the peer pad.  This function will first trigger the
   * pad block signal if it was installed.  This method works only on sink
   * pads.
   *
   * When pad is not linked Gst::FLOW_NOT_LINKED is returned else this function
   * returns the result of get_range() on the peer pad.
   *
   * @a buffer's caps must either be unset or the same as what is already
   * configured on pad. Renegotiation within a running pull-mode pipeline is
   * not supported.
   *
   * @param offset The start offset of the buffer.
   * @param size The length of the buffer.
   * @param buffer An uninitialized Glib::RefPtr<> in which to hold the
   * Gst::Buffer.
   * @return A Gst::FlowReturn from the peer pad (Gst::FLOW_ERROR if pad is not
   * a sink pad). When this function returns Gst::FLOW_OK, buffer will contain
   * a valid Gst::Buffer. @a buffer may not be used when any other return value
   * than Gst::FLOW_OK is returned. MT safe.
   */
  FlowReturn pull_range(guint64 offset, guint size, Glib::RefPtr<Gst::Buffer>& buffer);
  

  /** Activates or deactivates the given pad in pull mode via dispatching to the
   * pad's activatepullfunc. For use from within pad activation functions only.
   * When called on sink pads, will first proxy the call to the peer pad, which
   * is expected to activate its internally linked pads from within its
   * activate_pull function.
   * 
   * If you don't know what this is, you probably don't want to call it.
   * @param active Whether or not the pad should be active.
   * @return <tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool activate_pull(bool active = true);
  
  /** Activates or deactivates the given pad in push mode via dispatching to the
   * pad's activatepushfunc. For use from within pad activation functions only.
   * 
   * If you don't know what this is, you probably don't want to call it.
   * @param active Whether the pad should be active or not.
   * @return <tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool activate_push(bool active = true);

  // This method is written manually because an extra ref is necessary
  /** Sends the event to the pad. This function can be used by applications to
   * send events in the pipeline.
   *
   * If the pad is a source pad, event should be an upstream event. If the pad
   * is a sink pad, the event should be a downstream event. For example, you
   * would not send a Gst::EVENT_EOS on a src pad; EOS events only propagate
   * downstream.  Furthermore, some downstream events have to be serialized
   * with data flow, like EOS, while some can travel out-of-band, like
   * Gst::EVENT_FLUSH_START.  If the event needs to be serialized with data
   * flow, this function will take the pad's stream lock while calling its
   * event function.
   *
   * To find out whether an event type is upstream, downstream, or downstream
   * and serialized, see Gst::EventTypeFlags, Gst::Enums::get_flags(),
   * is_upstream(), Gst::Event::is_downstream(), and
   * Gst::Event::is_serialized(). Note that in practice that an application or
   * plugin doesn't need to bother itself with this information; the core
   * handles all necessary locks and checks.
   *
   * @param event The Gst::Event to send to the pad.
   * @return true if the event was handled. 
   */
  bool send_event(const Glib::RefPtr<Gst::Event>& event);
  

  /** Invokes the default event handler for the given pad. End-of-stream and
   * discontinuity events are handled specially, and then the event is sent to all
   * pads internally linked to @a pad. Note that if there are many possible sink
   * pads that are internally linked to @a pad, only one will be sent an event.
   * Multi-sinkpad elements should implement custom event handlers.
   * @param event The Gst::Event to handle.
   * @return <tt>true</tt> if the event was sent succesfully.
   */
  bool event_default(const Glib::RefPtr<Gst::Event>& event);
  
  /** Dispatches a query to a pad. The query should have been allocated by the
   * caller via one of the type-specific allocation functions in gstquery.h. The
   * element is responsible for filling the query with an appropriate response,
   * which should then be parsed with a type-specific query parsing function.
   * 
   * Again, the caller is responsible for both the allocation and deallocation of
   * the query structure.
   * @param query The Gst::Query to perform.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query(const Glib::RefPtr<Gst::Query>& query) const;
  
  /** Performs query() on the peer of @a pad.
   * 
   * The caller is responsible for both the allocation and deallocation of
   * the query structure.
   * @param query The Gst::Query to perform.
   * @return <tt>true</tt> if the query could be performed. This function returns <tt>false</tt>
   * if @a pad has no peer.
   * 
   * @newin{0,10}.15.
   */
  bool peer_query(const Glib::RefPtr<Gst::Query>& query) const;
  
  /** Invokes the default query handler for the given pad.
   * The query is sent to all pads internally linked to @a pad. Note that
   * if there are many possible sink pads that are internally linked to
   *  @a pad, only one will be sent the query.
   * Multi-sinkpad elements should implement custom query handlers.
   * @param query The Gst::Query to handle.
   * @return <tt>true</tt> if the query was performed succesfully.
   */
  bool query_default(const Glib::RefPtr<Gst::Query>& query) const;
  
  /** Queries a pad for the stream position.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param cur A location in which to store the current position, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_position(Format& format, gint64& position) const;

  /** Queries a pad for the stream position parsing only the format.
   * @param format A reference to the Gst::Format asked for. On return contains
   * the Gst::Format used.
   * @return true if the query could be performed.
   */
  bool query_position(Format& format) const;

  
  /** Queries a pad for the total stream duration.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param duration A location in which to store the total duration, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_duration(Format& format, gint64& duration) const;

  /** Queries a pad for the total stream duration parsing only the format.
   * @param format A reference to the Gst::Format asked for. On return contains
   * the GstFormat used.
   * @return true if the query could be performed.
   */
  bool query_duration(Format& format) const;

  
  /** Queries a pad to convert @a src_val in @a src_format to @a dest_format.
   * @param src_format A Gst::Format to convert from.
   * @param src_val A value to convert.
   * @param dest_format A pointer to the Gst::Format to convert to.
   * @param dest_val A pointer to the result.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_convert(Format src_format, gint64 src_value, Format& dst_format, gint64& dst_value) const;
  
  /** Queries the peer of a given sink pad for the stream position.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param cur A location in which to store the current position, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_peer_position(Format& format, gint64& position) const;

  /** Queries the peer of a given sink pad for the stream position parsing only
   * the format.
   * @param format A reference to the Gst::Format asked for. On return contains
   * the Gst::Format used.
   * @return true if the query could be performed.
   */
  bool query_peer_position(Format& format) const;

   
  /** Queries the peer pad of a given sink pad for the total stream duration.
   * @param format A pointer to the Gst::Format asked for.
   * On return contains the Gst::Format used.
   * @param duration A location in which to store the total duration, or <tt>0</tt>.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_peer_duration(Format& format, gint64& duration) const;

  /** Queries the peer pad of a given sink pad for the total stream duration.
   * @param format A reference to the Gst::Format asked for. On return contains
   * the Gst::Format used.
   * @return true if the query could be performed.
   */
  bool query_peer_duration(Format& format) const;

   
  /** Queries the peer pad of a given sink pad to convert @a src_val in @a src_format
   * to @a dest_format.
   * @param src_format A Gst::Format to convert from.
   * @param src_val A value to convert.
   * @param dest_format A pointer to the Gst::Format to convert to.
   * @param dest_val A pointer to the result.
   * @return <tt>true</tt> if the query could be performed.
   */
  bool query_peer_convert(Format src_format, gint64 src_value, Format& dst_format, gint64& dst_value) const;

 
  /** Get an array of supported queries that can be performed
   * on this pad.
   * @return A zero-terminated array of Gst::QueryType.
   */
  Glib::ArrayHandle<QueryType> get_query_types() const;
  
  /** Invoke the default dispatcher for the query types on
   * the pad.
   * @return An zero-terminated array of Gst::QueryType, or <tt>0</tt> if none of the
   * internally-linked pads has a query types function.
   */
  Glib::ArrayHandle<QueryType> get_query_types_default() const;

  
  /** Gets an iterator for the pads to which the given pad is linked to inside
   * of the parent element.
   * 
   * Each Gst::Pad element yielded by the iterator will have its refcount increased,
   * so unref after use.
   * @return A new Gst::Iterator of Gst::Pad or <tt>0</tt> when the pad does not have an
   * iterator function configured. Use gst_iterator_free() after usage.
   * 
   * @newin{0,10}.21.
   */
  Gst::Iterator<Gst::Pad> iterate_internal_links();
  
  /** Gets an iterator for the pads to which the given pad is linked to inside
   * of the parent element.
   * 
   * Each Gst::Pad element yielded by the iterator will have its refcount increased,
   * so unref after use.
   * @return A new Gst::Iterator of Gst::Pad or <tt>0</tt> when the pad does not have an
   * iterator function configured. Use gst_iterator_free() after usage.
   * 
   * @newin{0,10}.21.
   */
  Gst::Iterator<const Gst::Pad> iterate_internal_links() const;
  
  /** Iterate the list of pads to which the given pad is linked to inside of
   * the parent element.
   * This is the default handler, and thus returns an iterator of all of the
   * pads inside the parent element with opposite direction.
   * 
   * The caller must free this iterator after use with gst_iterator_free().
   * @return A Gst::Iterator of Gst::Pad, or <tt>0</tt> if @a pad has no parent. Unref each
   * returned pad with Gst::Object::unref().
   * 
   * @newin{0,10}.21.
   */
  Gst::Iterator<Gst::Pad> iterate_internal_links_default();
  
  /** Iterate the list of pads to which the given pad is linked to inside of
   * the parent element.
   * This is the default handler, and thus returns an iterator of all of the
   * pads inside the parent element with opposite direction.
   * 
   * The caller must free this iterator after use with gst_iterator_free().
   * @return A Gst::Iterator of Gst::Pad, or <tt>0</tt> if @a pad has no parent. Unref each
   * returned pad with Gst::Object::unref().
   * 
   * @newin{0,10}.21.
   */
  Gst::Iterator<const Gst::Pad> iterate_internal_links_default() const;

 
  /** Gets a list of pads to which the given pad is linked to
   * inside of the parent element.
   * The caller must free this list after use.
   * 
   * Not MT safe.
   * @return A newly allocated List of pads, free with Glib::list_free().
   * 
   * Deprecated: This function does not ref the pads in the list so that they
   * could become invalid by the time the application accesses them. It's also
   * possible that the list changes while handling the pads, which the caller of
   * this function is unable to know. Use the thread-safe 
   * iterate_internal_links() instead.
   */
  Glib::ListHandle< Glib::RefPtr<Gst::Pad> > get_internal_links();

 
  /** Gets a list of pads to which the given pad is linked to
   * inside of the parent element.
   * The caller must free this list after use.
   * 
   * Not MT safe.
   * @return A newly allocated List of pads, free with Glib::list_free().
   * 
   * Deprecated: This function does not ref the pads in the list so that they
   * could become invalid by the time the application accesses them. It's also
   * possible that the list changes while handling the pads, which the caller of
   * this function is unable to know. Use the thread-safe 
   * iterate_internal_links() instead.
   */
  Glib::ListHandle< Glib::RefPtr<const Gst::Pad> > get_internal_links() const;

  
  /** Gets a list of pads to which the given pad is linked to
   * inside of the parent element.
   * This is the default handler, and thus returns a list of all of the
   * pads inside the parent element with opposite direction.
   * 
   * The caller must free this list after use with Glib::list_free().
   * @return A newly allocated List of pads, or <tt>0</tt> if the pad has no parent.
   * 
   * Not MT safe.
   * 
   * Deprecated: This function does not ref the pads in the list so that they
   * could become invalid by the time the application accesses them. It's also
   * possible that the list changes while handling the pads, which the caller of
   * this function is unable to know. Use the thread-safe 
   * iterate_internal_links_default() instead.
   */
  Glib::ListHandle< Glib::RefPtr<Gst::Pad> > get_internal_links_default();
  
  /** Gets a list of pads to which the given pad is linked to
   * inside of the parent element.
   * This is the default handler, and thus returns a list of all of the
   * pads inside the parent element with opposite direction.
   * 
   * The caller must free this list after use with Glib::list_free().
   * @return A newly allocated List of pads, or <tt>0</tt> if the pad has no parent.
   * 
   * Not MT safe.
   * 
   * Deprecated: This function does not ref the pads in the list so that they
   * could become invalid by the time the application accesses them. It's also
   * possible that the list changes while handling the pads, which the caller of
   * this function is unable to know. Use the thread-safe 
   * iterate_internal_links_default() instead.
   */
  Glib::ListHandle< Glib::RefPtr<const Gst::Pad> > get_internal_links_default() const;

  // This method is written manually because an extra ref is necessary
  FlowReturn chain(const Glib::RefPtr<Gst::Buffer>& buffer);
  

  /** Pause the task of @a pad. This function will also wait until the
   * function executed by the task is finished if this function is not
   * called from the task function.
   * @return A <tt>true</tt> if the task could be paused or <tt>false</tt> when the pad
   * has no task.
   */
  bool pause_task() ;
  
  /** Stop the task of @a pad. This function will also make sure that the
   * function executed by the task will effectively stop if not called
   * from the GstTaskFunction.
   * 
   * This function will deadlock if called from the GstTaskFunction of
   * the task. Use Gst::Task::pause() instead.
   * 
   * Regardless of whether the pad has a task, the stream lock is acquired and
   * released so as to ensure that streaming through this pad has finished.
   * @return A <tt>true</tt> if the task could be stopped or <tt>false</tt> on error.
   */
  bool stop_task() ;
  
  /** Activates or deactivates the given pad.
   * Normally called from within core state change functions.
   * 
   * If @a active, makes sure the pad is active. If it is already active, either in
   * push or pull mode, just return. Otherwise dispatches to the pad's activate
   * function to perform the actual activation.
   * 
   * If not @a active, checks the pad's current mode and calls
   * activate_push() or activate_pull(), as appropriate, with a
   * <tt>false</tt> argument.
   * @param active Whether or not the pad should be active.
   * @return #<tt>true</tt> if the operation was successful.
   * 
   * MT safe.
   */
  bool set_active(bool active = true);

    //C API specific pad callback setting functions are ignored.
    

  //C API helper function gst_pad_get_fixed_caps_func ignored.
  

  //The "have-data" signal never really emits so ignore it.  Adding data, event
  //and buffer probes do emit.
  

  /** Signals that a pad has been linked to the peer pad.
   *
   * @par Prototype:
   * <tt>void on_my_%linked(const Glib::RefPtr<Gst::Pad>& peer_pad)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& > signal_linked();


  /** Signals that a pad connection has been requested.
   *
   * @par Prototype:
   * <tt>void on_my_%request_link()</tt>
   */

  Glib::SignalProxy0< void > signal_request_link();


  /** Signals that a pad has been unlinked from the peer pad.
   *
   * @par Prototype:
   * <tt>void on_my_%unlinked(const Glib::RefPtr<Gst::Pad>& peer_pad)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gst::Pad>& > signal_unlinked();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The capabilities of the pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gst::Caps> > property_caps() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The direction of the pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PadDirection> property_direction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GstPadTemplate of this pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PadTemplate> property_template() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GstPadTemplate of this pad.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PadTemplate> property_template() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_linked(const Glib::RefPtr<Gst::Pad>& peer_pad);
  virtual void on_request_link();
  virtual void on_unlinked(const Glib::RefPtr<Gst::Pad>& peer_pad);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Pad
   */
  Glib::RefPtr<Gst::Pad> wrap(GstPad* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_PAD_H */

